/// <reference path="./internals/internal_*.d.ts" />
declare class BlockPos extends Vec3i {
    constructor($$0: Vec3i_)
    constructor($$0: number, $$1: number, $$2: number)
    mutable(): Internal.BlockPos$MutableBlockPos;
    south(): this;
    above(): this;
    offset($$0: number, $$1: number, $$2: number): this;
    offset($$0: Vec3i_): this;
    static betweenClosed($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): Internal.Iterable<BlockPos>;
    static getY($$0: number): number;
    static betweenClosedStream($$0: BlockPos_, $$1: BlockPos_): Internal.Stream<BlockPos>;
    multiply($$0: number): this;
    static offset($$0: number, $$1: number, $$2: number, $$3: number): number;
    asLong(): number;
    west(): this;
    static spiralAround($$0: BlockPos_, $$1: number, $$2: Internal.Direction_, $$3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    west(distance: number): this;
    below(distance: number): this;
    south(distance: number): this;
    static betweenClosedStream($$0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    relative($$0: Internal.Direction_): this;
    static randomInCube($$0: Internal.RandomSource_, $$1: number, $$2: BlockPos_, $$3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal($$0: BlockPos_, $$1: number, $$2: number, $$3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, $$4: Internal.Predicate_<BlockPos>): number;
    static betweenClosed($$0: BlockPos_, $$1: BlockPos_): Internal.Iterable<BlockPos>;
    getCenter(): Vec3d;
    static offset($$0: number, $$1: Internal.Direction_): number;
    static containing($$0: Internal.Position_): BlockPos;
    east(distance: number): this;
    cross($$0: Vec3i_): this;
    above(distance: number): this;
    static getX($$0: number): number;
    east(): this;
    below(): this;
    static getZ($$0: number): number;
    static findClosestMatch($$0: BlockPos_, $$1: number, $$2: number, $$3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    north(distance: number): this;
    atY($$0: number): this;
    rotate($$0: Internal.Rotation_): this;
    relative($$0: Internal.Direction_, $$1: number): this;
    static betweenClosedStream($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): Internal.Stream<BlockPos>;
    static randomBetweenClosed($$0: Internal.RandomSource_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): Internal.Iterable<BlockPos>;
    north(): this;
    static withinManhattanStream($$0: BlockPos_, $$1: number, $$2: number, $$3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    static asLong($$0: number, $$1: number, $$2: number): number;
    static getFlatIndex($$0: number): number;
    static of($$0: number): BlockPos;
    /**
     * @deprecated
    */
    static squareOutSouthEast($$0: BlockPos_): Internal.Stream<BlockPos>;
    static withinManhattan($$0: BlockPos_, $$1: number, $$2: number, $$3: number): Internal.Iterable<BlockPos>;
    static containing($$0: number, $$1: number, $$2: number): BlockPos;
    static betweenClosedStream($$0: Internal.AABB_): Internal.Stream<BlockPos>;
    relative($$0: Internal.Direction$Axis_, $$1: number): this;
    subtract($$0: Vec3i_): this;
    get center(): Vec3d
    static readonly PACKED_Y_LENGTH: 12;
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: BlockPos;
}
type BlockPos_ = [number, number, number] | BlockPos | any_;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor($$0: number, $$1: number, $$2: number)
    constructor($$0: Vec3f_)
    horizontalDistance(): number;
    normalize(): this;
    get($$0: Internal.Direction$Axis_): number;
    lerp($$0: Vec3d_, $$1: number): this;
    lengthSqr(): number;
    distanceToSqr($$0: Vec3d_): number;
    relative($$0: Internal.Direction_, $$1: number): this;
    add($$0: number, $$1: number, $$2: number): this;
    static atCenterOf($$0: Vec3i_): Vec3d;
    static directionFromRotation($$0: Internal.Vec2_): Vec3d;
    cross($$0: Vec3d_): this;
    add($$0: Vec3d_): this;
    yRot($$0: number): this;
    z(): number;
    "with"($$0: Internal.Direction$Axis_, $$1: number): this;
    static atBottomCenterOf($$0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    xRot($$0: number): this;
    dot($$0: Vec3d_): number;
    multiply($$0: number, $$1: number, $$2: number): this;
    y(): number;
    x(): number;
    align($$0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    closerThan($$0: Internal.Position_, $$1: number): boolean;
    offsetRandom($$0: Internal.RandomSource_, $$1: number): this;
    vectorTo($$0: Vec3d_): this;
    static atLowerCornerWithOffset($$0: Vec3i_, $$1: number, $$2: number, $$3: number): Vec3d;
    static atLowerCornerOf($$0: Vec3i_): Vec3d;
    static fromRGB24($$0: number): Vec3d;
    subtract($$0: Vec3d_): this;
    multiply($$0: Vec3d_): this;
    distanceTo($$0: Vec3d_): number;
    static upFromBottomCenterOf($$0: Vec3i_, $$1: number): Vec3d;
    reverse(): this;
    scale($$0: number): this;
    toVector3f(): Vec3f;
    length(): number;
    distanceToSqr($$0: number, $$1: number, $$2: number): number;
    static directionFromRotation($$0: number, $$1: number): Vec3d;
    subtract($$0: number, $$1: number, $$2: number): this;
    zRot($$0: number): this;
    readonly z: number;
    static readonly ZERO: Vec3d;
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static values(): RotationAxis[];
    rad(f: number): Quaternionf;
    static valueOf(name: string): RotationAxis;
    static readonly XN: RotationAxis;
    static readonly ZP: RotationAxis;
    static readonly YN: RotationAxis;
    static readonly XP: RotationAxis;
    static readonly YP: RotationAxis;
    static readonly ZN: RotationAxis;
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation>, Internal.ResourceLocationExtensions {
    constructor($$0: string, $$1: string)
    constructor($$0: string)
    static isValidNamespace($$0: string): boolean;
    compareTo($$0: ResourceLocation_): number;
    toLanguageKey($$0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static read($$0: string): Internal.DataResult<ResourceLocation>;
    toShortLanguageKey(): string;
    static isValidPath($$0: string): boolean;
    compareTo(arg0: any): number;
    setPath(arg0: string): void;
    static tryBuild($$0: string, $$1: string): ResourceLocation;
    static isAllowedInResourceLocation($$0: string): boolean;
    static tryParse($$0: string): ResourceLocation;
    withPath($$0: string): this;
    static validPathChar($$0: string): boolean;
    toLanguageKey($$0: string, $$1: string): string;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    compareNamespaced(o: ResourceLocation_): number;
    static of($$0: string, $$1: string): ResourceLocation;
    withSuffix($$0: string): this;
    specialEquals(o: any, shallow: boolean): boolean;
    static read($$0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation($$0: string): boolean;
    setNamespace(arg0: string): void;
    withPath($$0: Internal.UnaryOperator_<string>): this;
    withPrefix($$0: string): this;
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: "realms";
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: ":";
    static readonly DEFAULT_NAMESPACE: "minecraft";
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class any {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
}
type any_ = any;
declare class Stats {
    constructor()
    static readonly SWIM_ONE_CM: ResourceLocation;
    static readonly FLY_ONE_CM: ResourceLocation;
    static readonly CLEAN_SHULKER_BOX: ResourceLocation;
    static readonly TOTAL_WORLD_TIME: ResourceLocation;
    static readonly TUNE_NOTEBLOCK: ResourceLocation;
    static readonly DAMAGE_RESISTED: ResourceLocation;
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: ResourceLocation;
    static readonly INTERACT_WITH_BREWINGSTAND: ResourceLocation;
    static readonly INTERACT_WITH_CAMPFIRE: ResourceLocation;
    static readonly INSPECT_DISPENSER: ResourceLocation;
    static readonly INTERACT_WITH_FURNACE: ResourceLocation;
    static readonly OPEN_ENDERCHEST: ResourceLocation;
    static readonly ANIMALS_BRED: ResourceLocation;
    static readonly POT_FLOWER: ResourceLocation;
    static readonly INTERACT_WITH_STONECUTTER: ResourceLocation;
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: ResourceLocation;
    static readonly DAMAGE_ABSORBED: ResourceLocation;
    static readonly FISH_CAUGHT: ResourceLocation;
    static readonly INTERACT_WITH_ANVIL: ResourceLocation;
    static readonly BOAT_ONE_CM: ResourceLocation;
    static readonly PLAY_RECORD: ResourceLocation;
    static readonly DAMAGE_DEALT_RESISTED: ResourceLocation;
    static readonly RAID_WIN: ResourceLocation;
    static readonly DAMAGE_DEALT: ResourceLocation;
    static readonly DEATHS: ResourceLocation;
    static readonly INTERACT_WITH_SMOKER: ResourceLocation;
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: ResourceLocation;
    static readonly INTERACT_WITH_SMITHING_TABLE: ResourceLocation;
    static readonly INSPECT_DROPPER: ResourceLocation;
    static readonly DROP: ResourceLocation;
    static readonly INTERACT_WITH_LECTERN: ResourceLocation;
    static readonly PLAY_TIME: ResourceLocation;
    static readonly WALK_ONE_CM: ResourceLocation;
    static readonly CLIMB_ONE_CM: ResourceLocation;
    static readonly TRADED_WITH_VILLAGER: ResourceLocation;
    static readonly RAID_TRIGGER: ResourceLocation;
    static readonly STRIDER_ONE_CM: ResourceLocation;
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: ResourceLocation;
    static readonly INTERACT_WITH_BEACON: ResourceLocation;
    static readonly INSPECT_HOPPER: ResourceLocation;
    static readonly PLAY_NOTEBLOCK: ResourceLocation;
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: ResourceLocation;
    static readonly JUMP: ResourceLocation;
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: ResourceLocation;
    static readonly MOB_KILLS: ResourceLocation;
    static readonly OPEN_CHEST: ResourceLocation;
    static readonly SLEEP_IN_BED: ResourceLocation;
    static readonly CLEAN_ARMOR: ResourceLocation;
    static readonly CROUCH_ONE_CM: ResourceLocation;
    static readonly TALKED_TO_VILLAGER: ResourceLocation;
    static readonly DAMAGE_DEALT_ABSORBED: ResourceLocation;
    static readonly INTERACT_WITH_LOOM: ResourceLocation;
    static readonly LEAVE_GAME: ResourceLocation;
    static readonly HORSE_ONE_CM: ResourceLocation;
    static readonly WALK_ON_WATER_ONE_CM: ResourceLocation;
    static readonly MINECART_ONE_CM: ResourceLocation;
    static readonly ENCHANT_ITEM: ResourceLocation;
    static readonly TIME_SINCE_DEATH: ResourceLocation;
    static readonly DAMAGE_TAKEN: ResourceLocation;
    static readonly INTERACT_WITH_BLAST_FURNACE: ResourceLocation;
    static readonly TRIGGER_TRAPPED_CHEST: ResourceLocation;
    static readonly INTERACT_WITH_GRINDSTONE: ResourceLocation;
    static readonly OPEN_BARREL: ResourceLocation;
    static readonly SPRINT_ONE_CM: ResourceLocation;
    static readonly DAMAGE_BLOCKED_BY_SHIELD: ResourceLocation;
    static readonly EAT_CAKE_SLICE: ResourceLocation;
    static readonly INTERACT_WITH_CRAFTING_TABLE: ResourceLocation;
    static readonly CLEAN_BANNER: ResourceLocation;
    static readonly TARGET_HIT: ResourceLocation;
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: ResourceLocation;
    static readonly PIG_ONE_CM: ResourceLocation;
    static readonly OPEN_SHULKER_BOX: ResourceLocation;
    static readonly USE_CAULDRON: ResourceLocation;
    static readonly AVIATE_ONE_CM: ResourceLocation;
    static readonly FILL_CAULDRON: ResourceLocation;
}
type Stats_ = Stats;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    static water(): Internal.FluidStackJS;
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: ResourceLocation;
    static readonly WATER_ID: ResourceLocation;
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    static of(o: InputItem_): InputItem;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    validForMatching(): boolean;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    unwrap(): Internal.List<InputItem>;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    isEmpty(): boolean;
    withCount(count: number): this;
    toJson(): Internal.JsonElement;
    kjs$asIngredient(): Internal.Ingredient;
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: InputItem;
    static readonly PARSE_CACHE: {"minecraft:iron_ingot": InputItem, "minecraft:chiseled_stone_bricks": InputItem};
}
type InputItem_ = Internal.Ingredient_ | InputItem | any_;
declare interface Color {
    of(o: any): dev.latvian.mods.rhino.mod.util.color.Color;
    rgba(r: number, g: number, b: number, a: number): dev.latvian.mods.rhino.mod.util.color.Color;
    createMapped(o: any, ...names: string[]): dev.latvian.mods.rhino.mod.util.color.Color;
    readonly DARK_PURPLE: Internal.ChatFormatting;
    readonly YELLOW: Internal.ChatFormatting;
    readonly CYAN_DYE: Internal.DyeColor;
    readonly GRAY: Internal.ChatFormatting;
    readonly BROWN_DYE: Internal.DyeColor;
    readonly LIGHT_PURPLE: Internal.ChatFormatting;
    readonly PURPLE_DYE: Internal.DyeColor;
    readonly DARK_AQUA: Internal.ChatFormatting;
    readonly GREEN: Internal.ChatFormatting;
    readonly LIGHT_GRAY_DYE: Internal.DyeColor;
    readonly WHITE: Internal.ChatFormatting;
    readonly MAGENTA_DYE: Internal.DyeColor;
    readonly RED: Internal.ChatFormatting;
    readonly BLACK_DYE: Internal.DyeColor;
    readonly TEXT: {"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting};
    readonly RED_DYE: Internal.DyeColor;
    readonly GRAY_DYE: Internal.DyeColor;
    readonly DARK_GRAY: Internal.ChatFormatting;
    readonly NONE: Internal.NoColor;
    readonly ORANGE_DYE: Internal.DyeColor;
    readonly WHITE_DYE: Internal.DyeColor;
    readonly DYE: {"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor};
    readonly BLACK: Internal.ChatFormatting;
    readonly BLUE: Internal.ChatFormatting;
    readonly DARK_GREEN: Internal.ChatFormatting;
    readonly DARK_RED: Internal.ChatFormatting;
    readonly GOLD: Internal.ChatFormatting;
    readonly MAP: {"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting};
    readonly GREEN_DYE: Internal.DyeColor;
    readonly LIGHT_BLUE_DYE: Internal.DyeColor;
    readonly AQUA: Internal.ChatFormatting;
    readonly DARK_BLUE: Internal.ChatFormatting;
    readonly PINK_DYE: Internal.DyeColor;
    readonly BLUE_DYE: Internal.DyeColor;
    readonly YELLOW_DYE: Internal.DyeColor;
    readonly LIME_DYE: Internal.DyeColor;
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    static toPrettyString(json: Internal.JsonElement_): string;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static getJsonHashString(json: Internal.JsonElement_): string;
    static parse(string: string): any;
    static toObject(json: Internal.JsonElement_): any;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static toPrimitive(element: Internal.JsonElement_): any;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static toString(json: Internal.JsonElement_): string;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    static of(o: any): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
}
type JsonIO_ = JsonIO;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: Internal.UUID;
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: Internal.UUID;
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    shortValue(): number;
    abstract doubleValue(): number;
    abstract intValue(): number;
    abstract floatValue(): number;
    byteValue(): number;
}
type number_ = number;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    write(buf: Internal.FriendlyByteBuf_): void;
    setAtlasIcon(icon: string): void;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    static of(cx: Internal.Context_, object: any): Notification;
    setIcon(icon: string): void;
    show(): void;
    setItemIcon(stack: Internal.ItemStack_): void;
    set atlasIcon(icon: string)
    set icon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: Duration;
    backgroundColor: dev.latvian.mods.rhino.mod.util.color.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: Internal.SimpleColor;
    static readonly DEFAULT_BORDER_COLOR: Internal.SimpleColor;
    borderColor: dev.latvian.mods.rhino.mod.util.color.Color;
    text: net.minecraft.network.chat.Component;
    outlineColor: dev.latvian.mods.rhino.mod.util.color.Color;
    textShadow: boolean;
    static readonly NO_TEXT: net.minecraft.network.chat.Component[];
}
type Notification_ = Notification;
declare interface Facing {
    readonly south: Internal.Direction;
    readonly up: Internal.Direction;
    readonly UP: Internal.Direction;
    readonly NORTH: Internal.Direction;
    readonly east: Internal.Direction;
    readonly DOWN: Internal.Direction;
    readonly EAST: Internal.Direction;
    readonly west: Internal.Direction;
    readonly north: Internal.Direction;
    readonly down: Internal.Direction;
    readonly ALL: {"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction};
    readonly WEST: Internal.Direction;
    readonly SOUTH: Internal.Direction;
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    positiveZ(arg0: Vec3f_): Vec3f;
    difference(arg0: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: Vec4f_): Vec4f;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    normalize(arg0: Quaternionf_): this;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mul(arg0: number, arg1: Quaternionf_): this;
    w(): number;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    isFinite(): boolean;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    dot(arg0: Quaternionf_): number;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    lengthSquared(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    get(arg0: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotationX(arg0: number): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    angle(): number;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix3f_): Matrix3f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    set(arg0: Internal.AxisAngle4d_): this;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    set fromNormalized(arg0: Internal.Matrix4fc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class BlockProperties {
    constructor()
    static readonly LEVEL_FLOWING: Internal.IntegerProperty;
    static readonly PERSISTENT: Internal.BooleanProperty;
    static readonly HORIZONTAL_FACING: Internal.DirectionProperty;
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: Internal.BooleanProperty;
    static readonly NOTE: Internal.IntegerProperty;
    static readonly AGE_5: Internal.IntegerProperty;
    static readonly EGGS: Internal.IntegerProperty;
    static readonly NORTH: Internal.BooleanProperty;
    static readonly HAS_RECORD: Internal.BooleanProperty;
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: Internal.IntegerProperty;
    static readonly HANGING: Internal.BooleanProperty;
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: Internal.IntegerProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: Internal.BooleanProperty;
    static readonly HAS_BOTTLE_2: Internal.BooleanProperty;
    static readonly LAYERS: Internal.IntegerProperty;
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: Internal.BooleanProperty;
    static readonly CONDITIONAL: Internal.BooleanProperty;
    static readonly LOCKED: Internal.BooleanProperty;
    static readonly POWER: Internal.IntegerProperty;
    static readonly EYE: Internal.BooleanProperty;
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: 1;
    static readonly ATTACHED: Internal.BooleanProperty;
    static readonly MAX_LEVEL_15: 15;
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: 7;
    static readonly FLOWER_AMOUNT: Internal.IntegerProperty;
    static readonly EXTENDED: Internal.BooleanProperty;
    static readonly INVERTED: Internal.BooleanProperty;
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: Internal.IntegerProperty;
    static readonly LIT: Internal.BooleanProperty;
    static readonly DISTANCE: Internal.IntegerProperty;
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: Internal.IntegerProperty;
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: 8;
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: 0;
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: Internal.BooleanProperty;
    static readonly ENABLED: Internal.BooleanProperty;
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: Internal.BooleanProperty;
    static readonly UNSTABLE: Internal.BooleanProperty;
    static readonly AGE_4: Internal.IntegerProperty;
    static readonly EAST: Internal.BooleanProperty;
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: 4;
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: 7;
    static readonly DOWN: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: Internal.BooleanProperty;
    static readonly AGE_15: Internal.IntegerProperty;
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: Internal.BooleanProperty;
    static readonly BLOOM: Internal.BooleanProperty;
    static readonly SHRIEKING: Internal.BooleanProperty;
    static readonly AGE_1: Internal.IntegerProperty;
    static readonly FACING_HOPPER: Internal.DirectionProperty;
    static readonly VERTICAL_DIRECTION: Internal.DirectionProperty;
    static readonly PICKLES: Internal.IntegerProperty;
    static readonly MAX_AGE_25: 25;
    static readonly LEVEL_HONEY: Internal.IntegerProperty;
    static readonly DUSTED: Internal.IntegerProperty;
    static readonly MAX_AGE_4: 4;
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: Internal.IntegerProperty;
    static readonly SNOWY: Internal.BooleanProperty;
    static readonly TRIGGERED: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: Internal.BooleanProperty;
    static readonly SIGNAL_FIRE: Internal.BooleanProperty;
    static readonly LEVEL_CAULDRON: Internal.IntegerProperty;
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: Internal.IntegerProperty;
    static readonly DRAG: Internal.BooleanProperty;
    static readonly CAN_SUMMON: Internal.BooleanProperty;
    static readonly LEVEL: Internal.IntegerProperty;
    static readonly STAGE: Internal.IntegerProperty;
    static readonly MAX_AGE_5: 5;
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: Internal.BooleanProperty;
    static readonly BITES: Internal.IntegerProperty;
    static readonly IN_WALL: Internal.BooleanProperty;
    static readonly AGE_25: Internal.IntegerProperty;
    static readonly STABILITY_MAX_DISTANCE: 7;
    static readonly HAS_BOTTLE_1: Internal.BooleanProperty;
    static readonly AGE_7: Internal.IntegerProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: Internal.BooleanProperty;
    static readonly SOUTH: Internal.BooleanProperty;
    static readonly MAX_AGE_15: 15;
    static readonly DISARMED: Internal.BooleanProperty;
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: Internal.IntegerProperty;
    static readonly DELAY: Internal.IntegerProperty;
    static readonly MIN_LEVEL: 0;
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: 1;
    static readonly BOTTOM: Internal.BooleanProperty;
    static readonly HAS_BOOK: Internal.BooleanProperty;
    static readonly CANDLES: Internal.IntegerProperty;
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: Internal.BooleanProperty;
    static readonly SHORT: Internal.BooleanProperty;
    static readonly BERRIES: Internal.BooleanProperty;
    static readonly MAX_AGE_2: 2;
    static readonly HAS_BOTTLE_0: Internal.BooleanProperty;
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: Internal.IntegerProperty;
    static readonly MAX_LEVEL_3: 3;
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: Internal.BooleanProperty;
    static readonly MAX_AGE_3: 3;
    static readonly OCCUPIED: Internal.BooleanProperty;
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: Internal.DirectionProperty;
}
type BlockProperties_ = BlockProperties;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor($$0: number, $$1: number, $$2: number)
    north(): this;
    distToCenterSqr($$0: Internal.Position_): number;
    getX(): number;
    static offsetCodec($$0: number): Internal.Codec<Vec3i>;
    getY(): number;
    south($$0: number): this;
    toShortString(): string;
    above($$0: number): this;
    west($$0: number): this;
    compareTo(arg0: any): number;
    east($$0: number): this;
    distToLowCornerSqr($$0: number, $$1: number, $$2: number): number;
    relative($$0: Internal.Direction_): this;
    multiply($$0: number): this;
    getZ(): number;
    closerThan($$0: Vec3i_, $$1: number): boolean;
    below($$0: number): this;
    offset($$0: number, $$1: number, $$2: number): this;
    above(): this;
    east(): this;
    north($$0: number): this;
    below(): this;
    distManhattan($$0: Vec3i_): number;
    west(): this;
    relative($$0: Internal.Direction$Axis_, $$1: number): this;
    get($$0: Internal.Direction$Axis_): number;
    cross($$0: Vec3i_): this;
    offset($$0: Vec3i_): this;
    south(): this;
    distSqr($$0: Vec3i_): number;
    subtract($$0: Vec3i_): this;
    relative($$0: Internal.Direction_, $$1: number): this;
    compareTo($$0: Vec3i_): number;
    closerToCenterThan($$0: Internal.Position_, $$1: number): boolean;
    distToCenterSqr($$0: number, $$1: number, $$2: number): number;
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: Vec3i;
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare class Blocks {
    constructor()
    static never($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.EntityType_<any>): boolean;
    static log($$0: Internal.MapColor_, $$1: Internal.MapColor_, $$2: SoundType_): Internal.RotatedPillarBlock;
    static never($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
    static always($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_): boolean;
    static rebuildCache(): void;
    static stoneButton(): Internal.ButtonBlock;
    static woodenButton($$0: Internal.BlockSetType_, ...$$1: Internal.FeatureFlag_[]): Internal.ButtonBlock;
    static log($$0: Internal.MapColor_, $$1: Internal.MapColor_): Internal.RotatedPillarBlock;
    static register($$0: string, $$1: Internal.Block_): Internal.Block;
    static leaves($$0: SoundType_): Internal.LeavesBlock;
    static litBlockEmission($$0: number): Internal.ToIntFunction<Internal.BlockState>;
    static netherStem($$0: Internal.MapColor_): Internal.Block;
    static ocelotOrParrot($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.EntityType_<any>): boolean;
    static always($$0: Internal.BlockState_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.EntityType_<any>): boolean;
    static flowerPot($$0: Internal.Block_, ...$$1: Internal.FeatureFlag_[]): Internal.FlowerPotBlock;
    static readonly MANGROVE_PROPAGULE: Internal.MangrovePropaguleBlock;
    static readonly STONE_SLAB: Internal.SlabBlock;
    static readonly POTTED_CRIMSON_FUNGUS: Internal.FlowerPotBlock;
    static readonly DEEPSLATE_BRICK_STAIRS: Internal.StairBlock;
    static readonly CHERRY_SAPLING: Internal.SaplingBlock;
    static readonly POLISHED_ANDESITE: Internal.Block;
    static readonly RED_NETHER_BRICKS: Internal.Block;
    static readonly TORCH: Internal.TorchBlock;
    static readonly COAL_BLOCK: Internal.Block;
    static readonly STRIPPED_CRIMSON_STEM: Internal.RotatedPillarBlock;
    static readonly FIRE_CORAL_BLOCK: Internal.CoralBlock;
    static readonly WEEPING_VINES_PLANT: Internal.WeepingVinesPlantBlock;
    static readonly PEONY: Internal.TallFlowerBlock;
    static readonly CARROTS: Internal.CarrotBlock;
    static readonly YELLOW_CANDLE: Internal.CandleBlock;
    static readonly CYAN_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly BLUE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly TUBE_CORAL_BLOCK: Internal.CoralBlock;
    static readonly SMITHING_TABLE: Internal.SmithingTableBlock;
    static readonly ACACIA_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly MAGENTA_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly POTTED_CHERRY_SAPLING: Internal.FlowerPotBlock;
    static readonly PLAYER_WALL_HEAD: Internal.PlayerWallHeadBlock;
    static readonly DEAD_HORN_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly MANGROVE_LOG: Internal.RotatedPillarBlock;
    static readonly SPRUCE_BUTTON: Internal.ButtonBlock;
    static readonly IRON_ORE: Internal.DropExperienceBlock;
    static readonly TRIPWIRE: Internal.TripWireBlock;
    static readonly BLACK_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly LIGHT_BLUE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly ACACIA_STAIRS: Internal.StairBlock;
    static readonly CRIMSON_FUNGUS: Internal.FungusBlock;
    static readonly BUBBLE_CORAL_BLOCK: Internal.CoralBlock;
    static readonly LIGHT_BLUE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly PRISMARINE_SLAB: Internal.SlabBlock;
    static readonly DEAD_TUBE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly PURPLE_BANNER: Internal.BannerBlock;
    static readonly RED_NETHER_BRICK_SLAB: Internal.SlabBlock;
    static readonly SCULK_SENSOR: Internal.SculkSensorBlock;
    static readonly YELLOW_WOOL: Internal.Block;
    static readonly MAGENTA_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly SAND: Internal.SandBlock;
    static readonly MYCELIUM: Internal.MyceliumBlock;
    static readonly LIGHT_GRAY_BANNER: Internal.BannerBlock;
    static readonly ORANGE_CANDLE: Internal.CandleBlock;
    static readonly CORNFLOWER: Internal.FlowerBlock;
    static readonly DARK_OAK_DOOR: Internal.DoorBlock;
    static readonly GRANITE_SLAB: Internal.SlabBlock;
    static readonly REDSTONE_LAMP: Internal.RedstoneLampBlock;
    static readonly LIGHT: Internal.LightBlock;
    static readonly TUBE_CORAL_FAN: Internal.CoralFanBlock;
    static readonly WARPED_FENCE_GATE: Internal.FenceGateBlock;
    static readonly DANDELION: Internal.FlowerBlock;
    static readonly PINK_TERRACOTTA: Internal.Block;
    static readonly WARPED_BUTTON: Internal.ButtonBlock;
    static readonly RED_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly SOUL_SOIL: Internal.Block;
    static readonly ACACIA_FENCE: Internal.FenceBlock;
    static readonly CRIMSON_SIGN: Internal.StandingSignBlock;
    static readonly HEAVY_WEIGHTED_PRESSURE_PLATE: Internal.WeightedPressurePlateBlock;
    static readonly PRISMARINE_STAIRS: Internal.StairBlock;
    static readonly TWISTING_VINES_PLANT: Internal.TwistingVinesPlantBlock;
    static readonly DEEPSLATE_BRICK_SLAB: Internal.SlabBlock;
    static readonly WARPED_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly OAK_WOOD: Internal.RotatedPillarBlock;
    static readonly PINK_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly RED_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly WARPED_WART_BLOCK: Internal.Block;
    static readonly EXPOSED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static readonly COARSE_DIRT: Internal.Block;
    static readonly DEEPSLATE_REDSTONE_ORE: Internal.RedStoneOreBlock;
    static readonly TUFF: Internal.Block;
    static readonly CHISELED_BOOKSHELF: Internal.ChiseledBookShelfBlock;
    static readonly ACACIA_LOG: Internal.RotatedPillarBlock;
    static readonly DEEPSLATE_IRON_ORE: Internal.DropExperienceBlock;
    static readonly PURPLE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly LIGHTNING_ROD: Internal.LightningRodBlock;
    static readonly COBBLED_DEEPSLATE_SLAB: Internal.SlabBlock;
    static readonly RED_CARPET: Internal.WoolCarpetBlock;
    static readonly CHERRY_LOG: Internal.RotatedPillarBlock;
    static readonly LILY_PAD: Internal.WaterlilyBlock;
    static readonly GREEN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly BARRIER: Internal.BarrierBlock;
    static readonly PINK_CARPET: Internal.WoolCarpetBlock;
    static readonly DRAGON_HEAD: Internal.SkullBlock;
    static readonly YELLOW_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly DEAD_BUBBLE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly STRIPPED_BIRCH_WOOD: Internal.RotatedPillarBlock;
    static readonly SEAGRASS: Internal.SeagrassBlock;
    static readonly CHERRY_WALL_SIGN: Internal.WallSignBlock;
    static readonly HORN_CORAL: Internal.CoralPlantBlock;
    static readonly MOSSY_STONE_BRICKS: Internal.Block;
    static readonly SPRUCE_SIGN: Internal.StandingSignBlock;
    static readonly WAXED_COPPER_BLOCK: Internal.Block;
    static readonly STONE_BRICK_STAIRS: Internal.StairBlock;
    static readonly GRANITE_WALL: Internal.WallBlock;
    static readonly NETHER_BRICK_FENCE: Internal.FenceBlock;
    static readonly MOSS_CARPET: Internal.CarpetBlock;
    static readonly DARK_OAK_PLANKS: Internal.Block;
    static readonly MAGENTA_WALL_BANNER: Internal.WallBannerBlock;
    static readonly ANDESITE_SLAB: Internal.SlabBlock;
    static readonly RED_NETHER_BRICK_WALL: Internal.WallBlock;
    static readonly BIRCH_DOOR: Internal.DoorBlock;
    static readonly BAMBOO_DOOR: Internal.DoorBlock;
    static readonly BROWN_CONCRETE: Internal.Block;
    static readonly DEEPSLATE_DIAMOND_ORE: Internal.DropExperienceBlock;
    static readonly BEETROOTS: Internal.BeetrootBlock;
    static readonly POTTED_BAMBOO: Internal.FlowerPotBlock;
    static readonly FERN: Internal.TallGrassBlock;
    static readonly CRIMSON_HYPHAE: Internal.RotatedPillarBlock;
    static readonly WAXED_CUT_COPPER: Internal.Block;
    static readonly ACACIA_DOOR: Internal.DoorBlock;
    static readonly BLACK_WOOL: Internal.Block;
    static readonly POLISHED_BLACKSTONE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly BRAIN_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly VINE: Internal.VineBlock;
    static readonly CHERRY_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly ANDESITE_STAIRS: Internal.StairBlock;
    static readonly INFESTED_DEEPSLATE: Internal.InfestedRotatedPillarBlock;
    static readonly ACACIA_WALL_SIGN: Internal.WallSignBlock;
    static readonly SPONGE: Internal.SpongeBlock;
    static readonly REDSTONE_ORE: Internal.RedStoneOreBlock;
    static readonly STRIPPED_ACACIA_WOOD: Internal.RotatedPillarBlock;
    static readonly REDSTONE_WALL_TORCH: Internal.RedstoneWallTorchBlock;
    static readonly CYAN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly BLACK_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly CAMPFIRE: Internal.CampfireBlock;
    static readonly OCHRE_FROGLIGHT: Internal.RotatedPillarBlock;
    static readonly COBBLESTONE_STAIRS: Internal.StairBlock;
    static readonly DRAGON_WALL_HEAD: Internal.WallSkullBlock;
    static readonly POTTED_WITHER_ROSE: Internal.FlowerPotBlock;
    static readonly BLACKSTONE_STAIRS: Internal.StairBlock;
    static readonly GRAY_CANDLE: Internal.CandleBlock;
    static readonly CYAN_TERRACOTTA: Internal.Block;
    static readonly BAMBOO_SIGN: Internal.StandingSignBlock;
    static readonly BIRCH_WALL_SIGN: Internal.WallSignBlock;
    static readonly POTTED_CORNFLOWER: Internal.FlowerPotBlock;
    static readonly STICKY_PISTON: Internal.PistonBaseBlock;
    static readonly LIGHT_BLUE_TERRACOTTA: Internal.Block;
    static readonly WEATHERED_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly CYAN_WALL_BANNER: Internal.WallBannerBlock;
    static readonly RAW_GOLD_BLOCK: Internal.Block;
    static readonly STRIPPED_BIRCH_LOG: Internal.RotatedPillarBlock;
    static readonly LARGE_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static readonly POLISHED_ANDESITE_SLAB: Internal.SlabBlock;
    static readonly NETHER_PORTAL: Internal.NetherPortalBlock;
    static readonly JUNGLE_PLANKS: Internal.Block;
    static readonly PINK_TULIP: Internal.FlowerBlock;
    static readonly OAK_SLAB: Internal.SlabBlock;
    static readonly STRIPPED_WARPED_HYPHAE: Internal.RotatedPillarBlock;
    static readonly POTTED_OAK_SAPLING: Internal.FlowerPotBlock;
    static readonly MANGROVE_SLAB: Internal.SlabBlock;
    static readonly DARK_OAK_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly EXPOSED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static readonly ORANGE_CONCRETE: Internal.Block;
    static readonly BLUE_ORCHID: Internal.FlowerBlock;
    static readonly STRIPPED_BAMBOO_BLOCK: Internal.RotatedPillarBlock;
    static readonly BIRCH_LOG: Internal.RotatedPillarBlock;
    static readonly GRAY_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly DEEPSLATE_TILES: Internal.Block;
    static readonly CRIMSON_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly WHITE_BANNER: Internal.BannerBlock;
    static readonly KELP: Internal.KelpBlock;
    static readonly BROWN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly INFESTED_CRACKED_STONE_BRICKS: Internal.InfestedBlock;
    static readonly JUNGLE_FENCE: Internal.FenceBlock;
    static readonly LIGHT_GRAY_CONCRETE: Internal.Block;
    static readonly RED_MUSHROOM_BLOCK: Internal.HugeMushroomBlock;
    static readonly GRAY_TERRACOTTA: Internal.Block;
    static readonly MOSS_BLOCK: Internal.MossBlock;
    static readonly LIME_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly CRIMSON_STAIRS: Internal.StairBlock;
    static readonly CARVED_PUMPKIN: Internal.EquipableCarvedPumpkinBlock;
    static readonly POTATOES: Internal.PotatoBlock;
    static readonly PURPUR_PILLAR: Internal.RotatedPillarBlock;
    static readonly MUD_BRICKS: Internal.Block;
    static readonly DEAD_FIRE_CORAL_BLOCK: Internal.Block;
    static readonly MANGROVE_WOOD: Internal.RotatedPillarBlock;
    static readonly CHERRY_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly NOTE_BLOCK: Internal.NoteBlock;
    static readonly ENDER_CHEST: Internal.EnderChestBlock;
    static readonly CYAN_BED: Internal.BedBlock;
    static readonly DEAD_TUBE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly BIRCH_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly YELLOW_CONCRETE: Internal.Block;
    static readonly DEAD_TUBE_CORAL_BLOCK: Internal.Block;
    static readonly STRIPPED_WARPED_STEM: Internal.RotatedPillarBlock;
    static readonly LEVER: Internal.LeverBlock;
    static readonly POLISHED_BLACKSTONE: Internal.Block;
    static readonly LIGHT_BLUE_CONCRETE: Internal.Block;
    static readonly POTTED_MANGROVE_PROPAGULE: Internal.FlowerPotBlock;
    static readonly DROPPER: Internal.DropperBlock;
    static readonly SPRUCE_FENCE: Internal.FenceBlock;
    static readonly RED_SANDSTONE_STAIRS: Internal.StairBlock;
    static readonly CRAFTING_TABLE: Internal.CraftingTableBlock;
    static readonly SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly GRASS: Internal.TallGrassBlock;
    static readonly CHERRY_SLAB: Internal.SlabBlock;
    static readonly MEDIUM_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static readonly CRIMSON_ROOTS: Internal.RootsBlock;
    static readonly WITHER_ROSE: Internal.WitherRoseBlock;
    static readonly OXEYE_DAISY: Internal.FlowerBlock;
    static readonly OAK_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly EMERALD_BLOCK: Internal.Block;
    static readonly BUDDING_AMETHYST: Internal.BuddingAmethystBlock;
    static readonly RAIL: Internal.RailBlock;
    static readonly JUNGLE_WALL_SIGN: Internal.WallSignBlock;
    static readonly BROWN_MUSHROOM_BLOCK: Internal.HugeMushroomBlock;
    static readonly DARK_OAK_SAPLING: Internal.SaplingBlock;
    static readonly DIAMOND_ORE: Internal.DropExperienceBlock;
    static readonly LADDER: Internal.LadderBlock;
    static readonly OAK_SAPLING: Internal.SaplingBlock;
    static readonly MELON: Internal.MelonBlock;
    static readonly CRIMSON_PLANKS: Internal.Block;
    static readonly GLOW_LICHEN: Internal.GlowLichenBlock;
    static readonly REDSTONE_WIRE: Internal.RedStoneWireBlock;
    static readonly HORN_CORAL_FAN: Internal.CoralFanBlock;
    static readonly DARK_PRISMARINE_SLAB: Internal.SlabBlock;
    static readonly CAVE_VINES_PLANT: Internal.CaveVinesPlantBlock;
    static readonly ACACIA_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly YELLOW_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly SMOOTH_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly COBBLED_DEEPSLATE_WALL: Internal.WallBlock;
    static readonly CRIMSON_NYLIUM: Internal.NyliumBlock;
    static readonly POTTED_BLUE_ORCHID: Internal.FlowerPotBlock;
    static readonly CYAN_BANNER: Internal.BannerBlock;
    static readonly SCULK_CATALYST: Internal.SculkCatalystBlock;
    static readonly STRIPPED_MANGROVE_LOG: Internal.RotatedPillarBlock;
    static readonly DISPENSER: Internal.DispenserBlock;
    static readonly PRISMARINE_WALL: Internal.WallBlock;
    static readonly ORANGE_TULIP: Internal.FlowerBlock;
    static readonly COMMAND_BLOCK: Internal.CommandBlock;
    static readonly BLACK_WALL_BANNER: Internal.WallBannerBlock;
    static readonly SPORE_BLOSSOM: Internal.SporeBlossomBlock;
    static readonly OXIDIZED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static readonly DEEPSLATE_TILE_STAIRS: Internal.StairBlock;
    static readonly JUNGLE_STAIRS: Internal.StairBlock;
    static readonly DIRT_PATH: Internal.DirtPathBlock;
    static readonly BLUE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly GREEN_CARPET: Internal.WoolCarpetBlock;
    static readonly HONEYCOMB_BLOCK: Internal.Block;
    static readonly ICE: Internal.IceBlock;
    static readonly BAMBOO_MOSAIC_STAIRS: Internal.StairBlock;
    static readonly POTTED_BIRCH_SAPLING: Internal.FlowerPotBlock;
    static readonly WHITE_CARPET: Internal.WoolCarpetBlock;
    static readonly WATER: Internal.LiquidBlock;
    static readonly CRACKED_NETHER_BRICKS: Internal.Block;
    static readonly WATER_CAULDRON: Internal.LayeredCauldronBlock;
    static readonly MUD_BRICK_SLAB: Internal.SlabBlock;
    static readonly WAXED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static readonly POLISHED_DEEPSLATE_WALL: Internal.WallBlock;
    static readonly OAK_FENCE_GATE: Internal.FenceGateBlock;
    static readonly OAK_LEAVES: Internal.LeavesBlock;
    static readonly POTTED_BROWN_MUSHROOM: Internal.FlowerPotBlock;
    static readonly WARPED_DOOR: Internal.DoorBlock;
    static readonly JUKEBOX: Internal.JukeboxBlock;
    static readonly MANGROVE_FENCE: Internal.FenceBlock;
    static readonly NETHER_BRICKS: Internal.Block;
    static readonly PLAYER_HEAD: Internal.PlayerHeadBlock;
    static readonly PURPLE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly DEAD_TUBE_CORAL: Internal.BaseCoralPlantBlock;
    static readonly BIRCH_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly POWDER_SNOW_CAULDRON: Internal.PowderSnowCauldronBlock;
    static readonly BROWN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly BREWING_STAND: Internal.BrewingStandBlock;
    static readonly POLISHED_BLACKSTONE_BRICK_STAIRS: Internal.StairBlock;
    static readonly REDSTONE_TORCH: Internal.RedstoneTorchBlock;
    static readonly BAMBOO_FENCE_GATE: Internal.FenceGateBlock;
    static readonly BLACK_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly POLISHED_GRANITE_STAIRS: Internal.StairBlock;
    static readonly MAGENTA_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly DEAD_BRAIN_CORAL: Internal.BaseCoralPlantBlock;
    static readonly BLACK_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly NETHER_SPROUTS: Internal.NetherSproutsBlock;
    static readonly GREEN_CANDLE: Internal.CandleBlock;
    static readonly SPRUCE_LOG: Internal.RotatedPillarBlock;
    static readonly PURPLE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly CONDUIT: Internal.ConduitBlock;
    static readonly ORANGE_WOOL: Internal.Block;
    static readonly POTTED_WHITE_TULIP: Internal.FlowerPotBlock;
    static readonly PRISMARINE_BRICKS: Internal.Block;
    static readonly POLISHED_BLACKSTONE_WALL: Internal.WallBlock;
    static readonly SEA_LANTERN: Internal.Block;
    static readonly MAGENTA_BED: Internal.BedBlock;
    static readonly POLISHED_DEEPSLATE_SLAB: Internal.SlabBlock;
    static readonly STONE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly SCAFFOLDING: Internal.ScaffoldingBlock;
    static readonly NETHER_BRICK_STAIRS: Internal.StairBlock;
    static readonly DIORITE_SLAB: Internal.SlabBlock;
    static readonly PISTON_HEAD: Internal.PistonHeadBlock;
    static readonly BLACK_TERRACOTTA: Internal.Block;
    static readonly PURPLE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly LIME_CANDLE: Internal.CandleBlock;
    static readonly OAK_WALL_SIGN: Internal.WallSignBlock;
    static readonly CUT_RED_SANDSTONE: Internal.Block;
    static readonly DEAD_FIRE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly LIME_BED: Internal.BedBlock;
    static readonly SPAWNER: Internal.SpawnerBlock;
    static readonly FROSTED_ICE: Internal.FrostedIceBlock;
    static readonly IRON_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly WARPED_ROOTS: Internal.RootsBlock;
    static readonly STONE: Internal.Block;
    static readonly MUD_BRICK_WALL: Internal.WallBlock;
    static readonly SOUL_LANTERN: Internal.LanternBlock;
    static readonly COPPER_BLOCK: Internal.WeatheringCopperFullBlock;
    static readonly WAXED_OXIDIZED_COPPER: Internal.Block;
    static readonly WARPED_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly POLISHED_BASALT: Internal.RotatedPillarBlock;
    static readonly DAYLIGHT_DETECTOR: Internal.DaylightDetectorBlock;
    static readonly CRIMSON_SLAB: Internal.SlabBlock;
    static readonly CHERRY_WOOD: Internal.RotatedPillarBlock;
    static readonly GOLD_BLOCK: Internal.Block;
    static readonly POTTED_LILY_OF_THE_VALLEY: Internal.FlowerPotBlock;
    static readonly LIGHT_BLUE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly LIGHT_GRAY_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly DRIPSTONE_BLOCK: Internal.Block;
    static readonly COBBLED_DEEPSLATE: Internal.Block;
    static readonly BIG_DRIPLEAF: Internal.BigDripleafBlock;
    static readonly MANGROVE_LEAVES: Internal.MangroveLeavesBlock;
    static readonly GRAY_WOOL: Internal.Block;
    static readonly INFESTED_CHISELED_STONE_BRICKS: Internal.InfestedBlock;
    static readonly GRAY_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly CHERRY_SIGN: Internal.StandingSignBlock;
    static readonly REPEATING_COMMAND_BLOCK: Internal.CommandBlock;
    static readonly WARPED_FENCE: Internal.FenceBlock;
    static readonly RED_BED: Internal.BedBlock;
    static readonly CHERRY_DOOR: Internal.DoorBlock;
    static readonly POTTED_DANDELION: Internal.FlowerPotBlock;
    static readonly POTTED_CACTUS: Internal.FlowerPotBlock;
    static readonly DIORITE_WALL: Internal.WallBlock;
    static readonly HOPPER: Internal.HopperBlock;
    static readonly SPRUCE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly BARREL: Internal.BarrelBlock;
    static readonly MELON_STEM: Internal.StemBlock;
    static readonly ROOTED_DIRT: Internal.RootedDirtBlock;
    static readonly LIGHT_BLUE_WOOL: Internal.Block;
    static readonly SOUL_WALL_TORCH: Internal.WallTorchBlock;
    static readonly LAPIS_BLOCK: Internal.Block;
    static readonly ANDESITE: Internal.Block;
    static readonly YELLOW_BED: Internal.BedBlock;
    static readonly END_STONE_BRICK_STAIRS: Internal.StairBlock;
    static readonly BLAST_FURNACE: Internal.BlastFurnaceBlock;
    static readonly SMALL_DRIPLEAF: Internal.SmallDripleafBlock;
    static readonly KELP_PLANT: Internal.KelpPlantBlock;
    static readonly RED_SAND: Internal.SandBlock;
    static readonly JUNGLE_LOG: Internal.RotatedPillarBlock;
    static readonly QUARTZ_BRICKS: Internal.Block;
    static readonly CRIMSON_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly ZOMBIE_WALL_HEAD: Internal.WallSkullBlock;
    static readonly LIME_TERRACOTTA: Internal.Block;
    static readonly RAW_COPPER_BLOCK: Internal.Block;
    static readonly CHERRY_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly ORANGE_CARPET: Internal.WoolCarpetBlock;
    static readonly LOOM: Internal.LoomBlock;
    static readonly GREEN_WOOL: Internal.Block;
    static readonly BROWN_WOOL: Internal.Block;
    static readonly LIGHT_GRAY_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly PIGLIN_WALL_HEAD: Internal.PiglinWallSkullBlock;
    static readonly BLUE_CANDLE: Internal.CandleBlock;
    static readonly PINK_CANDLE: Internal.CandleBlock;
    static readonly SMOKER: Internal.SmokerBlock;
    static readonly ANVIL: Internal.AnvilBlock;
    static readonly BROWN_CARPET: Internal.WoolCarpetBlock;
    static readonly FLOWER_POT: Internal.FlowerPotBlock;
    static readonly LIGHT_BLUE_BANNER: Internal.BannerBlock;
    static readonly POLISHED_BLACKSTONE_STAIRS: Internal.StairBlock;
    static readonly STONECUTTER: Internal.StonecutterBlock;
    static readonly CUT_RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly RED_CONCRETE: Internal.Block;
    static readonly DARK_OAK_FENCE: Internal.FenceBlock;
    static readonly GREEN_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly BAMBOO: Internal.BambooStalkBlock;
    static readonly DEAD_HORN_CORAL_BLOCK: Internal.Block;
    static readonly DARK_OAK_WALL_SIGN: Internal.WallSignBlock;
    static readonly MAGENTA_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly DARK_OAK_SIGN: Internal.StandingSignBlock;
    static readonly CHISELED_RED_SANDSTONE: Internal.Block;
    static readonly CRIMSON_BUTTON: Internal.ButtonBlock;
    static readonly PITCHER_CROP: Internal.PitcherCropBlock;
    static readonly CHERRY_LEAVES: Internal.CherryLeavesBlock;
    static readonly RED_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly QUARTZ_PILLAR: Internal.RotatedPillarBlock;
    static readonly CHISELED_POLISHED_BLACKSTONE: Internal.Block;
    static readonly DEAD_FIRE_CORAL: Internal.BaseCoralPlantBlock;
    static readonly PURPLE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly RED_CANDLE: Internal.CandleBlock;
    static readonly AMETHYST_CLUSTER: Internal.AmethystClusterBlock;
    static readonly DARK_PRISMARINE: Internal.Block;
    static readonly MANGROVE_WALL_SIGN: Internal.WallSignBlock;
    static readonly SCULK_VEIN: Internal.SculkVeinBlock;
    static readonly JUNGLE_SAPLING: Internal.SaplingBlock;
    static readonly YELLOW_CARPET: Internal.WoolCarpetBlock;
    static readonly OBSERVER: Internal.ObserverBlock;
    static readonly END_STONE_BRICK_WALL: Internal.WallBlock;
    static readonly SPRUCE_LEAVES: Internal.LeavesBlock;
    static readonly MANGROVE_BUTTON: Internal.ButtonBlock;
    static readonly WAXED_EXPOSED_CUT_COPPER: Internal.Block;
    static readonly STONE_BRICK_SLAB: Internal.SlabBlock;
    static readonly BAMBOO_BUTTON: Internal.ButtonBlock;
    static readonly STONE_BRICKS: Internal.Block;
    static readonly SPRUCE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly NETHER_WART: Internal.NetherWartBlock;
    static readonly WAXED_OXIDIZED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static readonly RED_WALL_BANNER: Internal.WallBannerBlock;
    static readonly OBSIDIAN: Internal.Block;
    static readonly PURPLE_CONCRETE: Internal.Block;
    static readonly BLACK_CONCRETE: Internal.Block;
    static readonly WARPED_SIGN: Internal.StandingSignBlock;
    static readonly REINFORCED_DEEPSLATE: Internal.Block;
    static readonly DRAGON_EGG: Internal.DragonEggBlock;
    static readonly PACKED_MUD: Internal.Block;
    static readonly ACACIA_PLANKS: Internal.Block;
    static readonly RED_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly DARK_OAK_STAIRS: Internal.StairBlock;
    static readonly MOSSY_STONE_BRICK_STAIRS: Internal.StairBlock;
    static readonly LIGHT_WEIGHTED_PRESSURE_PLATE: Internal.WeightedPressurePlateBlock;
    static readonly FIRE_CORAL_FAN: Internal.CoralFanBlock;
    static readonly QUARTZ_STAIRS: Internal.StairBlock;
    static readonly PURPUR_STAIRS: Internal.StairBlock;
    static readonly STONE_STAIRS: Internal.StairBlock;
    static readonly STRIPPED_JUNGLE_LOG: Internal.RotatedPillarBlock;
    static readonly RED_WOOL: Internal.Block;
    static readonly FARMLAND: Internal.FarmBlock;
    static readonly DARK_OAK_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly ORANGE_TERRACOTTA: Internal.Block;
    static readonly DEEPSLATE_GOLD_ORE: Internal.DropExperienceBlock;
    static readonly LIGHT_BLUE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly POLISHED_BLACKSTONE_BRICK_WALL: Internal.WallBlock;
    static readonly BRICKS: Internal.Block;
    static readonly WAXED_EXPOSED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static readonly MOSSY_COBBLESTONE_STAIRS: Internal.StairBlock;
    static readonly CAKE: Internal.CakeBlock;
    static readonly GREEN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly JUNGLE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly BLUE_BED: Internal.BedBlock;
    static readonly OAK_BUTTON: Internal.ButtonBlock;
    static readonly MANGROVE_DOOR: Internal.DoorBlock;
    static readonly DEEPSLATE_BRICKS: Internal.Block;
    static readonly BASALT: Internal.RotatedPillarBlock;
    static readonly REPEATER: Internal.RepeaterBlock;
    static readonly PURPLE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly AZURE_BLUET: Internal.FlowerBlock;
    static readonly LILY_OF_THE_VALLEY: Internal.FlowerBlock;
    static readonly STONE_BRICK_WALL: Internal.WallBlock;
    static readonly BIRCH_SAPLING: Internal.SaplingBlock;
    static readonly BIRCH_STAIRS: Internal.StairBlock;
    static readonly LIGHT_BLUE_CARPET: Internal.WoolCarpetBlock;
    static readonly BROWN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly FIRE_CORAL: Internal.CoralPlantBlock;
    static readonly SANDSTONE_WALL: Internal.WallBlock;
    static readonly RESPAWN_ANCHOR: Internal.RespawnAnchorBlock;
    static readonly PRISMARINE_BRICK_SLAB: Internal.SlabBlock;
    static readonly NETHER_BRICK_SLAB: Internal.SlabBlock;
    static readonly NETHERRACK: Internal.NetherrackBlock;
    static readonly CAVE_VINES: Internal.CaveVinesBlock;
    static readonly WARPED_NYLIUM: Internal.NyliumBlock;
    static readonly POTTED_POPPY: Internal.FlowerPotBlock;
    static readonly POINTED_DRIPSTONE: Internal.PointedDripstoneBlock;
    static readonly ORANGE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly LIGHT_GRAY_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly WAXED_WEATHERED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static readonly POLISHED_BLACKSTONE_BRICKS: Internal.Block;
    static readonly GLASS: Internal.GlassBlock;
    static readonly WARPED_PLANKS: Internal.Block;
    static readonly WET_SPONGE: Internal.WetSpongeBlock;
    static readonly GRASS_BLOCK: Internal.GrassBlock;
    static readonly COAL_ORE: Internal.DropExperienceBlock;
    static readonly PURPUR_SLAB: Internal.SlabBlock;
    static readonly WARPED_STEM: Internal.RotatedPillarBlock;
    static readonly DEEPSLATE_COPPER_ORE: Internal.DropExperienceBlock;
    static readonly POLISHED_DIORITE_STAIRS: Internal.StairBlock;
    static readonly ANCIENT_DEBRIS: Internal.Block;
    static readonly GRAY_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly DEAD_BRAIN_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly WHITE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly END_STONE_BRICK_SLAB: Internal.SlabBlock;
    static readonly PODZOL: Internal.SnowyDirtBlock;
    static readonly CHERRY_BUTTON: Internal.ButtonBlock;
    static readonly COMPARATOR: Internal.ComparatorBlock;
    static readonly ACACIA_FENCE_GATE: Internal.FenceGateBlock;
    static readonly CHISELED_STONE_BRICKS: Internal.Block;
    static readonly WAXED_WEATHERED_COPPER: Internal.Block;
    static readonly SUGAR_CANE: Internal.SugarCaneBlock;
    static readonly DEAD_BRAIN_CORAL_BLOCK: Internal.Block;
    static readonly NETHERITE_BLOCK: Internal.Block;
    static readonly OAK_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly WHITE_CONCRETE: Internal.Block;
    static readonly POTTED_AZURE_BLUET: Internal.FlowerPotBlock;
    static readonly SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly ORANGE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly ORANGE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly BRAIN_CORAL_FAN: Internal.CoralFanBlock;
    static readonly PINK_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly OXIDIZED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly GRAY_BED: Internal.BedBlock;
    static readonly GLASS_PANE: Internal.IronBarsBlock;
    static readonly GRAVEL: Internal.GravelBlock;
    static readonly BAMBOO_MOSAIC: Internal.Block;
    static readonly SUSPICIOUS_GRAVEL: Internal.BrushableBlock;
    static readonly ENCHANTING_TABLE: Internal.EnchantmentTableBlock;
    static readonly LILAC: Internal.TallFlowerBlock;
    static readonly STRIPPED_SPRUCE_WOOD: Internal.RotatedPillarBlock;
    static readonly MANGROVE_SIGN: Internal.StandingSignBlock;
    static readonly RED_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly STRIPPED_JUNGLE_WOOD: Internal.RotatedPillarBlock;
    static readonly ALLIUM: Internal.FlowerBlock;
    static readonly MUD_BRICK_STAIRS: Internal.StairBlock;
    static readonly DEAD_BRAIN_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly LIGHT_GRAY_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly ZOMBIE_HEAD: Internal.SkullBlock;
    static readonly WHITE_TULIP: Internal.FlowerBlock;
    static readonly PINK_WALL_BANNER: Internal.WallBannerBlock;
    static readonly MOSSY_COBBLESTONE_WALL: Internal.WallBlock;
    static readonly CRACKED_DEEPSLATE_BRICKS: Internal.Block;
    static readonly WHITE_WOOL: Internal.Block;
    static readonly GREEN_WALL_BANNER: Internal.WallBannerBlock;
    static readonly GRAY_CARPET: Internal.WoolCarpetBlock;
    static readonly BLACK_BANNER: Internal.BannerBlock;
    static readonly TUBE_CORAL: Internal.CoralPlantBlock;
    static readonly JUNGLE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly CUT_SANDSTONE: Internal.Block;
    static readonly POLISHED_GRANITE: Internal.Block;
    static readonly DARK_OAK_LOG: Internal.RotatedPillarBlock;
    static readonly SKELETON_WALL_SKULL: Internal.WallSkullBlock;
    static readonly TALL_GRASS: Internal.DoublePlantBlock;
    static readonly POTTED_JUNGLE_SAPLING: Internal.FlowerPotBlock;
    static readonly YELLOW_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly PEARLESCENT_FROGLIGHT: Internal.RotatedPillarBlock;
    static readonly DARK_OAK_FENCE_GATE: Internal.FenceGateBlock;
    static readonly MAGENTA_WOOL: Internal.Block;
    static readonly PUMPKIN_STEM: Internal.StemBlock;
    static readonly MUD: Internal.MudBlock;
    static readonly GRINDSTONE: Internal.GrindstoneBlock;
    static readonly LIGHT_BLUE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly BAMBOO_FENCE: Internal.FenceBlock;
    static readonly BLUE_ICE: Internal.HalfTransparentBlock;
    static readonly BROWN_BANNER: Internal.BannerBlock;
    static readonly FLOWERING_AZALEA: Internal.AzaleaBlock;
    static readonly CHERRY_PLANKS: Internal.Block;
    static readonly PACKED_ICE: Internal.Block;
    static readonly ACACIA_SLAB: Internal.SlabBlock;
    static readonly GRAY_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly DARK_OAK_SLAB: Internal.SlabBlock;
    static readonly BLUE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly ORANGE_BANNER: Internal.BannerBlock;
    static readonly BEEHIVE: Internal.BeehiveBlock;
    static readonly PURPLE_CANDLE: Internal.CandleBlock;
    static readonly BLUE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly BLACK_CARPET: Internal.WoolCarpetBlock;
    static readonly WHITE_CANDLE: Internal.CandleBlock;
    static readonly NETHER_GOLD_ORE: Internal.DropExperienceBlock;
    static readonly LODESTONE: Internal.Block;
    static readonly WEEPING_VINES: Internal.WeepingVinesBlock;
    static readonly MAGENTA_CANDLE: Internal.CandleBlock;
    static readonly OAK_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly END_PORTAL: Internal.EndPortalBlock;
    static readonly TINTED_GLASS: Internal.TintedGlassBlock;
    static readonly LIME_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly SKELETON_SKULL: Internal.SkullBlock;
    static readonly LIME_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly END_STONE: Internal.Block;
    static readonly JUNGLE_FENCE_GATE: Internal.FenceGateBlock;
    static readonly TWISTING_VINES: Internal.TwistingVinesBlock;
    static readonly END_PORTAL_FRAME: Internal.EndPortalFrameBlock;
    static readonly CRIMSON_WALL_SIGN: Internal.WallSignBlock;
    static readonly SPRUCE_PLANKS: Internal.Block;
    static readonly POLISHED_GRANITE_SLAB: Internal.SlabBlock;
    static readonly YELLOW_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly SNIFFER_EGG: Internal.SnifferEggBlock;
    static readonly MOSSY_COBBLESTONE_SLAB: Internal.SlabBlock;
    static readonly CHERRY_FENCE_GATE: Internal.FenceGateBlock;
    static readonly ORANGE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly LIGHT_BLUE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly ACACIA_LEAVES: Internal.LeavesBlock;
    static readonly GRAY_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly GRAY_BANNER: Internal.BannerBlock;
    static readonly BIRCH_SLAB: Internal.SlabBlock;
    static readonly CRACKED_DEEPSLATE_TILES: Internal.Block;
    static readonly HANGING_ROOTS: Internal.HangingRootsBlock;
    static readonly TURTLE_EGG: Internal.TurtleEggBlock;
    static readonly BLACKSTONE_WALL: Internal.WallBlock;
    static readonly SMOOTH_RED_SANDSTONE: Internal.Block;
    static readonly BAMBOO_SAPLING: Internal.BambooSaplingBlock;
    static readonly WAXED_OXIDIZED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static readonly WHITE_BED: Internal.BedBlock;
    static readonly CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly DETECTOR_RAIL: Internal.DetectorRailBlock;
    static readonly COPPER_ORE: Internal.DropExperienceBlock;
    static readonly CAULDRON: Internal.CauldronBlock;
    static readonly LANTERN: Internal.LanternBlock;
    static readonly GLOWSTONE: Internal.Block;
    static readonly YELLOW_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly VOID_AIR: Internal.AirBlock;
    static readonly PURPUR_BLOCK: Internal.Block;
    static readonly INFESTED_STONE: Internal.InfestedBlock;
    static readonly CHAIN: Internal.ChainBlock;
    static readonly STRIPPED_SPRUCE_LOG: Internal.RotatedPillarBlock;
    static readonly OAK_SIGN: Internal.StandingSignBlock;
    static readonly OAK_DOOR: Internal.DoorBlock;
    static readonly MAGMA_BLOCK: Internal.MagmaBlock;
    static readonly DIORITE_STAIRS: Internal.StairBlock;
    static readonly RED_SANDSTONE_WALL: Internal.WallBlock;
    static readonly LAPIS_ORE: Internal.DropExperienceBlock;
    static readonly SPRUCE_SAPLING: Internal.SaplingBlock;
    static readonly SMOOTH_STONE: Internal.Block;
    static readonly BUBBLE_COLUMN: Internal.BubbleColumnBlock;
    static readonly CANDLE: Internal.CandleBlock;
    static readonly POLISHED_DIORITE: Internal.Block;
    static readonly BIRCH_WOOD: Internal.RotatedPillarBlock;
    static readonly AIR: Internal.AirBlock;
    static readonly AZALEA_LEAVES: Internal.LeavesBlock;
    static readonly WHITE_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly CAVE_AIR: Internal.AirBlock;
    static readonly MOSSY_COBBLESTONE: Internal.Block;
    static readonly OAK_FENCE: Internal.FenceBlock;
    static readonly BAMBOO_SLAB: Internal.SlabBlock;
    static readonly EMERALD_ORE: Internal.DropExperienceBlock;
    static readonly CYAN_WOOL: Internal.Block;
    static readonly BIRCH_PLANKS: Internal.Block;
    static readonly POTTED_ORANGE_TULIP: Internal.FlowerPotBlock;
    static readonly POTTED_WARPED_ROOTS: Internal.FlowerPotBlock;
    static readonly SPRUCE_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly DARK_PRISMARINE_STAIRS: Internal.StairBlock;
    static readonly SMALL_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static readonly SPRUCE_STAIRS: Internal.StairBlock;
    static readonly WITHER_SKELETON_SKULL: Internal.WitherSkullBlock;
    static readonly BUBBLE_CORAL_FAN: Internal.CoralFanBlock;
    static readonly CREEPER_WALL_HEAD: Internal.WallSkullBlock;
    static readonly STRIPPED_OAK_LOG: Internal.RotatedPillarBlock;
    static readonly ACACIA_WOOD: Internal.RotatedPillarBlock;
    static readonly CHAIN_COMMAND_BLOCK: Internal.CommandBlock;
    static readonly PIGLIN_HEAD: Internal.SkullBlock;
    static readonly MANGROVE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly INFESTED_MOSSY_STONE_BRICKS: Internal.InfestedBlock;
    static readonly BROWN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly BLUE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly ACACIA_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly CYAN_CANDLE: Internal.CandleBlock;
    static readonly FLETCHING_TABLE: Internal.FletchingTableBlock;
    static readonly TORCHFLOWER_CROP: Internal.TorchflowerCropBlock;
    static readonly GRAY_CONCRETE: Internal.Block;
    static readonly WARPED_STAIRS: Internal.StairBlock;
    static readonly HORN_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly BROWN_WALL_BANNER: Internal.WallBannerBlock;
    static readonly END_GATEWAY: Internal.EndGatewayBlock;
    static readonly DEEPSLATE_TILE_WALL: Internal.WallBlock;
    static readonly POTTED_ALLIUM: Internal.FlowerPotBlock;
    static readonly COBBLESTONE: Internal.Block;
    static readonly OAK_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly CALCITE: Internal.Block;
    static readonly MANGROVE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly POTTED_OXEYE_DAISY: Internal.FlowerPotBlock;
    static readonly FIRE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly OAK_LOG: Internal.RotatedPillarBlock;
    static readonly STRIPPED_CRIMSON_HYPHAE: Internal.RotatedPillarBlock;
    static readonly BIRCH_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly TERRACOTTA: Internal.Block;
    static readonly JUNGLE_SLAB: Internal.SlabBlock;
    static readonly NETHER_BRICK_WALL: Internal.WallBlock;
    static readonly CYAN_CARPET: Internal.WoolCarpetBlock;
    static readonly BAMBOO_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly END_ROD: Internal.EndRodBlock;
    static readonly LIGHT_BLUE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly SMOOTH_QUARTZ: Internal.Block;
    static readonly PRISMARINE: Internal.Block;
    static readonly SMOOTH_QUARTZ_STAIRS: Internal.StairBlock;
    static readonly NETHER_QUARTZ_ORE: Internal.DropExperienceBlock;
    static readonly MUDDY_MANGROVE_ROOTS: Internal.RotatedPillarBlock;
    static readonly LIGHT_GRAY_CANDLE: Internal.CandleBlock;
    static readonly MANGROVE_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly DEEPSLATE_TILE_SLAB: Internal.SlabBlock;
    static readonly ATTACHED_PUMPKIN_STEM: Internal.AttachedStemBlock;
    static readonly CYAN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly OXIDIZED_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly POLISHED_DEEPSLATE_STAIRS: Internal.StairBlock;
    static readonly POLISHED_BLACKSTONE_BRICK_SLAB: Internal.SlabBlock;
    static readonly POLISHED_DEEPSLATE: Internal.Block;
    static readonly COCOA: Internal.CocoaBlock;
    static readonly JUNGLE_BUTTON: Internal.ButtonBlock;
    static readonly BIRCH_FENCE_GATE: Internal.FenceGateBlock;
    static readonly SPRUCE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly POTTED_RED_MUSHROOM: Internal.FlowerPotBlock;
    static readonly MAGENTA_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly JUNGLE_WOOD: Internal.RotatedPillarBlock;
    static readonly WARPED_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly CRIMSON_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly CHEST: Internal.ChestBlock;
    static readonly SPRUCE_WOOD: Internal.RotatedPillarBlock;
    static readonly PINK_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly BLACKSTONE_SLAB: Internal.SlabBlock;
    static readonly LIME_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly GILDED_BLACKSTONE: Internal.Block;
    static readonly SUNFLOWER: Internal.TallFlowerBlock;
    static readonly ORANGE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly VERDANT_FROGLIGHT: Internal.RotatedPillarBlock;
    static readonly PETRIFIED_OAK_SLAB: Internal.SlabBlock;
    static readonly RED_NETHER_BRICK_STAIRS: Internal.StairBlock;
    static readonly DRIED_KELP_BLOCK: Internal.Block;
    static readonly BONE_BLOCK: Internal.RotatedPillarBlock;
    static readonly WHITE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly POTTED_SPRUCE_SAPLING: Internal.FlowerPotBlock;
    static readonly DEAD_HORN_CORAL: Internal.BaseCoralPlantBlock;
    static readonly BUBBLE_CORAL: Internal.CoralPlantBlock;
    static readonly GREEN_CONCRETE: Internal.Block;
    static readonly CHORUS_FLOWER: Internal.ChorusFlowerBlock;
    static readonly GRAY_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly SMOOTH_SANDSTONE_STAIRS: Internal.StairBlock;
    static readonly RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly YELLOW_BANNER: Internal.BannerBlock;
    static readonly LIGHT_GRAY_TERRACOTTA: Internal.Block;
    static readonly PINK_WOOL: Internal.Block;
    static readonly PINK_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly CYAN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly DARK_OAK_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly POWERED_RAIL: Internal.PoweredRailBlock;
    static readonly LIGHT_BLUE_CANDLE: Internal.CandleBlock;
    static readonly POWDER_SNOW: Internal.PowderSnowBlock;
    static readonly ORANGE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly PINK_BANNER: Internal.BannerBlock;
    static readonly BLACK_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly SPRUCE_FENCE_GATE: Internal.FenceGateBlock;
    static readonly GRAY_WALL_BANNER: Internal.WallBannerBlock;
    static readonly WARPED_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly JIGSAW: Internal.JigsawBlock;
    static readonly WHITE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly SPRUCE_SLAB: Internal.SlabBlock;
    static readonly LIGHT_GRAY_WOOL: Internal.Block;
    static readonly PISTON: Internal.PistonBaseBlock;
    static readonly SMOOTH_RED_SANDSTONE_STAIRS: Internal.StairBlock;
    static readonly CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static readonly DIRT: Internal.Block;
    static readonly BLUE_CONCRETE: Internal.Block;
    static readonly RED_TERRACOTTA: Internal.Block;
    static readonly DEAD_BUBBLE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly OXIDIZED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static readonly TALL_SEAGRASS: Internal.TallSeagrassBlock;
    static readonly CHORUS_PLANT: Internal.ChorusPlantBlock;
    static readonly PINK_CONCRETE: Internal.Block;
    static readonly WHITE_TERRACOTTA: Internal.Block;
    static readonly MOVING_PISTON: Internal.MovingPistonBlock;
    static readonly CHERRY_FENCE: Internal.FenceBlock;
    static readonly MANGROVE_ROOTS: Internal.MangroveRootsBlock;
    static readonly POTTED_ACACIA_SAPLING: Internal.FlowerPotBlock;
    static readonly MANGROVE_PLANKS: Internal.Block;
    static readonly ACACIA_BUTTON: Internal.ButtonBlock;
    static readonly WAXED_OXIDIZED_CUT_COPPER: Internal.Block;
    static readonly BAMBOO_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly RED_BANNER: Internal.BannerBlock;
    static readonly BLUE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly BELL: Internal.BellBlock;
    static readonly MUSHROOM_STEM: Internal.HugeMushroomBlock;
    static readonly EXPOSED_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly CYAN_CONCRETE: Internal.Block;
    static readonly POTTED_CRIMSON_ROOTS: Internal.FlowerPotBlock;
    static readonly GREEN_TERRACOTTA: Internal.Block;
    static readonly CHISELED_QUARTZ_BLOCK: Internal.Block;
    static readonly JUNGLE_LEAVES: Internal.LeavesBlock;
    static readonly FROGSPAWN: Internal.FrogspawnBlock;
    static readonly SOUL_TORCH: Internal.TorchBlock;
    static readonly BOOKSHELF: Internal.Block;
    static readonly WAXED_EXPOSED_COPPER: Internal.Block;
    static readonly CRIMSON_FENCE: Internal.FenceBlock;
    static readonly DIAMOND_BLOCK: Internal.Block;
    static readonly RED_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly CRIMSON_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly SANDSTONE_STAIRS: Internal.StairBlock;
    static readonly MAGENTA_CARPET: Internal.WoolCarpetBlock;
    static readonly STRIPPED_DARK_OAK_WOOD: Internal.RotatedPillarBlock;
    static readonly DEAD_BUBBLE_CORAL_BLOCK: Internal.Block;
    static readonly SPRUCE_WALL_SIGN: Internal.WallSignBlock;
    static readonly BLUE_BANNER: Internal.BannerBlock;
    static readonly STRIPPED_CHERRY_LOG: Internal.RotatedPillarBlock;
    static readonly POLISHED_BLACKSTONE_SLAB: Internal.SlabBlock;
    static readonly CALIBRATED_SCULK_SENSOR: Internal.CalibratedSculkSensorBlock;
    static readonly AMETHYST_BLOCK: Internal.AmethystBlock;
    static readonly STRUCTURE_BLOCK: Internal.StructureBlock;
    static readonly BAMBOO_WALL_SIGN: Internal.WallSignBlock;
    static readonly BRAIN_CORAL_BLOCK: Internal.CoralBlock;
    static readonly BAMBOO_MOSAIC_SLAB: Internal.SlabBlock;
    static readonly STRIPPED_DARK_OAK_LOG: Internal.RotatedPillarBlock;
    static readonly SMOOTH_SANDSTONE: Internal.Block;
    static readonly WAXED_EXPOSED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static readonly BLUE_WOOL: Internal.Block;
    static readonly IRON_BARS: Internal.IronBarsBlock;
    static readonly IRON_BLOCK: Internal.Block;
    static readonly SUSPICIOUS_SAND: Internal.BrushableBlock;
    static readonly HORN_CORAL_BLOCK: Internal.CoralBlock;
    static readonly MAGENTA_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly HONEY_BLOCK: Internal.HoneyBlock;
    static readonly END_STONE_BRICKS: Internal.Block;
    static readonly JACK_O_LANTERN: Internal.CarvedPumpkinBlock;
    static readonly TARGET: Internal.TargetBlock;
    static readonly BRAIN_CORAL: Internal.CoralPlantBlock;
    static readonly DEAD_FIRE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static readonly MOSSY_STONE_BRICK_SLAB: Internal.SlabBlock;
    static readonly BLUE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly WITHER_SKELETON_WALL_SKULL: Internal.WitherWallSkullBlock;
    static readonly CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly BIRCH_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly ROSE_BUSH: Internal.TallFlowerBlock;
    static readonly YELLOW_TERRACOTTA: Internal.Block;
    static readonly LECTERN: Internal.LecternBlock;
    static readonly CRIMSON_FENCE_GATE: Internal.FenceGateBlock;
    static readonly DAMAGED_ANVIL: Internal.AnvilBlock;
    static readonly POLISHED_BLACKSTONE_BUTTON: Internal.ButtonBlock;
    static readonly POLISHED_DIORITE_SLAB: Internal.SlabBlock;
    static readonly HAY_BLOCK: Internal.HayBlock;
    static readonly WARPED_HYPHAE: Internal.RotatedPillarBlock;
    static readonly CHERRY_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static readonly MANGROVE_STAIRS: Internal.StairBlock;
    static readonly WEATHERED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static readonly LIME_BANNER: Internal.BannerBlock;
    static readonly TRIPWIRE_HOOK: Internal.TripWireHookBlock;
    static readonly CLAY: Internal.Block;
    static readonly SNOW: Internal.SnowLayerBlock;
    static readonly WHEAT: Internal.CropBlock;
    static readonly CYAN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly WEATHERED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly BROWN_MUSHROOM: Internal.MushroomBlock;
    static readonly SHROOMLIGHT: Internal.Block;
    static readonly CRIMSON_DOOR: Internal.DoorBlock;
    static readonly PRISMARINE_BRICK_STAIRS: Internal.StairBlock;
    static readonly POPPY: Internal.FlowerBlock;
    static readonly STRUCTURE_VOID: Internal.StructureVoidBlock;
    static readonly ORANGE_BED: Internal.BedBlock;
    static readonly DEEPSLATE_COAL_ORE: Internal.DropExperienceBlock;
    static readonly PURPLE_TERRACOTTA: Internal.Block;
    static readonly CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static readonly REDSTONE_BLOCK: Internal.PoweredBlock;
    static readonly BLACK_CANDLE: Internal.CandleBlock;
    static readonly WAXED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static readonly GREEN_BANNER: Internal.BannerBlock;
    static readonly POTTED_AZALEA: Internal.FlowerPotBlock;
    static readonly LIME_CONCRETE: Internal.Block;
    static readonly BAMBOO_BLOCK: Internal.RotatedPillarBlock;
    static readonly PURPLE_WOOL: Internal.Block;
    static readonly SOUL_FIRE: Internal.SoulFireBlock;
    static readonly CHISELED_NETHER_BRICKS: Internal.Block;
    static readonly CRACKED_POLISHED_BLACKSTONE_BRICKS: Internal.Block;
    static readonly PINK_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly CARTOGRAPHY_TABLE: Internal.CartographyTableBlock;
    static readonly BLACK_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly GREEN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly CYAN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly QUARTZ_BLOCK: Internal.Block;
    static readonly BAMBOO_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly WHITE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly WAXED_WEATHERED_CUT_COPPER: Internal.Block;
    static readonly WARPED_WALL_SIGN: Internal.WallSignBlock;
    static readonly COMPOSTER: Internal.ComposterBlock;
    static readonly DARK_OAK_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly ACACIA_SAPLING: Internal.SaplingBlock;
    static readonly PITCHER_PLANT: Internal.DoublePlantBlock;
    static readonly CHISELED_SANDSTONE: Internal.Block;
    static readonly POTTED_PINK_TULIP: Internal.FlowerPotBlock;
    static readonly LARGE_FERN: Internal.DoublePlantBlock;
    static readonly TNT: Internal.TntBlock;
    static readonly COBBLED_DEEPSLATE_STAIRS: Internal.StairBlock;
    static readonly BRICK_STAIRS: Internal.StairBlock;
    static readonly WARPED_SLAB: Internal.SlabBlock;
    static readonly SMOOTH_QUARTZ_SLAB: Internal.SlabBlock;
    static readonly LAVA_CAULDRON: Internal.LavaCauldronBlock;
    static readonly SCULK_SHRIEKER: Internal.SculkShriekerBlock;
    static readonly BRICK_WALL: Internal.WallBlock;
    static readonly CHISELED_DEEPSLATE: Internal.Block;
    static readonly AZALEA: Internal.AzaleaBlock;
    static readonly SMOOTH_STONE_SLAB: Internal.SlabBlock;
    static readonly JUNGLE_SIGN: Internal.StandingSignBlock;
    static readonly LIME_WOOL: Internal.Block;
    static readonly LIME_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly GREEN_BED: Internal.BedBlock;
    static readonly ACTIVATOR_RAIL: Internal.PoweredRailBlock;
    static readonly SEA_PICKLE: Internal.SeaPickleBlock;
    static readonly PINK_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly BLUE_TERRACOTTA: Internal.Block;
    static readonly WEATHERED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static readonly CRACKED_STONE_BRICKS: Internal.Block;
    static readonly FURNACE: Internal.FurnaceBlock;
    static readonly COBBLESTONE_SLAB: Internal.SlabBlock;
    static readonly MANGROVE_FENCE_GATE: Internal.FenceGateBlock;
    static readonly CHERRY_STAIRS: Internal.StairBlock;
    static readonly BAMBOO_STAIRS: Internal.StairBlock;
    static readonly LIGHT_GRAY_CARPET: Internal.WoolCarpetBlock;
    static readonly MANGROVE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly COBBLESTONE_WALL: Internal.WallBlock;
    static readonly BEDROCK: Internal.Block;
    static readonly BIRCH_LEAVES: Internal.LeavesBlock;
    static readonly PURPLE_BED: Internal.BedBlock;
    static readonly LIME_WALL_BANNER: Internal.WallBannerBlock;
    static readonly RED_SANDSTONE: Internal.Block;
    static readonly GOLD_ORE: Internal.DropExperienceBlock;
    static readonly SCULK: Internal.SculkBlock;
    static readonly ACACIA_SIGN: Internal.StandingSignBlock;
    static readonly COBWEB: Internal.WebBlock;
    static readonly CRIMSON_STEM: Internal.RotatedPillarBlock;
    static readonly PINK_BED: Internal.BedBlock;
    static readonly STRIPPED_ACACIA_LOG: Internal.RotatedPillarBlock;
    static readonly BEE_NEST: Internal.BeehiveBlock;
    static readonly LAVA: Internal.LiquidBlock;
    static readonly POTTED_WARPED_FUNGUS: Internal.FlowerPotBlock;
    static readonly NETHER_WART_BLOCK: Internal.Block;
    static readonly TORCHFLOWER: Internal.FlowerBlock;
    static readonly ATTACHED_MELON_STEM: Internal.AttachedStemBlock;
    static readonly DEEPSLATE_EMERALD_ORE: Internal.DropExperienceBlock;
    static readonly BROWN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly POTTED_DARK_OAK_SAPLING: Internal.FlowerPotBlock;
    static readonly POTTED_FERN: Internal.FlowerPotBlock;
    static readonly PUMPKIN: Internal.PumpkinBlock;
    static readonly EXPOSED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static readonly RED_MUSHROOM: Internal.MushroomBlock;
    static readonly BROWN_TERRACOTTA: Internal.Block;
    static readonly PURPLE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly ORANGE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static readonly RAW_IRON_BLOCK: Internal.Block;
    static readonly WALL_TORCH: Internal.WallTorchBlock;
    static readonly CACTUS: Internal.CactusBlock;
    static readonly FIRE: Internal.FireBlock;
    static readonly SLIME_BLOCK: Internal.SlimeBlock;
    static readonly CHIPPED_ANVIL: Internal.AnvilBlock;
    static readonly QUARTZ_SLAB: Internal.SlabBlock;
    static readonly LIGHT_BLUE_BED: Internal.BedBlock;
    static readonly GREEN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly JUNGLE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly SOUL_SAND: Internal.SoulSandBlock;
    static readonly CUT_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly MAGENTA_CONCRETE: Internal.Block;
    static readonly GRANITE: Internal.Block;
    static readonly LIGHT_GRAY_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static readonly SMOOTH_BASALT: Internal.Block;
    static readonly DEAD_BUSH: Internal.DeadBushBlock;
    static readonly DARK_OAK_LEAVES: Internal.LeavesBlock;
    static readonly SOUL_CAMPFIRE: Internal.CampfireBlock;
    static readonly MAGENTA_BANNER: Internal.BannerBlock;
    static readonly SPRUCE_DOOR: Internal.DoorBlock;
    static readonly CREEPER_HEAD: Internal.SkullBlock;
    static readonly BROWN_CANDLE: Internal.CandleBlock;
    static readonly YELLOW_WALL_BANNER: Internal.WallBannerBlock;
    static readonly DEAD_BUBBLE_CORAL: Internal.BaseCoralPlantBlock;
    static readonly BLUE_CARPET: Internal.WoolCarpetBlock;
    static readonly BRICK_SLAB: Internal.SlabBlock;
    static readonly JUNGLE_DOOR: Internal.DoorBlock;
    static readonly LIME_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly ACACIA_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static readonly MOSSY_STONE_BRICK_WALL: Internal.WallBlock;
    static readonly TUBE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly BROWN_BED: Internal.BedBlock;
    static readonly PURPLE_CARPET: Internal.WoolCarpetBlock;
    static readonly LIGHT_GRAY_WALL_BANNER: Internal.WallBannerBlock;
    static readonly BIG_DRIPLEAF_STEM: Internal.BigDripleafStemBlock;
    static readonly LIME_CARPET: Internal.WoolCarpetBlock;
    static readonly WARPED_FUNGUS: Internal.FungusBlock;
    static readonly WHITE_WALL_BANNER: Internal.WallBannerBlock;
    static readonly DARK_OAK_WOOD: Internal.RotatedPillarBlock;
    static readonly STRIPPED_MANGROVE_WOOD: Internal.RotatedPillarBlock;
    static readonly CRYING_OBSIDIAN: Internal.CryingObsidianBlock;
    static readonly WAXED_WEATHERED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static readonly MAGENTA_TERRACOTTA: Internal.Block;
    static readonly POTTED_TORCHFLOWER: Internal.FlowerPotBlock;
    static readonly STONE_BUTTON: Internal.ButtonBlock;
    static readonly IRON_DOOR: Internal.DoorBlock;
    static readonly TRAPPED_CHEST: Internal.TrappedChestBlock;
    static readonly LIGHT_GRAY_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly OAK_PLANKS: Internal.Block;
    static readonly FLOWERING_AZALEA_LEAVES: Internal.LeavesBlock;
    static readonly POTTED_FLOWERING_AZALEA: Internal.FlowerPotBlock;
    static readonly POLISHED_ANDESITE_STAIRS: Internal.StairBlock;
    static readonly BUBBLE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static readonly ANDESITE_WALL: Internal.WallBlock;
    static readonly YELLOW_CANDLE_CAKE: Internal.CandleCakeBlock;
    static readonly BIRCH_SIGN: Internal.StandingSignBlock;
    static readonly DEEPSLATE_BRICK_WALL: Internal.WallBlock;
    static readonly SMOOTH_RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static readonly BLACKSTONE: Internal.Block;
    static readonly LIGHT_GRAY_BED: Internal.BedBlock;
    static readonly STRIPPED_OAK_WOOD: Internal.RotatedPillarBlock;
    static readonly PINK_PETALS: Internal.PinkPetalsBlock;
    static readonly DIORITE: Internal.Block;
    static readonly SWEET_BERRY_BUSH: Internal.SweetBerryBushBlock;
    static readonly DECORATED_POT: Internal.DecoratedPotBlock;
    static readonly INFESTED_STONE_BRICKS: Internal.InfestedBlock;
    static readonly POTTED_RED_TULIP: Internal.FlowerPotBlock;
    static readonly RED_TULIP: Internal.FlowerBlock;
    static readonly BAMBOO_PLANKS: Internal.Block;
    static readonly BIRCH_BUTTON: Internal.ButtonBlock;
    static readonly JUNGLE_TRAPDOOR: Internal.TrapDoorBlock;
    static readonly GREEN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static readonly BEACON: Internal.BeaconBlock;
    static readonly DEEPSLATE_LAPIS_ORE: Internal.DropExperienceBlock;
    static readonly OAK_STAIRS: Internal.StairBlock;
    static readonly BIRCH_FENCE: Internal.FenceBlock;
    static readonly SANDSTONE: Internal.Block;
    static readonly SNOW_BLOCK: Internal.Block;
    static readonly BLACK_BED: Internal.BedBlock;
    static readonly BROWN_STAINED_GLASS: Internal.StainedGlassBlock;
    static readonly POTTED_DEAD_BUSH: Internal.FlowerPotBlock;
    static readonly STRIPPED_CHERRY_WOOD: Internal.RotatedPillarBlock;
    static readonly GRANITE_STAIRS: Internal.StairBlock;
    static readonly DEEPSLATE: Internal.RotatedPillarBlock;
    static readonly DARK_OAK_BUTTON: Internal.ButtonBlock;
    static readonly WHITE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static readonly DEAD_HORN_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static readonly BAMBOO_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static readonly INFESTED_COBBLESTONE: Internal.InfestedBlock;
}
type Blocks_ = Blocks;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    ruleTestOf(o: any): Internal.RuleTest;
    asRuleTest(): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    (arg0: Internal.BlockState): boolean;
    readonly AIR_ID: ResourceLocation;
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_} | any_;
declare const BlockStatePredicate: BlockStatePredicate;
declare class KMath {
    constructor()
    static v3f(x: number, y: number, z: number): Vec3f;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static m4f(): Matrix4f;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static map(value: number, min0: number, max0: number, min1: number, max1: number): number;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static v3(x: number, y: number, z: number): Vec3d;
    static rad(value: number): number;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    static wrapDegrees(d: number): number;
    static degreesDifference(current: number, target: number): number;
    static m3f(): Matrix3f;
    static clampedLerp(value: number, min: number, max: number): number;
    static approachDegrees(current: number, target: number, speed: number): number;
    static floor(value: number): number;
    static approach(current: number, target: number, speed: number): number;
    static lerp(value: number, min: number, max: number): number;
    static isPowerOfTwo(value: number): boolean;
    static readonly PI: 3.141592653589793;
    static readonly RADIANS_TO_DEGREES: 57.29577951308232;
    static readonly DEGREES_TO_RADIANS: 0.017453292519943295;
    static readonly E: 2.718281828459045;
}
type KMath_ = KMath;
declare class Items {
    constructor()
    static registerItem($$0: ResourceLocation_, $$1: Internal.Item_): Internal.Item;
    static registerBlock($$0: Internal.Block_, ...$$1: Internal.Block_[]): Internal.Item;
    static registerBlock($$0: Internal.Block_, $$1: Internal.Item_): Internal.Item;
    static registerItem($$0: string, $$1: Internal.Item_): Internal.Item;
    static registerBlock($$0: Internal.Block_): Internal.Item;
    static registerItem($$0: Internal.ResourceKey_<Internal.Item>, $$1: Internal.Item_): Internal.Item;
    static registerBlock($$0: Internal.BlockItem_): Internal.Item;
    static readonly POWERED_RAIL: Internal.BlockItem;
    static readonly GUARDIAN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly QUARTZ: Internal.Item;
    static readonly TUBE_CORAL: Internal.BlockItem;
    static readonly TURTLE_EGG: Internal.BlockItem;
    static readonly HANGING_ROOTS: Internal.BlockItem;
    static readonly CYAN_DYE: Internal.DyeItem;
    static readonly WAXED_WEATHERED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly CRACKED_DEEPSLATE_TILES: Internal.BlockItem;
    static readonly OAK_PLANKS: Internal.BlockItem;
    static readonly BLAZE_ROD: Internal.Item;
    static readonly GRASS_BLOCK: Internal.BlockItem;
    static readonly DRIED_KELP: Internal.Item;
    static readonly TURTLE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GRAY_BANNER: Internal.BannerItem;
    static readonly MAGENTA_CONCRETE: Internal.BlockItem;
    static readonly WARPED_FUNGUS: Internal.BlockItem;
    static readonly DEEPSLATE_BRICKS: Internal.BlockItem;
    static readonly BEETROOT: Internal.Item;
    static readonly LIGHT_GRAY_TERRACOTTA: Internal.BlockItem;
    static readonly GRAY_BED: Internal.BedItem;
    static readonly MUDDY_MANGROVE_ROOTS: Internal.BlockItem;
    static readonly OAK_SIGN: Internal.SignItem;
    static readonly ACACIA_LEAVES: Internal.BlockItem;
    static readonly BIRCH_SLAB: Internal.BlockItem;
    static readonly CHAIN: Internal.BlockItem;
    static readonly LIGHT_GRAY_DYE: Internal.DyeItem;
    static readonly STRIPPED_SPRUCE_LOG: Internal.BlockItem;
    static readonly LIGHT_GRAY_CANDLE: Internal.BlockItem;
    static readonly PURPUR_BLOCK: Internal.BlockItem;
    static readonly NETHERITE_LEGGINGS: Internal.ArmorItem;
    static readonly DEBUG_STICK: Internal.DebugStickItem;
    static readonly DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly MUSIC_DISC_CAT: Internal.RecordItem;
    static readonly GOLDEN_SWORD: Internal.SwordItem;
    static readonly VERDANT_FROGLIGHT: Internal.BlockItem;
    static readonly WARPED_NYLIUM: Internal.BlockItem;
    static readonly TIPPED_ARROW: Internal.TippedArrowItem;
    static readonly MILK_BUCKET: Internal.MilkBucketItem;
    static readonly LAPIS_ORE: Internal.BlockItem;
    static readonly WEEPING_VINES: Internal.BlockItem;
    static readonly BLAZE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly TORCHFLOWER: Internal.BlockItem;
    static readonly LODESTONE: Internal.BlockItem;
    static readonly IRON_HELMET: Internal.ArmorItem;
    static readonly MANGROVE_DOOR: Internal.DoubleHighBlockItem;
    static readonly INFESTED_STONE: Internal.BlockItem;
    static readonly OAK_LOG: Internal.BlockItem;
    static readonly SMOOTH_QUARTZ: Internal.BlockItem;
    static readonly BIRCH_STAIRS: Internal.BlockItem;
    static readonly BRUSH: Internal.BrushItem;
    static readonly END_PORTAL_FRAME: Internal.BlockItem;
    static readonly AZURE_BLUET: Internal.BlockItem;
    static readonly NETHER_QUARTZ_ORE: Internal.BlockItem;
    static readonly COBBLESTONE: Internal.BlockItem;
    static readonly DARK_OAK_HANGING_SIGN: Internal.HangingSignItem;
    static readonly SPRUCE_HANGING_SIGN: Internal.HangingSignItem;
    static readonly PUMPKIN: Internal.BlockItem;
    static readonly COBWEB: Internal.BlockItem;
    static readonly YELLOW_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly DARK_OAK_WOOD: Internal.BlockItem;
    static readonly BLUE_CARPET: Internal.BlockItem;
    static readonly CARROT: Internal.ItemNameBlockItem;
    static readonly GOLDEN_BOOTS: Internal.ArmorItem;
    static readonly BLACKSTONE_SLAB: Internal.BlockItem;
    static readonly SUNFLOWER: Internal.DoubleHighBlockItem;
    static readonly COPPER_ORE: Internal.BlockItem;
    static readonly CHEST: Internal.BlockItem;
    static readonly DEAD_HORN_CORAL: Internal.BlockItem;
    static readonly POLISHED_GRANITE_SLAB: Internal.BlockItem;
    static readonly PURPLE_CANDLE: Internal.BlockItem;
    static readonly SKELETON_SKULL: Internal.StandingAndWallBlockItem;
    static readonly RESPAWN_ANCHOR: Internal.BlockItem;
    static readonly BUCKET: Internal.BucketItem;
    static readonly ZOMBIFIED_PIGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GLASS: Internal.BlockItem;
    static readonly BIRCH_CHEST_BOAT: Internal.BoatItem;
    static readonly FIRE_CORAL: Internal.BlockItem;
    static readonly LAVA_BUCKET: Internal.BucketItem;
    static readonly ENDER_PEARL: Internal.EnderpearlItem;
    static readonly DRIED_KELP_BLOCK: Internal.BlockItem;
    static readonly POLISHED_BLACKSTONE_BRICKS: Internal.BlockItem;
    static readonly WILD_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly JUNGLE_SLAB: Internal.BlockItem;
    static readonly BOOKSHELF: Internal.BlockItem;
    static readonly DIAMOND_LEGGINGS: Internal.ArmorItem;
    static readonly COBBLESTONE_WALL: Internal.BlockItem;
    static readonly TWISTING_VINES: Internal.BlockItem;
    static readonly GRINDSTONE: Internal.BlockItem;
    static readonly DARK_OAK_LEAVES: Internal.BlockItem;
    static readonly PHANTOM_MEMBRANE: Internal.Item;
    static readonly BRICK: Internal.Item;
    static readonly ARCHER_POTTERY_SHERD: Internal.Item;
    static readonly JUNGLE_LEAVES: Internal.BlockItem;
    static readonly TINTED_GLASS: Internal.BlockItem;
    static readonly OAK_TRAPDOOR: Internal.BlockItem;
    static readonly GOLD_ORE: Internal.BlockItem;
    static readonly FLOWERING_AZALEA: Internal.BlockItem;
    static readonly POPPED_CHORUS_FRUIT: Internal.Item;
    static readonly PRISMARINE_CRYSTALS: Internal.Item;
    static readonly LAPIS_LAZULI: Internal.Item;
    static readonly SQUID_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly TERRACOTTA: Internal.BlockItem;
    static readonly NETHERITE_INGOT: Internal.Item;
    static readonly DEEPSLATE_EMERALD_ORE: Internal.BlockItem;
    static readonly CHAINMAIL_BOOTS: Internal.ArmorItem;
    static readonly NETHERITE_CHESTPLATE: Internal.ArmorItem;
    static readonly CHICKEN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BEEHIVE: Internal.BlockItem;
    static readonly SPYGLASS: Internal.SpyglassItem;
    static readonly NETHERITE_AXE: Internal.AxeItem;
    static readonly ELDER_GUARDIAN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DARK_OAK_SLAB: Internal.BlockItem;
    static readonly BLUE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly MULE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ORANGE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly DARK_OAK_BUTTON: Internal.BlockItem;
    static readonly FIREWORK_STAR: Internal.FireworkStarItem;
    static readonly SPIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DARK_OAK_LOG: Internal.BlockItem;
    static readonly SKULL_POTTERY_SHERD: Internal.Item;
    static readonly FROG_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DEAD_BRAIN_CORAL_BLOCK: Internal.BlockItem;
    static readonly DIRT: Internal.BlockItem;
    static readonly DARK_OAK_CHEST_BOAT: Internal.BoatItem;
    static readonly WOODEN_SHOVEL: Internal.ShovelItem;
    static readonly GLOWSTONE_DUST: Internal.Item;
    static readonly ITEM_FRAME: Internal.ItemFrameItem;
    static readonly MUSIC_DISC_RELIC: Internal.RecordItem;
    static readonly SANDSTONE: Internal.BlockItem;
    static readonly BIRCH_FENCE: Internal.BlockItem;
    static readonly MOSSY_COBBLESTONE_WALL: Internal.BlockItem;
    static readonly REDSTONE: Internal.ItemNameBlockItem;
    static readonly CARROT_ON_A_STICK: Internal.Item;
    static readonly SOUL_TORCH: Internal.StandingAndWallBlockItem;
    static readonly LIME_CARPET: Internal.BlockItem;
    static readonly MANGROVE_PLANKS: Internal.BlockItem;
    static readonly SUGAR_CANE: Internal.BlockItem;
    static readonly COMMAND_BLOCK_MINECART: Internal.MinecartItem;
    static readonly SMOOTH_SANDSTONE_STAIRS: Internal.BlockItem;
    static readonly CHEST_MINECART: Internal.MinecartItem;
    static readonly DEAD_BUBBLE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly SCUTE: Internal.Item;
    static readonly FEATHER: Internal.Item;
    static readonly JUNGLE_TRAPDOOR: Internal.BlockItem;
    static readonly CUT_SANDSTONE: Internal.BlockItem;
    static readonly CHISELED_QUARTZ_BLOCK: Internal.BlockItem;
    static readonly WHITE_TERRACOTTA: Internal.BlockItem;
    static readonly COPPER_INGOT: Internal.Item;
    static readonly SWEET_BERRIES: Internal.ItemNameBlockItem;
    static readonly GREEN_TERRACOTTA: Internal.BlockItem;
    static readonly BUBBLE_CORAL: Internal.BlockItem;
    static readonly BELL: Internal.BlockItem;
    static readonly WAXED_EXPOSED_COPPER: Internal.BlockItem;
    static readonly WHITE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly PITCHER_POD: Internal.ItemNameBlockItem;
    static readonly BLACK_DYE: Internal.DyeItem;
    static readonly WHITE_WOOL: Internal.BlockItem;
    static readonly DETECTOR_RAIL: Internal.BlockItem;
    static readonly TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly LIME_CONCRETE: Internal.BlockItem;
    static readonly PIGLIN_HEAD: Internal.StandingAndWallBlockItem;
    static readonly CHORUS_FLOWER: Internal.BlockItem;
    static readonly WARPED_HYPHAE: Internal.BlockItem;
    static readonly WARDEN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CHISELED_NETHER_BRICKS: Internal.BlockItem;
    static readonly SNOWBALL: Internal.SnowballItem;
    static readonly LANTERN: Internal.BlockItem;
    static readonly CYAN_CONCRETE_POWDER: Internal.BlockItem;
    static readonly MAP: Internal.EmptyMapItem;
    static readonly WHITE_SHULKER_BOX: Internal.BlockItem;
    static readonly DEEPSLATE_COPPER_ORE: Internal.BlockItem;
    static readonly CUT_STANDSTONE_SLAB: Internal.BlockItem;
    static readonly BLACK_CANDLE: Internal.BlockItem;
    static readonly BLAST_FURNACE: Internal.BlockItem;
    static readonly BIRCH_PLANKS: Internal.BlockItem;
    static readonly QUARTZ_BRICKS: Internal.BlockItem;
    static readonly CYAN_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly IRON_INGOT: Internal.Item;
    static readonly PINK_BANNER: Internal.BannerItem;
    static readonly MAGMA_CUBE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly WHITE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly SMOOTH_RED_SANDSTONE: Internal.BlockItem;
    static readonly TRADER_LLAMA_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly TNT: Internal.BlockItem;
    static readonly OAK_DOOR: Internal.DoubleHighBlockItem;
    static readonly CHERRY_PRESSURE_PLATE: Internal.BlockItem;
    static readonly GREEN_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly CHERRY_FENCE: Internal.BlockItem;
    static readonly YELLOW_BANNER: Internal.BannerItem;
    static readonly ROTTEN_FLESH: Internal.Item;
    static readonly RIB_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly WRITTEN_BOOK: Internal.WrittenBookItem;
    static readonly DISC_FRAGMENT_5: Internal.DiscFragmentItem;
    static readonly SNIFFER_EGG: Internal.BlockItem;
    static readonly MAGENTA_DYE: Internal.DyeItem;
    static readonly CLAY: Internal.BlockItem;
    static readonly CHERRY_PLANKS: Internal.BlockItem;
    static readonly MAGENTA_CONCRETE_POWDER: Internal.BlockItem;
    static readonly CHERRY_FENCE_GATE: Internal.BlockItem;
    static readonly BRAIN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly SPAWNER: Internal.BlockItem;
    static readonly LIME_SHULKER_BOX: Internal.BlockItem;
    static readonly CRIMSON_TRAPDOOR: Internal.BlockItem;
    static readonly NETHERITE_SCRAP: Internal.Item;
    static readonly NETHER_BRICK_SLAB: Internal.BlockItem;
    static readonly STONE: Internal.BlockItem;
    static readonly WITHER_SKELETON_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly AMETHYST_BLOCK: Internal.BlockItem;
    static readonly BIRCH_SAPLING: Internal.BlockItem;
    static readonly JUNGLE_BUTTON: Internal.BlockItem;
    static readonly HOGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ZOGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly LIME_DYE: Internal.DyeItem;
    static readonly IRON_TRAPDOOR: Internal.BlockItem;
    static readonly CHERRY_CHEST_BOAT: Internal.BoatItem;
    static readonly MAGENTA_CANDLE: Internal.BlockItem;
    static readonly PETRIFIED_OAK_SLAB: Internal.BlockItem;
    static readonly PRISMARINE_SHARD: Internal.Item;
    static readonly NETHER_GOLD_ORE: Internal.BlockItem;
    static readonly POLISHED_BASALT: Internal.BlockItem;
    static readonly MANGROVE_STAIRS: Internal.BlockItem;
    static readonly ORANGE_BANNER: Internal.BannerItem;
    static readonly CHERRY_DOOR: Internal.DoubleHighBlockItem;
    static readonly SANDSTONE_WALL: Internal.BlockItem;
    static readonly ORANGE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly ENDER_DRAGON_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly STRIPPED_OAK_LOG: Internal.BlockItem;
    static readonly POLISHED_GRANITE_STAIRS: Internal.BlockItem;
    static readonly DEEPSLATE_GOLD_ORE: Internal.BlockItem;
    static readonly OBSERVER: Internal.BlockItem;
    static readonly GRAY_CONCRETE_POWDER: Internal.BlockItem;
    static readonly DIAMOND_SWORD: Internal.SwordItem;
    static readonly FOX_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CHERRY_STAIRS: Internal.BlockItem;
    static readonly MAGENTA_WOOL: Internal.BlockItem;
    static readonly CALCITE: Internal.BlockItem;
    static readonly PUMPKIN_SEEDS: Internal.ItemNameBlockItem;
    static readonly FERMENTED_SPIDER_EYE: Internal.Item;
    static readonly HEART_POTTERY_SHERD: Internal.Item;
    static readonly PURPLE_CONCRETE: Internal.BlockItem;
    static readonly MUTTON: Internal.Item;
    static readonly PURPLE_STAINED_GLASS: Internal.BlockItem;
    static readonly GOLDEN_PICKAXE: Internal.PickaxeItem;
    static readonly ZOMBIE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly MUSIC_DISC_PIGSTEP: Internal.RecordItem;
    static readonly REDSTONE_TORCH: Internal.StandingAndWallBlockItem;
    static readonly LEATHER_LEGGINGS: Internal.DyeableArmorItem;
    static readonly PIGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly RED_SHULKER_BOX: Internal.BlockItem;
    static readonly COD: Internal.Item;
    static readonly MUSIC_DISC_11: Internal.RecordItem;
    static readonly AZALEA_LEAVES: Internal.BlockItem;
    static readonly NETHER_WART: Internal.ItemNameBlockItem;
    static readonly NAME_TAG: Internal.NameTagItem;
    static readonly CYAN_CARPET: Internal.BlockItem;
    static readonly BAMBOO_TRAPDOOR: Internal.BlockItem;
    static readonly MOSSY_COBBLESTONE: Internal.BlockItem;
    static readonly NETHER_BRICK_WALL: Internal.BlockItem;
    static readonly JACK_O_LANTERN: Internal.BlockItem;
    static readonly JUNGLE_SAPLING: Internal.BlockItem;
    static readonly WARPED_SLAB: Internal.BlockItem;
    static readonly FURNACE: Internal.BlockItem;
    static readonly ACACIA_SLAB: Internal.BlockItem;
    static readonly RED_CONCRETE: Internal.BlockItem;
    static readonly YELLOW_CARPET: Internal.BlockItem;
    static readonly POWDER_SNOW_BUCKET: Internal.SolidBucketItem;
    static readonly BUBBLE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly WHITE_STAINED_GLASS: Internal.BlockItem;
    static readonly BRICK_WALL: Internal.BlockItem;
    static readonly BOOK: Internal.BookItem;
    static readonly RED_STAINED_GLASS: Internal.BlockItem;
    static readonly DARK_PRISMARINE_STAIRS: Internal.BlockItem;
    static readonly LIGHT_BLUE_BANNER: Internal.BannerItem;
    static readonly CRIMSON_BUTTON: Internal.BlockItem;
    static readonly PURPLE_WOOL: Internal.BlockItem;
    static readonly PURPLE_BED: Internal.BedItem;
    static readonly EMERALD_ORE: Internal.BlockItem;
    static readonly BLUE_TERRACOTTA: Internal.BlockItem;
    static readonly CRACKED_STONE_BRICKS: Internal.BlockItem;
    static readonly COD_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DIAMOND: Internal.Item;
    static readonly AZALEA: Internal.BlockItem;
    static readonly JUNGLE_BOAT: Internal.BoatItem;
    static readonly SPRUCE_TRAPDOOR: Internal.BlockItem;
    static readonly MELON_SEEDS: Internal.ItemNameBlockItem;
    static readonly WEATHERED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly CANDLE: Internal.BlockItem;
    static readonly PURPLE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly PILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly MUSIC_DISC_13: Internal.RecordItem;
    static readonly LIGHT_GRAY_CARPET: Internal.BlockItem;
    static readonly BIRCH_WOOD: Internal.BlockItem;
    static readonly FLOWER_POT: Internal.BlockItem;
    static readonly ACACIA_WOOD: Internal.BlockItem;
    static readonly WARPED_FENCE: Internal.BlockItem;
    static readonly CHISELED_POLISHED_BLACKSTONE: Internal.BlockItem;
    static readonly SEA_PICKLE: Internal.BlockItem;
    static readonly LARGE_FERN: Internal.DoubleHighBlockItem;
    static readonly AMETHYST_SHARD: Internal.Item;
    static readonly CHICKEN: Internal.Item;
    static readonly GRAY_CONCRETE: Internal.BlockItem;
    static readonly ACACIA_PRESSURE_PLATE: Internal.BlockItem;
    static readonly TOTEM_OF_UNDYING: Internal.Item;
    static readonly STONE_BRICKS: Internal.BlockItem;
    static readonly GREEN_BED: Internal.BedItem;
    static readonly DROPPER: Internal.BlockItem;
    static readonly LIME_STAINED_GLASS: Internal.BlockItem;
    static readonly KNOWLEDGE_BOOK: Internal.KnowledgeBookItem;
    static readonly LOOM: Internal.BlockItem;
    static readonly LIGHT_BLUE_WOOL: Internal.BlockItem;
    static readonly NETHERITE_BLOCK: Internal.BlockItem;
    static readonly ORANGE_CARPET: Internal.BlockItem;
    static readonly FISHING_ROD: Internal.FishingRodItem;
    static readonly BROWN_DYE: Internal.DyeItem;
    static readonly MEDIUM_AMETHYST_BUD: Internal.BlockItem;
    static readonly ROOTED_DIRT: Internal.BlockItem;
    static readonly SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly WARPED_STEM: Internal.BlockItem;
    static readonly SHEAF_POTTERY_SHERD: Internal.Item;
    static readonly RED_SAND: Internal.BlockItem;
    static readonly END_STONE_BRICK_STAIRS: Internal.BlockItem;
    static readonly SHEARS: Internal.ShearsItem;
    static readonly PANDA_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly POTATO: Internal.ItemNameBlockItem;
    static readonly LAPIS_BLOCK: Internal.BlockItem;
    static readonly COMPOSTER: Internal.BlockItem;
    static readonly NETHERITE_HELMET: Internal.ArmorItem;
    static readonly TROPICAL_FISH: Internal.Item;
    static readonly POTION: Internal.PotionItem;
    static readonly MANGROVE_ROOTS: Internal.BlockItem;
    static readonly JIGSAW: Internal.GameMasterBlockItem;
    static readonly PRISMARINE_BRICK_STAIRS: Internal.BlockItem;
    static readonly TROPICAL_FISH_BUCKET: Internal.MobBucketItem;
    static readonly WARPED_PRESSURE_PLATE: Internal.BlockItem;
    static readonly RED_TERRACOTTA: Internal.BlockItem;
    static readonly BROWN_CARPET: Internal.BlockItem;
    static readonly CRIMSON_HANGING_SIGN: Internal.HangingSignItem;
    static readonly LIGHT_BLUE_CANDLE: Internal.BlockItem;
    static readonly LEATHER_CHESTPLATE: Internal.DyeableArmorItem;
    static readonly RED_BED: Internal.BedItem;
    static readonly STONE_HOE: Internal.HoeItem;
    static readonly JUNGLE_LOG: Internal.BlockItem;
    static readonly GLOW_SQUID_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly EYE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly BROWN_WOOL: Internal.BlockItem;
    static readonly PUFFERFISH_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GLASS_PANE: Internal.BlockItem;
    static readonly CHAINMAIL_LEGGINGS: Internal.ArmorItem;
    static readonly GREEN_WOOL: Internal.BlockItem;
    static readonly BREAD: Internal.Item;
    static readonly COOKED_CHICKEN: Internal.Item;
    static readonly BIRCH_FENCE_GATE: Internal.BlockItem;
    static readonly MANGROVE_TRAPDOOR: Internal.BlockItem;
    static readonly CRIMSON_SLAB: Internal.BlockItem;
    static readonly GOLD_NUGGET: Internal.Item;
    static readonly PHANTOM_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly QUARTZ_STAIRS: Internal.BlockItem;
    static readonly WHITE_CONCRETE: Internal.BlockItem;
    static readonly WAXED_WEATHERED_COPPER: Internal.BlockItem;
    static readonly BLUE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly WHEAT_SEEDS: Internal.ItemNameBlockItem;
    static readonly DEEPSLATE_TILES: Internal.BlockItem;
    static readonly PORKCHOP: Internal.Item;
    static readonly SCAFFOLDING: Internal.ScaffoldingBlockItem;
    static readonly END_ROD: Internal.BlockItem;
    static readonly ANDESITE: Internal.BlockItem;
    static readonly PACKED_MUD: Internal.BlockItem;
    static readonly STONE_BRICK_WALL: Internal.BlockItem;
    static readonly ORANGE_WOOL: Internal.BlockItem;
    static readonly REINFORCED_DEEPSLATE: Internal.BlockItem;
    static readonly ACACIA_FENCE_GATE: Internal.BlockItem;
    static readonly LIGHT_GRAY_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly LILY_OF_THE_VALLEY: Internal.BlockItem;
    static readonly VILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly STONE_SHOVEL: Internal.ShovelItem;
    static readonly PARROT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly WHEAT: Internal.Item;
    static readonly JUNGLE_PLANKS: Internal.BlockItem;
    static readonly BROWN_CONCRETE_POWDER: Internal.BlockItem;
    static readonly POLISHED_DEEPSLATE_SLAB: Internal.BlockItem;
    static readonly DIAMOND_AXE: Internal.AxeItem;
    static readonly WAXED_WEATHERED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly WARPED_PLANKS: Internal.BlockItem;
    static readonly NETHERRACK: Internal.BlockItem;
    static readonly DIAMOND_CHESTPLATE: Internal.ArmorItem;
    static readonly GRAY_WOOL: Internal.BlockItem;
    static readonly COPPER_BLOCK: Internal.BlockItem;
    static readonly WEATHERED_CUT_COPPER: Internal.BlockItem;
    static readonly PURPUR_PILLAR: Internal.BlockItem;
    static readonly STONE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly RED_NETHER_BRICK_STAIRS: Internal.BlockItem;
    static readonly CAKE: Internal.BlockItem;
    static readonly COBBLED_DEEPSLATE: Internal.BlockItem;
    static readonly MANGROVE_FENCE: Internal.BlockItem;
    static readonly FARMLAND: Internal.BlockItem;
    static readonly LIGHT_GRAY_CONCRETE: Internal.BlockItem;
    static readonly NETHERITE_SHOVEL: Internal.ShovelItem;
    static readonly PUMPKIN_PIE: Internal.Item;
    static readonly SHULKER_SHELL: Internal.Item;
    static readonly OAK_LEAVES: Internal.BlockItem;
    static readonly BIRCH_HANGING_SIGN: Internal.HangingSignItem;
    static readonly RABBIT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly LIGHT_WEIGHTED_PRESSURE_PLATE: Internal.BlockItem;
    static readonly APPLE: Internal.Item;
    static readonly DIAMOND_HORSE_ARMOR: Internal.HorseArmorItem;
    static readonly POLISHED_BLACKSTONE_SLAB: Internal.BlockItem;
    static readonly WARPED_ROOTS: Internal.BlockItem;
    static readonly BIRCH_LOG: Internal.BlockItem;
    static readonly ELYTRA: Internal.ElytraItem;
    static readonly WARPED_SIGN: Internal.SignItem;
    static readonly GREEN_CANDLE: Internal.BlockItem;
    static readonly BIRCH_TRAPDOOR: Internal.BlockItem;
    static readonly BEE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly PINK_DYE: Internal.DyeItem;
    static readonly PLAYER_HEAD: Internal.PlayerHeadItem;
    static readonly GLOW_LICHEN: Internal.BlockItem;
    static readonly STONE_STAIRS: Internal.BlockItem;
    static readonly ROSE_BUSH: Internal.DoubleHighBlockItem;
    static readonly GLOW_ITEM_FRAME: Internal.ItemFrameItem;
    static readonly WHITE_TULIP: Internal.BlockItem;
    static readonly JUNGLE_HANGING_SIGN: Internal.HangingSignItem;
    static readonly OBSIDIAN: Internal.BlockItem;
    static readonly BLADE_POTTERY_SHERD: Internal.Item;
    static readonly BROWN_SHULKER_BOX: Internal.BlockItem;
    static readonly EGG: Internal.EggItem;
    static readonly WITCH_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly OXIDIZED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly WAXED_EXPOSED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly OCELOT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly HORN_CORAL_BLOCK: Internal.BlockItem;
    static readonly NETHER_SPROUTS: Internal.BlockItem;
    static readonly MUD_BRICK_SLAB: Internal.BlockItem;
    static readonly DEAD_BRAIN_CORAL: Internal.BlockItem;
    static readonly TALL_GRASS: Internal.DoubleHighBlockItem;
    static readonly BLACK_STAINED_GLASS: Internal.BlockItem;
    static readonly SPIDER_EYE: Internal.Item;
    static readonly FILLED_MAP: Internal.MapItem;
    static readonly MUD_BRICK_STAIRS: Internal.BlockItem;
    static readonly AXOLOTL_BUCKET: Internal.MobBucketItem;
    static readonly ZOMBIE_HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DARK_PRISMARINE_SLAB: Internal.BlockItem;
    static readonly MANGROVE_SIGN: Internal.SignItem;
    static readonly STRIPPED_JUNGLE_WOOD: Internal.BlockItem;
    static readonly MUSHROOM_STEM: Internal.BlockItem;
    static readonly LILAC: Internal.DoubleHighBlockItem;
    static readonly BAMBOO_RAFT: Internal.BoatItem;
    static readonly SUSPICIOUS_STEW: Internal.SuspiciousStewItem;
    static readonly SUSPICIOUS_GRAVEL: Internal.BlockItem;
    static readonly GOLDEN_LEGGINGS: Internal.ArmorItem;
    static readonly IRON_PICKAXE: Internal.PickaxeItem;
    static readonly WAXED_OXIDIZED_CUT_COPPER: Internal.BlockItem;
    static readonly CRACKED_DEEPSLATE_BRICKS: Internal.BlockItem;
    static readonly SHULKER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly LIGHT_GRAY_STAINED_GLASS: Internal.BlockItem;
    static readonly MELON_SLICE: Internal.Item;
    static readonly HONEYCOMB_BLOCK: Internal.BlockItem;
    static readonly POLISHED_DIORITE_STAIRS: Internal.BlockItem;
    static readonly PEARLESCENT_FROGLIGHT: Internal.BlockItem;
    static readonly GOLDEN_CHESTPLATE: Internal.ArmorItem;
    static readonly ANCIENT_DEBRIS: Internal.BlockItem;
    static readonly HOPPER_MINECART: Internal.MinecartItem;
    static readonly MAGMA_CREAM: Internal.Item;
    static readonly ZOMBIE_HEAD: Internal.StandingAndWallBlockItem;
    static readonly POLISHED_GRANITE: Internal.BlockItem;
    static readonly PINK_CONCRETE: Internal.BlockItem;
    static readonly HONEYCOMB: Internal.HoneycombItem;
    static readonly NOTE_BLOCK: Internal.BlockItem;
    static readonly RED_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly FURNACE_MINECART: Internal.MinecartItem;
    static readonly DRAGON_BREATH: Internal.Item;
    static readonly CYAN_CONCRETE: Internal.BlockItem;
    static readonly CRIMSON_PLANKS: Internal.BlockItem;
    static readonly CHORUS_PLANT: Internal.BlockItem;
    static readonly WAXED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly YELLOW_CONCRETE_POWDER: Internal.BlockItem;
    static readonly TURTLE_HELMET: Internal.ArmorItem;
    static readonly DARK_OAK_FENCE_GATE: Internal.BlockItem;
    static readonly COAL_ORE: Internal.BlockItem;
    static readonly COAL: Internal.Item;
    static readonly COAST_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly GRAY_CARPET: Internal.BlockItem;
    static readonly OXIDIZED_CUT_COPPER: Internal.BlockItem;
    static readonly LIGHT_BLUE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly DANGER_POTTERY_SHERD: Internal.Item;
    static readonly SANDSTONE_SLAB: Internal.BlockItem;
    static readonly GREEN_CONCRETE: Internal.BlockItem;
    static readonly BARREL: Internal.BlockItem;
    static readonly RED_SANDSTONE_SLAB: Internal.BlockItem;
    static readonly WHITE_DYE: Internal.DyeItem;
    static readonly ORANGE_DYE: Internal.DyeItem;
    static readonly ENCHANTED_BOOK: Internal.EnchantedBookItem;
    static readonly SOUL_SOIL: Internal.BlockItem;
    static readonly IRON_NUGGET: Internal.Item;
    static readonly ENDERMITE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly NETHERITE_BOOTS: Internal.ArmorItem;
    static readonly LEVER: Internal.BlockItem;
    static readonly COOKED_SALMON: Internal.Item;
    static readonly CAULDRON: Internal.BlockItem;
    static readonly ALLIUM: Internal.BlockItem;
    static readonly JUNGLE_CHEST_BOAT: Internal.BoatItem;
    static readonly EXPLORER_POTTERY_SHERD: Internal.Item;
    static readonly POISONOUS_POTATO: Internal.Item;
    static readonly FLOWER_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly SMOOTH_STONE: Internal.BlockItem;
    static readonly WHITE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly SNORT_POTTERY_SHERD: Internal.Item;
    static readonly BROWN_MUSHROOM_BLOCK: Internal.BlockItem;
    static readonly GHAST_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly NETHER_BRICK_STAIRS: Internal.BlockItem;
    static readonly IRON_SHOVEL: Internal.ShovelItem;
    static readonly AXOLOTL_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ORANGE_STAINED_GLASS: Internal.BlockItem;
    static readonly SEA_LANTERN: Internal.BlockItem;
    static readonly SMOOTH_RED_SANDSTONE_STAIRS: Internal.BlockItem;
    static readonly POLISHED_BLACKSTONE_WALL: Internal.BlockItem;
    static readonly STONE_PICKAXE: Internal.PickaxeItem;
    static readonly LIME_TERRACOTTA: Internal.BlockItem;
    static readonly SHIELD: Internal.ShieldItem;
    static readonly DIORITE_WALL: Internal.BlockItem;
    static readonly STONE_SWORD: Internal.SwordItem;
    static readonly GOLDEN_HOE: Internal.HoeItem;
    static readonly BLACK_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly DIAMOND_ORE: Internal.BlockItem;
    static readonly BLACK_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly LIGHT_GRAY_CONCRETE_POWDER: Internal.BlockItem;
    static readonly LIGHT_BLUE_DYE: Internal.DyeItem;
    static readonly REPEATER: Internal.BlockItem;
    static readonly SPECTRAL_ARROW: Internal.SpectralArrowItem;
    static readonly CHERRY_SLAB: Internal.BlockItem;
    static readonly LEAD: Internal.LeadItem;
    static readonly WHITE_CANDLE: Internal.BlockItem;
    static readonly CHISELED_STONE_BRICKS: Internal.BlockItem;
    static readonly DEAD_TUBE_CORAL: Internal.BlockItem;
    static readonly BROWN_BANNER: Internal.BannerItem;
    static readonly WAXED_OXIDIZED_COPPER: Internal.BlockItem;
    static readonly PINK_WOOL: Internal.BlockItem;
    static readonly BIRCH_BOAT: Internal.BoatItem;
    static readonly BLACK_CARPET: Internal.BlockItem;
    static readonly SPRUCE_FENCE_GATE: Internal.BlockItem;
    static readonly BREWING_STAND: Internal.BlockItem;
    static readonly BIG_DRIPLEAF: Internal.BlockItem;
    static readonly CARVED_PUMPKIN: Internal.BlockItem;
    static readonly OAK_BUTTON: Internal.BlockItem;
    static readonly PINK_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly DIORITE_SLAB: Internal.BlockItem;
    static readonly ACACIA_BOAT: Internal.BoatItem;
    static readonly POLISHED_BLACKSTONE_BRICK_SLAB: Internal.BlockItem;
    static readonly CHERRY_WOOD: Internal.BlockItem;
    static readonly SMOOTH_QUARTZ_STAIRS: Internal.BlockItem;
    static readonly END_STONE: Internal.BlockItem;
    static readonly BLUE_BED: Internal.BedItem;
    static readonly LIGHT: Internal.BlockItem;
    static readonly BONE_BLOCK: Internal.BlockItem;
    static readonly DRIPSTONE_BLOCK: Internal.BlockItem;
    static readonly WET_SPONGE: Internal.BlockItem;
    static readonly FLINT: Internal.Item;
    static readonly INFESTED_CHISELED_STONE_BRICKS: Internal.BlockItem;
    static readonly GRAY_SHULKER_BOX: Internal.BlockItem;
    static readonly YELLOW_CANDLE: Internal.BlockItem;
    static readonly SPRUCE_LEAVES: Internal.BlockItem;
    static readonly MOSSY_COBBLESTONE_SLAB: Internal.BlockItem;
    static readonly HUSK_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly PINK_STAINED_GLASS: Internal.BlockItem;
    static readonly MAGENTA_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly BLUE_ICE: Internal.BlockItem;
    static readonly JUKEBOX: Internal.BlockItem;
    static readonly FIRE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly FIRE_CHARGE: Internal.FireChargeItem;
    static readonly COOKED_MUTTON: Internal.Item;
    static readonly BASALT: Internal.BlockItem;
    static readonly ACACIA_PLANKS: Internal.BlockItem;
    static readonly PIG_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly MUSHROOM_STEW: Internal.BowlFoodItem;
    static readonly PURPLE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly MANGROVE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly HOWL_POTTERY_SHERD: Internal.Item;
    static readonly SMALL_AMETHYST_BUD: Internal.BlockItem;
    static readonly DEAD_HORN_CORAL_BLOCK: Internal.BlockItem;
    static readonly POLISHED_BLACKSTONE_BRICK_WALL: Internal.BlockItem;
    static readonly WEATHERED_COPPER: Internal.BlockItem;
    static readonly RED_WOOL: Internal.BlockItem;
    static readonly MANGROVE_PROPAGULE: Internal.BlockItem;
    static readonly PURPUR_STAIRS: Internal.BlockItem;
    static readonly PAPER: Internal.Item;
    static readonly IRON_HOE: Internal.HoeItem;
    static readonly MAGENTA_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly STICKY_PISTON: Internal.BlockItem;
    static readonly COMPASS: Internal.CompassItem;
    static readonly RED_SANDSTONE_WALL: Internal.BlockItem;
    static readonly DARK_PRISMARINE: Internal.BlockItem;
    static readonly DARK_OAK_FENCE: Internal.BlockItem;
    static readonly BAMBOO_BUTTON: Internal.BlockItem;
    static readonly CLAY_BALL: Internal.Item;
    static readonly CYAN_WOOL: Internal.BlockItem;
    static readonly STONECUTTER: Internal.BlockItem;
    static readonly MINECART: Internal.MinecartItem;
    static readonly POLISHED_BLACKSTONE_STAIRS: Internal.BlockItem;
    static readonly RED_CANDLE: Internal.BlockItem;
    static readonly GREEN_STAINED_GLASS: Internal.BlockItem;
    static readonly SHELTER_POTTERY_SHERD: Internal.Item;
    static readonly AIR: Internal.AirItem;
    static readonly SEAGRASS: Internal.BlockItem;
    static readonly GLOWSTONE: Internal.BlockItem;
    static readonly YELLOW_BED: Internal.BedItem;
    static readonly ANVIL: Internal.BlockItem;
    static readonly YELLOW_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly RAW_COPPER_BLOCK: Internal.BlockItem;
    static readonly POLISHED_DIORITE: Internal.BlockItem;
    static readonly DARK_OAK_SIGN: Internal.SignItem;
    static readonly MAGENTA_STAINED_GLASS: Internal.BlockItem;
    static readonly NETHER_BRICKS: Internal.BlockItem;
    static readonly WITHER_SKELETON_SKULL: Internal.StandingAndWallBlockItem;
    static readonly DONKEY_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly STONE_BRICK_STAIRS: Internal.BlockItem;
    static readonly WARPED_DOOR: Internal.DoubleHighBlockItem;
    static readonly WAXED_COPPER_BLOCK: Internal.BlockItem;
    static readonly ENCHANTED_GOLDEN_APPLE: Internal.EnchantedGoldenAppleItem;
    static readonly MANGROVE_CHEST_BOAT: Internal.BoatItem;
    static readonly MUD: Internal.BlockItem;
    static readonly OAK_FENCE: Internal.BlockItem;
    static readonly GOAT_HORN: Internal.InstrumentItem;
    static readonly HOST_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly CAVE_SPIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly QUARTZ_PILLAR: Internal.BlockItem;
    static readonly DEAD_FIRE_CORAL: Internal.BlockItem;
    static readonly SUGAR: Internal.Item;
    static readonly WAXED_EXPOSED_CUT_COPPER: Internal.BlockItem;
    static readonly BROWN_CONCRETE: Internal.BlockItem;
    static readonly SCULK_VEIN: Internal.BlockItem;
    static readonly FLETCHING_TABLE: Internal.BlockItem;
    static readonly INFESTED_MOSSY_STONE_BRICKS: Internal.BlockItem;
    static readonly WARPED_STAIRS: Internal.BlockItem;
    static readonly SPRUCE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly BROWN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly PINK_CANDLE: Internal.BlockItem;
    static readonly STONE_BRICK_SLAB: Internal.BlockItem;
    static readonly PLENTY_POTTERY_SHERD: Internal.Item;
    static readonly RED_CARPET: Internal.BlockItem;
    static readonly CLOCK: Internal.Item;
    static readonly GRAY_TERRACOTTA: Internal.BlockItem;
    static readonly EMERALD: Internal.Item;
    static readonly DEEPSLATE_DIAMOND_ORE: Internal.BlockItem;
    static readonly BIRCH_PRESSURE_PLATE: Internal.BlockItem;
    static readonly BIRCH_DOOR: Internal.DoubleHighBlockItem;
    static readonly BROWN_CANDLE: Internal.BlockItem;
    static readonly KELP: Internal.BlockItem;
    static readonly WITHER_ROSE: Internal.BlockItem;
    static readonly ACACIA_CHEST_BOAT: Internal.BoatItem;
    static readonly TADPOLE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly OAK_HANGING_SIGN: Internal.HangingSignItem;
    static readonly SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly SPRUCE_FENCE: Internal.BlockItem;
    static readonly ORANGE_CONCRETE: Internal.BlockItem;
    static readonly CRAFTING_TABLE: Internal.BlockItem;
    static readonly BAKED_POTATO: Internal.Item;
    static readonly MANGROVE_SLAB: Internal.BlockItem;
    static readonly CYAN_BED: Internal.BedItem;
    static readonly CHISELED_BOOKSHELF: Internal.BlockItem;
    static readonly NAUTILUS_SHELL: Internal.Item;
    static readonly SHULKER_BOX: Internal.BlockItem;
    static readonly STICK: Internal.Item;
    static readonly HEAVY_WEIGHTED_PRESSURE_PLATE: Internal.BlockItem;
    static readonly COARSE_DIRT: Internal.BlockItem;
    static readonly QUARTZ_SLAB: Internal.BlockItem;
    static readonly SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly COBBLED_DEEPSLATE_SLAB: Internal.BlockItem;
    static readonly LIGHTNING_ROD: Internal.BlockItem;
    static readonly ACACIA_FENCE: Internal.BlockItem;
    static readonly POLAR_BEAR_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ACACIA_LOG: Internal.BlockItem;
    static readonly MOJANG_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly DEEPSLATE_REDSTONE_ORE: Internal.BlockItem;
    static readonly INFESTED_STONE_BRICKS: Internal.BlockItem;
    static readonly ENCHANTING_TABLE: Internal.BlockItem;
    static readonly POLISHED_ANDESITE_SLAB: Internal.BlockItem;
    static readonly PURPLE_CONCRETE_POWDER: Internal.BlockItem;
    static readonly PINK_CARPET: Internal.BlockItem;
    static readonly BREWER_POTTERY_SHERD: Internal.Item;
    static readonly DIORITE: Internal.BlockItem;
    static readonly RED_CONCRETE_POWDER: Internal.BlockItem;
    static readonly DARK_OAK_SAPLING: Internal.BlockItem;
    static readonly GRAY_DYE: Internal.DyeItem;
    static readonly LIGHT_GRAY_BED: Internal.BedItem;
    static readonly BAMBOO_SIGN: Internal.SignItem;
    static readonly IRON_ORE: Internal.BlockItem;
    static readonly SCULK_SENSOR: Internal.BlockItem;
    static readonly BUNDLE: Internal.BundleItem;
    static readonly STRING: Internal.ItemNameBlockItem;
    static readonly STRIPPED_JUNGLE_LOG: Internal.BlockItem;
    static readonly END_CRYSTAL: Internal.EndCrystalItem;
    static readonly LEATHER_BOOTS: Internal.DyeableArmorItem;
    static readonly SLIME_BALL: Internal.Item;
    static readonly ORANGE_TERRACOTTA: Internal.BlockItem;
    static readonly DEEPSLATE_IRON_ORE: Internal.BlockItem;
    static readonly BOW: Internal.BowItem;
    static readonly ORANGE_CANDLE: Internal.BlockItem;
    static readonly BLUE_ORCHID: Internal.BlockItem;
    static readonly SPRUCE_BUTTON: Internal.BlockItem;
    static readonly LLAMA_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CAMPFIRE: Internal.BlockItem;
    static readonly LIGHT_BLUE_STAINED_GLASS: Internal.BlockItem;
    static readonly CHERRY_BUTTON: Internal.BlockItem;
    static readonly MAGENTA_TERRACOTTA: Internal.BlockItem;
    static readonly DARK_OAK_STAIRS: Internal.BlockItem;
    static readonly EXPOSED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly BUBBLE_CORAL_BLOCK: Internal.BlockItem;
    static readonly RED_MUSHROOM: Internal.BlockItem;
    static readonly ACACIA_STAIRS: Internal.BlockItem;
    static readonly BLACK_CONCRETE: Internal.BlockItem;
    static readonly SAND: Internal.BlockItem;
    static readonly NETHERITE_HOE: Internal.HoeItem;
    static readonly RED_MUSHROOM_BLOCK: Internal.BlockItem;
    static readonly MYCELIUM: Internal.BlockItem;
    static readonly PINK_TULIP: Internal.BlockItem;
    static readonly PINK_TERRACOTTA: Internal.BlockItem;
    static readonly GOAT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly INFESTED_CRACKED_STONE_BRICKS: Internal.BlockItem;
    static readonly RABBIT: Internal.Item;
    static readonly PRISMARINE_SLAB: Internal.BlockItem;
    static readonly REDSTONE_LAMP: Internal.BlockItem;
    static readonly LIGHT_BLUE_CARPET: Internal.BlockItem;
    static readonly TUBE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly MANGROVE_WOOD: Internal.BlockItem;
    static readonly LIME_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly DARK_OAK_DOOR: Internal.DoubleHighBlockItem;
    static readonly STRIPPED_ACACIA_WOOD: Internal.BlockItem;
    static readonly LIGHT_BLUE_SHULKER_BOX: Internal.BlockItem;
    static readonly ARMOR_STAND: Internal.ArmorStandItem;
    static readonly CHERRY_SAPLING: Internal.BlockItem;
    static readonly BROWN_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly STONE_SLAB: Internal.BlockItem;
    static readonly CHERRY_HANGING_SIGN: Internal.HangingSignItem;
    static readonly MANGROVE_BOAT: Internal.BoatItem;
    static readonly PRISMARINE_WALL: Internal.BlockItem;
    static readonly LIGHT_GRAY_BANNER: Internal.BannerItem;
    static readonly RED_NETHER_BRICK_SLAB: Internal.BlockItem;
    static readonly WAXED_OXIDIZED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly IRON_GOLEM_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CRIMSON_NYLIUM: Internal.BlockItem;
    static readonly FIRE_CORAL_BLOCK: Internal.BlockItem;
    static readonly EXPERIENCE_BOTTLE: Internal.ExperienceBottleItem;
    static readonly POLISHED_BLACKSTONE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly RED_NETHER_BRICKS: Internal.BlockItem;
    static readonly BLACK_CONCRETE_POWDER: Internal.BlockItem;
    static readonly SMITHING_TABLE: Internal.BlockItem;
    static readonly DARK_OAK_TRAPDOOR: Internal.BlockItem;
    static readonly LIGHT_BLUE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly ACACIA_SIGN: Internal.SignItem;
    static readonly YELLOW_STAINED_GLASS: Internal.BlockItem;
    static readonly VEX_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly PIGLIN_BRUTE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GRAY_CANDLE: Internal.BlockItem;
    static readonly COBBLESTONE_STAIRS: Internal.BlockItem;
    static readonly BLAZE_POWDER: Internal.Item;
    static readonly MUSIC_DISC_MALL: Internal.RecordItem;
    static readonly LARGE_AMETHYST_BUD: Internal.BlockItem;
    static readonly BRICKS: Internal.BlockItem;
    static readonly BUDDING_AMETHYST: Internal.BlockItem;
    static readonly RABBIT_FOOT: Internal.Item;
    static readonly BAMBOO_MOSAIC: Internal.BlockItem;
    static readonly MOSSY_COBBLESTONE_STAIRS: Internal.BlockItem;
    static readonly SKULL_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly ACACIA_TRAPDOOR: Internal.BlockItem;
    static readonly BURN_POTTERY_SHERD: Internal.Item;
    static readonly COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static readonly BEACON: Internal.BlockItem;
    static readonly STRIPPED_SPRUCE_WOOD: Internal.BlockItem;
    static readonly OAK_SAPLING: Internal.BlockItem;
    static readonly SMOOTH_SANDSTONE_SLAB: Internal.BlockItem;
    static readonly BIRCH_BUTTON: Internal.BlockItem;
    static readonly STRIPPED_CRIMSON_STEM: Internal.BlockItem;
    static readonly GLOW_INK_SAC: Internal.GlowInkSacItem;
    static readonly CYAN_BANNER: Internal.BannerItem;
    static readonly CAMEL_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly POLISHED_BLACKSTONE: Internal.BlockItem;
    static readonly GRASS: Internal.BlockItem;
    static readonly SMOOTH_RED_SANDSTONE_SLAB: Internal.BlockItem;
    static readonly BROWN_STAINED_GLASS: Internal.BlockItem;
    static readonly MUSIC_DISC_CHIRP: Internal.RecordItem;
    static readonly MUSIC_DISC_FAR: Internal.RecordItem;
    static readonly RED_SANDSTONE_STAIRS: Internal.BlockItem;
    static readonly JUNGLE_STAIRS: Internal.BlockItem;
    static readonly COBBLED_DEEPSLATE_WALL: Internal.BlockItem;
    static readonly BLUE_SHULKER_BOX: Internal.BlockItem;
    static readonly WOODEN_AXE: Internal.AxeItem;
    static readonly SPORE_BLOSSOM: Internal.BlockItem;
    static readonly DEAD_BRAIN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly DEEPSLATE_TILE_STAIRS: Internal.BlockItem;
    static readonly CROSSBOW: Internal.CrossbowItem;
    static readonly BAMBOO_PRESSURE_PLATE: Internal.BlockItem;
    static readonly HORN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly ORANGE_TULIP: Internal.BlockItem;
    static readonly DIAMOND_PICKAXE: Internal.PickaxeItem;
    static readonly GREEN_CARPET: Internal.BlockItem;
    static readonly SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly OXIDIZED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly RABBIT_HIDE: Internal.Item;
    static readonly COOKED_COD: Internal.Item;
    static readonly BLACK_BED: Internal.BedItem;
    static readonly PUFFERFISH: Internal.Item;
    static readonly ENDER_EYE: Internal.EnderEyeItem;
    static readonly INFESTED_COBBLESTONE: Internal.BlockItem;
    static readonly GOLD_INGOT: Internal.Item;
    static readonly VEX_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly STRIPPED_MANGROVE_LOG: Internal.BlockItem;
    static readonly ICE: Internal.BlockItem;
    static readonly BAMBOO_MOSAIC_STAIRS: Internal.BlockItem;
    static readonly BLACK_BANNER: Internal.BannerItem;
    static readonly OAK_CHEST_BOAT: Internal.BoatItem;
    static readonly LIME_BANNER: Internal.BannerItem;
    static readonly PINK_SHULKER_BOX: Internal.BlockItem;
    static readonly SMALL_DRIPLEAF: Internal.DoubleHighBlockItem;
    static readonly LILY_PAD: Internal.PlaceOnWaterBlockItem;
    static readonly CREEPER_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly GLOW_BERRIES: Internal.ItemNameBlockItem;
    static readonly HOPPER: Internal.BlockItem;
    static readonly PUFFERFISH_BUCKET: Internal.MobBucketItem;
    static readonly PURPLE_BANNER: Internal.BannerItem;
    static readonly HAY_BLOCK: Internal.BlockItem;
    static readonly HEART_OF_THE_SEA: Internal.Item;
    static readonly WARD_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly MOSSY_STONE_BRICK_WALL: Internal.BlockItem;
    static readonly EXPOSED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly WARPED_WART_BLOCK: Internal.BlockItem;
    static readonly NETHERITE_SWORD: Internal.SwordItem;
    static readonly SHEEP_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ANGLER_POTTERY_SHERD: Internal.Item;
    static readonly PODZOL: Internal.BlockItem;
    static readonly DIAMOND_HOE: Internal.HoeItem;
    static readonly GRAY_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly YELLOW_SHULKER_BOX: Internal.BlockItem;
    static readonly STRIPPED_WARPED_STEM: Internal.BlockItem;
    static readonly SPRUCE_SIGN: Internal.SignItem;
    static readonly RABBIT_STEW: Internal.BowlFoodItem;
    static readonly DEAD_TUBE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly DECORATED_POT: Internal.BlockItem;
    static readonly OAK_PRESSURE_PLATE: Internal.BlockItem;
    static readonly LIGHT_GRAY_SHULKER_BOX: Internal.BlockItem;
    static readonly CHAINMAIL_HELMET: Internal.ArmorItem;
    static readonly CRACKED_POLISHED_BLACKSTONE_BRICKS: Internal.BlockItem;
    static readonly ACACIA_HANGING_SIGN: Internal.HangingSignItem;
    static readonly LIME_BED: Internal.BedItem;
    static readonly TUFF: Internal.BlockItem;
    static readonly GRAVEL: Internal.BlockItem;
    static readonly BARRIER: Internal.BlockItem;
    static readonly DRAGON_HEAD: Internal.StandingAndWallBlockItem;
    static readonly MUSIC_DISC_MELLOHI: Internal.RecordItem;
    static readonly IRON_DOOR: Internal.DoubleHighBlockItem;
    static readonly BAT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly VINDICATOR_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SMOOTH_BASALT: Internal.BlockItem;
    static readonly LIGHT_GRAY_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly DEAD_HORN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly DROWNED_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly NETHER_STAR: Internal.SimpleFoiledItem;
    static readonly CRIMSON_PRESSURE_PLATE: Internal.BlockItem;
    static readonly FLINT_AND_STEEL: Internal.FlintAndSteelItem;
    static readonly MAGENTA_BED: Internal.BedItem;
    static readonly BONE: Internal.Item;
    static readonly BROWN_TERRACOTTA: Internal.BlockItem;
    static readonly END_STONE_BRICK_SLAB: Internal.BlockItem;
    static readonly CALIBRATED_SCULK_SENSOR: Internal.BlockItem;
    static readonly COMPARATOR: Internal.BlockItem;
    static readonly LEATHER_HORSE_ARMOR: Internal.DyeableHorseArmorItem;
    static readonly STRIPPED_BAMBOO_BLOCK: Internal.BlockItem;
    static readonly POLISHED_DIORITE_SLAB: Internal.BlockItem;
    static readonly MUD_BRICK_WALL: Internal.BlockItem;
    static readonly MOSS_BLOCK: Internal.BlockItem;
    static readonly CRIMSON_STAIRS: Internal.BlockItem;
    static readonly CREEPER_HEAD: Internal.StandingAndWallBlockItem;
    static readonly JUNGLE_DOOR: Internal.DoubleHighBlockItem;
    static readonly BLACK_TERRACOTTA: Internal.BlockItem;
    static readonly COOKIE: Internal.Item;
    static readonly GRANITE: Internal.BlockItem;
    static readonly LEATHER: Internal.Item;
    static readonly SALMON_BUCKET: Internal.MobBucketItem;
    static readonly DANDELION: Internal.BlockItem;
    static readonly WARPED_HANGING_SIGN: Internal.HangingSignItem;
    static readonly PRISMARINE_BRICK_SLAB: Internal.BlockItem;
    static readonly RED_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly IRON_HORSE_ARMOR: Internal.HorseArmorItem;
    static readonly IRON_SWORD: Internal.SwordItem;
    static readonly BONE_MEAL: Internal.BoneMealItem;
    static readonly GRAY_STAINED_GLASS: Internal.BlockItem;
    static readonly DEAD_FIRE_CORAL_BLOCK: Internal.BlockItem;
    static readonly POINTED_DRIPSTONE: Internal.BlockItem;
    static readonly PURPUR_SLAB: Internal.BlockItem;
    static readonly BIRCH_LEAVES: Internal.BlockItem;
    static readonly ORANGE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly ALLAY_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly COW_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ARMS_UP_POTTERY_SHERD: Internal.Item;
    static readonly BLUE_WOOL: Internal.BlockItem;
    static readonly LIGHT_BLUE_TERRACOTTA: Internal.BlockItem;
    static readonly MUSIC_DISC_WARD: Internal.RecordItem;
    static readonly PINK_CONCRETE_POWDER: Internal.BlockItem;
    static readonly BLUE_STAINED_GLASS: Internal.BlockItem;
    static readonly ANDESITE_STAIRS: Internal.BlockItem;
    static readonly CHORUS_FRUIT: Internal.ChorusFruitItem;
    static readonly VINE: Internal.BlockItem;
    static readonly COAL_BLOCK: Internal.BlockItem;
    static readonly POLISHED_DEEPSLATE_WALL: Internal.BlockItem;
    static readonly MUSIC_DISC_OTHERSIDE: Internal.RecordItem;
    static readonly MOSSY_STONE_BRICK_STAIRS: Internal.BlockItem;
    static readonly SNOW_GOLEM_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SCULK: Internal.BlockItem;
    static readonly POLISHED_ANDESITE: Internal.BlockItem;
    static readonly JUNGLE_SIGN: Internal.SignItem;
    static readonly COCOA_BEANS: Internal.ItemNameBlockItem;
    static readonly CYAN_STAINED_GLASS: Internal.BlockItem;
    static readonly BAMBOO_FENCE_GATE: Internal.BlockItem;
    static readonly PURPLE_DYE: Internal.DyeItem;
    static readonly CYAN_TERRACOTTA: Internal.BlockItem;
    static readonly BLACKSTONE_STAIRS: Internal.BlockItem;
    static readonly GLOBE_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly SPRUCE_LOG: Internal.BlockItem;
    static readonly TUBE_CORAL_BLOCK: Internal.BlockItem;
    static readonly EXPOSED_CUT_COPPER: Internal.BlockItem;
    static readonly GREEN_SHULKER_BOX: Internal.BlockItem;
    static readonly CONDUIT: Internal.BlockItem;
    static readonly GLISTERING_MELON_SLICE: Internal.Item;
    static readonly RAVAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SKELETON_HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BRAIN_CORAL_BLOCK: Internal.BlockItem;
    static readonly BAMBOO: Internal.BlockItem;
    static readonly COOKED_PORKCHOP: Internal.Item;
    static readonly GOLDEN_SHOVEL: Internal.ShovelItem;
    static readonly CUT_RED_SANDSTONE_SLAB: Internal.BlockItem;
    static readonly MOSSY_STONE_BRICKS: Internal.BlockItem;
    static readonly DIAMOND_HELMET: Internal.ArmorItem;
    static readonly BAMBOO_DOOR: Internal.DoubleHighBlockItem;
    static readonly POLISHED_BLACKSTONE_BRICK_STAIRS: Internal.BlockItem;
    static readonly SMOOTH_STONE_SLAB: Internal.BlockItem;
    static readonly IRON_LEGGINGS: Internal.ArmorItem;
    static readonly SMOKER: Internal.BlockItem;
    static readonly STRIPPED_BIRCH_WOOD: Internal.BlockItem;
    static readonly SPRUCE_BOAT: Internal.BoatItem;
    static readonly MOSS_CARPET: Internal.BlockItem;
    static readonly FIREWORK_ROCKET: Internal.FireworkRocketItem;
    static readonly OCHRE_FROGLIGHT: Internal.BlockItem;
    static readonly CHISELED_DEEPSLATE: Internal.BlockItem;
    static readonly CHERRY_LEAVES: Internal.BlockItem;
    static readonly NETHER_BRICK_FENCE: Internal.BlockItem;
    static readonly CHISELED_RED_SANDSTONE: Internal.BlockItem;
    static readonly TADPOLE_BUCKET: Internal.MobBucketItem;
    static readonly DRAGON_EGG: Internal.BlockItem;
    static readonly PRIZE_POTTERY_SHERD: Internal.Item;
    static readonly DARK_OAK_PLANKS: Internal.BlockItem;
    static readonly COOKED_RABBIT: Internal.Item;
    static readonly CHERRY_BOAT: Internal.BoatItem;
    static readonly END_STONE_BRICK_WALL: Internal.BlockItem;
    static readonly GREEN_DYE: Internal.DyeItem;
    static readonly MUSIC_DISC_WAIT: Internal.RecordItem;
    static readonly RED_NETHER_BRICK_WALL: Internal.BlockItem;
    static readonly PITCHER_PLANT: Internal.BlockItem;
    static readonly LIME_CONCRETE_POWDER: Internal.BlockItem;
    static readonly PRISMARINE_STAIRS: Internal.BlockItem;
    static readonly MANGROVE_BUTTON: Internal.BlockItem;
    static readonly AMETHYST_CLUSTER: Internal.BlockItem;
    static readonly CHISELED_SANDSTONE: Internal.BlockItem;
    static readonly DEEPSLATE_COAL_ORE: Internal.BlockItem;
    static readonly STRIPPED_MANGROVE_WOOD: Internal.BlockItem;
    static readonly STONE_BUTTON: Internal.BlockItem;
    static readonly RED_DYE: Internal.DyeItem;
    static readonly SPLASH_POTION: Internal.SplashPotionItem;
    static readonly PURPLE_TERRACOTTA: Internal.BlockItem;
    static readonly STRIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly OXEYE_DAISY: Internal.BlockItem;
    static readonly SPRUCE_SLAB: Internal.BlockItem;
    static readonly PINK_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly STRIPPED_CHERRY_WOOD: Internal.BlockItem;
    static readonly REPEATING_COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static readonly CHERRY_SIGN: Internal.SignItem;
    static readonly CRYING_OBSIDIAN: Internal.BlockItem;
    static readonly RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly CREEPER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BAMBOO_BLOCK: Internal.BlockItem;
    static readonly SCULK_SHRIEKER: Internal.BlockItem;
    static readonly GOLDEN_HORSE_ARMOR: Internal.HorseArmorItem;
    static readonly POLISHED_DEEPSLATE: Internal.BlockItem;
    static readonly YELLOW_CONCRETE: Internal.BlockItem;
    static readonly LIGHT_GRAY_WOOL: Internal.BlockItem;
    static readonly PINK_PETALS: Internal.BlockItem;
    static readonly YELLOW_DYE: Internal.DyeItem;
    static readonly CRIMSON_DOOR: Internal.DoubleHighBlockItem;
    static readonly PURPLE_CARPET: Internal.BlockItem;
    static readonly WITHER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BEETROOT_SOUP: Internal.BowlFoodItem;
    static readonly CRIMSON_ROOTS: Internal.BlockItem;
    static readonly BLACKSTONE: Internal.BlockItem;
    static readonly FLOWERING_AZALEA_LEAVES: Internal.BlockItem;
    static readonly OAK_BOAT: Internal.BoatItem;
    static readonly POLISHED_ANDESITE_STAIRS: Internal.BlockItem;
    static readonly BROWN_BED: Internal.BedItem;
    static readonly BLUE_CANDLE: Internal.BlockItem;
    static readonly STRIPPED_CRIMSON_HYPHAE: Internal.BlockItem;
    static readonly POLISHED_DEEPSLATE_STAIRS: Internal.BlockItem;
    static readonly SPRUCE_WOOD: Internal.BlockItem;
    static readonly BAMBOO_HANGING_SIGN: Internal.HangingSignItem;
    static readonly TARGET: Internal.BlockItem;
    static readonly SOUL_SAND: Internal.BlockItem;
    static readonly DAYLIGHT_DETECTOR: Internal.BlockItem;
    static readonly MOOSHROOM_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly LIGHT_BLUE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly PRISMARINE_BRICKS: Internal.BlockItem;
    static readonly DAMAGED_ANVIL: Internal.BlockItem;
    static readonly YELLOW_TERRACOTTA: Internal.BlockItem;
    static readonly RAW_IRON_BLOCK: Internal.BlockItem;
    static readonly TROPICAL_FISH_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly BAMBOO_STAIRS: Internal.BlockItem;
    static readonly INK_SAC: Internal.InkSacItem;
    static readonly LINGERING_POTION: Internal.LingeringPotionItem;
    static readonly BRAIN_CORAL: Internal.BlockItem;
    static readonly SPRUCE_DOOR: Internal.DoubleHighBlockItem;
    static readonly GILDED_BLACKSTONE: Internal.BlockItem;
    static readonly PRISMARINE: Internal.BlockItem;
    static readonly SOUL_CAMPFIRE: Internal.BlockItem;
    static readonly LECTERN: Internal.BlockItem;
    static readonly SHROOMLIGHT: Internal.BlockItem;
    static readonly GOLD_BLOCK: Internal.BlockItem;
    static readonly BRICK_SLAB: Internal.BlockItem;
    static readonly MUD_BRICKS: Internal.BlockItem;
    static readonly JUNGLE_FENCE: Internal.BlockItem;
    static readonly SNIFFER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CHERRY_TRAPDOOR: Internal.BlockItem;
    static readonly MANGROVE_LEAVES: Internal.BlockItem;
    static readonly PAINTING: Internal.HangingEntityItem;
    static readonly MANGROVE_HANGING_SIGN: Internal.HangingSignItem;
    static readonly IRON_BLOCK: Internal.BlockItem;
    static readonly ARROW: Internal.ArrowItem;
    static readonly DEAD_BUBBLE_CORAL_BLOCK: Internal.BlockItem;
    static readonly STRIPPED_DARK_OAK_LOG: Internal.BlockItem;
    static readonly WHITE_CARPET: Internal.BlockItem;
    static readonly DIAMOND_BLOCK: Internal.BlockItem;
    static readonly CRIMSON_STEM: Internal.BlockItem;
    static readonly SOUL_LANTERN: Internal.BlockItem;
    static readonly BLUE_BANNER: Internal.BannerItem;
    static readonly WRITABLE_BOOK: Internal.WritableBookItem;
    static readonly PURPLE_SHULKER_BOX: Internal.BlockItem;
    static readonly CUT_RED_SANDSTONE: Internal.BlockItem;
    static readonly LIME_CANDLE: Internal.BlockItem;
    static readonly STRAY_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly STRIPPED_BIRCH_LOG: Internal.BlockItem;
    static readonly DEEPSLATE_TILE_WALL: Internal.BlockItem;
    static readonly SLIME_BLOCK: Internal.BlockItem;
    static readonly NETHER_WART_BLOCK: Internal.BlockItem;
    static readonly DEEPSLATE_TILE_SLAB: Internal.BlockItem;
    static readonly BAMBOO_MOSAIC_SLAB: Internal.BlockItem;
    static readonly END_STONE_BRICKS: Internal.BlockItem;
    static readonly SKELETON_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly CRIMSON_FENCE: Internal.BlockItem;
    static readonly SUSPICIOUS_SAND: Internal.BlockItem;
    static readonly CRACKED_NETHER_BRICKS: Internal.BlockItem;
    static readonly STRUCTURE_BLOCK: Internal.GameMasterBlockItem;
    static readonly CAT_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly IRON_BOOTS: Internal.ArmorItem;
    static readonly STRIPPED_OAK_WOOD: Internal.BlockItem;
    static readonly PISTON: Internal.BlockItem;
    static readonly NETHERITE_UPGRADE_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly DEEPSLATE_BRICK_WALL: Internal.BlockItem;
    static readonly COD_BUCKET: Internal.MobBucketItem;
    static readonly HONEY_BOTTLE: Internal.HoneyBottleItem;
    static readonly EXPOSED_COPPER: Internal.BlockItem;
    static readonly MUSIC_DISC_STRAD: Internal.RecordItem;
    static readonly GREEN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly PINK_BED: Internal.BedItem;
    static readonly LADDER: Internal.BlockItem;
    static readonly SCULK_CATALYST: Internal.BlockItem;
    static readonly BLUE_CONCRETE: Internal.BlockItem;
    static readonly BLUE_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly SNOW_BLOCK: Internal.BlockItem;
    static readonly BAMBOO_CHEST_RAFT: Internal.BoatItem;
    static readonly SALMON: Internal.Item;
    static readonly DISPENSER: Internal.BlockItem;
    static readonly DIAMOND_BOOTS: Internal.ArmorItem;
    static readonly OAK_STAIRS: Internal.BlockItem;
    static readonly RED_BANNER: Internal.BannerItem;
    static readonly IRON_AXE: Internal.AxeItem;
    static readonly DEEPSLATE_LAPIS_ORE: Internal.BlockItem;
    static readonly SILVERFISH_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly ENDERMAN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly GOLDEN_AXE: Internal.AxeItem;
    static readonly OAK_FENCE_GATE: Internal.BlockItem;
    static readonly GRANITE_STAIRS: Internal.BlockItem;
    static readonly CHARCOAL: Internal.Item;
    static readonly WOODEN_PICKAXE: Internal.PickaxeItem;
    static readonly MELON: Internal.BlockItem;
    static readonly ECHO_SHARD: Internal.Item;
    static readonly BAMBOO_PLANKS: Internal.BlockItem;
    static readonly DIRT_PATH: Internal.BlockItem;
    static readonly DEEPSLATE: Internal.BlockItem;
    static readonly WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static readonly WHITE_BED: Internal.BedItem;
    static readonly DIORITE_STAIRS: Internal.BlockItem;
    static readonly MANGROVE_FENCE_GATE: Internal.BlockItem;
    static readonly RECOVERY_COMPASS: Internal.Item;
    static readonly SNOW: Internal.BlockItem;
    static readonly GRAY_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly GHAST_TEAR: Internal.Item;
    static readonly GOLDEN_CARROT: Internal.Item;
    static readonly FERN: Internal.BlockItem;
    static readonly CORNFLOWER: Internal.BlockItem;
    static readonly CHAIN_COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static readonly ZOMBIE_VILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly LIME_STAINED_GLASS_PANE: Internal.BlockItem;
    static readonly JUNGLE_FENCE_GATE: Internal.BlockItem;
    static readonly GREEN_BANNER: Internal.BannerItem;
    static readonly TRIPWIRE_HOOK: Internal.BlockItem;
    static readonly EVOKER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly SALMON_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly DEEPSLATE_BRICK_SLAB: Internal.BlockItem;
    static readonly RAW_GOLD: Internal.Item;
    static readonly BIRCH_SIGN: Internal.SignItem;
    static readonly FROGSPAWN: Internal.PlaceOnWaterBlockItem;
    static readonly SADDLE: Internal.SaddleItem;
    static readonly YELLOW_WOOL: Internal.BlockItem;
    static readonly TRIDENT: Internal.TridentItem;
    static readonly LIGHT_BLUE_CONCRETE: Internal.BlockItem;
    static readonly WARPED_BUTTON: Internal.BlockItem;
    static readonly POLISHED_BLACKSTONE_BUTTON: Internal.BlockItem;
    static readonly SLIME_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly OAK_WOOD: Internal.BlockItem;
    static readonly ENDER_CHEST: Internal.BlockItem;
    static readonly REDSTONE_BLOCK: Internal.BlockItem;
    static readonly ORANGE_BED: Internal.BedItem;
    static readonly CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly WANDERING_TRADER_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly WAXED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly CRIMSON_FENCE_GATE: Internal.BlockItem;
    static readonly WAXED_WEATHERED_CUT_COPPER: Internal.BlockItem;
    static readonly WAXED_OXIDIZED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly QUARTZ_BLOCK: Internal.BlockItem;
    static readonly BAMBOO_SLAB: Internal.BlockItem;
    static readonly RAIL: Internal.BlockItem;
    static readonly EMERALD_BLOCK: Internal.BlockItem;
    static readonly CUT_COPPER: Internal.BlockItem;
    static readonly POPPY: Internal.BlockItem;
    static readonly ACACIA_BUTTON: Internal.BlockItem;
    static readonly ANDESITE_WALL: Internal.BlockItem;
    static readonly LEATHER_HELMET: Internal.DyeableArmorItem;
    static readonly ACACIA_SAPLING: Internal.BlockItem;
    static readonly CARTOGRAPHY_TABLE: Internal.BlockItem;
    static readonly RED_TULIP: Internal.BlockItem;
    static readonly TRAPPED_CHEST: Internal.BlockItem;
    static readonly MANGROVE_LOG: Internal.BlockItem;
    static readonly DARK_OAK_PRESSURE_PLATE: Internal.BlockItem;
    static readonly CHERRY_LOG: Internal.BlockItem;
    static readonly CHIPPED_ANVIL: Internal.BlockItem;
    static readonly MAGMA_BLOCK: Internal.BlockItem;
    static readonly GUNPOWDER: Internal.Item;
    static readonly OXIDIZED_COPPER: Internal.BlockItem;
    static readonly BLACK_SHULKER_BOX: Internal.BlockItem;
    static readonly BLUE_DYE: Internal.DyeItem;
    static readonly PACKED_ICE: Internal.BlockItem;
    static readonly PEONY: Internal.DoubleHighBlockItem;
    static readonly CRIMSON_FUNGUS: Internal.BlockItem;
    static readonly JUNGLE_PRESSURE_PLATE: Internal.BlockItem;
    static readonly JUNGLE_WOOD: Internal.BlockItem;
    static readonly ORANGE_SHULKER_BOX: Internal.BlockItem;
    static readonly BEETROOT_SEEDS: Internal.ItemNameBlockItem;
    static readonly IRON_CHESTPLATE: Internal.ArmorItem;
    static readonly GOLDEN_APPLE: Internal.Item;
    static readonly LIGHT_BLUE_BED: Internal.BedItem;
    static readonly WARPED_TRAPDOOR: Internal.BlockItem;
    static readonly CACTUS: Internal.BlockItem;
    static readonly TORCH: Internal.StandingAndWallBlockItem;
    static readonly GLASS_BOTTLE: Internal.BottleItem;
    static readonly MAGENTA_SHULKER_BOX: Internal.BlockItem;
    static readonly STRUCTURE_VOID: Internal.BlockItem;
    static readonly DEAD_TUBE_CORAL_BLOCK: Internal.BlockItem;
    static readonly GREEN_CONCRETE_POWDER: Internal.BlockItem;
    static readonly MUSIC_DISC_BLOCKS: Internal.RecordItem;
    static readonly COOKED_BEEF: Internal.Item;
    static readonly DIAMOND_SHOVEL: Internal.ShovelItem;
    static readonly WOODEN_SWORD: Internal.SwordItem;
    static readonly CRIMSON_SIGN: Internal.SignItem;
    static readonly NETHER_BRICK: Internal.Item;
    static readonly STONE_AXE: Internal.AxeItem;
    static readonly DEAD_BUSH: Internal.BlockItem;
    static readonly CYAN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static readonly SPRUCE_CHEST_BOAT: Internal.BoatItem;
    static readonly DEEPSLATE_BRICK_STAIRS: Internal.BlockItem;
    static readonly WHITE_BANNER: Internal.BannerItem;
    static readonly GRANITE_SLAB: Internal.BlockItem;
    static readonly MOSSY_STONE_BRICK_SLAB: Internal.BlockItem;
    static readonly OAK_SLAB: Internal.BlockItem;
    static readonly DEAD_BUBBLE_CORAL: Internal.BlockItem;
    static readonly WARPED_FENCE_GATE: Internal.BlockItem;
    static readonly MINER_POTTERY_SHERD: Internal.Item;
    static readonly BROWN_MUSHROOM: Internal.BlockItem;
    static readonly SPRUCE_PLANKS: Internal.BlockItem;
    static readonly WOLF_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly MAGENTA_BANNER: Internal.BannerItem;
    static readonly CYAN_SHULKER_BOX: Internal.BlockItem;
    static readonly WAXED_EXPOSED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static readonly RAW_IRON: Internal.Item;
    static readonly WEATHERED_CUT_COPPER_SLAB: Internal.BlockItem;
    static readonly RED_SANDSTONE: Internal.BlockItem;
    static readonly STRIPPED_DARK_OAK_WOOD: Internal.BlockItem;
    static readonly BAMBOO_FENCE: Internal.BlockItem;
    static readonly INFESTED_DEEPSLATE: Internal.BlockItem;
    static readonly IRON_BARS: Internal.BlockItem;
    static readonly SANDSTONE_STAIRS: Internal.BlockItem;
    static readonly BEDROCK: Internal.BlockItem;
    static readonly MOURNER_POTTERY_SHERD: Internal.Item;
    static readonly STRIPPED_CHERRY_LOG: Internal.BlockItem;
    static readonly TNT_MINECART: Internal.MinecartItem;
    static readonly BEE_NEST: Internal.BlockItem;
    static readonly ACTIVATOR_RAIL: Internal.BlockItem;
    static readonly MUSIC_DISC_5: Internal.RecordItem;
    static readonly DEAD_FIRE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static readonly GOLDEN_HELMET: Internal.ArmorItem;
    static readonly STRIPPED_WARPED_HYPHAE: Internal.BlockItem;
    static readonly MAGENTA_CARPET: Internal.BlockItem;
    static readonly TORCHFLOWER_SEEDS: Internal.ItemNameBlockItem;
    static readonly HONEY_BLOCK: Internal.BlockItem;
    static readonly STRIPPED_ACACIA_LOG: Internal.BlockItem;
    static readonly FRIEND_POTTERY_SHERD: Internal.Item;
    static readonly RAW_GOLD_BLOCK: Internal.BlockItem;
    static readonly WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static readonly SMOOTH_SANDSTONE: Internal.BlockItem;
    static readonly SPRUCE_SAPLING: Internal.BlockItem;
    static readonly DOLPHIN_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly NETHERITE_PICKAXE: Internal.PickaxeItem;
    static readonly GRANITE_WALL: Internal.BlockItem;
    static readonly BRICK_STAIRS: Internal.BlockItem;
    static readonly LIME_WOOL: Internal.BlockItem;
    static readonly CHAINMAIL_CHESTPLATE: Internal.ArmorItem;
    static readonly WOODEN_HOE: Internal.HoeItem;
    static readonly HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static readonly WATER_BUCKET: Internal.BucketItem;
    static readonly SMOOTH_QUARTZ_SLAB: Internal.BlockItem;
    static readonly WAXED_CUT_COPPER: Internal.BlockItem;
    static readonly HORN_CORAL: Internal.BlockItem;
    static readonly BLACKSTONE_WALL: Internal.BlockItem;
    static readonly MUSIC_DISC_STAL: Internal.RecordItem;
    static readonly SPONGE: Internal.BlockItem;
    static readonly PIGLIN_BANNER_PATTERN: Internal.BannerPatternItem;
    static readonly RAW_COPPER: Internal.Item;
    static readonly DARK_OAK_BOAT: Internal.BoatItem;
    static readonly REDSTONE_ORE: Internal.BlockItem;
    static readonly ANDESITE_SLAB: Internal.BlockItem;
    static readonly BOWL: Internal.Item;
    static readonly BLACK_WOOL: Internal.BlockItem;
    static readonly COBBLED_DEEPSLATE_STAIRS: Internal.BlockItem;
    static readonly BEEF: Internal.Item;
    static readonly COBBLESTONE_SLAB: Internal.BlockItem;
    static readonly CYAN_CANDLE: Internal.BlockItem;
    static readonly ACACIA_DOOR: Internal.DoubleHighBlockItem;
    static readonly SPRUCE_STAIRS: Internal.BlockItem;
    static readonly HEARTBREAK_POTTERY_SHERD: Internal.Item;
    static readonly CRIMSON_HYPHAE: Internal.BlockItem;
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor($$0: number, $$1: number, $$2: Internal.SoundEvent_, $$3: Internal.SoundEvent_, $$4: Internal.SoundEvent_, $$5: Internal.SoundEvent_, $$6: Internal.SoundEvent_)
    getVolume(): number;
    getPitch(): number;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    getBreakSound(): Internal.SoundEvent;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    get volume(): number
    get pitch(): number
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get breakSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    static readonly EMPTY: SoundType;
    static readonly SAND: SoundType;
    static readonly DECORATED_POT: SoundType;
    static readonly TUFF: SoundType;
    static readonly GRAVEL: SoundType;
    static readonly SHROOMLIGHT: SoundType;
    static readonly MOSS: SoundType;
    readonly pitch: number;
    static readonly GRASS: SoundType;
    static readonly SOUL_SOIL: SoundType;
    static readonly WEEPING_VINES: SoundType;
    static readonly ANCIENT_DEBRIS: SoundType;
    static readonly SCULK_SENSOR: SoundType;
    static readonly POINTED_DRIPSTONE: SoundType;
    static readonly ROOTED_DIRT: SoundType;
    static readonly FROGSPAWN: SoundType;
    static readonly NETHER_ORE: SoundType;
    static readonly COPPER: SoundType;
    static readonly LANTERN: SoundType;
    static readonly BONE_BLOCK: SoundType;
    static readonly FROGLIGHT: SoundType;
    static readonly SNOW: SoundType;
    static readonly SCULK_VEIN: SoundType;
    static readonly CHERRY_WOOD: SoundType;
    static readonly POLISHED_DEEPSLATE: SoundType;
    static readonly NYLIUM: SoundType;
    static readonly DEEPSLATE: SoundType;
    static readonly SPORE_BLOSSOM: SoundType;
    static readonly BASALT: SoundType;
    static readonly CHERRY_WOOD_HANGING_SIGN: SoundType;
    static readonly SMALL_AMETHYST_BUD: SoundType;
    static readonly CANDLE: SoundType;
    static readonly FLOWERING_AZALEA: SoundType;
    static readonly ANVIL: SoundType;
    static readonly SCAFFOLDING: SoundType;
    static readonly DEEPSLATE_BRICKS: SoundType;
    static readonly CORAL_BLOCK: SoundType;
    static readonly BAMBOO_SAPLING: SoundType;
    static readonly LILY_PAD: SoundType;
    static readonly MOSS_CARPET: SoundType;
    static readonly LADDER: SoundType;
    static readonly LARGE_AMETHYST_BUD: SoundType;
    static readonly GLOW_LICHEN: SoundType;
    static readonly CROP: SoundType;
    static readonly PINK_PETALS: SoundType;
    static readonly AZALEA_LEAVES: SoundType;
    static readonly POWDER_SNOW: SoundType;
    static readonly METAL: SoundType;
    static readonly HONEY_BLOCK: SoundType;
    static readonly NETHER_BRICKS: SoundType;
    static readonly SUSPICIOUS_SAND: SoundType;
    static readonly GILDED_BLACKSTONE: SoundType;
    static readonly HARD_CROP: SoundType;
    static readonly SCULK_CATALYST: SoundType;
    static readonly DEEPSLATE_TILES: SoundType;
    static readonly PACKED_MUD: SoundType;
    static readonly SCULK: SoundType;
    static readonly VINE: SoundType;
    static readonly BAMBOO: SoundType;
    static readonly GLASS: SoundType;
    static readonly DRIPSTONE_BLOCK: SoundType;
    static readonly CHERRY_SAPLING: SoundType;
    static readonly CALCITE: SoundType;
    static readonly MUD_BRICKS: SoundType;
    static readonly STEM: SoundType;
    static readonly BAMBOO_WOOD: SoundType;
    static readonly SOUL_SAND: SoundType;
    static readonly MUD: SoundType;
    static readonly BIG_DRIPLEAF: SoundType;
    static readonly BAMBOO_WOOD_HANGING_SIGN: SoundType;
    static readonly TWISTING_VINES: SoundType;
    static readonly NETHERRACK: SoundType;
    static readonly AMETHYST_CLUSTER: SoundType;
    static readonly SLIME_BLOCK: SoundType;
    static readonly SCULK_SHRIEKER: SoundType;
    static readonly CHAIN: SoundType;
    static readonly WOOD: SoundType;
    static readonly AZALEA: SoundType;
    static readonly MANGROVE_ROOTS: SoundType;
    static readonly CHISELED_BOOKSHELF: SoundType;
    static readonly NETHER_GOLD_ORE: SoundType;
    static readonly CHERRY_LEAVES: SoundType;
    static readonly AMETHYST: SoundType;
    static readonly DECORATED_POT_CRACKED: SoundType;
    static readonly CAVE_VINES: SoundType;
    static readonly SUSPICIOUS_GRAVEL: SoundType;
    static readonly LODESTONE: SoundType;
    readonly volume: number;
    static readonly FUNGUS: SoundType;
    static readonly SMALL_DRIPLEAF: SoundType;
    static readonly HANGING_ROOTS: SoundType;
    static readonly SWEET_BERRY_BUSH: SoundType;
    static readonly NETHER_WOOD: SoundType;
    static readonly NETHER_WART: SoundType;
    static readonly STONE: SoundType;
    static readonly NETHER_WOOD_HANGING_SIGN: SoundType;
    static readonly HANGING_SIGN: SoundType;
    static readonly WET_GRASS: SoundType;
    static readonly NETHERITE_BLOCK: SoundType;
    static readonly MEDIUM_AMETHYST_BUD: SoundType;
    static readonly MUDDY_MANGROVE_ROOTS: SoundType;
    static readonly WOOL: SoundType;
    static readonly ROOTS: SoundType;
    static readonly WART_BLOCK: SoundType;
    static readonly NETHER_SPROUTS: SoundType;
}
type SoundType_ = SoundType;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    static parse(arg0: Internal.CharSequence_): Duration;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    isNegative(): boolean;
    minus(arg0: Duration_): this;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    plusNanos(arg0: number): this;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    isPositive(): boolean;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    toDaysPart(): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    plusHours(arg0: number): this;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    minusMillis(arg0: number): this;
    dividedBy(arg0: Duration_): number;
    abs(): this;
    static ofHours(arg0: number): Duration;
    minusMinutes(arg0: number): this;
    withNanos(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get seconds(): number
    get zero(): boolean
    get positive(): boolean
    get nano(): number
    static readonly ZERO: Duration;
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getNbt(): Internal.CompoundTag;
    getCount(): number;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    getChance(): number;
    isEmpty(): boolean;
    withCount(count: number): this;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    withChance(chance: number): this;
    hasChance(): boolean;
    withRolls(min: number, max: number): this;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get nbt(): Internal.CompoundTag
    get count(): number
    get chance(): number
    get empty(): boolean
    static readonly EMPTY: OutputItem;
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem | any_;
declare class DamageSource {
    constructor($$0: Internal.Holder_<Internal.DamageType>)
    constructor($$0: Internal.Holder_<Internal.DamageType>, $$1: Internal.Entity_, $$2: Internal.Entity_)
    constructor($$0: Internal.Holder_<Internal.DamageType>, $$1: Internal.Entity_)
    constructor($$0: Internal.Holder_<Internal.DamageType>, $$1: Vec3d_)
    getSourcePosition(): Vec3d;
    isIndirect(): boolean;
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    getImmediate(): Internal.Entity;
    getFoodExhaustion(): number;
    getLocalizedDeathMessage($$0: Internal.LivingEntity_): net.minecraft.network.chat.Component;
    sourcePositionRaw(): Vec3d;
    is($$0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    is($$0: Internal.TagKey_<Internal.DamageType>): boolean;
    isCreativePlayer(): boolean;
    type(): Internal.DamageType;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    get sourcePosition(): Vec3d
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
}
type DamageSource_ = DamageSource;
declare class Platform {
    constructor()
    static getMinecraftVersion(): number;
    static getMcVersion(): string;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    static isClientEnvironment(): boolean;
    static isForge(): boolean;
    static isFabric(): boolean;
    static getModVersion(): string;
    static breakpoint(...args: any[]): void;
    static isGeneratingData(): boolean;
    static getMinecraftVersionString(): string;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    get minecraftVersion(): number
    get mcVersion(): string
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get forge(): boolean
    get fabric(): boolean
    get modVersion(): string
    get generatingData(): boolean
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
    get name(): string
}
type Platform_ = Platform;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    rotateY(arg0: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    set(arg0: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    set(arg0: Internal.FloatBuffer_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    z(): number;
    round(): this;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    get(arg0: number): number;
    mul(arg0: number, arg1: number, arg2: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    ceil(arg0: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    negate(): this;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    add(arg0: Internal.Vector3fc_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    ceil(): this;
    div(arg0: number, arg1: Vec3f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    rotateZ(arg0: number): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    floor(): this;
    set(arg0: number[]): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    mulProject(arg0: Internal.Matrix4fc_): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    mul(arg0: Internal.Matrix3x2fc_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    div(arg0: number): this;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    normalize(arg0: number): this;
    normalize(arg0: Vec3f_): this;
    normalize(): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    isFinite(): boolean;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    x(): number;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    absolute(): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateY(arg0: number, arg1: Vec3f_): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    distance(arg0: number, arg1: number, arg2: number): number;
    minComponent(): number;
    set(arg0: Internal.Vector3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    dot(arg0: Internal.Vector3fc_): number;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    rotateX(arg0: number): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    distance(arg0: Internal.Vector3fc_): number;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    max(arg0: Internal.Vector3fc_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    setFromAddress(arg0: number): this;
    get finite(): boolean
    set fromAddress(arg0: number)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    z(): number;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateZ(arg0: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    round(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get(arg0: number): number;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    set(arg0: Internal.Vector4fc_): this;
    negate(arg0: Vec4f_): this;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    getToAddress(arg0: number): Internal.Vector4fc;
    rotateY(arg0: number, arg1: Vec4f_): this;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    length(): number;
    normalize(arg0: number): this;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mul(arg0: number): this;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(): this;
    angle(arg0: Internal.Vector4fc_): number;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    absolute(): this;
    distance(arg0: Internal.Vector4fc_): number;
    mul(arg0: number, arg1: Vec4f_): this;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    isFinite(): boolean;
    normalize(): this;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    minComponent(): number;
    rotateX(arg0: number): this;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    add(arg0: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    set(arg0: number): this;
    mul(arg0: Internal.Matrix4fc_): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get finite(): boolean
    set fromAddress(arg0: number)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: Internal.CustomIngredientImpl;
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: Internal.Ingredient;
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static ceilMod(arg0: number, arg1: number): number;
    static divideExact(arg0: number, arg1: number): number;
    static asin(arg0: number): number;
    static expm1(arg0: number): number;
    static ceil(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static exp(arg0: number): number;
    static clamp(arg0: number, arg1: number, arg2: number): number;
    static copySign(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static ceilDivExact(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static round(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static cos(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static clamp(arg0: number, arg1: number, arg2: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static floorDivExact(arg0: number, arg1: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static ceilDiv(arg0: number, arg1: number): number;
    static tanh(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static pow(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static addExact(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static ceilDiv(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static clamp(arg0: number, arg1: number, arg2: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static random(): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static ceilDiv(arg0: number, arg1: number): number;
    static rint(arg0: number): number;
    static signum(arg0: number): number;
    static absExact(arg0: number): number;
    static log10(arg0: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static ceilMod(arg0: number, arg1: number): number;
    static tan(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static ceilDivExact(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static toRadians(arg0: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static unsignedMultiplyHigh(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static divideExact(arg0: number, arg1: number): number;
    static floorDivExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static cbrt(arg0: number): number;
    static ceilMod(arg0: number, arg1: number): number;
    static clamp(arg0: number, arg1: number, arg2: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static readonly PI: 3.141592653589793;
    static readonly TAU: 6.283185307179586;
    static readonly E: 2.718281828459045;
}
type JavaMath_ = JavaMath;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    l(v: number): Internal.Tag;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    listTag(): Internal.Tag;
    s(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    longTag(v: number): Internal.Tag;
    intTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    la(v: number[]): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTag(v: any): Internal.Tag;
    toTagCompound(v: any): Internal.CompoundTag;
    toTagList(list: any): Internal.ListTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    i(v: number): Internal.Tag;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare interface FluidAmounts {
    readonly MILLIBUCKET: 81;
    readonly MB: 81;
    readonly INGOT: 9000;
    readonly BOTTLE: 27000;
    readonly B: 81000;
    readonly NUGGET: 1000;
    readonly METAL_BLOCK: 81000;
    readonly BUCKET: 81000;
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXnZ(arg0: Matrix3f_): this;
    mapnYnXZ(arg0: Matrix3f_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(arg0: Matrix3f_): this;
    mapnYnZX(): this;
    mapXnYnZ(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    set(arg0: Internal.Matrix3fc_): this;
    m20(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnXnYZ(): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(): this;
    mapnYZnX(arg0: Matrix3f_): this;
    cofactor(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    mapXnZY(arg0: Matrix3f_): this;
    transform(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    mapYnZX(): this;
    mapnXZY(arg0: Matrix3f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    rotateLocalY(arg0: number): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m21(): number;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    isFinite(): boolean;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYX(arg0: Matrix3f_): this;
    mapnYZX(): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    m10(): number;
    mapXnZnY(): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: number): number;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.FloatBuffer_): this;
    mapnZnXnY(arg0: Matrix3f_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    m22(): number;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(): this;
    mapnZnYnX(arg0: Matrix3f_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    m00(): number;
    mapYnZX(arg0: Matrix3f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    identity(): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    setFromAddress(arg0: number): this;
    mapnZnYnX(): this;
    m01(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    m12(): number;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnXZY(): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    negateY(): this;
    toString(arg0: Internal.NumberFormat_): string;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    m12(arg0: number): this;
    clone(): any;
    m01(): number;
    mapnYnZX(arg0: Matrix3f_): this;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    rotateZYX(arg0: Vec3f_): this;
    mapnZnXnY(): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    m02(arg0: number): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnZnXY(arg0: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    negateX(): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mapnZYX(arg0: Matrix3f_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapnXZnY(arg0: Matrix3f_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    invert(arg0: Matrix3f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    transpose(): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    rotateY(arg0: number): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    add(arg0: Internal.Matrix3fc_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapYnXZ(arg0: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    mapYZX(arg0: Matrix3f_): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapYnXnZ(): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapnYXZ(arg0: Matrix3f_): this;
    mapZXY(): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromAddress(arg0: number)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZXY(arg0: Matrix4f_): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    m31(): number;
    setTransposedFromAddress(arg0: number): this;
    mapYXnZ(arg0: Matrix4f_): this;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    getRowColumn(arg0: number, arg1: number): number;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    mapZXY(arg0: Matrix4f_): this;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    mapnYnXnZ(arg0: Matrix4f_): this;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m10(arg0: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapZYnX(): this;
    m33(arg0: number): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    set3x3(arg0: Internal.Matrix3fc_): this;
    invertAffine(arg0: Matrix4f_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    normalize3x3(arg0: Matrix4f_): this;
    m32(): number;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    getScale(arg0: Vec3f_): Vec3f;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    invertFrustum(arg0: Matrix4f_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotationY(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    rotationTowardsXY(arg0: number, arg1: number): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    transpose3x3(arg0: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnZnXnY(): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m33(): number;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    transpose(arg0: Matrix4f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    m22(): number;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapYZnX(): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    m31(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    mapZYX(arg0: Matrix4f_): this;
    set(arg0: Internal.FloatBuffer_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    mapYnZX(arg0: Matrix4f_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    mapnZnXY(): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_): this;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    mapnZXnY(): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    mapnXZY(): this;
    mapnZYnX(arg0: Matrix4f_): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m13(arg0: number): this;
    m12(): number;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYnZX(arg0: Matrix4f_): this;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapXZY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZXY(): this;
    rotateLocalX(arg0: number): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateZYX(arg0: Vec3f_): this;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    mapXZnY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m01(arg0: number): this;
    mapYXnZ(): this;
    m01(): number;
    set(arg0: Internal.Matrix4dc_): this;
    negateY(): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapYZnX(arg0: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnYXnZ(): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    transpose3x3(): this;
    invertOrtho(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    sub4x3(arg0: Matrix4f_): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateLocalY(arg0: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYXZ(): this;
    setFromAddress(arg0: number): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m02(arg0: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    mapnYZnX(arg0: Matrix4f_): this;
    m02(): number;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transpose(): this;
    set(arg0: number[]): this;
    m11(arg0: number): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    cofactor3x3(arg0: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m22(arg0: number): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    mapnZYX(): this;
    invertOrtho(arg0: Matrix4f_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    mapYZX(arg0: Matrix4f_): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    normal(): this;
    m03(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    cofactor3x3(): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    scaling(arg0: Internal.Vector3fc_): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapnYZnX(): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    m23(arg0: number): this;
    m00(arg0: number): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    mapnXZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mapnXnZY(arg0: Matrix4f_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapXZY(arg0: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapZYX(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    mapnXnYnZ(): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapZnYnX(arg0: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    positiveZ(arg0: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    mapnYnZX(): this;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set(arg0: number[], arg1: number): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x3(arg0: Matrix3f_): Matrix3f;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    mapYnZX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnXnYZ(): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setTransposed(arg0: number[], arg1: number): this;
    mapZnXnY(arg0: Matrix4f_): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Matrix4x3fc_): this;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    m03(arg0: number): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    determinant3x3(): number;
    get(arg0: number, arg1: number): number;
    mapnYZX(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invert(): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapYnXnZ(): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    invertFrustum(): this;
    rotateX(arg0: number): this;
    invertAffine(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    mapnYnXnZ(): this;
    identity(): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    mapZXnY(arg0: Matrix4f_): this;
    clone(): any;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    invert(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnYX(): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    properties(): number;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    add4x3(arg0: Internal.Matrix4fc_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    mapnYnXZ(): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnZnXY(arg0: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZnYnX(): this;
    perspectiveFar(): number;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mapnXnZnY(arg0: Matrix4f_): this;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.Quaternionfc_): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXZ(): this;
    mapXnZnY(arg0: Matrix4f_): this;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    determinant(): number;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveFov(): number;
    mapZYnX(arg0: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mapZXY(): this;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    mapnYnZnX(): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    mapnXZnY(arg0: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    m30(): number;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set fromAddress(arg0: number)
    set transposed(arg0: Internal.ByteBuffer_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): net.minecraft.network.chat.Component;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: net.minecraft.network.chat.Component_): boolean;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: net.minecraft.network.chat.Component_[]): Internal.MutableComponent;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<net.minecraft.network.chat.Component>): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: net.minecraft.network.chat.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: Internal.DustParticleOptions;
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: Internal.AABB;
    readonly EMPTY: Internal.AABB;
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace Special {
    type Mod = "ad_astra" | "ae2" | "ae2-emi-crafting" | "agricraft" | "appleskin" | "architectury" | "arsenal" | "artifacts" | "attributefix" | "balm" | "biomesoplenty" | "blue_endless_jankson" | "boatiview" | "bookshelf" | "borderlessmining" | "botarium" | "caffeineconfig" | "cardinal-components" | "cardinal-components-base" | "cardinal-components-block" | "cardinal-components-chunk" | "cardinal-components-entity" | "cardinal-components-item" | "cardinal-components-level" | "cardinal-components-scoreboard" | "cardinal-components-world" | "carryon" | "cc_tweaked_cobalt" | "chat_heads" | "chisel" | "chunk-storage-api-fabric" | "classicpipes" | "cloth-basic-math" | "cloth-config" | "clumps" | "com_akuleshov7_ktoml-core-jvm" | "com_electronwill_night-config_core" | "com_electronwill_night-config_toml" | "com_eliotlash_mclib_mclib" | "com_google_code_findbugs_jsr305" | "com_jcraft_jzlib" | "com_teamresourceful_bytecodecs" | "com_teamresourceful_yabn" | "com_twelvemonkeys_common_common-image" | "com_twelvemonkeys_common_common-io" | "com_twelvemonkeys_common_common-lang" | "com_twelvemonkeys_imageio_imageio-core" | "com_twelvemonkeys_imageio_imageio-metadata" | "com_twelvemonkeys_imageio_imageio-webp" | "comforts" | "computercraft" | "configuration" | "controlling" | "crash_assistant" | "create" | "create_copper_and_zinc" | "createaddition" | "createoreexcavation" | "cryonicconfig" | "datasync_minecraft" | "dripstone_fluid_lib" | "ducky-periphs" | "emi" | "emi_loot" | "emi_ores" | "emiffect" | "emitrades" | "enchantmentsplus" | "enchdesc" | "entity_texture_features" | "entityculling" | "expandability" | "extendedae" | "fabric-api" | "fabric-api-base" | "fabric-api-lookup-api-v1" | "fabric-biome-api-v1" | "fabric-block-api-v1" | "fabric-block-view-api-v2" | "fabric-blockrenderlayer-v1" | "fabric-client-tags-api-v1" | "fabric-command-api-v1" | "fabric-command-api-v2" | "fabric-commands-v0" | "fabric-containers-v0" | "fabric-content-registries-v0" | "fabric-convention-tags-v1" | "fabric-crash-report-info-v1" | "fabric-data-attachment-api-v1" | "fabric-data-generation-api-v1" | "fabric-dimensions-v1" | "fabric-entity-events-v1" | "fabric-events-interaction-v0" | "fabric-events-lifecycle-v0" | "fabric-game-rule-api-v1" | "fabric-item-api-v1" | "fabric-item-group-api-v1" | "fabric-key-binding-api-v1" | "fabric-keybindings-v0" | "fabric-language-kotlin" | "fabric-lifecycle-events-v1" | "fabric-loot-api-v2" | "fabric-loot-tables-v1" | "fabric-message-api-v1" | "fabric-mining-level-api-v1" | "fabric-model-loading-api-v1" | "fabric-models-v0" | "fabric-networking-api-v1" | "fabric-networking-v0" | "fabric-object-builder-api-v1" | "fabric-particles-v1" | "fabric-permissions-api-v0" | "fabric-recipe-api-v1" | "fabric-registry-sync-v0" | "fabric-renderer-api-v1" | "fabric-renderer-indigo" | "fabric-renderer-registries-v1" | "fabric-rendering-data-attachment-v1" | "fabric-rendering-fluids-v1" | "fabric-rendering-v0" | "fabric-rendering-v1" | "fabric-resource-conditions-api-v1" | "fabric-resource-loader-v0" | "fabric-screen-api-v1" | "fabric-screen-handler-api-v1" | "fabric-sound-api-v1" | "fabric-transfer-api-v1" | "fabric-transitive-access-wideners-v1" | "fabricloader" | "factory_blocks" | "farmersdelight" | "ferritecore" | "fiber" | "flywheel" | "forgeconfigapiport" | "ftbchunks" | "ftblibrary" | "ftbteams" | "fzzy_config" | "geckolib" | "glitchcore" | "gravestones" | "here-be-no-dragons" | "hexal" | "hexcassettes" | "hexcasting" | "hexical" | "hexpigmentplus" | "hexsbm" | "hextended" | "hextweaks" | "iceandfire" | "iceberg" | "immediatelyfast" | "indium" | "inline" | "io_github_douira_glsl-transformer" | "io_netty_netty-codec-http" | "io_netty_netty-codec-socks" | "io_netty_netty-handler-proxy" | "iris" | "jade" | "jamlib" | "java" | "javax_annotation_javax_annotation-api" | "javazoom_jlayer" | "jupiter" | "kanos_config" | "kubejs" | "kuma_api" | "lambdynlights" | "lambdynlights_api" | "lib39-core" | "lib39-phantom" | "litematica" | "lithium" | "lootr" | "malilib" | "mantle" | "memoryleakfix" | "milk" | "minecraft" | "mixinextras" | "mixinsquared" | "mixintrace" | "mm" | "modelfix" | "modernfix" | "modmenu" | "molten_metals" | "moonlight" | "moreiotas" | "mousetweaks" | "net_jodah_typetools" | "net_lenni0451_reflect" | "net_peanuuutz_tomlkt_tomlkt-jvm" | "netherportalfix" | "org_anarres_jcpp" | "org_antlr_antlr4-runtime" | "org_apache_httpcomponents_httpmime" | "org_java-websocket_java-websocket" | "org_jblas_jblas" | "org_jetbrains_kotlin_kotlin-reflect" | "org_jetbrains_kotlin_kotlin-stdlib" | "org_jetbrains_kotlin_kotlin-stdlib-jdk7" | "org_jetbrains_kotlin_kotlin-stdlib-jdk8" | "org_jetbrains_kotlinx_atomicfu-jvm" | "org_jetbrains_kotlinx_kotlinx-coroutines-core-jvm" | "org_jetbrains_kotlinx_kotlinx-coroutines-jdk8" | "org_jetbrains_kotlinx_kotlinx-datetime-jvm" | "org_jetbrains_kotlinx_kotlinx-io-bytestring-jvm" | "org_jetbrains_kotlinx_kotlinx-io-core-jvm" | "org_jetbrains_kotlinx_kotlinx-serialization-cbor-jvm" | "org_jetbrains_kotlinx_kotlinx-serialization-core-jvm" | "org_jetbrains_kotlinx_kotlinx-serialization-json-jvm" | "org_joml_joml" | "org_quiltmc_parsers_gson" | "org_quiltmc_parsers_json" | "owo" | "packetfixer" | "patchouli" | "paucal" | "pehkui" | "placeholder-api" | "player-animator" | "pneumonocore" | "polyeng" | "polymorph" | "ponder" | "porting_lib_accessors" | "porting_lib_attributes" | "porting_lib_base" | "porting_lib_brewing" | "porting_lib_client_events" | "porting_lib_common" | "porting_lib_config" | "porting_lib_core" | "porting_lib_data" | "porting_lib_entity" | "porting_lib_extensions" | "porting_lib_fluids" | "porting_lib_gametest" | "porting_lib_gui_utils" | "porting_lib_items" | "porting_lib_lazy_registration" | "porting_lib_loot" | "porting_lib_mixin_extensions" | "porting_lib_model_generators" | "porting_lib_model_loader" | "porting_lib_model_materials" | "porting_lib_models" | "porting_lib_networking" | "porting_lib_obj_loader" | "porting_lib_recipe_book_categories" | "porting_lib_tags" | "porting_lib_tool_actions" | "porting_lib_transfer" | "porting_lib_utility" | "powah" | "pride" | "probejs" | "railways" | "ratatouille" | "reach-entity-attributes" | "reeses-sodium-options" | "registrate-fabric" | "resourcechickens" | "resourcefulconfig" | "resourcefullib" | "rhino" | "rightclickharvest" | "searchables" | "serialization_hooks" | "simplylight" | "skinlayers3d" | "sodium" | "sodium-extra" | "sophisticatedbackpacks" | "sophisticatedcore" | "spark" | "spectrelib" | "spruceui" | "star" | "starlight" | "step-height-entity-attribute" | "tconstruct" | "team_reborn_energy" | "terrablender" | "transition" | "trender" | "trinkets" | "uranus" | "voicechat" | "voicechat_api" | "yet_another_config_lib_v3" | "yumi_commons_collections" | "yumi_commons_core" | "yumi_commons_event" | "zoomify"
    type Ingredient = string;
    type Advancement = "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "ad_astra:recipes/misc/chiseled_moon_stone_bricks" | "minecraft:recipes/redstone/acacia_button" | "minecraft:recipes/decorations/brick_wall" | "ae2:recipes/misc/tools/paintballs_lumen_blue" | "minecraft:recipes/building_blocks/stone_bricks" | "create:recipes/misc/crafting/logistics/gray_table_cloth_clear" | "iceandfire:recipes/tools/dragonsteel_fire_shovel" | "tconstruct:tools/materials_and_you" | "extendedae:recipes/misc/pre_bus" | "biomesoplenty:recipes/redstone/willow_pressure_plate" | "minecraft:recipes/building_blocks/polished_deepslate" | "create:recipes/misc/crafting/logistics/black_table_cloth_clear" | "hexcasting:recipes/tools/trinket" | "ad_astra:recipes/misc/aeronos_door" | "create:recipes/building_blocks/cut_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_locometal_smokebox" | "minecraft:husbandry/allay_deliver_item_to_player" | "minecraft:recipes/combat/leather_helmet" | "ad_astra:recipes/misc/steel_pillar" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab" | "ae2:recipes/misc/misc/tank_sky_stone" | "create:recipes/misc/crafting/logistics/redstone_requester_clear" | "farmersdelight:recipes/cooking/mushroom_rice" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_boiler" | "ae2:recipes/misc/block_cutter/stairs/smooth_quartz_stairs" | "minecraft:recipes/decorations/blast_furnace" | "minecraft:recipes/decorations/ladder" | "minecraft:recipes/decorations/red_nether_brick_wall" | "railways:recipes/combat/dying_existing_cap_light_gray" | "minecraft:recipes/decorations/magenta_stained_glass_pane" | "iceandfire:recipes/tools/copper_shovel" | "create:recipes/misc/crafting/kinetics/mechanical_saw" | "ad_astra:recipes/misc/stonecutting/chiseled_moon_stone_stairs_from_chiseled_moon_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_mangrove_wood" | "hexcasting:recipes/building_blocks/edified_fence_gate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal" | "ad_astra:moon_cheese" | "create:recipes/building_blocks/cut_tuff_from_stone_types_tuff_stonecutting" | "tconstruct:recipes/misc/common/slime/ender/slimeball_from_block" | "create:recipes/building_blocks/small_ochrum_brick_slab_recycling" | "farmersdelight:recipes/food/egg_sandwich" | "create:recipes/misc/smelting/ingot_osmium_compat_mekanism" | "tconstruct:recipes/misc/common/slime/sky/crystal_smelting" | "create:recipes/building_blocks/birch_window" | "create:recipes/building_blocks/cut_deepslate_brick_stairs" | "ae2:recipes/misc/decorative/smooth_quartz_block" | "ad_astra:recipes/misc/stonecutting/moon_stone_brick_slab_from_moon_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/orange_iron_wrapped_locometal" | "minecraft:recipes/decorations/brown_banner" | "tconstruct:recipes/building_blocks/common/materials/hepatizon_block_from_ingots" | "create:recipes/building_blocks/cut_andesite_brick_stairs" | "ad_astra:recipes/misc/jet_suit" | "ae2:recipes/misc/network/cables/dense_smart_fluix_clean" | "hexcasting:recipes/building_blocks/slate_block_from_slates" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_flat_riveted_locometal" | "farmersdelight:recipes/food/melon_juice" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_plated_locometal" | "classicpipes:recipes/copper_fluid_pipe_a" | "create:recipes/misc/crafting/kinetics/rotation_speed_controller" | "railways:recipes/misc/crafting/palettes/wrapping/green_brass_wrapped_locometal" | "farmersdelight:recipes/food/grilled_salmon" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_boiler" | "ae2:recipes/misc/network/parts/import_bus" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "tconstruct:recipes/misc/common/puny_smelting" | "farmersdelight:recipes/decorations/brown_canvas_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_iron_wrapped_locometal" | "biomesoplenty:recipes/building_blocks/cut_orange_sandstone_slab_from_orange_sandstone_stonecutting" | "minecraft:recipes/building_blocks/mangrove_planks" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal" | "ae2:recipes/misc/network/cables/glass_blue" | "create:recipes/building_blocks/small_veridium_brick_slab" | "iceandfire:recipes/combat/frost_troll_leather_chestplate" | "create:recipes/decorations/copper_ladder_from_copper_ingots_stonecutting" | "extendedae:recipes/misc/threshold_level_emitter" | "ae2:recipes/misc/network/parts/annihilation_plane_alt2" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_deepslate_lapis_ore" | "biomesoplenty:recipes/redstone/willow_fence_gate" | "create:recipes/building_blocks/small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "create:recipes/misc/smelting/zinc_ingot_from_ore" | "minecraft:recipes/misc/emerald" | "tconstruct:recipes/misc/common/glass/brown_clear_stained_glass_pane_from_panes" | "biomesoplenty:recipes/building_blocks/umbran_planks" | "ae2:recipes/misc/decorative/quartz_fixture" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/brick_stairs" | "create:recipes/building_blocks/cut_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/decorations/deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_techreborn" | "iceandfire:recipes/combat/dragonarmor_diamond_body" | "computercraft:recipes/redstone/pocket_advanced/computercraft/wireless_modem_advanced" | "create:recipes/building_blocks/scoria_from_stone_types_scoria_stonecutting" | "iceandfire:iceandfire/pixie_wand" | "ad_astra:recipes/space_stations/space_station/earth_orbit_space_station" | "farmersdelight:recipes/decorations/basket" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_brass_wrapped_locometal_boiler" | "biomesoplenty:recipes/decorations/brimstone_cluster" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "create:recipes/misc/crafting/kinetics/light_gray_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/copycat_headstock_link_and_pin" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat_from_other_seat" | "minecraft:recipes/misc/eye_armor_trim_smithing_template_smithing_trim" | "extendedae:recipes/misc/epa_upgrade" | "create:recipes/building_blocks/cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/lime_stained_glass_pane_from_glass_pane" | "ad_astra:recipes/misc/stonecutting/chiseled_permafrost_brick_slab_from_chiseled_permafrost_bricks_stonecutting" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "ad_astra:recipes/misc/stonecutting/venus_pillar_from_venus_stone_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_blasting_deepslate_copper_ore" | "create:recipes/misc/crafting/kinetics/chute" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_copper_wrapped_locometal" | "create:recipes/combat/crafting/appliances/netherite_diving_boots" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_brass_wrapped_locometal" | "iceandfire:recipes/combat/deathworm_gauntlet_red" | "create:recipes/misc/crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "biomesoplenty:recipes/building_blocks/smooth_white_sandstone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_copper_wrapped_locometal_boiler" | "farmersdelight:main/get_rich_soil" | "ae2:recipes/misc/shaped/walls/sky_stone_brick" | "create:recipes/building_blocks/small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "biomesoplenty:recipes/building_blocks/jacaranda_slab" | "minecraft:recipes/building_blocks/smooth_quartz_slab" | "ae2:recipes/misc/shaped/slabs/sky_stone_small_brick" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_smokebox" | "extendedae:recipes/misc/ei_upgrade" | "sophisticatedbackpacks:recipes/misc/advanced_feeding_upgrade" | "minecraft:recipes/building_blocks/end_stone_brick_slab" | "ad_astra:recipes/misc/stonecutting/polished_mars_stone_stairs_from_polished_mars_stone_stonecutting" | "ae2:recipes/misc/network/cells/spatial_components" | "tconstruct:recipes/misc/smeltery/scorched/polished_scorched_stone_stonecutting" | "extendedae:recipes/misc/ex_io_port" | "create:recipes/building_blocks/cut_tuff_brick_wall" | "minecraft:recipes/decorations/polished_deepslate_wall" | "ad_astra:recipes/misc/glacio_stone_stairs" | "create:recipes/building_blocks/granite_from_stone_types_granite_stonecutting" | "tconstruct:foundry/plate_armor" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tiles_from_honeycomb" | "create:recipes/building_blocks/crafting/logistics/brown_postbox" | "create:clockwork_bearing" | "biomesoplenty:recipes/building_blocks/stripped_hellbark_wood" | "tconstruct:world/blood_island" | "tconstruct:recipes/food/gadgets/cake/earth" | "railways:recipes/misc/stonecutting/palettes/cycling/locometal_smokebox" | "minecraft:recipes/decorations/orange_bed" | "railways:recipes/misc/stonecutting/palettes/cycling/slashed_locometal" | "hexcasting:aab_big_cast" | "create:recipes/building_blocks/crafting/logistics/lime_table_cloth" | "minecraft:recipes/decorations/fletching_table" | "ad_astra:recipes/misc/chiseled_venus_stone_stairs" | "biomesoplenty:recipes/building_blocks/empyreal_planks" | "minecraft:recipes/food/cooked_chicken_from_campfire_cooking" | "classicpipes:request_item" | "minecraft:recipes/decorations/brown_bed" | "hexcasting:recipes/misc/dye_colorizer_magenta" | "ad_astra:recipes/misc/polished_moon_stone" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_fire_body" | "minecraft:recipes/food/cooked_mutton_from_smoking" | "minecraft:recipes/building_blocks/deepslate_bricks" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_hoe" | "create:recipes/building_blocks/weathered_copper_shingle_slab_from_weathered_copper_shingles_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_boiler" | "biomesoplenty:recipes/misc/red_dye_from_rose" | "minecraft:recipes/building_blocks/polished_diorite_stairs" | "iceandfire:recipes/misc/ash_to_charcoal" | "create:recipes/building_blocks/cut_diorite_brick_wall" | "minecraft:recipes/building_blocks/dye_brown_bed" | "ae2:main/facade" | "iceandfire:recipes/food/fire_stew" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_stairs_stonecutter" | "tconstruct:recipes/misc/common/glass/lime_clear_stained_glass_pane_from_panes" | "create:recipes/building_blocks/cut_ochrum_wall" | "sophisticatedbackpacks:recipes/misc/deposit_upgrade" | "minecraft:recipes/misc/gold_ingot_from_gold_block" | "create:recipes/building_blocks/crafting/logistics/yellow_table_cloth" | "minecraft:recipes/building_blocks/light_blue_stained_glass" | "ae2:recipes/misc/network/cables/glass_lime" | "ad_astra:recipes/misc/stonecutting/glacio_cobblestone_stairs_from_glacio_cobblestone_stonecutting" | "create:recipes/misc/crafting/kinetics/elevator_pulley" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_locometal_smokebox" | "iceandfire:recipes/combat/deathworm_gauntlet_white" | "create:recipes/misc/crafting/kinetics/portable_fluid_interface" | "create:recipes/misc/crafting/kinetics/wrench" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_lapis_ore" | "create:recipes/misc/crafting/kinetics/rose_quartz_lamp" | "create:recipes/misc/crafting/kinetics/steam_whistle" | "minecraft:recipes/decorations/purple_bed" | "biomesoplenty:recipes/building_blocks/stripped_empyreal_wood" | "farmersdelight:recipes/decorations/pink_hanging_canvas_sign" | "agricraft:recipes/tools/wooden_crop_sticks" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_slashed_locometal" | "ad_astra:recipes/misc/stonecutting/venus_stone_brick_slab_from_venus_stone_bricks_stonecutting" | "ad_astra:recipes/misc/small_white_industrial_lamp" | "create:recipes/building_blocks/crafting/kinetics/pink_seat_from_other_seat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_plated_locometal" | "create:recipes/building_blocks/oxidized_copper_shingle_slab_from_oxidized_copper_shingles_stonecutting" | "minecraft:recipes/decorations/light_gray_glazed_terracotta" | "biomesoplenty:recipes/redstone/dead_button" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_vine" | "iceandfire:recipes/combat/armor_silver_boots" | "farmersdelight:recipes/cooking/rabbit_stew" | "minecraft:recipes/redstone/birch_button" | "minecraft:recipes/building_blocks/quartz_slab" | "railways:recipes/misc/crafting/semaphore" | "ae2:recipes/misc/tools/certus_quartz_pickaxe" | "minecraft:recipes/building_blocks/jungle_wood" | "minecraft:recipes/combat/netherite_chestplate_smithing" | "ad_astra:recipes/misc/stonecutting/chiseled_glacio_stone_slab_from_chiseled_glacio_stone_bricks_stonecutting" | "create:recipes/building_blocks/cut_diorite_brick_stairs" | "ad_astra:recipes/misc/stonecutting/glacio_stone_brick_stairs_from_glacio_stone_bricks_stonecutting" | "tconstruct:recipes/misc/gadgets/slimesling/earth" | "minecraft:recipes/decorations/purple_glazed_terracotta" | "tconstruct:recipes/misc/tables/pattern" | "ad_astra:recipes/misc/ostrum_block" | "minecraft:story/deflect_arrow" | "tconstruct:recipes/building_blocks/common/materials/rose_gold_ingot_from_block" | "ad_astra:recipes/compressing/compressing/steel_plate_from_compressing_steel_blocks" | "create:sturdy_sheet" | "railways:recipes/misc/crafting/palettes/wrapping/green_copper_wrapped_locometal" | "farmersdelight:recipes/cooking/stuffed_pumpkin_block" | "ae2:recipes/misc/tools/paintballs_purple" | "minecraft:recipes/tools/golden_axe" | "create:recipes/misc/blasting/uranium_ingot_compat_modern_industrialization" | "minecraft:husbandry/leash_all_frog_variants" | "create:recipes/misc/crafting/logistics/green_table_cloth_clear" | "create:recipes/building_blocks/cut_limestone_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_andesite_brick_slab" | "create:recipes/building_blocks/cut_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "ad_astra:recipes/misc/small_lime_industrial_lamp" | "biomesoplenty:recipes/building_blocks/brimstone_brick_slab" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "minecraft:recipes/decorations/orange_banner" | "biomesoplenty:recipes/redstone/tnt_from_bop_sand" | "biomesoplenty:recipes/building_blocks/cut_black_sandstone_slab_from_black_sandstone_stonecutting" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_bricks" | "minecraft:recipes/decorations/oak_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_slashed_locometal" | "comforts:rope_and_nail" | "ad_astra:recipes/misc/smelting/ostrum_ingot_from_smelting_deepslate_ostrum_ore" | "minecraft:recipes/building_blocks/red_concrete_powder" | "create:recipes/misc/crafting/kinetics/package_filter" | "tconstruct:recipes/misc/common/glass/green_clear_stained_glass_pane_from_panes" | "ae2:recipes/misc/blasting/silicon_from_certus_quartz_dust" | "iceandfire:recipes/misc/dragon_bone_wall" | "create:recipes/misc/crafting/kinetics/gantry_shaft" | "iceandfire:recipes/combat/dragonsteel_fire_helmet" | "minecraft:recipes/tools/golden_pickaxe" | "extendedae:recipes/misc/precise_storage_bus" | "biomesoplenty:recipes/building_blocks/stripped_magic_wood" | "tconstruct:world/earth_island" | "ad_astra:recipes/misc/orange_industrial_lamp" | "create:recipes/building_blocks/polished_cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:recipes/brewing/magma_cream" | "create:recipes/building_blocks/cut_scoria_stairs" | "create:recipes/building_blocks/crafting/logistics/green_table_cloth" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_plated_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_locometal_pillar" | "create:recipes/building_blocks/cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "iceandfire:recipes/combat/dragonsteel_fire_boots" | "create:recipes/building_blocks/small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "minecraft:nether/brew_potion" | "comforts:sleeping_bag_cyan" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_plated_locometal" | "minecraft:recipes/building_blocks/polished_deepslate_slab" | "create:recipes/misc/crafting/appliances/copper_backtank" | "ae2:recipes/misc/network/blocks/cell_workbench" | "create:recipes/building_blocks/dark_oak_window" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_brick_slab" | "railways:recipes/combat/dying_existing_cap_cyan" | "railways:recipes/misc/crafting/palettes/wrapping/gray_copper_wrapped_locometal" | "iceandfire:recipes/combat/armor_white_leggings" | "minecraft:recipes/building_blocks/quartz_bricks" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "minecraft:recipes/decorations/purple_stained_glass_pane_from_glass_pane" | "create:recipes/building_blocks/polished_cut_crimsite_wall" | "iceandfire:recipes/misc/dragon_ice" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_slab_from_honeycomb" | "ae2:recipes/misc/tools/fluix_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal" | "create:recipes/misc/smelting/lead_ingot_compat_modern_industrialization" | "minecraft:end/dragon_egg" | "ad_astra:recipes/misc/iron_pillar" | "ad_astra:recipes/misc/stonecutting/chiseled_glacio_stone_stairs_from_chiseled_glacio_stone_bricks_stonecutting" | "minecraft:husbandry/fishy_business" | "ae2:recipes/misc/decorative/light_detector" | "minecraft:recipes/building_blocks/lapis_block" | "farmersdelight:recipes/food/steak_and_potatoes" | "ad_astra:recipes/misc/smelting/gold_ingot_from_smelting_venus_gold_ore" | "create:recipes/building_blocks/polished_cut_calcite_slab" | "tconstruct:recipes/food/gadgets/cake/sky" | "ad_astra:recipes/misc/small_orange_industrial_lamp" | "agricraft:recipes/tools/iron_crop_sticks" | "tconstruct:recipes/misc/smeltery/seared/table" | "ad_astra:recipes/misc/calorite_plating_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_plated_locometal" | "iceandfire:recipes/combat/armor_green_leggings" | "minecraft:recipes/food/cooked_cod_from_smoking" | "hexcasting:recipes/building_blocks/slate_pillar" | "create:recipes/misc/crafting/kinetics/mechanical_press" | "farmersdelight:main/obtain_netherite_knife" | "farmersdelight:recipes/food/cooked_cod_slice_from_smoking" | "railways:recipes/misc/stonecutting/palettes/cycling/black_plated_locometal" | "farmersdelight:recipes/decorations/orange_hanging_canvas_sign" | "minecraft:nether/explore_nether" | "ae2:recipes/misc/network/cells/item_storage_cell_64k" | "tconstruct:recipes/misc/common/tinkers_gadgetry" | "ae2:recipes/misc/tools/paintballs_orange" | "create:recipes/building_blocks/cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/prismarine" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_iron_wrapped_locometal_boiler" | "classicpipes:recipes/dark_oak_pipe" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_plated_locometal" | "ae2:recipes/misc/network/upgrade_wireless_crafting_terminal" | "create:recipes/building_blocks/framed_glass_pane_from_colorless_glass_panes_stonecutting" | "minecraft:recipes/building_blocks/polished_diorite" | "create:recipes/building_blocks/cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "iceandfire:recipes/misc/sea_serpent_scale_block_green_to_sea_serpent_scales_green" | "create:recipes/misc/crafting/kinetics/rope_pulley" | "biomesoplenty:recipes/building_blocks/pine_stairs" | "minecraft:recipes/misc/brown_dye" | "minecraft:recipes/building_blocks/raw_iron_block" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/polished_cut_veridium_from_stone_types_veridium_stonecutting" | "agricraft:recipes/tools/trowel" | "iceandfire:recipes/combat/armor_silver_chestplate" | "tconstruct:foundry/fantastic_foundry" | "minecraft:recipes/building_blocks/mud_brick_slab_from_mud_bricks_stonecutting" | "tconstruct:recipes/misc/tables/crafting_station_from_logs" | "create:recipes/building_blocks/cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "ae2:recipes/misc/network/cables/glass_brown" | "ae2:recipes/misc/network/wireless_terminal" | "ad_astra:recipes/misc/stonecutting/venus_cobblestone_slab_from_venus_cobblestone_stonecutting" | "farmersdelight:recipes/decorations/mangrove_cabinet" | "create:recipes/building_blocks/exposed_copper_tile_slab" | "ad_astra:recipes/cryo_freezing/cryo_freezing/cryo_fuel_from_cryo_freezing_ice_shard" | "create:recipes/building_blocks/crafting/kinetics/green_seat_from_other_seat" | "create:recipes/building_blocks/polished_cut_tuff_from_stone_types_tuff_stonecutting" | "biomesoplenty:recipes/transportation/willow_boat" | "create:recipes/building_blocks/cut_andesite_slab_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_flat_riveted_locometal" | "ae2:recipes/misc/tools/portable_fluid_cell_4k" | "ad_astra:venus" | "railways:recipes/misc/crafting/palettes/wrapping/lime_copper_wrapped_locometal" | "create:recipes/building_blocks/small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "create:recipes/building_blocks/cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "create:extendo_grip" | "computercraft:recipes/redstone/pocket_normal/computercraft/wireless_modem_normal" | "create:recipes/building_blocks/cut_scoria_brick_stairs" | "ad_astra:recipes/misc/smelting/cracked_glacio_stone_bricks_from_smelting_glacio_stone_bricks" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_stonecutting" | "farmersdelight:recipes/cooking/mushroom_stew" | "create:recipes/building_blocks/polished_cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/cut_diorite_slab_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/netherite_scrap_from_blasting" | "create:glass_pipe" | "minecraft:recipes/combat/diamond_sword" | "minecraft:recipes/decorations/cyan_stained_glass_pane" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet_from_netherite" | "tconstruct:recipes/misc/smeltery/scorched/scorched_road_smelting" | "minecraft:recipes/misc/white_dye" | "minecraft:recipes/building_blocks/stripped_warped_hyphae" | "ad_astra:recipes/misc/moon_pillar" | "hexcasting:recipes/building_blocks/stonecutting/amethyst_tiles" | "biomesoplenty:recipes/building_blocks/hellbark_planks" | "minecraft:recipes/decorations/jukebox" | "create:recipes/building_blocks/crafting/logistics/magenta_postbox" | "ae2:recipes/misc/block_cutter/stairs/smooth_sky_stone_stairs" | "ad_astra:recipes/misc/chiseled_glacio_stone_bricks" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_flat_slashed_locometal" | "ad_astra:recipes/misc/stonecutting/venus_sandstone_bricks_from_venus_sandstone_stonecutting" | "minecraft:recipes/misc/silence_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_scoria_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_riveted_locometal" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/slab" | "ad_astra:recipes/misc/steel_ingot_from_steel_block" | "minecraft:recipes/misc/gold_nugget" | "hexcasting:recipes/misc/ancient_colorizer" | "ad_astra:recipes/misc/glacio_stone_slab" | "ae2:recipes/misc/network/blocks/pattern_providers_interface_part" | "ae2:recipes/misc/network/blocks/quantum_link" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_plated_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_flat_riveted_locometal" | "minecraft:recipes/building_blocks/smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "minecraft:nether/all_effects" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_flat_slashed_locometal" | "tconstruct:recipes/misc/common/gold_platform" | "create:recipes/building_blocks/small_deepslate_brick_slab" | "ae2:recipes/misc/decorative/certus_quartz_bricks" | "tconstruct:recipes/misc/smeltery/scorched/chute_retextured" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_riveted_locometal" | "create:recipes/building_blocks/polished_cut_veridium_slab" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "iceandfire:iceandfire/dragonsteel" | "iceandfire:recipes/combat/armor_black_leggings" | "ad_astra:recipes/misc/desh_factory_block" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_smokebox" | "railways:recipes/misc/crafting/track_switch_brass" | "ae2:recipes/misc/tools/paintballs_lumen_white" | "biomesoplenty:recipes/building_blocks/cut_white_sandstone_slab_from_white_sandstone_stonecutting" | "create:recipes/misc/crafting/appliances/chain_from_zinc" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_pillar" | "railways:recipes/misc/stonecutting/palettes/cycling/red_slashed_locometal" | "iceandfire:recipes/combat/tide_purple_helmet" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_veridium_brick_wall" | "create:recipes/building_blocks/cut_scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/white_glazed_terracotta" | "minecraft:recipes/combat/iron_helmet" | "minecraft:recipes/tools/golden_shovel" | "tconstruct:recipes/misc/common/slime/ichor/congealed" | "biomesoplenty:recipes/building_blocks/orange_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal" | "iceandfire:recipes/misc/dragonsteel_fire_block_to_dragonsteel_fire_ingot" | "create:recipes/building_blocks/small_scoria_brick_slab" | "computercraft:recipes/redstone/printer" | "iceandfire:recipes/building_blocks/dragonforge_ice_brick" | "iceandfire:recipes/combat/tide_deepblue_helmet" | "minecraft:recipes/building_blocks/dye_magenta_carpet" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs" | "ae2:recipes/misc/shaped/stairs/sky_stone_block" | "minecraft:recipes/combat/diamond_chestplate" | "tconstruct:recipes/misc/common/glass/light_blue_clear_stained_glass_pane_from_panes" | "create:recipes/misc/crafting/kinetics/smart_chute" | "create:recipes/building_blocks/polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "tconstruct:recipes/misc/common/materials_and_you" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_iron_wrapped_locometal" | "minecraft:story/mine_stone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_flat_riveted_locometal" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/decorations/furnace" | "minecraft:recipes/food/beetroot_soup" | "farmersdelight:recipes/tools/lead_from_straw" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal" | "create:recipes/misc/smelting/tin_ingot_compat_modern_industrialization" | "minecraft:recipes/building_blocks/andesite_stairs" | "hexical:media_slurp" | "hexcasting:recipes/building_blocks/quenched_allay_bricks" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_smokebox" | "hexcasting:recipes/tools/staff/quenched" | "create:recipes/misc/crafting/kinetics/mechanical_arm" | "ad_astra:recipes/misc/steel_block" | "minecraft:recipes/redstone/redstone_torch" | "railways:recipes/misc/crafting/palettes/wrapping/orange_brass_wrapped_locometal" | "minecraft:recipes/food/golden_apple" | "minecraft:recipes/misc/gold_ingot_from_blasting_raw_gold" | "minecraft:recipes/building_blocks/green_concrete_powder" | "create:recipes/building_blocks/cut_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "create:recipes/misc/blasting/nickel_ingot_compat_thermal" | "ae2:recipes/misc/misc/fluixpearl" | "create:recipes/misc/blasting/copper_ingot_from_crushed" | "biomesoplenty:recipes/transportation/jacaranda_chest_boat" | "create:recipes/misc/blasting/tin_ingot_compat_alloygery" | "ad_astra:recipes/misc/calorite_plateblock" | "railways:recipes/misc/crafting/palettes/wrapping/lime_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/orange_stained_glass" | "ad_astra:recipes/misc/brown_flag" | "railways:recipes/misc/crafting/palettes/wrapping/purple_brass_wrapped_locometal" | "ad_astra:tier_1_rocket" | "ae2:recipes/misc/tools/portable_fluid_cell_1k" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_riveted_locometal" | "ad_astra:recipes/misc/polished_mars_stone_slab" | "farmersdelight:recipes/food/cooked_salmon_slice_from_campfire_cooking" | "create:recipes/misc/crafting/kinetics/super_glue" | "railways:recipes/misc/crafting/palettes/wrapping/lime_brass_wrapped_locometal" | "minecraft:adventure/two_birds_one_arrow" | "minecraft:recipes/decorations/end_crystal" | "create:recipes/building_blocks/cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "farmersdelight:recipes/food/melon_popsicle" | "hexcasting:recipes/tools/staff/edified" | "ae2:recipes/misc/network/crafting/256k_cpu_crafting_storage" | "farmersdelight:recipes/food/roast_chicken_block" | "ad_astra:energizer" | "create:recipes/misc/blasting/tin_ingot_compat_techreborn" | "ad_astra:recipes/misc/stonecutting/chiseled_mars_stone_bricks_from_mars_stone_bricks_stonecutting" | "tconstruct:smeltery/melter" | "create:recipes/building_blocks/exposed_copper_shingle_slab" | "tconstruct:recipes/misc/common/glass/green_clear_stained_glass_pane" | "create:recipes/building_blocks/cut_crimsite_slab" | "ad_astra:recipes/misc/chiseled_mercury_stone_stairs" | "minecraft:recipes/redstone/birch_door" | "tconstruct:recipes/building_blocks/common/materials/rose_gold_block_from_ingots" | "iceandfire:recipes/combat/deathworm_yellow_helmet" | "create:recipes/misc/crafting/logistics/pulse_extender" | "create:root" | "create:recipes/building_blocks/crimsite_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/logistics/red_table_cloth_clear" | "iceandfire:recipes/combat/armor_red_chestplate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_brass_wrapped_locometal" | "biomesoplenty:recipes/transportation/pine_chest_boat" | "tconstruct:recipes/misc/common/copper_platform_waxing_exposed" | "ad_astra:recipes/misc/polished_venus_stone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_riveted_locometal" | "hexical:arch_lamp" | "agricraft:recipes/tools/wooden_rake" | "create:train_crash_backwards" | "create:recipes/building_blocks/exposed_copper_tile_stairs" | "minecraft:recipes/decorations/snow" | "minecraft:recipes/decorations/soul_lantern" | "hexical:reload_lamp" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/oxidized_cut_copper_from_oxidized_copper_stonecutting" | "minecraft:recipes/decorations/cherry_fence" | "minecraft:recipes/decorations/birch_fence" | "minecraft:recipes/decorations/sandstone_wall_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/andesite_door" | "biomesoplenty:recipes/building_blocks/cut_orange_sandstone" | "create:recipes/building_blocks/cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "hextweaks:grandspell/mindflayplus" | "sophisticatedbackpacks:recipes/misc/advanced_refill_upgrade" | "ad_astra:recipes/misc/stonecutting/polished_moon_stone_slab_from_moon_stone_stonecutting" | "ad_astra:recipes/misc/zip_gun" | "minecraft:recipes/building_blocks/stone_brick_stairs" | "ae2:recipes/misc/network/cells/spatial_components_1" | "create:recipes/building_blocks/cut_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "ad_astra:recipes/misc/chiseled_glacio_stone_slab" | "create:recipes/misc/crafting/materials/cardboard_from_bound_block" | "ae2:recipes/misc/network/cells/spatial_components_0" | "ad_astra:recipes/misc/blasting/diamond_from_blasting_mars_diamond_ore" | "minecraft:recipes/combat/golden_boots" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_boiler" | "tconstruct:recipes/building_blocks/common/materials/copper_nugget_from_ingot" | "railways:recipes/misc/crafting/link_and_pin" | "computercraft:recipes/redstone/wireless_modem_advanced" | "minecraft:recipes/tools/wooden_axe" | "ae2:recipes/misc/network/cells/item_storage_components_cell_1k_part" | "biomesoplenty:recipes/building_blocks/chiseled_brimstone_bricks_from_brimstone_bricks_stonecutting" | "farmersdelight:recipes/food/beef_patty_from_campfire_cooking" | "ad_astra:recipes/misc/steel_plating_button" | "create:recipes/building_blocks/polished_cut_tuff_slab_from_stone_types_tuff_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_smelting_gold_ore" | "minecraft:recipes/building_blocks/stone_bricks_from_stone_stonecutting" | "create:recipes/building_blocks/crafting/logistics/orange_table_cloth" | "create:copper" | "minecraft:recipes/building_blocks/chiseled_sandstone" | "computercraft:recipes/redstone/wired_modem_full_to" | "hexcasting:recipes/decorations/ageing_scroll_paper_lantern" | "ad_astra:recipes/misc/glacio_pillar" | "create:recipes/building_blocks/cut_limestone_slab" | "ad_astra:recipes/misc/encased_iron_block" | "create:recipes/building_blocks/small_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "ae2:recipes/misc/network/cables/dense_smart_light_gray" | "ad_astra:recipes/misc/black_industrial_lamp" | "tconstruct:recipes/misc/common/slime/blood/slimeball_from_congealed" | "ad_astra:recipes/misc/strophar_ladder" | "iceandfire:recipes/building_blocks/dragonscales_copper_to_dragonscale_copper" | "biomesoplenty:recipes/building_blocks/smooth_orange_sandstone" | "tconstruct:recipes/building_blocks/world/wood/skyroot/sign" | "iceandfire:recipes/combat/dragonsteel_ice_helmet" | "ad_astra:recipes/nasa_workbench/nasa_workbench/tier_2_rocket_from_nasa_workbench" | "biomesoplenty:recipes/decorations/empyreal_sign" | "create:recipes/misc/smelting/glass_from_framed_glass" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_flat_riveted_locometal" | "create:potato_cannon" | "create:recipes/misc/crafting/kinetics/spout" | "minecraft:recipes/building_blocks/stone_slab" | "minecraft:recipes/decorations/black_carpet" | "ae2:recipes/misc/network/cells/spatial_storage_cell_16_cubed" | "minecraft:recipes/misc/gold_nugget_from_blasting" | "hexcasting:recipes/redstone/impetus/empty" | "hexcassettes:quinio" | "create:recipes/building_blocks/cut_deepslate_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/decorations/yellow_stained_glass_pane" | "farmersdelight:main/get_fd_seed" | "minecraft:recipes/building_blocks/blue_concrete_powder" | "biomesoplenty:recipes/redstone/redwood_trapdoor" | "hexcasting:recipes/misc/default_colorizer" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/granite_slab_from_granite_stonecutting" | "tconstruct:recipes/misc/smeltery/scorched/scorched_glass" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cables/dense_covered_fluix" | "minecraft:recipes/building_blocks/crimson_planks" | "create:recipes/building_blocks/cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_riveted_locometal" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_wall" | "create:chute" | "iceandfire:recipes/combat/dragonarmor_iron_neck" | "iceandfire:recipes/combat/armor_blue_leggings" | "create:recipes/building_blocks/polished_cut_scoria_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/small_tuff_brick_slab_recycling" | "tconstruct:smeltery/gold_casting" | "minecraft:recipes/building_blocks/cut_sandstone" | "minecraft:recipes/building_blocks/smooth_red_sandstone" | "minecraft:recipes/building_blocks/black_terracotta" | "minecraft:recipes/decorations/blackstone_wall" | "minecraft:recipes/misc/cyan_dye_from_pitcher_plant" | "tconstruct:recipes/misc/tables/scorched_anvil" | "ae2:recipes/misc/network/cables/covered_brown" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "hexcasting:recipes/brainsweep/brainsweep/impetus_rightclick" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_copper_wrapped_locometal" | "create:chained_drain" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal" | "farmersdelight:recipes/cooking/chicken_soup" | "minecraft:recipes/decorations/purple_candle" | "create:recipes/building_blocks/crafting/kinetics/blue_seat" | "create:recipes/building_blocks/cut_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/pink_glazed_terracotta" | "minecraft:recipes/misc/coal" | "minecraft:recipes/transportation/spruce_chest_boat" | "create:recipes/misc/smelting/silver_ingot_compat_bewitchment" | "sophisticatedbackpacks:recipes/misc/magnet_upgrade" | "ad_astra:recipes/misc/smelting/lapis_lazuli_from_smelting_glacio_lapis_ore" | "create:recipes/building_blocks/crafting/logistics/gray_postbox_from_other_postbox" | "minecraft:recipes/food/cooked_rabbit" | "iceandfire:recipes/combat/tide_teal_chestplate" | "hexcasting:recipes/tools/focus_rotated" | "minecraft:recipes/combat/leather_chestplate" | "ae2:recipes/misc/network/cells/item_storage_cell_256k" | "iceandfire:recipes/combat/dragonsteel_fire_leggings" | "create:recipes/misc/crafting/appliances/crafting_blueprint" | "minecraft:recipes/misc/magenta_dye_from_blue_red_pink" | "minecraft:recipes/decorations/yellow_candle" | "ae2:recipes/misc/tools/paintballs_lumen_lime" | "create:recipes/building_blocks/polished_cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/logistics/orange_table_cloth_clear" | "minecraft:nether/obtain_blaze_rod" | "iceandfire:recipes/combat/tide_bronze_chestplate" | "tconstruct:recipes/misc/common/glass/pink_clear_stained_glass_pane_from_panes" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_flat_riveted_locometal" | "create:crushing_wheel" | "create:recipes/misc/crafting/kinetics/gearbox_from_conversion" | "ae2:recipes/misc/network/cables/dense_smart_white" | "create:recipes/building_blocks/cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/placard" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_riveted_locometal" | "ad_astra:ti_69" | "ad_astra:recipes/misc/wrench" | "create:recipes/misc/crafting/logistics/stock_ticker_clear" | "hexcasting:recipes/redstone/edified_trapdoor" | "create:recipes/building_blocks/cut_crimsite_brick_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_flat_slashed_locometal" | "create:recipes/building_blocks/small_tuff_brick_wall" | "iceandfire:recipes/misc/dragonscale_amythest_to_dragonscales_amythest" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal" | "ad_astra:recipes/misc/pink_industrial_lamp" | "classicpipes:recipes/diamond_pipe" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_riveted_locometal" | "agricraft:recipes/tools/seed_analyzer" | "biomesoplenty:recipes/misc/orange_dye_from_burning_blossom" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_iron_wrapped_locometal" | "create:recipes/misc/crafting/kinetics/water_wheel" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_iron_wrapped_locometal" | "create:recipes/building_blocks/cut_granite_slab_from_stone_types_granite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal_boiler" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_locometal_smokebox" | "create:recipes/misc/blasting/silver_ingot_compat_oreganized" | "biomesoplenty:recipes/misc/magenta_dye_from_wildflower" | "minecraft:adventure/shoot_arrow" | "tconstruct:recipes/building_blocks/common/materials/cobalt_ingot_from_block" | "create:recipes/building_blocks/polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_slashed_locometal" | "iceandfire:iceandfire/use_tide_trident" | "minecraft:recipes/building_blocks/polished_blackstone_stairs" | "create:recipes/building_blocks/cut_limestone_brick_slab_recycling" | "tconstruct:recipes/building_blocks/common/mud_bricks_stairs" | "iceandfire:recipes/building_blocks/dragonforge_fire_brick" | "create:recipes/misc/smelting/lead_ingot_compat_thermal" | "hexcassettes:full_arsenal" | "iceandfire:recipes/building_blocks/dread_stone_face" | "farmersdelight:main/place_organic_compost" | "computercraft:recipes/redstone/pocket_normal/computercraft/speaker" | "biomesoplenty:recipes/building_blocks/smooth_black_sandstone" | "tconstruct:recipes/misc/smeltery/scorched/scorched_brick" | "create:recipes/building_blocks/cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/oxidized_copper_shingle_slab" | "iceandfire:recipes/combat/mountain_troll_leather_helmet" | "biomesoplenty:recipes/redstone/maple_door" | "farmersdelight:main/place_campfire" | "railways:recipes/combat/dying_existing_cap_red" | "create:recipes/building_blocks/polished_cut_crimsite_slab_recycling" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab" | "minecraft:recipes/building_blocks/chiseled_red_sandstone" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat" | "minecraft:recipes/decorations/light_gray_stained_glass_pane_from_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_boiler" | "ae2:recipes/misc/tools/portable_fluid_cell_256k" | "tconstruct:recipes/misc/smeltery/seared/heater" | "farmersdelight:recipes/food/fried_egg_from_campfire_cooking" | "minecraft:adventure/arbalistic" | "minecraft:recipes/decorations/pink_candle" | "ae2:recipes/misc/network/cables/smart_gray" | "hexcasting:recipes/tools/focus" | "minecraft:recipes/building_blocks/deepslate_brick_stairs" | "create:recipes/building_blocks/small_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/light_blue_bed" | "tconstruct:recipes/misc/common/cobalt_platform" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/wrapping/white_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/pink_stained_glass" | "ae2:recipes/misc/network/wireless_part" | "iceandfire:recipes/building_blocks/dragonforge_fire_core_disabled" | "minecraft:recipes/decorations/purple_stained_glass_pane" | "tconstruct:recipes/misc/common/slime/ichor/slimeblock" | "create:recipes/misc/crafting/kinetics/large_cogwheel_from_little" | "minecraft:recipes/building_blocks/black_stained_glass" | "minecraft:recipes/building_blocks/brick_stairs_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "tconstruct:recipes/misc/smeltery/scorched/scorched_bricks_from_brick" | "create:hand_crank_000" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_flat_slashed_locometal" | "classicpipes:autocraft_recipe_pipe" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cables/covered_fluix_clean" | "minecraft:nether/charge_respawn_anchor" | "ad_astra:recipes/compressing/compressing/iron_plate_from_compressing_iron_block" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_sword" | "iceandfire:recipes/combat/tide_bronze_helmet" | "minecraft:recipes/building_blocks/bamboo_planks" | "minecraft:recipes/building_blocks/cracked_polished_blackstone_bricks" | "biomesoplenty:recipes/building_blocks/brimstone_brick_stairs_from_brimstone_stonecutting" | "minecraft:recipes/building_blocks/gray_stained_glass" | "ad_astra:recipes/misc/stonecutting/venus_stone_brick_slab_from_venus_stone_stonecutting" | "create:mechanical_mixer" | "hexcasting:recipes/misc/uuid_colorizer" | "minecraft:recipes/decorations/crafting_table" | "create:recipes/misc/crafting/kinetics/portable_storage_interface" | "extendedae:recipes/misc/wireless_ex_pat" | "create:super_glue" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_copper_block_stonecutting" | "ad_astra:recipes/misc/fan" | "minecraft:recipes/misc/map" | "ae2:recipes/misc/network/cables/dense_covered_light_gray" | "minecraft:recipes/decorations/chest" | "minecraft:story/shiny_gear" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab" | "create:recipes/building_blocks/crafting/logistics/light_blue_postbox" | "create:recipes/building_blocks/cut_scorchia_wall" | "ad_astra:recipes/misc/stonecutting/glacio_pillar_from_glacio_stone_bricks_stonecutting" | "tconstruct:recipes/building_blocks/common/materials/netherite_nugget_from_ingot" | "biomesoplenty:recipes/redstone/empyreal_button" | "ae2:recipes/misc/network/parts/terminals" | "create:recipes/misc/blasting/ingot_tin_compat_ic2" | "minecraft:recipes/tools/shears" | "minecraft:recipes/misc/stick" | "minecraft:recipes/redstone/crimson_pressure_plate" | "lootr:1cart" | "farmersdelight:recipes/decorations/gray_canvas_sign" | "create:funnel" | "hexcasting:recipes/building_blocks/stonecutting/amethyst_pillar" | "ae2:recipes/misc/misc/tiny_tnt" | "minecraft:recipes/redstone/polished_blackstone_button" | "railways:recipes/misc/stonecutting/palettes/cycling/white_plated_locometal" | "ad_astra:recipes/misc/steel_rod" | "agricraft:recipes/tools/seed_bag" | "biomesoplenty:recipes/decorations/redwood_hanging_sign" | "create:recipes/misc/crafting/materials/andesite_alloy_block" | "ad_astra:recipes/misc/stonecutting/venus_stone_brick_stairs_from_venus_stone_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_riveted_locometal" | "ad_astra:recipes/misc/blasting/desh_ingot_from_blasting_moon_desh_ore" | "create:recipes/building_blocks/cut_andesite_slab" | "tconstruct:recipes/misc/common/slime/ender/crystal_growing" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal" | "minecraft:recipes/brewing/golden_carrot" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_locometal_smokebox" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal_boiler" | "biomesoplenty:recipes/misc/purple_dye_from_tall_lavender" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_plated_locometal" | "tconstruct:recipes/misc/common/basalt_blast_furnace" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_iron_wrapped_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_flat_riveted_locometal" | "computercraft:recipes/redstone/turtle_normal_overlays/turtle_trans_overlay" | "create:recipes/misc/crafting/kinetics/steam_engine" | "minecraft:recipes/building_blocks/pink_terracotta" | "ae2:recipes/misc/network/crafting/1k_cpu_crafting_storage" | "ae2:recipes/misc/network/cells/fluid_storage_cell_16k" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "minecraft:adventure/summon_iron_golem" | "minecraft:recipes/transportation/jungle_chest_boat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/weathered_copper_shingle_stairs" | "create:recipes/building_blocks/cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "hexcasting:recipes/misc/pride_colorizer_aroace" | "create:recipes/building_blocks/weathered_copper_shingle_slab" | "ae2:recipes/misc/network/parts/panels_monitor" | "ae2:recipes/misc/tools/fluix_upgrade_smithing_template" | "ad_astra:recipes/refining/refining/fuel_from_refining_oil" | "extendedae:recipes/misc/ex_molecular_assembler" | "minecraft:recipes/building_blocks/dye_pink_bed" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_slab_from_honeycomb" | "create:recipes/building_blocks/cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "tconstruct:recipes/misc/common/glass/magenta_clear_stained_glass_pane_from_panes" | "minecraft:recipes/tools/spyglass" | "biomesoplenty:recipes/building_blocks/smooth_orange_sandstone_stairs_from_smooth_orange_sandstone_stonecutting" | "tconstruct:recipes/misc/smeltery/seared/lantern" | "iceandfire:recipes/combat/tide_blue_chestplate" | "minecraft:recipes/redstone/lectern" | "railways:recipes/misc/crafting/smokestack_woodburner" | "create:recipes/building_blocks/cut_crimsite_brick_slab_recycling" | "minecraft:recipes/building_blocks/stone_stairs_from_stone_stonecutting" | "ad_astra:recipes/misc/glacian_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/red_dye_from_rose_bush" | "create:recipes/misc/smelting/platinum_ingot_compat_mythicmetals" | "extendedae:recipes/misc/cobblestone_cell" | "minecraft:recipes/misc/magenta_dye_from_purple_and_pink" | "minecraft:recipes/decorations/mossy_stone_brick_wall" | "biomesoplenty:recipes/building_blocks/smooth_orange_sandstone_stairs" | "create:recipes/building_blocks/polished_cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "sophisticatedbackpacks:recipes/misc/filter_upgrade" | "iceandfire:recipes/tools/copper_axe" | "tconstruct:recipes/misc/smeltery/seared/seared_fancy_bricks_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_modern_industrialization" | "ad_astra:recipes/misc/iron_plating_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_locometal_smokebox" | "iceandfire:iceandfire/dragonsteel_weapon" | "biomesoplenty:recipes/misc/brown_dye_from_cattail" | "biomesoplenty:recipes/building_blocks/cut_black_sandstone" | "tconstruct:recipes/misc/common/iron_platform" | "minecraft:adventure/sleep_in_bed" | "create:recipes/building_blocks/ochrum_pillar_from_stone_types_ochrum_stonecutting" | "tconstruct:recipes/misc/smeltery/seared/seared_bricks_stonecutting" | "minecraft:recipes/food/cooked_rabbit_from_campfire_cooking" | "minecraft:recipes/building_blocks/cobblestone_slab_from_cobblestone_stonecutting" | "create:recipes/building_blocks/bamboo_window" | "create:recipes/building_blocks/cut_scorchia_brick_slab" | "ae2:recipes/misc/network/cables/covered_red" | "ad_astra:recipes/misc/stonecutting/chiseled_venus_stone_slab_from_chiseled_venus_stone_bricks_stonecutting" | "create:recipes/building_blocks/cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/prismarine_slab_from_prismarine_stonecutting" | "iceandfire:recipes/building_blocks/dragonforge_lightning_input" | "create:recipes/building_blocks/small_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/birch_sign" | "minecraft:recipes/transportation/cherry_boat" | "iceandfire:recipes/combat/tide_teal_leggings" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_riveted_locometal" | "farmersdelight:recipes/food/carrot_from_crate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_copper_wrapped_locometal_boiler" | "minecraft:recipes/tools/diamond_pickaxe" | "minecraft:recipes/redstone/lightning_rod" | "minecraft:adventure/kill_all_mobs" | "minecraft:recipes/decorations/brown_glazed_terracotta" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_copper_wrapped_locometal" | "biomesoplenty:recipes/misc/cyan_dye_from_glowflower" | "ae2:recipes/misc/network/cables/smart_purple" | "ae2:recipes/misc/network/cells/fluid_storage_cell_256k" | "minecraft:recipes/building_blocks/birch_wood" | "create:recipes/building_blocks/oxidized_copper_tile_slab_from_oxidized_copper_tiles_stonecutting" | "ad_astra:recipes/misc/glacio_stone_brick_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_plated_locometal" | "create:recipes/misc/blasting/ingot_silver_compat_immersiveengineering" | "minecraft:recipes/decorations/crimson_sign" | "createoreexcavation:recipes/misc/vein_atlas" | "biomesoplenty:recipes/redstone/dead_pressure_plate" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat" | "create:recipes/misc/smelting/tin_ingot_compat_alloygery" | "minecraft:adventure/voluntary_exile" | "iceandfire:recipes/combat/tide_purple_chestplate" | "iceandfire:iceandfire/dragon_forge_core" | "minecraft:recipes/decorations/granite_wall_from_granite_stonecutting" | "computercraft:recipes/redstone/turtle_advanced_upgrade" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "farmersdelight:recipes/food/cabbage_from_leaves" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_blackstone_stonecutting" | "ad_astra:recipes/misc/blasting/ice_shard_from_blasting_moon_ice_shard_ore" | "create:recipes/misc/smelting/ingot_aluminum_compat_immersiveengineering" | "create:recipes/building_blocks/polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "biomesoplenty:recipes/redstone/willow_door" | "create:recipes/building_blocks/polished_cut_diorite_wall" | "iceandfire:recipes/misc/dragonscale_blue_to_dragonscales_blue" | "create:recipes/misc/crafting/appliances/schedule_clear" | "create:recipes/misc/crafting/kinetics/gearbox" | "minecraft:recipes/building_blocks/cherry_planks" | "computercraft:recipes/redstone/turtle_advanced" | "hexcasting:recipes/building_blocks/edified_fence" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_pillar" | "ae2:recipes/misc/misc/deconstruction_cut_certus_quartz_block" | "create:recipes/building_blocks/polished_cut_scoria_slab" | "minecraft:recipes/building_blocks/dye_cyan_bed" | "ad_astra:recipes/misc/small_light_gray_industrial_lamp" | "create:recipes/misc/smelting/nickel_ingot_compat_modern_industrialization" | "create:recipes/misc/crafting/logistics/light_blue_table_cloth_clear" | "create:recipes/building_blocks/crafting/logistics/orange_postbox_from_other_postbox" | "create:recipes/misc/crafting/logistics/brass_table_cloth_clear" | "create:recipes/building_blocks/polished_cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/combat/golden_chestplate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_boiler" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_pickaxe" | "biomesoplenty:recipes/transportation/umbran_boat" | "iceandfire:iceandfire/kill_deathworm" | "minecraft:recipes/building_blocks/stripped_dark_oak_wood" | "sophisticatedbackpacks:recipes/misc/feeding_upgrade" | "iceandfire:recipes/combat/dragonarmor_diamond_tail" | "minecraft:recipes/building_blocks/dye_yellow_wool" | "tconstruct:recipes/building_blocks/common/materials/hepatizon_ingot_from_block" | "ae2:recipes/misc/network/cables/smart_lime" | "create:recipes/misc/crafting/logistics/brass_tunnel" | "create:recipes/misc/crafting/logistics/pulse_repeater" | "ad_astra:recipes/misc/blasting/lapis_lazuli_from_blasting_glacio_lapis_ore" | "create:extendo_grip_dual" | "iceandfire:recipes/combat/dragonarmor_copper_head" | "railways:recipes/misc/crafting/palettes/wrapping/pink_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/iron_block" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_pillar" | "ad_astra:recipes/misc/chiseled_mercury_stone_slab" | "farmersdelight:recipes/food/bacon_sandwich" | "iceandfire:recipes/misc/dragon_flute" | "ae2:recipes/misc/network/cables/dense_covered_brown" | "minecraft:recipes/misc/red_dye_from_poppy" | "create:recipes/misc/smelting/bread" | "iceandfire:recipes/misc/sea_serpent_scale_block_purple_to_sea_serpent_scales_purple" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs" | "minecraft:recipes/building_blocks/clay" | "create:recipes/building_blocks/small_granite_brick_stairs" | "create:mechanical_crafter" | "classicpipes:recipes/brick_fluid_pipe_a" | "create:recipes/building_blocks/crafting/logistics/yellow_postbox_from_other_postbox" | "create:recipes/misc/crafting/kinetics/furnace_minecart_from_contraption_cart" | "ae2:recipes/misc/network/cells/fluid_storage_cell_1k_storage" | "create:recipes/misc/crafting/kinetics/green_valve_handle_from_other_valve_handle" | "sophisticatedbackpacks:recipes/misc/advanced_compacting_upgrade" | "biomesoplenty:recipes/decorations/redwood_sign" | "create:recipes/misc/blasting/iron_ingot_from_crushed" | "artifacts:adventurous_eater" | "create:recipes/building_blocks/small_dripstone_brick_slab" | "ae2:recipes/misc/tools/certus_quartz_sword" | "ad_astra:recipes/misc/stonecutting/mercury_stone_brick_slab_from_mercury_stone_stonecutting" | "minecraft:recipes/decorations/birch_hanging_sign" | "minecraft:recipes/transportation/mangrove_chest_boat" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "iceandfire:recipes/misc/ghost_chest" | "create:recipes/building_blocks/cut_asurine_brick_slab" | "minecraft:recipes/decorations/gray_carpet" | "ae2:recipes/misc/tools/paintballs_red" | "minecraft:recipes/decorations/deepslate_tile_wall" | "minecraft:recipes/redstone/tripwire_hook" | "create:recipes/misc/crafting/kinetics/wooden_bracket" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_flat_riveted_locometal" | "biomesoplenty:recipes/building_blocks/redwood_planks" | "create:recipes/misc/crafting/kinetics/weighted_ejector" | "biomesoplenty:recipes/redstone/pine_button" | "ad_astra:recipes/misc/smelting/desh_ingot_from_smelting_raw_desh" | "create:recipes/misc/crafting/logistics/blue_table_cloth_clear" | "comforts:sleeping_bag_brown" | "minecraft:recipes/redstone/birch_fence_gate" | "create:recipes/misc/smelting/zinc_ingot_from_raw_ore" | "minecraft:recipes/redstone/stone_button" | "ae2:recipes/misc/network/cables/dense_smart_lime" | "minecraft:recipes/building_blocks/packed_mud" | "create:recipes/building_blocks/cut_dripstone_brick_stairs" | "iceandfire:recipes/combat/dragonarmor_silver_neck" | "hexcasting:recipes/tools/thought_knot" | "ad_astra:recipes/misc/stonecutting/mercury_stone_brick_stairs_from_mercury_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_plated_locometal" | "farmersdelight:recipes/decorations/cooking_pot" | "biomesoplenty:recipes/decorations/willow_sign" | "ae2:recipes/misc/network/parts/terminals_crafting" | "farmersdelight:recipes/food/apple_pie_from_slices" | "create:spout" | "minecraft:recipes/building_blocks/smooth_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_iron_wrapped_locometal_boiler" | "ae2:recipes/misc/network/wireless_crafting_terminal" | "ad_astra:recipes/misc/stonecutting/permafrost_brick_wall_from_permafrost_bricks_stonecutting" | "create:recipes/building_blocks/crafting/logistics/orange_postbox" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal" | "biomesoplenty:recipes/transportation/fir_chest_boat" | "minecraft:recipes/building_blocks/blue_terracotta" | "iceandfire:recipes/combat/armor_white_helmet" | "iceandfire:recipes/tools/silver_axe" | "minecraft:recipes/building_blocks/stone" | "ad_astra:recipes/misc/green_industrial_lamp" | "iceandfire:recipes/combat/armor_amythest_leggings" | "ae2:recipes/misc/network/cables/dense_smart_from_smart" | "extendedae:recipes/misc/water_cell" | "minecraft:recipes/decorations/green_carpet" | "minecraft:recipes/building_blocks/light_blue_terracotta" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_flat_riveted_locometal" | "iceandfire:iceandfire/kill_hydra" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_slashed_locometal" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_iron_wrapped_locometal" | "minecraft:recipes/transportation/bamboo_raft" | "computercraft:recipes/redstone/speaker" | "hexcasting:recipes/tools/staff/mindsplice" | "ae2:recipes/misc/network/parts/panels_semi_dark_monitor_alt" | "minecraft:recipes/building_blocks/cut_red_sandstone" | "biomesoplenty:recipes/building_blocks/maple_wood" | "create:recipes/building_blocks/small_crimsite_brick_slab_recycling" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/battery_upgrade" | "create:recipes/building_blocks/small_rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal_boiler" | "ad_astra:recipes/misc/smelting/iron_ingot_from_smelting_mercury_iron_ore" | "minecraft:recipes/decorations/purple_carpet" | "biomesoplenty:recipes/transportation/maple_chest_boat" | "classicpipes:recipes/mangrove_pipe" | "minecraft:recipes/building_blocks/cut_copper" | "minecraft:recipes/redstone/stone_pressure_plate" | "ad_astra:recipes/space_stations/space_station/moon_orbit_space_station" | "minecraft:recipes/building_blocks/polished_blackstone_slab" | "ad_astra:recipes/compressing/compressing/calorite_plate_from_compressing_calorite_blocks" | "ad_astra:recipes/misc/stonecutting/mercury_pillar_from_mercury_stone_stonecutting" | "ae2:recipes/misc/tools/portable_fluid_cell_16k" | "create:recipes/building_blocks/polished_cut_granite_wall" | "gravestones:recipes/decorations/gravestone_damaged" | "minecraft:recipes/misc/netherite_ingot" | "create:recipes/building_blocks/small_granite_brick_stairs_from_stone_types_granite_stonecutting" | "biomesoplenty:recipes/building_blocks/mahogany_slab" | "ad_astra:recipes/misc/red_industrial_lamp" | "tconstruct:recipes/misc/common/glass/pink_clear_stained_glass" | "create:recipes/building_blocks/cut_ochrum_brick_slab_recycling" | "railways:recipes/misc/stonecutting/palettes/cycling/black_locometal_pillar" | "minecraft:recipes/building_blocks/dye_lime_bed" | "iceandfire:recipes/combat/armor_sapphire_boots" | "ae2:recipes/misc/network/cables/dense_smart_blue" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_locometal_pillar" | "iceandfire:recipes/combat/armor_green_helmet" | "iceandfire:recipes/combat/dragonsteel_ice_leggings" | "tconstruct:recipes/misc/common/copper_platform" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_flat_riveted_locometal" | "minecraft:adventure/spyglass_at_dragon" | "create:recipes/building_blocks/cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/purple_iron_wrapped_locometal" | "ae2:recipes/misc/decorative/quartz_vibrant_glass" | "ad_astra:recipes/misc/stonecutting/glacio_stone_brick_stairs_from_glacio_stone_stonecutting" | "ae2:recipes/misc/network/cables/dense_covered_pink" | "railways:recipes/misc/stonecutting/palettes/cycling/green_riveted_locometal" | "sophisticatedbackpacks:recipes/misc/advanced_jukebox_upgrade" | "create:recipes/misc/smelting/silver_ingot_compat_mythicmetals" | "sophisticatedbackpacks:recipes/misc/advanced_deposit_upgrade" | "tconstruct:recipes/misc/smeltery/scorched/chiseled_scorched_bricks_crafting" | "create:recipes/misc/crafting/kinetics/large_water_wheel" | "create:recipes/building_blocks/deepslate_from_stone_types_deepslate_stonecutting" | "ae2:recipes/misc/network/cables/smart_blue" | "minecraft:adventure/trade_at_world_height" | "ae2:recipes/misc/network/cells/item_storage_components_cell_64k_part" | "hexcasting:recipes/building_blocks/slate_amethyst_bricks_small" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_axe" | "minecraft:recipes/decorations/red_sandstone_wall_from_red_sandstone_stonecutting" | "minecraft:recipes/food/cookie" | "biomesoplenty:recipes/redstone/magic_trapdoor" | "comforts:hammock_brown" | "railways:recipes/misc/stonecutting/palettes/cycling/flat_riveted_locometal" | "ad_astra:recipes/misc/pink_flag" | "minecraft:recipes/decorations/light_blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/acacia_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_pillar" | "create:recipes/building_blocks/small_asurine_brick_slab_recycling" | "create:recipes/building_blocks/small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "ad_astra:recipes/misc/stonecutting/mars_stone_brick_slab_from_mars_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_flat_slashed_locometal" | "iceandfire:iceandfire/lectern" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal" | "create:recipes/building_blocks/small_veridium_brick_stairs" | "minecraft:recipes/misc/fire_charge" | "minecraft:recipes/decorations/soul_torch" | "ad_astra:tier_2_rocket" | "iceandfire:recipes/misc/sea_serpent_scale_block_bronze_to_sea_serpent_scales_bronze" | "create:recipes/misc/crafting/materials/andesite_alloy" | "iceandfire:recipes/combat/deathworm_white_chestplate" | "minecraft:recipes/building_blocks/yellow_terracotta" | "iceandfire:recipes/building_blocks/ash" | "hexcasting:recipes/building_blocks/stonecutting/slate_pillar" | "farmersdelight:recipes/cooking/baked_cod_stew" | "ad_astra:rocket_man" | "biomesoplenty:recipes/transportation/palm_chest_boat" | "minecraft:recipes/misc/writable_book" | "farmersdelight:recipes/combat/golden_knife" | "create:recipes/building_blocks/crafting/logistics/green_postbox" | "create:recipes/building_blocks/polished_cut_granite_stairs" | "ad_astra:recipes/misc/polished_mercury_stone_stairs" | "computercraft:recipes/redstone/computer_advanced" | "iceandfire:recipes/tools/dragonsteel_ice_shovel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_flat_slashed_locometal" | "minecraft:recipes/decorations/candle" | "create:recipes/combat/crafting/appliances/netherite_backtank_from_netherite" | "classicpipes:recipes/copper_pipe" | "minecraft:recipes/food/bread" | "ad_astra:recipes/misc/stonecutting/moon_stone_brick_stairs_from_moon_stone_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_plated_locometal" | "ad_astra:recipes/misc/desh_plateblock" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_iron_wrapped_locometal" | "computercraft:recipes/redstone/turtle_advanced/computercraft/wireless_modem_advanced" | "minecraft:nether/obtain_ancient_debris" | "ad_astra:recipes/misc/small_magenta_industrial_lamp" | "ad_astra:recipes/misc/stonecutting/polished_mars_stone_from_mars_stone_stonecutting" | "computercraft:recipes/redstone/redstone_relay" | "minecraft:recipes/misc/bone_meal_from_bone_block" | "iceandfire:iceandfire/dragon_meal" | "create:recipes/building_blocks/cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "ae2:recipes/misc/decorative/fluix_block" | "minecraft:recipes/decorations/magenta_candle" | "biomesoplenty:recipes/transportation/dead_boat" | "create:recipes/building_blocks/cut_veridium_wall_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "minecraft:nether/create_full_beacon" | "ae2:recipes/misc/tools/paintballs_lumen_gray" | "create:recipes/building_blocks/tuff_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/diorite" | "ad_astra:recipes/misc/desh_block" | "minecraft:recipes/building_blocks/dye_white_bed" | "create:recipes/building_blocks/small_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/iron_wrapped_locometal" | "ad_astra:recipes/misc/smelting/coal_from_smelting_glacio_coal_ore" | "tconstruct:recipes/misc/common/glass/pink_clear_stained_glass_pane" | "minecraft:recipes/decorations/spruce_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_riveted_locometal" | "farmersdelight:recipes/building_blocks/rice_bale" | "minecraft:recipes/building_blocks/polished_granite_from_granite_stonecutting" | "tconstruct:recipes/misc/smeltery/scorched/chiseled_scorched_bricks_stonecutting" | "tconstruct:recipes/misc/smeltery/seared/fuel_gauge" | "ad_astra:recipes/misc/steel_tank" | "create:recipes/building_blocks/cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "create:recipes/misc/crafting/logistics/yellow_table_cloth_clear" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "ad_astra:recipes/misc/stonecutting/polished_glacio_stone_stairs_from_polished_glacio_stone_stonecutting" | "iceandfire:recipes/combat/tide_green_leggings" | "ae2:recipes/misc/tools/paintballs_light_blue" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "iceandfire:iceandfire/kill_if_dragon" | "farmersdelight:recipes/decorations/magenta_canvas_sign" | "create:recipes/misc/crafting/logistics/brass_funnel" | "minecraft:recipes/building_blocks/birch_slab" | "biomesoplenty:recipes/transportation/magic_boat" | "minecraft:recipes/misc/raw_gold" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_flat_riveted_locometal" | "create:cart_pickup" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_pillar" | "biomesoplenty:recipes/decorations/fir_fence" | "create:potato_cannon_collide" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_honeycomb" | "minecraft:recipes/decorations/oak_hanging_sign" | "create:recipes/building_blocks/copper_tiles_from_copper_ingots_stonecutting" | "minecraft:recipes/building_blocks/dye_lime_carpet" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_blackstone_stonecutting" | "biomesoplenty:recipes/building_blocks/mahogany_wood" | "create:recipes/building_blocks/small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "extendedae:recipes/misc/ingredient_buffer" | "create:recipes/building_blocks/cut_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_slashed_locometal" | "iceandfire:recipes/building_blocks/dragonsteel_fire_ingot_to_dragonsteel_fire_block" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs" | "minecraft:recipes/redstone/redstone_from_smelting_redstone_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_riveted_locometal" | "tconstruct:recipes/misc/common/slime/sky/slimeball_from_block" | "minecraft:recipes/building_blocks/hay_block" | "minecraft:recipes/misc/leather_horse_armor" | "iceandfire:recipes/tools/dragonsteel_lightning_shovel" | "tconstruct:recipes/misc/common/glass/brown_clear_stained_glass" | "create:recipes/building_blocks/crafting/logistics/brown_postbox_from_other_postbox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_slab_from_honeycomb" | "ae2:recipes/misc/block_cutter/walls/fluix_wall" | "create:recipes/building_blocks/weathered_copper_shingle_stairs_from_weathered_copper_shingles_stonecutting" | "minecraft:recipes/building_blocks/granite" | "ad_astra:recipes/misc/polished_conglomerate" | "ad_astra:recipes/misc/small_brown_industrial_lamp" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_cut_sandstone_stonecutting" | "create:recipes/building_blocks/cut_granite_brick_slab" | "tconstruct:recipes/misc/common/glass/red_clear_stained_glass_pane_from_panes" | "create:recipes/misc/smelting/osmium_ingot_compat_mythicmetals" | "create:recipes/building_blocks/polished_cut_limestone_slab_recycling" | "railways:recipes/misc/stonecutting/palettes/cycling/white_locometal_smokebox" | "biomesoplenty:recipes/building_blocks/cut_white_sandstone_slab_from_cut_white_sandstone_stonecutting" | "minecraft:recipes/misc/emerald_from_smelting_deepslate_emerald_ore" | "minecraft:recipes/transportation/oak_chest_boat" | "ad_astra:recipes/misc/magenta_industrial_lamp" | "hexcasting:recipes/redstone/edified_door" | "hexcasting:recipes/brainsweep/brainsweep/directrix_redstone" | "minecraft:recipes/redstone/target" | "farmersdelight:recipes/decorations/blue_hanging_canvas_sign" | "tconstruct:recipes/misc/gadgets/slimesling/ichor" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_slab" | "minecraft:recipes/redstone/crimson_door" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_flat_slashed_locometal" | "ad_astra:recipes/misc/stonecutting/glacio_stone_brick_slab_from_glacio_stone_stonecutting" | "classicpipes:recipes/request_pipe_a" | "create:recipes/misc/smelting/lead_ingot_compat_oreganized" | "farmersdelight:recipes/cooking/apple_cider" | "minecraft:recipes/misc/copper_ingot_from_waxed_copper_block" | "tconstruct:recipes/building_blocks/common/firewood/nahuatl_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_pillar" | "iceandfire:recipes/combat/tide_red_leggings" | "minecraft:recipes/redstone/acacia_door" | "ad_astra:recipes/misc/glowing_calorite_pillar" | "create:recipes/misc/crafting/appliances/copper_diving_helmet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_smokebox" | "biomesoplenty:recipes/building_blocks/null_end_stone" | "minecraft:recipes/misc/tide_armor_trim_smithing_template" | "ae2:recipes/misc/network/blocks/interfaces_interface" | "ae2:recipes/misc/network/parts/quartz_fiber_part" | "minecraft:recipes/decorations/spruce_fence" | "minecraft:recipes/tools/diamond_hoe" | "create:recipes/building_blocks/crafting/logistics/cyan_table_cloth" | "minecraft:recipes/transportation/activator_rail" | "minecraft:recipes/building_blocks/dark_oak_stairs" | "minecraft:recipes/tools/diamond_shovel" | "biomesoplenty:recipes/building_blocks/cut_orange_sandstone_slab_from_cut_orange_sandstone_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_slab_from_polished_granite_stonecutting" | "farmersdelight:recipes/cooking/squid_ink_pasta" | "ad_astra:recipes/misc/small_black_industrial_lamp" | "minecraft:husbandry/safely_harvest_honey" | "sophisticatedbackpacks:recipes/misc/netherite_backpack" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_locometal_pillar" | "biomesoplenty:recipes/building_blocks/black_sandstone_slab" | "create:recipes/building_blocks/polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "minecraft:recipes/building_blocks/granite_slab" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_honeycomb" | "extendedae:recipes/misc/caner" | "ad_astra:recipes/space_stations/space_station/venus_orbit_space_station" | "ae2:recipes/misc/network/parts/panels_dark_monitor" | "minecraft:adventure/spyglass_at_ghast" | "minecraft:adventure/trim_with_any_armor_pattern" | "minecraft:nether/uneasy_alliance" | "ad_astra:under_pressure" | "hexcasting:recipes/misc/dye_colorizer_pink" | "farmersdelight:recipes/misc/book_from_canvas" | "ad_astra:recipes/misc/steel_panel" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "tconstruct:recipes/misc/smeltery/scorched/scorched_ladder" | "ad_astra:recipes/misc/desh_fluid_pipe" | "farmersdelight:main/eat_comfort_food" | "classicpipes:recipes/cherry_fluid_pipe_a" | "minecraft:recipes/redstone/redstone_from_blasting_redstone_ore" | "create:recipes/building_blocks/small_limestone_brick_slab" | "tconstruct:recipes/misc/common/glass/red_clear_stained_glass" | "create:recipes/building_blocks/cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_slashed_locometal" | "ad_astra:recipes/misc/smelting/mars_stone_from_smelting_mars_cobblestone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal_boiler" | "create:long_train" | "tconstruct:recipes/misc/smeltery/seared/chute" | "railways:recipes/misc/crafting/palettes/wrapping/brown_brass_wrapped_locometal" | "farmersdelight:main/plant_all_crops" | "create:recipes/building_blocks/crafting/logistics/green_table_cloth_from_other_table_cloth" | "create:recipes/misc/blasting/ingot_tin_compat_mekanism" | "biomesoplenty:recipes/building_blocks/cut_black_sandstone_slab" | "create:recipes/building_blocks/cut_granite_from_stone_types_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_diorite_stonecutting" | "railways:recipes/transportation/benchcart" | "create:recipes/building_blocks/industrial_iron_window" | "iceandfire:recipes/combat/armor_sapphire_helmet" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_flat_slashed_locometal" | "tconstruct:recipes/misc/common/slime/ichor/crystal_growing" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_3" | "ad_astra:recipes/misc/smelting/calorite_ingot_from_smelting_venus_calorite_ore" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_4" | "railways:recipes/misc/crafting/palettes/wrapping/black_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_2" | "create:recipes/building_blocks/cut_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "ad_astra:recipes/misc/smelting/cracked_mars_stone_bricks_from_smelting_mars_stone_bricks" | "minecraft:recipes/building_blocks/dye_black_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal_boiler" | "ae2:recipes/misc/misc/deconstruction_smooth_certus_quartz_block" | "minecraft:recipes/building_blocks/waxed_copper_block_from_honeycomb" | "ad_astra:recipes/misc/polished_mars_stone" | "minecraft:recipes/building_blocks/weathered_cut_copper" | "biomesoplenty:recipes/redstone/fir_button" | "create:recipes/building_blocks/cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "ae2:recipes/misc/decorative/chiseled_quartz_block" | "iceandfire:recipes/misc/chain_sticky" | "minecraft:recipes/redstone/warped_trapdoor" | "create:recipes/misc/crafting/kinetics/mechanical_plough" | "ae2:recipes/misc/shaped/slabs/smooth_sky_stone_block" | "create:recipes/misc/smelting/tin_ingot_compat_thermal" | "ad_astra:recipes/misc/smelting/iron_ingot_from_smelting_mars_iron_ore" | "biomesoplenty:recipes/building_blocks/palm_planks" | "minecraft:recipes/building_blocks/dye_brown_wool" | "minecraft:recipes/redstone/light_weighted_pressure_plate" | "ad_astra:recipes/misc/steel_plateblock" | "minecraft:adventure/throw_trident" | "create:recipes/building_blocks/cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "farmersdelight:recipes/cooking/glow_berry_custard" | "create:recipes/misc/crafting/kinetics/belt_connector" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab" | "minecraft:recipes/misc/conduit" | "tconstruct:recipes/building_blocks/common/materials/manyullyn_ingot_from_block" | "create:recipes/building_blocks/spruce_window" | "ad_astra:recipes/misc/cyan_flag" | "biomesoplenty:recipes/redstone/fir_door" | "create:recipes/building_blocks/cut_asurine_slab" | "biomesoplenty:recipes/redstone/redwood_fence_gate" | "hexcasting:recipes/brainsweep/brainsweep/impetus_look" | "tconstruct:recipes/misc/armor/building/travelers_chestplate" | "ae2:main/presses" | "minecraft:recipes/building_blocks/prismarine_stairs_from_prismarine_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_stairs_stonecutter" | "agricraft:recipes/misc/coal" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_polished_andesite_stonecutting" | "minecraft:recipes/decorations/green_candle" | "createoreexcavation:recipes/misc/netherite_drill_smithing" | "ae2:recipes/misc/network/cables/dense_covered_yellow" | "ad_astra:recipes/misc/ostrum_tank" | "biomesoplenty:recipes/building_blocks/maple_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_iron_wrapped_locometal_boiler" | "tconstruct:recipes/misc/common/slime/earth/crystal_smelting" | "tconstruct:recipes/misc/smeltery/scorched/chute" | "biomesoplenty:recipes/building_blocks/orange_sandstone" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "ad_astra:recipes/misc/chiseled_mars_stone_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_slashed_locometal" | "create:recipes/misc/blasting/lead_ingot_compat_modern_industrialization" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade_from_smelting_upgrade" | "ad_astra:recipes/misc/stonecutting/mercury_stone_slab_from_mercury_stone_stonecutting" | "ad_astra:recipes/misc/aeronos_stairs" | "tconstruct:recipes/building_blocks/common/materials/raw_cobalt_from_raw_block" | "iceandfire:recipes/combat/armor_silver_leggings" | "iceandfire:iceandfire/dragon_flute" | "ad_astra:recipes/misc/stonecutting/mars_stone_bricks_from_mars_stone_stonecutting" | "computercraft:recipes/redstone/wireless_modem_normal" | "create:recipes/misc/blasting/tin_ingot_compat_modern_industrialization" | "ad_astra:recipes/misc/stonecutting/polished_moon_stone_from_moon_stone_stonecutting" | "ad_astra:recipes/misc/mars_stone_brick_stairs" | "minecraft:recipes/decorations/bamboo_fence" | "ad_astra:recipes/misc/aeronos_ladder" | "ae2:recipes/misc/network/cells/fluid_cell_housing" | "farmersdelight:recipes/decorations/white_hanging_canvas_sign" | "create:recipes/misc/crafting/logistics/content_observer" | "minecraft:recipes/building_blocks/polished_granite_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "create:recipes/building_blocks/crafting/logistics/red_table_cloth" | "minecraft:recipes/redstone/repeater" | "minecraft:recipes/tools/compass" | "farmersdelight:recipes/food/kelp_roll" | "create:recipes/misc/crafting/kinetics/fluid_pipe_vertical" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_flat_riveted_locometal" | "minecraft:adventure/ol_betsy" | "tconstruct:recipes/misc/common/slime/blood/congealed" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_smokebox" | "ad_astra:recipes/misc/moon_stone_bricks" | "minecraft:recipes/building_blocks/quartz_block" | "minecraft:recipes/decorations/gray_candle" | "hexcasting:recipes/misc/decompose_quenched_shard/charged" | "ae2:recipes/misc/network/blocks/quantum_ring" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_vine" | "ad_astra:recipes/misc/desh_plating_pressure_plate" | "iceandfire:recipes/combat/ghost_sword" | "ae2:recipes/misc/network/cables/dense_smart_brown" | "create:recipes/building_blocks/cut_crimsite_brick_slab" | "biomesoplenty:recipes/building_blocks/mahogany_planks" | "iceandfire:recipes/tools/silver_sword" | "ae2:recipes/misc/network/blocks/crystal_processing_growth_accelerator" | "ad_astra:recipes/compressing/compressing/steel_plate_from_compressing_steel_ingots" | "minecraft:recipes/decorations/cyan_bed" | "classicpipes:recipes/warped_fluid_pipe_a" | "create:recipes/building_blocks/polished_cut_dripstone_wall" | "ad_astra:recipes/misc/blasting/cheese_from_blasting_moon_cheese_ore" | "ad_astra:recipes/misc/venus_sandstone_brick_slab" | "minecraft:nether/netherite_armor" | "minecraft:recipes/building_blocks/birch_stairs" | "minecraft:recipes/building_blocks/jungle_stairs" | "minecraft:recipes/building_blocks/purpur_pillar" | "iceandfire:recipes/building_blocks/sea_serpent_scales_blue_to_sea_serpent_scale_block_blue" | "minecraft:recipes/food/pumpkin_pie" | "minecraft:recipes/decorations/end_rod" | "minecraft:recipes/misc/host_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/small_veridium_brick_slab_recycling" | "create:recipes/building_blocks/cut_calcite_stairs" | "ad_astra:recipes/misc/moon_stone_brick_slab" | "create:recipes/building_blocks/polished_cut_ochrum_wall" | "biomesoplenty:recipes/decorations/maple_sign" | "minecraft:husbandry/breed_an_animal" | "tconstruct:recipes/building_blocks/common/materials/pig_iron_ingot_from_nuggets" | "create:recipes/building_blocks/polished_cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/combat/netherite_helmet_smithing" | "biomesoplenty:recipes/decorations/dead_fence" | "iceandfire:recipes/combat/amphithere_macuahuitl" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_sword" | "biomesoplenty:recipes/building_blocks/cut_white_sandstone" | "hexcasting:recipes/building_blocks/amethyst_bricks_small_from_amethyst_bricks" | "ad_astra:recipes/misc/calorite_panel" | "minecraft:husbandry/complete_catalogue" | "iceandfire:recipes/combat/armor_sapphire_chestplate" | "minecraft:recipes/decorations/gray_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/stripped_spruce_wood" | "create:recipes/building_blocks/small_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "minecraft:recipes/decorations/brown_stained_glass_pane" | "iceandfire:recipes/combat/armor_copper_metal_leggings" | "create:recipes/misc/crafting/kinetics/mechanical_pump" | "ae2:recipes/misc/decorative/sky_stone_small_brick_from_stonecutting" | "farmersdelight:recipes/decorations/lime_canvas_sign" | "farmersdelight:recipes/decorations/black_hanging_canvas_sign" | "tconstruct:recipes/misc/common/glass/blue_clear_stained_glass_pane" | "ad_astra:recipes/misc/blasting/ice_shard_from_blasting_deepslate_ice_shard_ore" | "tconstruct:recipes/misc/common/glass/purple_clear_stained_glass_pane_from_panes" | "ad_astra:recipes/space_stations/space_station/mars_orbit_space_station" | "railways:recipes/misc/stonecutting/palettes/cycling/black_flat_riveted_locometal" | "hexical:conjure_hexxy" | "iceandfire:recipes/misc/dragonscale_bronze_to_dragonscales_bronze" | "iceandfire:iceandfire/dragon_horn" | "create:recipes/building_blocks/deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs" | "ae2:recipes/misc/network/cables/smart_fluix" | "hexcasting:recipes/misc/dye_colorizer_orange" | "create:recipes/misc/crafting/logistics/display_link" | "ae2:main/charged_quartz" | "ae2:recipes/misc/tools/fluix_shovel" | "ad_astra:recipes/misc/glacian_slab" | "iceandfire:recipes/combat/forest_troll_leather_boots" | "ad_astra:recipes/misc/calorite_ingot_from_calorite_block" | "iceandfire:recipes/misc/skull_to_bone_meal" | "biomesoplenty:recipes/redstone/umbran_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal_boiler" | "comforts:sleeping_bag_light_blue" | "minecraft:recipes/building_blocks/stripped_cherry_wood" | "minecraft:recipes/decorations/gray_glazed_terracotta" | "minecraft:recipes/misc/light_blue_dye_from_blue_orchid" | "ad_astra:rover" | "biomesoplenty:recipes/building_blocks/fir_stairs" | "iceandfire:recipes/misc/dragonscale_green_to_dragonscales_green" | "minecraft:recipes/building_blocks/red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs" | "minecraft:recipes/building_blocks/lime_concrete_powder" | "ad_astra:recipes/misc/stonecutting/chiseled_moon_stone_slab_from_chiseled_moon_stone_bricks_stonecutting" | "ad_astra:recipes/misc/stonecutting/chiseled_moon_stone_bricks_from_moon_stone_stonecutting" | "create:recipes/building_blocks/crimson_window" | "create:recipes/building_blocks/cut_granite_brick_stairs_from_stone_types_granite_stonecutting" | "biomesoplenty:recipes/building_blocks/black_sandstone_stairs" | "ad_astra:recipes/misc/ostrum_factory_block" | "farmersdelight:recipes/food/hamburger" | "minecraft:recipes/building_blocks/copper_block" | "biomesoplenty:recipes/building_blocks/magic_stairs" | "classicpipes:recipes/jungle_pipe" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_smokebox" | "iceandfire:iceandfire/root" | "minecraft:recipes/building_blocks/dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "farmersdelight:recipes/food/rice" | "create:train_portal" | "ad_astra:recipes/misc/stonecutting/mars_pillar_from_mars_stone_bricks_stonecutting" | "minecraft:recipes/redstone/spruce_button" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_riveted_locometal" | "sophisticatedbackpacks:recipes/misc/xp_pump_upgrade" | "ad_astra:interstellar" | "minecraft:recipes/misc/popped_chorus_fruit" | "minecraft:nether/distract_piglin" | "tconstruct:recipes/building_blocks/world/wood/skyroot/fence" | "minecraft:recipes/misc/flower_banner_pattern" | "ae2:recipes/misc/smelting/smooth_sky_stone_block" | "ae2:recipes/misc/tools/paintballs_lime" | "iceandfire:iceandfire/jar_pixie" | "tconstruct:recipes/misc/tables/book_substitute" | "biomesoplenty:recipes/decorations/pine_hanging_sign" | "biomesoplenty:recipes/decorations/umbran_fence" | "ae2:recipes/misc/network/cables/dense_covered_red" | "biomesoplenty:recipes/building_blocks/mossy_cobblestone_from_willow_vine" | "farmersdelight:recipes/food/apple_pie" | "tconstruct:recipes/misc/smeltery/seared/basin" | "minecraft:recipes/building_blocks/sandstone_stairs" | "sophisticatedbackpacks:recipes/misc/void_upgrade" | "minecraft:recipes/redstone/dark_oak_door" | "comforts:hammock_purple" | "ad_astra:recipes/misc/mars_stone_stairs" | "extendedae:recipes/misc/mod_export_bus" | "minecraft:recipes/misc/coal_from_smelting_deepslate_coal_ore" | "create:mechanical_pump_0" | "create:brass" | "create:recipes/building_blocks/polished_cut_limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smoking" | "minecraft:recipes/redstone/hopper" | "iceandfire:iceandfire/tame_cockatrice" | "create:recipes/misc/crafting/kinetics/mechanical_harvester" | "biomesoplenty:recipes/decorations/mahogany_fence" | "create:recipes/building_blocks/polished_cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal" | "lootr:1shulker" | "minecraft:recipes/redstone/calibrated_sculk_sensor" | "create:recipes/building_blocks/cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_locometal_smokebox" | "farmersdelight:recipes/food/cooked_bacon_from_campfire_cooking" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "ad_astra:recipes/misc/stonecutting/chiseled_mars_stone_bricks_from_mars_stone_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/white_locometal_pillar" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "ratatouille:recipes/decorations/mauve_plush" | "minecraft:recipes/misc/lime_dye" | "create:recipes/misc/crafting/materials/zinc_ingot_from_compacting" | "minecraft:recipes/misc/gold_ingot_from_smelting_raw_gold" | "iceandfire:recipes/combat/dragonbone_sword_lightning" | "classicpipes:recipes/matching_pipe_a" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal" | "iceandfire:recipes/misc/nest" | "biomesoplenty:recipes/redstone/maple_trapdoor" | "minecraft:recipes/building_blocks/smooth_basalt" | "create:recipes/building_blocks/small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "iceandfire:recipes/building_blocks/dragonscales_white_to_dragonscale_white" | "ad_astra:recipes/misc/blasting/coal_from_blasting_glacio_coal_ore" | "create:recipes/misc/crafting/palettes/scorchia" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template" | "create:recipes/building_blocks/small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_flat_riveted_locometal" | "create:recipes/misc/smoking/bread" | "minecraft:recipes/building_blocks/tinted_glass" | "iceandfire:recipes/combat/deathworm_red_leggings" | "minecraft:recipes/building_blocks/dye_blue_wool" | "sophisticatedbackpacks:recipes/misc/smelting_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_scoria_stairs" | "minecraft:recipes/redstone/comparator" | "minecraft:recipes/redstone/mangrove_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal_boiler" | "hexcasting:recipes/misc/dye_colorizer_light_gray" | "create:recipes/building_blocks/polished_cut_granite_from_stone_types_granite_stonecutting" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_lightning_head" | "hexical:educate_lamp" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_slab" | "farmersdelight:recipes/cooking/hot_cocoa" | "minecraft:recipes/decorations/deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "biomesoplenty:recipes/building_blocks/stripped_fir_wood" | "create:recipes/building_blocks/small_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "create:recipes/misc/crafting/appliances/tree_fertilizer" | "minecraft:recipes/building_blocks/red_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_pillar" | "agricraft:recipes/tools/obsidian_crop_sticks" | "minecraft:adventure/very_very_frightening" | "ae2:recipes/misc/decorative/certus_quartz_bricks_from_stonecutting" | "minecraft:story/lava_bucket" | "ad_astra:recipes/misc/blasting/iron_ingot_from_blasting_glacio_iron_ore" | "farmersdelight:recipes/food/chocolate_pie" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_plated_locometal" | "farmersdelight:recipes/food/cooked_bacon_from_smoking" | "computercraft:recipes/redstone/printed_pages" | "minecraft:recipes/building_blocks/quartz_stairs" | "create:recipes/misc/crafting/kinetics/secondary_linear_chassis_from_conversion" | "create:recipes/building_blocks/cut_crimsite_wall" | "create:recipes/building_blocks/horizontal_framed_glass_from_colorless_glass_stonecutting" | "create:recipes/building_blocks/polished_cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "ae2:recipes/misc/materials/carddistribution" | "minecraft:recipes/misc/copper_ingot_from_blasting_raw_copper" | "tconstruct:world/slime_collector" | "create:recipes/building_blocks/crafting/logistics/orange_table_cloth_from_other_table_cloth" | "biomesoplenty:recipes/redstone/mahogany_pressure_plate" | "ae2:main/crafting_cpu" | "tconstruct:recipes/misc/common/glass/blue_clear_stained_glass" | "ad_astra:recipes/misc/small_pink_industrial_lamp" | "minecraft:recipes/decorations/black_bed" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_locometal_pillar" | "create:recipes/building_blocks/small_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "ad_astra:tier_3_rocket" | "create:recipes/building_blocks/layered_scoria_from_stone_types_scoria_stonecutting" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "tconstruct:recipes/misc/common/glass/white_clear_stained_glass" | "ae2:recipes/misc/network/cables/covered_light_blue" | "create:recipes/building_blocks/crafting/kinetics/red_seat_from_other_seat" | "iceandfire:recipes/misc/sea_serpent_scale_block_teal_to_sea_serpent_scales_teal" | "lootr:social" | "tconstruct:recipes/misc/smeltery/scorched/fuel_tank" | "hexcasting:recipes/misc/pride_colorizer_lesbian" | "ae2:recipes/misc/decorative/cut_quartz_block_from_stonecutting" | "railways:recipes/combat/dying_existing_cap_magenta" | "railways:recipes/misc/crafting/smokestack_coalburner" | "ad_astra:recipes/misc/stonecutting/glacio_cobblestone_slab_from_glacio_cobblestone_stonecutting" | "farmersdelight:recipes/combat/netherite_knife_smithing" | "create:recipes/misc/crafting/kinetics/speedometer_from_conversion" | "minecraft:recipes/building_blocks/polished_deepslate_from_cobbled_deepslate_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_slab" | "sophisticatedbackpacks:recipes/misc/backpack" | "ae2:recipes/misc/block_cutter/slabs/smooth_sky_stone_slab" | "ad_astra:recipes/misc/calorite_nugget" | "create:recipes/building_blocks/cut_granite_brick_slab_recycling" | "minecraft:recipes/food/cooked_beef_from_smoking" | "iceandfire:recipes/misc/sea_serpent_scale_block_blue_to_sea_serpent_scales_blue" | "create:recipes/building_blocks/polished_cut_dripstone_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_slashed_locometal" | "create:recipes/building_blocks/crafting/logistics/yellow_table_cloth_from_other_table_cloth" | "minecraft:recipes/decorations/pink_stained_glass_pane" | "farmersdelight:recipes/decorations/spruce_cabinet" | "create:recipes/misc/blasting/lead_ingot_compat_techreborn" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_pillar" | "minecraft:nether/all_potions" | "minecraft:recipes/misc/emerald_from_blasting_emerald_ore" | "create:recipes/building_blocks/crafting/logistics/purple_postbox_from_other_postbox" | "minecraft:recipes/misc/diamond_from_smelting_deepslate_diamond_ore" | "hexcasting:grant_patchi_book" | "create:recipes/building_blocks/cut_andesite_bricks_from_stone_types_andesite_stonecutting" | "minecraft:recipes/combat/netherite_boots_smithing" | "minecraft:recipes/misc/light_blue_dye_from_blue_white_dye" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_flat_slashed_locometal" | "ae2:main/network3" | "create:recipes/building_blocks/cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "ad_astra:recipes/misc/airlock" | "ae2:main/network2" | "iceandfire:recipes/combat/tide_red_boots" | "ae2:recipes/misc/shaped/stairs/cut_quartz_block" | "ae2:main/network1" | "minecraft:recipes/building_blocks/orange_concrete_powder" | "minecraft:recipes/food/cooked_porkchop" | "minecraft:recipes/building_blocks/oak_slab" | "ad_astra:recipes/misc/moon_cobblestone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_flat_slashed_locometal" | "ae2:recipes/misc/block_cutter/slabs/cut_quartz_slab" | "farmersdelight:recipes/food/cooked_chicken_cuts_from_campfire_cooking" | "minecraft:husbandry/tame_an_animal" | "create:recipes/building_blocks/crafting/kinetics/orange_seat_from_other_seat" | "iceandfire:recipes/combat/deathworm_white_boots" | "ae2:recipes/misc/network/parts/monitors_storage" | "ad_astra:recipes/misc/raw_ostrum" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone" | "minecraft:recipes/building_blocks/raw_copper_block" | "farmersdelight:recipes/food/roasted_mutton_chops" | "minecraft:recipes/building_blocks/granite_stairs" | "iceandfire:recipes/building_blocks/dread_stone_bricks" | "iceandfire:recipes/combat/dragonarmor_silver_tail" | "minecraft:recipes/decorations/cyan_glazed_terracotta" | "create:recipes/building_blocks/small_andesite_bricks_from_stone_types_andesite_stonecutting" | "hexcasting:recipes/misc/pride_colorizer_agender" | "minecraft:recipes/building_blocks/dye_red_bed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_copper_wrapped_locometal" | "minecraft:recipes/building_blocks/dye_black_bed" | "minecraft:recipes/tools/brush" | "hexcasting:recipes/redstone/edified_button" | "minecraft:recipes/decorations/cyan_candle" | "minecraft:recipes/building_blocks/diorite_stairs_from_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_pillar" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_slab" | "minecraft:recipes/building_blocks/stripped_acacia_wood" | "classicpipes:recipes/bone_pipe" | "minecraft:recipes/misc/leather" | "create:recipes/building_blocks/cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/misc/crafting/curiosities/minecart_coupling" | "ad_astra:recipes/misc/chiseled_moon_stone_stairs" | "tconstruct:recipes/misc/gadgets/punji" | "create:recipes/building_blocks/cut_veridium_from_stone_types_veridium_stonecutting" | "ad_astra:recipes/misc/iron_rod" | "biomesoplenty:recipes/redstone/palm_button" | "iceandfire:recipes/building_blocks/sea_serpent_scales_deepblue_to_sea_serpent_scale_block_deepblue" | "farmersdelight:recipes/decorations/brown_hanging_canvas_sign" | "minecraft:recipes/decorations/light_gray_bed" | "farmersdelight:recipes/building_blocks/tomato_crate" | "ad_astra:recipes/misc/glowing_ostrum_pillar" | "create:recipes/building_blocks/acacia_window_pane" | "classicpipes:recipes/obsidian_pipe" | "minecraft:recipes/building_blocks/blackstone_stairs" | "tconstruct:recipes/misc/common/glass/black_clear_stained_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_slashed_locometal" | "tconstruct:recipes/misc/armor/building/travelers_boots" | "farmersdelight:recipes/misc/gold_nugget_from_smelting_knife" | "ae2:recipes/misc/tools/paintballs_lumen_black" | "create:windmill_maxed" | "create:recipes/misc/crafting/kinetics/deployer" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_tuff_wall_from_stone_types_tuff_stonecutting" | "farmersdelight:recipes/food/cooked_salmon_slice" | "create:recipes/misc/crafting/appliances/copper_diving_boots" | "create:recipes/building_blocks/cut_limestone_wall_from_stone_types_limestone_stonecutting" | "minecraft:recipes/transportation/bamboo_chest_raft" | "ad_astra:recipes/misc/steel_cable" | "minecraft:recipes/decorations/cyan_banner" | "ae2:recipes/misc/decorative/certus_quartz_pillar" | "ad_astra:recipes/misc/stonecutting/polished_mars_stone_slab_from_polished_mars_stone_stonecutting" | "hexcasting:recipes/decorations/scroll_small" | "minecraft:recipes/decorations/red_banner" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/raw_gold_block" | "minecraft:recipes/building_blocks/dye_red_wool" | "minecraft:recipes/combat/iron_boots" | "tconstruct:recipes/misc/common/glass/orange_clear_stained_glass_pane_from_panes" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_slashed_locometal" | "ad_astra:recipes/misc/stonecutting/moon_cobblestone_slab_from_moon_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/birch_planks" | "railways:recipes/misc/crafting/palettes/wrapping/copper_wrapped_locometal" | "ae2:recipes/misc/network/cells/item_storage_components_cell_16k_part" | "iceandfire:recipes/combat/dragonarmor_copper_body" | "comforts:sleeping_bag_white" | "ae2:main/storage_bus" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_boiler" | "ae2:recipes/misc/block_cutter/slabs/quartz_brick_slab" | "create:recipes/building_blocks/acacia_window" | "iceandfire:recipes/building_blocks/dragonforge_lightning_core_disabled" | "create:recipes/misc/smelting/glass_from_tiled_glass" | "iceandfire:recipes/combat/dragonbone_bow" | "create:track_0" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_blackstone_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_deepslate_gold_ore" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_flat_slashed_locometal" | "minecraft:recipes/redstone/spruce_pressure_plate" | "iceandfire:iceandfire/kill_sea_serpent" | "minecraft:recipes/building_blocks/granite_stairs_from_granite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs_from_prismarine_stonecutting" | "ad_astra:recipes/misc/blue_flag" | "minecraft:recipes/misc/gold_ingot_from_blasting_gold_ore" | "railways:recipes/misc/crafting/palettes/wrapping/black_copper_wrapped_locometal" | "minecraft:recipes/decorations/magenta_glazed_terracotta" | "ae2:recipes/misc/network/blocks/energy_energy_cell" | "ae2:recipes/misc/tools/certus_quartz_spade" | "tconstruct:recipes/misc/common/gold_bars" | "create:recipes/misc/crafting/kinetics/clutch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_brass_wrapped_locometal_boiler" | "hexal:recipes/freeze/freeze/powder_snow_cauldron" | "iceandfire:recipes/combat/mountain_troll_leather_chestplate" | "create:recipes/building_blocks/polished_cut_deepslate_stairs" | "ad_astra:recipes/misc/stonecutting/mars_stone_brick_wall_from_mars_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_polished_granite_stonecutting" | "ae2:recipes/misc/network/parts/energy_acceptor" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/refill_upgrade" | "ad_astra:recipes/misc/mercury_cobblestone_stairs" | "minecraft:recipes/building_blocks/mud_brick_stairs" | "ae2:recipes/misc/network/parts/cable_anchor" | "ad_astra:recipes/misc/stonecutting/moon_stone_bricks_from_moon_stone_stonecutting" | "classicpipes:autocraft_eight_steps" | "minecraft:recipes/building_blocks/dye_blue_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_riveted_locometal" | "iceandfire:iceandfire/kill_stymphalian_bird" | "hexcasting:recipes/building_blocks/amethyst_tiles" | "create:recipes/building_blocks/cut_dripstone_stairs" | "create:recipes/building_blocks/copper_tile_stairs" | "minecraft:recipes/building_blocks/dye_light_gray_wool" | "create:recipes/misc/crafting/curiosities/cake" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_riveted_locometal" | "ae2:recipes/misc/network/crafting/16k_cpu_crafting_storage" | "iceandfire:recipes/combat/armor_black_boots" | "ad_astra:recipes/misc/smelting/calorite_ingot_from_smelting_deepslate_calorite_ore" | "minecraft:recipes/decorations/magenta_banner" | "minecraft:recipes/tools/stone_pickaxe" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "iceandfire:recipes/combat/armor_white_chestplate" | "create:recipes/decorations/brass_bars_from_brass_ingots_stonecutting" | "create:recipes/misc/crafting/kinetics/depot" | "ad_astra:recipes/misc/stonecutting/chiseled_glacio_stone_bricks_from_glacio_stone_bricks_stonecutting" | "minecraft:recipes/decorations/deepslate_brick_wall" | "iceandfire:recipes/combat/forest_troll_leather_leggings" | "railways:recipes/misc/stonecutting/palettes/cycling/red_riveted_locometal" | "create:recipes/misc/crafting/logistics/brown_table_cloth_clear" | "hexcasting:recipes/building_blocks/quenched_allay_bricks_from_quenched_allay_bricks_small" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal" | "minecraft:recipes/misc/black_dye" | "minecraft:recipes/building_blocks/light_gray_stained_glass" | "minecraft:recipes/food/honey_bottle" | "ad_astra:recipes/misc/blasting/desh_ingot_from_blasting_raw_desh" | "ad_astra:recipes/misc/smelting/copper_ingot_from_smelting_glacio_copper_ore" | "railways:recipes/misc/crafting/palettes/wrapping/brown_iron_wrapped_locometal" | "ad_astra:recipes/misc/stonecutting/moon_cobblestone_stairs_from_moon_cobblestone_stonecutting" | "create:recipes/building_blocks/layered_calcite_from_stone_types_calcite_stonecutting" | "ratatouille:recipes/decorations/folly_plush" | "minecraft:recipes/misc/light_gray_dye_from_gray_white_dye" | "create:recipes/building_blocks/small_crimsite_brick_wall" | "minecraft:recipes/decorations/acacia_sign" | "ae2:recipes/misc/network/cables/covered_purple" | "ae2:recipes/misc/shaped/stairs/quartz_pillar" | "minecraft:recipes/building_blocks/brick_slab" | "create:recipes/combat/crafting/appliances/netherite_backtank" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/iron_ingot_from_smelting_iron_ore" | "ae2:recipes/misc/network/cells/spatial_storage_cell_2_cubed_storage" | "minecraft:recipes/decorations/lantern" | "lootr:50loot" | "tconstruct:recipes/building_blocks/common/materials/rose_gold_ingot_from_nuggets" | "minecraft:recipes/decorations/cherry_sign" | "extendedae:recipes/misc/mod_storage_bus" | "hexcasting:recipes/tools/staff/warped" | "ad_astra:recipes/misc/stonecutting/permafrost_pillar_from_permafrost_stonecutting" | "create:recipes/building_blocks/cut_scorchia_brick_slab_recycling" | "ae2:recipes/misc/network/blocks/storage_chest" | "create:recipes/misc/crafting/kinetics/minecart_from_contraption_cart" | "create:recipes/building_blocks/crafting/logistics/white_table_cloth_from_other_table_cloth" | "iceandfire:recipes/combat/armor_amythest_helmet" | "iceandfire:recipes/combat/deathworm_red_helmet" | "hexcasting:recipes/decorations/scroll_medium" | "farmersdelight:recipes/food/beef_patty" | "railways:recipes/misc/crafting/palettes/wrapping/white_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_brass_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1_from_starter" | "biomesoplenty:recipes/redstone/umbran_fence_gate" | "tconstruct:recipes/misc/common/glass/vanilla/glass_bottle" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal_boiler" | "biomesoplenty:recipes/decorations/jacaranda_hanging_sign" | "sophisticatedbackpacks:recipes/misc/stonecutter_upgrade" | "ae2:recipes/misc/tools/paintballs_brown" | "ad_astra:recipes/misc/smelting/cheese_from_smelting_moon_cheese_ore" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/cut_diorite_brick_slab_recycling" | "create:recipes/building_blocks/ornate_iron_window" | "create:recipes/misc/crafting/kinetics/attribute_filter" | "ad_astra:recipes/misc/cyan_industrial_lamp" | "ad_astra:recipes/misc/jet_suit_helmet" | "minecraft:recipes/misc/orange_dye_from_red_yellow" | "create:recipes/building_blocks/cut_crimsite_slab_recycling" | "ad_astra:recipes/cryo_freezing/cryo_freezing/cryo_fuel_from_cryo_freezing_packed_ice" | "railways:recipes/misc/crafting/track_switch_andesite" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_smokebox" | "minecraft:adventure/fall_from_world_height" | "biomesoplenty:recipes/building_blocks/stripped_umbran_wood" | "minecraft:recipes/misc/gold_ingot_from_blasting_nether_gold_ore" | "create:fist_bump" | "minecraft:recipes/building_blocks/dye_orange_bed" | "hexcasting:recipes/misc/dye_colorizer_purple" | "minecraft:recipes/food/rabbit_stew_from_brown_mushroom" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/magenta_concrete_powder" | "minecraft:recipes/decorations/blue_bed" | "minecraft:recipes/decorations/green_bed" | "create:recipes/building_blocks/cut_scorchia_brick_stairs" | "extendedae:recipes/misc/crystal_fixer" | "railways:recipes/misc/stonecutting/palettes/cycling/black_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_smokebox" | "tconstruct:recipes/building_blocks/world/wood/skyroot/log_to_wood" | "minecraft:recipes/building_blocks/cut_sandstone_from_sandstone_stonecutting" | "ad_astra:recipes/misc/smelting/venus_stone_from_smelting_venus_cobblestone" | "biomesoplenty:recipes/redstone/willow_trapdoor" | "iceandfire:iceandfire/bestiary" | "ad_astra:recipes/misc/stonecutting/venus_stone_stairs_from_venus_stone_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_slab_from_honeycomb" | "minecraft:recipes/decorations/campfire" | "railways:recipes/misc/stonecutting/palettes/cycling/red_locometal_smokebox" | "create:recipes/misc/crafting/materials/cardboard_from_block" | "minecraft:recipes/decorations/lime_stained_glass_pane" | "ad_astra:recipes/misc/fuel_refinery" | "minecraft:recipes/misc/snout_armor_trim_smithing_template" | "biomesoplenty:recipes/building_blocks/maple_stairs" | "create:recipes/misc/blasting/nickel_ingot_compat_modern_industrialization" | "minecraft:recipes/transportation/hopper_minecart" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_plated_locometal" | "classicpipes:recipes/acacia_pipe" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_plated_locometal" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "railways:recipes/combat/dying_existing_cap_light_blue" | "tconstruct:recipes/misc/smeltery/seared/grout" | "farmersdelight:recipes/cooking/dumplings" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_riveted_locometal" | "ae2:recipes/misc/block_cutter/walls/quartz_pillar_wall" | "create:recipes/misc/crafting/kinetics/sail_frame_from_conversion" | "create:recipes/building_blocks/cut_ochrum_brick_wall" | "farmersdelight:recipes/food/sweet_berry_cheesecake_from_slices" | "sophisticatedbackpacks:recipes/misc/chipped/botanist_workbench_upgrade" | "minecraft:recipes/building_blocks/terracotta" | "extendedae:recipes/misc/epp" | "minecraft:recipes/misc/red_dye_from_beetroot" | "ad_astra:recipes/misc/smelting/iron_ingot_from_smelting_glacio_iron_ore" | "ae2:recipes/misc/tools/paintballs_lumen_green" | "hexcasting:recipes/building_blocks/stonecutting/slate_bricks_small" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_iron_wrapped_locometal" | "biomesoplenty:recipes/redstone/hellbark_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_smokebox" | "create:display_link" | "extendedae:recipes/misc/epa" | "ad_astra:recipes/space_stations/space_station/glacio_orbit_space_station" | "farmersdelight:main/get_ham" | "create:recipes/building_blocks/scoria_pillar_from_stone_types_scoria_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_slab_stonecutter" | "agricraft:recipes/misc/copper_ingot" | "extendedae:recipes/misc/wireless_tool" | "minecraft:recipes/redstone/jungle_trapdoor" | "minecraft:recipes/tools/wooden_hoe" | "create:recipes/building_blocks/polished_cut_scorchia_from_stone_types_scorchia_stonecutting" | "sophisticatedbackpacks:recipes/misc/pickup_upgrade" | "farmersdelight:recipes/decorations/light_blue_canvas_sign" | "ad_astra:recipes/nasa_workbench/nasa_workbench/tier_1_rocket_from_nasa_workbench" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_pillar" | "tconstruct:recipes/misc/smeltery/seared/seared_stone_smelting" | "iceandfire:recipes/combat/dragonarmor_gold_head" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_brass_wrapped_locometal" | "ad_astra:recipes/compressing/compressing/desh_plate_from_compressing_desh_ingots" | "farmersdelight:recipes/decorations/orange_canvas_sign" | "railways:recipes/misc/crafting/palettes/wrapping/black_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/chiseled_sandstone_from_sandstone_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_polished_deepslate_stonecutting" | "minecraft:recipes/decorations/granite_wall" | "ae2:recipes/misc/network/cables/glass_fluix" | "create:recipes/building_blocks/crafting/logistics/pink_table_cloth_from_other_table_cloth" | "create:recipes/building_blocks/copper_tile_slab_from_copper_tiles_stonecutting" | "ad_astra:recipes/misc/smelting/cracked_venus_sandstone_bricks_from_smelting_venus_sandstone_bricks" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal" | "tconstruct:smeltery/puny_smelting" | "create:recipes/building_blocks/crafting/logistics/gray_postbox" | "minecraft:recipes/building_blocks/orange_terracotta" | "tconstruct:recipes/misc/common/slime/ichor/slimeball_from_block" | "ad_astra:recipes/misc/nasa_workbench" | "minecraft:recipes/misc/silence_armor_trim_smithing_template" | "create:recipes/misc/crafting/schematics/schematicannon" | "ad_astra:recipes/misc/stonecutting/glacio_stone_bricks_from_glacio_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_boiler" | "ad_astra:recipes/misc/oxygen_loader" | "farmersdelight:recipes/food/cooked_chicken_cuts" | "minecraft:recipes/food/cooked_chicken_from_smoking" | "tconstruct:recipes/misc/common/copper_platform_waxing_weathered" | "minecraft:recipes/redstone/oak_fence_gate" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_flat_riveted_locometal" | "create:recipes/building_blocks/cut_deepslate_brick_slab_recycling" | "create:recipes/misc/crafting/kinetics/metal_girder" | "railways:recipes/misc/stonecutting/palettes/cycling/red_locometal_pillar" | "minecraft:husbandry/bred_all_animals" | "classicpipes:recipes/lapis_fluid_pipe_a" | "ad_astra:recipes/misc/stonecutting/mercury_cobblestone_stairs_from_mercury_cobblestone_stonecutting" | "hexcasting:recipes/redstone/directrix/empty" | "create:recipes/building_blocks/cut_asurine_brick_stairs" | "hexcasting:recipes/tools/staff/mangrove" | "classicpipes:recipes/lapis_pipe" | "create:recipes/building_blocks/cut_diorite_stairs" | "create:recipes/building_blocks/cut_tuff_slab" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_stairs" | "tconstruct:recipes/misc/common/glass/vanilla/beacon" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/green_plated_locometal" | "biomesoplenty:recipes/redstone/maple_pressure_plate" | "create:saw_processing" | "ae2:recipes/misc/network/cables/covered_yellow" | "tconstruct:recipes/misc/smeltery/copper_can" | "minecraft:recipes/misc/charcoal" | "minecraft:recipes/building_blocks/stone_brick_slab" | "ad_astra:recipes/misc/blue_industrial_lamp" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_slab" | "minecraft:recipes/redstone/cherry_pressure_plate" | "minecraft:recipes/redstone/warped_pressure_plate" | "minecraft:recipes/building_blocks/polished_granite_slab_from_granite_stonecutting" | "ae2:recipes/misc/block_cutter/walls/sky_stone_small_brick_wall" | "hexcasting:recipes/misc/pride_colorizer_pansexual" | "minecraft:recipes/building_blocks/polished_andesite_from_andesite_stonecutting" | "ae2:recipes/misc/tools/nether_quartz_pickaxe" | "biomesoplenty:recipes/transportation/hellbark_chest_boat" | "minecraft:recipes/tools/iron_shovel" | "ad_astra:recipes/misc/ostrum_sliding_door" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/stairs" | "create:recipes/building_blocks/cut_asurine_slab_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/copycat_panel_from_zinc_ingots_stonecutting" | "ae2:recipes/misc/network/cells/spatial_storage_cell_16_cubed_storage" | "sophisticatedbackpacks:recipes/misc/jukebox_upgrade" | "create:recipes/misc/crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "minecraft:recipes/food/cooked_salmon_from_campfire_cooking" | "create:recipes/misc/crafting/materials/brass_block_from_compacting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_flat_slashed_locometal" | "iceandfire:recipes/misc/sea_serpent_scale_block_deepblue_to_sea_serpent_scales_deepblue" | "iceandfire:recipes/combat/armor_gray_helmet" | "farmersdelight:recipes/food/cooked_mutton_chops_from_campfire_cooking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_plated_locometal" | "minecraft:recipes/decorations/item_frame" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal" | "farmersdelight:recipes/decorations/gray_hanging_canvas_sign" | "biomesoplenty:recipes/decorations/orange_sandstone_wall_from_orange_sandstone_stonecutting" | "minecraft:recipes/building_blocks/cut_copper_slab" | "farmersdelight:recipes/food/rice_roll_medley_block" | "biomesoplenty:recipes/decorations/dead_sign" | "create:recipes/building_blocks/cut_andesite_brick_wall" | "iceandfire:recipes/building_blocks/dragon_bone_block" | "iceandfire:recipes/building_blocks/dragonscales_black_to_dragonscale_black" | "farmersdelight:recipes/food/cake_from_slices" | "ad_astra:recipes/misc/calorite_factory_block" | "extendedae:recipes/misc/epp_alt" | "create:recipes/building_blocks/cut_veridium_stairs" | "create:recipes/building_blocks/cut_crimsite_from_stone_types_crimsite_stonecutting" | "ad_astra:recipes/misc/ostrum_plateblock" | "create:recipes/building_blocks/jungle_window_pane" | "create:recipes/building_blocks/crimson_window_pane" | "create:recipes/misc/crafting/kinetics/shaft" | "create:recipes/building_blocks/small_ochrum_brick_slab" | "minecraft:recipes/redstone/bamboo_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_brass_wrapped_locometal_boiler" | "ad_astra:recipes/misc/smelting/diamond_from_smelting_mars_diamond_ore" | "iceandfire:recipes/combat/mountain_troll_leather_boots" | "ad_astra:recipes/misc/calorite_ingot" | "ad_astra:recipes/misc/permafrost_brick_wall" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab" | "farmersdelight:recipes/cooking/pasta_with_meatballs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal" | "lootr:25loot" | "minecraft:recipes/misc/coast_armor_trim_smithing_template" | "minecraft:recipes/misc/ward_armor_trim_smithing_template_smithing_trim" | "biomesoplenty:recipes/redstone/mahogany_button" | "minecraft:recipes/combat/diamond_helmet" | "hexical:acquired_lamp" | "create:recipes/misc/crafting/materials/bound_cardboard_block" | "railways:recipes/misc/stonecutting/palettes/cycling/red_plated_locometal" | "create:recipes/misc/crafting/kinetics/white_valve_handle_from_other_valve_handle" | "iceandfire:recipes/combat/armor_gray_chestplate" | "farmersdelight:recipes/decorations/full_tatami_mat_from_halves" | "ae2:recipes/misc/network/cells/item_cell_housing" | "lootr:1barrel" | "ae2:recipes/misc/network/cables/smart_pink" | "tconstruct:recipes/misc/smeltery/scorched/polished_scorched_stone_crafting" | "ad_astra:recipes/misc/stonecutting/glacio_stone_brick_slab_from_glacio_stone_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_boiler" | "tconstruct:recipes/tools/tools/building/earth_staff" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_boiler" | "ad_astra:recipes/misc/polished_venus_stone_stairs" | "create:deployer" | "tconstruct:recipes/building_blocks/common/materials/queens_slime_nugget_from_ingot" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_boiler" | "ad_astra:recipes/misc/ostrum_plating_slab" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template" | "iceandfire:recipes/tools/dragonsteel_ice_sword" | "minecraft:recipes/building_blocks/chiseled_nether_bricks_from_nether_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_copper_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cables/smart_orange" | "sophisticatedbackpacks:recipes/misc/advanced_pump_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal" | "ad_astra:recipes/misc/small_purple_industrial_lamp" | "tconstruct:recipes/building_blocks/world/wood/greenheart/slab" | "create:recipes/building_blocks/small_calcite_brick_stairs" | "create:recipes/building_blocks/polished_cut_asurine_wall" | "ad_astra:moon" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "hexcasting:recipes/building_blocks/slate_block" | "hexcasting:recipes/redstone/akashic_bookshelf" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_from_stone_bricks_stonecutting" | "farmersdelight:recipes/decorations/crimson_cabinet" | "create:recipes/misc/crafting/kinetics/hand_crank" | "ad_astra:recipes/misc/vent" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_copper_wrapped_locometal_boiler" | "minecraft:recipes/decorations/pink_bed" | "create:recipes/building_blocks/cut_asurine_wall_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_slab_recycling" | "minecraft:recipes/misc/coal_from_blasting_deepslate_coal_ore" | "ae2:recipes/misc/network/wireless_access_point" | "tconstruct:recipes/misc/smeltery/seared/seared_cracked_bricks_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/copper_tile_slab" | "ad_astra:recipes/misc/stonecutting/polished_glacio_stone_slab_from_glacio_stone_stonecutting" | "ad_astra:recipes/misc/aeronos_fence" | "ad_astra:recipes/misc/stonecutting/mars_cobblestone_stairs_from_mars_cobblestone_stonecutting" | "comforts:sleeping_bag_purple" | "ad_astra:recipes/misc/sky_stone" | "ad_astra:recipes/misc/polished_glacio_stone_slab" | "farmersdelight:recipes/decorations/hanging_canvas_sign" | "create:recipes/building_blocks/cut_tuff_brick_stairs" | "ae2:recipes/misc/block_cutter/walls/cut_quartz_wall" | "ae2:recipes/misc/network/cells/item_storage_cell_1k_storage" | "ae2:recipes/misc/network/cables/glass_yellow" | "minecraft:recipes/building_blocks/cyan_stained_glass" | "minecraft:recipes/tools/netherite_axe_smithing" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_plated_locometal" | "ae2:recipes/misc/network/blocks/interfaces_interface_alt" | "railways:recipes/misc/crafting/smokestack_oilburner" | "minecraft:recipes/decorations/jungle_sign" | "create:recipes/misc/crafting/appliances/book" | "tconstruct:recipes/misc/common/glass/purple_clear_stained_glass" | "minecraft:recipes/building_blocks/andesite" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/exposed_cut_copper_from_exposed_copper_stonecutting" | "biomesoplenty:recipes/redstone/pine_fence_gate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_pillar" | "biomesoplenty:recipes/decorations/brimstone_bud_from_brimstone_stonecutting" | "biomesoplenty:biomesoplenty/root" | "comforts:sleeping_bag_green" | "tconstruct:recipes/misc/common/slime/earth/congealed" | "ae2:recipes/misc/decorative/chiseled_quartz_block_from_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_locometal_pillar" | "tconstruct:foundry/alloyer" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_iron_wrapped_locometal" | "ae2:recipes/misc/tools/paintballs_lumen_yellow" | "minecraft:recipes/building_blocks/blackstone_slab" | "minecraft:husbandry/feed_snifflet" | "minecraft:recipes/building_blocks/sandstone_slab_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/copper_valve_handle" | "create:recipes/building_blocks/cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/small_deepslate_brick_stairs" | "tconstruct:recipes/building_blocks/common/materials/cobalt_ingot_from_nuggets" | "ae2:recipes/misc/misc/deconstruction_chiseled_certus_quartz" | "minecraft:story/form_obsidian" | "ad_astra:recipes/misc/netherite_space_suit" | "biomesoplenty:recipes/decorations/empyreal_fence" | "create:recipes/building_blocks/layered_scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/netherite_ingot_from_netherite_block" | "tconstruct:recipes/misc/smeltery/scorched/alloyer" | "iceandfire:recipes/misc/dragonscale_gray_to_dragonscales_gray" | "create:recipes/building_blocks/small_crimsite_brick_stairs" | "create:haunted_bell" | "create:recipes/building_blocks/cut_dripstone_brick_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_copper_wrapped_locometal" | "minecraft:end/enter_end_gateway" | "ad_astra:recipes/misc/ti_69" | "create:recipes/misc/crafting/materials/cardboard_block" | "minecraft:recipes/building_blocks/bamboo_slab" | "create:recipes/building_blocks/cut_scoria_slab_recycling" | "iceandfire:recipes/combat/frost_troll_leather_boots" | "railways:recipes/misc/stonecutting/palettes/cycling/green_flat_riveted_locometal" | "create:recipes/building_blocks/cut_calcite_wall_from_stone_types_calcite_stonecutting" | "create:recipes/misc/crafting/kinetics/vertical_gearbox_from_conversion" | "ad_astra:recipes/misc/glacian_planks" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_polished_blackstone_stonecutting" | "tconstruct:recipes/misc/gadgets/frame/netherite" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_flat_riveted_locometal" | "iceandfire:iceandfire/stymphalian_arrow" | "classicpipes:recipes/mod_label" | "minecraft:nether/loot_bastion" | "tconstruct:recipes/building_blocks/common/materials/manyullyn_block_from_ingots" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal_boiler" | "ae2:recipes/misc/tools/paintballs_blue" | "minecraft:recipes/redstone/oak_door" | "create:recipes/misc/campfire_cooking/bread" | "ad_astra:recipes/misc/encased_ostrum_block" | "minecraft:recipes/building_blocks/dye_yellow_carpet" | "biomesoplenty:recipes/building_blocks/white_sandstone_stairs" | "ad_astra:recipes/misc/venus_stone_bricks" | "ae2:recipes/misc/network/blocks/pattern_providers_interface_alt" | "ad_astra:recipes/misc/oxygen_gear" | "minecraft:recipes/misc/iron_ingot_from_iron_block" | "create:recipes/building_blocks/cut_diorite_slab" | "iceandfire:recipes/combat/dragonsteel_ice_boots" | "classicpipes:recipes/advanced_copper_fluid_pipe_b" | "tconstruct:recipes/building_blocks/world/wood/skyroot/fence_gate" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_copper_wrapped_locometal" | "tconstruct:recipes/building_blocks/world/wood/greenheart/fence" | "minecraft:recipes/redstone/jungle_door" | "create:recipes/building_blocks/horizontal_framed_glass_pane" | "create:recipes/building_blocks/small_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/granite_pillar_from_stone_types_granite_stonecutting" | "iceandfire:recipes/building_blocks/dread_stone_bricks_chiseled" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_crimsite_slab" | "create:recipes/misc/smelting/zinc_ingot_from_crushed" | "ad_astra:recipes/misc/stonecutting/moon_stone_brick_wall_from_moon_stone_stonecutting" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_stonecutting" | "hexpigmentplus:recipes/cloaks" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_blackstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade" | "iceandfire:recipes/food/gold_pile" | "create:recipes/misc/crafting/kinetics/propeller" | "create:recipes/building_blocks/crafting/logistics/cyan_postbox_from_other_postbox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_boiler" | "ad_astra:recipes/misc/purple_industrial_lamp" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_stairs_from_honeycomb" | "ae2:recipes/misc/shaped/walls/smooth_sky_stone_block" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "ae2:recipes/misc/network/parts/terminals_pattern_access" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_iron_wrapped_locometal_boiler" | "hexcasting:recipes/misc/pride_colorizer_plural" | "create:recipes/building_blocks/cut_andesite_slab_recycling" | "biomesoplenty:recipes/building_blocks/black_sandstone_stairs_from_black_sandstone_stonecutting" | "minecraft:recipes/decorations/light_gray_candle" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_pillar" | "create:recipes/building_blocks/calcite_pillar_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/melon" | "ad_astra:recipes/misc/venus_sandstone_brick_stairs" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "biomesoplenty:recipes/decorations/pine_fence" | "farmersdelight:recipes/decorations/canvas_rug" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal" | "biomesoplenty:recipes/misc/light_blue_dye_from_icy_iris" | "ad_astra:recipes/misc/polished_permafrost_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_pillar" | "ad_astra:recipes/misc/stonecutting/chiseled_moon_stone_bricks_from_moon_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_slab" | "create:recipes/building_blocks/polished_cut_ochrum_slab_recycling" | "ad_astra:recipes/compressing/compressing/ostrum_plate_from_compressing_ostrum_ingots" | "ad_astra:recipes/misc/permafrost_brick_stairs" | "ae2:recipes/misc/block_cutter/slabs/smooth_quartz_slab" | "ae2:main/spatial_ioport" | "iceandfire:recipes/combat/tide_teal_boots" | "create:recipes/misc/crafting/materials/experience_nugget_from_block" | "create:recipes/misc/crafting/kinetics/orange_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/polished_cut_granite_wall_from_stone_types_granite_stonecutting" | "ae2:main/compass" | "create:recipes/building_blocks/cut_veridium_brick_stairs" | "create:recipes/building_blocks/diorite_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/yellow_stained_glass_pane_from_glass_pane" | "biomesoplenty:recipes/decorations/white_sandstone_wall" | "biomesoplenty:recipes/building_blocks/stripped_redwood_wood" | "ae2:recipes/misc/materials/advancedcard" | "ae2:main/glass_cable" | "farmersdelight:recipes/decorations/lime_hanging_canvas_sign" | "create:recipes/building_blocks/cut_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_stairs" | "ad_astra:recipes/misc/light_gray_industrial_lamp" | "tconstruct:recipes/building_blocks/common/materials/pig_iron_block_from_ingots" | "biomesoplenty:recipes/building_blocks/palm_wood" | "hexcasting:recipes/tools/staff/acacia" | "create:recipes/misc/crafting/kinetics/gray_valve_handle_from_other_valve_handle" | "create:mechanical_press" | "ad_astra:recipes/misc/iron_sliding_door" | "minecraft:recipes/combat/golden_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_plated_locometal" | "minecraft:end/elytra" | "create:recipes/misc/crafting/kinetics/turntable" | "biomesoplenty:recipes/redstone/palm_fence_gate" | "minecraft:recipes/decorations/mangrove_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_slashed_locometal" | "minecraft:recipes/tools/wooden_shovel" | "farmersdelight:recipes/decorations/birch_cabinet" | "ad_astra:recipes/misc/venus_stone_brick_stairs" | "minecraft:recipes/decorations/bamboo_mosaic" | "minecraft:recipes/building_blocks/purpur_stairs" | "tconstruct:recipes/misc/armor/building/plate_helmet" | "ad_astra:recipes/misc/desh_plating" | "iceandfire:recipes/combat/armor_red_leggings" | "ae2:recipes/misc/tools/paintballs_lumen_magenta" | "minecraft:recipes/redstone/redstone_lamp" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/orange_copper_wrapped_locometal" | "ad_astra:recipes/misc/space_suit" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_riveted_locometal" | "minecraft:recipes/decorations/crimson_fence" | "minecraft:recipes/redstone/dispenser" | "create:recipes/building_blocks/polished_cut_limestone_stairs" | "create:recipes/misc/crafting/appliances/clipboard_clear" | "create:recipes/misc/crafting/appliances/cardboard_leggings" | "create:recipes/misc/crafting/logistics/purple_table_cloth_clear" | "create:recipes/building_blocks/polished_cut_andesite_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/purpur_pillar_from_purpur_block_stonecutting" | "ad_astra:recipes/misc/stonecutting/chiseled_mars_stone_stairs_from_chiseled_mars_stone_bricks_stonecutting" | "iceandfire:recipes/building_blocks/sea_serpent_scales_bronze_to_sea_serpent_scale_block_bronze" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_ice_body" | "create:recipes/building_blocks/polished_cut_ochrum_stairs" | "minecraft:recipes/building_blocks/cobblestone_slab" | "biomesoplenty:recipes/transportation/pine_boat" | "hexcasting:lore/experiment1" | "iceandfire:iceandfire/dragon_forge_brick" | "hexcasting:lore/experiment2" | "create:recipes/misc/crafting/kinetics/encased_chain_drive" | "farmersdelight:recipes/food/beetroot_from_crate" | "minecraft:recipes/building_blocks/stripped_crimson_hyphae" | "create:recipes/misc/crafting/kinetics/mechanical_drill" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_flat_riveted_locometal" | "ad_astra:recipes/misc/iron_plating_button" | "ad_astra:recipes/misc/blasting/calorite_ingot_from_blasting_venus_calorite_ore" | "hexcasting:recipes/decorations/ancient_scroll_paper_lantern" | "ad_astra:recipes/misc/glacio_cobblestone_stairs" | "minecraft:recipes/building_blocks/magenta_terracotta" | "tconstruct:recipes/building_blocks/common/mud_bricks_slab" | "ad_astra:recipes/misc/mercury_stone_brick_slab" | "agricraft:recipes/misc/amethyst_shard" | "minecraft:recipes/misc/brick" | "computercraft:recipes/redstone/turtle_normal/computercraft/wireless_modem_advanced" | "tconstruct:recipes/misc/common/glass/blue_clear_stained_glass_pane_from_panes" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_boiler" | "ae2:recipes/misc/tools/portable_item_cell_256k" | "hexcasting:recipes/building_blocks/amethyst_pillar" | "iceandfire:recipes/combat/tide_deepblue_leggings" | "ae2:recipes/misc/network/cables/covered_green" | "create:recipes/building_blocks/cut_crimsite_stairs" | "create:recipes/misc/crafting/logistics/lime_table_cloth_clear" | "biomesoplenty:recipes/building_blocks/fir_wood" | "ad_astra:recipes/misc/solar_panel" | "create:recipes/building_blocks/polished_cut_veridium_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_iron_wrapped_locometal" | "ad_astra:recipes/misc/netherite_space_pants" | "ad_astra:recipes/misc/glacio_stone_brick_stairs" | "minecraft:recipes/building_blocks/gold_block" | "railways:recipes/combat/dying_existing_cap_brown" | "tconstruct:recipes/misc/common/glass/magenta_clear_stained_glass" | "create:recipes/building_blocks/cut_andesite_brick_slab_recycling" | "create:recipes/misc/smelting/ingot_uranium_compat_mekanism" | "create:recipes/building_blocks/layered_dripstone_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "biomesoplenty:recipes/decorations/hellbark_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_slashed_locometal" | "minecraft:recipes/misc/yellow_dye_from_sunflower" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_pillar" | "minecraft:recipes/brewing/cauldron" | "tconstruct:recipes/building_blocks/common/materials/pig_iron_nugget_from_ingot" | "iceandfire:recipes/building_blocks/dreadwood_planks" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab" | "minecraft:recipes/decorations/armor_stand" | "create:recipes/building_blocks/cut_andesite_wall_from_stone_types_andesite_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/misc/crafting/kinetics/track_observer" | "create:recipes/decorations/andesite_bars_from_andesite_alloy_stonecutting" | "comforts:sleeping_bag_orange" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal_boiler" | "ad_astra:recipes/misc/stonecutting/mars_pillar_from_mars_stone_stonecutting" | "create:recipes/misc/crafting/kinetics/sticker" | "minecraft:recipes/transportation/acacia_boat" | "minecraft:recipes/redstone/iron_trapdoor" | "classicpipes:recipes/spruce_pipe" | "railways:recipes/misc/crafting/buffer" | "minecraft:adventure/root" | "ae2:recipes/misc/materials/formationcore" | "minecraft:recipes/building_blocks/end_stone_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/dense_covered_gray" | "minecraft:recipes/decorations/jungle_fence" | "ae2:recipes/misc/block_cutter/walls/quartz_wall" | "ad_astra:recipes/misc/stonecutting/polished_permafrost_from_permafrost_bricks_stonecutting" | "minecraft:recipes/misc/tide_armor_trim_smithing_template_smithing_trim" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_boiler" | "minecraft:recipes/decorations/mud_brick_wall_from_mud_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_flat_slashed_locometal" | "minecraft:recipes/building_blocks/chiseled_quartz_block_from_quartz_block_stonecutting" | "minecraft:recipes/misc/ender_eye" | "tconstruct:recipes/misc/common/slime/earth/crystal_growing" | "ad_astra:recipes/misc/ostrum_ingot_from_ostrum_block" | "computercraft:recipes/redstone/pocket_computer_advanced" | "minecraft:recipes/redstone/redstone_block" | "tconstruct:recipes/misc/smeltery/seared/duct_retextured" | "ae2:main/spatial_explorer" | "create:recipes/building_blocks/bamboo_window_pane" | "minecraft:recipes/decorations/dark_oak_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_pillar" | "iceandfire:recipes/combat/dragonarmor_copper_tail" | "ae2:recipes/misc/shaped/stairs/smooth_quartz_block" | "ae2:recipes/misc/shaped/walls/sky_stone_block" | "create:recipes/misc/crafting/kinetics/smart_fluid_pipe" | "ae2:recipes/misc/decorative/sky_stone_brick_from_stonecutting" | "iceandfire:recipes/tools/dragonbone_hoe" | "biomesoplenty:recipes/redstone/willow_button" | "create:recipes/building_blocks/polished_cut_tuff_slab_recycling" | "minecraft:recipes/building_blocks/cyan_terracotta" | "create:recipes/misc/crafting/materials/raw_zinc" | "ad_astra:recipes/misc/ostrum_plating_pressure_plate" | "biomesoplenty:recipes/redstone/dead_fence_gate" | "minecraft:recipes/decorations/nether_brick_wall_from_nether_bricks_stonecutting" | "ae2:recipes/misc/network/blocks/energy_energy_acceptor" | "minecraft:recipes/decorations/red_stained_glass_pane_from_glass_pane" | "ae2:recipes/misc/shaped/stairs/fluix_block" | "ae2:recipes/misc/network/blocks/io_condenser" | "minecraft:story/follow_ender_eye" | "minecraft:recipes/building_blocks/weathered_cut_copper_from_weathered_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/ingot_lead_compat_immersiveengineering" | "ae2:recipes/misc/network/cables/dense_smart_light_blue" | "create:recipes/building_blocks/cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "ad_astra:recipes/misc/steel_trapdoor" | "biomesoplenty:recipes/decorations/brimstone_brick_wall" | "ae2:recipes/misc/decorative/sky_stone_small_brick" | "ad_astra:recipes/misc/ostrum_plating_stairs" | "iceandfire:recipes/misc/chain" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_locometal_pillar" | "minecraft:recipes/decorations/deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_raw_iron" | "biomesoplenty:recipes/building_blocks/chiseled_orange_sandstone" | "create:recipes/building_blocks/small_limestone_bricks_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/materials/brass_ingot_from_compacting" | "computercraft:recipes/redstone/computer_advanced_upgrade" | "create:steam_engine" | "biomesoplenty:recipes/building_blocks/brimstone_brick_slab_from_brimstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_pillar" | "minecraft:recipes/misc/blue_dye_from_cornflower" | "tconstruct:recipes/misc/tables/part_chest" | "minecraft:recipes/redstone/slime_block" | "create:recipes/building_blocks/small_asurine_brick_slab" | "create:recipes/building_blocks/polished_cut_scorchia_wall" | "create:recipes/building_blocks/small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_stairs" | "create:recipes/building_blocks/cut_granite_brick_stairs" | "ad_astra:recipes/misc/stonecutting/mercury_stone_bricks_from_mercury_stone_stonecutting" | "minecraft:recipes/decorations/bamboo_hanging_sign" | "create:recipes/building_blocks/small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "create:recipes/misc/crafting/logistics/repackager_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_flat_riveted_locometal" | "ad_astra:recipes/misc/magenta_flag" | "ae2:recipes/misc/network/cables/glass_cyan" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_locometal_smokebox" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tiles_from_honeycomb" | "iceandfire:recipes/combat/armor_silver_metal_helmet" | "ad_astra:recipes/misc/blasting/desh_ingot_from_blasting_deepslate_desh_ore" | "minecraft:recipes/building_blocks/acacia_wood" | "sophisticatedbackpacks:recipes/misc/pump_upgrade" | "create:recipes/building_blocks/ornate_iron_window_pane" | "ad_astra:recipes/misc/ostrum_plating" | "ae2:main/growth_accelerator" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_riveted_locometal" | "minecraft:recipes/decorations/polished_blackstone_brick_wall" | "ae2:recipes/misc/shaped/walls/sky_stone_small_brick" | "tconstruct:recipes/misc/smeltery/scorched/table" | "classicpipes:recipes/acacia_fluid_pipe_a" | "create:recipes/building_blocks/scorchia_pillar_from_stone_types_scorchia_stonecutting" | "create:recipes/building_blocks/small_asurine_brick_stairs" | "minecraft:recipes/combat/wooden_sword" | "ae2:recipes/misc/tools/paintballs_magenta" | "minecraft:recipes/decorations/gray_banner" | "minecraft:recipes/building_blocks/oak_planks" | "ae2:recipes/misc/network/cells/spatial_storage_cell_128_cubed_storage" | "minecraft:recipes/decorations/light_blue_carpet" | "biomesoplenty:recipes/building_blocks/brimstone_brick_stairs_from_brimstone_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_stairs_stonecutter" | "create:recipes/building_blocks/cut_scoria_wall" | "ad_astra:recipes/misc/ostrum_nugget" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_slashed_locometal" | "ad_astra:recipes/misc/smelting/glacio_stone_from_smelting_glacio_cobblestone" | "railways:recipes/misc/crafting/smokestack_long" | "minecraft:recipes/building_blocks/dye_blue_bed" | "ae2:recipes/misc/network/parts/energy_level_emitter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal_boiler" | "biomesoplenty:recipes/redstone/jacaranda_pressure_plate" | "tconstruct:recipes/building_blocks/common/materials/slimesteel_ingot_from_nuggets" | "create:recipes/misc/crafting/logistics/pink_table_cloth_clear" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_slashed_locometal" | "ae2:recipes/misc/block_cutter/stairs/chiseled_quartz_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/quartz_slab_from_stonecutting" | "ad_astra:recipes/misc/venus_cobblestone_stairs" | "biomesoplenty:recipes/decorations/palm_fence" | "minecraft:recipes/building_blocks/black_concrete_powder" | "iceandfire:recipes/tools/copper_hoe" | "ad_astra:recipes/misc/chiseled_venus_stone_slab" | "create:recipes/building_blocks/vertical_framed_glass_pane_from_colorless_glass_panes_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_plated_locometal" | "ae2:recipes/misc/network/blocks/spatial_io_pylon" | "farmersdelight:recipes/building_blocks/tatami_block_from_full" | "railways:recipes/misc/stonecutting/palettes/cycling/red_flat_slashed_locometal" | "create:recipes/building_blocks/cut_veridium_slab" | "minecraft:recipes/combat/crossbow" | "farmersdelight:recipes/food/shepherds_pie_block" | "minecraft:recipes/building_blocks/mud_bricks" | "create:recipes/building_blocks/crafting/logistics/blue_postbox_from_other_postbox" | "create:recipes/building_blocks/cut_granite_brick_wall" | "minecraft:recipes/food/cooked_porkchop_from_smoking" | "tconstruct:recipes/building_blocks/common/materials/manyullyn_nugget_from_ingot" | "minecraft:recipes/building_blocks/cracked_deepslate_bricks" | "create:recipes/misc/crafting/kinetics/train_trapdoor" | "ad_astra:recipes/misc/stonecutting/venus_pillar_from_venus_stone_bricks_stonecutting" | "ad_astra:recipes/misc/space_pants" | "ad_astra:recipes/misc/purple_flag" | "minecraft:recipes/building_blocks/chiseled_nether_bricks" | "create:recipes/building_blocks/crafting/logistics/red_postbox_from_other_postbox" | "minecraft:recipes/building_blocks/warped_planks" | "create:recipes/building_blocks/crafting/logistics/black_table_cloth_from_other_table_cloth" | "create:recipes/building_blocks/crafting/logistics/gray_table_cloth_from_other_table_cloth" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab" | "minecraft:recipes/decorations/warped_fence" | "ad_astra:recipes/misc/desh_panel" | "minecraft:recipes/decorations/black_glazed_terracotta" | "create:millstone" | "create:recipes/building_blocks/crafting/kinetics/green_seat" | "create:recipes/misc/blasting/osmium_ingot_compat_mythicmetals" | "railways:recipes/combat/dying_existing_cap_yellow" | "iceandfire:recipes/misc/dragonscale_electric_to_dragonscales_electric" | "create:recipes/building_blocks/cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "computercraft:recipes/redstone/turtle_normal/computercraft/speaker" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs" | "tconstruct:recipes/misc/common/materials/cobalt_ingot_smelting" | "ae2:recipes/misc/network/cables/dense_smart_purple" | "tconstruct:recipes/redstone/world/wood/skyroot/button" | "farmersdelight:recipes/decorations/green_canvas_sign" | "hexcasting:recipes/building_blocks/stonecutting/quenched_allay_bricks" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal_boiler" | "farmersdelight:recipes/cooking/beetroot_soup" | "minecraft:recipes/misc/gray_dye" | "create:train_whistle" | "classicpipes:recipes/birch_fluid_pipe_a" | "create:recipes/building_blocks/cut_limestone_wall" | "ad_astra:recipes/misc/calorite_plating_button" | "minecraft:recipes/redstone/bamboo_button" | "create:recipes/misc/blasting/ingot_silver_compat_ic2" | "minecraft:recipes/decorations/light_gray_carpet" | "create:recipes/building_blocks/cut_diorite_slab_recycling" | "minecraft:recipes/decorations/barrel" | "iceandfire:recipes/combat/gold_hippogryph_armor" | "ae2:recipes/misc/tools/paintballs_gray" | "ad_astra:recipes/misc/venus_sandstone_bricks" | "minecraft:recipes/misc/rib_armor_trim_smithing_template" | "tconstruct:recipes/misc/common/glass/yellow_clear_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_diorite_stairs" | "minecraft:recipes/combat/leather_boots" | "minecraft:recipes/misc/red_dye_from_tulip" | "minecraft:husbandry/axolotl_in_a_bucket" | "minecraft:recipes/decorations/cobblestone_wall_from_cobblestone_stonecutting" | "ad_astra:recipes/misc/stonecutting/polished_venus_stone_slab_from_polished_venus_stone_stonecutting" | "minecraft:recipes/misc/orange_dye_from_orange_tulip" | "minecraft:recipes/decorations/grindstone" | "farmersdelight:recipes/food/sweet_berry_cookie" | "sophisticatedbackpacks:recipes/misc/anvil_upgrade" | "minecraft:recipes/building_blocks/diamond_block" | "biomesoplenty:recipes/redstone/palm_trapdoor" | "ad_astra:recipes/misc/white_industrial_lamp" | "hexcasting:recipes/redstone/edified_pressure_plate" | "iceandfire:iceandfire/tame_amphithere" | "ae2:recipes/misc/network/parts/terminals_pattern_encoding" | "biomesoplenty:recipes/building_blocks/cut_orange_sandstone_slab" | "ad_astra:recipes/misc/glacian_trapdoor" | "minecraft:recipes/decorations/yellow_carpet" | "minecraft:recipes/building_blocks/stripped_oak_wood" | "create:recipes/misc/crafting/materials/rose_quartz_tiles_from_conversion" | "create:recipes/building_blocks/cut_calcite_wall" | "farmersdelight:main/craft_knife" | "create:recipes/misc/blasting/nickel_ingot_compat_alloygery" | "iceandfire:recipes/combat/dragonarmor_iron_head" | "minecraft:nether/ride_strider_in_overworld_lava" | "comforts:hammock_pink" | "create:recipes/building_blocks/polished_cut_andesite_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_smokebox" | "iceandfire:recipes/building_blocks/dragonforge_ice_core_disabled" | "ad_astra:recipes/misc/mars_cobblestone_stairs" | "create:recipes/misc/smelting/ingot_nickel_compat_immersiveengineering" | "farmersdelight:recipes/decorations/cyan_canvas_sign" | "hexcasting:recipes/building_blocks/stonecutting/slate_tiles" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_slashed_locometal" | "hextweaks:grandspell/fireball" | "iceandfire:recipes/tools/dragonsteel_fire_axe" | "iceandfire:recipes/tools/silver_pickaxe" | "create:recipes/building_blocks/crafting/logistics/light_blue_postbox_from_other_postbox" | "ad_astra:recipes/misc/desh_pillar" | "iceandfire:recipes/combat/armor_gray_leggings" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_slashed_locometal" | "create:recipes/building_blocks/cut_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "ad_astra:recipes/misc/stonecutting/polished_glacio_stone_from_glacio_stone_bricks_stonecutting" | "biomesoplenty:recipes/redstone/mahogany_door" | "create:recipes/building_blocks/crafting/kinetics/purple_seat" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal_boiler" | "minecraft:recipes/decorations/blue_banner" | "create:recipes/building_blocks/polished_cut_andesite_wall" | "create:recipes/building_blocks/weathered_copper_tile_slab" | "ad_astra:recipes/misc/green_flag" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/glass_magenta" | "ad_astra:recipes/misc/stonecutting/permafrost_brick_stairs_from_permafrost_bricks_stonecutting" | "hexcasting:recipes/building_blocks/amethyst_bricks_from_amethyst_bricks_small" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_locometal_smokebox" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_polished_deepslate_stonecutting" | "tconstruct:recipes/misc/gadgets/shuriken/flint_shuriken" | "tconstruct:recipes/misc/smeltery/scorched/lantern" | "create:recipes/building_blocks/polished_cut_granite_slab" | "biomesoplenty:recipes/building_blocks/mossy_stone_bricks_from_willow_vine" | "minecraft:recipes/building_blocks/dark_prismarine_slab_from_dark_prismarine_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/lime_banner" | "minecraft:recipes/decorations/white_bed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal" | "ae2:recipes/misc/network/cables/dense_smart_fluix" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal" | "tconstruct:recipes/misc/gadgets/shuriken/quartz_shuriken" | "tconstruct:recipes/misc/gadgets/fancy_frame/reversed_gold" | "create:recipes/misc/crafting/kinetics/copper_valve_handle_from_others" | "create:recipes/building_blocks/crafting/logistics/cyan_postbox" | "minecraft:recipes/decorations/deepslate_brick_wall_from_polished_deepslate_stonecutting" | "biomesoplenty:recipes/building_blocks/jacaranda_wood" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_deepslate_lapis_ore" | "create:recipes/building_blocks/polished_cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/weathered_copper_tile_slab_from_weathered_copper_tiles_stonecutting" | "minecraft:recipes/decorations/nether_brick_wall" | "ae2:recipes/misc/network/cables/covered_pink" | "minecraft:recipes/misc/ward_armor_trim_smithing_template" | "create:recipes/building_blocks/crafting/logistics/yellow_postbox" | "iceandfire:recipes/combat/armor_electric_chestplate" | "tconstruct:recipes/misc/smeltery/seared/faucet" | "create:recipes/misc/crafting/appliances/linked_controller" | "tconstruct:recipes/building_blocks/world/wood/greenheart/fence_gate" | "minecraft:recipes/misc/copper_ingot_from_smelting_deepslate_copper_ore" | "create:recipes/building_blocks/small_ochrum_brick_stairs" | "farmersdelight:recipes/food/potato_from_crate" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_flat_slashed_locometal" | "create:recipes/building_blocks/cut_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "ad_astra:recipes/misc/mercury_stone_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_slashed_locometal" | "ad_astra:recipes/misc/lime_flag" | "tconstruct:recipes/misc/common/glass/lime_clear_stained_glass" | "ad_astra:recipes/misc/stonecutting/polished_venus_stone_stairs_from_polished_venus_stone_stonecutting" | "ae2:recipes/misc/tools/portable_item_cell_64k" | "minecraft:recipes/misc/firework_rocket_simple" | "ad_astra:recipes/misc/stonecutting/polished_mercury_stone_from_mercury_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal" | "minecraft:recipes/misc/gold_ingot_from_smelting_deepslate_gold_ore" | "ad_astra:recipes/misc/jet_suit_boots" | "biomesoplenty:recipes/redstone/jacaranda_door" | "minecraft:nether/summon_wither" | "iceandfire:iceandfire/dragon_egg" | "tconstruct:recipes/misc/gadgets/throwball/efln_ball" | "ad_astra:recipes/misc/small_green_industrial_lamp" | "create:recipes/building_blocks/small_scoria_brick_slab_recycling" | "ae2:recipes/misc/shaped/stairs/quartz_block" | "tconstruct:recipes/misc/tables/crafting_station" | "create:compacting" | "create:recipes/building_blocks/cut_crimsite_brick_wall" | "tconstruct:recipes/misc/armor/building/plate_leggings" | "create:recipes/misc/crafting/kinetics/nozzle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_pillar" | "minecraft:recipes/redstone/redstone_from_blasting_deepslate_redstone_ore" | "create:recipes/misc/crafting/kinetics/radial_chassis" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_riveted_locometal" | "create:stock_ticker" | "ae2:recipes/misc/tools/certus_quartz_hoe" | "iceandfire:iceandfire/tame_hippogryph" | "create:recipes/building_blocks/polished_cut_ochrum_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cables/dense_smart_orange" | "minecraft:recipes/building_blocks/red_nether_brick_slab" | "minecraft:recipes/building_blocks/cobblestone_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_riveted_locometal" | "create:recipes/building_blocks/small_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_blasting_copper_ore" | "minecraft:recipes/building_blocks/dye_green_carpet" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab" | "hexcasting:recipes/building_blocks/stripped_edified_wood" | "ae2:recipes/misc/network/cells/item_storage_cell_16k" | "railways:recipes/misc/stonecutting/palettes/cycling/green_slashed_locometal" | "create:burner" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_smokebox" | "minecraft:recipes/decorations/pink_banner" | "tconstruct:recipes/misc/smeltery/scorched/drain" | "farmersdelight:recipes/food/pie_crust" | "biomesoplenty:recipes/redstone/hellbark_fence_gate" | "farmersdelight:recipes/combat/iron_knife" | "create:recipes/misc/smelting/nickel_ingot_compat_thermal" | "iceandfire:recipes/combat/armor_gray_boots" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_boiler" | "minecraft:recipes/building_blocks/prismarine_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_brass_wrapped_locometal_boiler" | "tconstruct:recipes/misc/gadgets/fancy_frame/reversed_reversed_gold" | "minecraft:recipes/building_blocks/waxed_exposed_copper_from_honeycomb" | "tconstruct:recipes/misc/smeltery/seared/drain" | "create:frogport" | "minecraft:recipes/misc/magenta_dye_from_blue_red_white_dye" | "ae2:recipes/misc/network/cables/covered_light_gray" | "ae2:recipes/misc/network/cables/smart_brown" | "minecraft:recipes/building_blocks/purple_concrete_powder" | "extendedae:recipes/misc/ei_alt" | "ad_astra:recipes/misc/blasting/ice_shard_from_blasting_glacio_ice_shard_ore" | "create:recipes/building_blocks/cut_granite_wall" | "biomesoplenty:recipes/building_blocks/chiseled_white_sandstone_from_white_sandstone_stonecutting" | "iceandfire:recipes/combat/armor_electric_boots" | "iceandfire:recipes/building_blocks/dragonscales_sapphire_to_dragonscale_sapphire" | "minecraft:recipes/building_blocks/prismarine_slab" | "minecraft:recipes/decorations/orange_carpet" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "hexcasting:recipes/misc/dye_colorizer_light_blue" | "create:recipes/misc/crafting/kinetics/mechanical_piston" | "ad_astra:recipes/misc/stonecutting/permafrost_tiles_from_permafrost_bricks_stonecutting" | "hexcasting:recipes/building_blocks/edified_tile" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_plated_locometal" | "minecraft:recipes/redstone/cherry_door" | "hexcasting:recipes/misc/dye_colorizer_brown" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/cut_copper_stairs" | "ad_astra:rocket_science" | "biomesoplenty:recipes/building_blocks/fir_planks" | "ad_astra:recipes/misc/polished_mars_stone_stairs" | "minecraft:recipes/decorations/warped_hanging_sign" | "classicpipes:recipes/flint_pipe" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/sticky_mechanical_piston" | "tconstruct:recipes/misc/gadgets/slimesling/sky" | "create:shifting_gears" | "create:recipes/building_blocks/exposed_copper_shingle_slab_from_exposed_copper_shingles_stonecutting" | "tconstruct:tools/make_part" | "create:recipes/misc/crafting/kinetics/encased_fan" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_boiler" | "ad_astra:recipes/misc/chiseled_permafrost_brick_slab" | "create:recipes/building_blocks/cut_scoria_wall_from_stone_types_scoria_stonecutting" | "farmersdelight:recipes/decorations/rope" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_plated_locometal" | "ae2:recipes/misc/materials/cardredstone" | "railways:recipes/misc/crafting/conductor_whistle" | "biomesoplenty:recipes/redstone/empyreal_pressure_plate" | "create:recipes/building_blocks/cut_dripstone_wall" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/door" | "create:recipes/misc/crafting/appliances/attribute_filter_clear" | "ae2:recipes/misc/network/parts/toggle_bus" | "ae2:recipes/misc/tools/nether_quartz_hoe" | "minecraft:recipes/combat/spectral_arrow" | "tconstruct:recipes/misc/common/glass/yellow_clear_stained_glass" | "minecraft:recipes/decorations/white_stained_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_plated_locometal" | "railways:recipes/misc/crafting/wooden_headstock_link_and_pin" | "create:recipes/building_blocks/crafting/logistics/black_postbox_from_other_postbox" | "ae2:recipes/misc/shaped/stairs/sky_stone_brick" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_hoe" | "iceandfire:recipes/combat/armor_electric_helmet" | "create:recipes/building_blocks/cut_diorite_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/ender_chest" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/wrapping/blue_brass_wrapped_locometal" | "minecraft:recipes/decorations/dark_oak_sign" | "create:recipes/misc/crafting/materials/experience_block" | "tconstruct:recipes/misc/common/glass/light_gray_clear_stained_glass_pane" | "tconstruct:foundry/manyullyn_lanterns" | "create:recipes/building_blocks/veridium_pillar_from_stone_types_veridium_stonecutting" | "minecraft:story/mine_diamond" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_granite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_locometal_pillar" | "create:track_crafting_factory" | "create:recipes/misc/crafting/kinetics/framed_glass_door" | "create:belt" | "iceandfire:recipes/building_blocks/sea_serpent_scales_purple_to_sea_serpent_scale_block_purple" | "iceandfire:iceandfire/dragon_staff" | "create:recipes/building_blocks/polished_cut_dripstone_stairs" | "minecraft:recipes/building_blocks/cyan_concrete_powder" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_wall" | "ae2:recipes/misc/network/blocks/energy_vibration_chamber" | "tconstruct:recipes/misc/gadgets/throwball/glow_ball" | "ae2:recipes/misc/tools/misctools_entropy_manipulator" | "biomesoplenty:recipes/transportation/umbran_chest_boat" | "create:recipes/misc/crafting/materials/electron_tube" | "ad_astra:recipes/misc/encased_desh_block" | "minecraft:recipes/misc/pink_dye_from_peony" | "hexcasting:recipes/tools/cypher" | "create:recipes/building_blocks/crafting/logistics/blue_table_cloth_from_other_table_cloth" | "farmersdelight:recipes/food/cake_from_milk_bottle" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_lightning_neck" | "create:recipes/misc/crafting/kinetics/goggles" | "sophisticatedbackpacks:recipes/misc/iron_backpack_from_copper" | "ad_astra:recipes/misc/smelting/moon_stone_from_smelting_moon_cobblestone" | "biomesoplenty:recipes/transportation/willow_chest_boat" | "create:recipes/misc/crafting/materials/andesite_alloy_from_block" | "minecraft:recipes/misc/coal_from_smelting_coal_ore" | "create:recipes/misc/crafting/kinetics/copper_door" | "minecraft:nether/find_fortress" | "farmersdelight:recipes/building_blocks/organic_compost_from_tree_bark" | "create:recipes/building_blocks/cut_tuff_brick_slab_recycling" | "create:recipes/decorations/copper_bars_from_copper_ingots_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_bricks" | "ad_astra:recipes/misc/smelting/mercury_stone_from_smelting_mercury_cobblestone" | "ae2:main/network_tool" | "create:recipes/building_blocks/polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "tconstruct:recipes/misc/common/copper_platform_waxing_unaffected" | "ae2:recipes/misc/network/cables/smart_light_blue" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_plated_locometal" | "minecraft:recipes/decorations/red_sandstone_wall" | "ad_astra:recipes/misc/strophar_trapdoor" | "farmersdelight:recipes/food/rice_from_bag" | "minecraft:recipes/misc/nether_brick" | "tconstruct:recipes/misc/smeltery/scorched/duct" | "create:recipes/building_blocks/cut_scorchia_brick_wall" | "create:recipes/building_blocks/small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "hexcasting:recipes/decorations/scroll_paper_lantern" | "biomesoplenty:recipes/redstone/palm_door" | "create:recipes/building_blocks/cut_scorchia_stairs" | "create:recipes/misc/crafting/appliances/cardboard_sword" | "railways:recipes/misc/crafting/handcar" | "minecraft:recipes/tools/stone_shovel" | "ae2:recipes/misc/materials/annihilationcore" | "farmersdelight:recipes/food/onion" | "iceandfire:recipes/building_blocks/dragonscales_blue_to_dragonscale_blue" | "create:recipes/misc/smelting/ingot_silver_compat_immersiveengineering" | "biomesoplenty:recipes/redstone/umbran_trapdoor" | "create:lava_wheel_00000" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_pickaxe" | "create:recipes/misc/blasting/ingot_lead_compat_immersiveengineering" | "create:recipes/misc/crafting/kinetics/whisk" | "minecraft:recipes/building_blocks/brown_terracotta" | "tconstruct:recipes/misc/common/slime/blood/slimeball_from_block" | "create:recipes/misc/crafting/kinetics/display_board" | "ad_astra:recipes/misc/mercury_cobblestone_slab" | "ae2:recipes/misc/shaped/slabs/cut_quartz_block" | "create:recipes/building_blocks/jungle_window" | "railways:recipes/combat/dying_existing_cap_pink" | "railways:recipes/misc/stonecutting/palettes/cycling/green_flat_slashed_locometal" | "minecraft:recipes/building_blocks/polished_deepslate_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_slashed_locometal" | "create:recipes/building_blocks/small_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/shulker_box" | "farmersdelight:recipes/food/wheat_dough_from_egg" | "minecraft:recipes/building_blocks/polished_basalt" | "minecraft:recipes/building_blocks/oak_wood" | "minecraft:recipes/building_blocks/smooth_quartz_stairs" | "ad_astra:recipes/misc/stonecutting/mars_stone_brick_wall_from_mars_stone_stonecutting" | "minecraft:recipes/misc/slime_ball" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_boiler" | "create:recipes/building_blocks/crafting/logistics/lime_postbox" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/layered_andesite_from_stone_types_andesite_stonecutting" | "tconstruct:recipes/misc/common/glass/white_clear_stained_glass_pane" | "create:recipes/misc/smelting/ingot_aluminium_compat_ic2" | "ad_astra:recipes/misc/desh_cable" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_locometal_smokebox" | "ae2:recipes/misc/blasting/sky_stone_block" | "farmersdelight:recipes/food/cooked_bacon" | "ae2:recipes/misc/network/cables/covered_white" | "create:recipes/building_blocks/polished_cut_calcite_slab_recycling" | "minecraft:recipes/building_blocks/dye_green_wool" | "minecraft:recipes/decorations/cherry_hanging_sign" | "ae2:recipes/misc/network/crafting/molecular_assembler" | "iceandfire:recipes/building_blocks/dread_stone_tile" | "minecraft:recipes/building_blocks/jungle_slab" | "tconstruct:recipes/misc/smeltery/seared/melter" | "create:recipes/building_blocks/polished_cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "ad_astra:recipes/misc/iron_plating" | "minecraft:recipes/decorations/light_blue_candle" | "biomesoplenty:recipes/building_blocks/palm_slab" | "create:recipes/misc/smelting/ingot_tin_compat_ic2" | "ae2:recipes/misc/network/crafting/4k_cpu_crafting_storage" | "ad_astra:recipes/misc/stonecutting/venus_stone_brick_stairs_from_venus_stone_bricks_stonecutting" | "create:recipes/building_blocks/framed_glass_pane" | "ad_astra:recipes/misc/iron_factory_block" | "create:recipes/building_blocks/polished_cut_asurine_slab_recycling" | "create:recipes/building_blocks/polished_cut_scoria_wall" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_riveted_locometal" | "minecraft:recipes/food/cooked_beef" | "ad_astra:recipes/misc/smelting/cracked_venus_stone_bricks_from_smelting_venus_stone_bricks" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "classicpipes:recipes/brick_pipe" | "hexcasting:recipes/tools/staff/bamboo" | "farmersdelight:recipes/food/cooked_chicken_cuts_from_smoking" | "minecraft:recipes/transportation/powered_rail" | "iceandfire:recipes/combat/dragonarmor_diamond_head" | "minecraft:recipes/decorations/red_bed" | "create:recipes/building_blocks/crafting/logistics/purple_table_cloth" | "classicpipes:recipes/crimson_fluid_pipe_a" | "minecraft:recipes/misc/iron_ingot_from_nuggets" | "tconstruct:recipes/combat/armor/building/travelers_shield" | "tconstruct:smeltery/tool_forge" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_smokebox" | "minecraft:recipes/transportation/jungle_boat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/piston_extension_pole" | "hexical:augmented_reality" | "ae2:recipes/misc/network/cables/dense_smart_gray" | "create:recipes/building_blocks/horizontal_framed_glass_pane_from_colorless_glass_panes_stonecutting" | "ad_astra:recipes/misc/stonecutting/moon_stone_brick_slab_from_moon_stone_bricks_stonecutting" | "minecraft:recipes/redstone/heavy_weighted_pressure_plate" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "farmersdelight:main/harvest_ropelogged_tomato" | "minecraft:story/enter_the_end" | "hexcasting:recipes/brainsweep/brainsweep/quench_allay" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal" | "minecraft:recipes/transportation/warped_fungus_on_a_stick" | "tconstruct:recipes/building_blocks/world/wood/greenheart/stripped_log_to_wood" | "comforts:hammock_orange" | "ad_astra:recipes/misc/calorite_tank" | "minecraft:recipes/building_blocks/stripped_jungle_wood" | "create:recipes/building_blocks/polished_cut_calcite_from_stone_types_calcite_stonecutting" | "agricraft:recipes/misc/quartz" | "minecraft:recipes/building_blocks/stone_stairs" | "create:recipes/building_blocks/oak_window_pane" | "create:recipes/misc/smelting/iron_ingot_from_crushed" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_slashed_locometal" | "minecraft:recipes/building_blocks/purpur_slab_from_purpur_block_stonecutting" | "create:recipes/building_blocks/spruce_window_pane" | "minecraft:recipes/transportation/rail" | "iceandfire:recipes/combat/dragonarmor_gold_neck" | "iceandfire:recipes/combat/dragonarmor_silver_head" | "ad_astra:recipes/misc/aeronos_fence_gate" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/small_diorite_brick_slab" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_stone_slab_stonecutter" | "ae2:recipes/misc/shaped/walls/quartz_pillar" | "iceandfire:recipes/combat/forest_troll_leather_chestplate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_iron_wrapped_locometal_boiler" | "biomesoplenty:recipes/building_blocks/smooth_black_sandstone_slab" | "ae2:recipes/misc/network/blocks/crank" | "farmersdelight:recipes/decorations/full_tatami_mat" | "create:recipes/building_blocks/crafting/logistics/blue_postbox" | "iceandfire:recipes/combat/dragonsteel_lightning_boots" | "create:recipes/misc/blasting/ingot_aluminium_compat_ic2" | "ad_astra:recipes/oxygen_loading/oxygen_loading/oxygen_from_oxygen_loading_water" | "farmersdelight:recipes/food/horse_feed" | "minecraft:recipes/building_blocks/bone_block" | "tconstruct:recipes/misc/smeltery/seared/chute_retextured" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_flat_riveted_locometal" | "sophisticatedbackpacks:recipes/misc/advanced_restock_upgrade" | "hexcasting:recipes/building_blocks/quenched_allay_tiles" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_honeycomb" | "biomesoplenty:recipes/misc/yellow_dye_from_goldenrod" | "minecraft:recipes/redstone/lever" | "create:recipes/decorations/andesite_scaffolding_from_andesite_alloy_stonecutting" | "farmersdelight:recipes/cooking/dog_food" | "create:recipes/misc/blasting/platinum_ingot_compat_mythicmetals" | "minecraft:nether/obtain_crying_obsidian" | "iceandfire:recipes/building_blocks/dread_stone_slab" | "minecraft:recipes/misc/magenta_dye_from_lilac" | "tconstruct:recipes/building_blocks/common/firewood/lavawood_stairs" | "farmersdelight:recipes/food/fried_egg_from_smoking" | "create:recipes/misc/crafting/materials/zinc_ingot_from_decompacting" | "farmersdelight:recipes/food/nether_salad" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_brass_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_limestone_wall_from_stone_types_limestone_stonecutting" | "ae2:recipes/misc/block_cutter/stairs/quartz_pillar_stairs" | "minecraft:recipes/misc/pink_dye_from_pink_petals" | "farmersdelight:recipes/decorations/half_tatami_mat" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_flat_slashed_locometal" | "farmersdelight:main/place_cooking_pot" | "tconstruct:recipes/brewing/common/slime/magma_cream" | "minecraft:husbandry/froglights" | "create:recipes/building_blocks/small_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_pillar" | "minecraft:recipes/misc/melon_seeds" | "minecraft:recipes/building_blocks/magma_block" | "create:recipes/building_blocks/cut_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "ad_astra:recipes/misc/stonecutting/mercury_stone_brick_wall_from_mercury_stone_bricks_stonecutting" | "ad_astra:cryo_freezer" | "farmersdelight:recipes/combat/diamond_knife" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade" | "computercraft:recipes/redstone/turtle_advanced/minecraft/diamond_shovel" | "farmersdelight:recipes/misc/iron_nugget_from_blasting_knife" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "iceandfire:recipes/combat/deathworm_gauntlet_yellow" | "create:recipes/building_blocks/cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_riveted_locometal" | "lootr:1chest" | "ad_astra:recipes/misc/orange_flag" | "sophisticatedbackpacks:recipes/misc/advanced_void_upgrade" | "railways:recipes/misc/crafting/portable_fuel_interface" | "ad_astra:recipes/misc/moon_stone_brick_wall" | "tconstruct:recipes/misc/smeltery/seared/grout_multiple" | "minecraft:recipes/building_blocks/lime_terracotta" | "create:recipes/building_blocks/small_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "ad_astra:recipes/misc/steel_plating" | "minecraft:recipes/building_blocks/smooth_quartz_slab_from_smooth_quartz_stonecutting" | "create:recipes/building_blocks/cut_scoria_brick_slab_recycling" | "minecraft:recipes/food/cake" | "ad_astra:recipes/misc/glowing_desh_pillar" | "ad_astra:recipes/misc/stonecutting/polished_mars_stone_from_mars_stone_bricks_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_wall_stonecutter" | "minecraft:recipes/combat/iron_leggings" | "minecraft:recipes/building_blocks/light_gray_terracotta" | "biomesoplenty:recipes/decorations/red_maple_leaf_pile" | "create:recipes/misc/crafting/kinetics/mechanical_crafter" | "create:ejector_maxed" | "create:recipes/building_blocks/cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/crafting/logistics/red_table_cloth_from_other_table_cloth" | "create:recipes/building_blocks/cut_limestone_bricks_from_stone_types_limestone_stonecutting" | "biomesoplenty:recipes/redstone/maple_button" | "minecraft:recipes/decorations/gray_bed" | "create:recipes/misc/crafting/materials/brass_ingot_from_decompacting" | "hexcasting:recipes/tools/staff/jungle" | "minecraft:recipes/misc/emerald_from_smelting_emerald_ore" | "iceandfire:recipes/combat/armor_copper_helmet" | "minecraft:recipes/building_blocks/coarse_dirt" | "farmersdelight:recipes/food/smoked_ham" | "comforts:sleeping_bag_pink" | "farmersdelight:recipes/food/milk_bottle" | "create:recipes/misc/crafting/kinetics/speedometer" | "tconstruct:recipes/misc/common/glass/gray_clear_stained_glass" | "farmersdelight:recipes/food/bread_from_smelting" | "iceandfire:recipes/combat/tide_blue_leggings" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/light_gray_concrete_powder" | "create:recipes/building_blocks/small_diorite_brick_wall" | "tconstruct:recipes/redstone/world/wood/greenheart/button" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_flat_riveted_locometal" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "artifacts:chest_slayer" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_flat_riveted_locometal" | "comforts:hammock_magenta" | "iceandfire:recipes/misc/dragon_meal" | "ae2:main/charger" | "minecraft:recipes/combat/leather_leggings" | "create:recipes/building_blocks/cut_veridium_bricks_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/pink_concrete_powder" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_riveted_locometal" | "minecraft:recipes/building_blocks/sandstone_slab" | "classicpipes:recipes/stocking_pipe_a" | "ad_astra:recipes/misc/steel_door" | "farmersdelight:recipes/building_blocks/straw_bale" | "ae2:recipes/misc/network/cables/glass_green" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_copper_wrapped_locometal_boiler" | "create:recipes/misc/blasting/silver_ingot_compat_techreborn" | "create:recipes/misc/blasting/silver_ingot_compat_bewitchment" | "minecraft:recipes/redstone/crimson_button" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_slashed_locometal" | "hexcasting:recipes/misc/decompose_quenched_shard/shard" | "minecraft:story/obtain_armor" | "create:recipes/building_blocks/polished_cut_veridium_wall_from_stone_types_veridium_stonecutting" | "biomesoplenty:recipes/building_blocks/chiseled_white_sandstone" | "create:recipes/building_blocks/polished_cut_andesite_stairs" | "create:diving_suit" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal_boiler" | "iceandfire:recipes/misc/dragonscale_silver_to_dragonscales_silver" | "ad_astra:recipes/misc/ostrum_ingot" | "minecraft:recipes/combat/diamond_leggings" | "minecraft:recipes/decorations/gray_stained_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/black_slashed_locometal" | "tconstruct:recipes/redstone/world/wood/skyroot/pressure_plate" | "create:recipes/building_blocks/small_diorite_bricks_from_stone_types_diorite_stonecutting" | "ad_astra:mercury" | "minecraft:recipes/food/dried_kelp_from_smelting" | "create:recipes/misc/smelting/gold_ingot_from_crushed" | "create:hose_pulley_lava" | "hexcasting:recipes/misc/dye_colorizer_cyan" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_brass_wrapped_locometal_boiler" | "farmersdelight:recipes/cooking/fish_stew" | "biomesoplenty:recipes/redstone/hellbark_trapdoor" | "create:recipes/building_blocks/layered_diorite_from_stone_types_diorite_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/greenheart/door" | "tconstruct:world/piggybackpack" | "ad_astra:cryo_fuel" | "biomesoplenty:recipes/decorations/mahogany_hanging_sign" | "tconstruct:recipes/redstone/world/wood/bloodshroom/button" | "tconstruct:recipes/building_blocks/world/wood/skyroot/stripped_log_to_wood" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_pillar" | "ad_astra:recipes/misc/raw_ostrum_block" | "minecraft:recipes/building_blocks/cherry_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "ae2:recipes/misc/network/cables/smart_white" | "create:recipes/building_blocks/small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "ad_astra:recipes/misc/stonecutting/polished_mercury_stone_stairs_from_polished_mercury_stone_stonecutting" | "sophisticatedbackpacks:recipes/misc/everlasting_upgrade" | "minecraft:end/kill_dragon" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_plated_locometal" | "tconstruct:recipes/misc/tables/tinkers_chest" | "create:recipes/building_blocks/polished_cut_deepslate_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/scoria" | "railways:recipes/misc/crafting/fuel_tank" | "ad_astra:recipes/misc/venus_cobblestone_slab" | "minecraft:recipes/decorations/orange_candle" | "ad_astra:recipes/misc/glacian_button" | "create:recipes/building_blocks/asurine_pillar_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/stone_brick_wall" | "farmersdelight:main/place_skillet" | "create:encased_fan" | "ad_astra:recipes/misc/strophar_fence_gate" | "create:recipes/building_blocks/cut_diorite_wall_from_stone_types_diorite_stonecutting" | "ae2:recipes/misc/shaped/slabs/chiseled_quartz_block" | "iceandfire:recipes/combat/deathworm_white_helmet" | "minecraft:recipes/redstone/dark_oak_fence_gate" | "minecraft:recipes/building_blocks/waxed_weathered_copper_from_honeycomb" | "minecraft:recipes/misc/iron_nugget_from_smelting" | "ad_astra:recipes/space_stations/space_station/mercury_orbit_space_station" | "minecraft:recipes/decorations/prismarine_wall_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/dye_light_gray_bed" | "extendedae:recipes/misc/tape" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_plated_locometal" | "create:recipes/building_blocks/copper_shingle_slab" | "create:recipes/misc/crafting/kinetics/cuckoo_clock" | "ad_astra:recipes/misc/stonecutting/polished_venus_stone_slab_from_venus_stone_stonecutting" | "biomesoplenty:recipes/building_blocks/stripped_dead_wood" | "minecraft:recipes/misc/copper_ingot_from_smelting_copper_ore" | "farmersdelight:recipes/misc/milk_bucket_from_bottles" | "ae2:recipes/misc/block_cutter/stairs/quartz_brick_stairs" | "minecraft:recipes/misc/blue_dye" | "biomesoplenty:recipes/decorations/willow_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "computercraft:recipes/redstone/turtle_normal_overlays/turtle_rainbow_overlay" | "minecraft:recipes/food/baked_potato_from_campfire_cooking" | "create:recipes/building_blocks/cut_deepslate_stairs" | "create:recipes/building_blocks/industrial_iron_block_from_iron_ingots_stonecutting" | "classicpipes:recipes/warped_pipe" | "create:recipes/misc/crafting/kinetics/analog_lever" | "biomesoplenty:recipes/redstone/umbran_button" | "ad_astra:recipes/misc/polished_mercury_stone_slab" | "iceandfire:recipes/building_blocks/dragonsteel_lightning_ingot_to_dragonsteel_lightning_block" | "create:recipes/building_blocks/crafting/kinetics/blue_seat_from_other_seat" | "tconstruct:recipes/misc/smeltery/scorched/scorched_glass_pane" | "biomesoplenty:recipes/building_blocks/smooth_black_sandstone_stairs_from_smooth_black_sandstone_stonecutting" | "minecraft:recipes/misc/cyan_dye" | "create:recipes/building_blocks/limestone_from_stone_types_limestone_stonecutting" | "biomesoplenty:recipes/misc/purple_dye_from_violet" | "minecraft:husbandry/make_a_sign_glow" | "hexcasting:recipes/building_blocks/edified_slab" | "create:andesite_alloy" | "minecraft:recipes/building_blocks/dye_lime_wool" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "biomesoplenty:recipes/building_blocks/umbran_stairs" | "create:recipes/misc/blasting/silver_ingot_compat_thermal" | "minecraft:recipes/redstone/acacia_pressure_plate" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_ice_tail" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_fire_neck" | "create:water_wheel" | "ad_astra:recipes/misc/stonecutting/glacio_stone_brick_wall_from_glacio_stone_stonecutting" | "iceandfire:recipes/misc/raw_silver_block_to_raw_silver" | "computercraft:recipes/redstone/computer_command" | "ad_astra:recipes/misc/blasting/coal_from_blasting_venus_coal_ore" | "minecraft:nether/create_beacon" | "minecraft:recipes/building_blocks/crimson_slab" | "ae2:recipes/misc/network/blocks/spatial_io_port" | "hexcasting:recipes/tools/lens" | "ae2:recipes/misc/tools/paintballs_lumen_pink" | "ae2:recipes/misc/shaped/walls/quartz_bricks" | "minecraft:recipes/building_blocks/crimson_stairs" | "iceandfire:recipes/combat/dragonarmor_diamond_neck" | "iceandfire:recipes/combat/mountain_troll_leather_leggings" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_slashed_locometal" | "ae2:recipes/misc/network/cables/glass_light_blue" | "createoreexcavation:recipes/misc/vein_finder" | "minecraft:recipes/building_blocks/green_stained_glass" | "ae2:recipes/misc/network/parts/annihilation_plane_alt" | "create:recipes/misc/crafting/logistics/pulse_timer" | "minecraft:recipes/building_blocks/bamboo_mosaic_slab" | "minecraft:recipes/decorations/yellow_glazed_terracotta" | "ae2:recipes/misc/network/cables/glass_black" | "create:recipes/building_blocks/small_granite_brick_slab_recycling" | "railways:recipes/misc/stonecutting/palettes/cycling/white_riveted_locometal" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_stairs" | "ae2:recipes/misc/network/blocks/pattern_providers_interface" | "create:recipes/building_blocks/small_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "ae2:recipes/misc/shaped/walls/smooth_quartz_block" | "create:recipes/misc/crafting/logistics/redstone_link" | "minecraft:recipes/building_blocks/bookshelf" | "hexcassettes:tape_worm" | "ae2:recipes/misc/block_cutter/stairs/fluix_stairs" | "biomesoplenty:recipes/building_blocks/empyreal_stairs" | "hexcasting:recipes/tools/artifact" | "hexcasting:root" | "ae2:recipes/misc/network/parts/storage_bus" | "tconstruct:recipes/misc/armor/building/travelers_goggles" | "sophisticatedbackpacks:recipes/misc/auto_smelting_upgrade" | "ae2:recipes/misc/block_cutter/slabs/chiseled_quartz_slab" | "tconstruct:recipes/misc/common/glass/light_gray_clear_stained_glass" | "create:recipes/misc/crafting/kinetics/cart_assembler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_pillar" | "computercraft:recipes/redstone/monitor_normal" | "create:recipes/building_blocks/small_tuff_bricks_from_stone_types_tuff_stonecutting" | "minecraft:story/iron_tools" | "tconstruct:recipes/building_blocks/common/materials/queens_slime_block_from_ingots" | "biomesoplenty:recipes/decorations/brimstone_fumarole" | "ae2:recipes/misc/tools/certus_quartz_axe" | "create:recipes/building_blocks/exposed_copper_shingle_stairs_from_exposed_copper_shingles_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_vertical_framed_glass_pane" | "iceandfire:recipes/combat/deathworm_white_leggings" | "create:recipes/misc/crafting/kinetics/controller_rail" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_blackstone_stonecutting" | "ad_astra:recipes/misc/mars_stone_bricks" | "minecraft:recipes/combat/iron_chestplate" | "ad_astra:recipes/misc/blasting/diamond_from_blasting_venus_diamond_ore" | "create:recipes/building_blocks/small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/redstone/dark_oak_trapdoor" | "minecraft:recipes/redstone/oak_trapdoor" | "hexcasting:recipes/food/sub_sandwich" | "create:recipes/building_blocks/tiled_glass_pane" | "tconstruct:recipes/food/gadgets/cake/magma" | "ad_astra:recipes/misc/iron_plateblock" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/fence_gate" | "ae2:recipes/misc/network/cells/spatial_storage_cell_2_cubed" | "biomesoplenty:recipes/building_blocks/cut_orange_sandstone_from_orange_sandstone_stonecutting" | "ad_astra:recipes/misc/calorite_engine" | "create:recipes/building_blocks/limestone_pillar_from_stone_types_limestone_stonecutting" | "ad_astra:recipes/misc/blasting/iron_ingot_from_blasting_mars_iron_ore" | "sophisticatedbackpacks:recipes/misc/chipped/mason_table_upgrade" | "hexcasting:recipes/building_blocks/amethyst_dust_packing" | "tconstruct:world/slime_sling" | "create:honey_drain" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal_boiler" | "iceandfire:recipes/combat/dragonarmor_iron_body" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_plated_locometal" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "ad_astra:recipes/misc/glowing_iron_pillar" | "minecraft:recipes/misc/book" | "minecraft:recipes/building_blocks/purpur_slab" | "hexal:recipes/freeze/freeze/blue_ice" | "create:recipes/building_blocks/small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_block" | "create:recipes/building_blocks/crafting/kinetics/brown_seat" | "minecraft:recipes/combat/stone_sword" | "biomesoplenty:recipes/decorations/jacaranda_fence" | "biomesoplenty:recipes/building_blocks/stripped_palm_wood" | "farmersdelight:recipes/decorations/blue_canvas_sign" | "minecraft:recipes/decorations/cobblestone_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_brass_wrapped_locometal" | "minecraft:recipes/misc/dune_armor_trim_smithing_template_smithing_trim" | "ae2:recipes/misc/network/blocks/energy_energy_acceptor_alt" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_smokebox" | "create:recipes/misc/smelting/ingot_lead_compat_mekanism" | "minecraft:recipes/building_blocks/brown_stained_glass" | "hexcasting:recipes/building_blocks/amethyst_bricks" | "create:recipes/building_blocks/cut_asurine_from_stone_types_asurine_stonecutting" | "ae2:recipes/misc/block_cutter/walls/smooth_sky_stone_wall" | "create:recipes/misc/crafting/logistics/desk_bell" | "minecraft:recipes/decorations/brown_carpet" | "iceandfire:recipes/misc/silver_ingot_to_silver_nugget" | "iceandfire:recipes/misc/sea_serpent_scale_block_red_to_sea_serpent_scales_red" | "minecraft:recipes/decorations/red_stained_glass_pane" | "biomesoplenty:recipes/building_blocks/umbran_slab" | "minecraft:recipes/food/dried_kelp_from_campfire_cooking" | "minecraft:recipes/combat/netherite_sword_smithing" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal" | "create:pulley_maxed" | "railways:recipes/misc/crafting/palettes/wrapping/red_brass_wrapped_locometal" | "create:recipes/building_blocks/veridium_from_stone_types_veridium_stonecutting" | "extendedae:recipes/misc/fishbig" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_copper_wrapped_locometal" | "minecraft:recipes/misc/diamond" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal" | "minecraft:recipes/misc/gold_nugget_from_smelting" | "minecraft:recipes/food/cooked_chicken" | "create:recipes/building_blocks/small_veridium_bricks_from_stone_types_veridium_stonecutting" | "ae2:recipes/misc/tools/misctools_charged_staff" | "ad_astra:recipes/misc/stonecutting/mercury_stone_brick_slab_from_mercury_stone_bricks_stonecutting" | "hexcasting:recipes/decorations/scroll" | "minecraft:recipes/misc/netherite_upgrade_smithing_template" | "ae2:recipes/misc/network/cells/fluid_storage_cell_4k_storage" | "ad_astra:recipes/misc/venus_stone_brick_slab" | "minecraft:recipes/tools/stone_axe" | "create:chocolate_bucket" | "biomesoplenty:recipes/building_blocks/magic_wood" | "create:recipes/building_blocks/asurine_from_stone_types_asurine_stonecutting" | "biomesoplenty:recipes/decorations/maple_hanging_sign" | "tconstruct:tools/modified" | "iceandfire:recipes/combat/armor_silver_metal_boots" | "comforts:sleeping_bag_light_gray" | "create:recipes/building_blocks/cut_deepslate_wall" | "create:recipes/building_blocks/small_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "minecraft:recipes/decorations/blue_candle" | "tconstruct:recipes/misc/smeltery/seared/seared_bricks_from_brick" | "create:recipes/misc/blasting/zinc_ingot_from_raw_ore" | "extendedae:recipes/misc/epp_part" | "ad_astra:recipes/misc/light_blue_industrial_lamp" | "create:recipes/decorations/copper_scaffolding_from_copper_ingots_stonecutting" | "create:recipes/misc/crafting/kinetics/mysterious_cuckoo_clock" | "tconstruct:recipes/misc/smeltery/red_sand_cast" | "minecraft:nether/ride_strider" | "create:recipes/misc/crafting/appliances/cardboard_helmet" | "tconstruct:recipes/misc/smeltery/scorched/duct_retextured" | "tconstruct:recipes/misc/tools/modifiers/silky_cloth" | "create:recipes/building_blocks/cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "ad_astra:recipes/misc/steel_ingot" | "create:recipes/building_blocks/cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "biomesoplenty:recipes/building_blocks/hellbark_slab" | "iceandfire:recipes/combat/deathworm_yellow_boots" | "create:recipes/building_blocks/small_andesite_brick_stairs" | "ae2:recipes/misc/block_cutter/slabs/fluix_slab" | "ad_astra:recipes/misc/smelting/calorite_ingot_from_smelting_raw_calorite" | "tconstruct:smeltery/tinkers_anvil" | "sophisticatedbackpacks:recipes/misc/chipped/carpenters_table_upgrade" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/misc/iron_nugget" | "minecraft:recipes/building_blocks/brown_concrete_powder" | "biomesoplenty:recipes/building_blocks/stripped_mahogany_wood" | "create:recipes/building_blocks/cut_calcite_slab_from_stone_types_calcite_stonecutting" | "minecraft:end/levitate" | "create:recipes/misc/blasting/tin_ingot_compat_thermal" | "ad_astra:recipes/misc/mars_stone_brick_wall" | "minecraft:recipes/building_blocks/blue_stained_glass" | "create:self_deploying" | "hexal:recipes/freeze/freeze/packed_ice" | "ad_astra:recipes/misc/radio" | "ae2:recipes/misc/decorative/certus_quartz_pillar_from_stonecutting" | "ae2:recipes/misc/materials/cardcrafting" | "ad_astra:recipes/misc/rocket_fin" | "computercraft:recipes/redstone/wired_modem_full_from" | "minecraft:recipes/building_blocks/cracked_stone_bricks" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_slab_stonecutter" | "iceandfire:recipes/misc/dragonscale_red_to_dragonscales_red" | "hexcasting:recipes/misc/pride_colorizer_intersex" | "farmersdelight:recipes/decorations/cyan_hanging_canvas_sign" | "ad_astra:recipes/misc/iron_plating_stairs" | "tconstruct:smeltery/cast_collector" | "farmersdelight:recipes/combat/flint_knife" | "farmersdelight:main/plant_rice" | "minecraft:recipes/building_blocks/cut_copper_slab_from_cut_copper_stonecutting" | "biomesoplenty:recipes/redstone/pine_trapdoor" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_flat_riveted_locometal" | "minecraft:recipes/misc/iron_ingot_from_blasting_iron_ore" | "biomesoplenty:recipes/building_blocks/umbran_wood" | "tconstruct:recipes/misc/armor/building/plate_chestplate" | "minecraft:recipes/misc/bucket" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal" | "create:recipes/building_blocks/small_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "ae2:main/qnb" | "minecraft:adventure/bullseye" | "create:recipes/building_blocks/cut_dripstone_brick_wall" | "minecraft:recipes/building_blocks/diorite_slab" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_bricks_stonecutting" | "iceandfire:recipes/misc/blindfold" | "create:recipes/building_blocks/polished_cut_veridium_slab_from_stone_types_veridium_stonecutting" | "farmersdelight:recipes/decorations/black_canvas_sign" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_shovel" | "minecraft:recipes/decorations/orange_stained_glass_pane" | "create:recipes/building_blocks/small_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "hexcasting:recipes/tools/staff/spruce" | "create:recipes/misc/crafting/kinetics/track_station" | "hexcasting:creative_unlocker" | "minecraft:recipes/building_blocks/light_blue_concrete_powder" | "tconstruct:recipes/misc/common/glass/brown_clear_stained_glass_pane" | "ad_astra:tier_4_rocket" | "create:recipes/building_blocks/cut_diorite_wall" | "biomesoplenty:recipes/building_blocks/fir_slab" | "iceandfire:recipes/building_blocks/dread_stone_stairs" | "createoreexcavation:recipes/misc/diamond_drill" | "create:recipes/misc/crafting/kinetics/mechanical_roller" | "biomesoplenty:recipes/building_blocks/stripped_pine_wood" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_smokebox" | "iceandfire:recipes/tools/silver_ingot_from_smelting_raw_silver" | "ad_astra:recipes/misc/reinforced_door" | "minecraft:recipes/building_blocks/glass" | "ad_astra:recipes/misc/red_flag" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal_boiler" | "iceandfire:recipes/tools/dragonbone_shovel" | "minecraft:recipes/combat/bow" | "create:cardboard" | "minecraft:recipes/building_blocks/acacia_slab" | "minecraft:recipes/building_blocks/smooth_sandstone" | "minecraft:recipes/building_blocks/oxidized_cut_copper" | "ae2:recipes/misc/block_cutter/walls/smooth_quartz_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_boiler" | "createoreexcavation:recipes/misc/drill" | "create:recipes/building_blocks/cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "farmersdelight:recipes/building_blocks/tatami" | "create:recipes/building_blocks/crafting/logistics/magenta_table_cloth" | "iceandfire:iceandfire/dragonarmor" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_flat_slashed_locometal" | "ae2:recipes/misc/network/cables/dense_smart_red" | "farmersdelight:recipes/decorations/safety_net" | "ad_astra:recipes/misc/polished_moon_stone_slab" | "ae2:main/fluix" | "ae2:recipes/misc/block_cutter/slabs/sky_stone_small_brick_slab" | "minecraft:recipes/transportation/minecart" | "minecraft:recipes/decorations/orange_glazed_terracotta" | "farmersdelight:recipes/food/cooked_salmon_slice_from_smoking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_plated_locometal" | "create:andesite_casing" | "create:recipes/building_blocks/crafting/kinetics/gray_seat" | "ae2:recipes/misc/network/cables/covered_black" | "hexcasting:recipes/building_blocks/edified_wood" | "create:recipes/misc/crafting/materials/copper_nugget" | "minecraft:recipes/decorations/green_stained_glass_pane" | "iceandfire:recipes/building_blocks/dragonforge_lightning_brick" | "tconstruct:recipes/food/gadgets/cake/blood" | "minecraft:recipes/tools/iron_hoe" | "biomesoplenty:recipes/decorations/brimstone_brick_wall_from_brimstone_stonecutting" | "ad_astra:recipes/misc/glacio_stone_brick_slab" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "hexcasting:enlightenment" | "tconstruct:recipes/building_blocks/common/materials/cobalt_nugget_from_ingot" | "ae2:recipes/misc/network/cables/glass_pink" | "farmersdelight:recipes/misc/iron_nugget_from_smelting_knife" | "biomesoplenty:recipes/redstone/hellbark_door" | "ad_astra:recipes/misc/stonecutting/mercury_cobblestone_slab_from_mercury_cobblestone_stonecutting" | "ae2:recipes/misc/tools/network_memory_card" | "iceandfire:recipes/combat/armor_blue_boots" | "railways:recipes/misc/stonecutting/palettes/cycling/black_flat_slashed_locometal" | "iceandfire:recipes/building_blocks/dragonscales_electric_to_dragonscale_electric" | "minecraft:recipes/misc/bowl" | "create:recipes/building_blocks/polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "farmersdelight:recipes/decorations/magenta_hanging_canvas_sign" | "create:steam_engine_maxed" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_riveted_locometal" | "minecraft:recipes/building_blocks/dye_orange_carpet" | "ae2:recipes/misc/tools/nether_quartz_sword" | "create:recipes/building_blocks/crafting/kinetics/white_seat_from_other_seat" | "farmersdelight:recipes/food/cooked_mutton_chops" | "farmersdelight:recipes/food/honey_cookie" | "minecraft:recipes/tools/clock" | "tconstruct:foundry/blaze" | "classicpipes:recipes/tag_label_a" | "ae2:recipes/misc/network/cells/item_storage_cell_4k_storage" | "minecraft:story/enter_the_nether" | "iceandfire:recipes/building_blocks/dragonforge_ice_input" | "minecraft:recipes/decorations/red_glazed_terracotta" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal" | "minecraft:adventure/whos_the_pillager_now" | "create:recipes/building_blocks/small_asurine_bricks_from_stone_types_asurine_stonecutting" | "ad_astra:recipes/misc/small_cyan_industrial_lamp" | "computercraft:recipes/redstone/cable" | "tconstruct:world/sky_island" | "create:recipes/building_blocks/cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/food/baked_potato" | "create:recipes/misc/crafting/kinetics/filter" | "create:recipes/building_blocks/cut_andesite_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_plated_locometal" | "create:recipes/building_blocks/cut_limestone_brick_stairs" | "iceandfire:recipes/combat/armor_sapphire_leggings" | "create:recipes/misc/crafting/kinetics/white_sail" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_riveted_locometal" | "ad_astra:recipes/misc/glacian_stairs" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_slab_from_honeycomb" | "create:recipes/misc/crafting/tree_fertilizer" | "minecraft:recipes/decorations/green_banner" | "ad_astra:recipes/misc/mercury_stone_brick_wall" | "create:recipes/building_blocks/cherry_window_pane" | "create:recipes/misc/smelting/silver_ingot_compat_oreganized" | "minecraft:recipes/misc/gold_ingot_from_nuggets" | "computercraft:recipes/redstone/pocket_advanced/computercraft/speaker" | "iceandfire:recipes/combat/dragonsteel_lightning_helmet" | "tconstruct:recipes/misc/smeltery/seared/duct" | "ad_astra:recipes/misc/blasting/calorite_ingot_from_blasting_deepslate_calorite_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_flat_slashed_locometal" | "comforts:hammock_gray" | "create:recipes/misc/crafting/logistics/package_frogport" | "biomesoplenty:recipes/redstone/jacaranda_button" | "create:recipes/building_blocks/cut_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/pink_dye_from_pink_tulip" | "minecraft:recipes/building_blocks/mangrove_stairs" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade" | "agricraft:recipes/misc/netherite_scrap" | "create:recipes/building_blocks/polished_cut_crimsite_from_stone_types_crimsite_stonecutting" | "tconstruct:recipes/misc/smeltery/scorched/faucet" | "create:recipes/building_blocks/cut_deepslate_brick_wall" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_lightning_tail" | "minecraft:recipes/decorations/spruce_sign" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template" | "create:recipes/building_blocks/layered_granite_from_stone_types_granite_stonecutting" | "sophisticatedbackpacks:recipes/misc/diamond_backpack" | "create:recipes/building_blocks/cut_calcite_brick_wall" | "railways:recipes/misc/crafting/track_coupler" | "classicpipes:recipes/bamboo_pipe" | "railways:recipes/misc/stonecutting/palettes/cycling/green_locometal_pillar" | "ae2:main/crafting_terminal" | "create:anvil_plough" | "ae2:main/ioport" | "iceandfire:recipes/combat/armor_silver_helmet" | "iceandfire:recipes/combat/dragonsteel_lightning_chestplate" | "minecraft:recipes/building_blocks/bricks" | "minecraft:recipes/combat/netherite_leggings_smithing" | "farmersdelight:recipes/cooking/noodle_soup" | "minecraft:recipes/decorations/painting" | "create:stressometer" | "minecraft:recipes/building_blocks/waxed_cut_copper" | "ae2:recipes/misc/tools/fluix_hoe" | "farmersdelight:main/hit_raider_with_rotten_tomato" | "minecraft:recipes/building_blocks/red_terracotta" | "minecraft:recipes/combat/arrow" | "ae2:recipes/misc/network/cables/dense_covered_purple" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_pillar" | "ae2:recipes/misc/network/blocks/spatial_anchor" | "tconstruct:recipes/building_blocks/common/materials/slimesteel_nugget_from_ingot" | "hexcasting:recipes/building_blocks/slate_tiles" | "iceandfire:recipes/combat/armor_green_chestplate" | "create:recipes/building_blocks/small_diorite_brick_slab_recycling" | "sophisticatedbackpacks:recipes/misc/chipped/alchemy_bench_upgrade" | "classicpipes:recipes/oak_pipe" | "gravestones:recipes/decorations/gravestone_chipped" | "tconstruct:recipes/misc/smeltery/sand_cast" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_brass_wrapped_locometal" | "ad_astra:carbon_footprint" | "create:recipes/building_blocks/crafting/kinetics/red_seat" | "create:recipes/building_blocks/polished_cut_veridium_slab_recycling" | "farmersdelight:recipes/decorations/dark_oak_cabinet" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/combat/golden_helmet" | "minecraft:recipes/redstone/acacia_trapdoor" | "create:recipes/misc/smelting/glass_pane_from_framed_glass_pane" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tiles_from_honeycomb" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_pillar" | "tconstruct:recipes/redstone/common/glass/vanilla/daylight_detector" | "create:recipes/building_blocks/cut_ochrum_stairs" | "ae2:recipes/misc/network/blocks/energy_dense_energy_cell" | "minecraft:recipes/building_blocks/brick_slab_from_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_andesite_slab" | "ad_astra:recipes/misc/stonecutting/polished_glacio_stone_from_glacio_stone_stonecutting" | "biomesoplenty:recipes/building_blocks/smooth_white_sandstone_slab_from_smooth_white_sandstone_stonecutting" | "create:train" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_flat_riveted_locometal" | "minecraft:recipes/food/cooked_salmon" | "minecraft:recipes/building_blocks/cherry_stairs" | "iceandfire:recipes/combat/tide_blue_boots" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_riveted_locometal" | "ad_astra:recipes/misc/yellow_flag" | "ad_astra:doom_slayer" | "create:recipes/building_blocks/small_andesite_brick_wall" | "create:recipes/building_blocks/small_tuff_brick_stairs" | "tconstruct:recipes/misc/common/glass/light_gray_clear_stained_glass_pane_from_panes" | "ae2:recipes/misc/network/cables/smart_red" | "ae2:recipes/misc/block_cutter/slabs/quartz_pillar_slab" | "biomesoplenty:recipes/building_blocks/pine_planks" | "biomesoplenty:recipes/building_blocks/hellbark_stairs" | "hexcasting:recipes/building_blocks/amethyst_dust_unpacking" | "ad_astra:recipes/misc/glacian_door" | "ad_astra:recipes/misc/stonecutting/chiseled_mercury_stone_slab_from_chiseled_mercury_stone_bricks_stonecutting" | "tconstruct:recipes/misc/smeltery/seared/seared_ladder" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_copper_wrapped_locometal_boiler" | "tconstruct:recipes/misc/common/glass/purple_clear_stained_glass_pane" | "create:recipes/building_blocks/crafting/logistics/brown_table_cloth_from_other_table_cloth" | "tconstruct:recipes/misc/common/firewood/nahuatl_fence" | "ad_astra:oxygen_distributor" | "biomesoplenty:recipes/building_blocks/chiseled_orange_sandstone_from_orange_sandstone_stonecutting" | "biomesoplenty:recipes/decorations/maple_fence" | "tconstruct:recipes/misc/common/slime/ender/congealed" | "create:recipes/building_blocks/cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "hexcasting:recipes/tools/staff/dark_oak" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_slashed_locometal" | "ad_astra:recipes/misc/white_flag" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_cobble_wall_stonecutter" | "iceandfire:recipes/combat/dragonarmor_silver_body" | "minecraft:recipes/decorations/composter" | "tconstruct:recipes/building_blocks/common/materials/netherite_ingot_from_nuggets" | "ae2:recipes/misc/decorative/sky_stone_brick" | "tconstruct:recipes/redstone/world/wood/greenheart/pressure_plate" | "ad_astra:recipes/misc/stonecutting/chiseled_venus_stone_bricks_from_venus_stone_bricks_stonecutting" | "create:recipes/building_blocks/cut_ochrum_brick_slab" | "minecraft:recipes/building_blocks/red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/orange_seat" | "iceandfire:recipes/building_blocks/dragonforge_fire_input" | "create:recipes/building_blocks/dripstone_block_from_stone_types_dripstone_stonecutting" | "ad_astra:recipes/misc/etrionic_blast_furnace" | "create:recipes/building_blocks/cut_scorchia_slab" | "create:recipes/building_blocks/weathered_copper_tile_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_pillar" | "ae2:recipes/misc/block_cutter/walls/sky_stone_brick_wall" | "create:recipes/building_blocks/cut_calcite_brick_stairs" | "iceandfire:recipes/combat/tide_purple_leggings" | "ad_astra:recipes/misc/stonecutting/polished_glacio_stone_slab_from_polished_glacio_stone_stonecutting" | "create:recipes/building_blocks/tiled_glass_pane_from_colorless_glass_panes_stonecutting" | "minecraft:recipes/building_blocks/end_stone_bricks" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_riveted_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_starter_tier" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "minecraft:recipes/decorations/glow_item_frame" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_copper_wrapped_locometal" | "iceandfire:iceandfire/kill_cyclops" | "minecraft:husbandry/silk_touch_nest" | "minecraft:recipes/building_blocks/dark_prismarine_stairs" | "minecraft:recipes/building_blocks/dye_cyan_wool" | "ae2:recipes/misc/tools/portable_item_cell_16k" | "minecraft:recipes/decorations/andesite_wall_from_andesite_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_honeycomb" | "ad_astra:recipes/misc/netherite_space_helmet" | "minecraft:recipes/building_blocks/nether_brick_stairs" | "create:train_roadkill" | "sophisticatedbackpacks:recipes/misc/chipped/glassblower_upgrade" | "create:recipes/building_blocks/cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "agricraft:recipes/tools/iron_rake" | "comforts:sleeping_bag_magenta" | "hexcasting:recipes/building_blocks/ancient_scroll_paper" | "iceandfire:iceandfire/dragonbone_tool" | "create:recipes/misc/crafting/kinetics/black_valve_handle_from_other_valve_handle" | "farmersdelight:recipes/cooking/vegetable_noodles" | "ad_astra:recipes/misc/netherite_space_boots" | "biomesoplenty:recipes/redstone/mahogany_fence_gate" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab" | "create:recipes/building_blocks/oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "biomesoplenty:recipes/redstone/fir_fence_gate" | "ae2:recipes/misc/shaped/walls/quartz_block" | "ratatouille:recipes/decorations/rat_maid_plush" | "minecraft:story/smelt_iron" | "create:brass_casing" | "minecraft:recipes/misc/orange_dye_from_torchflower" | "ad_astra:recipes/misc/steel_nugget" | "iceandfire:recipes/combat/dragonarmor_gold_tail" | "create:recipes/misc/smelting/ingot_tin_compat_mekanism" | "biomesoplenty:recipes/redstone/magic_door" | "minecraft:recipes/tools/fishing_rod" | "minecraft:recipes/decorations/smoker" | "create:recipes/building_blocks/crafting/logistics/pink_postbox_from_other_postbox" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_slashed_locometal" | "ad_astra:recipes/misc/mercury_pillar" | "computercraft:recipes/redstone/pocket_normal/computercraft/wireless_modem_advanced" | "create:wrench_goggles" | "biomesoplenty:recipes/building_blocks/chiseled_brimstone_bricks_from_brimstone_stonecutting" | "create:recipes/building_blocks/copper_tile_stairs_from_copper_tiles_stonecutting" | "iceandfire:recipes/combat/armor_white_boots" | "create:recipes/building_blocks/weathered_iron_block_from_iron_ingots_stonecutting" | "ad_astra:recipes/misc/glacio_cobblestone_slab" | "minecraft:recipes/building_blocks/chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "ad_astra:recipes/misc/space_boots" | "tconstruct:recipes/building_blocks/common/materials/queens_slime_ingot_from_block" | "railways:recipes/misc/crafting/palettes/wrapping/gray_iron_wrapped_locometal" | "hexal:recipes/redstone/relay" | "create:recipes/building_blocks/layered_tuff_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/chiseled_stone_bricks" | "create:recipes/building_blocks/crafting/logistics/blue_table_cloth" | "minecraft:recipes/building_blocks/nether_brick_slab" | "biomesoplenty:recipes/building_blocks/smooth_orange_sandstone_slab_from_smooth_orange_sandstone_stonecutting" | "create:recipes/building_blocks/cut_granite_slab" | "minecraft:recipes/misc/pumpkin_seeds" | "biomesoplenty:recipes/redstone/empyreal_door" | "create:recipes/building_blocks/framed_glass_from_colorless_glass_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal" | "create:recipes/misc/crafting/kinetics/mechanical_bearing" | "hexcasting:recipes/brainsweep/brainsweep/budding_amethyst" | "farmersdelight:recipes/decorations/jungle_cabinet" | "comforts:sleeping_bag_black" | "create:cross_streams" | "minecraft:recipes/decorations/mud_brick_wall" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/log_to_wood" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal_boiler" | "classicpipes:recipes/obsidian_fluid_pipe_a" | "minecraft:recipes/building_blocks/red_sandstone" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_flat_riveted_locometal" | "minecraft:husbandry/tadpole_in_a_bucket" | "tconstruct:recipes/misc/common/glass/clear_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_slashed_locometal" | "biomesoplenty:recipes/redstone/magic_pressure_plate" | "minecraft:recipes/redstone/dark_oak_button" | "create:recipes/misc/blasting/ingot_osmium_compat_mekanism" | "ae2:recipes/misc/smelting/silicon_from_certus_quartz_dust" | "tconstruct:recipes/misc/smeltery/scorched/scorched_bricks_fence" | "minecraft:husbandry/wax_off" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_stairs_from_honeycomb" | "railways:recipes/misc/stonecutting/palettes/cycling/flat_slashed_locometal" | "ae2:recipes/misc/decorative/quartz_block" | "farmersdelight:recipes/food/rice_panicle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_riveted_locometal" | "tconstruct:recipes/misc/common/slime/ichor/crystal_block" | "minecraft:recipes/decorations/beehive" | "ad_astra:recipes/misc/coal_generator" | "minecraft:recipes/misc/rib_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/tools/netherite_hoe_smithing" | "minecraft:recipes/decorations/lime_candle" | "minecraft:recipes/building_blocks/emerald_block" | "minecraft:recipes/food/cooked_rabbit_from_smoking" | "sophisticatedbackpacks:recipes/misc/chipped/tinkering_table_upgrade" | "create:recipes/misc/crafting/kinetics/train_door" | "ae2:recipes/misc/shaped/slabs/quartz_block" | "ad_astra:recipes/misc/stonecutting/venus_cobblestone_stairs_from_venus_cobblestone_stonecutting" | "ad_astra:recipes/misc/blasting/iron_ingot_from_blasting_mercury_iron_ore" | "farmersdelight:recipes/misc/paper_from_tree_bark" | "farmersdelight:recipes/cooking/cabbage_rolls" | "ad_astra:recipes/misc/stonecutting/glacio_stone_brick_wall_from_glacio_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/nether_wart_block" | "ad_astra:recipes/misc/desh_sliding_door" | "tconstruct:recipes/misc/smeltery/scorched/basin" | "biomesoplenty:recipes/building_blocks/orange_sandstone_slab_from_orange_sandstone_stonecutting" | "create:recipes/building_blocks/cut_deepslate_slab_recycling" | "hexcasting:recipes/misc/dye_colorizer_yellow" | "ad_astra:recipes/misc/steel_factory_block" | "minecraft:recipes/redstone/trapped_chest" | "minecraft:recipes/building_blocks/dye_pink_wool" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_brass_wrapped_locometal_boiler" | "ae2:recipes/misc/network/cells/fluid_storage_cell_256k_storage" | "ae2:recipes/misc/network/cables/dense_covered_black" | "tconstruct:world/slimeskull" | "minecraft:recipes/decorations/cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/andesite_from_stone_types_andesite_stonecutting" | "tconstruct:recipes/misc/common/copper_platform_waxing_oxidized" | "iceandfire:recipes/building_blocks/dragonscales_bronze_to_dragonscale_bronze" | "ae2:recipes/misc/tools/nether_quartz_cutting_knife" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_slab" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade_from_basic" | "biomesoplenty:recipes/redstone/redwood_button" | "iceandfire:iceandfire/dragonbone_flaming_sword" | "ad_astra:recipes/misc/desh_engine" | "ae2:recipes/misc/network/blocks/crystal_processing_charger" | "minecraft:recipes/building_blocks/stripped_birch_wood" | "create:recipes/misc/crafting/schematics/schematic_and_quill" | "create:windmill" | "create:recipes/building_blocks/cut_andesite_from_stone_types_andesite_stonecutting" | "ad_astra:recipes/misc/stonecutting/mars_cobblestone_slab_from_mars_cobblestone_stonecutting" | "biomesoplenty:recipes/transportation/fir_boat" | "create:rose_quartz" | "iceandfire:recipes/combat/cockatrice_scepter" | "create:recipes/misc/smelting/ingot_uranium_compat_ic2" | "biomesoplenty:recipes/building_blocks/stripped_maple_wood" | "railways:recipes/misc/stonecutting/palettes/cycling/plated_locometal" | "ae2:recipes/misc/tools/fluix_axe" | "minecraft:recipes/building_blocks/sponge" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "create:recipes/building_blocks/cut_veridium_wall" | "ae2:recipes/misc/network/cables/dense_covered_cyan" | "ae2:recipes/misc/shaped/stairs/chiseled_quartz_block" | "minecraft:recipes/building_blocks/prismarine_brick_stairs" | "minecraft:recipes/decorations/prismarine_wall" | "create:recipes/misc/crafting/kinetics/linear_chassis_from_conversion" | "comforts:sleeping_bag_red" | "create:recipes/building_blocks/cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "iceandfire:iceandfire/kill_siren" | "create:recipes/misc/crafting/schematics/empty_schematic" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_flat_slashed_locometal" | "ad_astra:recipes/alloying/alloying/steel_ingot_from_alloying_iron_ingot_and_coals" | "create:recipes/decorations/brass_table_cloth_from_brass_ingots_stonecutting" | "tconstruct:recipes/building_blocks/common/materials/amethyst_bronze_nugget_from_ingot" | "minecraft:recipes/redstone/warped_fence_gate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_veridium_brick_slab_recycling" | "minecraft:recipes/transportation/acacia_chest_boat" | "iceandfire:recipes/building_blocks/silver_ingot_to_silver_block" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_copper_wrapped_locometal" | "biomesoplenty:biomesoplenty/all_biomes" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_fire_head" | "biomesoplenty:recipes/decorations/empyreal_hanging_sign" | "minecraft:recipes/decorations/white_candle" | "farmersdelight:recipes/food/salmon_roll" | "extendedae:recipes/misc/ei" | "minecraft:recipes/combat/turtle_helmet" | "iceandfire:recipes/misc/dragonbone" | "minecraft:recipes/building_blocks/mud_brick_stairs_from_mud_bricks_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_horizontal_framed_glass_pane" | "create:recipes/decorations/brass_scaffolding_from_brass_ingots_stonecutting" | "farmersdelight:main/place_feast" | "minecraft:recipes/building_blocks/oak_stairs" | "iceandfire:recipes/combat/armor_copper_boots" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_andesite_stonecutting" | "ae2:recipes/misc/network/crystal_resonance_generator" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_smokebox" | "tconstruct:recipes/misc/gadgets/slimesling/ender" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_riveted_locometal" | "biomesoplenty:recipes/transportation/magic_chest_boat" | "sophisticatedbackpacks:recipes/misc/smithing_upgrade" | "create:package_chute_throw" | "hexpigmentplus:recipes/hats" | "minecraft:end/dragon_breath" | "create:recipes/building_blocks/weathered_iron_window" | "tconstruct:recipes/misc/common/slime/lead" | "create:recipes/misc/blasting/silver_ingot_compat_galosphere" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat_from_other_seat" | "railways:recipes/combat/dying_existing_cap_purple" | "create:recipes/misc/crafting/kinetics/fluid_pipe" | "biomesoplenty:recipes/decorations/yellow_maple_leaf_pile" | "create:recipes/misc/crafting/kinetics/blue_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_boiler" | "minecraft:recipes/building_blocks/white_concrete_powder" | "hexcasting:recipes/brainsweep/brainsweep/directrix_boolean" | "create:recipes/building_blocks/polished_cut_crimsite_stairs" | "create:recipes/building_blocks/small_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/stripped_log_to_wood" | "agricraft:recipes/tools/magnifying_glass" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/sign" | "ae2:recipes/misc/network/cables/glass_light_gray" | "minecraft:recipes/misc/music_disc_5" | "biomesoplenty:recipes/decorations/black_sandstone_wall_from_black_sandstone_stonecutting" | "ad_astra:recipes/misc/yellow_industrial_lamp" | "create:recipes/building_blocks/cut_dripstone_slab" | "minecraft:recipes/misc/netherite_scrap" | "iceandfire:iceandfire/tame_pixie" | "minecraft:story/enchant_item" | "biomesoplenty:recipes/decorations/white_sandstone_wall_from_white_sandstone_stonecutting" | "iceandfire:recipes/tools/dragonsteel_fire_hoe" | "create:recipes/building_blocks/layered_crimsite_from_stone_types_crimsite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_flat_slashed_locometal" | "computercraft:recipes/redstone/disk_drive" | "minecraft:recipes/building_blocks/lime_stained_glass" | "iceandfire:recipes/combat/armor_bronze_boots" | "create:recipes/misc/smelting/lead_ingot_compat_techreborn" | "create:recipes/building_blocks/polished_cut_tuff_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal" | "biomesoplenty:recipes/building_blocks/jacaranda_planks" | "minecraft:recipes/building_blocks/quartz_pillar_from_quartz_block_stonecutting" | "ad_astra:recipes/misc/stonecutting/polished_venus_stone_from_venus_stone_bricks_stonecutting" | "create:recipes/building_blocks/cut_tuff_stairs" | "create:recipes/building_blocks/cut_tuff_wall" | "minecraft:recipes/redstone/cherry_trapdoor" | "biomesoplenty:recipes/decorations/brimstone_brick_wall_from_brimstone_bricks_stonecutting" | "ae2:recipes/misc/tools/network_tool" | "tconstruct:recipes/misc/common/glass/cyan_clear_stained_glass" | "create:recipes/misc/crafting/kinetics/brass_hand" | "biomesoplenty:recipes/building_blocks/orange_sandstone_stairs_from_orange_sandstone_stonecutting" | "minecraft:recipes/decorations/chain" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_brass_wrapped_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_locometal_pillar" | "iceandfire:recipes/tools/copper_sword" | "create:stressometer_maxed" | "minecraft:recipes/decorations/yellow_bed" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_boiler" | "create:recipes/building_blocks/layered_ochrum_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/cut_scoria_from_stone_types_scoria_stonecutting" | "tconstruct:tools/tool_smith" | "minecraft:recipes/decorations/oak_fence" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_smokebox" | "ad_astra:recipes/misc/moon_stone_stairs" | "create:recipes/building_blocks/ochrum_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/cut_limestone_stairs" | "ad_astra:recipes/nasa_workbench/nasa_workbench/tier_3_rocket_from_nasa_workbench" | "tconstruct:recipes/misc/smeltery/scorched/nether_grout" | "create:recipes/misc/crafting/logistics/redstone_requester" | "minecraft:recipes/redstone/cherry_button" | "tconstruct:recipes/redstone/world/wood/greenheart/trapdoor" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs" | "minecraft:recipes/misc/coal_from_blasting_coal_ore" | "minecraft:recipes/redstone/mangrove_door" | "create:display_board_0" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_locometal_smokebox" | "minecraft:recipes/redstone/redstone_from_smelting_deepslate_redstone_ore" | "create:steam_whistle" | "minecraft:recipes/food/cooked_porkchop_from_campfire_cooking" | "ae2:recipes/misc/network/cells/item_storage_cell_4k" | "minecraft:recipes/building_blocks/chiseled_bookshelf" | "farmersdelight:recipes/cooking/pumpkin_soup" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal_boiler" | "create:recipes/misc/crafting/appliances/clipboard" | "create:recipes/building_blocks/crafting/kinetics/black_seat_from_other_seat" | "ad_astra:recipes/misc/stonecutting/polished_conglomerate_from_conglomerate_stonecutting" | "biomesoplenty:recipes/decorations/orange_sandstone_wall" | "ad_astra:recipes/misc/lime_industrial_lamp" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_boiler" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_slashed_locometal" | "ae2:recipes/misc/tools/paintballs_lumen_purple" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/planks" | "minecraft:recipes/decorations/light_blue_stained_glass_pane" | "biomesoplenty:recipes/decorations/palm_hanging_sign" | "create:recipes/building_blocks/cut_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "ad_astra:recipes/misc/ostrum_plating_button" | "tconstruct:recipes/building_blocks/world/wood/bloodshroom/fence" | "create:crafter_lazy_000" | "minecraft:adventure/spyglass_at_parrot" | "minecraft:recipes/building_blocks/nether_brick_stairs_from_nether_bricks_stonecutting" | "iceandfire:recipes/combat/armor_bronze_leggings" | "create:recipes/building_blocks/copper_shingle_stairs" | "create:recipes/misc/crafting/logistics/white_table_cloth_clear" | "ae2:recipes/misc/network/parts/export_bus" | "create:recipes/building_blocks/small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "iceandfire:recipes/combat/deathworm_red_chestplate" | "create:recipes/misc/crafting/kinetics/linear_chassis" | "create:recipes/building_blocks/cut_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs" | "hexcasting:recipes/building_blocks/stonecutting/quenched_allay_bricks_small" | "iceandfire:recipes/combat/armor_amythest_boots" | "tconstruct:recipes/misc/common/glass/gray_clear_stained_glass_pane_from_panes" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_plated_locometal" | "ad_astra:recipes/misc/blasting/ostrum_ingot_from_blasting_raw_ostrum" | "create:recipes/misc/smelting/uranium_ingot_compat_modern_industrialization" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_flat_slashed_locometal" | "ae2:recipes/misc/network/blocks/interfaces_interface_part" | "ad_astra:recipes/misc/smelting/ice_shard_from_smelting_mars_ice_shard_ore" | "minecraft:recipes/building_blocks/spruce_wood" | "create:recipes/misc/blasting/ingot_uranium_compat_immersiveengineering" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_copper_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/track_signal" | "ae2:recipes/misc/network/cables/smart_light_gray" | "ad_astra:recipes/misc/stonecutting/chiseled_permafrost_brick_stairs_from_chiseled_permafrost_bricks_stonecutting" | "minecraft:recipes/misc/yellow_dye_from_dandelion" | "ae2:recipes/misc/tools/paintballs_lumen_light_gray" | "biomesoplenty:recipes/building_blocks/smooth_white_sandstone_slab" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_bricks_stairs" | "biomesoplenty:recipes/building_blocks/black_sandstone_slab_from_black_sandstone_stonecutting" | "minecraft:recipes/decorations/end_stone_brick_wall" | "create:recipes/misc/crafting/kinetics/gantry_carriage" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal_boiler" | "ad_astra:recipes/misc/stonecutting/moon_stone_stairs_from_moon_stone_stonecutting" | "iceandfire:recipes/combat/armor_blue_chestplate" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_plated_locometal" | "iceandfire:recipes/combat/dragonsteel_lightning_leggings" | "minecraft:recipes/decorations/mangrove_hanging_sign" | "minecraft:recipes/building_blocks/deepslate_bricks_from_polished_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_slashed_locometal" | "ad_astra:recipes/misc/smelting/cracked_permafrost_bricks_from_smelting_permafrost_bricks" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_riveted_locometal" | "minecraft:recipes/decorations/black_banner" | "create:recipes/building_blocks/small_granite_brick_wall_from_stone_types_granite_stonecutting" | "minecraft:recipes/misc/black_dye_from_wither_rose" | "minecraft:recipes/misc/bone_meal" | "hexcasting:recipes/misc/pride_colorizer_nonbinary" | "create:speed_controller" | "create:recipes/misc/crafting/logistics/stock_link" | "computercraft:recipes/redstone/turtle_advanced_overlays/turtle_rainbow_overlay" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal" | "create:recipes/misc/blasting/ingot_uranium_compat_ic2" | "railways:recipes/misc/crafting/palettes/wrapping/blue_copper_wrapped_locometal" | "create:recipes/building_blocks/tuff_pillar_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/diorite_pillar_from_stone_types_diorite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_slab_from_prismarine_stonecutting" | "create:recipes/building_blocks/weathered_iron_window_pane" | "minecraft:recipes/building_blocks/sandstone_stairs_from_sandstone_stonecutting" | "ae2:recipes/misc/tools/paintballs_cyan" | "biomesoplenty:recipes/redstone/magic_fence_gate" | "minecraft:adventure/totem_of_undying" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_slashed_locometal" | "minecraft:recipes/decorations/cobbled_deepslate_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_iron_wrapped_locometal_boiler" | "ad_astra:recipes/misc/stonecutting/chiseled_mars_stone_slab_from_chiseled_mars_stone_bricks_stonecutting" | "tconstruct:recipes/misc/tables/part_builder" | "ad_astra:astronaut" | "minecraft:recipes/building_blocks/prismarine_bricks" | "farmersdelight:recipes/food/chocolate_pie_from_slices" | "create:recipes/misc/crafting/appliances/name_tag" | "minecraft:recipes/decorations/polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "tconstruct:recipes/building_blocks/world/wood/skyroot/planks" | "lootr:root" | "biomesoplenty:recipes/building_blocks/rose_quartz_block" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal" | "farmersdelight:recipes/decorations/green_hanging_canvas_sign" | "tconstruct:recipes/building_blocks/common/materials/pig_iron_ingot_from_block" | "extendedae:recipes/misc/threshold_export_bus" | "minecraft:recipes/decorations/diorite_wall" | "ad_astra:recipes/misc/smelting/coal_from_smelting_venus_coal_ore" | "agricraft:recipes/misc/diamond" | "ae2:recipes/misc/tools/paintballs_lumen_orange" | "iceandfire:recipes/tools/dragonbone_axe" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal_boiler" | "iceandfire:recipes/misc/earplugs" | "create:recipes/building_blocks/cut_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "iceandfire:recipes/combat/tide_blue_helmet" | "create:recipes/misc/blasting/platinum_ingot_compat_modern_industrialization" | "hexcasting:recipes/redstone/akashic_connector" | "minecraft:recipes/decorations/stonecutter" | "classicpipes:recipes/routing_pipe" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal" | "farmersdelight:recipes/food/barbecue_stick" | "sophisticatedbackpacks:recipes/misc/compacting_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "ad_astra:recipes/compressing/compressing/iron_plate_from_compressing_iron_ingot" | "tconstruct:recipes/misc/smeltery/scorched/channel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal_boiler" | "tconstruct:recipes/building_blocks/world/wood/skyroot/slab" | "minecraft:recipes/decorations/light_blue_banner" | "biomesoplenty:recipes/misc/light_gray_dye_from_endbloom" | "ae2:recipes/misc/tools/nether_quartz_spade" | "hexcasting:recipes/building_blocks/stonecutting/amethyst_bricks_small" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal" | "minecraft:recipes/decorations/smithing_table" | "biomesoplenty:recipes/transportation/maple_boat" | "create:recipes/building_blocks/crafting/logistics/light_gray_table_cloth" | "hexcasting:recipes/misc/pride_colorizer_aromantic" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal_boiler" | "ad_astra:recipes/misc/small_blue_industrial_lamp" | "tconstruct:recipes/misc/smeltery/scorched/drain_retextured" | "tconstruct:recipes/misc/common/slime/ichor/slimeball_from_congealed" | "minecraft:recipes/building_blocks/cut_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_pillar" | "minecraft:recipes/misc/sugar_from_honey_bottle" | "minecraft:recipes/building_blocks/dye_red_carpet" | "tconstruct:recipes/misc/common/slime/sky/crystal_growing" | "ad_astra:recipes/misc/cheese" | "ae2:recipes/misc/decorative/quartz_fixture_from_anchors" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "ad_astra:recipes/misc/mercury_stone_slab" | "ad_astra:recipes/misc/stonecutting/glacio_stone_stairs_from_glacio_stone_stonecutting" | "tconstruct:recipes/building_blocks/common/materials/hepatizon_ingot_from_nuggets" | "create:recipes/building_blocks/copper_shingles_from_copper_ingots_stonecutting" | "create:recipes/building_blocks/cut_limestone_brick_wall" | "iceandfire:recipes/food/ambrosia" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "iceandfire:recipes/misc/dragonscale_white_to_dragonscales_white" | "ad_astra:recipes/misc/stonecutting/chiseled_venus_stone_bricks_from_venus_stone_stonecutting" | "create:recipes/building_blocks/oxidized_copper_tile_stairs" | "minecraft:recipes/decorations/orange_stained_glass_pane_from_glass_pane" | "minecraft:recipes/transportation/tnt_minecart" | "biomesoplenty:recipes/misc/white_dye_from_white_lavender" | "ae2:recipes/misc/tools/certus_quartz_wrench" | "biomesoplenty:recipes/redstone/maple_fence_gate" | "ae2:recipes/misc/tools/nether_quartz_wrench" | "create:crusher_maxed_0000" | "create:recipes/misc/smelting/copper_ingot_from_crushed" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_riveted_locometal" | "create:recipes/building_blocks/small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "ad_astra:recipes/misc/glacian_fence_gate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_smokebox" | "classicpipes:recipes/mangrove_fluid_pipe_a" | "ad_astra:recipes/misc/small_red_industrial_lamp" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "ae2:recipes/misc/network/cables/covered_magenta" | "minecraft:recipes/building_blocks/dye_green_bed" | "create:recipes/misc/smelting/tin_ingot_compat_techreborn" | "iceandfire:recipes/combat/tide_bronze_leggings" | "tconstruct:recipes/building_blocks/common/firewood/nahuatl_slab" | "create:recipes/building_blocks/polished_cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/brown_candle" | "minecraft:recipes/building_blocks/quartz_pillar" | "minecraft:husbandry/wax_on" | "minecraft:recipes/building_blocks/purple_terracotta" | "create:recipes/misc/crafting/logistics/light_gray_table_cloth_clear" | "create:recipes/misc/crafting/logistics/powered_latch" | "ad_astra:zip_gun" | "minecraft:adventure/play_jukebox_in_meadows" | "computercraft:recipes/redstone/turtle_normal" | "ad_astra:recipes/misc/gravity_normalizer" | "ae2:recipes/misc/network/cables/smart_magenta" | "biomesoplenty:recipes/building_blocks/smooth_white_sandstone_stairs_from_smooth_white_sandstone_stonecutting" | "create:recipes/building_blocks/polished_cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/misc/green_dye" | "biomesoplenty:recipes/redstone/magic_button" | "tconstruct:recipes/misc/common/glass/yellow_clear_stained_glass_pane_from_panes" | "minecraft:recipes/decorations/magenta_bed" | "create:recipes/building_blocks/polished_cut_granite_slab_recycling" | "minecraft:recipes/redstone/honey_block" | "minecraft:recipes/building_blocks/dark_prismarine" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_flat_slashed_locometal" | "minecraft:adventure/hero_of_the_village" | "create:recipes/building_blocks/polished_cut_limestone_wall" | "minecraft:recipes/redstone/redstone" | "railways:recipes/misc/stonecutting/palettes/cycling/riveted_locometal" | "minecraft:recipes/building_blocks/smooth_stone" | "create:recipes/building_blocks/small_scorchia_brick_slab_recycling" | "create:recipes/misc/crafting/logistics/andesite_tunnel" | "biomesoplenty:recipes/decorations/mahogany_sign" | "create:recipes/decorations/copper_table_cloth_from_copper_ingots_stonecutting" | "ad_astra:recipes/compressing/compressing/calorite_plate_from_compressing_calorite_ingots" | "minecraft:recipes/misc/coast_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_pink_carpet" | "railways:recipes/misc/crafting/palettes/wrapping/pink_copper_wrapped_locometal" | "classicpipes:recipes/diamond_fluid_pipe_a" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_boiler" | "create:recipes/building_blocks/crafting/logistics/light_gray_table_cloth_from_other_table_cloth" | "minecraft:recipes/building_blocks/packed_ice" | "minecraft:recipes/transportation/spruce_boat" | "hexcasting:recipes/misc/pride_colorizer_bisexual" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_slashed_locometal" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_small_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/quartz_stairs_from_quartz_block_stonecutting" | "iceandfire:recipes/combat/armor_blue_helmet" | "tconstruct:recipes/misc/common/glass/green_clear_stained_glass" | "ae2:recipes/misc/network/cables/dense_covered_blue" | "iceandfire:recipes/misc/bestiary" | "biomesoplenty:recipes/misc/pink_dye_from_pink_hibiscus" | "ae2:recipes/misc/block_cutter/slabs/quartz_slab" | "biomesoplenty:recipes/building_blocks/magic_planks" | "minecraft:recipes/building_blocks/deepslate_tiles" | "biomesoplenty:recipes/transportation/redwood_chest_boat" | "extendedae:recipes/misc/epp_upgrade" | "create:recipes/building_blocks/crimsite_pillar_from_stone_types_crimsite_stonecutting" | "hexcasting:recipes/building_blocks/slate_bricks" | "iceandfire:recipes/building_blocks/raw_silver_to_raw_silver_block" | "minecraft:recipes/building_blocks/warped_hyphae" | "biomesoplenty:recipes/decorations/blackstone_bulb" | "minecraft:recipes/redstone/jungle_button" | "hexcasting:recipes/building_blocks/edified_planks" | "ad_astra:recipes/misc/steel_plating_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/black_locometal_smokebox" | "farmersdelight:recipes/misc/canvas" | "minecraft:recipes/redstone/note_block" | "hexcasting:recipes/tools/staff/cherry" | "railways:recipes/combat/dying_existing_cap_gray" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_copper_wrapped_locometal" | "minecraft:recipes/decorations/green_stained_glass_pane_from_glass_pane" | "create:recipes/building_blocks/crafting/kinetics/lime_seat_from_other_seat" | "create:hose_pulley" | "minecraft:recipes/decorations/crimson_hanging_sign" | "biomesoplenty:recipes/misc/pink_dye_from_pink_daffodil" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal" | "minecraft:recipes/decorations/lime_bed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_flat_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_riveted_locometal" | "create:recipes/building_blocks/polished_cut_granite_slab_from_stone_types_granite_stonecutting" | "create:recipes/misc/crafting/kinetics/empty_blaze_burner" | "biomesoplenty:recipes/redstone/jacaranda_fence_gate" | "tconstruct:recipes/misc/smeltery/scorched/ingot_tank" | "iceandfire:iceandfire/rotten_egg" | "farmersdelight:recipes/decorations/light_gray_canvas_sign" | "minecraft:recipes/building_blocks/smooth_stone_slab" | "farmersdelight:recipes/food/cooked_mutton_chops_from_smoking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_slashed_locometal" | "ae2:recipes/misc/network/wireless_booster" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat" | "create:recipes/building_blocks/small_asurine_brick_wall" | "tconstruct:world/slimesuit" | "ad_astra:recipes/misc/blasting/copper_ingot_from_blasting_glacio_copper_ore" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_riveted_locometal" | "iceandfire:recipes/combat/tide_deepblue_chestplate" | "minecraft:recipes/misc/beacon" | "create:recipes/misc/crafting/kinetics/millstone" | "create:recipes/building_blocks/crafting/logistics/light_blue_table_cloth_from_other_table_cloth" | "tconstruct:recipes/building_blocks/world/wood/greenheart/sign" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade" | "tconstruct:recipes/misc/gadgets/frame/diamond" | "tconstruct:recipes/misc/common/glass/lime_clear_stained_glass_pane" | "biomesoplenty:recipes/building_blocks/cut_black_sandstone_slab_from_cut_black_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_boiler" | "minecraft:recipes/building_blocks/red_nether_bricks" | "ad_astra:gravity_normalizer" | "ae2:recipes/misc/network/cables/dense_covered_white" | "minecraft:recipes/decorations/cyan_carpet" | "minecraft:husbandry/root" | "biomesoplenty:recipes/redstone/pine_pressure_plate" | "create:recipes/building_blocks/cut_granite_bricks_from_stone_types_granite_stonecutting" | "tconstruct:recipes/tools/tools/building/ichor_staff" | "minecraft:recipes/transportation/birch_boat" | "minecraft:recipes/building_blocks/cut_copper_from_copper_block_stonecutting" | "tconstruct:smeltery/abilities" | "hexcasting:recipes/misc/decompose_quenched_shard/dust" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "create:recipes/misc/crafting/materials/small_rose_quartz_tiles_from_conversion" | "ae2:recipes/misc/network/cables/dense_covered_orange" | "tconstruct:recipes/misc/common/glass/black_clear_stained_glass" | "hexcasting:opened_eyes" | "ae2:recipes/misc/network/cables/dense_covered_green" | "create:recipes/misc/blasting/silver_ingot_compat_modern_industrialization" | "ae2:recipes/misc/tools/paintballs_yellow" | "biomesoplenty:recipes/building_blocks/cut_black_sandstone_from_black_sandstone_stonecutting" | "classicpipes:recipes/crimson_pipe" | "ae2:recipes/misc/network/cells/item_storage_cell_1k" | "biomesoplenty:recipes/decorations/brimstone_bud" | "ad_astra:recipes/misc/blasting/calorite_ingot_from_blasting_raw_calorite" | "iceandfire:recipes/building_blocks/dragonscales_gray_to_dragonscale_gray" | "biomesoplenty:recipes/decorations/redwood_fence" | "create:recipes/building_blocks/crafting/kinetics/purple_seat_from_other_seat" | "farmersdelight:recipes/food/cod_roll" | "railways:recipes/misc/crafting/palettes/wrapping/blue_iron_wrapped_locometal" | "minecraft:recipes/redstone/crimson_trapdoor" | "minecraft:recipes/building_blocks/cherry_wood" | "minecraft:recipes/decorations/green_glazed_terracotta" | "tconstruct:recipes/building_blocks/common/materials/cobalt_block_from_ingots" | "minecraft:recipes/decorations/bamboo_sign" | "tconstruct:recipes/combat/armor/building/plate_shield" | "ad_astra:recipes/misc/chiseled_permafrost_brick_stairs" | "create:recipes/misc/blasting/lead_ingot_compat_thermal" | "create:recipes/building_blocks/cut_ochrum_brick_stairs" | "ae2:recipes/misc/tools/matter_cannon" | "ad_astra:recipes/misc/venus_stone_stairs" | "iceandfire:recipes/combat/armor_electric_leggings" | "minecraft:recipes/building_blocks/blue_ice" | "ae2:recipes/misc/network/cables/dense_smart_pink" | "minecraft:adventure/trade" | "minecraft:recipes/building_blocks/deepslate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_flat_slashed_locometal" | "ad_astra:recipes/misc/marked_iron_pillar" | "ad_astra:recipes/misc/smelting/cracked_moon_stone_bricks_from_smelting_moon_stone_bricks" | "minecraft:recipes/decorations/white_carpet" | "ae2:main/pattern_encoding_terminal" | "ad_astra:recipes/misc/desh_ingot" | "minecraft:recipes/transportation/cherry_chest_boat" | "create:recipes/misc/crafting/appliances/cardboard_chestplate" | "tconstruct:recipes/building_blocks/world/wood/greenheart/log_to_wood" | "tconstruct:recipes/misc/gadgets/frame/manyullyn" | "minecraft:recipes/building_blocks/red_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_boiler" | "minecraft:recipes/building_blocks/dark_prismarine_slab" | "iceandfire:recipes/combat/dragonsteel_ice_chestplate" | "iceandfire:recipes/decorations/copper_pile" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_flat_slashed_locometal" | "minecraft:recipes/decorations/pink_stained_glass_pane_from_glass_pane" | "biomesoplenty:recipes/transportation/empyreal_chest_boat" | "create:recipes/building_blocks/cut_scoria_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_iron_wrapped_locometal_boiler" | "create:recipes/misc/smelting/glass_pane_from_tiled_glass_pane" | "create:recipes/building_blocks/cut_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/jack_o_lantern" | "minecraft:recipes/transportation/birch_chest_boat" | "minecraft:recipes/decorations/glass_pane" | "ad_astra:recipes/misc/stonecutting/chiseled_permafrost_bricks_from_permafrost_bricks_stonecutting" | "biomesoplenty:recipes/misc/red_dye_from_waterlily" | "minecraft:recipes/decorations/purple_banner" | "tconstruct:recipes/building_blocks/common/materials/amethyst_bronze_ingot_from_block" | "minecraft:recipes/building_blocks/magenta_stained_glass" | "create:recipes/misc/crafting/schematics/schematic_table" | "biomesoplenty:recipes/decorations/fir_sign" | "farmersdelight:recipes/decorations/skillet" | "ad_astra:recipes/misc/gas_tank" | "create:recipes/building_blocks/crafting/logistics/purple_postbox" | "create:recipes/building_blocks/crafting/logistics/light_gray_postbox_from_other_postbox" | "minecraft:recipes/transportation/oak_boat" | "classicpipes:recipes/golden_pipe" | "ae2:recipes/misc/network/parts/monitors_conversion" | "ae2:recipes/misc/network/cables/dense_covered_magenta" | "biomesoplenty:recipes/building_blocks/cut_white_sandstone_from_white_sandstone_stonecutting" | "biomesoplenty:recipes/decorations/brimstone_cluster_from_brimstone_stonecutting" | "ad_astra:recipes/misc/chiseled_moon_stone_slab" | "railways:recipes/misc/crafting/smokestack_streamlined" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_plated_locometal" | "biomesoplenty:recipes/misc/white_dye_from_tall_white_lavender" | "create:recipes/building_blocks/polished_cut_scorchia_stairs" | "ae2:main/storage_cell" | "create:recipes/building_blocks/polished_cut_asurine_wall_from_stone_types_asurine_stonecutting" | "ad_astra:recipes/misc/stonecutting/mars_stone_brick_stairs_from_mars_stone_stonecutting" | "minecraft:recipes/building_blocks/bamboo_mosaic_stairs" | "create:recipes/building_blocks/small_granite_brick_wall" | "minecraft:recipes/building_blocks/smooth_stone_slab_from_smooth_stone_stonecutting" | "iceandfire:recipes/tools/dragonbone_pickaxe" | "railways:recipes/misc/stonecutting/palettes/cycling/green_locometal_smokebox" | "minecraft:recipes/decorations/deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "create:recipes/misc/crafting/logistics/cyan_table_cloth_clear" | "ae2:recipes/misc/network/cables/covered_gray" | "minecraft:recipes/misc/paper" | "hexical:hallucinate" | "create:recipes/building_blocks/polished_cut_tuff_stairs" | "ad_astra:ocean_cleanup" | "ad_astra:recipes/misc/stonecutting/polished_moon_stone_stairs_from_polished_moon_stone_stonecutting" | "tconstruct:smeltery/structure" | "create:backtank" | "ad_astra:recipes/misc/iron_plating_pressure_plate" | "minecraft:recipes/redstone/warped_button" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_riveted_locometal" | "minecraft:husbandry/kill_axolotl_target" | "minecraft:recipes/decorations/stone_brick_wall_from_stone_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_flat_slashed_locometal" | "minecraft:recipes/building_blocks/red_nether_brick_stairs" | "ad_astra:recipes/misc/glacio_stone_bricks" | "create:recipes/misc/crafting/kinetics/brass_door" | "biomesoplenty:recipes/transportation/redwood_boat" | "ad_astra:recipes/misc/polished_glacio_stone" | "railways:recipes/misc/stonecutting/palettes/cycling/red_flat_riveted_locometal" | "create:recipes/building_blocks/small_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "biomesoplenty:recipes/decorations/willow_fence" | "ae2:recipes/misc/network/crafting/patterns_blank" | "iceandfire:recipes/combat/armor_black_chestplate" | "ad_astra:recipes/misc/jet_suit_pants" | "ae2:recipes/misc/network/cells/fluid_storage_cell_4k" | "minecraft:recipes/building_blocks/warped_stairs" | "ad_astra:recipes/misc/stonecutting/polished_moon_stone_stairs_from_moon_stone_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_wall" | "minecraft:recipes/building_blocks/white_stained_glass" | "ae2:recipes/misc/network/cables/dense_covered_lime" | "farmersdelight:recipes/food/bread_from_smoking" | "minecraft:recipes/decorations/blue_glazed_terracotta" | "tconstruct:world/ender_island" | "farmersdelight:recipes/cooking/cooked_rice" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_moss_block" | "minecraft:recipes/building_blocks/andesite_slab_from_andesite_stonecutting" | "minecraft:recipes/redstone/acacia_fence_gate" | "minecraft:recipes/building_blocks/coal_block" | "hexcasting:recipes/tools/staff/oak" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_honeycomb" | "iceandfire:recipes/combat/deathworm_red_boots" | "railways:recipes/misc/crafting/palettes/wrapping/brass_wrapped_locometal" | "extendedae:recipes/misc/ebus_out" | "ad_astra:recipes/misc/raw_calorite_block" | "minecraft:recipes/building_blocks/spruce_slab" | "minecraft:recipes/decorations/polished_blackstone_wall_from_blackstone_stonecutting" | "iceandfire:recipes/combat/dragonarmor_iron_tail" | "biomesoplenty:recipes/transportation/dead_chest_boat" | "create:recipes/building_blocks/cut_asurine_brick_slab_recycling" | "ae2:recipes/misc/shaped/walls/chiseled_quartz_block" | "minecraft:recipes/tools/lead" | "minecraft:recipes/decorations/warped_sign" | "tconstruct:recipes/misc/common/glass/cyan_clear_stained_glass_pane_from_panes" | "farmersdelight:recipes/cooking/fried_rice" | "hexcasting:recipes/misc/dye_colorizer_lime" | "ae2:recipes/misc/network/cells/view_cell_storage" | "minecraft:recipes/decorations/white_stained_glass_pane_from_glass_pane" | "create:recipes/misc/crafting/kinetics/windmill_bearing" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "hexcasting:lore" | "iceandfire:recipes/tools/dragonsteel_fire_sword" | "create:recipes/building_blocks/polished_cut_ochrum_from_stone_types_ochrum_stonecutting" | "computercraft:recipes/redstone/wired_modem" | "computercraft:recipes/redstone/turtle_advanced/computercraft/wireless_modem_normal" | "create:recipes/building_blocks/cut_asurine_bricks_from_stone_types_asurine_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_filter_upgrade" | "minecraft:recipes/redstone/bamboo_door" | "minecraft:recipes/decorations/lodestone" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_flat_slashed_locometal" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template_smithing_trim" | "biomesoplenty:recipes/building_blocks/magic_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_pillar" | "iceandfire:recipes/misc/dragon_ice_spikes" | "create:recipes/building_blocks/cut_calcite_brick_slab_recycling" | "create:recipes/building_blocks/cut_tuff_slab_recycling" | "create:recipes/misc/crafting/materials/sand_paper" | "ad_astra:recipes/misc/polished_mercury_stone" | "create:recipes/building_blocks/layered_limestone_from_stone_types_limestone_stonecutting" | "ad_astra:recipes/misc/desh_ingot_from_desh_block" | "tconstruct:recipes/building_blocks/common/materials/manyullyn_ingot_from_nuggets" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_smokebox" | "iceandfire:recipes/tools/dragonsteel_lightning_axe" | "create:recipes/building_blocks/crafting/logistics/white_postbox" | "ae2:recipes/misc/network/cells/fluid_storage_cell_1k" | "create:recipes/building_blocks/polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "iceandfire:recipes/misc/dragonsteel_lightning_block_to_dragonsteel_lightning_ingot" | "ad_astra:recipes/misc/stonecutting/moon_stone_brick_stairs_from_moon_stone_stonecutting" | "minecraft:recipes/redstone/oak_button" | "iceandfire:recipes/building_blocks/dragonscales_green_to_dragonscale_green" | "create:recipes/misc/crafting/kinetics/basin" | "iceandfire:recipes/tools/silver_ingot_from_blasting_raw_silver" | "create:belt_funnel_kiss" | "ad_astra:recipes/misc/stonecutting/permafrost_brick_slab_from_permafrost_bricks_stonecutting" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_ice_head" | "minecraft:adventure/honey_block_slide" | "ad_astra:recipes/misc/desh_plating_button" | "create:recipes/building_blocks/dark_oak_window_pane" | "minecraft:recipes/redstone/dark_oak_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_plated_locometal" | "biomesoplenty:recipes/building_blocks/brimstone_brick_stairs" | "minecraft:recipes/building_blocks/smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template" | "biomesoplenty:recipes/decorations/magic_hanging_sign" | "create:recipes/building_blocks/cut_calcite_slab" | "create:recipes/building_blocks/small_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "tconstruct:recipes/misc/common/glass/gray_clear_stained_glass_pane" | "minecraft:recipes/misc/iron_ingot_from_smelting_deepslate_iron_ore" | "minecraft:recipes/decorations/nether_brick_fence" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_blackstone_stonecutting" | "ae2:recipes/misc/tools/nether_quartz_axe" | "ad_astra:recipes/misc/small_gray_industrial_lamp" | "minecraft:recipes/misc/magenta_dye_from_allium" | "classicpipes:recipes/jungle_fluid_pipe_a" | "biomesoplenty:recipes/decorations/magic_sign" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/decorations/decorated_pot_simple" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_smokebox" | "minecraft:recipes/building_blocks/cracked_deepslate_tiles" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_stairs_from_honeycomb" | "ad_astra:recipes/misc/stonecutting/mars_stone_brick_slab_from_mars_stone_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/inception_upgrade" | "minecraft:recipes/building_blocks/exposed_cut_copper" | "create:linked_controller" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab" | "minecraft:recipes/decorations/stone_brick_walls_from_stone_stonecutting" | "ae2:recipes/misc/misc/deconstruction_certus_quartz_pillar" | "create:arm_many_targets" | "create:recipes/building_blocks/crafting/logistics/cyan_table_cloth_from_other_table_cloth" | "ad_astra:recipes/misc/chiseled_mercury_stone_bricks" | "create:recipes/building_blocks/polished_cut_diorite_wall_from_stone_types_diorite_stonecutting" | "create:recipes/misc/crafting/materials/transmitter" | "create:recipes/misc/smelting/silver_ingot_compat_iceandfire" | "minecraft:recipes/redstone/daylight_detector" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/diamond_from_blasting_deepslate_diamond_ore" | "biomesoplenty:recipes/decorations/palm_sign" | "create:recipes/misc/crafting/materials/copper_ingot" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/small_calcite_brick_slab" | "hexcasting:recipes/building_blocks/stonecutting/quenched_allay_tiles" | "ad_astra:recipes/misc/encased_steel_block" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_1" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_3" | "sophisticatedbackpacks:recipes/misc/stack_downgrade_tier_2" | "minecraft:recipes/building_blocks/dye_purple_bed" | "hexcasting:recipes/misc/dye_colorizer_blue" | "minecraft:recipes/redstone/jungle_fence_gate" | "create:recipes/misc/crafting/materials/zinc_block_from_compacting" | "iceandfire:recipes/misc/dragonscale_sapphire_to_dragonscales_sapphire" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/dye_light_gray_carpet" | "create:recipes/misc/crafting/kinetics/large_cogwheel" | "ae2:main/portable_cell" | "minecraft:recipes/redstone/warped_door" | "ae2:recipes/misc/network/parts/formation_plane_alt" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade" | "minecraft:recipes/decorations/dark_oak_fence" | "tconstruct:recipes/misc/gadgets/frame/gold" | "iceandfire:recipes/combat/armor_red_helmet" | "minecraft:recipes/combat/diamond_boots" | "create:recipes/misc/crafting/logistics/andesite_funnel" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat_from_other_seat" | "ae2:recipes/misc/shaped/slabs/smooth_quartz_block" | "create:recipes/misc/crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/smokestack_caboosestyle" | "ad_astra:recipes/misc/stonecutting/mars_stone_stairs_from_mars_stone_stonecutting" | "ad_astra:recipes/misc/chiseled_venus_stone_bricks" | "tconstruct:recipes/misc/common/slime/sky/slimeblock" | "ae2:recipes/misc/decorative/quartz_glass" | "create:recipes/misc/crafting/kinetics/fluid_valve" | "railways:recipes/misc/crafting/palettes/wrapping/brown_copper_wrapped_locometal" | "biomesoplenty:recipes/redstone/redwood_door" | "ad_astra:recipes/misc/smelting/desh_ingot_from_smelting_moon_desh_ore" | "create:recipes/misc/blasting/tin_ingot_compat_mythicmetals" | "computercraft:recipes/decorations/skull_dan200" | "create:recipes/building_blocks/polished_cut_asurine_stairs" | "create:recipes/decorations/andesite_table_cloth_from_andesite_alloy_stonecutting" | "create:recipes/building_blocks/small_dripstone_brick_stairs" | "farmersdelight:recipes/decorations/warped_cabinet" | "ae2:recipes/misc/network/cables/dense_smart_cyan" | "create:red_signal" | "iceandfire:recipes/building_blocks/sapphire_gem_to_sapphire_block" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_locometal_pillar" | "minecraft:recipes/combat/iron_sword" | "create:recipes/building_blocks/polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_flat_riveted_locometal" | "minecraft:recipes/redstone/observer" | "tconstruct:internal/starting_book" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal_boiler" | "iceandfire:recipes/combat/armor_copper_metal_boots" | "minecraft:recipes/misc/light_gray_dye_from_white_tulip" | "tconstruct:recipes/redstone/world/wood/bloodshroom/pressure_plate" | "create:recipes/building_blocks/crafting/logistics/light_blue_table_cloth" | "ae2:recipes/misc/materials/cardvoid" | "minecraft:recipes/tools/iron_pickaxe" | "minecraft:recipes/building_blocks/polished_granite_stairs" | "computercraft:recipes/decorations/skull_cloudy" | "create:recipes/building_blocks/crafting/logistics/white_postbox_from_other_postbox" | "minecraft:recipes/building_blocks/dark_oak_slab" | "ae2:recipes/misc/misc/deconstruction_fluix_block" | "minecraft:recipes/transportation/mangrove_boat" | "create:recipes/misc/crafting/kinetics/light_blue_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/cut_limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/decorations/torch" | "ad_astra:recipes/misc/strophar_door" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal" | "ae2:recipes/misc/tools/portable_fluid_cell_64k" | "ae2:recipes/misc/network/crafting/64k_cpu_crafting_storage" | "hexcasting:recipes/tools/staff/crimson" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_stonecutting" | "tconstruct:recipes/misc/smeltery/seared/seared_brick" | "hexcasting:recipes/brainsweep/brainsweep/impetus_storedplayer" | "tconstruct:recipes/misc/common/slime/ender/crystal_block" | "create:recipes/building_blocks/crafting/logistics/white_table_cloth" | "create:recipes/misc/crafting/logistics/andesite_table_cloth_clear" | "tconstruct:recipes/misc/common/slime/ender/slimeblock" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "hexcasting:recipes/misc/dye_colorizer_white" | "biomesoplenty:recipes/building_blocks/orange_sandstone_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_honeycomb" | "ae2:recipes/misc/tools/paintballs_lumen_brown" | "ae2:recipes/misc/network/cells/spatial_storage_cell_128_cubed" | "minecraft:recipes/building_blocks/dark_oak_planks" | "minecraft:recipes/transportation/detector_rail" | "iceandfire:recipes/combat/armor_copper_metal_helmet" | "tconstruct:recipes/misc/common/slime/blood/slimeblock" | "ae2:recipes/misc/network/blocks/controller" | "biomesoplenty:recipes/decorations/fir_hanging_sign" | "tconstruct:recipes/misc/smeltery/scorched/fuel_gauge" | "minecraft:recipes/combat/shield" | "ae2:recipes/misc/tools/paintballs_light_gray" | "computercraft:recipes/redstone/turtle_normal/minecraft/crafting_table" | "create:recipes/building_blocks/small_dripstone_brick_slab_recycling" | "minecraft:recipes/building_blocks/red_sandstone_stairs" | "create:recipes/building_blocks/crafting/logistics/magenta_postbox_from_other_postbox" | "create:recipes/misc/crafting/logistics/stockpile_switch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/birch_window_pane" | "create:recipes/misc/crafting/kinetics/chain_conveyor" | "iceandfire:recipes/misc/copper_nuggets_to_ingot" | "ad_astra:recipes/misc/moon_cobblestone_stairs" | "create:recipes/building_blocks/small_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "tconstruct:recipes/misc/smeltery/seared/channel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_boiler" | "ad_astra:recipes/misc/gray_industrial_lamp" | "tconstruct:recipes/misc/tools/modifiers/wither_bone_conversion" | "biomesoplenty:recipes/decorations/pine_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_flat_riveted_locometal" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_polished_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_riveted_locometal" | "create:recipes/building_blocks/polished_cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_wall_from_stone_types_scoria_stonecutting" | "ad_astra:recipes/misc/iron_panel" | "create:recipes/building_blocks/polished_cut_andesite_slab_from_stone_types_andesite_stonecutting" | "ad_astra:recipes/misc/polished_venus_stone_slab" | "biomesoplenty:recipes/decorations/umbran_sign" | "create:recipes/misc/crafting/kinetics/encased_chain_drive_from_zinc" | "minecraft:recipes/misc/dune_armor_trim_smithing_template" | "hexcasting:recipes/misc/pride_colorizer_gay" | "minecraft:recipes/decorations/magenta_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_calcite_wall" | "minecraft:recipes/misc/creeper_banner_pattern" | "ae2:recipes/misc/network/cells/item_storage_cell_256k_storage" | "tconstruct:recipes/building_blocks/world/wood/greenheart/planks" | "ae2:recipes/misc/network/parts/toggle_bus_inverted_alt" | "tconstruct:tools/part_builder" | "iceandfire:recipes/combat/armor_copper_chestplate" | "create:recipes/misc/crafting/materials/red_sand_paper" | "ad_astra:recipes/misc/stonecutting/polished_mars_stone_stairs_from_mars_stone_stonecutting" | "create:recipes/misc/crafting/kinetics/controls" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_smokebox" | "ae2:recipes/misc/network/cables/glass_purple" | "ad_astra:recipes/misc/permafrost_pillar" | "extendedae:recipes/misc/wireless_connector" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_flat_riveted_locometal" | "minecraft:recipes/building_blocks/andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/iron_bars" | "ad_astra:recipes/misc/cryo_freezer" | "ae2:recipes/misc/block_cutter/stairs/cut_quartz_stairs" | "create:recipes/building_blocks/cut_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "tconstruct:recipes/misc/common/slime/ender/slimeball_from_congealed" | "minecraft:recipes/misc/copper_ingot" | "ae2:recipes/misc/network/cables/smart_cyan" | "extendedae:recipes/misc/pattern_modifier" | "create:recipes/building_blocks/crafting/logistics/gray_table_cloth" | "create:recipes/building_blocks/cut_veridium_slab_from_stone_types_veridium_stonecutting" | "create:recipes/misc/blasting/ingot_aluminum_compat_immersiveengineering" | "create:recipes/building_blocks/cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "hexcasting:recipes/building_blocks/edified_stairs" | "tconstruct:recipes/misc/common/glass/light_blue_clear_stained_glass" | "ae2:recipes/misc/network/cables/covered_lime" | "ae2:recipes/misc/network/parts/tunnels_me" | "ad_astra:recipes/misc/stonecutting/polished_mars_stone_slab_from_mars_stone_stonecutting" | "extendedae:recipes/misc/tag_storage_bus" | "minecraft:recipes/building_blocks/dye_purple_wool" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_copper_wrapped_locometal" | "iceandfire:recipes/food/frost_stew" | "minecraft:recipes/transportation/chest_minecart" | "biomesoplenty:recipes/decorations/blackstone_spines" | "minecraft:recipes/building_blocks/spruce_planks" | "railways:recipes/misc/crafting/remote_lens" | "minecraft:recipes/building_blocks/netherite_block" | "create:recipes/building_blocks/cut_granite_slab_recycling" | "minecraft:recipes/building_blocks/polished_diorite_slab" | "create:train_crash" | "minecraft:recipes/decorations/red_carpet" | "ae2:recipes/misc/tools/paintballs_black" | "minecraft:recipes/misc/wild_armor_trim_smithing_template" | "biomesoplenty:recipes/misc/orange_dye_from_orange_cosmos" | "ad_astra:recipes/misc/glowing_steel_pillar" | "tconstruct:recipes/misc/smeltery/seared/drain_retextured" | "tconstruct:world/clay_island" | "ad_astra:recipes/misc/stonecutting/polished_mercury_stone_from_mercury_stone_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_plated_locometal" | "create:long_travel" | "ae2:recipes/misc/network/cables/covered_orange" | "minecraft:recipes/transportation/dark_oak_chest_boat" | "ae2:recipes/misc/tools/certus_quartz_cutting_knife" | "comforts:hammock_red" | "create:recipes/misc/crafting/kinetics/sequenced_gearshift" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_smokebox" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "minecraft:recipes/building_blocks/mud_brick_slab" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "extendedae:recipes/misc/ex_drive" | "minecraft:recipes/misc/host_armor_trim_smithing_template" | "hextweaks:grandspell/explode" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_boiler" | "create:recipes/building_blocks/cut_ochrum_from_stone_types_ochrum_stonecutting" | "iceandfire:recipes/building_blocks/silver_nugget_to_silver_ingot" | "iceandfire:recipes/tools/dragonsteel_lightning_hoe" | "iceandfire:recipes/combat/dragonarmor_copper_neck" | "ae2:main/recursive" | "sophisticatedbackpacks:recipes/misc/advanced_tool_swapper_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_slashed_locometal" | "minecraft:recipes/brewing/glistering_melon_slice" | "extendedae:recipes/misc/active_formation_plane" | "minecraft:recipes/misc/light_gray_dye_from_azure_bluet" | "ad_astra:recipes/misc/strophar_stairs" | "minecraft:recipes/building_blocks/cracked_nether_bricks" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_plated_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "iceandfire:iceandfire/kill_troll" | "tconstruct:recipes/misc/common/slime/ichor/crystal_smelting" | "minecraft:recipes/misc/wild_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/smooth_quartz" | "iceandfire:recipes/combat/iron_hippogryph_armor" | "ae2:recipes/misc/network/cables/dense_smart_black" | "farmersdelight:recipes/decorations/cherry_cabinet" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_slab_stonecutter" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_limestone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal_boiler" | "ad_astra:recipes/misc/desh_tank" | "create:recipes/building_blocks/small_scoria_brick_wall" | "create:recipes/building_blocks/crafting/kinetics/pink_seat" | "iceandfire:recipes/building_blocks/dragonscales_red_to_dragonscale_red" | "minecraft:recipes/decorations/blue_stained_glass_pane" | "create:recipes/building_blocks/mangrove_window_pane" | "biomesoplenty:recipes/building_blocks/redwood_slab" | "create:recipes/building_blocks/polished_cut_calcite_slab_from_stone_types_calcite_stonecutting" | "ad_astra:recipes/misc/raw_desh_block" | "biomesoplenty:recipes/redstone/empyreal_trapdoor" | "hexcasting:recipes/misc/pride_colorizer_asexual" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "ae2:recipes/misc/network/cables/covered_blue" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "ae2:recipes/misc/network/cells/view_cell" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_pillar" | "biomesoplenty:recipes/redstone/umbran_door" | "iceandfire:recipes/building_blocks/sea_serpent_scales_red_to_sea_serpent_scale_block_red" | "minecraft:recipes/decorations/polished_deepslate_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/food/cooked_salmon_from_smoking" | "railways:recipes/combat/dying_existing_cap_green" | "tconstruct:recipes/building_blocks/world/wood/skyroot/door" | "create:recipes/misc/crafting/logistics/factory_gauge" | "minecraft:recipes/tools/netherite_shovel_smithing" | "minecraft:recipes/brewing/glass_bottle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_brass_wrapped_locometal" | "create:mechanical_arm" | "tconstruct:world/tinkers_gadgetry" | "minecraft:recipes/decorations/acacia_hanging_sign" | "create:recipes/misc/crafting/logistics/factory_gauge_clear" | "ad_astra:recipes/misc/stonecutting/polished_mercury_stone_stairs_from_mercury_stone_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_carpet" | "create:recipes/misc/crafting/materials/brass_nugget_from_decompacting" | "create:recipes/misc/crafting/kinetics/item_drain" | "create:recipes/building_blocks/small_diorite_brick_stairs" | "create:recipes/building_blocks/rose_quartz_block_from_rose_quartz_stonecutting" | "hexcasting:recipes/tools/staff/birch" | "ae2:recipes/misc/network/cables/glass_orange" | "minecraft:recipes/decorations/red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "ad_astra:recipes/misc/smelting/ice_shard_from_smelting_glacio_ice_shard_ore" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_flat_slashed_locometal" | "minecraft:recipes/misc/lime_dye_from_smelting" | "tconstruct:recipes/misc/common/glass/light_blue_clear_stained_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_flat_slashed_locometal" | "create:recipes/building_blocks/cut_asurine_wall" | "minecraft:recipes/building_blocks/blackstone_slab_from_blackstone_stonecutting" | "tconstruct:recipes/misc/common/slime/sky/crystal_block" | "biomesoplenty:recipes/decorations/jacaranda_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_locometal_pillar" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_slab_from_honeycomb" | "agricraft:recipes/tools/journal" | "minecraft:recipes/redstone/cherry_fence_gate" | "ad_astra:recipes/misc/stonecutting/glacio_stone_slab_from_glacio_stone_stonecutting" | "ae2:recipes/misc/network/cables/covered_fluix" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs" | "create:recipes/misc/crafting/kinetics/mechanical_mixer" | "minecraft:recipes/building_blocks/chiseled_red_sandstone_from_red_sandstone_stonecutting" | "biomesoplenty:recipes/building_blocks/pine_wood" | "biomesoplenty:recipes/building_blocks/dead_stairs" | "ad_astra:recipes/misc/stonecutting/polished_moon_stone_slab_from_polished_moon_stone_stonecutting" | "hexcasting:recipes/building_blocks/slate_amethyst_bricks" | "iceandfire:recipes/combat/tide_trident" | "minecraft:recipes/building_blocks/jungle_planks" | "farmersdelight:recipes/decorations/stove" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/nickel_ingot_compat_alloygery" | "minecraft:recipes/building_blocks/chiseled_quartz_block" | "create:recipes/building_blocks/small_tuff_brick_slab" | "ae2:recipes/misc/network/cables/dense_smart_green" | "iceandfire:recipes/combat/frost_troll_leather_helmet" | "hexcasting:lore/inventory" | "tconstruct:recipes/building_blocks/common/materials/slimesteel_block_from_ingots" | "ad_astra:recipes/misc/stonecutting/venus_sandstone_brick_stairs_from_venus_sandstone_bricks_stonecutting" | "minecraft:recipes/redstone/bamboo_trapdoor" | "iceandfire:recipes/building_blocks/crackled_to_gravel" | "create:recipes/misc/crafting/kinetics/framed_glass_trapdoor" | "comforts:sleeping_bag_gray" | "railways:recipes/misc/stonecutting/palettes/cycling/locometal_pillar" | "ad_astra:recipes/misc/wheel" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_iron_wrapped_locometal_boiler" | "farmersdelight:recipes/decorations/oak_cabinet" | "ad_astra:recipes/misc/blasting/ice_shard_from_blasting_mars_ice_shard_ore" | "biomesoplenty:recipes/building_blocks/redwood_wood" | "farmersdelight:recipes/food/cooked_cod_slice" | "biomesoplenty:recipes/decorations/black_sandstone_wall" | "ad_astra:dj" | "iceandfire:recipes/building_blocks/dragonsteel_ice_ingot_to_dragonsteel_ice_block" | "ad_astra:recipes/misc/stonecutting/moon_pillar_from_moon_stone_stonecutting" | "create:recipes/building_blocks/polished_cut_deepslate_wall" | "create:recipes/building_blocks/crafting/kinetics/black_seat" | "create:recipes/building_blocks/cut_diorite_brick_slab" | "create:recipes/decorations/andesite_ladder_from_andesite_alloy_stonecutting" | "create:packager" | "farmersdelight:main/get_mushroom_colony" | "create:recipes/combat/crafting/appliances/netherite_diving_boots_from_netherite" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_smokebox" | "create:recipes/building_blocks/small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "ad_astra:recipes/misc/chiseled_permafrost_bricks" | "create:recipes/misc/crafting/logistics/redstone_contact" | "computercraft:recipes/redstone/computer_normal" | "ad_astra:recipes/compressing/compressing/ostrum_plate_from_compressing_ostrum_blocks" | "ad_astra:recipes/misc/ostrum_fluid_pipe" | "tconstruct:recipes/misc/smeltery/seared/seared_fancy_bricks_crafting" | "ae2:recipes/misc/tools/network_color_applicator" | "create:recipes/misc/crafting/kinetics/red_valve_handle_from_other_valve_handle" | "iceandfire:recipes/combat/armor_red_boots" | "minecraft:recipes/building_blocks/dye_light_blue_wool" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_copper_wrapped_locometal" | "minecraft:recipes/redstone/sticky_piston" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_smokebox" | "hexcasting:recipes/tools/abacus" | "biomesoplenty:recipes/transportation/hellbark_boat" | "railways:recipes/misc/stonecutting/palettes/cycling/white_flat_riveted_locometal" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade_from_smelting_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_riveted_locometal" | "ae2:recipes/misc/tools/fluix_pickaxe" | "biomesoplenty:recipes/building_blocks/white_sandstone_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_riveted_locometal" | "ad_astra:recipes/misc/stonecutting/polished_mercury_stone_slab_from_polished_mercury_stone_stonecutting" | "tconstruct:recipes/building_blocks/common/firewood/blazewood_stairs" | "ae2:recipes/misc/shaped/slabs/sky_stone_brick" | "minecraft:recipes/brewing/fermented_spider_eye" | "minecraft:recipes/misc/iron_ingot_from_smelting_raw_iron" | "biomesoplenty:recipes/building_blocks/maple_planks" | "ae2:recipes/misc/network/cables/smart_fluix_clean" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "iceandfire:recipes/combat/tide_teal_helmet" | "ad_astra:solar_panel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_smokebox" | "minecraft:recipes/misc/purple_dye" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_riveted_locometal" | "create:recipes/building_blocks/cut_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_waxed_copper_block_stonecutting" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "create:recipes/building_blocks/polished_cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/building_blocks/dried_kelp_block" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_brick_stonecutting" | "tconstruct:tools/tinker_tool" | "minecraft:recipes/building_blocks/quartz_bricks_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_calcite_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/cut_scorchia_slab_recycling" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_stairs_stonecutter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal" | "ad_astra:recipes/misc/blasting/ostrum_ingot_from_blasting_deepslate_ostrum_ore" | "biomesoplenty:recipes/decorations/orange_maple_leaf_pile" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_flat_slashed_locometal" | "create:recipes/misc/crafting/logistics/packager_from_conversion" | "tconstruct:tools/material_master" | "ad_astra:recipes/misc/gray_flag" | "ad_astra:recipes/misc/mars_pillar" | "classicpipes:recipes/bamboo_fluid_pipe_a" | "create:recipes/building_blocks/small_deepslate_brick_slab_recycling" | "biomesoplenty:recipes/transportation/jacaranda_boat" | "minecraft:recipes/building_blocks/waxed_oxidized_copper_from_honeycomb" | "iceandfire:recipes/combat/amphithere_arrow" | "tconstruct:recipes/building_blocks/world/wood/greenheart/stairs" | "extendedae:recipes/misc/tag_export_bus" | "hexcasting:recipes/misc/dye_colorizer_red" | "tconstruct:foundry/structure" | "farmersdelight:recipes/food/beef_patty_from_smoking" | "create:recipes/building_blocks/small_andesite_brick_slab" | "create:recipes/building_blocks/exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "farmersdelight:recipes/cooking/beef_stew" | "farmersdelight:recipes/food/cabbage" | "tconstruct:recipes/misc/common/glass/white_clear_stained_glass_pane_from_panes" | "create:recipes/building_blocks/crafting/logistics/black_table_cloth" | "hexcasting:recipes/misc/dye_colorizer_gray" | "minecraft:recipes/decorations/mangrove_fence" | "minecraft:recipes/building_blocks/dye_white_carpet" | "minecraft:recipes/building_blocks/white_terracotta" | "create:recipes/misc/crafting/kinetics/fluid_tank" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal" | "iceandfire:iceandfire/deathworm_egg" | "minecraft:recipes/food/cooked_mutton" | "railways:recipes/misc/crafting/palettes/wrapping/pink_iron_wrapped_locometal" | "minecraft:recipes/misc/white_dye_from_lily_of_the_valley" | "ae2:recipes/misc/network/cells/fluid_storage_cell_64k" | "create:recipes/misc/crafting/materials/andesite_alloy_from_zinc" | "minecraft:recipes/building_blocks/deepslate_tile_stairs" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "create:recipes/building_blocks/crafting/logistics/green_postbox_from_other_postbox" | "create:recipes/building_blocks/cut_granite_wall_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/calcite_from_stone_types_calcite_stonecutting" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_stairs_stonecutter" | "comforts:hammock_black" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_brass_wrapped_locometal" | "ae2:recipes/misc/misc/chests_smooth_sky_stone" | "ad_astra:recipes/nasa_workbench/nasa_workbench/tier_4_rocket_from_nasa_workbench" | "classicpipes:recipes/storage_pipe_a" | "hexpigmentplus:recipes/hay_hats" | "minecraft:recipes/building_blocks/dye_light_blue_bed" | "create:recipes/building_blocks/industrial_iron_window_pane" | "biomesoplenty:recipes/building_blocks/smooth_black_sandstone_slab_from_smooth_black_sandstone_stonecutting" | "minecraft:recipes/decorations/lime_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_flat_riveted_locometal" | "railways:recipes/misc/crafting/smokestack_diesel" | "minecraft:adventure/sniper_duel" | "farmersdelight:recipes/decorations/canvas_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_slashed_locometal" | "ad_astra:recipes/misc/venus_stone_slab" | "create:track_signal" | "minecraft:recipes/building_blocks/polished_andesite_stairs" | "minecraft:recipes/transportation/furnace_minecart" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_bricks_stonecutting" | "minecraft:nether/root" | "classicpipes:recipes/dark_oak_fluid_pipe_a" | "ae2:recipes/misc/shaped/slabs/quartz_bricks" | "minecraft:recipes/misc/spire_armor_trim_smithing_template" | "ad_astra:recipes/misc/stonecutting/mars_stone_brick_stairs_from_mars_stone_bricks_stonecutting" | "biomesoplenty:recipes/transportation/mahogany_boat" | "create:recipes/misc/crafting/kinetics/stressometer_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_flat_slashed_locometal" | "minecraft:recipes/building_blocks/stone_slab_from_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/gray_brass_wrapped_locometal" | "create:recipes/misc/crafting/kinetics/track_observer_from_other_plates" | "farmersdelight:recipes/misc/canvas_from_canvas_rug" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_boiler" | "tconstruct:recipes/misc/common/glass/orange_clear_stained_glass" | "create:musical_arm" | "iceandfire:recipes/misc/dragonscale_black_to_dragonscales_black" | "hexal:recipes/brainsweep/brainsweep/mediafied_storage" | "minecraft:recipes/tools/flint_and_steel" | "ad_astra:recipes/misc/calorite_plating_pressure_plate" | "minecraft:recipes/building_blocks/dye_purple_carpet" | "minecraft:recipes/building_blocks/nether_bricks" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_flat_slashed_locometal" | "create:recipes/building_blocks/andesite_pillar_from_stone_types_andesite_stonecutting" | "iceandfire:recipes/building_blocks/dread_stone" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_brick_stonecutting" | "tconstruct:recipes/misc/common/glass/orange_clear_stained_glass_pane" | "create:recipes/building_blocks/scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/sugar_from_sugar_cane" | "ae2:recipes/misc/network/cells/item_storage_components_cell_256k_part" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_flat_riveted_locometal" | "minecraft:recipes/building_blocks/dye_magenta_bed" | "create:recipes/decorations/brass_ladder_from_brass_ingots_stonecutting" | "arsenal:recipes/decorations/weapon_rack" | "minecraft:recipes/decorations/respawn_anchor" | "create:recipes/building_blocks/copycat_step_from_zinc_ingots_stonecutting" | "ad_astra:recipes/misc/mars_cobblestone_slab" | "iceandfire:recipes/tools/dragonsteel_lightning_sword" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_plated_locometal" | "create:recipes/building_blocks/cut_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "iceandfire:recipes/combat/forest_troll_leather_helmet" | "computercraft:recipes/redstone/turtle_advanced/minecraft/crafting_table" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_plated_locometal" | "ae2:recipes/misc/network/cables/glass_gray" | "biomesoplenty:recipes/redstone/pine_door" | "minecraft:recipes/decorations/white_banner" | "biomesoplenty:recipes/building_blocks/black_sandstone" | "biomesoplenty:recipes/building_blocks/jacaranda_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_smokebox" | "minecraft:recipes/decorations/mossy_cobblestone_wall" | "classicpipes:recipes/iron_pipe" | "ad_astra:recipes/misc/cheese_block" | "create:recipes/building_blocks/cut_veridium_slab_recycling" | "tconstruct:recipes/misc/smeltery/scorched/scorched_bricks_crafting" | "iceandfire:recipes/combat/armor_silver_metal_chestplate" | "minecraft:nether/get_wither_skull" | "biomesoplenty:recipes/redstone/redwood_pressure_plate" | "tconstruct:recipes/misc/common/fantastic_foundry" | "ad_astra:recipes/misc/steel_engine" | "tconstruct:recipes/misc/smeltery/seared/ingot_gauge" | "minecraft:recipes/building_blocks/dye_magenta_wool" | "railways:recipes/misc/crafting/palettes/wrapping/red_iron_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_scorchia_slab" | "minecraft:recipes/decorations/diorite_wall_from_diorite_stonecutting" | "farmersdelight:recipes/misc/straw" | "railways:recipes/misc/crafting/big_buffer" | "create:recipes/misc/crafting/kinetics/magenta_valve_handle_from_other_valve_handle" | "computercraft:recipes/redstone/disk_8" | "computercraft:recipes/redstone/disk_9" | "create:recipes/misc/crafting/kinetics/white_sail_from_conversion" | "computercraft:recipes/redstone/disk_6" | "computercraft:recipes/redstone/disk_7" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_stairs" | "tconstruct:foundry/encyclopedia" | "create:recipes/building_blocks/small_granite_brick_slab_from_stone_types_granite_stonecutting" | "computercraft:recipes/redstone/disk_1" | "minecraft:recipes/tools/wooden_pickaxe" | "tconstruct:tools/travelers_gear" | "computercraft:recipes/redstone/disk_4" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs" | "computercraft:recipes/redstone/disk_5" | "create:recipes/misc/crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "computercraft:recipes/redstone/disk_2" | "computercraft:recipes/redstone/disk_3" | "create:recipes/building_blocks/polished_cut_tuff_slab" | "lootr:10loot" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_flat_slashed_locometal" | "ad_astra:recipes/misc/light_gray_flag" | "create:recipes/building_blocks/cut_tuff_brick_slab" | "ad_astra:recipes/misc/large_gas_tank" | "minecraft:recipes/building_blocks/dark_oak_wood" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_flat_riveted_locometal" | "hexcasting:recipes/decorations/amethyst_sconce" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_omega_tier" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone" | "minecraft:recipes/misc/diamond_from_smelting_diamond_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_flat_riveted_locometal" | "ae2:recipes/misc/network/cables/glass_fluix_clean" | "tconstruct:recipes/misc/tables/tinkers_anvil" | "ad_astra:recipes/misc/etrionic_capacitor" | "create:recipes/building_blocks/cut_andesite_wall" | "farmersdelight:main/root" | "create:recipes/building_blocks/polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/combat/dying_existing_cap_white" | "farmersdelight:recipes/food/mixed_salad" | "ad_astra:recipes/oxygen_loading/oxygen_loading/oxygen_from_oxygen_loading_oxygen" | "tconstruct:recipes/misc/smeltery/seared/seared_glass_pane" | "minecraft:recipes/food/baked_potato_from_smoking" | "create:recipes/building_blocks/small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "tconstruct:recipes/misc/common/glass/magenta_clear_stained_glass_pane" | "create:recipes/building_blocks/cut_dripstone_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "iceandfire:recipes/building_blocks/sea_serpent_scales_teal_to_sea_serpent_scale_block_teal" | "ad_astra:recipes/misc/polished_permafrost_slab" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs" | "create:recipes/building_blocks/cut_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "biomesoplenty:recipes/building_blocks/willow_planks" | "create:recipes/misc/smelting/ingot_silver_compat_ic2" | "biomesoplenty:recipes/decorations/hellbark_fence" | "railways:recipes/misc/stonecutting/palettes/cycling/white_slashed_locometal" | "minecraft:recipes/decorations/black_stained_glass_pane_from_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/small_scoria_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_iron_wrapped_locometal" | "biomesoplenty:recipes/building_blocks/unmapped_end_stone" | "biomesoplenty:recipes/building_blocks/stripped_willow_wood" | "ae2:recipes/misc/tools/paintballs_pink" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_flat_slashed_locometal" | "minecraft:recipes/decorations/red_candle" | "minecraft:recipes/misc/lapis_lazuli" | "hexcasting:recipes/misc/pride_colorizer_demigirl" | "iceandfire:recipes/building_blocks/dread_stone_bricks_mossy" | "minecraft:story/upgrade_tools" | "farmersdelight:recipes/building_blocks/packed_mud_from_straw" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "ae2:recipes/misc/network/cells/fluid_storage_cell_64k_storage" | "farmersdelight:recipes/decorations/painting_from_canvas" | "create:recipes/building_blocks/cut_deepslate_brick_slab" | "ae2:recipes/misc/materials/cardspeed" | "create:recipes/building_blocks/cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/misc/eye_armor_trim_smithing_template" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_slashed_locometal" | "ad_astra:recipes/misc/ostrum_engine" | "extendedae:recipes/misc/ex_inscriber" | "create:recipes/misc/crafting/logistics/magenta_table_cloth_clear" | "create:recipes/misc/crafting/kinetics/crafter_slot_cover" | "ad_astra:recipes/misc/oxygen_distributor" | "farmersdelight:main/master_chef" | "create:diving_suit_lava" | "ae2:recipes/misc/network/cables/glass_red" | "biomesoplenty:recipes/decorations/hellbark_hanging_sign" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template_smithing_trim" | "farmersdelight:main/use_cutting_board" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal_boiler" | "create:arm_blaze_burner" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "create:cuckoo_clock" | "hexcasting:recipes/brainsweep/brainsweep/akashic_record" | "ae2:recipes/misc/block_cutter/walls/chiseled_quartz_wall" | "create:recipes/misc/smelting/silver_ingot_compat_thermal" | "farmersdelight:recipes/cooking/bone_broth" | "minecraft:husbandry/tactical_fishing" | "create:recipes/building_blocks/cut_granite_stairs_from_stone_types_granite_stonecutting" | "create:recipes/misc/crafting/logistics/powered_toggle_latch" | "biomesoplenty:recipes/transportation/palm_boat" | "create:recipes/building_blocks/polished_cut_andesite_wall_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_riveted_locometal" | "computercraft:recipes/redstone/printed_book" | "minecraft:adventure/salvage_sherd" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_slab_stonecutter" | "tconstruct:recipes/misc/smeltery/seared/seared_glass" | "ad_astra:recipes/misc/calorite_plating" | "ad_astra:recipes/misc/light_blue_flag" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_flat_slashed_locometal" | "biomesoplenty:recipes/building_blocks/dead_planks" | "ad_astra:recipes/misc/stonecutting/venus_stone_slab_from_venus_stone_stonecutting" | "computercraft:recipes/redstone/pocket_advanced/computercraft/wireless_modem_normal" | "biomesoplenty:recipes/transportation/empyreal_boat" | "iceandfire:recipes/combat/tide_red_chestplate" | "tconstruct:recipes/building_blocks/common/materials/amethyst_bronze_block_from_ingots" | "create:recipes/misc/smelting/platinum_ingot_compat_modern_industrialization" | "classicpipes:recipes/cherry_pipe" | "create:recipes/building_blocks/cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "comforts:hammock_cyan" | "ad_astra:recipes/misc/small_light_blue_industrial_lamp" | "minecraft:story/cure_zombie_villager" | "create:recipes/building_blocks/small_calcite_bricks_from_stone_types_calcite_stonecutting" | "tconstruct:recipes/misc/common/slime/ender/crystal_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_brass_wrapped_locometal" | "ad_astra:recipes/misc/stonecutting/mercury_stone_brick_stairs_from_mercury_stone_bricks_stonecutting" | "tconstruct:recipes/misc/common/glass/cyan_clear_stained_glass_pane" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_stairs_from_honeycomb" | "create:recipes/building_blocks/small_granite_bricks_from_stone_types_granite_stonecutting" | "ad_astra:recipes/misc/desh_plating_stairs" | "farmersdelight:recipes/misc/gold_nugget_from_blasting_knife" | "ad_astra:recipes/misc/energizer" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "ad_astra:recipes/misc/stonecutting/polished_permafrost_slab_from_polished_permafrost_stonecutting" | "minecraft:recipes/redstone/mangrove_trapdoor" | "minecraft:recipes/tools/recovery_compass" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs_from_oxidized_copper_shingles_stonecutting" | "classicpipes:recipes/advanced_copper_pipe_a" | "tconstruct:recipes/misc/smeltery/seared/seared_triangle_bricks_stonecutting" | "tconstruct:recipes/building_blocks/common/materials/rose_gold_nugget_from_ingot" | "sophisticatedbackpacks:recipes/misc/upgrade_base" | "minecraft:recipes/redstone/oak_pressure_plate" | "ad_astra:recipes/misc/stonecutting/mercury_pillar_from_mercury_stone_bricks_stonecutting" | "tconstruct:recipes/tools/tools/building/sky_staff" | "ae2:recipes/misc/network/cells/item_storage_cell_64k_storage" | "ae2:recipes/misc/network/cables/dense_covered_fluix_clean" | "ad_astra:recipes/misc/blasting/ostrum_ingot_from_blasting_mars_ostrum_ore" | "create:recipes/building_blocks/crafting/logistics/pink_table_cloth" | "ad_astra:recipes/misc/mercury_stone_bricks" | "create:recipes/building_blocks/small_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "ad_astra:recipes/cryo_freezing/cryo_freezing/cryo_fuel_from_cryo_freezing_ice" | "farmersdelight:recipes/decorations/bamboo_cabinet" | "tconstruct:recipes/building_blocks/common/materials/slimesteel_ingot_from_block" | "computercraft:recipes/redstone/pocket_computer_normal" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "create:recipes/misc/crafting/kinetics/schedule" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_plated_locometal" | "biomesoplenty:recipes/building_blocks/willow_stairs" | "hexcasting:lore/cardamom4" | "hexcasting:lore/cardamom3" | "minecraft:recipes/redstone/dropper" | "create:recipes/building_blocks/cut_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "iceandfire:recipes/building_blocks/dragonscales_amythest_to_dragonscale_amythest" | "hexcasting:lore/cardamom5" | "ae2:recipes/misc/block_cutter/walls/quartz_brick_wall" | "iceandfire:iceandfire/tame_hippocampus" | "create:drain" | "comforts:hammock_light_blue" | "ae2:recipes/misc/network/blocks/storage_drive" | "minecraft:end/find_end_city" | "create:recipes/building_blocks/oxidized_copper_tile_slab" | "hexcasting:lore/cardamom2" | "hexcasting:lore/cardamom1" | "ad_astra:recipes/misc/water_pump" | "minecraft:recipes/redstone/mangrove_fence_gate" | "create:recipes/misc/blasting/ingot_uranium_compat_mekanism" | "ad_astra:recipes/misc/calorite_sliding_door" | "create:recipes/building_blocks/polished_cut_scoria_slab_recycling" | "create:recipes/building_blocks/cut_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/mangrove_window" | "create:recipes/building_blocks/warped_window_pane" | "ad_astra:recipes/misc/stonecutting/polished_mercury_stone_slab_from_mercury_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_slashed_locometal" | "create:recipes/building_blocks/cut_veridium_brick_slab" | "biomesoplenty:recipes/building_blocks/redwood_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_veridium_wall" | "minecraft:recipes/building_blocks/dye_light_blue_carpet" | "ad_astra:recipes/misc/permafrost_tiles" | "tconstruct:recipes/misc/smeltery/scorched/ingot_gauge" | "minecraft:recipes/building_blocks/polished_andesite" | "ad_astra:recipes/cryo_freezing/cryo_freezing/cryo_fuel_from_cryo_freezing_blue_ice" | "hexcasting:aaa_wasteful_cast" | "tconstruct:recipes/misc/armor/building/plate_boots" | "minecraft:recipes/decorations/lime_glazed_terracotta" | "minecraft:recipes/building_blocks/purpur_block" | "ad_astra:recipes/misc/mars_stone_brick_slab" | "railways:recipes/misc/crafting/palettes/wrapping/green_iron_wrapped_locometal" | "create:recipes/building_blocks/small_andesite_brick_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_slashed_locometal" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_iron_wrapped_locometal" | "ae2:recipes/misc/materials/basiccard" | "classicpipes:recipes/iron_fluid_pipe_a" | "iceandfire:recipes/tools/dragonsteel_ice_axe" | "tconstruct:recipes/misc/smeltery/scorched/scorched_bricks_stonecutting" | "ae2:recipes/misc/tools/portable_item_cell_1k" | "create:recipes/misc/crafting/kinetics/cogwheel" | "create:recipes/building_blocks/cut_tuff_slab_from_stone_types_tuff_stonecutting" | "hexcasting:recipes/misc/pride_colorizer_genderqueer" | "computercraft:recipes/redstone/turtle_advanced_overlays/turtle_trans_overlay" | "tconstruct:recipes/building_blocks/common/materials/hepatizon_nugget_from_ingot" | "ae2:recipes/misc/shaped/stairs/quartz_bricks" | "biomesoplenty:recipes/misc/green_dye_from_tiny_cactus" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "tconstruct:recipes/misc/common/slime/earth/crystal_block" | "minecraft:recipes/transportation/carrot_on_a_stick" | "railways:recipes/misc/crafting/palettes/wrapping/purple_copper_wrapped_locometal" | "ad_astra:recipes/misc/moon_stone_brick_stairs" | "farmersdelight:recipes/misc/pumpkin_seeds_from_slice" | "create:recipes/misc/crafting/appliances/cardboard_boots" | "computercraft:recipes/redstone/turtle_normal/minecraft/diamond_axe" | "minecraft:recipes/building_blocks/polished_granite" | "farmersdelight:main/use_skillet" | "create:recipes/building_blocks/small_dripstone_brick_wall" | "ae2:recipes/misc/tools/portable_item_cell_4k" | "minecraft:recipes/redstone/birch_trapdoor" | "railways:recipes/misc/crafting/palettes/wrapping/red_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "farmersdelight:main/eat_nourishing_food" | "minecraft:recipes/redstone/spruce_trapdoor" | "extendedae:recipes/misc/ebus_upgrade" | "computercraft:recipes/redstone/pocket_computer_advanced_upgrade" | "minecraft:recipes/building_blocks/muddy_mangrove_roots" | "minecraft:recipes/building_blocks/red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/misc/quartz" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat_from_other_seat" | "biomesoplenty:recipes/building_blocks/pine_slab" | "iceandfire:recipes/tools/dragonsteel_lightning_pickaxe" | "biomesoplenty:recipes/building_blocks/brimstone_bricks_from_brimstone_stonecutting" | "create:recipes/building_blocks/polished_cut_asurine_from_stone_types_asurine_stonecutting" | "ae2:recipes/misc/shaped/slabs/fluix_block" | "iceandfire:recipes/tools/dragonsteel_fire_pickaxe" | "ad_astra:recipes/misc/steel_plating_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_plated_locometal" | "minecraft:end/respawn_dragon" | "hexcasting:recipes/building_blocks/stonecutting/slate_bricks" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "biomesoplenty:recipes/decorations/umbran_hanging_sign" | "minecraft:recipes/decorations/soul_campfire" | "sophisticatedbackpacks:recipes/misc/copper_backpack" | "biomesoplenty:recipes/building_blocks/smooth_black_sandstone_stairs" | "comforts:hammock_green" | "create:recipes/building_blocks/cherry_window" | "farmersdelight:recipes/decorations/yellow_hanging_canvas_sign" | "create:recipes/building_blocks/cut_deepslate_slab" | "tconstruct:recipes/building_blocks/common/firewood/lavawood_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal" | "biomesoplenty:recipes/building_blocks/dead_wood" | "ad_astra:recipes/misc/stonecutting/mercury_stone_stairs_from_mercury_stone_stonecutting" | "biomesoplenty:recipes/decorations/dead_hanging_sign" | "biomesoplenty:recipes/building_blocks/chiseled_brimstone_bricks" | "minecraft:recipes/building_blocks/warped_slab" | "minecraft:recipes/food/cooked_mutton_from_campfire_cooking" | "create:recipes/misc/smelting/ingot_uranium_compat_immersiveengineering" | "iceandfire:recipes/misc/dragonscale_copper_to_dragonscales_copper" | "create:recipes/building_blocks/polished_cut_dripstone_slab" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_road_slab_stonecutter" | "farmersdelight:recipes/decorations/light_gray_hanging_canvas_sign" | "ad_astra:recipes/misc/stonecutting/chiseled_mercury_stone_stairs_from_chiseled_mercury_stone_bricks_stonecutting" | "hexcasting:recipes/misc/dye_colorizer_green" | "farmersdelight:main/harvest_straw" | "computercraft:recipes/redstone/monitor_advanced" | "minecraft:recipes/redstone/spruce_door" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_pillar" | "minecraft:recipes/building_blocks/crimson_hyphae" | "minecraft:recipes/building_blocks/dye_orange_wool" | "ad_astra:recipes/misc/tier_1_rover" | "minecraft:recipes/building_blocks/yellow_concrete_powder" | "minecraft:recipes/redstone/spruce_fence_gate" | "iceandfire:recipes/building_blocks/dragonscales_silver_to_dragonscale_silver" | "ad_astra:recipes/misc/blasting/gold_ingot_from_blasting_venus_gold_ore" | "farmersdelight:recipes/decorations/scaffolding_from_canvas" | "ae2:recipes/misc/network/cables/dense_smart_magenta" | "farmersdelight:recipes/cooking/pasta_with_mutton_chop" | "biomesoplenty:recipes/building_blocks/smooth_white_sandstone_stairs" | "farmersdelight:recipes/decorations/purple_canvas_sign" | "create:recipes/building_blocks/crafting/logistics/lime_postbox_from_other_postbox" | "minecraft:recipes/building_blocks/purple_stained_glass" | "ad_astra:recipes/misc/polished_glacio_stone_stairs" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_stone_from_stonecutting" | "biomesoplenty:recipes/redstone/jacaranda_trapdoor" | "farmersdelight:recipes/decorations/white_canvas_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_slashed_locometal" | "ae2:recipes/misc/block_cutter/stairs/sky_stone_brick_stairs" | "hexcasting:recipes/building_blocks/slate_amethyst_tiles" | "create:recipes/misc/crafting/appliances/dough" | "create:recipes/building_blocks/weathered_copper_tile_stairs_from_weathered_copper_tiles_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat_from_other_seat" | "ae2:recipes/misc/network/cables/smart_green" | "farmersdelight:recipes/decorations/acacia_cabinet" | "create:recipes/building_blocks/cut_limestone_slab_recycling" | "minecraft:recipes/decorations/blue_carpet" | "minecraft:recipes/misc/snout_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_white_wool" | "biomesoplenty:recipes/building_blocks/empyreal_slab" | "iceandfire:recipes/tools/silver_hoe" | "minecraft:recipes/decorations/light_blue_glazed_terracotta" | "farmersdelight:recipes/decorations/pink_canvas_sign" | "ae2:recipes/misc/network/cables/covered_cyan" | "create:recipes/misc/blasting/gold_ingot_from_crushed" | "ae2:recipes/misc/network/cables/glass_white" | "create:recipes/building_blocks/polished_cut_diorite_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_flat_riveted_locometal" | "create:recipes/misc/crafting/kinetics/contraption_controls" | "create:recipes/building_blocks/polished_cut_asurine_slab_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "farmersdelight:recipes/decorations/rope_from_safety_net" | "minecraft:recipes/building_blocks/prismarine_stairs" | "create:recipes/misc/crafting/kinetics/flywheel" | "ad_astra:recipes/misc/permafrost_brick_slab" | "minecraft:recipes/building_blocks/polished_blackstone_from_blackstone_stonecutting" | "create:recipes/misc/crafting/kinetics/hose_pulley" | "create:recipes/building_blocks/vertical_framed_glass_from_colorless_glass_stonecutting" | "create:recipes/building_blocks/crafting/logistics/magenta_table_cloth_from_other_table_cloth" | "ad_astra:recipes/misc/smelting/ice_shard_from_smelting_deepslate_ice_shard_ore" | "create:recipes/misc/crafting/curiosities/brown_toolbox" | "minecraft:recipes/building_blocks/deepslate_tiles_from_polished_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal" | "comforts:hammock_lime" | "ad_astra:recipes/misc/stonecutting/glacio_pillar_from_glacio_stone_stonecutting" | "minecraft:recipes/decorations/polished_blackstone_wall_from_polished_blackstone_stonecutting" | "farmersdelight:recipes/decorations/yellow_canvas_sign" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/deepslate_tiles_from_deepslate_bricks_stonecutting" | "ad_astra:recipes/misc/brown_industrial_lamp" | "minecraft:recipes/building_blocks/dripstone_block" | "minecraft:recipes/building_blocks/mangrove_wood" | "ae2:recipes/misc/network/parts/panels_semi_dark_monitor" | "iceandfire:recipes/misc/dragonsteel_ice_block_to_dragonsteel_ice_ingot" | "create:recipes/building_blocks/small_ochrum_brick_wall" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_brass_wrapped_locometal" | "biomesoplenty:recipes/redstone/mahogany_trapdoor" | "minecraft:adventure/avoid_vibration" | "create:recipes/building_blocks/small_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "create:contraption_actors" | "minecraft:recipes/misc/gold_ingot_from_smelting_nether_gold_ore" | "create:recipes/building_blocks/polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "railways:recipes/combat/dying_existing_cap_blue" | "ad_astra:recipes/misc/space_helmet" | "create:recipes/building_blocks/crafting/kinetics/white_seat" | "farmersdelight:recipes/decorations/red_canvas_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_locometal_smokebox" | "ae2:recipes/misc/network/crafting/cpu_crafting_monitor" | "create:recipes/building_blocks/cut_calcite_brick_slab" | "minecraft:recipes/building_blocks/yellow_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/spire_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/decorations/acacia_fence" | "create:recipes/building_blocks/polished_cut_deepslate_from_stone_types_deepslate_stonecutting" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet" | "ad_astra:recipes/misc/aeronos_trapdoor" | "biomesoplenty:recipes/building_blocks/white_sandstone_stairs_from_white_sandstone_stonecutting" | "ad_astra:recipes/misc/aeronos_slab" | "iceandfire:recipes/combat/deathworm_yellow_leggings" | "create:recipes/building_blocks/rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "ad_astra:recipes/misc/small_yellow_industrial_lamp" | "minecraft:recipes/misc/iron_ingot_from_blasting_deepslate_iron_ore" | "minecraft:recipes/building_blocks/dye_brown_carpet" | "create:recipes/building_blocks/small_limestone_brick_slab_recycling" | "farmersdelight:recipes/decorations/red_hanging_canvas_sign" | "minecraft:recipes/redstone/mangrove_button" | "minecraft:nether/return_to_sender" | "farmersdelight:recipes/cooking/tomato_sauce" | "minecraft:recipes/building_blocks/sandstone" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_lightning_body" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingles_from_honeycomb" | "railways:recipes/combat/dying_existing_cap_orange" | "farmersdelight:recipes/cooking/ratatouille" | "tconstruct:recipes/misc/smeltery/seared/fuel_tank" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_plated_locometal" | "farmersdelight:recipes/misc/tomato_seeds" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_slashed_locometal" | "ae2:recipes/misc/network/cables/dense_smart_yellow" | "biomesoplenty:recipes/redstone/fir_trapdoor" | "create:recipes/building_blocks/cut_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "minecraft:recipes/building_blocks/polished_basalt_from_basalt_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab" | "ae2:recipes/misc/decorative/cut_quartz_block" | "computercraft:recipes/redstone/turtle_normal/computercraft/wireless_modem_normal" | "create:recipes/building_blocks/polished_cut_diorite_slab_recycling" | "ae2:recipes/misc/shaped/stairs/sky_stone_small_brick" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_plated_locometal" | "railways:recipes/combat/dying_existing_cap_lime" | "ae2:recipes/misc/block_cutter/stairs/quartz_stairs" | "ad_astra:recipes/misc/venus_pillar" | "create:recipes/building_blocks/polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "biomesoplenty:recipes/building_blocks/willow_slab" | "minecraft:recipes/building_blocks/white_wool_from_string" | "biomesoplenty:recipes/building_blocks/mahogany_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_flat_riveted_locometal" | "ad_astra:recipes/misc/smelting/desh_ingot_from_smelting_deepslate_desh_ore" | "minecraft:recipes/decorations/yellow_banner" | "minecraft:recipes/decorations/brown_stained_glass_pane_from_glass_pane" | "minecraft:husbandry/obtain_sniffer_egg" | "iceandfire:recipes/tools/silver_shovel" | "ad_astra:recipes/misc/strophar_fence" | "biomesoplenty:recipes/redstone/dead_door" | "tconstruct:recipes/building_blocks/common/materials/queens_slime_ingot_from_nuggets" | "ad_astra:recipes/misc/chiseled_mars_stone_bricks" | "iceandfire:recipes/tools/dragonbone_sword" | "ad_astra:recipes/misc/blasting/iron_ingot_from_blasting_moon_iron_ore" | "minecraft:recipes/building_blocks/deepslate_brick_slab" | "tconstruct:recipes/redstone/world/wood/skyroot/trapdoor" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_polished_diorite_stonecutting" | "minecraft:recipes/decorations/brick_wall_from_bricks_stonecutting" | "ae2:recipes/misc/block_cutter/walls/sky_stone_wall" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "ae2:recipes/misc/shaped/walls/fluix_block" | "ae2:recipes/misc/network/cells/item_storage_components_cell_4k_part" | "create:recipes/building_blocks/crafting/logistics/brown_table_cloth" | "create:recipes/building_blocks/cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "ad_astra:recipes/misc/black_flag" | "ae2:recipes/misc/materials/cardinverter" | "minecraft:recipes/redstone/polished_blackstone_pressure_plate" | "farmersdelight:recipes/building_blocks/organic_compost_from_rotten_flesh" | "create:recipes/building_blocks/small_deepslate_brick_wall" | "comforts:hammock_blue" | "farmersdelight:recipes/building_blocks/rice_bag" | "minecraft:recipes/food/cooked_cod_from_campfire_cooking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_flat_riveted_locometal" | "create:recipes/building_blocks/crafting/logistics/purple_table_cloth_from_other_table_cloth" | "tconstruct:recipes/misc/gadgets/fancy_frame/clear" | "ad_astra:recipes/compressing/compressing/desh_plate_from_compressing_desh_blocks" | "iceandfire:recipes/tools/dragonsteel_ice_hoe" | "create:recipes/building_blocks/cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/magenta_stained_glass_pane_from_glass_pane" | "ad_astra:recipes/misc/calorite_pillar" | "ae2:recipes/misc/materials/cardcapacity" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal" | "ad_astra:recipes/misc/stonecutting/venus_stone_brick_wall_from_venus_stone_bricks_stonecutting" | "minecraft:recipes/misc/pink_dye_from_red_white_dye" | "comforts:hammock_white" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_fire_tail" | "create:recipes/building_blocks/small_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "computercraft:recipes/redstone/disk_12" | "computercraft:recipes/redstone/disk_11" | "computercraft:recipes/redstone/disk_14" | "minecraft:recipes/brewing/blaze_powder" | "computercraft:recipes/redstone/disk_13" | "minecraft:recipes/redstone/jungle_pressure_plate" | "minecraft:end/root" | "ae2:recipes/misc/materials/cardenergy" | "iceandfire:recipes/combat/dragonarmor_dragonsteel_ice_neck" | "create:recipes/misc/crafting/kinetics/clockwork_bearing" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_slashed_locometal" | "computercraft:recipes/redstone/disk_10" | "iceandfire:recipes/building_blocks/graveyard_soil" | "biomesoplenty:recipes/building_blocks/white_sandstone" | "hexcasting:recipes/tools/spellbook" | "computercraft:recipes/redstone/disk_16" | "computercraft:recipes/redstone/disk_15" | "biomesoplenty:recipes/redstone/fir_pressure_plate" | "ad_astra:recipes/misc/desh_plating_slab" | "ad_astra:recipes/misc/permafrost_bricks" | "ad_astra:recipes/misc/stonecutting/polished_glacio_stone_stairs_from_glacio_stone_stonecutting" | "iceandfire:recipes/combat/tide_deepblue_boots" | "tconstruct:recipes/misc/tables/tinkers_forge" | "sophisticatedbackpacks:recipes/misc/chipped/loom_table_upgrade" | "minecraft:recipes/misc/diamond_from_blasting_diamond_ore" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "create:recipes/building_blocks/dripstone_pillar_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/moss_carpet" | "create:recipes/misc/blasting/ingot_nickel_compat_immersiveengineering" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_polished_diorite_stonecutting" | "farmersdelight:recipes/food/stuffed_potato" | "railways:recipes/misc/stonecutting/palettes/cycling/white_flat_slashed_locometal" | "minecraft:recipes/decorations/cyan_stained_glass_pane_from_glass_pane" | "minecraft:recipes/decorations/blackstone_wall_from_blackstone_stonecutting" | "farmersdelight:recipes/food/fruit_salad" | "farmersdelight:recipes/decorations/light_blue_hanging_canvas_sign" | "minecraft:recipes/redstone/crimson_fence_gate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper" | "create:recipes/building_blocks/cut_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "classicpipes:recipes/provider_pipe_a" | "ae2:recipes/misc/network/parts/formation_plane" | "create:copper_casing" | "extendedae:recipes/misc/ex_drive_upgrade" | "ae2:recipes/misc/network/cables/smart_yellow" | "create:recipes/building_blocks/crafting/logistics/pink_postbox" | "ad_astra:recipes/misc/smelting/iron_ingot_from_smelting_moon_iron_ore" | "tconstruct:recipes/misc/tools/building/flint_and_brick" | "minecraft:recipes/building_blocks/amethyst_block" | "create:recipes/misc/crafting/kinetics/vertical_gearbox" | "tconstruct:recipes/misc/smeltery/seared/ingot_tank" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_riveted_locometal" | "ad_astra:recipes/misc/calorite_plating_slab" | "ad_astra:recipes/misc/oxygen_sensor" | "hexcasting:recipes/misc/pride_colorizer_transgender" | "extendedae:recipes/misc/ebus_in" | "minecraft:husbandry/obtain_netherite_hoe" | "minecraft:recipes/building_blocks/gray_concrete_powder" | "minecraft:recipes/decorations/light_gray_banner" | "create:foods" | "iceandfire:recipes/combat/tide_green_boots" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_smokebox" | "iceandfire:recipes/combat/tide_green_chestplate" | "hexical:diy_conjuring" | "biomesoplenty:recipes/misc/white_dye_from_white_petals" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_flat_riveted_locometal" | "comforts:hammock_light_gray" | "iceandfire:recipes/combat/dragonbone_arrow" | "ad_astra:recipes/misc/launch_pad" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_pillar" | "biomesoplenty:recipes/building_blocks/willow_wood" | "minecraft:recipes/tools/iron_axe" | "create:recipes/misc/crafting/logistics/packager" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_flat_riveted_locometal" | "minecraft:recipes/building_blocks/glowstone" | "minecraft:recipes/building_blocks/sea_lantern" | "ae2:main/p2p" | "create:recipes/building_blocks/crafting/logistics/black_postbox" | "biomesoplenty:recipes/building_blocks/white_sandstone_slab_from_white_sandstone_stonecutting" | "create:recipes/misc/crafting/appliances/item_frame" | "ad_astra:recipes/misc/stonecutting/venus_sandstone_brick_slab_from_venus_sandstone_bricks_stonecutting" | "create:recipes/building_blocks/oak_window" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal_boiler" | "biomesoplenty:recipes/building_blocks/brimstone_bricks" | "create:recipes/misc/crafting/curiosities/peculiar_bell" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_brass_wrapped_locometal" | "create:recipes/misc/crafting/logistics/item_hatch" | "iceandfire:recipes/misc/sapphire_block_to_sapphire_gem" | "create:recipes/building_blocks/polished_cut_diorite_slab" | "minecraft:recipes/decorations/cartography_table" | "create:recipes/misc/blasting/zinc_ingot_from_crushed" | "create:recipes/building_blocks/small_limestone_brick_wall" | "create:recipes/misc/crafting/appliances/package_filter_clear" | "tconstruct:recipes/misc/tables/scorched_forge" | "tconstruct:recipes/misc/common/glass/black_clear_stained_glass_pane_from_panes" | "tconstruct:tools/upgrade_slots" | "artifacts:amateur_archaeologist" | "minecraft:recipes/building_blocks/deepslate_tile_slab" | "biomesoplenty:recipes/building_blocks/dead_slab" | "minecraft:recipes/building_blocks/polished_diorite_from_diorite_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_wall" | "farmersdelight:recipes/food/tomato" | "minecraft:recipes/building_blocks/chiseled_deepslate" | "iceandfire:recipes/combat/diamond_hippogryph_armor" | "tconstruct:recipes/building_blocks/common/materials/raw_cobalt_block_from_raws" | "ad_astra:recipes/misc/smelting/cracked_mercury_stone_bricks_from_smelting_mercury_stone_bricks" | "classicpipes:recipes/birch_pipe" | "ad_astra:recipes/misc/venus_sandstone" | "tconstruct:recipes/misc/smeltery/seared/seared_paver_smelting" | "minecraft:recipes/building_blocks/nether_brick_slab_from_nether_bricks_stonecutting" | "create:recipes/misc/crafting/kinetics/nixie_tube" | "minecraft:recipes/misc/iron_nugget_from_blasting" | "railways:recipes/misc/crafting/small_buffer" | "sophisticatedbackpacks:recipes/misc/restock_upgrade" | "hexcasting:recipes/building_blocks/slate_bricks_from_slate_bricks_small" | "farmersdelight:recipes/food/mutton_wrap" | "minecraft:adventure/kill_a_mob" | "biomesoplenty:recipes/building_blocks/cut_white_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_slashed_locometal" | "ad_astra:recipes/misc/stonecutting/polished_permafrost_stairs_from_polished_permafrost_stonecutting" | "create:pipe_organ" | "sophisticatedbackpacks:recipes/misc/gold_backpack" | "agricraft:recipes/tools/clipper" | "minecraft:husbandry/plant_any_sniffer_seed" | "ad_astra:recipes/misc/calorite_block" | "create:recipes/building_blocks/crafting/kinetics/brown_seat_from_other_seat" | "classicpipes:obtain_pipe" | "ad_astra:recipes/misc/stonecutting/polished_venus_stone_from_venus_stone_stonecutting" | "minecraft:recipes/building_blocks/deepslate_bricks_from_cobbled_deepslate_stonecutting" | "minecraft:adventure/adventuring_time" | "farmersdelight:recipes/food/cooked_cod_slice_from_campfire_cooking" | "minecraft:recipes/building_blocks/dye_cyan_carpet" | "biomesoplenty:recipes/redstone/hellbark_button" | "tconstruct:recipes/redstone/world/wood/bloodshroom/trapdoor" | "classicpipes:recipes/pipe_slicer" | "create:recipes/building_blocks/polished_cut_asurine_slab" | "create:recipes/building_blocks/polished_cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "tconstruct:recipes/building_blocks/common/materials/copper_ingot_from_nuggets" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal" | "tconstruct:recipes/building_blocks/smeltery/scorched/scorched_bricks_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_pillar" | "create:recipes/building_blocks/cut_dripstone_brick_slab" | "biomesoplenty:recipes/building_blocks/hellbark_wood" | "create:recipes/building_blocks/cut_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_riveted_locometal" | "minecraft:husbandry/plant_seed" | "minecraft:nether/find_bastion" | "biomesoplenty:recipes/building_blocks/palm_stairs" | "create:recipes/building_blocks/crafting/kinetics/lime_seat" | "railways:recipes/misc/crafting/palettes/wrapping/white_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_polished_andesite_stonecutting" | "ad_astra:recipes/misc/aeronos_planks" | "iceandfire:iceandfire/kill_ghost" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_flat_slashed_locometal" | "minecraft:recipes/decorations/flower_pot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal" | "minecraft:recipes/misc/raw_iron" | "ad_astra:recipes/misc/strophar_slab" | "create:recipes/building_blocks/cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "ae2:recipes/misc/network/cables/smart_black" | "create:recipes/building_blocks/cut_scoria_brick_slab" | "create:recipes/misc/smelting/silver_ingot_compat_galosphere" | "sophisticatedbackpacks:recipes/misc/tool_swapper_upgrade" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/layered_asurine_from_stone_types_asurine_stonecutting" | "biomesoplenty:recipes/building_blocks/brimstone_brick_slab_from_brimstone_bricks_stonecutting" | "ad_astra:recipes/misc/stonecutting/moon_stone_brick_wall_from_moon_stone_bricks_stonecutting" | "railways:recipes/combat/dying_existing_cap_black" | "minecraft:recipes/misc/stick_from_bamboo_item" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper" | "create:recipes/misc/crafting/logistics/stock_ticker" | "minecraft:recipes/redstone/bamboo_fence_gate" | "minecraft:recipes/decorations/sandstone_wall" | "lootr:100loot" | "farmersdelight:recipes/food/chicken_sandwich" | "create:recipes/misc/crafting/kinetics/purple_valve_handle_from_other_valve_handle" | "ae2:recipes/misc/shaped/slabs/sky_stone_block" | "create:recipes/misc/smelting/glass_from_vertical_framed_glass" | "biomesoplenty:recipes/transportation/mahogany_chest_boat" | "create:fan_processing" | "tconstruct:recipes/redstone/common/slime/sticky_piston" | "minecraft:recipes/decorations/andesite_wall" | "minecraft:recipes/building_blocks/andesite_slab" | "minecraft:recipes/misc/light_gray_dye_from_oxeye_daisy" | "iceandfire:recipes/combat/dragonbone_sword_fire" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal_boiler" | "create:water_supply" | "create:recipes/misc/crafting/kinetics/metal_bracket" | "ae2:recipes/misc/network/blocks/inscribers" | "ae2:recipes/misc/tools/paintballs_white" | "minecraft:recipes/misc/light_gray_dye_from_black_white_dye" | "ad_astra:recipes/misc/smelting/diamond_from_smelting_venus_diamond_ore" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_flat_riveted_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab_recycling" | "tconstruct:recipes/misc/common/slime/sky/congealed" | "minecraft:recipes/building_blocks/cobblestone_stairs_from_cobblestone_stonecutting" | "iceandfire:recipes/combat/armor_green_boots" | "comforts:sleeping_bag_lime" | "create:recipes/building_blocks/small_veridium_brick_wall" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade_from_auto_smelting_upgrade" | "create:recipes/building_blocks/layered_veridium_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal_boiler" | "minecraft:recipes/misc/wheat" | "ad_astra:recipes/misc/moon_stone_slab" | "create:recipes/misc/crafting/logistics/copper_table_cloth_clear" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_riveted_locometal" | "ad_astra:recipes/misc/stonecutting/venus_stone_brick_wall_from_venus_stone_stonecutting" | "create:recipes/building_blocks/polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/warped_window" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_smokebox" | "create:recipes/misc/crafting/kinetics/adjustable_chain_gearshift" | "minecraft:recipes/food/rabbit_stew_from_red_mushroom" | "minecraft:recipes/redstone/birch_pressure_plate" | "railways:recipes/misc/stonecutting/riveted_locometal" | "railways:recipes/transportation/jukeboxcart" | "minecraft:recipes/building_blocks/purpur_stairs_from_purpur_block_stonecutting" | "ad_astra:recipes/misc/strophar_planks" | "minecraft:recipes/tools/golden_hoe" | "minecraft:recipes/building_blocks/cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/diorite_slab_from_diorite_stonecutting" | "ad_astra:smart_blasting" | "create:recipes/misc/smelting/glass_from_horizontal_framed_glass" | "biomesoplenty:recipes/building_blocks/chiseled_black_sandstone" | "create:recipes/building_blocks/polished_cut_deepslate_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal_boiler" | "ae2:recipes/misc/network/crafting/cpu_crafting_accelerator" | "iceandfire:recipes/combat/dragonarmor_gold_body" | "minecraft:recipes/decorations/pink_carpet" | "create:portable_storage_interface" | "farmersdelight:recipes/decorations/purple_hanging_canvas_sign" | "comforts:hammock_yellow" | "create:conductor" | "biomesoplenty:recipes/redstone/empyreal_fence_gate" | "extendedae:recipes/misc/ex_charger" | "ad_astra:recipes/misc/compressor" | "ae2:main/root" | "biomesoplenty:recipes/building_blocks/mossy_black_sand" | "hexcasting:recipes/misc/pride_colorizer_genderfluid" | "farmersdelight:recipes/decorations/cutting_board" | "create:recipes/misc/blasting/ingot_lead_compat_mekanism" | "hexcasting:recipes/misc/pride_colorizer_demiboy" | "minecraft:recipes/building_blocks/cut_copper_slab_from_copper_block_stonecutting" | "ae2:recipes/misc/shaped/not_so_mysterious_cube" | "create:recipes/building_blocks/tiled_glass_from_colorless_glass_stonecutting" | "iceandfire:recipes/combat/armor_bronze_chestplate" | "iceandfire:recipes/building_blocks/dread_torch" | "biomesoplenty:recipes/building_blocks/stripped_jacaranda_wood" | "ad_astra:recipes/misc/mars_stone_slab" | "minecraft:recipes/food/mushroom_stew" | "tconstruct:recipes/food/gadgets/cake/ender" | "create:factory_gauge" | "iceandfire:recipes/combat/armor_amythest_chestplate" | "ae2:recipes/misc/network/blocks/io_port" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab" | "ad_astra:recipes/misc/mercury_stone_stairs" | "create:recipes/misc/blasting/zinc_ingot_from_ore" | "ae2:recipes/misc/network/parts/level_emitter" | "ad_astra:recipes/misc/stonecutting/moon_pillar_from_moon_stone_bricks_stonecutting" | "minecraft:husbandry/balanced_diet" | "create:recipes/building_blocks/cut_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/gray_terracotta" | "iceandfire:iceandfire/gorgon_head" | "tconstruct:recipes/misc/armor/building/travelers_pants" | "farmersdelight:recipes/building_blocks/cabbage_crate" | "minecraft:recipes/food/cooked_cod" | "minecraft:recipes/tools/netherite_pickaxe_smithing" | "ae2:recipes/misc/network/parts/toggle_bus_alt" | "minecraft:nether/fast_travel" | "minecraft:recipes/building_blocks/bamboo_stairs" | "ae2:recipes/misc/network/cables/dense_covered_light_blue" | "minecraft:recipes/building_blocks/dye_yellow_bed" | "farmersdelight:recipes/food/bacon_and_eggs" | "biomesoplenty:recipes/decorations/magic_fence" | "create:recipes/misc/crafting/materials/zinc_nugget_from_decompacting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade_from_auto_smelting_upgrade" | "minecraft:recipes/building_blocks/bamboo_block" | "create:recipes/building_blocks/copper_shingle_slab_from_copper_shingles_stonecutting" | "create:precision_mechanism" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/deepslate_tiles_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_wool" | "ae2:recipes/misc/network/crafting/cpu_crafting_unit" | "create:recipes/misc/smelting/tin_ingot_compat_mythicmetals" | "ad_astra:recipes/misc/stonecutting/chiseled_mercury_stone_bricks_from_mercury_stone_stonecutting" | "create:recipes/misc/crafting/logistics/stock_link_clear" | "tconstruct:recipes/building_blocks/common/materials/amethyst_bronze_ingot_from_nuggets" | "iceandfire:recipes/combat/tide_purple_boots" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_flat_riveted_locometal" | "minecraft:recipes/decorations/mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "minecraft:recipes/redstone/tnt" | "minecraft:recipes/decorations/black_stained_glass_pane" | "create:recipes/building_blocks/cut_tuff_bricks_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_slab_from_honeycomb" | "create:recipes/building_blocks/crafting/logistics/red_postbox" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "classicpipes:recipes/recipe_pipe_a" | "ad_astra:recipes/misc/stonecutting/polished_venus_stone_stairs_from_venus_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_plated_locometal" | "biomesoplenty:recipes/redstone/dead_trapdoor" | "create:recipes/building_blocks/small_scoria_bricks_from_stone_types_scoria_stonecutting" | "comforts:sleeping_bag_blue" | "agricraft:recipes/misc/emerald" | "minecraft:recipes/building_blocks/dye_gray_bed" | "farmersdelight:recipes/building_blocks/pumpkin_from_slices" | "ae2:recipes/misc/shaped/stairs/smooth_sky_stone_block" | "create:recipes/building_blocks/small_limestone_brick_stairs" | "ad_astra:recipes/misc/photovoltaic_etrium_cell" | "ad_astra:recipes/misc/glacian_fence" | "hexcasting:recipes/building_blocks/slate_amethyst_pillar" | "ad_astra:recipes/misc/encased_calorite_block" | "minecraft:recipes/decorations/enchanting_table" | "biomesoplenty:recipes/building_blocks/empyreal_wood" | "iceandfire:recipes/combat/armor_copper_metal_chestplate" | "iceandfire:recipes/tools/copper_pickaxe" | "iceandfire:recipes/combat/sea_serpent_arrow" | "iceandfire:recipes/misc/dragon_horn" | "create:recipes/misc/blasting/lead_ingot_compat_oreganized" | "create:recipes/misc/crafting/materials/rose_quartz" | "hexcasting:recipes/building_blocks/edified_panel" | "create:train_casing_00" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "iceandfire:recipes/tools/dragonsteel_ice_pickaxe" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "tconstruct:recipes/combat/common/glass/vanilla/end_crystal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal_boiler" | "ad_astra:recipes/misc/steel_sliding_door" | "minecraft:recipes/tools/stone_hoe" | "iceandfire:recipes/building_blocks/sea_serpent_scales_green_to_sea_serpent_scale_block_green" | "minecraft:recipes/food/dried_kelp" | "extendedae:recipes/misc/ei_part" | "biomesoplenty:recipes/building_blocks/chiseled_black_sandstone_from_black_sandstone_stonecutting" | "minecraft:nether/use_lodestone" | "create:recipes/building_blocks/cut_calcite_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal" | "classicpipes:recipes/spruce_fluid_pipe_a" | "minecraft:recipes/decorations/jungle_hanging_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_flat_riveted_locometal" | "minecraft:recipes/building_blocks/spruce_stairs" | "create:recipes/misc/blasting/silver_ingot_compat_iceandfire" | "sophisticatedbackpacks:recipes/misc/tank_upgrade" | "minecraft:recipes/building_blocks/mangrove_slab" | "hexcasting:recipes/decorations/slate" | "sophisticatedbackpacks:recipes/misc/crafting_upgrade" | "iceandfire:recipes/misc/dragon_stick" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_plated_locometal" | "ad_astra:recipes/misc/polished_moon_stone_stairs" | "tconstruct:smeltery/sand_casting" | "tconstruct:recipes/misc/tables/tinker_station" | "create:recipes/misc/blasting/silver_ingot_compat_mythicmetals" | "ad_astra:recipes/misc/polished_permafrost" | "minecraft:recipes/building_blocks/red_sandstone_stairs_from_red_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_copper_wrapped_locometal" | "ae2:recipes/misc/shaped/walls/cut_quartz_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_flat_slashed_locometal" | "tconstruct:recipes/misc/common/flint" | "create:recipes/building_blocks/layered_deepslate_from_stone_types_deepslate_stonecutting" | "iceandfire:recipes/combat/armor_bronze_helmet" | "minecraft:recipes/decorations/anvil" | "minecraft:recipes/decorations/black_candle" | "ae2:recipes/misc/tools/paintballs_lumen_red" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_riveted_locometal" | "create:recipes/building_blocks/small_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/item_vault" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_honeycomb" | "iceandfire:recipes/combat/tide_bronze_boots" | "create:recipes/misc/crafting/materials/raw_zinc_block" | "create:recipes/building_blocks/exposed_copper_shingle_stairs" | "hexcasting:recipes/building_blocks/slate_bricks_small_from_slate_bricks" | "create:recipes/building_blocks/crafting/kinetics/gray_seat_from_other_seat" | "tconstruct:smeltery/mighty_smelting" | "create:cardboard_armor" | "iceandfire:recipes/combat/dragonbone_sword_ice" | "ad_astra:recipes/misc/venus_stone_brick_wall" | "minecraft:recipes/decorations/mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_smokebox" | "biomesoplenty:recipes/food/rabbit_stew_from_toadstool" | "tconstruct:recipes/misc/tables/cast_chest" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_slashed_locometal" | "ad_astra:recipes/misc/stonecutting/chiseled_glacio_stone_bricks_from_glacio_stone_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_locometal_smokebox" | "farmersdelight:recipes/building_blocks/onion_crate" | "ad_astra:recipes/misc/chiseled_glacio_stone_stairs" | "minecraft:recipes/decorations/loom" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "create:recipes/building_blocks/exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "ae2:recipes/misc/materials/cardfuzzy" | "tconstruct:recipes/misc/smeltery/seared/seared_bricks_crafting" | "minecraft:recipes/tools/diamond_axe" | "minecraft:recipes/building_blocks/end_stone_bricks_from_end_stone_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_stonecutting" | "create:recipes/misc/crafting/appliances/filter_clear" | "tconstruct:tools/tinker_station" | "minecraft:recipes/misc/emerald_from_blasting_deepslate_emerald_ore" | "ad_astra:recipes/misc/raw_desh" | "minecraft:recipes/decorations/scaffolding" | "farmersdelight:recipes/cooking/vegetable_soup" | "iceandfire:recipes/combat/armor_copper_leggings" | "ae2:recipes/misc/tools/paintballs_lumen_light_blue" | "biomesoplenty:recipes/building_blocks/flesh" | "create:recipes/building_blocks/polished_cut_calcite_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_boiler" | "ad_astra:recipes/misc/rocket_nose_cone" | "classicpipes:recipes/oak_fluid_pipe_a" | "biomesoplenty:recipes/misc/gray_dye_from_wilted_lily" | "ad_astra:recipes/misc/stonecutting/moon_stone_slab_from_moon_stone_stonecutting" | "tconstruct:recipes/building_blocks/common/firewood/blazewood_slab" | "biomesoplenty:recipes/building_blocks/algal_end_stone" | "create:table_cloth_shop" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper" | "tconstruct:recipes/misc/tables/modifier_worktable" | "minecraft:recipes/building_blocks/diorite_stairs" | "minecraft:recipes/building_blocks/green_terracotta" | "comforts:sleeping_bag_yellow" | "create:recipes/building_blocks/crafting/logistics/lime_table_cloth_from_other_table_cloth" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal" | "create:recipes/building_blocks/cut_granite_stairs" | "create:recipes/building_blocks/small_granite_brick_slab" | "ae2:recipes/misc/network/cells/fluid_storage_cell_16k_storage" | "create:recipes/building_blocks/small_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "create:recipes/misc/crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "minecraft:recipes/misc/raw_copper" | "ad_astra:recipes/misc/stonecutting/chiseled_venus_stone_stairs_from_chiseled_venus_stone_bricks_stonecutting" | "ae2:main/controller" | "iceandfire:recipes/combat/tide_red_helmet" | "create:recipes/building_blocks/copper_shingle_stairs_from_copper_shingles_stonecutting" | "create:recipes/building_blocks/small_crimsite_brick_slab" | "create:recipes/misc/crafting/kinetics/gearshift" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_moss_block" | "ad_astra:recipes/misc/stonecutting/chiseled_mercury_stone_bricks_from_mercury_stone_bricks_stonecutting" | "paucal:be_patron" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_smokebox" | "hexcasting:recipes/building_blocks/scroll_paper" | "ad_astra:recipes/misc/ostrum_pillar" | "minecraft:recipes/misc/skull_banner_pattern" | "iceandfire:recipes/misc/copper_ingot_to_nuggets" | "minecraft:story/root" | "biomesoplenty:recipes/redstone/palm_pressure_plate" | "minecraft:recipes/building_blocks/dye_black_wool" | "ae2:recipes/misc/tools/paintballs_lumen_cyan" | "tconstruct:recipes/misc/common/slime/earth/slimeball_from_congealed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_limestone_brick_slab" | "minecraft:recipes/brewing/brewing_stand" | "minecraft:recipes/root" | "hexcasting:recipes/building_blocks/stonecutting/amethyst_bricks" | "farmersdelight:recipes/food/sweet_berry_cheesecake" | "computercraft:recipes/redstone/turtle_advanced/computercraft/speaker" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat" | "railways:recipes/transportation/conductor_vent_from_industrial_iron_block_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal_boiler" | "ad_astra:recipes/misc/stonecutting/polished_moon_stone_from_moon_stone_bricks_stonecutting" | "minecraft:recipes/misc/quartz_from_blasting" | "minecraft:recipes/building_blocks/acacia_planks" | "biomesoplenty:recipes/building_blocks/smooth_orange_sandstone_slab" | "ae2:recipes/misc/misc/chests_sky_stone" | "biomesoplenty:recipes/misc/purple_dye_from_lavender" | "iceandfire:recipes/combat/tide_green_helmet" | "ad_astra:recipes/misc/raw_calorite" | "create:recipes/misc/crafting/appliances/slime_ball" | "ad_astra:recipes/misc/fluid_pipe_duct" | "ae2:recipes/misc/shaped/slabs/quartz_pillar" | "iceandfire:recipes/misc/silver_block_to_silver_ingot" | "ad_astra:recipes/misc/stonecutting/mercury_stone_brick_wall_from_mercury_stone_stonecutting" | "biomesoplenty:recipes/misc/light_blue_dye_from_blue_hydrangea" | "iceandfire:recipes/combat/armor_silver_metal_leggings" | "ad_astra:recipes/misc/desh_nugget" | "minecraft:recipes/redstone/iron_door" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_honeycomb" | "ad_astra:recipes/misc/stonecutting/venus_stone_bricks_from_venus_stone_stonecutting" | "farmersdelight:recipes/food/honey_glazed_ham_block" | "minecraft:recipes/misc/copper_ingot_from_smelting_raw_copper" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_boiler" | "create:recipes/building_blocks/cut_tuff_wall_from_stone_types_tuff_stonecutting" | "hexcasting:recipes/building_blocks/quenched_allay_bricks_small_from_quenched_allay_bricks" | "tconstruct:recipes/building_blocks/smeltery/seared/seared_paver_stairs_stonecutter" | "minecraft:recipes/building_blocks/snow_block" | "iceandfire:recipes/combat/deathworm_yellow_chestplate" | "hexcasting:recipes/tools/jeweler_hammer" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_slashed_locometal" | "minecraft:recipes/building_blocks/blackstone_stairs_from_blackstone_stonecutting" | "iceandfire:recipes/combat/armor_black_helmet" | "create:recipes/building_blocks/crafting/logistics/light_gray_postbox" | "ad_astra:recipes/misc/engine_frame" | "create:recipes/building_blocks/cut_asurine_slab_recycling" | "minecraft:recipes/decorations/polished_blackstone_wall" | "hexcasting:recipes/misc/dye_colorizer_black" | "create:recipes/building_blocks/cut_asurine_stairs" | "minecraft:recipes/transportation/dark_oak_boat" | "create:recipes/building_blocks/cut_asurine_brick_wall" | "minecraft:recipes/decorations/honeycomb_block" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs" | "ad_astra:recipes/misc/smelting/ice_shard_from_smelting_moon_ice_shard_ore" | "tconstruct:recipes/misc/common/glass/red_clear_stained_glass_pane" | "minecraft:recipes/misc/mojang_banner_pattern" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "minecraft:recipes/combat/golden_leggings" | "minecraft:recipes/redstone/piston" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_lapis_ore" | "ad_astra:recipes/misc/stonecutting/mars_stone_slab_from_mars_stone_stonecutting" | "gravestones:recipes/decorations/gravestone" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal" | "ad_astra:recipes/misc/chiseled_mars_stone_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_flat_slashed_locometal" | "ad_astra:recipes/misc/steel_plating_stairs" | "sophisticatedbackpacks:recipes/misc/advanced_pickup_upgrade" | "minecraft:recipes/food/cooked_beef_from_campfire_cooking" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_flat_slashed_locometal" | "hexcasting:y_u_no_cast_angy" | "ae2:recipes/misc/network/cells/item_storage_cell_16k_storage" | "sophisticatedbackpacks:recipes/misc/iron_backpack" | "farmersdelight:recipes/food/fried_egg" | "ad_astra:recipes/misc/smelting/ostrum_ingot_from_smelting_raw_ostrum" | "ad_astra:ad_astra" | "iceandfire:recipes/combat/frost_troll_leather_leggings" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal" | "create:cardboard_armor_trim" | "tconstruct:recipes/building_blocks/world/wood/skyroot/stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_flat_slashed_locometal" | "iceandfire:recipes/combat/dragonsteel_fire_chestplate" | "ad_astra:recipes/misc/ostrum_panel" | "ae2:recipes/misc/tools/paintballs_green" | "tconstruct:recipes/misc/common/slime/sky/slimeball_from_congealed" | "ad_astra:recipes/misc/smelting/ostrum_ingot_from_smelting_mars_ostrum_ore" | "create:recipes/building_blocks/vertical_framed_glass_pane" | "ad_astra:mars" | "ad_astra:recipes/misc/cable_duct" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_flat_riveted_locometal" | "biomesoplenty:recipes/decorations/blackstone_spines_from_blackstone_stonecutting" | "minecraft:recipes/decorations/light_gray_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_scorchia_slab_recycling";
    type RecipeId = "tconstruct:tools/modifiers/salvage/upgrade/fireprimer" | "farmersdelight:cutting/brown_mushroom_colony" | "tconstruct:tools/parts/casting/bow_grip_composite" | "comforts:hammock_to_cyan" | "create:crafting/logistics/pink_table_cloth_clear" | "create:polished_cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "railways:sequenced_assembly/track_biomesoplenty_umbran_wide" | "create:crushing/venus_calorite_ore" | "create:crafting/logistics/black_postbox_from_other_postbox" | "create:milling/charcoal" | "tconstruct:smeltery/casting/amethyst/glass" | "biomesoplenty:fir_boat" | "biomesoplenty:jacaranda_fence_gate" | "powah:crafting/energized_steel_block" | "biomesoplenty:brimstone_brick_slab_from_brimstone_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/soulsteel/nugget_gold_cast" | "minecraft:stonecutter" | "minecraft:bone_block" | "railways:crafting/palettes/dyeing_8x/yellow_locometal_pillar" | "tconstruct:smeltery/casting/metal/iron/ingot_gold_cast" | "ae2:inscriber/certus_quartz_dust" | "minecraft:melon" | "create:cut_andesite_slab" | "create:cutting/runtime_generated/compat/minecraft/jungle_log_to_stripped_jungle_log" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_sign" | "create:cut_granite_wall" | "tconstruct:tools/modifiers/worktable/enchantment_converting/defense_book" | "ad_astra:cyan_industrial_lamp" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "ae2:network/cells/item_storage_cell_256k_storage" | "create:smelting/glass_from_vertical_framed_glass" | "ad_astra:stonecutting/venus_sandstone_brick_slab_from_venus_sandstone_bricks_stonecutting" | "tconstruct:common/glass/pink_clear_stained_glass_pane" | "biomesoplenty:flesh" | "ad_astra:space_station/venus_orbit_space_station" | "minecraft:gold_nugget_from_blasting" | "create:oak_window" | "farmersdelight:cutting/bamboo_trapdoor" | "create:cut_diorite_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:void_upgrade" | "powah:crafting/ender_gate_basic_2" | "create:crushing/copper_ore" | "minecraft:cobblestone_wall" | "railways:crafting/palettes/dyeing_8x/light_gray_slashed_locometal" | "railways:sequenced_assembly/track_dark_oak_narrow" | "farmersdelight:cutting/ink_sac" | "minecraft:lime_stained_glass_pane" | "tconstruct:smeltery/melting/metal/rose_gold/block" | "tconstruct:tools/materials/electrum/nugget" | "hextended:long/extended_birch" | "create:deploying/waxed_exposed_copper_tile_stairs_from_adding_wax" | "minecraft:raw_copper" | "iceandfire:stonecutter/dread_stone_tile" | "railways:crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "create:cut_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "tconstruct:smeltery/melting/metal/netherite/block" | "farmersdelight:cutting/acacia_sign" | "tconstruct:tools/severing/wither_skeleton_skull" | "create:cut_scorchia_slab_recycling" | "farmersdelight:cooked_chicken_cuts_from_smoking" | "hexcasting:pride_colorizer_transgender" | "farmersdelight:sweet_berry_cheesecake" | "minecraft:map_extending" | "tconstruct:smeltery/scorched/scorched_bricks_crafting" | "minecraft:spruce_sign" | "tconstruct:tools/modifiers/salvage/upgrade/step_up" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "create:crafting/kinetics/encased_chain_drive_from_zinc" | "create:crafting/logistics/brass_tunnel" | "create:deploying/copper_shingles_from_removing_wax" | "sophisticatedbackpacks:advanced_refill_upgrade" | "minecraft:glow_item_frame" | "create:crafting/logistics/factory_gauge" | "create:crafting/materials/sand_paper" | "create:deploying/cut_copper_slab_from_deoxidising" | "minecraft:chiseled_nether_bricks" | "railways:sequenced_assembly/track_bamboo_narrow" | "tconstruct:world/wood/bloodshroom/fence" | "minecraft:copper_block" | "biomesoplenty:palm_fence" | "tconstruct:smeltery/casting/seared/bricks/stairs" | "tconstruct:tools/modifiers/upgrade/quick_charge_from_dust" | "classicpipes:copper_fluid_pipe_a" | "iceandfire:sea_serpent_scale_block_purple_to_sea_serpent_scales_purple" | "classicpipes:copper_fluid_pipe_b" | "railways:sequenced_assembly/track_crimson_narrow" | "tconstruct:armor/building/travelers_shield" | "tconstruct:smeltery/entity_melting/heads/zombie" | "hexcasting:amethyst_pillar" | "minecraft:green_stained_glass" | "tconstruct:smeltery/casting/metal/manyullyn/ingot_gold_cast" | "create:small_veridium_brick_slab_recycling" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "tconstruct:tools/building/pickaxe" | "farmersdelight:integration/create/milling/wild_beetroots" | "tconstruct:tools/modifiers/salvage/upgrade/sinistral" | "create:cutting/runtime_generated/compat/ad_astra/strophar_planks_to_strophar_door" | "tconstruct:common/materials/manyullyn_block_from_ingots" | "railways:stonecutting/palettes/cycling/white_plated_locometal" | "tconstruct:smeltery/casting/metal/iron/rod_sand_cast" | "tconstruct:armor/building/slimeshell" | "tconstruct:smeltery/casting/water/white_concrete" | "biomesoplenty:mossy_black_sand" | "classicpipes:pipe_slicer" | "hextended:prismarine_staff" | "tconstruct:smeltery/casting/metal/slimesteel/block" | "create:cutting/runtime_generated/compat/minecraft/crimson_hyphae_to_stripped_crimson_hyphae" | "ad_astra:desh_plating_button" | "ae2:network/cables/dense_smart_light_blue" | "minecraft:cut_sandstone_slab" | "railways:crafting/palettes/dyeing_1x/gray_locometal_pillar" | "iceandfire:armor_copper_chestplate" | "minecraft:cherry_door" | "railways:mechanical_crafting/green_locometal_boiler" | "tconstruct:common/materials/pig_iron_ingot_from_block" | "ad_astra:venus_sandstone_bricks" | "create:cutting/runtime_generated/compat/ad_astra/strophar_planks_to_strophar_fence_gate" | "iceandfire:summoning_crystal_fire" | "createaddition:charging/exposed_cut_copper" | "create:milling/compat/biomesoplenty/tall_white_lavender" | "tconstruct:smeltery/casts/sand_casts/ingots" | "railways:crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal" | "minecraft:acacia_door" | "minecraft:mangrove_wood" | "tconstruct:tools/modifiers/salvage/ability/bucketing" | "powah:crafting/ender_gate_spirited_2" | "classicpipes:birch_pipe" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_planks_to_magic_door" | "minecraft:cyan_concrete_powder" | "create:deploying/copper_tile_stairs_from_deoxidising" | "minecraft:mojang_banner_pattern" | "minecraft:dye_pink_wool" | "minecraft:fire_charge" | "minecraft:golden_hoe" | "create:industrial_iron_window_pane" | "ae2:tools/misctools_charged_staff" | "tconstruct:armor/repair/slime_boots_repair_kit" | "ad_astra:aeronos_fence" | "hexcasting:brainsweep/akashic_record" | "minecraft:dye_green_bed" | "ad_astra:gray_industrial_lamp" | "hexcasting:dye_colorizer_orange" | "computercraft:printer" | "createaddition:rolling/electrum_ingot" | "farmersdelight:rice_roll_medley_block" | "create:copycat_step_from_zinc_ingots_stonecutting" | "create:crafting/kinetics/cyan_seat_from_other_seat" | "tconstruct:smeltery/seared/seared_ladder" | "ad_astra:calorite_plating_button" | "create:deploying/exposed_copper_shingle_stairs_from_deoxidising" | "minecraft:stone_button" | "biomesoplenty:hellbark_wood" | "iceandfire:armor_bronze_boots" | "railways:crafting/palettes/dyeing_1x/black_iron_wrapped_locometal" | "iceandfire:dreadwood_planks" | "artifacts:eternal_steak_furnace" | "railways:sequenced_assembly/track_biomesoplenty_redwood_narrow" | "ae2:network/wireless_terminal" | "minecraft:sandstone" | "railways:crafting/palettes/dyeing_1x/lime_locometal_smokebox" | "create:polished_cut_scoria_slab" | "tconstruct:tools/modifiers/salvage/ability/snowdrift" | "railways:sequenced_assembly/track_biomesoplenty_jacaranda" | "create:copper_ladder_from_copper_ingots_stonecutting" | "create:crushing/glacio_ice_shard_ore" | "minecraft:purpur_block" | "tconstruct:armor/building/slime_skull/pig_iron" | "farmersdelight:cutting/smoked_ham" | "ad_astra:stonecutting/mercury_stone_brick_wall_from_mercury_stone_bricks_stonecutting" | "railways:crafting/palettes/wrapping/iron_wrapped_locometal" | "minecraft:polished_blackstone_slab" | "railways:mechanical_crafting/red_copper_wrapped_locometal_boiler" | "simplylight:illuminant_light_blue_block_toggle" | "railways:crafting/remote_lens" | "farmersdelight:blue_canvas_sign" | "tconstruct:smeltery/casting/metal/copper/nugget_sand_cast" | "ae2:network/cells/spatial_storage_cell_128_cubed_storage" | "tconstruct:tools/building/sword" | "tconstruct:tools/modifiers/slotless/embellishment_zinc" | "ae2:transform/fluix_crystal" | "minecraft:gray_concrete_powder" | "farmersdelight:cyan_hanging_canvas_sign" | "tconstruct:tools/materials/wood/planks/oak" | "powah:crafting/magmator_blazing" | "tconstruct:gadgets/slimesling/ender" | "create:crafting/kinetics/mechanical_roller" | "minecraft:redstone_from_blasting_redstone_ore" | "ae2:tools/paintballs_light_blue" | "tconstruct:tools/materials/melting/slimesteel" | "ad_astra:venus_cobblestone_stairs" | "railways:crafting/track_coupler" | "minecraft:lime_candle" | "tconstruct:tools/modifiers/upgrade/springy" | "railways:crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "minecraft:red_dye_from_beetroot" | "comforts:hammock_to_green" | "tconstruct:common/glass/magenta_clear_stained_glass_pane" | "computercraft:computer_command" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "railways:crafting/palettes/dyeing_8x/yellow_slashed_locometal" | "iceandfire:dragonarmor_gold_tail" | "tconstruct:smeltery/casting/slime/ender/slimeball" | "railways:mechanical_crafting/light_gray_copper_wrapped_locometal_boiler" | "biomesoplenty:stripped_jacaranda_wood" | "create:small_asurine_bricks_from_stone_types_asurine_stonecutting" | "tconstruct:smeltery/seared/seared_bricks_stonecutting" | "railways:crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "railways:crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal_boiler" | "createaddition:crafting/modular_accumulator_electrum" | "minecraft:birch_stairs" | "minecraft:exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_fence_gate" | "create:cutting/runtime_generated/compat/minecraft/birch_planks_to_birch_sign" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_redwood_wood_to_redwood_planks" | "tconstruct:tools/modifiers/slotless/embellishment_hepatizon" | "create:item_application/brass_casing_from_log" | "create:bamboo_window_pane" | "railways:stonecutting/palettes/cycling/purple_plated_locometal" | "railways:crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "hexcasting:cypher" | "railways:crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal_boiler" | "create:polished_cut_tuff_slab" | "createoreexcavation:drilling/emerald" | "railways:crafting/palettes/dyeing_1x/pink_riveted_locometal" | "powah:crafting/ender_cell_blazing" | "railways:crafting/palettes/dyeing_1x/light_blue_locometal_boiler" | "railways:crafting/palettes/dyeing_8x/blue_flat_slashed_locometal" | "tconstruct:common/materials/queens_slime_ingot_from_nuggets" | "create:crafting/kinetics/chute" | "minecraft:cyan_glazed_terracotta" | "iceandfire:dragonarmor_copper_body" | "create:milling/torchflower" | "iceandfire:chain" | "minecraft:stone_sword" | "create:crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "extendedae:ex_inscriber" | "tconstruct:smeltery/casting/metal/copper/plate_gold_cast" | "iceandfire:dragonscales_copper_to_dragonscale_copper" | "tconstruct:tools/modifiers/ability/tilling" | "tconstruct:tools/modifiers/defense/magic_protection" | "tconstruct:smeltery/casting/slime/ender/bottle" | "tconstruct:tools/modifiers/salvage/upgrade/swiftstrike" | "create:cut_ochrum_brick_stairs" | "iceandfire:dragonsteel_lightning_ingot_to_dragonsteel_lightning_block" | "farmersdelight:milk_bottle" | "tconstruct:tools/modifiers/worktable/extract_dagger_modifier_breath" | "railways:crafting/palettes/dyeing_1x/lime_slashed_locometal" | "hexcasting:pride_colorizer_demigirl" | "farmersdelight:cutting/mangrove_trapdoor" | "minecraft:iron_ingot_from_iron_block" | "create:polished_cut_asurine_stairs" | "create:cutting/runtime_generated/compat/biomesoplenty/maple_planks_to_maple_fence_gate" | "create:crafting/kinetics/fluid_tank" | "create:cutting/runtime_generated/compat/minecraft/acacia_wood_to_stripped_acacia_wood" | "create:smoking/bread" | "ad_astra:oxygen_loader" | "hextended:long/sealed_lesser_battery_extended_staff" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "ae2:shaped/walls/cut_quartz_block" | "ae2:network/wireless_booster" | "railways:crafting/palettes/dyeing_1x/green_iron_wrapped_locometal_boiler" | "ad_astra:chiseled_venus_stone_stairs" | "minecraft:banner_duplicate" | "createaddition:charging/exposed_cut_copper_slab" | "tconstruct:tools/materials/casting/manyullyn" | "ad_astra:ostrum_plateblock" | "minecraft:granite_stairs_from_granite_stonecutting" | "create:small_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "tconstruct:smeltery/casting/water/mud_bricks" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_planks_to_hellbark_door" | "railways:sequenced_assembly/track_biomesoplenty_hellbark_wide" | "tconstruct:common/slime/ichor/slimeball_from_congealed" | "minecraft:iron_ingot_from_nuggets" | "tconstruct:smeltery/casting/soul/glass" | "minecraft:golden_pickaxe" | "tconstruct:smeltery/casting/metal/slimesteel/nugget_gold_cast" | "minecraft:chiseled_bookshelf" | "minecraft:ladder" | "hextended:sealed_lesser_battery_staff" | "create:deploying/waxed_copper_tile_stairs_from_adding_wax" | "railways:crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "create:filling/builders_tea" | "railways:sequenced_assembly/track_blackstone_wide" | "tconstruct:tables/scorched_anvil" | "classicpipes:mangrove_fluid_pipe_b" | "classicpipes:mangrove_fluid_pipe_a" | "minecraft:redstone_torch" | "powah:crafting/nitro_crystal_block" | "farmersdelight:pumpkin_from_slices" | "create:small_tuff_brick_stairs" | "railways:crafting/palettes/dyeing_8x/magenta_plated_locometal" | "powah:crafting/niotic_crystal_block" | "create:crafting/kinetics/deployer" | "minecraft:gray_bed" | "farmersdelight:basket" | "ae2:network/parts/export_bus" | "create:crafting/materials/andesite_alloy" | "simplylight:illuminant_light_gray_block_on_dyed" | "minecraft:white_terracotta" | "minecraft:diamond_from_blasting_deepslate_diamond_ore" | "minecraft:armor_stand" | "minecraft:pink_stained_glass_pane" | "tconstruct:tools/modifiers/upgrade/hydraulic_from_shard" | "minecraft:blue_dye_from_cornflower" | "create:cutting/runtime_generated/compat/tconstruct/bloodshroom_planks_to_bloodshroom_fence" | "minecraft:stripped_cherry_wood" | "tconstruct:smeltery/melting/scorched/faucet" | "create:cutting/runtime_generated/compat/tconstruct/greenheart_planks_to_greenheart_button" | "ae2:network/parts/panels_monitor" | "biomesoplenty:redwood_boat" | "tconstruct:tools/parts/casting/bow_limb_sand_cast" | "minecraft:quartz_slab_from_stonecutting" | "tconstruct:tools/parts/casting/pick_head_gold_cast" | "minecraft:brown_banner" | "farmersdelight:tomato_crate" | "iceandfire:banners/banner_pattern_lightning_head" | "minecraft:warped_hyphae" | "molten_metals:filling/copper_filled_metal_mold" | "createaddition:crafting/large_connector_gold" | "simplylight:illuminant_light_gray_block_toggle" | "create:crimsite_pillar_from_stone_types_crimsite_stonecutting" | "create:cut_calcite_slab_from_stone_types_calcite_stonecutting" | "tconstruct:common/materials/pig_iron_ingot_from_nuggets" | "ae2:shaped/stairs/chiseled_quartz_block" | "railways:crafting/palettes/dyeing_8x/lime_locometal_boiler" | "comforts:sleeping_bag_to_yellow" | "ad_astra:mars_pillar" | "tconstruct:smeltery/melting/metal/iron/nugget" | "create:cutting/runtime_generated/compat/minecraft/stripped_acacia_log_to_acacia_planks" | "iceandfire:sea_serpent_scales_bronze_to_sea_serpent_scale_block_bronze" | "biomesoplenty:willow_door" | "tconstruct:tools/modifiers/slotless/embellishment_copper" | "biomesoplenty:brimstone_brick_stairs" | "minecraft:green_bed" | "create:layered_ochrum_from_stone_types_ochrum_stonecutting" | "railways:crafting/palettes/dyeing_1x/red_flat_riveted_locometal" | "tconstruct:smeltery/casts/sand_casts/bow_limb" | "minecraft:red_sandstone_slab_from_red_sandstone_stonecutting" | "ae2:block_cutter/slabs/fluix_slab" | "tconstruct:smeltery/scorched/table" | "hexcasting:staff/mindsplice" | "ad_astra:stonecutting/permafrost_pillar_from_permafrost_stonecutting" | "tconstruct:gadgets/piggy_backpack" | "farmersdelight:painting_from_canvas" | "tconstruct:smeltery/melting/ender/pearl" | "create:small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "tconstruct:tools/modifiers/upgrade/offhanded" | "comforts:hammock_to_black" | "ae2:tools/paintballs_red" | "tconstruct:smeltery/casting/water/blue_concrete" | "tconstruct:smeltery/casting/metal/steel/nugget_sand_cast" | "minecraft:prismarine_brick_slab_from_prismarine_stonecutting" | "tconstruct:tools/parts/casting/tool_binding_composite" | "hexcasting:uuid_colorizer" | "railways:crafting/palettes/dyeing_8x/orange_flat_riveted_locometal" | "create:crafting/logistics/red_table_cloth" | "ad_astra:energizer" | "create:small_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "ad_astra:stonecutting/mars_cobblestone_slab_from_mars_cobblestone_stonecutting" | "tconstruct:tools/building/kama" | "minecraft:gray_banner" | "create:cutting/runtime_generated/compat/hexcasting/edified_planks_to_edified_button" | "create:small_crimsite_brick_wall" | "minecraft:warped_stairs" | "railways:sequenced_assembly/track_warped" | "tconstruct:smeltery/casting/metal/netherite/ingot_sand_cast" | "simplylight:illuminant_purple_block_toggle" | "create:deploying/waxed_weathered_cut_copper_stairs_from_adding_wax" | "tconstruct:smeltery/scorched/scorched_bricks_slab_stonecutter" | "iceandfire:silver_ingot_to_silver_nugget" | "powah:crafting/capacitor_basic_large" | "iceandfire:dragonsteel_lightning_axe" | "create:small_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "ae2:network/cells/fluid_storage_cell_16k_storage" | "tconstruct:tools/materials/melting/ender_pearl" | "tconstruct:tools/modifiers/salvage/upgrade/reinforced" | "tconstruct:smeltery/melting/amethyst/tinted_glass" | "ae2:tools/paintballs_gray" | "minecraft:smooth_sandstone_slab" | "railways:crafting/palettes/dyeing_8x/purple_plated_locometal" | "iceandfire:dragonarmor_iron_tail" | "tconstruct:tools/materials/hepatizon/nugget" | "ad_astra:smelting/desh_ingot_from_smelting_raw_desh" | "create:cutting/runtime_generated/compat/minecraft/stripped_crimson_stem_to_crimson_planks" | "minecraft:rail" | "create:cutting/runtime_generated/compat/minecraft/crimson_planks_to_crimson_trapdoor" | "biomesoplenty:smooth_white_sandstone_stairs" | "powah:crafting/ender_gate_hardened_2" | "tconstruct:tools/materials/enderslime_vine" | "minecraft:diamond_sword" | "railways:stonecutting/palettes/cycling/blue_slashed_locometal" | "biomesoplenty:magic_wood" | "biomesoplenty:empyreal_slab" | "farmersdelight:cutting/oak_trapdoor" | "ae2:network/cells/fluid_storage_cell_256k" | "farmersdelight:cooking/dumplings" | "tconstruct:tools/parts/casting/tool_binding_sand_cast" | "create:milling/compat/biomesoplenty/rose" | "biomesoplenty:stripped_pine_wood" | "hextended:flowered_moss_staff" | "tconstruct:smeltery/melting/metal/soulsteel/nugget" | "create:deploying/exposed_cut_copper_slab_from_removing_wax" | "create:cut_veridium_bricks_from_stone_types_veridium_stonecutting" | "tconstruct:smeltery/melting/metal/slimesteel/nugget" | "tconstruct:smeltery/entity_melting/terracube" | "iceandfire:netherite_hippogryph_armor" | "tconstruct:common/slime/sky/slimeball_from_block" | "tconstruct:tools/materials/melting/steel" | "createoreexcavation:cutting/diamond_cutting" | "tconstruct:smeltery/casts/sand_casts/pick_head" | "minecraft:polished_blackstone_from_blackstone_stonecutting" | "tconstruct:tools/materials/composite/slimewood_composite" | "create:oxidized_copper_tile_slab_from_oxidized_copper_tiles_stonecutting" | "tconstruct:tools/severing/turtle_shell" | "tconstruct:smeltery/melting/metal/zinc/block" | "create:splashing/runtime_generated/compat/minecraft/purple_concrete_powder_to_purple_concrete" | "tconstruct:smeltery/casting/amethyst/shard_sand_cast" | "tconstruct:smeltery/casting/metal/gold/rod_sand_cast" | "create:cut_limestone_brick_slab" | "minecraft:polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "tconstruct:smeltery/alloys/molten_manyullyn" | "railways:stonecutting/palettes/cycling/orange_locometal_smokebox" | "farmersdelight:book_from_canvas" | "tconstruct:smeltery/melting/metal/cobalt/reinforcement" | "create:copper_tiles_from_copper_ingots_stonecutting" | "minecraft:crimson_planks" | "minecraft:smooth_red_sandstone" | "classicpipes:oak_fluid_pipe_a" | "create:cutting/runtime_generated/compat/ad_astra/glacian_log_to_stripped_glacian_log" | "classicpipes:oak_fluid_pipe_b" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_planks_to_mahogany_pressure_plate" | "computercraft:printed_book" | "iceandfire:wither_shard" | "railways:crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal" | "powah:crafting/energizing_rod_starter" | "sophisticatedbackpacks:advanced_pickup_upgrade" | "tconstruct:tools/materials/nahuatl" | "ae2:block_cutter/stairs/cut_quartz_stairs" | "ae2:network/cells/item_storage_cell_16k_storage" | "railways:crafting/palettes/dyeing_8x/gray_locometal_smokebox" | "create:crushing/asurine_recycling" | "extendedae:tag_storage_bus" | "create:cut_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "minecraft:mangrove_planks" | "ad_astra:stonecutting/venus_stone_slab_from_venus_stone_stonecutting" | "create:deploying/exposed_copper_shingle_stairs_from_removing_wax" | "tconstruct:smeltery/casts/gold_casts/small_blade" | "ae2:network/blocks/crystal_processing_growth_accelerator" | "ad_astra:stonecutting/mercury_stone_brick_wall_from_mercury_stone_stonecutting" | "railways:crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal_boiler" | "minecraft:iron_nugget_from_blasting" | "railways:crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal_boiler" | "molten_metals:crushing/slag_crushing" | "molten_metals:splashing/lead_ingot_from_metal_mold" | "tconstruct:common/materials/amethyst_bronze_block_from_ingots" | "tconstruct:world/wood/greenheart/sign" | "powah:crafting/ender_cell_niotic_2" | "railways:sequenced_assembly/track_biomesoplenty_redwood" | "tconstruct:tools/severing/player_head" | "powah:crafting/energy_cell_blazing" | "powah:crafting/energizing_rod_spirited" | "create:milling/azure_bluet" | "minecraft:green_stained_glass_pane" | "extendedae:crystal_fixer" | "create:cutting/runtime_generated/compat/tconstruct/bloodshroom_planks_to_bloodshroom_button" | "minecraft:magenta_dye_from_blue_red_pink" | "farmersdelight:red_hanging_canvas_sign" | "create:crushing/mars_ostrum_ore" | "minecraft:black_concrete_powder" | "minecraft:lime_carpet" | "biomesoplenty:white_dye_from_white_petals" | "minecraft:sugar_from_sugar_cane" | "create:polished_cut_diorite_slab_recycling" | "biomesoplenty:maple_chest_boat" | "biomesoplenty:dead_stairs" | "ae2:network/parts/terminals_crafting" | "molten_metals:mixing/molten_zinc_from_block" | "iceandfire:dragonarmor_dragon_steel_ice_body" | "hexcasting:jeweler_hammer" | "iceandfire:delight/pixie_dust_milky_tea" | "tconstruct:smeltery/casting/diamond/block" | "minecraft:cooked_beef_from_campfire_cooking" | "minecraft:quartz_pillar" | "tconstruct:smeltery/melting/metal/iron/cauldron" | "farmersdelight:cutting/leather_leggings" | "railways:crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal" | "create:deploying/waxed_copper_shingles_from_adding_wax" | "sophisticatedbackpacks:jukebox_upgrade" | "ae2:tools/certus_quartz_pickaxe" | "tconstruct:smeltery/seared/seared_stone_stairs" | "tconstruct:armor/building/slime_skull/glass" | "ad_astra:small_purple_industrial_lamp" | "minecraft:dye_red_wool" | "railways:crafting/palettes/dyeing_1x/cyan_slashed_locometal" | "tconstruct:smeltery/casts/sand_casts/gems" | "ae2:network/parts/energy_level_emitter" | "create:crafting/logistics/purple_postbox" | "iceandfire:dragonsteel_lightning_chestplate" | "minecraft:waxed_cut_copper_from_honeycomb" | "ad_astra:black_industrial_lamp" | "biomesoplenty:jacaranda_door" | "tconstruct:world/wood/bloodshroom/door" | "create:crushing/iron_ore" | "tconstruct:common/flint" | "railways:crafting/palettes/dyeing_8x/brown_flat_slashed_locometal" | "create:crafting/logistics/black_postbox" | "ad_astra:stonecutting/glacio_stone_brick_wall_from_glacio_stone_bricks_stonecutting" | "railways:crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal_boiler" | "minecraft:blue_dye" | "minecraft:polished_diorite_slab_from_polished_diorite_stonecutting" | "biomesoplenty:light_blue_dye_from_icy_iris" | "tconstruct:smeltery/seared/seared_cobble_stairs_stonecutter" | "tconstruct:tools/building/hand_axe" | "farmersdelight:organic_compost_from_rotten_flesh" | "minecraft:muddy_mangrove_roots" | "ad_astra:large_gas_tank" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_trapdoor" | "create:small_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "railways:sequenced_assembly/track_jungle_wide" | "ad_astra:venus_sandstone" | "iceandfire:dragonsteel_lightning_leggings" | "ad_astra:stonecutting/polished_moon_stone_slab_from_polished_moon_stone_stonecutting" | "iceandfire:fire_stew" | "railways:dying_existing_cap_pink" | "create:weathered_copper_tile_stairs_from_weathered_copper_tiles_stonecutting" | "createoreexcavation:sample_drill" | "minecraft:light_gray_banner" | "tconstruct:smeltery/seared/seared_bricks_slab_stonecutter" | "tconstruct:tools/modifiers/salvage/ability/expanded" | "powah:crafting/energizing_rod_hardened" | "railways:crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal" | "farmersdelight:cutting/mangrove_sign" | "minecraft:wooden_axe" | "ad_astra:venus_stone_brick_slab" | "railways:sequenced_assembly/track_oak" | "powah:crafting/energy_cell_basic" | "railways:mechanical_crafting/purple_copper_wrapped_locometal_boiler" | "create:smelting/glass_from_tiled_glass" | "tconstruct:smeltery/casts/red_sand_casts/small_blade" | "tconstruct:tools/materials/seared_stone/block" | "create:pressing/brass_ingot" | "ae2:decorative/light_detector" | "create:small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "hexcasting:slate_amethyst_pillar" | "minecraft:trapped_chest" | "create:oak_window_pane" | "minecraft:stone_stairs_from_stone_stonecutting" | "create:polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "iceandfire:dragonscale_electric_to_dragonscales_electric" | "minecraft:dried_kelp" | "railways:sequenced_assembly/track_blackstone_narrow" | "create:andesite_from_stone_types_andesite_stonecutting" | "minecraft:polished_andesite_stairs_from_andesite_stonecutting" | "create:cut_asurine_stairs" | "minecraft:iron_bars" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_planks_to_magic_slab" | "create:crafting/appliances/package_filter_clear" | "ad_astra:smelting/gold_ingot_from_smelting_venus_gold_ore" | "railways:crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal" | "ad_astra:small_white_industrial_lamp" | "computercraft:speaker" | "create:crafting/appliances/clipboard" | "iceandfire:dragonsteel_fire_hoe" | "ad_astra:space_helmet" | "create:pressing/ostrum_ingot" | "tconstruct:smeltery/melting/scorched/lantern" | "minecraft:diamond_axe" | "molten_metals:mixing/molten_zinc_from_block_raw" | "tconstruct:smeltery/casting/scorched/foundry_controller" | "tconstruct:common/firewood/lavawood_stairs" | "tconstruct:common/slime/earth/congealed" | "iceandfire:armor_green_boots" | "railways:sequenced_assembly/light_blue_conductor_cap" | "create:cutting/runtime_generated/compat/biomesoplenty/dead_planks_to_dead_stairs" | "tconstruct:smeltery/melting/diamond/axes" | "tconstruct:tools/severing/phantom_membrane" | "ad_astra:smelting/cracked_venus_stone_bricks_from_smelting_venus_stone_bricks" | "biomesoplenty:empyreal_door" | "railways:crafting/palettes/dyeing_1x/red_brass_wrapped_locometal" | "tconstruct:tools/severing/chicken_feather" | "minecraft:dark_oak_pressure_plate" | "minecraft:dye_blue_wool" | "computercraft:computer_advanced_upgrade" | "railways:crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal_boiler" | "iceandfire:iron_hippogryph_armor" | "tconstruct:smeltery/casting/obsidian/chest" | "molten_metals:emptying/molten_netherite_from_metal_mold" | "biomesoplenty:empyreal_planks" | "extendedae:threshold_export_bus" | "railways:crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal_boiler" | "tconstruct:tools/modifiers/ability/luck_level_1" | "tconstruct:tools/modifiers/ability/luck_level_3" | "tconstruct:tools/modifiers/ability/luck_level_2" | "create:cut_deepslate_slab" | "biomesoplenty:smooth_black_sandstone_stairs" | "tconstruct:common/glass/blue_clear_stained_glass_pane" | "minecraft:waxed_cut_copper" | "create:cutting/runtime_generated/compat/biomesoplenty/dead_log_to_stripped_dead_log" | "tconstruct:smeltery/entity_melting/magma_cube" | "create:polished_cut_dripstone_wall" | "create:cutting/glacian_log" | "minecraft:chiseled_polished_blackstone" | "create:crafting/curiosities/minecart_coupling" | "tconstruct:smeltery/casts/sand_casts/tool_handle" | "iceandfire:forest_troll_leather_leggings" | "create:cut_deepslate_brick_slab" | "create:cutting/runtime_generated/compat/minecraft/stripped_bamboo_block_to_bamboo_planks" | "create:deploying/oxidized_copper_shingle_stairs_from_removing_wax" | "tconstruct:smeltery/casting/metal/gold/rod_gold_cast" | "create:cut_granite_stairs_from_stone_types_granite_stonecutting" | "hexcasting:stripped_edified_wood" | "iceandfire:tide_red_chestplate" | "minecraft:mud_brick_wall_from_mud_bricks_stonecutting" | "create:milling/wheat" | "create:polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "create:compacting/honey" | "iceandfire:hippogryph_sword" | "biomesoplenty:cut_black_sandstone_from_black_sandstone_stonecutting" | "minecraft:red_banner" | "hexcasting:ancient_scroll_paper_lantern" | "ae2:misc/chests_sky_stone" | "railways:stonecutting/palettes/cycling/light_blue_flat_slashed_locometal" | "create:milling/grass" | "tconstruct:common/slime/ichor/congealed" | "hexcasting:pride_colorizer_pansexual" | "farmersdelight:cutting/cherry_trapdoor" | "powah:crafting/photoelectric_pane" | "create:cutting/runtime_generated/compat/biomesoplenty/umbran_planks_to_umbran_slab" | "railways:crafting/palettes/dyeing_1x/cyan_plated_locometal" | "ad_astra:netherite_space_helmet" | "tconstruct:smeltery/melting/diamond/block" | "farmersdelight:cutting/apple_pie" | "minecraft:black_carpet" | "ad_astra:smelting/calorite_ingot_from_smelting_deepslate_calorite_ore" | "railways:stonecutting/palettes/cycling/black_plated_locometal" | "ad_astra:stonecutting/mercury_stone_slab_from_mercury_stone_stonecutting" | "biomesoplenty:white_dye_from_white_lavender" | "biomesoplenty:stripped_willow_wood" | "tconstruct:tools/modifiers/salvage/ability/slurping" | "minecraft:dye_magenta_wool" | "minecraft:deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "create:splashing/runtime_generated/compat/minecraft/blue_concrete_powder_to_blue_concrete" | "create:crafting/appliances/cardboard_helmet" | "minecraft:waxed_oxidized_cut_copper_slab_from_honeycomb" | "farmersdelight:bacon_and_eggs" | "create:crafting/palettes/scorchia" | "powah:energizing/uraninite_from_ore_dense" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_umbran_log_to_umbran_planks" | "railways:mechanical_crafting/lime_locometal_boiler" | "ad_astra:mars_cobblestone_slab" | "iceandfire:dragonsteel_fire_chestplate" | "ad_astra:gray_flag" | "minecraft:torch" | "minecraft:polished_granite_stairs" | "tconstruct:smeltery/casts/red_sand_casts/broad_blade" | "iceandfire:dragonforge/dragonsteel_ice_ingot" | "ae2:entropy/cool/grass_block_dirt" | "railways:stonecutting/palettes/cycling/yellow_locometal_pillar" | "tconstruct:smeltery/melting/scorched/grout" | "iceandfire:banners/banner_pattern_bird" | "iceandfire:armor_silver_metal_helmet" | "create:crafting/logistics/light_blue_table_cloth_clear" | "create:crafting/kinetics/black_seat" | "tconstruct:smeltery/casting/slime/blood/congealed" | "iceandfire:tide_bronze_boots" | "create:milling/allium" | "ad_astra:stonecutting/moon_pillar_from_moon_stone_bricks_stonecutting" | "createoreexcavation:drilling/nether_gold" | "ad_astra:stonecutting/polished_venus_stone_from_venus_stone_bricks_stonecutting" | "farmersdelight:cutting/acacia_hanging_sign" | "tconstruct:common/firewood/nahuatl_fence" | "createaddition:charging/weathered_copper_shingles" | "iceandfire:armor_amythest_boots" | "railways:crafting/palettes/dyeing_1x/gray_flat_riveted_locometal" | "tconstruct:smeltery/melting/amethyst/bud_large" | "iceandfire:jar_empty" | "agricraft:coal" | "biomesoplenty:orange_sandstone_stairs_from_orange_sandstone_stonecutting" | "create:crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "create:crafting/kinetics/copper_valve_handle_from_others" | "railways:crafting/palettes/dyeing_1x/orange_flat_riveted_locometal" | "biomesoplenty:jacaranda_pressure_plate" | "iceandfire:dragonarmor_dragon_steel_ice_tail" | "molten_metals:splashing/tin_ingot_from_metal_mold" | "create:cutting/runtime_generated/compat/ad_astra/glacian_planks_to_glacian_fence" | "minecraft:sandstone_wall" | "tconstruct:common/iron_platform" | "tconstruct:common/firewood/blazewood_slab" | "minecraft:cut_copper_slab" | "tconstruct:smeltery/melting/amethyst/spyglass" | "create:splashing/runtime_generated/compat/minecraft/pink_concrete_powder_to_pink_concrete" | "create:mechanical_crafting/wand_of_symmetry" | "create:cut_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "create:milling/cactus" | "minecraft:cherry_slab" | "ad_astra:wrench" | "powah:crafting/energy_cell_nitro" | "railways:stonecutting/palettes/cycling/red_locometal_pillar" | "create:milling/clay" | "minecraft:stripped_acacia_wood" | "railways:crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal" | "tconstruct:tools/modifiers/upgrade/scope" | "comforts:sleeping_bag_brown" | "railways:crafting/palettes/dyeing_1x/black_locometal_pillar" | "railways:sequenced_assembly/track_jungle" | "extendedae:ei_part" | "tconstruct:armor/repair/travelers_leather_repair_kit" | "farmersdelight:cutting/mangrove_log" | "railways:crafting/palettes/dyeing_1x/orange_locometal_pillar" | "iceandfire:mountain_troll_leather_chestplate" | "iceandfire:tide_blue_leggings" | "extendedae:ebus_out" | "minecraft:orange_bed" | "create:crafting/materials/bound_cardboard_block" | "createaddition:mixing/bioethanol" | "ae2:tools/paintballs_lumen_purple" | "tconstruct:smeltery/melting/venom/eye" | "ad_astra:magenta_flag" | "ae2:network/cells/item_storage_cell_16k" | "railways:crafting/palettes/dyeing_8x/pink_riveted_locometal" | "create:filling/glowstone" | "tconstruct:smeltery/melting/metal/pig_iron/ingot" | "railways:crafting/palettes/wrapping/lime_iron_wrapped_locometal" | "railways:stonecutting/palettes/cycling/magenta_flat_slashed_locometal" | "classicpipes:acacia_fluid_pipe_a" | "classicpipes:acacia_fluid_pipe_b" | "ad_astra:glacio_stone_slab" | "tconstruct:smeltery/casting/filling/seared_ingot_gauge" | "minecraft:red_stained_glass_pane" | "create:splashing/gravel" | "railways:sequenced_assembly/track_biomesoplenty_dead_narrow" | "tconstruct:common/glass/clear_glass_pane" | "create:crafting/kinetics/andesite_door" | "minecraft:brick_wall" | "tconstruct:tools/modifiers/salvage/ability/aqua_affinity" | "railways:stonecutting/palettes/cycling/pink_locometal_smokebox" | "tconstruct:smeltery/casts/gold_casts/broad_blade" | "create:deploying/copper_tile_stairs_from_removing_wax" | "railways:stonecutting/palettes/cycling/gray_locometal_smokebox" | "tconstruct:tools/modifiers/slotless/creative_slot" | "railways:crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal" | "hexcasting:edified_wood" | "minecraft:dark_oak_planks" | "biomesoplenty:redwood_pressure_plate" | "minecraft:granite_wall" | "simplylight:illuminant_purple_block_on_dyed" | "tconstruct:armor/repair/slimesuit_repair_kit" | "iceandfire:copper_nuggets_to_ingot" | "tconstruct:smeltery/casting/metal/netherite/ingot_gold_cast" | "create:polished_cut_asurine_slab_from_stone_types_asurine_stonecutting" | "tconstruct:world/wood/bloodshroom/sign" | "hexcasting:dye_colorizer_red" | "tconstruct:smeltery/melting/water/ice" | "iceandfire:tide_deepblue_boots" | "minecraft:exposed_cut_copper_from_exposed_copper_stonecutting" | "railways:stonecutting/palettes/cycling/light_blue_slashed_locometal" | "tconstruct:smeltery/casting/amethyst/block" | "minecraft:mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "tconstruct:smeltery/scorched/drain" | "minecraft:diamond_helmet" | "molten_metals:filling/brass_filled_ceramic_mold" | "minecraft:warped_fence" | "createaddition:compat/tconstruct/hepatizon" | "railways:crafting/track_switch_andesite" | "minecraft:dark_oak_fence_gate" | "railways:crafting/palettes/dyeing_1x/black_flat_riveted_locometal" | "farmersdelight:cutting/oak_door" | "create:crushing/zinc_ore" | "tconstruct:smeltery/scorched/alloyer" | "minecraft:compass" | "tconstruct:tools/materials/slimewood/skyroot_planks" | "iceandfire:dragonsteel_fire_shovel" | "create:cut_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "minecraft:loom" | "tconstruct:smeltery/casting/metal/cobalt/block" | "farmersdelight:cutting/cake" | "ad_astra:steel_engine" | "tconstruct:smeltery/melting/seared/melter" | "create:smelting/copper_ingot_from_crushed" | "railways:crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal" | "ad_astra:small_lime_industrial_lamp" | "iceandfire:lectern" | "tconstruct:smeltery/melting/metal/electrum/ingot" | "create:crafting/logistics/cyan_table_cloth_clear" | "create:small_calcite_brick_stairs" | "sophisticatedbackpacks:smoking_upgrade_from_smelting_upgrade" | "classicpipes:spruce_fluid_pipe_a" | "railways:crafting/palettes/dyeing_1x/red_locometal_boiler" | "biomesoplenty:cut_black_sandstone_slab_from_cut_black_sandstone_stonecutting" | "tconstruct:smeltery/melting/slime/earth/bud_cluster" | "biomesoplenty:willow_stairs" | "classicpipes:spruce_fluid_pipe_b" | "sophisticatedbackpacks:everlasting_upgrade" | "biomesoplenty:white_dye_from_tall_white_lavender" | "farmersdelight:cutting/sweet_berry_cheesecake" | "tconstruct:tools/materials/melting/manyullyn" | "create:crafting/appliances/name_tag" | "minecraft:gray_stained_glass_pane" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_button" | "tconstruct:smeltery/melting/slime/earth/sapling" | "tconstruct:smeltery/casts/red_sand_casts/plates" | "railways:crafting/palettes/dyeing_1x/green_locometal_pillar" | "tconstruct:smeltery/melting/obsidian/dust" | "create:crafting/logistics/yellow_postbox_from_other_postbox" | "tconstruct:tools/modifiers/ability/crystalshot_enderslime" | "minecraft:polished_blackstone" | "tconstruct:smeltery/casts/gold_casts/tool_binding" | "minecraft:bamboo_mosaic_slab" | "create:cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "tconstruct:smeltery/melting/scorched/fuel_tank" | "tconstruct:tools/repair/staff_repair_kit" | "railways:stonecutting/palettes/cycling/lime_plated_locometal" | "railways:crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal_boiler" | "iceandfire:dragon_flute" | "tconstruct:tools/parts/casting/bow_limb_gold_cast" | "tconstruct:world/wood/bloodshroom/pressure_plate" | "minecraft:spire_armor_trim_smithing_template" | "create:cut_dripstone_brick_stairs" | "create:crafting/logistics/white_postbox_from_other_postbox" | "minecraft:stone_axe" | "ad_astra:stonecutting/permafrost_brick_wall_from_permafrost_bricks_stonecutting" | "createaddition:charging/weathered_copper_shingle_stairs" | "iceandfire:stymphalian_bird_dagger" | "minecraft:dye_purple_carpet" | "ad_astra:fluid_pipe_duct" | "iceandfire:armor_copper_metal_helmet" | "railways:crafting/palettes/dyeing_1x/blue_plated_locometal" | "extendedae:cobblestone_cell" | "biomesoplenty:dead_wood" | "tconstruct:tools/repair/flint_and_brick_seared_station" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_planks_to_fir_stairs" | "hexpigmentplus:magician_cloak_large" | "create:crafting/kinetics/controls" | "railways:crafting/palettes/dyeing_8x/purple_locometal_smokebox" | "ad_astra:stonecutting/permafrost_brick_slab_from_permafrost_bricks_stonecutting" | "comforts:sleeping_bag_to_gray" | "ae2:tools/nether_quartz_pickaxe" | "minecraft:light_blue_stained_glass" | "tconstruct:smeltery/alloys/molten_queens_slime" | "tconstruct:tools/severing/spider_head" | "tconstruct:smeltery/casting/metal/rose_gold/ingot_sand_cast" | "create:polished_cut_ochrum_from_stone_types_ochrum_stonecutting" | "create:polished_cut_tuff_from_stone_types_tuff_stonecutting" | "minecraft:deepslate_brick_slab" | "molten_metals:mixing/molten_netherite_from_block" | "tconstruct:smeltery/melting/metal/gold/boots" | "railways:crafting/palettes/dyeing_1x/cyan_riveted_locometal" | "ad_astra:smelting/glacio_stone_from_smelting_glacio_cobblestone" | "minecraft:polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "hexcasting:pride_colorizer_intersex" | "ad_astra:chiseled_mars_stone_bricks" | "powah:energizing/blazing_crystal_2" | "iceandfire:furnace/sapphire" | "powah:crafting/thermo_generator_niotic" | "create:cut_tuff_wall_from_stone_types_tuff_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_planks_to_pine_door" | "biomesoplenty:brimstone_brick_stairs_from_brimstone_bricks_stonecutting" | "create:crushing/lapis_ore" | "hexcasting:staff/oak" | "create:splashing/runtime_generated/compat/minecraft/brown_concrete_powder_to_brown_concrete" | "create:small_dripstone_brick_wall" | "createaddition:mixing/biomass_from_crops" | "ad_astra:strophar_trapdoor" | "farmersdelight:cutting/spruce_hanging_sign" | "create:cut_scoria_slab_from_stone_types_scoria_stonecutting" | "ae2:tools/paintballs_purple" | "iceandfire:dragonarmor_diamond_neck" | "create:milling/compat/biomesoplenty/wildflower" | "tconstruct:tools/modifiers/salvage/upgrade/leaping" | "sophisticatedbackpacks:compacting_upgrade" | "create:cut_dripstone_brick_slab_recycling" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_slab" | "railways:crafting/palettes/dyeing_8x/lime_riveted_locometal" | "farmersdelight:kelp_roll" | "iceandfire:dread_stone_bricks_chiseled" | "hexcasting:stonecutting/amethyst_bricks" | "hexcasting:akashic_connector" | "create:deploying/copper_tile_slab_from_removing_wax" | "minecraft:iron_axe" | "create:cut_crimsite_from_stone_types_crimsite_stonecutting" | "ae2:decorative/quartz_vibrant_glass" | "railways:crafting/palettes/dyeing_1x/white_locometal_pillar" | "minecraft:jukebox" | "ad_astra:small_brown_industrial_lamp" | "tconstruct:tools/modifiers/upgrade/sticky" | "create:layered_granite_from_stone_types_granite_stonecutting" | "create:crafting/logistics/repackager_from_conversion" | "railways:stonecutting/palettes/cycling/lime_flat_riveted_locometal" | "farmersdelight:carrot_from_crate" | "tconstruct:tables/modifier_worktable" | "minecraft:acacia_sign" | "tconstruct:common/glass/yellow_clear_stained_glass_pane" | "ae2:network/cables/smart_brown" | "minecraft:chest_minecart" | "tconstruct:smeltery/casting/scorched/brick_gold_cast" | "powah:crafting/solar_panel_hardened" | "tconstruct:tools/parts/casting/bow_grip_sand_cast" | "ae2:network/cables/covered_orange" | "create:crafting/logistics/brass_funnel" | "create:weathered_copper_shingle_stairs_from_weathered_copper_shingles_stonecutting" | "minecraft:decorated_pot" | "minecraft:magenta_terracotta" | "minecraft:baked_potato_from_campfire_cooking" | "create:compacting/ice" | "create:milling/blue_orchid" | "railways:crafting/palettes/dyeing_1x/cyan_flat_slashed_locometal" | "tconstruct:smeltery/scorched/faucet" | "minecraft:deepslate_bricks_from_polished_deepslate_stonecutting" | "tconstruct:tools/materials/wood/sticks" | "createoreexcavation:drilling/redstone" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_sign" | "biomesoplenty:orange_sandstone_slab_from_orange_sandstone_stonecutting" | "create:deploying/weathered_copper_shingles_from_deoxidising" | "minecraft:tide_armor_trim_smithing_template" | "tconstruct:tools/modifiers/worktable/remove_modifier_venom" | "iceandfire:bestiary" | "create:cut_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "create:milling/granite" | "create:crushing/amethyst_block" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_button" | "ad_astra:strophar_fence_gate" | "ad_astra:polished_moon_stone_slab" | "biomesoplenty:fir_planks" | "powah:crafting/thermo_generator_spirited" | "ad_astra:mars_stone_slab" | "create:small_veridium_brick_stairs" | "tconstruct:smeltery/casting/seared/cobble/wall" | "tconstruct:smeltery/melting/slime/honey_block" | "minecraft:cobblestone_stairs_from_cobblestone_stonecutting" | "railways:crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal" | "ad_astra:cyan_flag" | "minecraft:crimson_door" | "tconstruct:smeltery/melting/metal/manyullyn/ingot" | "create:cut_andesite_bricks_from_stone_types_andesite_stonecutting" | "iceandfire:armor_bronze_chestplate" | "ad_astra:blasting/coal_from_blasting_glacio_coal_ore" | "railways:crafting/conductor_whistle" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_trapdoor" | "create:deploying/copper_block_from_removing_wax" | "ae2:misc/deconstruction_certus_quartz_bricks" | "tconstruct:smeltery/seared/seared_brick_kiln" | "molten_metals:filling/brass_filled_metal_mold" | "create:crafting/logistics/display_link" | "iceandfire:dragonscale_green_to_dragonscales_green" | "simplylight:illuminant_yellow_block_dyed" | "iceandfire:ghost_chest" | "tconstruct:tools/parts/builder/bow_limb" | "tconstruct:smeltery/casting/honey/bottle" | "create:cutting/runtime_generated/compat/tconstruct/skyroot_planks_to_skyroot_sign" | "create:deploying/waxed_copper_shingle_stairs_from_adding_wax" | "minecraft:end_stone_bricks" | "ae2:matter_cannon/nuggets/iron" | "ad_astra:stonecutting/chiseled_venus_stone_slab_from_chiseled_venus_stone_bricks_stonecutting" | "minecraft:red_stained_glass_pane_from_glass_pane" | "ad_astra:stonecutting/polished_moon_stone_stairs_from_polished_moon_stone_stonecutting" | "iceandfire:tide_purple_leggings" | "hexcasting:staff/bamboo" | "tconstruct:tools/modifiers/upgrade/padded" | "minecraft:waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "tconstruct:tools/modifiers/salvage/ability/silky" | "minecraft:black_candle" | "farmersdelight:cutting/nether_bricks" | "ae2:network/cells/item_storage_cell_1k_storage" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_planks_to_pine_fence_gate" | "create:crushing/iron_horse_armor" | "tconstruct:tools/modifiers/salvage/ability/pockets" | "classicpipes:advanced_copper_pipe_b" | "classicpipes:advanced_copper_pipe_a" | "farmersdelight:cutting/cherry_sign" | "tconstruct:smeltery/casting/metal/cobalt/nugget_gold_cast" | "tconstruct:world/wood/skyroot/planks" | "minecraft:dye_brown_wool" | "tconstruct:smeltery/scorched/drain_retextured" | "tconstruct:common/glass/pink_clear_stained_glass_pane_from_panes" | "create:cut_veridium_wall_from_stone_types_veridium_stonecutting" | "iceandfire:dragonarmor_iron_body" | "ad_astra:green_flag" | "minecraft:polished_diorite_stairs_from_polished_diorite_stonecutting" | "farmersdelight:cutting/crimson_stem" | "tconstruct:smeltery/melting/clay/pot" | "sophisticatedbackpacks:advanced_restock_upgrade" | "create:polished_cut_scorchia_slab" | "biomesoplenty:smooth_white_sandstone_slab_from_smooth_white_sandstone_stonecutting" | "iceandfire:dragonforge_lightning_input" | "minecraft:warped_sign" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_planks_to_fir_pressure_plate" | "ad_astra:desh_panel" | "ad_astra:smelting/calorite_ingot_from_smelting_raw_calorite" | "tconstruct:smeltery/melting/obsidian/block" | "ad_astra:moon_stone_brick_stairs" | "tconstruct:common/glass/yellow_clear_stained_glass" | "createaddition:crafting/rolling_mill" | "tconstruct:common/slime/ender/slimeblock" | "tconstruct:smeltery/casting/filling/lingerng_bottle" | "tconstruct:smeltery/seared/seared_stone_slab" | "minecraft:bamboo_sign" | "molten_metals:splashing/zinc_ingot_from_metal_mold" | "tconstruct:smeltery/casting/filling/seared_lantern_full" | "computercraft:turtle_advanced/minecraft/diamond_sword" | "tconstruct:tools/materials/wood/planks/cherry" | "create:crafting/kinetics/spout" | "minecraft:host_armor_trim_smithing_template_smithing_trim" | "tconstruct:smeltery/entity_melting/heads/drowned" | "create:polished_cut_tuff_wall_from_stone_types_tuff_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/stripped_mangrove_log_to_mangrove_planks" | "sophisticatedbackpacks:netherite_backpack" | "minecraft:orange_terracotta" | "create:haunting/soul_torch" | "farmersdelight:integration/create/milling/wild_tomatoes" | "biomesoplenty:jacaranda_fence" | "tconstruct:smeltery/casting/metal/netherite/block" | "tconstruct:common/glass/black_clear_stained_glass_pane_from_panes" | "ae2:network/cables/dense_smart_cyan" | "minecraft:paper" | "minecraft:lime_glazed_terracotta" | "create:cut_scoria_brick_slab_recycling" | "tconstruct:smeltery/melting/metal/iron/weapon" | "create:crafting/logistics/red_table_cloth_clear" | "minecraft:cherry_fence_gate" | "create:crushing/moon_desh_ore" | "hexcasting:dye_colorizer_magenta" | "classicpipes:brick_fluid_pipe_b" | "classicpipes:brick_fluid_pipe_a" | "ad_astra:gas_tank" | "create:cut_calcite_brick_wall" | "ad_astra:chiseled_venus_stone_slab" | "railways:crafting/palettes/dyeing_8x/light_blue_locometal_pillar" | "tconstruct:common/glass/brown_clear_stained_glass_pane_from_panes" | "railways:crafting/palettes/dyeing_1x/white_brass_wrapped_locometal" | "sophisticatedbackpacks:advanced_magnet_upgrade" | "tconstruct:smeltery/melting/metal/zinc/nugget" | "minecraft:dark_oak_button" | "comforts:sleeping_bag_light_blue" | "create:crafting/kinetics/framed_glass_trapdoor" | "createoreexcavation:ore_vein_type/nether_gold" | "create:cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "tconstruct:smeltery/seared/seared_cracked_bricks_smelting" | "railways:crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal_boiler" | "biomesoplenty:maple_sign" | "create:crafting/kinetics/secondary_linear_chassis_from_conversion" | "create:deploying/weathered_copper_shingle_slab_from_removing_wax" | "railways:stonecutting/riveted_locometal" | "tconstruct:tools/modifiers/worktable/extract_modifier_sponge" | "biomesoplenty:maple_trapdoor" | "ad_astra:chiseled_mercury_stone_slab" | "create:cutting/runtime_generated/compat/minecraft/oak_wood_to_stripped_oak_wood" | "tconstruct:gadgets/frame/gold" | "tconstruct:smeltery/melting/slime/ender/bud_cluster" | "create:cutting/runtime_generated/compat/hexcasting/edified_planks_to_edified_fence_gate" | "tconstruct:tools/modifiers/upgrade/hydraulic_from_block" | "ae2:network/parts/panels_semi_dark_monitor" | "minecraft:cracked_deepslate_tiles" | "iceandfire:dragonsteel_ice_helmet" | "biomesoplenty:white_sandstone_wall" | "createoreexcavation:ore_vein_type/netherite" | "create:pressing/desh_ingot" | "tconstruct:tables/crafting_station_from_logs" | "ad_astra:stonecutting/mercury_stone_brick_stairs_from_mercury_stone_bricks_stonecutting" | "tconstruct:tools/modifiers/slotless/embellishment_ichor" | "minecraft:cooked_rabbit" | "tconstruct:tools/parts/casting/small_axe_head_composite" | "railways:crafting/palettes/dyeing_1x/lime_riveted_locometal" | "hexcasting:thought_knot" | "ad_astra:ostrum_ingot" | "biomesoplenty:chiseled_orange_sandstone_from_orange_sandstone_stonecutting" | "minecraft:magenta_banner" | "iceandfire:dragonarmor_silver_head" | "minecraft:mangrove_fence_gate" | "createaddition:crafting/digital_adapter" | "ad_astra:stonecutting/polished_glacio_stone_stairs_from_glacio_stone_stonecutting" | "tconstruct:tools/modifiers/slotless/overslime/ichor_block" | "tconstruct:tools/materials/slimesteel/nugget" | "tconstruct:common/slime/blood/slimeblock" | "ad_astra:iron_plateblock" | "create:milling/lilac" | "createaddition:charging/exposed_copper" | "ae2:network/parts/toggle_bus_alt" | "create:cutting/stripped_glacian_log" | "tconstruct:tools/modifiers/worktable/enchantment_converting/slotless_tool" | "minecraft:iron_block" | "create:cut_granite_brick_wall" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_dead_wood_to_dead_planks" | "ae2:network/cables/covered_brown" | "iceandfire:tide_green_boots" | "minecraft:dark_oak_door" | "ad_astra:calorite_engine" | "tconstruct:common/materials/manyullyn_nugget_from_ingot" | "computercraft:pocket_normal/computercraft/wireless_modem_normal" | "ad_astra:steel_ingot_from_steel_block" | "minecraft:flower_pot" | "create:cutting/runtime_generated/compat/ad_astra/glacian_planks_to_glacian_button" | "create:crafting/schematics/empty_schematic" | "tconstruct:tools/modifiers/salvage/ability/pathing" | "simplylight:rodlamp" | "railways:crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal_boiler" | "create:deploying/weathered_copper_tile_slab_from_removing_wax" | "biomesoplenty:white_sandstone" | "railways:sequenced_assembly/track_ender" | "tconstruct:tools/materials/wood/logs/default" | "minecraft:polished_blackstone_bricks_from_blackstone_stonecutting" | "ad_astra:stonecutting/polished_glacio_stone_from_glacio_stone_stonecutting" | "ae2:network/cables/smart_purple" | "resourcechickens:cooked_catcher_duck_campfire" | "create:cutting/runtime_generated/compat/ad_astra/glacian_planks_to_glacian_slab" | "tconstruct:smeltery/casting/diamond/gem_gold_cast" | "create:exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "classicpipes:spruce_pipe" | "biomesoplenty:umbran_hanging_sign" | "railways:crafting/palettes/dyeing_8x/black_iron_wrapped_locometal_boiler" | "hexal:freeze/blue_ice" | "tconstruct:tools/materials/slimewood/greenheart_planks" | "tconstruct:tools/modifiers/upgrade/bane_of_sssss" | "farmersdelight:red_canvas_sign" | "create:smelting/gold_ingot_from_crushed" | "minecraft:pink_glazed_terracotta" | "tconstruct:smeltery/casting/metal/netherite/nugget_sand_cast" | "create:small_crimsite_brick_slab_recycling" | "tconstruct:tables/tinker_station_damaging/base_one" | "farmersdelight:golden_knife" | "comforts:hammock_to_orange" | "minecraft:orange_stained_glass" | "create:small_andesite_brick_slab_recycling" | "minecraft:exposed_cut_copper_slab" | "farmersdelight:cutting/cabbage" | "create:crafting/materials/rose_quartz" | "biomesoplenty:mahogany_trapdoor" | "minecraft:copper_ingot_from_blasting_deepslate_copper_ore" | "create:crafting/materials/rose_quartz_tiles_from_conversion" | "comforts:hammock_to_gray" | "create:cutting/runtime_generated/compat/minecraft/stripped_warped_stem_to_warped_planks" | "create:crafting/kinetics/controller_rail" | "extendedae:ex_molecular_assembler" | "powah:crafting/magmator_nitro" | "ae2:matter_cannon/nuggets/electrum" | "minecraft:golden_boots" | "create:splashing/runtime_generated/compat/minecraft/black_concrete_powder_to_black_concrete" | "railways:crafting/palettes/dyeing_1x/red_iron_wrapped_locometal" | "iceandfire:summoning_crystal_ice" | "minecraft:pink_dye_from_red_white_dye" | "minecraft:netherite_shovel_smithing" | "simplylight:illuminant_green_block_on_dyed" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_mahogany_wood_to_mahogany_planks" | "tconstruct:smeltery/casting/water/red_concrete" | "ad_astra:steel_door" | "create:crafting/kinetics/clockwork_bearing" | "tconstruct:smeltery/casting/metal/copper/plate_sand_cast" | "railways:crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal" | "minecraft:polished_granite_slab" | "railways:mechanical_crafting/brown_locometal_boiler" | "farmersdelight:cutting/jungle_door" | "railways:crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal" | "minecraft:emerald" | "tconstruct:tools/severing/skeleton_skull" | "ducky-periphs:weather_machine_block" | "farmersdelight:cutting/oxeye_daisy" | "tconstruct:smeltery/casting/scorched/stone_from_magma" | "minecraft:cherry_planks" | "tconstruct:smeltery/seared/chute_retextured" | "railways:crafting/palettes/dyeing_1x/yellow_locometal_pillar" | "ae2:network/crafting/cpu_crafting_accelerator" | "tconstruct:tools/modifiers/ability/spilling" | "minecraft:nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "tconstruct:smeltery/melting/metal/gold/produce" | "minecraft:oak_stairs" | "minecraft:silence_armor_trim_smithing_template" | "minecraft:smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "tconstruct:tools/materials/manyullyn/nugget" | "create:crushing/nether_gold_ore" | "create:cutting/runtime_generated/compat/ad_astra/aeronos_planks_to_aeronos_door" | "ad_astra:small_orange_industrial_lamp" | "tconstruct:common/materials/netherite_nugget_from_ingot" | "minecraft:polished_blackstone_brick_stairs" | "tconstruct:smeltery/melting/metal/electrum/rod" | "tconstruct:smeltery/casts/sand_casts/plates" | "tconstruct:tools/severing/spider_eye" | "railways:crafting/palettes/dyeing_8x/magenta_locometal_boiler" | "iceandfire:mountain_troll_leather_leggings" | "tconstruct:smeltery/melting/seared/reinforcement" | "create:crafting/kinetics/mechanical_saw" | "ae2:network/cells/spatial_components_0" | "tconstruct:tools/modifiers/slotless/recapitated" | "tconstruct:armor/building/slime_skull/string" | "ae2:network/cells/spatial_components_1" | "create:crafting/logistics/andesite_funnel" | "iceandfire:deathworm_yellow_boots" | "biomesoplenty:fir_button" | "create:crafting/logistics/orange_table_cloth" | "farmersdelight:cutting/bamboo_hanging_sign" | "ae2:inscriber/logic_processor_press" | "tconstruct:smeltery/melting/metal/netherite/shovel" | "railways:stonecutting/palettes/cycling/cyan_flat_slashed_locometal" | "hexcasting:scroll_small" | "ad_astra:smelting/cracked_venus_sandstone_bricks_from_smelting_venus_sandstone_bricks" | "minecraft:glass" | "extendedae:ex_io_port" | "create:filling/honeyed_apple" | "iceandfire:armor_green_leggings" | "ae2:tools/portable_fluid_cell_64k" | "create:crushing/deepslate_zinc_ore" | "tconstruct:smeltery/casting/obsidian/nahuatl" | "railways:crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal_boiler" | "iceandfire:sea_serpent_scales_deepblue_to_sea_serpent_scale_block_deepblue" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_stairs" | "iceandfire:dragonsteel_fire_helmet" | "create:crafting/kinetics/nixie_tube" | "ae2:network/cables/smart_red" | "createaddition:crafting/modular_accumulator_gold" | "railways:crafting/palettes/dyeing_8x/light_gray_riveted_locometal" | "tconstruct:smeltery/casting/metal/steel/block" | "minecraft:light_blue_concrete_powder" | "comforts:sleeping_bag_white" | "tconstruct:tools/materials/wood/logs/oak" | "minecraft:granite_stairs" | "create:small_deepslate_brick_slab" | "ad_astra:blasting/lapis_lazuli_from_blasting_glacio_lapis_ore" | "railways:stonecutting/palettes/cycling/orange_locometal_pillar" | "create:haunting/infested_chiseled_stone_bricks" | "ad_astra:yellow_industrial_lamp" | "farmersdelight:cutting/cherry_door" | "create:oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "biomesoplenty:yellow_maple_leaf_pile" | "create:warped_window" | "tconstruct:tools/parts/builder/tool_binding" | "hexcasting:brainsweep/quench_allay" | "create:small_dripstone_brick_slab_recycling" | "tconstruct:smeltery/melting/metal/gold/ore_singular" | "extendedae:epa_upgrade" | "create:crushing/mars_ice_shard_ore" | "farmersdelight:integration/create/milling/wild_rice" | "powah:crafting/energizing_rod_nitro" | "ad_astra:encased_iron_block" | "tconstruct:tools/modifiers/ability/glowing" | "createaddition:mixing/netherrack" | "minecraft:prismarine_bricks" | "tconstruct:smeltery/melting/diamond/enchanting_table" | "iceandfire:armor_silver_metal_leggings" | "create:deploying/copper_shingle_slab_from_deoxidising" | "classicpipes:bamboo_pipe" | "iceandfire:dragon_bone_wall" | "railways:crafting/palettes/dyeing_1x/white_iron_wrapped_locometal_boiler" | "tconstruct:world/wood/greenheart/door" | "minecraft:stone_bricks" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_planks_to_hellbark_slab" | "biomesoplenty:dead_pressure_plate" | "create:cut_crimsite_brick_wall" | "ae2:tools/network_color_applicator" | "ae2:tools/paintballs_cyan" | "iceandfire:dragonarmor_dragon_steel_lightning_head" | "ad_astra:steel_block" | "minecraft:dye_orange_wool" | "iceandfire:tide_teal_leggings" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_fence_gate" | "computercraft:turtle_advanced" | "hexcasting:compat/create/crushing/amethyst_shard" | "classicpipes:bamboo_fluid_pipe_a" | "biomesoplenty:mahogany_fence" | "classicpipes:bamboo_fluid_pipe_b" | "iceandfire:furnace/silver_nugget_blasting" | "create:haunting/blackstone" | "tconstruct:tools/modifiers/salvage/ability/frost_walker" | "create:crafting/logistics/purple_table_cloth_clear" | "biomesoplenty:umbran_boat" | "minecraft:cyan_stained_glass" | "railways:crafting/palettes/dyeing_1x/red_copper_wrapped_locometal" | "hexcasting:quenched_allay_bricks" | "tconstruct:tables/tinker_station" | "minecraft:acacia_fence" | "create:cutting/runtime_generated/compat/minecraft/mangrove_log_to_stripped_mangrove_log" | "biomesoplenty:black_sandstone" | "minecraft:cyan_banner" | "ae2:network/cables/smart_fluix" | "create:veridium_from_stone_types_veridium_stonecutting" | "create:milling/lapis_lazuli" | "create:crafting/materials/copper_nugget" | "tconstruct:armor/building/slime_skull/ender_pearl" | "minecraft:glistering_melon_slice" | "minecraft:warped_door" | "simplylight:illuminant_magenta_block_toggle" | "railways:crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal" | "farmersdelight:cooking/pumpkin_soup" | "railways:crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal_boiler" | "railways:sequenced_assembly/track_stripped_bamboo_narrow" | "minecraft:acacia_fence_gate" | "create:crafting/kinetics/gray_seat" | "create:cut_ochrum_slab" | "create:crafting/materials/zinc_ingot_from_decompacting" | "minecraft:dye_yellow_wool" | "railways:sequenced_assembly/track_cherry_narrow" | "minecraft:magenta_carpet" | "create:crafting/kinetics/contraption_controls" | "ae2:block_cutter/stairs/quartz_pillar_stairs" | "tconstruct:smeltery/melting/metal/brass/ingot" | "ad_astra:steel_factory_block" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_planks_to_willow_stairs" | "create:small_diorite_brick_wall" | "iceandfire:armor_sapphire_helmet" | "farmersdelight:cutting/spruce_sign" | "create:pressing/calorite_ingot" | "create:crafting/logistics/packager" | "tconstruct:smeltery/melting/slime/ichor/congealed" | "create:industrial_iron_window" | "create:polished_cut_granite_from_stone_types_granite_stonecutting" | "farmersdelight:tatami_block_from_full" | "farmersdelight:chocolate_pie_from_slices" | "farmersdelight:cooking/vegetable_noodles" | "hexcasting:quenched_allay_tiles" | "tconstruct:tools/materials/wood/planks/default" | "minecraft:lectern" | "tconstruct:smeltery/seared/seared_bricks_stairs" | "tconstruct:tools/building/pickadze" | "create:cut_andesite_brick_wall" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_planks_to_dark_oak_pressure_plate" | "create:cutting/runtime_generated/compat/tconstruct/stripped_bloodshroom_log_to_bloodshroom_planks" | "minecraft:magenta_dye_from_allium" | "minecraft:smooth_stone_slab" | "simplylight:illuminant_light_blue_block_on_toggle" | "ae2:materials/formationcore" | "iceandfire:dragonsteel_ice_ingot_to_dragonsteel_ice_block" | "create:milling/beetroot" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_button" | "minecraft:dye_lime_wool" | "tconstruct:tools/modifiers/upgrade/thorns" | "railways:crafting/palettes/dyeing_8x/lime_locometal_smokebox" | "ad_astra:space_station/mercury_orbit_space_station" | "tconstruct:smeltery/casting/metal/pig_iron/nugget_gold_cast" | "molten_metals:emptying/molten_gold_from_ceramic_mold" | "tconstruct:common/gold_platform" | "minecraft:mossy_cobblestone_from_vine" | "create:deploying/oxidized_copper_shingles_from_removing_wax" | "ratatouille:mauve_plush" | "railways:crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal_boiler" | "tconstruct:smeltery/melting/fuel/blaze" | "tconstruct:tools/parts/casting/small_axe_head_sand_cast" | "tconstruct:smeltery/melting/metal/cobalt/ingot" | "tconstruct:smeltery/melting/glass/sand" | "tconstruct:smeltery/casting/metal/slimesteel/nugget_sand_cast" | "tconstruct:world/wood/greenheart/button" | "tconstruct:smeltery/seared/duct" | "create:small_andesite_brick_wall" | "iceandfire:banners/banner_pattern_feather" | "create:crafting/kinetics/adjustable_chain_gearshift" | "tconstruct:smeltery/melting/metal/slimesteel/reinforcement" | "biomesoplenty:empyreal_hanging_sign" | "farmersdelight:cutting/acacia_door" | "tconstruct:smeltery/casts/red_sand_casts/pick_head" | "powah:crafting/magmator_basic" | "create:smelting/glass_from_framed_glass" | "tconstruct:tools/materials/steel/block" | "classicpipes:golden_pipe" | "farmersdelight:nether_salad" | "create:crafting/kinetics/steam_engine" | "create:crushing/raw_zinc" | "createaddition:crafting/portable_energy_interface" | "gravestones:gravestone" | "ae2:shaped/walls/quartz_block" | "railways:crafting/palettes/dyeing_1x/purple_slashed_locometal" | "tconstruct:smeltery/casting/metal/manyullyn/block" | "minecraft:polished_blackstone_slab_from_blackstone_stonecutting" | "biomesoplenty:hellbark_planks" | "tconstruct:tools/materials/electrum/ingot" | "powah:crafting/thermo_generator_hardened" | "ae2:network/blocks/energy_energy_acceptor_alt" | "tconstruct:smeltery/casts/red_sand_casts/tool_binding" | "biomesoplenty:mahogany_sign" | "iceandfire:dragonarmor_copper_tail" | "railways:mechanical_crafting/gray_locometal_boiler" | "railways:crafting/palettes/dyeing_8x/blue_plated_locometal" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_log_to_stripped_dark_oak_log" | "minecraft:jungle_chest_boat" | "minecraft:dark_prismarine_slab_from_dark_prismarine_stonecutting" | "tconstruct:smeltery/seared/ingot_gauge" | "comforts:hammock_to_red" | "create:oxidized_copper_shingle_stairs" | "createaddition:crushing/diamond" | "railways:crafting/palettes/dyeing_8x/purple_locometal_boiler" | "farmersdelight:canvas_from_canvas_rug" | "tconstruct:smeltery/casts/red_sand_casts/bow_grip" | "farmersdelight:cooked_bacon_from_smoking" | "railways:dying_existing_cap_magenta" | "tconstruct:smeltery/casting/soup/mushroom" | "create:deploying/oxidized_cut_copper_slab_from_removing_wax" | "powah:crafting/cable_nitro_2" | "minecraft:end_stone_brick_slab" | "tconstruct:tools/parts/casting/round_plate_sand_cast" | "tconstruct:tools/materials/melting/hepatizon" | "createoreexcavation:cutting/emerald_cutting" | "hexcasting:pride_colorizer_lesbian" | "tconstruct:common/glass/vanilla/daylight_detector" | "minecraft:pink_concrete_powder" | "farmersdelight:green_canvas_sign" | "create:layered_scorchia_from_stone_types_scorchia_stonecutting" | "ae2:tools/nether_quartz_cutting_knife" | "railways:crafting/palettes/dyeing_8x/orange_riveted_locometal" | "farmersdelight:light_gray_hanging_canvas_sign" | "railways:mechanical_crafting/brown_brass_wrapped_locometal_boiler" | "ad_astra:polished_moon_stone_stairs" | "tconstruct:smeltery/casting/metal/hepatizon/nugget_sand_cast" | "minecraft:diamond_shovel" | "create:copycat_panel_from_zinc_ingots_stonecutting" | "railways:crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal" | "minecraft:andesite_wall" | "railways:crafting/palettes/dyeing_8x/lime_flat_riveted_locometal" | "railways:crafting/palettes/dyeing_8x/yellow_locometal_smokebox" | "ad_astra:rocket_nose_cone" | "minecraft:raiser_armor_trim_smithing_template_smithing_trim" | "tconstruct:smeltery/melting/metal/amethyst_bronze/block" | "farmersdelight:cutting/acacia_trapdoor" | "powah:crafting/capacitor_basic_tiny" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_door" | "hexical:animated_scroll_small" | "create:cutting/runtime_generated/compat/minecraft/warped_stem_to_stripped_warped_stem" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_planks_to_magic_fence_gate" | "computercraft:turtle_normal/computercraft/wireless_modem_normal" | "iceandfire:dragonbone_sword_lightning" | "create:cut_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "createoreexcavation:drilling/glowstone" | "minecraft:minecart" | "tconstruct:tools/materials/slimewood/greenheart_logs" | "ad_astra:pink_industrial_lamp" | "ad_astra:space_station/mars_orbit_space_station" | "ad_astra:calorite_sliding_door" | "ad_astra:ostrum_plating_button" | "hexcasting:edified_panel" | "tconstruct:armor/building/plate_shield" | "iceandfire:sea_serpent_scale_block_deepblue_to_sea_serpent_scales_deepblue" | "railways:mechanical_crafting/green_brass_wrapped_locometal_boiler" | "railways:crafting/palettes/wrapping/black_brass_wrapped_locometal" | "railways:crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal" | "biomesoplenty:orange_sandstone_slab" | "tconstruct:tools/modifiers/ability/firestarter" | "farmersdelight:cooked_bacon_from_campfire_cooking" | "create:weathered_copper_tile_stairs" | "railways:crafting/palettes/dyeing_8x/cyan_flat_riveted_locometal" | "farmersdelight:cooking/mushroom_rice" | "iceandfire:dread_stone_stairs" | "minecraft:golden_shovel" | "tconstruct:tools/materials/cobalt/block" | "create:deploying/oxidized_copper_tile_stairs_from_removing_wax" | "create:crafting/kinetics/smart_fluid_pipe" | "ae2:blasting/silicon_from_certus_quartz_dust" | "ae2:tools/paintballs_lumen_light_gray" | "create:polished_cut_veridium_from_stone_types_veridium_stonecutting" | "tconstruct:tools/modifiers/slotless/draconic_from_scales" | "computercraft:printed_pages" | "minecraft:brick_wall_from_bricks_stonecutting" | "create:cutting/runtime_generated/compat/ad_astra/strophar_planks_to_strophar_slab" | "railways:stonecutting/palettes/cycling/light_gray_plated_locometal" | "iceandfire:dragonsteel_fire_leggings" | "create:milling/dripstone_block" | "ae2:materials/cardspeed" | "hextended:long/extended_prismarine_staff" | "comforts:sleeping_bag_purple" | "minecraft:brown_glazed_terracotta" | "hexcasting:compat/farmersdelight/cutting/edified_log_aventurine" | "iceandfire:stonecutter/dread_stone_bricks_chiseled" | "powah:crafting/ender_gate_hardened" | "tconstruct:smeltery/casting/metal/cobalt/ingot_gold_cast" | "create:cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "tconstruct:smeltery/casting/seared/chiseled" | "railways:stonecutting/palettes/cycling/red_flat_slashed_locometal" | "iceandfire:armor_electric_helmet" | "create:cut_scoria_wall" | "extendedae:epa" | "simplylight:illuminant_brown_block_toggle" | "minecraft:warped_trapdoor" | "ae2:network/parts/annihilation_plane_alt2" | "ad_astra:smelting/diamond_from_smelting_venus_diamond_ore" | "railways:sequenced_assembly/track_mangrove" | "create:crafting/kinetics/fluid_pipe_vertical" | "ae2:network/cells/spatial_components" | "minecraft:diamond_chestplate" | "tconstruct:tools/modifiers/upgrade/lightspeed_from_block" | "create:crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "create:crafting/kinetics/mechanical_arm" | "ad_astra:glacio_pillar" | "comforts:sleeping_bag_green" | "tconstruct:tools/modifiers/ability/path_maker" | "molten_metals:splashing/netherite_ingot_from_ceramic_mold" | "tconstruct:smeltery/scorched/scorched_bricks_stairs" | "minecraft:birch_sign" | "create:cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "tconstruct:smeltery/scorched/chiseled_scorched_bricks_stonecutting" | "iceandfire:dragonbone_bow" | "create:pressing/path" | "create:cut_asurine_slab_from_stone_types_asurine_stonecutting" | "create:polished_cut_diorite_stairs" | "ae2:materials/cardcapacity" | "extendedae:epp" | "iceandfire:cockatrice_scepter" | "railways:mechanical_crafting/white_locometal_boiler" | "railways:mechanical_crafting/pink_brass_wrapped_locometal_boiler" | "create:crushing/glacio_iron_ore" | "create:crafting/copper/waxed_exposed_copper_tile_stairs_from_honeycomb" | "tconstruct:gadgets/cake/magma" | "minecraft:orange_dye_from_red_yellow" | "simplylight:illuminant_blue_block_on_dyed" | "iceandfire:pixie_wand" | "farmersdelight:food_serving" | "tconstruct:smeltery/seared/seared_bricks_crafting" | "create:cutting/runtime_generated/compat/minecraft/warped_hyphae_to_stripped_warped_hyphae" | "createaddition:smoking/cake_base_baked" | "railways:crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal_boiler" | "create:milling/compat/biomesoplenty/lavender" | "create:cut_diorite_stairs" | "farmersdelight:cooked_cod_slice" | "create:crafting/appliances/netherite_diving_boots" | "create:cutting/runtime_generated/compat/tconstruct/bloodshroom_planks_to_bloodshroom_fence_gate" | "create:crushing/deepslate_lapis_ore" | "ae2:decorative/certus_quartz_bricks" | "tconstruct:smeltery/melting/slime/sky/ball" | "create:crafting/logistics/brown_table_cloth" | "minecraft:light_gray_dye_from_azure_bluet" | "ad_astra:stonecutting/mercury_cobblestone_stairs_from_mercury_cobblestone_stonecutting" | "ad_astra:steel_rod" | "create:cutting/runtime_generated/compat/minecraft/birch_planks_to_birch_door" | "tconstruct:smeltery/melting/metal/netherite/helmet" | "farmersdelight:integration/create/milling/rice_panicle" | "create:small_scoria_brick_slab" | "powah:crafting/furnator_niotic" | "tconstruct:tools/materials/chorus_popped" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_planks_to_willow_fence_gate" | "create:cut_asurine_slab" | "minecraft:magenta_candle" | "tconstruct:smeltery/casts/red_sand_casts/tough_handle" | "create:small_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "create:cutting/runtime_generated/compat/tconstruct/stripped_greenheart_wood_to_greenheart_planks" | "create:crafting/kinetics/weighted_ejector" | "iceandfire:furnace/copper_nugget" | "tconstruct:smeltery/scorched/chiseled_scorched_bricks_crafting" | "tconstruct:tools/modifiers/upgrade/trueshot" | "create:crafting/kinetics/gearbox_from_conversion" | "tconstruct:smeltery/melting/scorched/block" | "create:cutting/runtime_generated/compat/tconstruct/greenheart_planks_to_greenheart_fence_gate" | "iceandfire:stymphalian_feather_bundle" | "ad_astra:glacian_planks" | "minecraft:tnt_minecart" | "tconstruct:tools/modifiers/upgrade/speedy_from_block" | "minecraft:acacia_planks" | "railways:crafting/palettes/dyeing_1x/light_blue_flat_riveted_locometal" | "create:item_application/copper_casing_from_wood" | "create:splashing/stained_glass" | "tconstruct:smeltery/casting/metal/gold/ingot_gold_cast" | "sophisticatedbackpacks:advanced_tool_swapper_upgrade" | "iceandfire:gold_hippogryph_armor" | "minecraft:cherry_button" | "railways:crafting/palettes/wrapping/light_blue_copper_wrapped_locometal" | "powah:energizing/niotic_crystal" | "ad_astra:stonecutting/polished_venus_stone_stairs_from_polished_venus_stone_stonecutting" | "ducky-periphs:duck_block_plastic" | "create:crafting/kinetics/large_water_wheel" | "minecraft:brown_terracotta" | "create:polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "farmersdelight:cutting_board" | "railways:crafting/palettes/dyeing_1x/black_copper_wrapped_locometal_boiler" | "tconstruct:tools/modifiers/upgrade/sweeping_edge" | "minecraft:note_block" | "railways:crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal_boiler" | "iceandfire:furnace/silver_ingot" | "railways:sequenced_assembly/track_blackstone" | "create:smelting/scoria" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_fence" | "molten_metals:mixing/molten_gold_from_ingot_raw" | "ad_astra:nasa_workbench" | "create:crushing/prismarine_crystals" | "ad_astra:alloying/steel_ingot_from_alloying_iron_ingot_and_coals" | "ad_astra:etrionic_capacitor" | "create:layered_limestone_from_stone_types_limestone_stonecutting" | "iceandfire:armor_silver_boots" | "tconstruct:smeltery/scorched/scorched_bricks_from_brick" | "ae2:tools/nether_quartz_axe" | "ae2:block_cutter/slabs/quartz_pillar_slab" | "minecraft:weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:end_crystal" | "ad_astra:small_light_gray_industrial_lamp" | "resourcechickens:egg_block_undo" | "biomesoplenty:stripped_maple_wood" | "tconstruct:smeltery/melting/metal/knightslime/ingot" | "create:deploying/waxed_copper_tile_slab_from_adding_wax" | "tconstruct:armor/building/travelers_pants" | "create:crafting/logistics/light_blue_table_cloth_from_other_table_cloth" | "minecraft:shulker_box" | "computercraft:clear_colour" | "ad_astra:blasting/iron_ingot_from_blasting_moon_iron_ore" | "create:birch_window_pane" | "ae2:network/cables/covered_blue" | "minecraft:white_carpet" | "create:cutting/runtime_generated/compat/ad_astra/glacian_planks_to_glacian_door" | "railways:sequenced_assembly/track_cherry" | "minecraft:mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "iceandfire:stymphalian_arrow" | "powah:crafting/cable_niotic_2" | "minecraft:cracked_stone_bricks" | "tconstruct:tools/modifiers/upgrade/netherite" | "ad_astra:stonecutting/chiseled_mercury_stone_stairs_from_chiseled_mercury_stone_bricks_stonecutting" | "iceandfire:dragonarmor_dragon_steel_lightning_neck" | "ad_astra:strophar_ladder" | "ae2:network/cells/fluid_storage_cell_4k" | "railways:crafting/palettes/dyeing_1x/brown_riveted_locometal" | "minecraft:ender_chest" | "minecraft:magenta_stained_glass" | "railways:crafting/palettes/dyeing_8x/gray_locometal_pillar" | "tconstruct:smeltery/casting/clay/brick_gold_cast" | "ad_astra:glacian_stairs" | "minecraft:iron_trapdoor" | "minecraft:brown_candle" | "ad_astra:chiseled_glacio_stone_stairs" | "tconstruct:armor/building/travelers_chestplate" | "iceandfire:sea_serpent_scale_block_red_to_sea_serpent_scales_red" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_planks_to_hellbark_fence" | "tconstruct:tools/modifiers/salvage/upgrade/thorns" | "tconstruct:common/glass/magenta_clear_stained_glass_pane_from_panes" | "create:crafting/kinetics/track_observer" | "computercraft:pocket_advanced/computercraft/speaker" | "createaddition:rolling/brass_ingot" | "minecraft:acacia_pressure_plate" | "farmersdelight:integration/create/mixing/tomato_sauce_from_mixing" | "hexcasting:amethyst_tiles" | "computercraft:turtle_advanced/minecraft/diamond_hoe" | "agricraft:wooden_rake" | "tconstruct:common/glass/white_clear_stained_glass_pane_from_panes" | "create:crafting/logistics/cyan_postbox_from_other_postbox" | "create:crafting/materials/brass_block_from_compacting" | "createaddition:charging/copper_shingle_stairs" | "minecraft:deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "railways:crafting/palettes/dyeing_8x/gray_locometal_boiler" | "tconstruct:smeltery/melting/metal/iron/nugget_3" | "create:filling/compat/farmersdelight/milk_bottle" | "farmersdelight:cake_from_slices" | "biomesoplenty:mahogany_door" | "create:cut_asurine_brick_stairs" | "create:cut_granite_from_stone_types_granite_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_planks_to_pine_sign" | "minecraft:firework_rocket" | "powah:crafting/solar_panel_blazing" | "tconstruct:world/wood/skyroot/fence_gate" | "minecraft:polished_andesite_slab_from_polished_andesite_stonecutting" | "ae2:network/cables/covered_lime" | "biomesoplenty:stripped_palm_wood" | "create:crafting/kinetics/gearshift" | "tconstruct:tools/parts/builder/small_axe_head" | "ad_astra:oxygen_loading/oxygen_from_oxygen_loading_water" | "tconstruct:smeltery/melting/metal/gold/ore_sparse" | "computercraft:turtle_normal/minecraft/diamond_shovel" | "create:cutting/runtime_generated/compat/ad_astra/aeronos_planks_to_aeronos_trapdoor" | "molten_metals:splashing/lead_ingot_from_ceramic_mold" | "tconstruct:common/materials/amethyst_bronze_ingot_from_block" | "iceandfire:armor_gray_helmet" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_wood_to_stripped_jacaranda_wood" | "minecraft:light_gray_dye_from_gray_white_dye" | "create:crushing/crimsite" | "create:crushing/tuff_recycling" | "iceandfire:tide_red_leggings" | "tconstruct:tools/materials/composite/darkthread" | "sophisticatedbackpacks:advanced_filter_upgrade" | "biomesoplenty:pine_wood" | "iceandfire:sheep_boots" | "minecraft:stripped_birch_wood" | "farmersdelight:roasted_mutton_chops" | "iceandfire:dragonarmor_dragon_steel_fire_tail" | "create:crushing/mars_iron_ore" | "tconstruct:tools/modifiers/upgrade/severing" | "tconstruct:armor/building/slime_skull/darkthread" | "iceandfire:dragonbone_shovel" | "extendedae:ebus_upgrade" | "powah:crafting/player_tranmitter_blazing" | "minecraft:lime_banner" | "railways:sequenced_assembly/lime_conductor_cap" | "tconstruct:tools/severing/earthslime_ball" | "molten_metals:emptying/molten_copper_from_ceramic_mold" | "tconstruct:tools/modifiers/upgrade/necrotic" | "tconstruct:smeltery/casting/metal/pig_iron/block" | "simplylight:illuminant_block_on_dyed" | "minecraft:deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "railways:mechanical_crafting/green_copper_wrapped_locometal_boiler" | "tconstruct:tools/modifiers/ability/ambidextrous" | "create:polished_cut_andesite_wall" | "minecraft:cut_copper_from_copper_block_stonecutting" | "minecraft:polished_andesite_stairs_from_polished_andesite_stonecutting" | "tconstruct:smeltery/melting/metal/gold/enchanted_apple" | "create:polished_cut_veridium_wall_from_stone_types_veridium_stonecutting" | "railways:crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal" | "biomesoplenty:smooth_orange_sandstone_stairs" | "farmersdelight:cabbage_crate" | "iceandfire:armor_blue_helmet" | "biomesoplenty:cut_orange_sandstone" | "create:cut_scoria_from_stone_types_scoria_stonecutting" | "tconstruct:tools/severing/iron_golem_head" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_jacaranda_log_to_jacaranda_planks" | "tconstruct:smeltery/melting/metal/gold/weapon" | "create:polished_cut_asurine_wall" | "classicpipes:iron_fluid_pipe_a" | "classicpipes:iron_fluid_pipe_b" | "tconstruct:smeltery/melting/slime/earth/sling" | "iceandfire:tide_trident" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_door" | "ae2:tools/fluix_axe" | "railways:crafting/palettes/wrapping/cyan_iron_wrapped_locometal" | "farmersdelight:half_tatami_mat" | "tconstruct:smeltery/melting/obsidian/beacon" | "railways:sequenced_assembly/track_spruce_narrow" | "tconstruct:smeltery/casting/metal/brass/ingot_sand_cast" | "tconstruct:smeltery/melting/metal/copper/block" | "classicpipes:cherry_fluid_pipe_b" | "classicpipes:cherry_fluid_pipe_a" | "create:deploying/weathered_copper_from_removing_wax" | "create:crafting/schematics/schematic_and_quill" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_planks_to_hellbark_button" | "biomesoplenty:empyreal_fence_gate" | "ad_astra:polished_glacio_stone_stairs" | "create:milling/compat/biomesoplenty/endbloom" | "powah:crafting/ender_cell_nitro_2" | "classicpipes:matching_pipe_a" | "create:small_ochrum_brick_stairs" | "tconstruct:smeltery/melting/metal/gold/nugget" | "railways:crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal" | "railways:stonecutting/palettes/cycling/lime_locometal_smokebox" | "minecraft:crimson_sign" | "create:crafting/copper/waxed_copper_shingles_from_honeycomb" | "minecraft:stone_brick_slab" | "tconstruct:smeltery/melting/metal/electrum/nugget" | "ae2:tools/paintballs_lumen_blue" | "minecraft:polished_blackstone_pressure_plate" | "railways:crafting/fuel_tank" | "biomesoplenty:blackstone_bulb" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_door" | "railways:crafting/palettes/dyeing_1x/blue_locometal_boiler" | "create:small_andesite_brick_stairs" | "tconstruct:tools/modifiers/slotless/rebalanced_abilities" | "tconstruct:smeltery/casting/metal/zinc/ingot_sand_cast" | "tconstruct:tools/modifiers/ability/trick_quiver" | "ae2:network/cables/glass_lime" | "create:cutting/runtime_generated/compat/minecraft/stripped_oak_log_to_oak_planks" | "iceandfire:silver_hoe" | "iceandfire:dragonsteel_fire_pickaxe" | "create:milling/compat/ae2/sky_stone_block" | "minecraft:stone_slab_from_stone_stonecutting" | "ad_astra:chiseled_mars_stone_slab" | "tconstruct:tools/modifiers/ability/aqua_affinity" | "farmersdelight:cooking/cabbage_rolls" | "ad_astra:desh_block" | "minecraft:gray_glazed_terracotta" | "classicpipes:matching_pipe_c" | "classicpipes:matching_pipe_b" | "create:cutting/runtime_generated/compat/tconstruct/skyroot_planks_to_skyroot_door" | "create:cut_calcite_wall" | "create:cutting/runtime_generated/compat/ad_astra/strophar_planks_to_strophar_trapdoor" | "minecraft:gold_ingot_from_nuggets" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_planks_to_hellbark_trapdoor" | "tconstruct:smeltery/scorched/scorched_bricks_stairs_stonecutter" | "railways:crafting/palettes/wrapping/blue_copper_wrapped_locometal" | "ae2:misc/deconstruction_chiseled_certus_quartz" | "railways:mechanical_crafting/light_blue_iron_wrapped_locometal_boiler" | "create:deploying/oxidized_copper_tiles_from_removing_wax" | "ad_astra:mercury_pillar" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_log_to_stripped_pine_log" | "tconstruct:smeltery/casting/metal/pig_iron/nugget_sand_cast" | "iceandfire:tide_bronze_leggings" | "minecraft:netherite_leggings_smithing" | "farmersdelight:mutton_wrap" | "create:crimson_window_pane" | "tconstruct:smeltery/melting/slime/magma/block" | "tconstruct:tools/materials/melting/copper" | "railways:crafting/palettes/wrapping/blue_iron_wrapped_locometal" | "create:crafting/kinetics/sticky_mechanical_piston" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_planks_to_mahogany_fence" | "minecraft:stone_brick_stairs_from_stone_stonecutting" | "comforts:sleeping_bag_to_light_blue" | "hexcasting:pride_colorizer_agender" | "create:cherry_window_pane" | "create:cutting/runtime_generated/compat/hexcasting/edified_wood_to_stripped_edified_wood" | "hexcasting:pride_colorizer_genderqueer" | "classicpipes:lapis_fluid_pipe_a" | "create:crafting/kinetics/white_sail_from_conversion" | "classicpipes:lapis_fluid_pipe_b" | "tconstruct:smeltery/casting/soup/beetroot" | "railways:crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal_boiler" | "create:cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "tconstruct:smeltery/melting/diamond/horse_armor" | "minecraft:honey_bottle" | "tconstruct:common/glass/black_clear_stained_glass_pane" | "railways:sequenced_assembly/track_biomesoplenty_willow_narrow" | "tconstruct:tools/modifiers/slotless/embellishment_iron_oxidized" | "ad_astra:moon_cobblestone_slab" | "railways:crafting/palettes/dyeing_1x/purple_plated_locometal" | "iceandfire:dragonscale_silver_to_dragonscales_silver" | "minecraft:raw_copper_block" | "minecraft:polished_diorite_from_diorite_stonecutting" | "biomesoplenty:cut_white_sandstone_slab_from_white_sandstone_stonecutting" | "tconstruct:common/copper_platform_waxing_weathered" | "tconstruct:smeltery/melting/seared/ingot_tank" | "railways:crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal_boiler" | "iceandfire:tide_deepblue_helmet" | "create:crafting/kinetics/light_blue_seat_from_other_seat" | "ae2:tools/portable_item_cell_1k" | "tconstruct:tables/pattern" | "tconstruct:smeltery/casting/filling/scorched_ingot_gauge" | "create:crafting/kinetics/gantry_shaft" | "ae2:tools/paintballs_lumen_lime" | "create:splashing/magma_block" | "tconstruct:smeltery/melting/clay/block" | "ae2:network/cables/glass_blue" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_planks_to_palm_stairs" | "create:haunting/infested_deepslate" | "iceandfire:dragonarmor_silver_neck" | "create:crafting/logistics/lime_table_cloth" | "minecraft:lapis_lazuli" | "ad_astra:chiseled_permafrost_brick_stairs" | "tconstruct:smeltery/casts/red_sand_casts/gems" | "tconstruct:smeltery/casting/filling/seared_fuel_tank" | "ae2:tools/portable_item_cell_4k" | "tconstruct:smeltery/casting/scorched/brick_sand_cast" | "tconstruct:smeltery/scorched/scorched_road_smelting" | "biomesoplenty:stripped_hellbark_wood" | "createaddition:pressing/zinc_ingot" | "minecraft:quartz_block" | "railways:stonecutting/palettes/cycling/light_blue_flat_riveted_locometal" | "create:cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "farmersdelight:safety_net" | "tconstruct:armor/building/slime_boots" | "extendedae:ex_drive" | "create:splashing/runtime_generated/compat/minecraft/white_concrete_powder_to_white_concrete" | "farmersdelight:wheat_dough_from_egg" | "ae2:network/cells/fluid_storage_cell_1k" | "hexcasting:stonecutting/slate_tiles" | "ad_astra:stonecutting/polished_permafrost_slab_from_polished_permafrost_stonecutting" | "iceandfire:banners/banner_pattern_amphithere" | "biomesoplenty:palm_boat" | "iceandfire:dragonscales_red_to_dragonscale_red" | "tconstruct:smeltery/casting/metal/zinc/block" | "create:cut_andesite_stairs" | "tconstruct:tools/materials/chain" | "create:deploying/waxed_oxidized_copper_tiles_from_adding_wax" | "iceandfire:raw_silver_to_raw_silver_block" | "resourcechickens:animal_net" | "ducky-periphs:keyboard_customization" | "create:splashing/crushed_raw_gold" | "ad_astra:cheese_block" | "biomesoplenty:palm_pressure_plate" | "biomesoplenty:umbran_fence" | "minecraft:coast_armor_trim_smithing_template" | "railways:crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal" | "minecraft:dune_armor_trim_smithing_template" | "create:crafting/logistics/brown_table_cloth_clear" | "farmersdelight:cutting/orange_tulip" | "tconstruct:tools/materials/casting/cobalt" | "powah:crafting/thermoelectric_plate" | "create:cut_veridium_stairs" | "farmersdelight:cutting/mangrove_door" | "railways:stonecutting/palettes/cycling/red_flat_riveted_locometal" | "createaddition:crafting/biomass_pellet" | "minecraft:polished_blackstone_stairs_from_blackstone_stonecutting" | "railways:sequenced_assembly/track_biomesoplenty_mahogany" | "biomesoplenty:willow_slab" | "tconstruct:tools/parts/casting/pick_head_sand_cast" | "createaddition:mixing/biomass_from_flowers" | "molten_metals:filling/copper_filled_ceramic_mold" | "hexical:media_jar" | "hexcasting:edified_fence" | "ae2:misc/tank_sky_stone" | "minecraft:deepslate_tile_wall" | "iceandfire:lightning_lily_mixture" | "minecraft:polished_deepslate_stairs" | "create:cut_scorchia_slab" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_planks_to_dark_oak_fence" | "ad_astra:glowing_iron_pillar" | "tconstruct:smeltery/melting/metal/gold/clock" | "minecraft:waxed_exposed_cut_copper_slab_from_honeycomb" | "ae2:network/cells/fluid_storage_cell_16k" | "biomesoplenty:jacaranda_slab" | "iceandfire:dragon_meal" | "create:crafting/kinetics/orange_seat_from_other_seat" | "minecraft:white_candle" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "tconstruct:tools/materials/melting/glass" | "ae2:network/crafting/1k_cpu_crafting_storage" | "ad_astra:strophar_slab" | "create:crushing/gold_ore" | "minecraft:cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_fence" | "create:small_asurine_brick_stairs" | "comforts:hammock_to_white" | "create:smelting/zinc_ingot_from_ore" | "tconstruct:smeltery/melting/metal/gold/chestplate" | "computercraft:turtle_advanced/computercraft/wireless_modem_advanced" | "tconstruct:smeltery/casts/sand_casts/hammer_head" | "tconstruct:tools/materials/casting/gold" | "create:crafting/kinetics/mechanical_bearing" | "minecraft:golden_carrot" | "farmersdelight:cutting/stone" | "tconstruct:smeltery/seared/seared_cobble_wall" | "ae2:network/cells/fluid_cell_housing" | "create:polished_cut_limestone_wall_from_stone_types_limestone_stonecutting" | "minecraft:prismarine_wall" | "railways:dying_existing_cap_purple" | "iceandfire:dragonscales_bronze_to_dragonscale_bronze" | "create:cutting/runtime_generated/compat/biomesoplenty/dead_planks_to_dead_trapdoor" | "railways:crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal" | "tconstruct:tools/modifiers/upgrade/swiftstrike_from_shard" | "extendedae:mod_export_bus" | "ad_astra:stonecutting/chiseled_glacio_stone_bricks_from_glacio_stone_bricks_stonecutting" | "create:crafting/kinetics/elevator_pulley" | "create:cutting/runtime_generated/compat/biomesoplenty/umbran_planks_to_umbran_button" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_planks_to_pine_pressure_plate" | "ad_astra:brown_flag" | "create:deploying/exposed_copper_tiles_from_deoxidising" | "iceandfire:dragon_ice_spikes" | "railways:sequenced_assembly/track_biomesoplenty_umbran" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_pressure_plate" | "biomesoplenty:magic_boat" | "farmersdelight:cooking/beetroot_soup" | "extendedae:mod_storage_bus" | "minecraft:magma_cream" | "create:crafting/kinetics/attribute_filter" | "tconstruct:smeltery/entity_melting/blaze" | "tconstruct:smeltery/melting/emerald/block" | "farmersdelight:cutting/bamboo_block" | "railways:crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal_boiler" | "minecraft:blackstone_wall" | "ae2:block_cutter/walls/sky_stone_wall" | "tconstruct:smeltery/melting/metal/soulsteel/ingot" | "computercraft:cable" | "ae2:network/blocks/io_port" | "molten_metals:splashing/electrum_ingot_from_ceramic_mold" | "tconstruct:common/materials/queens_slime_ingot_from_block" | "tconstruct:smeltery/casting/metal/queens_slime/nugget_gold_cast" | "tconstruct:tools/building/dagger" | "tconstruct:tools/modifiers/upgrade/haste_from_dust" | "powah:crafting/cable_blazing" | "railways:mechanical_crafting/magenta_brass_wrapped_locometal_boiler" | "tconstruct:armor/repair/slimesuit_station" | "minecraft:dried_kelp_from_smelting" | "createaddition:compat/tconstruct/tinkers_bronze" | "railways:crafting/palettes/dyeing_8x/cyan_flat_slashed_locometal" | "ae2:misc/deconstruction_certus_quartz_block" | "minecraft:cherry_sign" | "tconstruct:smeltery/melting/metal/gold/bell" | "railways:crafting/palettes/dyeing_1x/lime_locometal_pillar" | "railways:crafting/palettes/dyeing_8x/blue_flat_riveted_locometal" | "create:crushing/deepslate_gold_ore" | "biomesoplenty:palm_stairs" | "ad_astra:stonecutting/venus_sandstone_bricks_from_venus_sandstone_stonecutting" | "create:crafting/logistics/light_blue_table_cloth" | "railways:mechanical_crafting/lime_brass_wrapped_locometal_boiler" | "tconstruct:world/wood/bloodshroom/fence_gate" | "create:crafting/kinetics/purple_seat" | "farmersdelight:onion_crate" | "tconstruct:tools/modifiers/salvage/upgrade/feather_falling" | "railways:sequenced_assembly/orange_conductor_cap" | "railways:sequenced_assembly/track_biomesoplenty_palm_narrow" | "computercraft:computer_normal" | "railways:crafting/palettes/wrapping/green_iron_wrapped_locometal" | "create:crafting/materials/brass_ingot_from_compacting" | "hextended:long/extended_bamboo" | "tconstruct:tools/materials/pig_iron/block" | "create:crushing/venus_diamond_ore" | "tconstruct:tools/materials/rotten_flesh" | "farmersdelight:cutting/saddle" | "minecraft:dye_blue_carpet" | "railways:crafting/palettes/dyeing_1x/lime_locometal_boiler" | "railways:crafting/palettes/dyeing_1x/magenta_locometal_pillar" | "farmersdelight:cutting/cherry_hanging_sign" | "simplylight:illuminant_red_block_on_toggle" | "minecraft:exposed_cut_copper_stairs" | "create:crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "agricraft:magnifying_glass" | "create:polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "railways:crafting/palettes/dyeing_8x/white_brass_wrapped_locometal" | "tconstruct:common/glass/red_clear_stained_glass_pane" | "minecraft:jungle_boat" | "minecraft:stripped_mangrove_wood" | "create:crafting/logistics/black_table_cloth_from_other_table_cloth" | "tconstruct:tools/materials/silver/ingot" | "sophisticatedbackpacks:advanced_feeding_upgrade" | "railways:sequenced_assembly/magenta_conductor_cap" | "minecraft:light_weighted_pressure_plate" | "ad_astra:ostrum_pillar" | "iceandfire:dragonsteel_ice_shovel" | "iceandfire:furnace/silver_ingot_blasting" | "minecraft:dye_green_wool" | "create:crafting/appliances/netherite_diving_helmet" | "create:cutting/runtime_generated/compat/create/tag_runtime_generated/compat/hexcasting/edified_to_edified_planks" | "railways:crafting/palettes/dyeing_1x/pink_locometal_pillar" | "create:cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "create:crafting/logistics/brown_postbox_from_other_postbox" | "create:deploying/weathered_cut_copper_stairs_from_deoxidising" | "sophisticatedbackpacks:diamond_backpack" | "minecraft:black_stained_glass_pane_from_glass_pane" | "minecraft:pink_banner" | "create:polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "minecraft:bamboo_button" | "tconstruct:common/fantastic_foundry" | "create:cut_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "minecraft:copper_ingot_from_waxed_copper_block" | "extendedae:ingredient_buffer" | "ae2:shaped/slabs/quartz_bricks" | "ae2:block_cutter/slabs/sky_stone_small_brick_slab" | "create:cut_deepslate_slab_recycling" | "railways:mechanical_crafting/red_iron_wrapped_locometal_boiler" | "minecraft:cherry_trapdoor" | "tconstruct:common/slime/earth/crystal_growing" | "tconstruct:tools/materials/manyullyn/block" | "powah:crafting/energizing_rod_basic" | "tconstruct:smeltery/casting/emerald/block" | "comforts:sleeping_bag_to_cyan" | "ad_astra:steel_sliding_door" | "create:splashing/ice" | "minecraft:acacia_trapdoor" | "tconstruct:world/wood/bloodshroom/slab" | "ae2:block_cutter/walls/smooth_quartz_wall" | "create:deploying/exposed_copper_tile_slab_from_deoxidising" | "railways:crafting/palettes/dyeing_1x/light_blue_riveted_locometal" | "tconstruct:smeltery/melting/diamond/jukebox" | "minecraft:cut_copper_slab_from_cut_copper_stonecutting" | "create:crafting/kinetics/empty_blaze_burner" | "create:cutting/runtime_generated/compat/minecraft/stripped_spruce_log_to_spruce_planks" | "railways:stonecutting/palettes/cycling/cyan_flat_riveted_locometal" | "ad_astra:ostrum_factory_block" | "tconstruct:tools/materials/wood/planks/jungle" | "minecraft:cracked_nether_bricks" | "railways:crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal_boiler" | "railways:stonecutting/palettes/cycling/white_locometal_smokebox" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_wood_to_stripped_redwood_wood" | "farmersdelight:cutting/bamboo_sign" | "ae2:tools/matter_cannon" | "minecraft:purpur_pillar_from_purpur_block_stonecutting" | "tconstruct:smeltery/melting/slime/ender/crystal_block" | "ad_astra:stonecutting/venus_stone_brick_stairs_from_venus_stone_bricks_stonecutting" | "railways:sequenced_assembly/track_biomesoplenty_magic_wide" | "ad_astra:permafrost_tiles" | "tconstruct:smeltery/melting/metal/gold/nugget_3" | "create:small_calcite_bricks_from_stone_types_calcite_stonecutting" | "simplylight:illuminant_block" | "create:copper_shingle_stairs" | "tconstruct:smeltery/melting/metal/copper/nugget" | "ae2:network/cables/glass_red" | "minecraft:copper_ingot_from_smelting_copper_ore" | "tconstruct:armor/building/slimelytra" | "tconstruct:tables/tinker_station_damaging/lingering_one" | "tconstruct:smeltery/casting/metal/hepatizon/nugget_gold_cast" | "tconstruct:smeltery/melting/metal/knightslime/nugget" | "create:haunting/glow_berries" | "railways:crafting/palettes/dyeing_1x/lime_flat_slashed_locometal" | "railways:crafting/palettes/dyeing_1x/magenta_slashed_locometal" | "create:small_granite_bricks_from_stone_types_granite_stonecutting" | "minecraft:iron_pickaxe" | "ae2:shaped/not_so_mysterious_cube" | "powah:crafting/reactor_niotic" | "tconstruct:smeltery/casting/metal/knightslime/nugget_sand_cast" | "tconstruct:tools/parts/builder/hammer_head" | "iceandfire:packed_ice" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_slab" | "minecraft:spruce_button" | "create:cut_andesite_from_stone_types_andesite_stonecutting" | "ae2:network/cables/glass_orange" | "ae2:materials/cardinverter" | "create:splashing/runtime_generated/compat/minecraft/lime_concrete_powder_to_lime_concrete" | "ad_astra:stonecutting/mercury_stone_brick_slab_from_mercury_stone_bricks_stonecutting" | "railways:crafting/copycat_headstock_link_and_pin" | "createoreexcavation:ore_vein_type/zinc" | "powah:crafting/ender_gate_spirited" | "ae2:network/cells/fluid_storage_cell_256k_storage" | "create:crushing/asurine" | "factory_blocks:mason_table_old" | "minecraft:deepslate_tiles" | "molten_metals:emptying/molten_iron_from_ceramic_mold" | "powah:crafting/reactor_starter" | "tconstruct:smeltery/seared/chute" | "biomesoplenty:blackstone_spines_from_blackstone_stonecutting" | "tconstruct:gadgets/frame/diamond" | "simplylight:illuminant_black_block_on_dyed" | "minecraft:polished_diorite_stairs" | "minecraft:nether_brick_stairs_from_nether_bricks_stonecutting" | "ad_astra:stonecutting/glacio_cobblestone_slab_from_glacio_cobblestone_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_planks_to_fir_trapdoor" | "ad_astra:mercury_stone_brick_wall" | "tconstruct:smeltery/scorched/channel" | "classicpipes:mod_label" | "railways:crafting/palettes/dyeing_8x/light_gray_plated_locometal" | "comforts:hammock_orange" | "minecraft:dark_oak_slab" | "ad_astra:moon_stone_bricks" | "railways:crafting/palettes/dyeing_8x/orange_slashed_locometal" | "railways:crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal_boiler" | "hexpigmentplus:magician_hat_old" | "tconstruct:smeltery/casting/metal/steel/nugget_gold_cast" | "sophisticatedbackpacks:inception_upgrade" | "iceandfire:tide_teal_chestplate" | "powah:crafting/blank_card_2" | "minecraft:lime_stained_glass" | "iceandfire:furnace/silver_nugget" | "minecraft:stone_brick_walls_from_stone_stonecutting" | "create:crafting/copper/waxed_exposed_copper_shingle_slab_from_honeycomb" | "tconstruct:smeltery/casting/metal/gold/ingot_sand_cast" | "ae2:network/cables/covered_fluix_clean" | "tconstruct:smeltery/casting/metal/brass/rod_sand_cast" | "create:splashing/sand" | "tconstruct:tools/materials/melting/scorched_stone" | "factory_blocks:factory" | "ae2:network/blocks/spatial_io_pylon" | "railways:crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal" | "ad_astra:venus_stone_slab" | "minecraft:yellow_dye_from_dandelion" | "railways:crafting/palettes/dyeing_1x/light_blue_locometal_pillar" | "create:item_application/bound_cardboard_inworld" | "biomesoplenty:mahogany_slab" | "iceandfire:tide_blue_helmet" | "tconstruct:smeltery/melting/metal/steel/plates" | "minecraft:sentry_armor_trim_smithing_template_smithing_trim" | "hexcasting:focus_rotated" | "tconstruct:smeltery/casting/metal/pig_iron/ingot_gold_cast" | "tconstruct:smeltery/melting/metal/gold/plate" | "tconstruct:smeltery/seared/ingot_tank" | "railways:crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal" | "farmersdelight:cutting/spruce_trapdoor" | "create:mixing/lava_from_cobble" | "create:splashing/wheat_flour" | "tconstruct:smeltery/casting/scorched/glass_pane" | "ad_astra:stonecutting/venus_stone_brick_wall_from_venus_stone_bricks_stonecutting" | "create:crafting/kinetics/item_drain" | "create:deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:eye_armor_trim_smithing_template" | "iceandfire:sapphire_gem_to_sapphire_block" | "tconstruct:smeltery/alloys/molten_obsidian_from_soup" | "powah:smelting/uraninite_from_raw" | "create:cut_tuff_brick_wall" | "tconstruct:smeltery/melting/metal/iron/tripwire" | "iceandfire:frost_troll_leather_boots" | "farmersdelight:cutting/warped_door" | "simplylight:illuminant_magenta_block_on_dyed" | "ad_astra:stonecutting/chiseled_mars_stone_bricks_from_mars_stone_stonecutting" | "railways:sequenced_assembly/track_oak_narrow" | "create:crafting/appliances/crafting_blueprint" | "create:crushing/veridium" | "create:cutting/runtime_generated/compat/minecraft/mangrove_planks_to_mangrove_fence_gate" | "tconstruct:tools/modifiers/salvage/ability/boundless" | "ae2:tools/network_memory_card" | "railways:crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal_boiler" | "ae2:network/cells/spatial_storage_cell_128_cubed" | "minecraft:polished_blackstone_brick_slab_from_blackstone_stonecutting" | "railways:crafting/palettes/dyeing_1x/blue_riveted_locometal" | "create:cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "railways:stonecutting/palettes/cycling/brown_riveted_locometal" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "create:deploying/cogwheel" | "create:horizontal_framed_glass_pane" | "molten_metals:splashing/brass_ingot_from_metal_mold" | "powah:crafting/player_tranmitter_spirited" | "minecraft:mangrove_button" | "railways:stonecutting/palettes/cycling/orange_flat_slashed_locometal" | "create:cutting/runtime_generated/compat/minecraft/spruce_planks_to_spruce_slab" | "tconstruct:smeltery/seared/seared_bricks_stairs_stonecutter" | "ad_astra:cheese" | "tconstruct:smeltery/casting/metal/gold/plate_gold_cast" | "powah:crafting/energy_hopper_blazing" | "minecraft:yellow_bed" | "tconstruct:smeltery/casting/metal/iron/nugget_sand_cast" | "comforts:sleeping_bag_pink" | "tconstruct:smeltery/casting/metal/iron/plate_sand_cast" | "tconstruct:tools/modifiers/salvage/upgrade/shield_strap" | "minecraft:nether_brick_slab_from_nether_bricks_stonecutting" | "iceandfire:deathworm_gauntlet_white" | "minecraft:waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "create:filling/grass_block" | "tconstruct:common/slime/earth/crystal_block" | "minecraft:cooked_salmon_from_smoking" | "railways:sequenced_assembly/track_dark_oak" | "ae2:network/cables/dense_covered_fluix_clean" | "comforts:hammock_magenta" | "createaddition:pressing/electrum_ingot" | "minecraft:bamboo_mosaic" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_door" | "create:polished_cut_dripstone_slab_recycling" | "create:layered_crimsite_from_stone_types_crimsite_stonecutting" | "railways:crafting/palettes/dyeing_1x/gray_locometal_boiler" | "farmersdelight:cutting/jungle_trapdoor" | "ae2:network/cables/covered_fluix" | "create:cut_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "minecraft:purple_candle" | "create:asurine_from_stone_types_asurine_stonecutting" | "create:deploying/exposed_cut_copper_from_deoxidising" | "tconstruct:smeltery/melting/metal/rose_gold/ingot" | "iceandfire:blindfold" | "railways:crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal" | "tconstruct:smeltery/seared/seared_fancy_bricks_crafting" | "hexcasting:impetus/empty" | "minecraft:mossy_stone_brick_slab" | "createaddition:rolling/iron_ingot" | "ad_astra:stonecutting/chiseled_mercury_stone_bricks_from_mercury_stone_bricks_stonecutting" | "tconstruct:smeltery/seared/seared_glass" | "tconstruct:tools/severing/sheep_wool" | "ad_astra:moon_stone_stairs" | "minecraft:polished_blackstone_wall_from_polished_blackstone_stonecutting" | "tconstruct:tools/modifiers/slotless/rebalanced_defense" | "railways:sequenced_assembly/track_biomesoplenty_magic_narrow" | "tconstruct:smeltery/casts/red_sand_casts/small_axe_head" | "ae2:tools/nether_quartz_spade" | "railways:crafting/palettes/dyeing_1x/white_locometal_boiler" | "iceandfire:deathworm_red_leggings" | "create:crafting/kinetics/chain_conveyor" | "sophisticatedbackpacks:crafting_upgrade" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_wood_to_stripped_hellbark_wood" | "extendedae:u_terminal/upgrade" | "tconstruct:smeltery/casts/sand_casts/nuggets" | "railways:crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal" | "ae2:network/cells/fluid_storage_cell_1k_storage" | "create:small_tuff_brick_slab" | "railways:crafting/palettes/dyeing_8x/gray_flat_riveted_locometal" | "railways:crafting/palettes/wrapping/brass_wrapped_locometal" | "railways:crafting/palettes/wrapping/gray_copper_wrapped_locometal" | "comforts:sleeping_bag_to_orange" | "minecraft:cobblestone_stairs" | "hexcasting:pride_colorizer_nonbinary" | "simplylight:illuminant_red_block_toggle" | "create:cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "tconstruct:smeltery/casting/slime/earth/dirt" | "create:cut_scorchia_brick_wall" | "create:crafting/curiosities/toolbox_dyeing" | "ae2:tools/paintballs_lumen_red" | "tconstruct:smeltery/melting/metal/brass/nugget" | "ae2:shaped/slabs/fluix_block" | "tconstruct:tools/modifiers/ability/slurping" | "farmersdelight:cutting/warped_hyphae" | "tconstruct:tools/modifiers/defense/revitalizing" | "ae2:shaped/walls/sky_stone_small_brick" | "create:cutting/runtime_generated/compat/minecraft/stripped_crimson_hyphae_to_crimson_planks" | "tconstruct:smeltery/casting/scorched/brick_composite" | "create:polished_cut_scoria_slab_recycling" | "minecraft:polished_basalt" | "create:cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:mechanical_crafting/crushing_wheel" | "biomesoplenty:empyreal_button" | "create:small_andesite_brick_slab" | "hexcasting:slate_amethyst_bricks" | "minecraft:sentry_armor_trim_smithing_template" | "tconstruct:common/materials/cobalt_ingot_smelting" | "railways:crafting/palettes/dyeing_1x/red_plated_locometal" | "createaddition:charging/copper_shingles" | "create:crafting/copper/waxed_exposed_copper_tiles_from_honeycomb" | "create:cutting/runtime_generated/compat/biomesoplenty/dead_planks_to_dead_sign" | "create:cut_andesite_slab_recycling" | "minecraft:polished_andesite_slab" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_planks_to_redwood_trapdoor" | "ae2:network/cables/dense_covered_lime" | "create:crafting/logistics/redstone_requester" | "tconstruct:armor/repair/travelers_leather_station" | "tconstruct:smeltery/melting/metal/cobalt/seared_duct" | "railways:crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal" | "iceandfire:furnace/dread_stone_bricks_cracked" | "tconstruct:smeltery/casting/slime/ender/congealed" | "ad_astra:stonecutting/glacio_pillar_from_glacio_stone_stonecutting" | "tconstruct:smeltery/scorched/lantern" | "extendedae:ei_alt" | "create:cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "create:deploying/waxed_oxidized_cut_copper_from_adding_wax" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_palm_wood_to_palm_planks" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_planks_to_dark_oak_door" | "iceandfire:dragonarmor_diamond_body" | "railways:mechanical_crafting/red_brass_wrapped_locometal_boiler" | "powah:crafting/battery_starter" | "ae2:shaped/slabs/sky_stone_block" | "tconstruct:tools/materials/melting/gold" | "railways:stonecutting/palettes/cycling/magenta_flat_riveted_locometal" | "minecraft:yellow_candle" | "iceandfire:tide_bronze_helmet" | "create:deploying/waxed_exposed_copper_shingle_slab_from_adding_wax" | "tconstruct:smeltery/casting/metal/copper/rod_gold_cast" | "tconstruct:tools/modifiers/upgrade/knockback_armor" | "create:crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "minecraft:repeater" | "minecraft:red_concrete_powder" | "railways:stonecutting/palettes/cycling/blue_flat_riveted_locometal" | "hextended:long/extended_cherry" | "createaddition:charging/copper_block" | "create:polished_cut_limestone_slab" | "hexcasting:staff/edified" | "powah:crafting/crystal_nitro" | "ad_astra:mercury_stone_brick_slab" | "tconstruct:smeltery/alloys/molten_obsidian" | "create:weathered_copper_shingle_slab_from_weathered_copper_shingles_stonecutting" | "tconstruct:common/materials/hepatizon_ingot_from_block" | "minecraft:iron_leggings" | "ad_astra:steel_cable" | "create:rose_quartz_block_from_rose_quartz_stonecutting" | "railways:crafting/palettes/dyeing_8x/green_flat_riveted_locometal" | "simplylight:edge_light_bottom_from_top" | "minecraft:book_cloning" | "powah:crafting/dielectric_rod_2" | "tconstruct:smeltery/entity_melting/heads/creeper" | "ae2:tools/paintballs_white" | "tconstruct:smeltery/melting/slime/ichor/ball" | "tconstruct:smeltery/melting/metal/netherite/ingot" | "tconstruct:smeltery/melting/emerald/ore_singular" | "tconstruct:tools/modifiers/salvage/ability/bouncy" | "create:cut_andesite_wall_from_stone_types_andesite_stonecutting" | "railways:crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal" | "railways:crafting/palettes/dyeing_8x/blue_locometal_boiler" | "minecraft:mushroom_stew" | "farmersdelight:cooked_mutton_chops_from_smoking" | "create:crafting/kinetics/analog_lever" | "create:andesite_scaffolding_from_andesite_alloy_stonecutting" | "create:deploying/waxed_exposed_cut_copper_slab_from_adding_wax" | "create:smelting/zinc_ingot_from_crushed" | "tconstruct:armor/building/slime_skull/iron" | "tconstruct:tables/tinker_station_damaging/splash_two" | "tconstruct:smeltery/casting/metal/slimesteel/ingot_gold_cast" | "ad_astra:red_industrial_lamp" | "molten_metals:splashing/steel_ingot_from_metal_mold_dreams" | "ae2:block_cutter/stairs/quartz_brick_stairs" | "minecraft:dye_white_carpet" | "ae2:shaped/stairs/fluix_block" | "ae2:network/cables/dense_covered_blue" | "railways:crafting/palettes/dyeing_1x/cyan_flat_riveted_locometal" | "ad_astra:ostrum_plating" | "ad_astra:chiseled_mars_stone_stairs" | "railways:crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal_boiler" | "create:crafting/logistics/content_observer" | "tconstruct:smeltery/melting/amethyst/bud_medium" | "ae2:block_cutter/slabs/quartz_slab" | "tconstruct:common/materials/slimesteel_nugget_from_ingot" | "create:copper_tile_stairs_from_copper_tiles_stonecutting" | "biomesoplenty:pine_hanging_sign" | "railways:crafting/palettes/dyeing_8x/black_locometal_boiler" | "ad_astra:oxygen_loading/oxygen_from_oxygen_loading_oxygen" | "biomesoplenty:brimstone_bricks" | "minecraft:jungle_door" | "railways:crafting/palettes/dyeing_1x/purple_locometal_boiler" | "minecraft:prismarine_brick_slab" | "farmersdelight:full_tatami_mat" | "minecraft:nether_bricks" | "biomesoplenty:willow_planks" | "minecraft:iron_chestplate" | "create:milling/compat/biomesoplenty/orange_sandstone" | "tconstruct:smeltery/casting/seared/cobble/block" | "comforts:sleeping_bag_to_pink" | "tconstruct:tools/parts/casting/small_axe_head_gold_cast" | "createaddition:filling/chocolate_cake" | "create:cut_veridium_slab" | "minecraft:lapis_lazuli_from_blasting_deepslate_lapis_ore" | "ad_astra:stonecutting/chiseled_moon_stone_bricks_from_moon_stone_stonecutting" | "tconstruct:smeltery/casting/metal/netherite/nugget_gold_cast" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_fir_log_to_fir_planks" | "create:cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "farmersdelight:rope" | "tconstruct:tools/modifiers/salvage/defense/projectile_protection" | "biomesoplenty:dead_fence_gate" | "minecraft:vex_armor_trim_smithing_template" | "hexpigmentplus:magician_hat_medieval" | "tconstruct:armor/building/plate_boots" | "ae2:network/cells/item_storage_components_cell_256k_part" | "ad_astra:polished_permafrost_slab" | "railways:stonecutting/palettes/cycling/green_slashed_locometal" | "biomesoplenty:stripped_magic_wood" | "minecraft:polished_andesite_from_andesite_stonecutting" | "tconstruct:smeltery/casting/quartz/granite" | "ad_astra:stonecutting/mars_stone_brick_stairs_from_mars_stone_bricks_stonecutting" | "minecraft:crimson_stairs" | "railways:crafting/palettes/wrapping/gray_brass_wrapped_locometal" | "create:cut_granite_slab_recycling" | "minecraft:mud_brick_slab_from_mud_bricks_stonecutting" | "create:deploying/waxed_oxidized_copper_shingle_stairs_from_adding_wax" | "tconstruct:smeltery/casting/seared/smeltery_controller" | "create:crafting/kinetics/gray_valve_handle_from_other_valve_handle" | "tconstruct:smeltery/casting/metal/steel/rod_gold_cast" | "railways:stonecutting/palettes/cycling/cyan_locometal_smokebox" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_planks_to_redwood_sign" | "ae2:misc/chests_smooth_sky_stone" | "minecraft:stone_brick_stairs" | "hexcasting:edified_tile" | "tconstruct:tools/severing/rabbit_foot" | "computercraft:turtle_advanced/computercraft/wireless_modem_normal" | "minecraft:polished_blackstone_wall_from_blackstone_stonecutting" | "minecraft:smooth_stone_slab_from_smooth_stone_stonecutting" | "create:cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "create:crafting/kinetics/light_blue_seat" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_stairs" | "ad_astra:venus_stone_stairs" | "ad_astra:stonecutting/polished_permafrost_stairs_from_polished_permafrost_stonecutting" | "iceandfire:deathworm_yellow_chestplate" | "minecraft:clock" | "tconstruct:tools/materials/amethyst_bronze/block" | "classicpipes:advanced_copper_fluid_pipe_a" | "create:crafting/appliances/netherite_diving_helmet_from_netherite" | "create:crafting/logistics/blue_table_cloth_clear" | "railways:sequenced_assembly/track_biomesoplenty_mahogany_wide" | "ad_astra:stonecutting/polished_moon_stone_stairs_from_moon_stone_stonecutting" | "tconstruct:tools/modifiers/salvage/defense/melee_protection" | "ad_astra:stonecutting/polished_mercury_stone_from_mercury_stone_stonecutting" | "classicpipes:advanced_copper_fluid_pipe_b" | "comforts:sleeping_bag_light_gray" | "railways:crafting/palettes/wrapping/white_brass_wrapped_locometal" | "ad_astra:mercury_stone_bricks" | "ad_astra:calorite_pillar" | "biomesoplenty:brimstone_brick_slab_from_brimstone_stonecutting" | "railways:crafting/palettes/dyeing_8x/cyan_locometal_boiler" | "tconstruct:tools/modifiers/worktable/enchantment_converting/unenchant_tool" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_hellbark_log_to_hellbark_planks" | "tconstruct:smeltery/casting/metal/gold/block" | "iceandfire:dragonforge/dragonsteel_fire_ingot" | "ad_astra:glacio_stone_stairs" | "biomesoplenty:mahogany_button" | "biomesoplenty:purple_dye_from_lavender" | "minecraft:blue_ice" | "create:cutting/runtime_generated/compat/biomesoplenty/maple_planks_to_maple_fence" | "ae2:block_cutter/stairs/quartz_stairs" | "railways:benchcart" | "tconstruct:smeltery/casts/gold_casts/repair_kit" | "tconstruct:smeltery/scorched/scorched_road_stairs_stonecutter" | "minecraft:diamond_leggings" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_planks_to_empyreal_fence_gate" | "ad_astra:iron_plating" | "create:cutting/runtime_generated/compat/ad_astra/glacian_planks_to_glacian_pressure_plate" | "tconstruct:smeltery/melting/diamond/weapon" | "create:deploying/exposed_cut_copper_stairs_from_removing_wax" | "ad_astra:blasting/ice_shard_from_blasting_mars_ice_shard_ore" | "tconstruct:tools/modifiers/salvage/upgrade/severing" | "minecraft:purple_stained_glass" | "create:crushing/diamond_ore" | "railways:crafting/palettes/wrapping/pink_brass_wrapped_locometal" | "minecraft:cut_copper_stairs" | "powah:crafting/energy_cell_niotic" | "tconstruct:smeltery/casts/sand_casts/small_axe_head" | "tconstruct:smeltery/melting/metal/iron/boots" | "railways:sequenced_assembly/track_biomesoplenty_hellbark" | "iceandfire:tide_green_chestplate" | "computercraft:turtle_normal/computercraft/speaker" | "railways:stonecutting/palettes/cycling/brown_plated_locometal" | "create:polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "tconstruct:smeltery/casting/slime/sky/slimeball" | "create:cutting/runtime_generated/compat/minecraft/acacia_log_to_stripped_acacia_log" | "minecraft:polished_andesite_slab_from_andesite_stonecutting" | "minecraft:dye_black_bed" | "create:cut_asurine_brick_slab" | "railways:crafting/palettes/dyeing_1x/blue_locometal_smokebox" | "biomesoplenty:empyreal_chest_boat" | "create:milling/sunflower" | "minecraft:mossy_stone_bricks_from_moss_block" | "minecraft:orange_banner" | "farmersdelight:cutting/birch_trapdoor" | "molten_metals:splashing/copper_ingot_from_ceramic_mold" | "minecraft:dark_oak_sign" | "ad_astra:polished_mercury_stone_slab" | "hexcasting:stonecutting/slate_bricks_small" | "farmersdelight:iron_nugget_from_smelting_knife" | "ad_astra:smelting/ostrum_ingot_from_smelting_raw_ostrum" | "minecraft:oak_hanging_sign" | "biomesoplenty:dead_planks" | "createoreexcavation:ore_vein_type/gold" | "tconstruct:tools/modifiers/ability/reach" | "minecraft:brick_slab_from_bricks_stonecutting" | "create:crafting/logistics/item_hatch" | "tconstruct:tools/modifiers/salvage/ability/firestarter" | "create:crafting/logistics/stock_link_clear" | "iceandfire:dragonsteel_ice_hoe" | "tconstruct:tools/modifiers/upgrade/power" | "minecraft:polished_blackstone_button" | "railways:stonecutting/palettes/cycling/black_slashed_locometal" | "railways:crafting/palettes/dyeing_8x/cyan_locometal_smokebox" | "createaddition:rolling/copper_ingot" | "farmersdelight:cutting/quartz_block" | "powah:crafting/dielectric_rod_h" | "computercraft:disk" | "create:crafting/kinetics/mechanical_piston" | "create:limestone_from_stone_types_limestone_stonecutting" | "create:milling/compat/ae2/fluix_crystal" | "tconstruct:smeltery/casting/metal/gold/nugget_sand_cast" | "minecraft:lime_stained_glass_pane_from_glass_pane" | "minecraft:magenta_glazed_terracotta" | "farmersdelight:cutting/leather_chestplate" | "biomesoplenty:brimstone_brick_stairs_from_brimstone_stonecutting" | "farmersdelight:bacon_sandwich" | "railways:crafting/palettes/dyeing_1x/black_flat_slashed_locometal" | "minecraft:wooden_shovel" | "iceandfire:epic_dragon_seeker" | "createoreexcavation:vein_atlas" | "tconstruct:smeltery/casting/metal/rose_gold/nugget_gold_cast" | "create:crafting/kinetics/fluid_pipe" | "powah:crafting/ender_gate_niotic_2" | "classicpipes:flint_pipe" | "ae2:shaped/stairs/sky_stone_small_brick" | "minecraft:bamboo_trapdoor" | "powah:crafting/blank_card" | "create:deploying/waxed_copper_block_from_adding_wax" | "create:item_application/railway_casing" | "farmersdelight:lead_from_straw" | "railways:stonecutting/palettes/cycling/purple_slashed_locometal" | "minecraft:waxed_copper_block_from_honeycomb" | "tconstruct:smeltery/casting/metal/knightslime/nugget_gold_cast" | "tconstruct:smeltery/melting/water/snowball" | "railways:crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal" | "minecraft:warped_fungus_on_a_stick" | "iceandfire:dragonscales_silver_to_dragonscale_silver" | "hexcasting:spellbook" | "create:deploying/oxidized_copper_from_removing_wax" | "iceandfire:armor_electric_boots" | "ad_astra:cryo_freezing/cryo_fuel_from_cryo_freezing_ice_shard" | "molten_metals:splashing/iron_ingot_from_ceramic_mold" | "minecraft:gold_ingot_from_smelting_raw_gold" | "sophisticatedbackpacks:smithing_upgrade" | "tconstruct:common/glass/light_blue_clear_stained_glass" | "tconstruct:tools/modifiers/salvage/defense/golden" | "iceandfire:furnace/frozen_gravel" | "minecraft:spruce_hanging_sign" | "powah:crafting/energizing_rod_niotic" | "create:small_dripstone_brick_stairs" | "farmersdelight:cyan_canvas_sign" | "minecraft:cooked_cod_from_smoking" | "biomesoplenty:yellow_dye_from_goldenrod" | "tconstruct:common/glass/cyan_clear_stained_glass_pane_from_panes" | "tconstruct:tools/modifiers/salvage/ability/bulk_quiver" | "create:cutting/runtime_generated/compat/tconstruct/greenheart_log_to_stripped_greenheart_log" | "farmersdelight:gold_nugget_from_blasting_knife" | "tconstruct:tools/parts/casting/hammer_head_composite" | "ad_astra:stonecutting/mercury_stone_brick_stairs_from_mercury_stone_stonecutting" | "railways:mechanical_crafting/pink_locometal_boiler" | "ae2:charger/charged_certus_quartz_crystal" | "create:milling/compat/biomesoplenty/cattail" | "create:deploying/copper_tiles_from_removing_wax" | "railways:stonecutting/palettes/cycling/purple_locometal_smokebox" | "biomesoplenty:black_sandstone_stairs" | "sophisticatedbackpacks:anvil_upgrade" | "farmersdelight:cutting/mangrove_wood" | "create:crafting/kinetics/basin" | "create:cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "create:splashing/runtime_generated/compat/minecraft/yellow_concrete_powder_to_yellow_concrete" | "create:polished_cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "molten_metals:mixing/molten_netherite_from_alloying" | "tconstruct:common/slime/ichor/crystal_growing" | "minecraft:copper_ingot" | "railways:crafting/handcar" | "create:cut_veridium_brick_stairs" | "minecraft:waxed_weathered_cut_copper_slab" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_slab" | "tconstruct:smeltery/casting/metal/gold/apple" | "minecraft:white_dye_from_lily_of_the_valley" | "railways:crafting/palettes/dyeing_1x/red_copper_wrapped_locometal_boiler" | "molten_metals:mixing/molten_copper_from_block" | "minecraft:pink_dye_from_pink_petals" | "tconstruct:tools/materials/enderslime/block" | "create:haunting/glow_ink_sac" | "minecraft:end_stone_brick_wall" | "tconstruct:smeltery/melting/seared/slab" | "ad_astra:stonecutting/mars_cobblestone_stairs_from_mars_cobblestone_stonecutting" | "railways:crafting/palettes/dyeing_8x/white_flat_riveted_locometal" | "hexpigmentplus:magician_hat_cube" | "molten_metals:splashing/copper_ingot_from_metal_mold" | "ad_astra:steel_plateblock" | "ad_astra:blasting/calorite_ingot_from_blasting_raw_calorite" | "create:cut_tuff_slab_from_stone_types_tuff_stonecutting" | "railways:crafting/palettes/dyeing_8x/white_iron_wrapped_locometal" | "tconstruct:armor/repair/wood_station" | "tconstruct:tools/modifiers/salvage/upgrade/soulspeed" | "minecraft:waxed_oxidized_cut_copper_stairs_from_honeycomb" | "minecraft:netherite_chestplate_smithing" | "create:polished_cut_calcite_wall" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_planks_to_palm_slab" | "ae2:network/cables/dense_smart_red" | "tconstruct:smeltery/casting/metal/brass/ingot_gold_cast" | "ae2:inscriber/calculation_processor_print" | "biomesoplenty:maple_wood" | "minecraft:oak_sign" | "create:cutting/runtime_generated/compat/minecraft/stripped_dark_oak_log_to_dark_oak_planks" | "ad_astra:smelting/mars_stone_from_smelting_mars_cobblestone" | "railways:sequenced_assembly/track_acacia_narrow" | "ad_astra:glacio_stone_brick_stairs" | "railways:crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal" | "iceandfire:deathworm_white_boots" | "createaddition:crafting/electrum_block" | "biomesoplenty:redwood_slab" | "ad_astra:stonecutting/glacio_stone_slab_from_glacio_stone_stonecutting" | "create:polished_cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "tconstruct:tables/tinker_station_damaging/lingering_two" | "tconstruct:tools/modifiers/salvage/ability/multishot" | "create:cutting/runtime_generated/compat/minecraft/birch_planks_to_birch_pressure_plate" | "create:crafting/kinetics/track_station" | "minecraft:red_sandstone_stairs_from_red_sandstone_stonecutting" | "create:crushing/redstone_ore" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_planks_to_magic_pressure_plate" | "biomesoplenty:brimstone_bud_from_brimstone_stonecutting" | "farmersdelight:cutting/wild_beetroots" | "railways:mechanical_crafting/orange_iron_wrapped_locometal_boiler" | "minecraft:smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "iceandfire:copper_shovel" | "ad_astra:oxygen_distributor" | "tconstruct:tools/materials/wood/logs/acacia" | "ad_astra:stonecutting/chiseled_glacio_stone_slab_from_chiseled_glacio_stone_bricks_stonecutting" | "minecraft:diamond_from_smelting_diamond_ore" | "railways:sequenced_assembly/light_gray_conductor_cap" | "create:crushing/raw_iron" | "comforts:sleeping_bag_to_red" | "tconstruct:tools/materials/copper/nugget" | "minecraft:shield_decoration" | "create:cutting/runtime_generated/compat/ad_astra/aeronos_planks_to_aeronos_stairs" | "create:crafting/logistics/gray_postbox_from_other_postbox" | "create:cutting/runtime_generated/compat/ad_astra/glacian_planks_to_glacian_fence_gate" | "tconstruct:tools/modifiers/slotless/overslime/sky_block" | "minecraft:deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "ae2:tools/network_tool" | "create:cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "create:small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "tconstruct:tables/tinkers_forge" | "create:cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "farmersdelight:cooking/hot_cocoa" | "create:small_tuff_bricks_from_stone_types_tuff_stonecutting" | "minecraft:birch_planks" | "ae2:network/cables/dense_covered_red" | "minecraft:polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "create:small_calcite_brick_slab" | "tconstruct:common/firewood/blazewood_stairs" | "tconstruct:smeltery/seared/seared_paver_stairs_stonecutter" | "railways:crafting/palettes/dyeing_1x/green_brass_wrapped_locometal_boiler" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_planks_to_fir_door" | "minecraft:light_gray_stained_glass_pane" | "ae2:matter_cannon/nuggets/gold" | "tconstruct:common/glass/white_clear_stained_glass_pane" | "tconstruct:tools/modifiers/defense/turtle_shell" | "create:polished_cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "biomesoplenty:redwood_stairs" | "tconstruct:tools/parts/casting/hammer_head_sand_cast" | "create:diorite_pillar_from_stone_types_diorite_stonecutting" | "ad_astra:netherite_space_pants" | "comforts:sleeping_bag_magenta" | "create:crafting/logistics/copper_table_cloth_clear" | "ad_astra:permafrost_brick_wall" | "create:small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "tconstruct:smeltery/sand_cast_pickup" | "railways:crafting/palettes/dyeing_8x/yellow_locometal_boiler" | "minecraft:dye_magenta_carpet" | "create:cutting/bamboo_planks" | "tconstruct:tools/modifiers/jeweled_apple" | "sophisticatedbackpacks:xp_pump_upgrade" | "create:dripstone_block_from_stone_types_dripstone_stonecutting" | "create:milling/compat/tconstruct/nercotic_bone" | "create:polished_cut_andesite_from_stone_types_andesite_stonecutting" | "ad_astra:venus_sandstone_brick_stairs" | "minecraft:weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "create:scorchia_pillar_from_stone_types_scorchia_stonecutting" | "ad_astra:glowing_steel_pillar" | "ae2:network/cables/dense_smart_fluix_clean" | "ad_astra:calorite_plateblock" | "tconstruct:smeltery/casting/filling/scorched_lantern_full" | "farmersdelight:cooking/noodle_soup" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "tconstruct:gadgets/slimesling/ichor" | "tconstruct:tools/materials/steel/nugget" | "sophisticatedbackpacks:tank_upgrade" | "biomesoplenty:brimstone_brick_wall" | "simplylight:illuminant_light_gray_block_dyed" | "createoreexcavation:extractor/water" | "minecraft:brown_bed" | "railways:crafting/palettes/dyeing_1x/magenta_flat_riveted_locometal" | "railways:stonecutting/palettes/cycling/gray_plated_locometal" | "ae2:network/crafting/molecular_assembler" | "powah:crafting/capacitor_nitro" | "comforts:hammock_to_light_gray" | "biomesoplenty:hellbark_trapdoor" | "create:crushing/ochrum_recycling" | "biomesoplenty:hellbark_stairs" | "tconstruct:smeltery/melting/scorched/glass" | "ad_astra:iron_plating_pressure_plate" | "iceandfire:armor_electric_chestplate" | "ad_astra:polished_venus_stone_stairs" | "tconstruct:tools/modifiers/salvage/defense/shulking" | "ae2:decorative/sky_stone_brick_from_stonecutting" | "hexcasting:ancient_scroll_paper" | "tconstruct:world/wood/greenheart/slab" | "create:crafting/kinetics/hand_crank" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_log_to_stripped_fir_log" | "create:milling/compat/biomesoplenty/burning_blossom" | "create:milling/large_fern" | "tconstruct:smeltery/entity_melting/ender_slime" | "hexcasting:staff/spruce" | "powah:crafting/furnator_basic" | "tconstruct:smeltery/casting/quartz/andesite" | "minecraft:jack_o_lantern" | "create:crafting/logistics/blue_postbox" | "biomesoplenty:cut_black_sandstone" | "tconstruct:tools/repair/staff_station" | "minecraft:tripwire_hook" | "simplylight:illuminant_light_blue_block_on_dyed" | "minecraft:cut_sandstone_from_sandstone_stonecutting" | "ae2:network/cells/spatial_storage_cell_16_cubed" | "hexpigmentplus:magician_cloak" | "tconstruct:tools/materials/melting/enderslime" | "create:cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "tconstruct:tools/severing/terracube_clay" | "create:mixing/brass_ingot" | "tconstruct:smeltery/melting/slime/sky/bud_medium" | "tconstruct:tools/parts/casting/large_plate_sand_cast" | "iceandfire:dragonscales_black_to_dragonscale_black" | "farmersdelight:cutting/tag_dough" | "biomesoplenty:purple_dye_from_tall_lavender" | "tconstruct:common/materials/hepatizon_ingot_from_nuggets" | "create:crafting/logistics/pink_table_cloth" | "iceandfire:deathworm_yellow_helmet" | "ae2:network/crafting/patterns_blank" | "create:crafting/appliances/copper_backtank" | "ad_astra:permafrost_pillar" | "tconstruct:smeltery/casting/water/light_blue_concrete" | "railways:crafting/palettes/dyeing_1x/orange_locometal_boiler" | "create:cutting/runtime_generated/compat/minecraft/cherry_planks_to_cherry_fence_gate" | "create:crafting/kinetics/portable_storage_interface" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_planks_to_magic_stairs" | "createaddition:crafting/electrum_nugget" | "ad_astra:steel_trapdoor" | "railways:crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal_boiler" | "biomesoplenty:redwood_trapdoor" | "railways:crafting/palettes/dyeing_1x/black_locometal_boiler" | "biomesoplenty:pink_dye_from_pink_daffodil" | "comforts:hammock_to_brown" | "hextended:long/extended_quenched" | "create:crafting/materials/andesite_alloy_from_zinc" | "tconstruct:smeltery/entity_melting/heads/spider" | "biomesoplenty:jacaranda_trapdoor" | "create:milling/compat/biomesoplenty/white_petals" | "ad_astra:calorite_ingot" | "ad_astra:stonecutting/polished_permafrost_from_permafrost_bricks_stonecutting" | "ad_astra:blasting/desh_ingot_from_blasting_moon_desh_ore" | "create:cutting/runtime_generated/compat/minecraft/spruce_planks_to_spruce_stairs" | "railways:crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal_boiler" | "railways:stonecutting/palettes/cycling/black_flat_riveted_locometal" | "create:crafting/appliances/netherite_backtank_from_netherite" | "minecraft:waxed_weathered_cut_copper_from_honeycomb" | "createaddition:mechanical_crafting/electric_motor" | "ad_astra:moon_stone_brick_wall" | "comforts:sleeping_bag_red" | "sophisticatedbackpacks:auto_smelting_upgrade" | "ad_astra:black_flag" | "tconstruct:smeltery/casts/gold_casts/plates" | "tconstruct:smeltery/casting/metal/gold/carrot" | "ae2:network/cells/view_cell_storage" | "molten_metals:emptying/molten_zinc_from_ceramic_mold" | "ad_astra:smelting/ice_shard_from_smelting_deepslate_ice_shard_ore" | "create:cutting/runtime_generated/compat/tconstruct/stripped_skyroot_wood_to_skyroot_planks" | "ad_astra:stonecutting/polished_mercury_stone_slab_from_mercury_stone_stonecutting" | "minecraft:turtle_helmet" | "railways:crafting/palettes/dyeing_1x/light_blue_slashed_locometal" | "farmersdelight:cutting/mutton" | "create:milling/compat/biomesoplenty/white_sandstone" | "tconstruct:smeltery/casting/slime/earth/congealed" | "create:crafting/logistics/lime_postbox" | "railways:mechanical_crafting/yellow_locometal_boiler" | "ae2:network/cables/glass_black" | "powah:crafting/energy_discharger_starter" | "tconstruct:smeltery/seared/seared_glass_pane" | "biomesoplenty:chiseled_brimstone_bricks_from_brimstone_bricks_stonecutting" | "ad_astra:tier_1_rover" | "tconstruct:armor/building/travelers_boots" | "railways:mechanical_crafting/gray_copper_wrapped_locometal_boiler" | "ad_astra:small_cyan_industrial_lamp" | "minecraft:waxed_oxidized_cut_copper_slab" | "create:splashing/soul_sand" | "simplylight:illuminant_orange_block_dyed" | "railways:sequenced_assembly/track_biomesoplenty_hellbark_narrow" | "ae2:entropy/cool/lava_obsidian" | "minecraft:dropper" | "farmersdelight:onion" | "railways:sequenced_assembly/track_biomesoplenty_fir_narrow" | "create:crafting/kinetics/piston_extension_pole" | "tconstruct:tools/modifiers/salvage/upgrade/lightspeed" | "tconstruct:smeltery/scorched/fuel_tank" | "farmersdelight:cooking/stuffed_pumpkin_block" | "create:cut_crimsite_wall" | "minecraft:lime_dye_from_smelting" | "create:small_granite_brick_wall" | "create:cut_granite_slab_from_stone_types_granite_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_wood_to_stripped_empyreal_wood" | "create:cut_limestone_slab" | "create:crafting/kinetics/brass_hand" | "create:crafting/kinetics/lime_seat" | "minecraft:weathered_cut_copper_stairs" | "railways:mechanical_crafting/light_gray_brass_wrapped_locometal_boiler" | "create:cutting/runtime_generated/compat/minecraft/stripped_jungle_log_to_jungle_planks" | "ae2:transform/entangled_singularity" | "farmersdelight:cutting/spruce_door" | "simplylight:illuminant_black_block_dyed" | "hextended:long/lesser_battery_extended_staff" | "create:crafting/logistics/magenta_table_cloth_clear" | "ae2:network/crafting/4k_cpu_crafting_storage" | "ad_astra:refining/fuel_from_refining_oil" | "create:layered_dripstone_from_stone_types_dripstone_stonecutting" | "railways:crafting/palettes/dyeing_1x/lime_flat_riveted_locometal" | "ae2:network/cables/dense_smart_pink" | "create:crafting/kinetics/green_seat" | "molten_metals:mixing/molten_iron_from_ingot_raw" | "create:milling/sugar_cane" | "molten_metals:splashing/zinc_ingot_from_ceramic_mold" | "create:cutting/runtime_generated/compat/minecraft/crimson_planks_to_crimson_stairs" | "create:crafting/logistics/yellow_postbox" | "farmersdelight:cooking/mushroom_stew" | "minecraft:pink_bed" | "biomesoplenty:pink_dye_from_pink_hibiscus" | "minecraft:shield" | "railways:crafting/palettes/dyeing_8x/brown_riveted_locometal" | "railways:crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal_boiler" | "hexcasting:abacus" | "tconstruct:tools/modifiers/slotless/embellishment_electrum" | "minecraft:blackstone_slab" | "minecraft:dye_light_blue_carpet" | "hexcasting:dye_colorizer_yellow" | "hexcasting:dynamicseal_spellbook" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "powah:crafting/capacitor_basic" | "create:small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "minecraft:cooked_rabbit_from_smoking" | "tconstruct:tools/modifiers/slotless/writable" | "railways:crafting/palettes/dyeing_8x/black_riveted_locometal" | "create:cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "minecraft:quartz_bricks" | "ad_astra:yellow_flag" | "minecraft:map_cloning" | "minecraft:red_sandstone_wall" | "ae2:shaped/stairs/quartz_block" | "create:cutting/runtime_generated/compat/minecraft/cherry_planks_to_cherry_trapdoor" | "tconstruct:common/glass/blue_clear_stained_glass" | "create:crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "tconstruct:smeltery/casting/blaze/rod_sand_cast" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_planks_to_redwood_fence_gate" | "create:cut_deepslate_brick_slab_recycling" | "createaddition:crafting/spool" | "minecraft:acacia_stairs" | "farmersdelight:cutting/bamboo_door" | "tconstruct:tools/severing/drowned_head" | "iceandfire:summoning_crystal_lightning" | "ae2:block_cutter/walls/sky_stone_brick_wall" | "minecraft:iron_nugget_from_smelting" | "minecraft:raw_gold_block" | "minecraft:birch_door" | "tconstruct:smeltery/casts/sand_casts/repair_kit" | "tconstruct:tools/parts/builder/bowstring" | "create:cutting/runtime_generated/compat/ad_astra/aeronos_planks_to_aeronos_fence" | "tconstruct:tools/modifiers/salvage/ability/luck_pants" | "createoreexcavation:drilling_machine" | "create:polished_cut_granite_stairs" | "railways:crafting/palettes/dyeing_1x/red_iron_wrapped_locometal_boiler" | "farmersdelight:white_hanging_canvas_sign" | "computercraft:pocket_computer_normal" | "ae2:network/parts/formation_plane_alt" | "minecraft:chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "powah:crafting/blazing_crystal_block" | "tconstruct:tools/building/mattock" | "classicpipes:obsidian_fluid_pipe_b" | "iceandfire:furnace/frozen_cobblestone" | "classicpipes:obsidian_fluid_pipe_a" | "ae2:shaped/slabs/sky_stone_small_brick" | "railways:stonecutting/palettes/cycling/brown_locometal_pillar" | "sophisticatedbackpacks:pickup_upgrade" | "iceandfire:silver_pickaxe" | "minecraft:birch_fence_gate" | "tconstruct:world/wood/bloodshroom/button" | "minecraft:bone_meal" | "create:crafting/logistics/green_table_cloth_from_other_table_cloth" | "ad_astra:stonecutting/polished_moon_stone_from_moon_stone_stonecutting" | "ad_astra:stonecutting/venus_pillar_from_venus_stone_bricks_stonecutting" | "minecraft:gold_ingot_from_blasting_nether_gold_ore" | "create:mixing/andesite_alloy_from_zinc" | "railways:mechanical_crafting/black_locometal_boiler" | "iceandfire:dragonsteel_lightning_boots" | "powah:crafting/dielectric_paste_2" | "create:small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "tconstruct:smeltery/melting/diamond/chestplate" | "sophisticatedbackpacks:auto_smoking_upgrade" | "create:cutting/runtime_generated/compat/ad_astra/aeronos_planks_to_aeronos_slab" | "iceandfire:sheep_helmet" | "tconstruct:smeltery/seared/seared_bricks_from_brick" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_planks_to_dark_oak_slab" | "create:cut_andesite_brick_slab" | "minecraft:mud_brick_wall" | "tconstruct:smeltery/melting/slime/earth/bud_small" | "create:cut_deepslate_from_stone_types_deepslate_stonecutting" | "powah:energizing/uraninite_from_ore" | "minecraft:prismarine_wall_from_prismarine_stonecutting" | "tconstruct:tools/parts/casting/round_plate_gold_cast" | "tconstruct:tools/materials/rock/stone" | "railways:dying_existing_cap_cyan" | "molten_metals:mixing/molten_iron_from_block_raw" | "biomesoplenty:cut_orange_sandstone_from_orange_sandstone_stonecutting" | "farmersdelight:integration/create/milling/wild_cabbages" | "ad_astra:desh_plating" | "create:crafting/kinetics/purple_seat_from_other_seat" | "tconstruct:tools/modifiers/salvage/defense/magic_protection" | "create:cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "minecraft:redstone_block" | "minecraft:honeycomb_block" | "create:crafting/copper/waxed_copper_shingle_slab_from_honeycomb" | "biomesoplenty:cut_black_sandstone_slab_from_black_sandstone_stonecutting" | "ad_astra:polished_permafrost_stairs" | "createaddition:liquid_burning/plantoil" | "ae2:network/cables/glass_light_blue" | "tconstruct:smeltery/entity_melting/drowned" | "railways:crafting/palettes/dyeing_8x/black_slashed_locometal" | "hexcasting:dye_colorizer_cyan" | "minecraft:andesite_stairs_from_andesite_stonecutting" | "tconstruct:common/slime/sky/slimeblock" | "iceandfire:silver_ingot_from_blasting_raw_silver" | "create:blasting/gold_ingot_from_crushed" | "farmersdelight:cake_from_milk_bottle" | "simplylight:edge_light_top" | "create:cut_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "minecraft:dye_pink_bed" | "simplylight:illuminant_brown_block_on_dyed" | "railways:sequenced_assembly/track_biomesoplenty_jacaranda_wide" | "create:deploying/weathered_copper_tiles_from_deoxidising" | "create:crafting/kinetics/goggles" | "create:mixing/chocolate" | "create:crafting/materials/electron_tube" | "tconstruct:smeltery/casts/gold_casts/small_axe_head" | "farmersdelight:wheat_dough_from_water" | "powah:crafting/battery_hardened" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "tconstruct:smeltery/melting/scorched/slab" | "ae2:block_cutter/walls/quartz_brick_wall" | "hexal:freeze/powder_snow_cauldron" | "createoreexcavation:extractor" | "tconstruct:smeltery/casts/gold_casts/pick_head" | "iceandfire:dragonbone_sword" | "hexcasting:staff/jungle" | "create:splashing/wool" | "tconstruct:tools/materials/queens_slime/nugget" | "tconstruct:tools/parts/casting/bowstring_composite" | "create:cut_granite_stairs" | "minecraft:dye_cyan_carpet" | "tconstruct:tools/materials/pig_iron/nugget" | "create:crafting/logistics/red_postbox_from_other_postbox" | "ad_astra:stonecutting/chiseled_glacio_stone_bricks_from_glacio_stone_stonecutting" | "ad_astra:stonecutting/chiseled_venus_stone_bricks_from_venus_stone_stonecutting" | "railways:stonecutting/palettes/cycling/light_gray_riveted_locometal" | "create:cut_scoria_brick_slab" | "create:smelting/glass_pane_from_horizontal_framed_glass_pane" | "ad_astra:smelting/mercury_stone_from_smelting_mercury_cobblestone" | "tconstruct:tools/severing/creeper_head" | "simplylight:illuminant_pink_block_on_toggle" | "create:filling/redstone" | "tconstruct:smeltery/scorched/scorched_glass_pane" | "tconstruct:tools/materials/rose_gold/nugget" | "railways:crafting/palettes/dyeing_8x/red_copper_wrapped_locometal_boiler" | "minecraft:oxidized_cut_copper_stairs" | "create:cut_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "hextended:long/extended_mindsplice" | "iceandfire:forest_troll_leather_boots" | "minecraft:mangrove_trapdoor" | "minecraft:diamond_boots" | "ad_astra:stonecutting/venus_sandstone_brick_stairs_from_venus_sandstone_bricks_stonecutting" | "tconstruct:tools/materials/scorched_stone/block" | "iceandfire:banners/banner_pattern_sea_serpent" | "iceandfire:furnace/frozen_splinters" | "sophisticatedbackpacks:stack_upgrade_tier_4" | "create:cutting/runtime_generated/compat/create/tag_runtime_generated/compat/ad_astra/aeronos_to_aeronos_planks" | "minecraft:mangrove_hanging_sign" | "minecraft:stick" | "ad_astra:desh_engine" | "tconstruct:tools/modifiers/salvage/upgrade/quick_charge" | "create:cut_limestone_slab_recycling" | "tconstruct:smeltery/melting/metal/amethyst_bronze/nugget" | "farmersdelight:cooking/glow_berry_custard" | "ad_astra:calorite_plating_slab" | "create:crafting/kinetics/red_seat" | "create:deploying/waxed_copper_shingle_slab_from_adding_wax" | "ae2:network/parts/quartz_fiber_part" | "tconstruct:smeltery/casts/red_sand_casts/ingots" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_redwood_log_to_redwood_planks" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_planks_to_empyreal_stairs" | "minecraft:emerald_from_blasting_emerald_ore" | "tconstruct:smeltery/melting/metal/molten_debris/scrap" | "powah:energizing/nitro_crystal" | "tconstruct:tools/modifiers/ability/wetting" | "railways:crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal" | "create:crafting/logistics/light_gray_postbox" | "minecraft:polished_blackstone_brick_wall" | "ad_astra:aeronos_planks" | "tconstruct:tools/materials/composite/nahuatl" | "tconstruct:tools/materials/casting/enderslime" | "tconstruct:tools/modifiers/slotless/embellishment_blood" | "tconstruct:tools/modifiers/slotless/overslime/ichor_ball" | "create:crafting/kinetics/track_observer_from_other_plates" | "create:cutting/runtime_generated/compat/minecraft/crimson_planks_to_crimson_fence_gate" | "minecraft:dried_kelp_from_campfire_cooking" | "tconstruct:tools/materials/melting/darkthread" | "molten_metals:mixing/molten_gold_from_nugget" | "create:cutting/runtime_generated/compat/minecraft/stripped_mangrove_wood_to_mangrove_planks" | "ae2:network/wireless_crafting_terminal" | "hexcasting:slate_amethyst_bricks_small" | "create:cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "createoreexcavation:drilling/zinc" | "tconstruct:smeltery/entity_melting/ender" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_log_to_stripped_palm_log" | "create:polished_cut_veridium_slab_from_stone_types_veridium_stonecutting" | "ad_astra:raw_ostrum_block" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_sign" | "create:pressing/gold_ingot" | "tconstruct:tools/modifiers/worktable/enchantment_converting/ability_book" | "iceandfire:dragonarmor_copper_neck" | "railways:stonecutting/palettes/cycling/cyan_plated_locometal" | "tconstruct:common/glass/cyan_clear_stained_glass_pane" | "create:milling/compat/ae2/ender_pearl" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "create:crafting/kinetics/light_gray_seat_from_other_seat" | "biomesoplenty:magic_button" | "tconstruct:smeltery/casting/blaze/bone" | "sophisticatedbackpacks:stack_upgrade_tier_2" | "computercraft:turtle_upgrade" | "sophisticatedbackpacks:stack_upgrade_tier_3" | "farmersdelight:cutting/chocolate_pie" | "sophisticatedbackpacks:stack_upgrade_tier_1" | "railways:crafting/palettes/dyeing_1x/lime_plated_locometal" | "powah:crafting/energy_cell_basic_2" | "farmersdelight:green_hanging_canvas_sign" | "ae2:network/cables/dense_covered_light_blue" | "tconstruct:tools/modifiers/salvage/upgrade/blasting" | "ad_astra:smelting/coal_from_smelting_venus_coal_ore" | "iceandfire:dragonforge_fire_brick" | "ad_astra:cryo_freezing/cryo_fuel_from_cryo_freezing_ice" | "farmersdelight:horse_feed" | "createaddition:compat/tconstruct/blaze_blood" | "tconstruct:tools/parts/casting/tool_binding_gold_cast" | "railways:crafting/smokestack_long" | "create:crushing/glacio_coal_ore" | "tconstruct:tools/modifiers/ability/autosmelt" | "railways:stonecutting/palettes/cycling/blue_plated_locometal" | "iceandfire:dragonarmor_iron_neck" | "tconstruct:smeltery/melting/soul/pane" | "tconstruct:tools/modifiers/upgrade/blasting" | "minecraft:brown_stained_glass_pane" | "iceandfire:amphithere_arrow" | "minecraft:black_terracotta" | "resourcechickens:cooked_duck_smoking" | "iceandfire:deathworm_gauntlet_yellow" | "computercraft:turtle_normal_overlays/turtle_trans_overlay" | "create:cutting/runtime_generated/compat/hexcasting/edified_planks_to_edified_slab" | "iceandfire:dragonarmor_netherite_head" | "farmersdelight:cutting/pink_tulip" | "ae2:tools/certus_quartz_cutting_knife" | "tconstruct:smeltery/melting/metal/netherite/axes" | "minecraft:white_bed" | "tconstruct:smeltery/melting/slime/sky/crystal" | "ad_astra:glacio_cobblestone_stairs" | "create:crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "minecraft:spruce_slab" | "railways:stonecutting/palettes/cycling/red_locometal_smokebox" | "biomesoplenty:smooth_black_sandstone" | "railways:crafting/palettes/dyeing_1x/red_locometal_pillar" | "minecraft:cobblestone_slab_from_cobblestone_stonecutting" | "minecraft:mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "minecraft:yellow_carpet" | "tconstruct:tools/modifiers/ability/plowing" | "ae2:shaped/stairs/smooth_sky_stone_block" | "create:compacting/andesite_from_flint" | "tconstruct:smeltery/melting/seared/gauge" | "extendedae:epp_alt" | "tconstruct:armor/building/slime_skull/bone" | "powah:crafting/crystal_blazing" | "create:cut_dripstone_from_stone_types_dripstone_stonecutting" | "railways:crafting/palettes/wrapping/green_brass_wrapped_locometal" | "railways:sequenced_assembly/track_hexcasting_edified_wide" | "hexcasting:stonecutting/slate_pillar" | "minecraft:pumpkin_pie" | "biomesoplenty:pine_fence_gate" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_planks_to_dark_oak_trapdoor" | "tconstruct:smeltery/entity_melting/wither" | "railways:crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal_boiler" | "ae2:block_cutter/walls/fluix_wall" | "create:cut_ochrum_stairs" | "tconstruct:smeltery/melting/metal/gold/cast" | "minecraft:deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "railways:sequenced_assembly/track_stripped_bamboo_wide" | "minecraft:polished_granite" | "create:crafting/logistics/gray_table_cloth_clear" | "minecraft:soul_campfire" | "create:cutting/runtime_generated/compat/minecraft/birch_planks_to_birch_slab" | "createaddition:compat/tconstruct/pig_iron_2" | "create:deploying/cut_copper_stairs_from_deoxidising" | "tconstruct:smeltery/melting/metal/gold/helmet" | "create:crushing/deepslate_diamond_ore" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_planks_to_fir_slab" | "tconstruct:tools/materials/rabbit_hide" | "minecraft:gold_ingot_from_smelting_nether_gold_ore" | "create:cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "tconstruct:tools/modifiers/salvage/upgrade/impaling" | "farmersdelight:cutting/acacia_wood" | "iceandfire:dragonscale_bronze_to_dragonscales_bronze" | "simplylight:illuminant_block_dyed" | "railways:sequenced_assembly/gray_conductor_cap" | "tconstruct:tools/modifiers/ability/flamewake" | "farmersdelight:cooking/beef_stew" | "create:cutting/runtime_generated/compat/tconstruct/bloodshroom_log_to_stripped_bloodshroom_log" | "powah:crafting/furnator_nitro" | "railways:crafting/palettes/dyeing_1x/purple_flat_slashed_locometal" | "createoreexcavation:ore_vein_type/glowstone" | "railways:sequenced_assembly/purple_conductor_cap" | "create:cutting/runtime_generated/compat/minecraft/birch_log_to_stripped_birch_log" | "ae2:misc/deconstruction_fluix_block" | "ad_astra:stonecutting/venus_cobblestone_stairs_from_venus_cobblestone_stonecutting" | "tconstruct:smeltery/melting/metal/hepatizon/block" | "create:small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "molten_metals:splashing/necromium_ingot_from_ceramic_mold" | "iceandfire:armor_amythest_helmet" | "biomesoplenty:brown_dye_from_cattail" | "minecraft:crimson_fence_gate" | "biomesoplenty:orange_sandstone_stairs" | "create:crafting/appliances/chain_from_zinc" | "tconstruct:tools/materials/flint" | "biomesoplenty:cut_orange_sandstone_slab_from_orange_sandstone_stonecutting" | "create:polished_cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "create:polished_cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/bamboo_planks_to_bamboo_button" | "computercraft:monitor_normal" | "railways:crafting/palettes/wrapping/magenta_copper_wrapped_locometal" | "minecraft:lapis_lazuli_from_blasting_lapis_ore" | "create:crafting/kinetics/minecart_from_contraption_cart" | "create:cutting/runtime_generated/compat/minecraft/oak_log_to_stripped_oak_log" | "minecraft:rib_armor_trim_smithing_template" | "railways:mechanical_crafting/purple_brass_wrapped_locometal_boiler" | "railways:stonecutting/palettes/cycling/gray_flat_slashed_locometal" | "biomesoplenty:algal_end_stone" | "minecraft:cooked_chicken_from_campfire_cooking" | "create:emptying/compat/farmersdelight/milk_bottle" | "create:crafting/kinetics/radial_chassis" | "ae2:network/cells/item_storage_cell_4k_storage" | "create:small_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "railways:crafting/palettes/dyeing_8x/red_brass_wrapped_locometal_boiler" | "tconstruct:tools/modifiers/salvage/ability/protection" | "railways:crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal" | "tconstruct:smeltery/casts/sand_casts/wires" | "ae2:inscriber/logic_processor_print" | "molten_metals:mixing/molten_netherite_from_ingot" | "create:splashing/industrial_iron_window_pane" | "ad_astra:polished_permafrost" | "ae2:block_cutter/stairs/smooth_sky_stone_stairs" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_magic_log_to_magic_planks" | "railways:mechanical_crafting/brass_wrapped_locometal_boiler" | "minecraft:quartz_pillar_from_quartz_block_stonecutting" | "tconstruct:smeltery/casting/slime/ender/dirt" | "sophisticatedbackpacks:stack_upgrade_omega_tier" | "tconstruct:tools/materials/rock/diorite" | "hexcasting:brainsweep/directrix_redstone" | "ad_astra:raw_calorite_block" | "minecraft:deepslate_tiles_from_cobbled_deepslate_stonecutting" | "farmersdelight:cutting/dandelion" | "minecraft:mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "minecraft:observer" | "minecraft:polished_deepslate_wall" | "tconstruct:armor/building/slime_skull/blazing_bone" | "minecraft:cooked_cod_from_campfire_cooking" | "biomesoplenty:redwood_door" | "ducky-periphs:focal_link_block" | "ad_astra:marked_iron_pillar" | "minecraft:dye_purple_bed" | "railways:crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal" | "railways:crafting/palettes/dyeing_8x/light_gray_locometal_boiler" | "create:milling/bone_meal" | "ad_astra:raw_ostrum" | "create:mixing/andesite_alloy" | "minecraft:stripped_jungle_wood" | "minecraft:pink_dye_from_peony" | "create:cutting/aeronos_caps" | "tconstruct:smeltery/casts/gold_casts/bow_grip" | "create:compacting/chocolate" | "powah:crafting/battery_niotic" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_planks_to_palm_door" | "biomesoplenty:fir_wood" | "railways:stonecutting/palettes/cycling/black_riveted_locometal" | "minecraft:chiseled_red_sandstone_from_red_sandstone_stonecutting" | "railways:crafting/palettes/dyeing_8x/green_brass_wrapped_locometal" | "tconstruct:tools/modifiers/defense/golden" | "ad_astra:iron_factory_block" | "railways:sequenced_assembly/track_mangrove_narrow" | "ae2:charger/meteorite_compass" | "ad_astra:desh_pillar" | "hexcasting:amethyst_dust_packing" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_pressure_plate" | "iceandfire:tide_red_boots" | "create:bamboo_window" | "railways:mechanical_crafting/magenta_copper_wrapped_locometal_boiler" | "minecraft:chiseled_deepslate" | "railways:dying_existing_cap_light_blue" | "minecraft:soul_torch" | "create:crushing/gilded_blackstone" | "railways:sequenced_assembly/cyan_conductor_cap" | "biomesoplenty:hellbark_sign" | "tconstruct:tools/materials/melting/cobalt" | "powah:crafting/player_tranmitter_hardened" | "create:cut_dripstone_brick_wall" | "farmersdelight:rope_from_safety_net" | "ad_astra:steel_ingot" | "tconstruct:smeltery/melting/metal/copper/platform" | "biomesoplenty:fir_trapdoor" | "biomesoplenty:brimstone_cluster" | "minecraft:warped_fence_gate" | "ad_astra:glacian_fence_gate" | "tconstruct:smeltery/casting/metal/iron/ingot_sand_cast" | "create:cut_tuff_wall" | "create:crafting/kinetics/super_glue" | "minecraft:weathered_cut_copper_from_weathered_copper_stonecutting" | "ad_astra:desh_plating_pressure_plate" | "minecraft:gray_dye" | "farmersdelight:cooked_mutton_chops_from_campfire_cooking" | "railways:sequenced_assembly/track_dark_oak_wide" | "minecraft:coal_block" | "railways:mechanical_crafting/blue_locometal_boiler" | "tconstruct:smeltery/casting/metal/soulsteel/nugget_sand_cast" | "farmersdelight:orange_canvas_sign" | "computercraft:skull_dan200" | "tconstruct:smeltery/entity_melting/villager" | "tconstruct:tools/materials/melting/queens_slime" | "minecraft:slime_ball" | "create:crafting/kinetics/black_seat_from_other_seat" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_umbran_wood_to_umbran_planks" | "railways:crafting/palettes/dyeing_1x/light_gray_slashed_locometal" | "create:milling/pitcher_plant" | "tconstruct:armor/building/slime_skull/necrotic_bone" | "create:item_application/brass_casing_from_wood" | "ae2:network/parts/energy_acceptor" | "ad_astra:aeronos_door" | "farmersdelight:cutting/dark_oak_wood" | "ae2:network/cables/smart_light_blue" | "computercraft:turtle_normal/minecraft/diamond_axe" | "tconstruct:tools/parts/casting/pick_head_composite" | "railways:crafting/palettes/dyeing_1x/black_copper_wrapped_locometal" | "ad_astra:stonecutting/polished_mercury_stone_slab_from_polished_mercury_stone_stonecutting" | "minecraft:emerald_block" | "railways:sequenced_assembly/track_bamboo" | "iceandfire:sea_serpent_arrow" | "create:calcite_from_stone_types_calcite_stonecutting" | "create:cut_limestone_brick_slab_recycling" | "hexcasting:edified_button" | "classicpipes:brick_pipe" | "farmersdelight:cooking/cooked_rice" | "minecraft:end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:iron_sword" | "create:crafting/kinetics/linear_chassis_from_conversion" | "classicpipes:storage_pipe_a" | "ad_astra:ostrum_block" | "classicpipes:storage_pipe_b" | "ae2:network/blocks/interfaces_interface_alt" | "tconstruct:smeltery/copper_can" | "create:crafting/logistics/yellow_table_cloth" | "ad_astra:stonecutting/mars_stone_brick_slab_from_mars_stone_stonecutting" | "ae2:tools/portable_fluid_cell_4k" | "create:milling/saddle" | "railways:crafting/palettes/dyeing_8x/red_flat_slashed_locometal" | "railways:crafting/smokestack_caboosestyle" | "tconstruct:common/glass/purple_clear_stained_glass_pane_from_panes" | "railways:stonecutting/palettes/cycling/slashed_locometal" | "biomesoplenty:willow_sign" | "create:small_granite_brick_slab_recycling" | "create:small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "minecraft:chiseled_sandstone_from_sandstone_stonecutting" | "ae2:shaped/walls/sky_stone_brick" | "tconstruct:gadgets/fancy_frame/reversed_gold" | "comforts:hammock_red" | "ad_astra:chiseled_permafrost_brick_slab" | "tconstruct:smeltery/seared/seared_fancy_bricks_stonecutting" | "createoreexcavation:drilling/lapis" | "tconstruct:smeltery/melting/metal/iron/platform" | "farmersdelight:cutting/leather_helmet" | "minecraft:smooth_red_sandstone_slab" | "minecraft:cut_copper_stairs_from_cut_copper_stonecutting" | "create:cut_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "tconstruct:smeltery/casts/red_sand_casts/round_plate" | "railways:mechanical_crafting/black_copper_wrapped_locometal_boiler" | "minecraft:bamboo_pressure_plate" | "tconstruct:smeltery/seared/fuel_tank" | "powah:crafting/cable_basic" | "ad_astra:iron_pillar" | "minecraft:birch_trapdoor" | "tconstruct:tools/modifiers/defense/blast_protection" | "minecraft:prismarine_brick_stairs_from_prismarine_stonecutting" | "tconstruct:smeltery/melting/seared/pane" | "minecraft:deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "ad_astra:stonecutting/polished_mercury_stone_from_mercury_stone_bricks_stonecutting" | "molten_metals:splashing/steel_ingot_from_ceramic_mold_dreams" | "ad_astra:stonecutting/polished_mars_stone_from_mars_stone_bricks_stonecutting" | "railways:crafting/palettes/dyeing_8x/red_plated_locometal" | "railways:sequenced_assembly/track_monorail" | "tconstruct:tools/modifiers/salvage/defense/fire_protection" | "tconstruct:smeltery/melting/water/packed_ice" | "ad_astra:encased_desh_block" | "create:crafting/appliances/netherite_backtank" | "create:crafting/kinetics/metal_girder" | "tconstruct:common/materials/pig_iron_block_from_ingots" | "create:crafting/kinetics/millstone" | "create:exposed_copper_shingle_stairs" | "tconstruct:smeltery/casting/metal/iron/bars" | "tconstruct:smeltery/melting/slime/ender/sapling" | "ad_astra:polished_mars_stone" | "minecraft:conduit" | "railways:crafting/palettes/wrapping/purple_copper_wrapped_locometal" | "tconstruct:smeltery/melting/water/snow_block" | "tconstruct:tools/modifiers/salvage/upgrade/respiration" | "minecraft:sticky_piston" | "railways:crafting/palettes/dyeing_8x/pink_locometal_pillar" | "tconstruct:common/slime/lead" | "minecraft:blue_glazed_terracotta" | "tconstruct:smeltery/scorched/ingot_tank" | "tconstruct:smeltery/melting/metal/copper/ore_singular" | "biomesoplenty:palm_slab" | "hexal:brainsweep/mediafied_storage" | "ae2:tools/portable_fluid_cell_1k" | "minecraft:exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "tconstruct:smeltery/seared/drain" | "hexcasting:staff/mangrove" | "ad_astra:stonecutting/chiseled_moon_stone_stairs_from_chiseled_moon_stone_bricks_stonecutting" | "create:cut_diorite_brick_stairs" | "biomesoplenty:mossy_stone_bricks_from_willow_vine" | "create:milling/wool" | "powah:crafting/ender_gate_starter_2" | "create:crushing/deepslate_calorite_ore" | "tconstruct:common/puny_smelting" | "tconstruct:gadgets/cake/earth" | "tconstruct:tools/modifiers/salvage/ability/melting" | "railways:crafting/palettes/dyeing_1x/black_plated_locometal" | "tconstruct:smeltery/melting/metal/copper/plates" | "create:cutting/runtime_generated/compat/minecraft/mangrove_wood_to_stripped_mangrove_wood" | "tconstruct:common/materials/amethyst_bronze_nugget_from_ingot" | "minecraft:stripped_oak_wood" | "create:mixing/dough_by_mixing" | "farmersdelight:beef_patty_from_smoking" | "hexcasting:sub_sandwich" | "iceandfire:copper_sword" | "tconstruct:smeltery/melting/metal/molten_debris/debris_nugget" | "minecraft:comparator" | "sophisticatedbackpacks:stack_upgrade_starter_tier" | "ae2:matter_cannon/nuggets/cobalt" | "tconstruct:tools/modifiers/worktable/enchantment_converting/upgrade_book" | "tconstruct:smeltery/casting/seared/paver" | "railways:stonecutting/palettes/cycling/green_riveted_locometal" | "tconstruct:tools/parts/casting/round_plate_composite" | "create:exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "railways:crafting/palettes/dyeing_8x/gray_plated_locometal" | "tconstruct:tools/modifiers/upgrade/diamond" | "ad_astra:stonecutting/glacio_stone_brick_stairs_from_glacio_stone_stonecutting" | "railways:crafting/palettes/dyeing_8x/black_plated_locometal" | "railways:crafting/palettes/dyeing_8x/cyan_plated_locometal" | "tconstruct:tools/modifiers/ability/boundless" | "molten_metals:splashing/netherite_ingot_from_metal_mold" | "tconstruct:smeltery/melting/slime/ender/block" | "ad_astra:stonecutting/mars_pillar_from_mars_stone_stonecutting" | "create:deploying/weathered_copper_shingles_from_removing_wax" | "railways:crafting/palettes/dyeing_8x/blue_locometal_smokebox" | "create:cut_dripstone_wall" | "tconstruct:smeltery/casts/sand_casts/tough_handle" | "tconstruct:smeltery/seared/seared_paver_stairs" | "biomesoplenty:fir_hanging_sign" | "minecraft:granite_wall_from_granite_stonecutting" | "comforts:sleeping_bag_gray" | "minecraft:cut_red_sandstone" | "create:crushing/raw_copper" | "create:polished_cut_veridium_slab" | "railways:crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal" | "railways:crafting/palettes/dyeing_8x/black_flat_slashed_locometal" | "create:small_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "ad_astra:astrodux" | "create:crafting/kinetics/vertical_gearbox" | "tconstruct:tools/modifiers/slotless/blindshot" | "minecraft:andesite_slab_from_andesite_stonecutting" | "tconstruct:smeltery/casts/gold_casts/rods" | "create:cut_calcite_brick_slab" | "create:smelting/bread" | "tconstruct:smeltery/casting/water/splash" | "ad_astra:white_flag" | "farmersdelight:canvas_sign" | "iceandfire:furnace/deepslate_silver_ingot_blasting" | "biomesoplenty:empyreal_sign" | "tconstruct:common/materials/slimesteel_ingot_from_nuggets" | "create:crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "railways:crafting/palettes/dyeing_1x/green_copper_wrapped_locometal_boiler" | "create:cut_limestone_brick_stairs" | "tconstruct:tables/tinker_station_damaging/potion_one" | "hexcasting:brainsweep/impetus_look" | "railways:stonecutting/palettes/cycling/green_plated_locometal" | "tconstruct:smeltery/melting/slime/blood/ball" | "powah:crafting/furnator_starter" | "biomesoplenty:pine_boat" | "minecraft:deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "minecraft:bamboo_door" | "create:item_application/copper_casing_from_log" | "railways:crafting/palettes/dyeing_1x/light_gray_plated_locometal" | "tconstruct:smeltery/casting/honey/block" | "ad_astra:stonecutting/mars_stone_slab_from_mars_stone_stonecutting" | "tconstruct:tools/modifiers/upgrade/emerald" | "create:crafting/logistics/purple_postbox_from_other_postbox" | "farmersdelight:integration/create/milling/wild_onions" | "ad_astra:blasting/calorite_ingot_from_blasting_deepslate_calorite_ore" | "powah:crafting/crystal_niotic" | "farmersdelight:oak_cabinet" | "ad_astra:solar_panel" | "ad_astra:glacian_trapdoor" | "railways:sequenced_assembly/track_create_andesite_narrow" | "powah:crafting/cable_spirited_2" | "minecraft:white_wool_from_string" | "railways:crafting/palettes/dyeing_8x/red_iron_wrapped_locometal_boiler" | "ad_astra:cryo_freezing/cryo_fuel_from_cryo_freezing_packed_ice" | "minecraft:cobblestone_wall_from_cobblestone_stonecutting" | "ae2:network/cells/item_cell_housing" | "biomesoplenty:white_sandstone_stairs_from_white_sandstone_stonecutting" | "minecraft:white_stained_glass_pane" | "tconstruct:armor/repair/travelers_copper_repair_kit" | "create:deploying/weathered_copper_tile_stairs_from_deoxidising" | "create:crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_planks_to_redwood_fence" | "ae2:shaped/walls/smooth_sky_stone_block" | "tconstruct:smeltery/alloys/molten_amethyst_bronze" | "iceandfire:frost_troll_leather_helmet" | "comforts:hammock_to_magenta" | "minecraft:yellow_dye_from_sunflower" | "railways:crafting/palettes/dyeing_8x/orange_locometal_smokebox" | "create:crafting/kinetics/windmill_bearing" | "create:small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "ad_astra:vent" | "railways:stonecutting/palettes/cycling/brown_slashed_locometal" | "farmersdelight:cutting/torchflower" | "minecraft:oak_slab" | "ad_astra:ostrum_sliding_door" | "biomesoplenty:fir_fence" | "iceandfire:graveyard_soil" | "tconstruct:smeltery/casting/metal/iron/block" | "railways:stonecutting/palettes/cycling/purple_riveted_locometal" | "tconstruct:tools/parts/casting/bow_grip_gold_cast" | "biomesoplenty:chiseled_white_sandstone_from_white_sandstone_stonecutting" | "railways:dying_existing_cap_yellow" | "create:milling/sea_pickle" | "minecraft:mangrove_sign" | "biomesoplenty:redwood_sign" | "farmersdelight:cutting/wild_carrots" | "railways:crafting/palettes/dyeing_1x/gray_flat_slashed_locometal" | "railways:stonecutting/palettes/cycling/blue_flat_slashed_locometal" | "powah:crafting/cable_basic_2" | "create:cutting/runtime_generated/compat/tconstruct/skyroot_planks_to_skyroot_button" | "create:pressing/iron_ingot" | "create:cut_deepslate_stairs" | "create:cut_ochrum_brick_slab" | "classicpipes:provider_pipe_a" | "railways:crafting/palettes/dyeing_8x/gray_flat_slashed_locometal" | "tconstruct:smeltery/melting/metal/iron/rod" | "create:crafting/logistics/light_gray_postbox_from_other_postbox" | "classicpipes:provider_pipe_b" | "railways:mechanical_crafting/purple_iron_wrapped_locometal_boiler" | "railways:crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal" | "ad_astra:moon_cobblestone_stairs" | "create:pressing/steel_ingot" | "iceandfire:armor_white_boots" | "railways:mechanical_crafting/orange_copper_wrapped_locometal_boiler" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_planks_to_pine_slab" | "minecraft:dye_brown_carpet" | "minecraft:glass_pane" | "tconstruct:smeltery/casting/seared/brick_gold_cast" | "railways:mechanical_crafting/blue_copper_wrapped_locometal_boiler" | "hextended:moss_staff" | "biomesoplenty:maple_fence_gate" | "tconstruct:smeltery/melting/amethyst/cluster" | "farmersdelight:netherite_knife_smithing" | "simplylight:illuminant_yellow_block_toggle" | "ae2:transform/chipped_budding_quartz" | "minecraft:clay" | "ae2:network/crafting/cpu_crafting_unit" | "tconstruct:tools/materials/enderslime/ball" | "farmersdelight:rice_panicle" | "ae2:shaped/slabs/smooth_sky_stone_block" | "ad_astra:blue_flag" | "create:crafting/kinetics/mechanical_plough" | "iceandfire:armor_blue_leggings" | "create:milling/compat/biomesoplenty/violet" | "railways:crafting/palettes/dyeing_8x/yellow_riveted_locometal" | "create:framed_glass_pane" | "railways:crafting/palettes/dyeing_1x/yellow_riveted_locometal" | "create:cutting/runtime_generated/compat/biomesoplenty/umbran_wood_to_stripped_umbran_wood" | "tconstruct:smeltery/casting/metal/soulsteel/ingot_sand_cast" | "tconstruct:tools/modifiers/ability/luck_pants" | "railways:sequenced_assembly/track_biomesoplenty_jacaranda_narrow" | "ae2:shaped/stairs/smooth_quartz_block" | "farmersdelight:tatami" | "ad_astra:orange_flag" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "ae2:network/blocks/interfaces_interface_part" | "powah:crafting/battery_spirited" | "tconstruct:common/copper_platform_waxing_unaffected" | "tconstruct:tools/modifiers/ability/stripping" | "ae2:materials/annihilationcore" | "railways:stonecutting/palettes/cycling/blue_locometal_smokebox" | "create:cutting/runtime_generated/compat/minecraft/cherry_planks_to_cherry_button" | "tconstruct:smeltery/melting/metal/brass/block" | "ad_astra:blasting/ostrum_ingot_from_blasting_raw_ostrum" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_planks_to_pine_fence" | "ae2:network/cables/dense_covered_green" | "create:crafting/logistics/magenta_postbox_from_other_postbox" | "create:crafting/logistics/gray_table_cloth_from_other_table_cloth" | "minecraft:leather_boots" | "create:milling/dandelion" | "farmersdelight:cutting/crimson_door" | "biomesoplenty:jacaranda_planks" | "ad_astra:etrionic_blast_furnace" | "create:crafting/logistics/andesite_tunnel" | "railways:crafting/palettes/dyeing_8x/green_riveted_locometal" | "create:cutting/runtime_generated/compat/ad_astra/stripped_glacian_log_to_glacian_planks" | "create:splashing/crushed_raw_iron" | "simplylight:illuminant_cyan_block_toggle" | "tconstruct:tools/parts/casting/tool_handle_composite" | "tconstruct:common/glass/purple_clear_stained_glass" | "tconstruct:tools/repair/flint_and_brick_scorched_repair_kit" | "tconstruct:smeltery/melting/metal/netherite/chestplate" | "railways:stonecutting/palettes/cycling/white_flat_riveted_locometal" | "create:splashing/industrial_iron_block" | "create:crushing/moon_cheese_ore" | "tconstruct:common/glass/pink_clear_stained_glass" | "iceandfire:copper_axe" | "iceandfire:summoning_crystal_fire_reset" | "ae2:network/crystal_resonance_generator" | "tconstruct:smeltery/casts/gold_casts/tool_handle" | "tconstruct:armor/repair/travelers_copper_station" | "create:cutting/runtime_generated/compat/biomesoplenty/dead_planks_to_dead_pressure_plate" | "tconstruct:tools/modifiers/salvage/upgrade/cooling" | "minecraft:baked_potato_from_smoking" | "railways:crafting/palettes/dyeing_8x/pink_locometal_boiler" | "create:polished_cut_granite_wall" | "minecraft:dye_black_carpet" | "ad_astra:polished_mercury_stone_stairs" | "ae2:network/cables/covered_purple" | "minecraft:polished_blackstone_brick_wall_from_blackstone_stonecutting" | "tconstruct:smeltery/melting/quartz/decorative_block" | "farmersdelight:cutting/red_mushroom_colony" | "create:cut_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/stripped_oak_wood_to_oak_planks" | "farmersdelight:cutting/acacia_log" | "create:cut_asurine_slab_recycling" | "minecraft:magma_block" | "tconstruct:tools/building/sky_staff" | "tconstruct:tools/modifiers/worktable/extract_modifier_breath" | "railways:crafting/palettes/wrapping/black_iron_wrapped_locometal" | "create:cut_limestone_wall_from_stone_types_limestone_stonecutting" | "create:small_granite_brick_stairs_from_stone_types_granite_stonecutting" | "tconstruct:smeltery/casting/blaze/congealed" | "iceandfire:dragonarmor_diamond_tail" | "tconstruct:smeltery/casting/metal/silver/ingot_sand_cast" | "minecraft:brush" | "create:cutting/runtime_generated/compat/minecraft/cherry_wood_to_stripped_cherry_wood" | "farmersdelight:fried_egg_from_smoking" | "tconstruct:smeltery/melting/metal/netherite/weapon" | "tconstruct:smeltery/scorched/scorched_brick" | "computercraft:pocket_computer_advanced_upgrade" | "create:splashing/runtime_generated/compat/minecraft/green_concrete_powder_to_green_concrete" | "tconstruct:world/wood/skyroot/button" | "tconstruct:tools/modifiers/ability/multishot" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_planks_to_magic_sign" | "minecraft:deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "create:crafting/materials/experience_block" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_planks_to_empyreal_trapdoor" | "create:cutting/runtime_generated/compat/minecraft/spruce_planks_to_spruce_sign" | "railways:sequenced_assembly/track_biomesoplenty_fir" | "tconstruct:common/glass/red_clear_stained_glass" | "create:vertical_framed_glass_pane" | "minecraft:end_stone_bricks_from_end_stone_stonecutting" | "tconstruct:common/materials/netherite_ingot_from_nuggets" | "create:milling/ink_sac" | "createaddition:compat/tconstruct/queens_slime" | "create:limestone_pillar_from_stone_types_limestone_stonecutting" | "iceandfire:dragonsteel_lightning_block_to_dragonsteel_lightning_ingot" | "railways:stonecutting/palettes/cycling/light_gray_flat_slashed_locometal" | "create:haunting/warped_fungus" | "create:cutting/runtime_generated/compat/minecraft/spruce_planks_to_spruce_trapdoor" | "tconstruct:tools/modifiers/stringy_crafting_table" | "biomesoplenty:chiseled_white_sandstone" | "tconstruct:common/slime/earth/slimeball_from_congealed" | "create:crafting/logistics/blue_table_cloth" | "create:deploying/waxed_exposed_cut_copper_from_adding_wax" | "iceandfire:dragonbone_sword_fire" | "simplylight:illuminant_block_on" | "create:small_tuff_brick_slab_recycling" | "railways:stonecutting/palettes/cycling/gray_flat_riveted_locometal" | "create:polished_cut_andesite_slab_recycling" | "iceandfire:silver_nugget_to_silver_ingot" | "tconstruct:smeltery/alloys/molten_electrum" | "create:sequenced_assembly/track" | "create:polished_cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "farmersdelight:cooking/bone_broth" | "create:crafting/logistics/light_gray_table_cloth" | "tconstruct:smeltery/melting/seared/block" | "railways:mechanical_crafting/brown_iron_wrapped_locometal_boiler" | "create:mixing/tea" | "powah:crafting/cable_nitro" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_planks_to_willow_pressure_plate" | "railways:sequenced_assembly/track_bamboo_wide" | "minecraft:waxed_exposed_cut_copper_slab" | "railways:crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal" | "powah:crafting/manual" | "minecraft:dark_oak_fence" | "create:cut_deepslate_wall" | "tconstruct:smeltery/melting/metal/rose_gold/silky_cloth" | "biomesoplenty:dead_boat" | "tconstruct:smeltery/melting/venom/fermented_eye" | "farmersdelight:cutting/melon" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "create:polished_cut_diorite_wall_from_stone_types_diorite_stonecutting" | "tconstruct:tools/modifiers/salvage/upgrade/soulbound" | "ad_astra:calorite_factory_block" | "biomesoplenty:umbran_trapdoor" | "tconstruct:smeltery/casting/metal/zinc/plate_sand_cast" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_planks_to_dark_oak_sign" | "create:crafting/logistics/white_table_cloth_clear" | "ae2:network/cables/dense_smart_purple" | "minecraft:blaze_powder" | "minecraft:chain" | "biomesoplenty:smooth_orange_sandstone_slab_from_smooth_orange_sandstone_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_wood_to_stripped_pine_wood" | "tconstruct:tools/modifiers/salvage/defense/dragon_scale" | "railways:stonecutting/palettes/cycling/light_gray_slashed_locometal" | "classicpipes:copper_pipe" | "minecraft:oak_fence" | "create:polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "biomesoplenty:umbran_pressure_plate" | "powah:crafting/player_tranmitter_starter" | "ae2:decorative/sky_stone_small_brick_from_stonecutting" | "simplylight:illuminant_black_block_on_toggle" | "iceandfire:dragonbone" | "create:small_veridium_bricks_from_stone_types_veridium_stonecutting" | "tconstruct:smeltery/melting/scorched/pane" | "gravestones:gravestone_chipped" | "tconstruct:smeltery/seared/grout" | "tconstruct:tools/modifiers/slotless/embellishment_obsidian" | "tconstruct:world/wood/bloodshroom/log_to_wood" | "tconstruct:tools/materials/iron/block" | "iceandfire:banners/banner_pattern_hippogryph_head" | "create:cut_andesite_brick_slab_recycling" | "create:cut_tuff_stairs" | "ad_astra:smelting/cracked_glacio_stone_bricks_from_smelting_glacio_stone_bricks" | "comforts:hammock_light_blue" | "minecraft:deepslate" | "ad_astra:purple_flag" | "create:haunting/crimson_fungus" | "ae2:inscriber/calculation_processor" | "tconstruct:tools/materials/wood/planks/mangrove" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_planks_to_mahogany_button" | "create:crafting/logistics/redstone_contact" | "tconstruct:smeltery/melting/metal/brass/rod" | "tconstruct:smeltery/melting/metal/iron/chestplate" | "create:crushing/glacio_copper_ore" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_trapdoor" | "minecraft:calibrated_sculk_sensor" | "railways:crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal" | "tconstruct:common/glass/light_gray_clear_stained_glass_pane_from_panes" | "ad_astra:desh_factory_block" | "create:cut_granite_brick_stairs_from_stone_types_granite_stonecutting" | "ae2:tools/certus_quartz_spade" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_planks_to_redwood_button" | "iceandfire:chain_sticky" | "tconstruct:common/glass/red_clear_stained_glass_pane_from_panes" | "farmersdelight:skillet" | "minecraft:prismarine_slab_from_prismarine_stonecutting" | "create:crafting/kinetics/light_gray_valve_handle_from_other_valve_handle" | "ae2:network/cables/dense_covered_black" | "ae2:network/blocks/controller" | "ad_astra:smelting/desh_ingot_from_smelting_deepslate_desh_ore" | "tconstruct:smeltery/scorched/basin" | "tconstruct:common/glass/lime_clear_stained_glass_pane" | "createaddition:rolling/gold_ingot" | "biomesoplenty:umbran_planks" | "minecraft:deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "tconstruct:smeltery/casting/metal/steel/plate_gold_cast" | "minecraft:green_terracotta" | "create:filling/honey_bottle" | "minecraft:white_stained_glass" | "tconstruct:smeltery/scorched/scorched_road_stairs" | "computercraft:turtle_normal/computercraft/wireless_modem_advanced" | "tconstruct:smeltery/casting/seared/bricks/slab" | "tconstruct:tools/modifiers/ability/dual_wielding" | "create:layered_asurine_from_stone_types_asurine_stonecutting" | "railways:crafting/palettes/dyeing_1x/yellow_locometal_smokebox" | "railways:mechanical_crafting/gray_brass_wrapped_locometal_boiler" | "tconstruct:smeltery/casting/metal/amethyst_bronze/ingot_sand_cast" | "tconstruct:tools/materials/composite/blazing_bone" | "railways:crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal_boiler" | "create:cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "tconstruct:tools/parts/builder/repair_kit" | "create:cutting/runtime_generated/compat/minecraft/birch_planks_to_birch_button" | "minecraft:purpur_stairs" | "ad_astra:chiseled_permafrost_bricks" | "create:cutting/runtime_generated/compat/hexcasting/stripped_edified_wood_to_edified_planks" | "create:splashing/runtime_generated/compat/minecraft/gray_concrete_powder_to_gray_concrete" | "tconstruct:tools/parts/casting/broad_blade_composite" | "tconstruct:smeltery/melting/metal/iron/raw" | "ae2:misc/fluixpearl" | "ad_astra:sky_stone" | "iceandfire:nest" | "iceandfire:furnace/deepslate_silver_ingot" | "tconstruct:smeltery/melting/metal/amethyst_bronze/ingot" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_hellbark_wood_to_hellbark_planks" | "create:cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "create:crafting/kinetics/large_cogwheel_from_little" | "create:polished_cut_crimsite_slab_recycling" | "tconstruct:smeltery/casting/water/orange_concrete" | "ad_astra:aeronos_stairs" | "create:sandpaper_polishing/rose_quartz" | "minecraft:ward_armor_trim_smithing_template" | "sophisticatedbackpacks:auto_blasting_upgrade" | "ad_astra:blasting/ice_shard_from_blasting_deepslate_ice_shard_ore" | "biomesoplenty:maple_button" | "ae2:network/cables/dense_smart_gray" | "iceandfire:dragonscales_green_to_dragonscale_green" | "ae2:tools/paintballs_lumen_pink" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_slab" | "tconstruct:common/glass/white_clear_stained_glass" | "hexcasting:dye_colorizer_light_gray" | "create:cut_veridium_slab_from_stone_types_veridium_stonecutting" | "minecraft:quartz_from_blasting" | "ae2:network/parts/terminals_pattern_encoding" | "powah:crafting/energy_discharger_blazing" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_planks_to_hellbark_sign" | "iceandfire:furnace/sapphire_blasting" | "createaddition:rolling/straw" | "minecraft:purpur_slab" | "tconstruct:smeltery/red_sand_cast_pickup" | "farmersdelight:light_gray_canvas_sign" | "biomesoplenty:willow_fence_gate" | "minecraft:chiseled_polished_blackstone_from_blackstone_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_log_to_stripped_magic_log" | "tconstruct:tools/modifiers/ability/double_jump" | "molten_metals:mixing/molten_brass_from_ingot" | "createaddition:filling/honey_cake" | "railways:mechanical_crafting/pink_iron_wrapped_locometal_boiler" | "create:milling/compat/biomesoplenty/tiny_cactus" | "tconstruct:common/glass/green_clear_stained_glass_pane_from_panes" | "minecraft:gold_nugget" | "agricraft:seed_bag" | "railways:crafting/palettes/dyeing_8x/brown_slashed_locometal" | "create:cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "iceandfire:dragonsteel_ice_chestplate" | "create:small_dripstone_brick_slab" | "ad_astra:stonecutting/glacio_cobblestone_stairs_from_glacio_cobblestone_stonecutting" | "railways:crafting/palettes/dyeing_8x/lime_slashed_locometal" | "minecraft:waxed_oxidized_cut_copper" | "comforts:hammock_lime" | "sophisticatedbackpacks:stack_upgrade_tier_1_from_starter" | "create:copper_shingle_slab_from_copper_shingles_stonecutting" | "artifacts:eternal_steak_campfire" | "biomesoplenty:umbran_stairs" | "create:small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "tconstruct:smeltery/entity_melting/heads/blaze" | "tconstruct:tools/parts/casting/tool_handle_gold_cast" | "tconstruct:tools/modifiers/slotless/embellishment_clay" | "create:deploying/weathered_cut_copper_stairs_from_removing_wax" | "tconstruct:smeltery/melting/seared/glass" | "minecraft:blast_furnace" | "create:cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "minecraft:polished_andesite_stairs" | "tconstruct:smeltery/casting/metal/iron/soul_lantern" | "farmersdelight:cutting/crimson_sign" | "computercraft:disk_10" | "computercraft:disk_11" | "computercraft:disk_12" | "computercraft:disk_13" | "tconstruct:smeltery/casting/filling/scorched_ingot_tank" | "tconstruct:tools/parts/casting/bow_limb_composite" | "minecraft:light_blue_stained_glass_pane_from_glass_pane" | "minecraft:magenta_dye_from_lilac" | "railways:crafting/palettes/wrapping/white_iron_wrapped_locometal" | "ae2:materials/carddistribution" | "ae2:network/parts/import_bus" | "minecraft:dye_red_bed" | "computercraft:pocket_normal/computercraft/speaker" | "railways:crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal_boiler" | "railways:crafting/palettes/dyeing_8x/red_locometal_boiler" | "iceandfire:dragonarmor_silver_body" | "farmersdelight:canvas_rug" | "ae2:network/crafting/16k_cpu_crafting_storage" | "iceandfire:dread_stone_bricks_mossy" | "minecraft:blue_stained_glass_pane_from_glass_pane" | "tconstruct:tools/materials/gold/nugget" | "tconstruct:smeltery/melting/amethyst/bud_small" | "tconstruct:tools/modifiers/salvage/upgrade/killager" | "railways:crafting/palettes/dyeing_8x/green_slashed_locometal" | "minecraft:red_sandstone_wall_from_red_sandstone_stonecutting" | "tconstruct:tools/modifiers/worktable/invisible_ink_removing" | "powah:crafting/uraninite_block" | "create:weathered_copper_tile_slab_from_weathered_copper_tiles_stonecutting" | "create:acacia_window" | "iceandfire:tide_blue_chestplate" | "biomesoplenty:umbran_wood" | "create:cut_veridium_brick_slab" | "create:cut_crimsite_brick_stairs" | "ae2:network/cables/glass_pink" | "ae2:network/cables/smart_cyan" | "minecraft:fletching_table" | "minecraft:dye_lime_bed" | "minecraft:waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "tconstruct:smeltery/scorched/scorched_road_slab" | "farmersdelight:acacia_cabinet" | "minecraft:mossy_cobblestone_wall" | "railways:crafting/palettes/wrapping/purple_iron_wrapped_locometal" | "minecraft:spyglass" | "create:smelting/glass_from_horizontal_framed_glass" | "tconstruct:tools/modifiers/ability/bouncy" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_planks_to_willow_trapdoor" | "create:cutting/runtime_generated/compat/minecraft/spruce_planks_to_spruce_door" | "minecraft:pink_stained_glass" | "railways:crafting/palettes/dyeing_8x/red_locometal_pillar" | "create:splashing/runtime_generated/compat/minecraft/red_concrete_powder_to_red_concrete" | "biomesoplenty:brimstone_bricks_from_brimstone_stonecutting" | "minecraft:oak_chest_boat" | "create:deploying/exposed_copper_tiles_from_removing_wax" | "minecraft:end_stone_brick_wall_from_end_stone_brick_stonecutting" | "create:milling/venus_sandstone" | "tconstruct:smeltery/melting/diamond/leggings" | "create:cut_dripstone_slab_recycling" | "create:oxidized_copper_tile_stairs" | "biomesoplenty:black_sandstone_slab" | "minecraft:yellow_stained_glass_pane" | "minecraft:diorite_slab_from_diorite_stonecutting" | "tconstruct:smeltery/casting/metal/brass/plate_gold_cast" | "ad_astra:fuel_refinery" | "tconstruct:tools/materials/wood/logs/spruce" | "minecraft:raiser_armor_trim_smithing_template" | "molten_metals:splashing/bismuth_ingot_from_ceramic_mold" | "farmersdelight:white_canvas_sign" | "minecraft:bamboo_mosaic_stairs" | "create:deploying/waxed_oxidized_copper_tile_stairs_from_adding_wax" | "hexcasting:stonecutting/amethyst_tiles" | "comforts:hammock_blue" | "create:crushing/amethyst_cluster" | "resourcechickens:cooked_catcher_duck" | "create:polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "powah:energizing/uraninite_from_raw" | "computercraft:disk_14" | "computercraft:disk_15" | "computercraft:disk_16" | "minecraft:oxidized_cut_copper_from_oxidized_copper_stonecutting" | "tconstruct:common/materials/cobalt_nugget_from_ingot" | "minecraft:bread" | "railways:dying_existing_cap_gray" | "create:crafting/appliances/copper_diving_helmet" | "ae2:tools/portable_item_cell_64k" | "railways:sequenced_assembly/track_biomesoplenty_willow_wide" | "biomesoplenty:magic_fence_gate" | "minecraft:lever" | "create:cutting/runtime_generated/compat/biomesoplenty/dead_wood_to_stripped_dead_wood" | "ad_astra:desh_plating_stairs" | "tconstruct:smeltery/melting/soul/glass" | "iceandfire:hippocampus_slapper" | "create:crushing/deepslate_copper_ore" | "create:cutting/runtime_generated/compat/biomesoplenty/pine_planks_to_pine_button" | "iceandfire:dragonbone_hoe" | "minecraft:end_stone_brick_wall_from_end_stone_stonecutting" | "molten_metals:splashing/bronze_ingot_from_ceramic_mold" | "create:cutting/runtime_generated/compat/biomesoplenty/maple_planks_to_maple_stairs" | "tconstruct:smeltery/casting/emerald/gem_sand_cast" | "minecraft:bamboo_slab" | "minecraft:dark_oak_chest_boat" | "create:milling/compat/biomesoplenty/goldenrod" | "railways:stonecutting/palettes/cycling/white_flat_slashed_locometal" | "minecraft:black_banner" | "tconstruct:armor/repair/plate_station" | "minecraft:iron_shovel" | "tconstruct:tools/modifiers/slotless/rebalanced_upgrades" | "tconstruct:smeltery/melting/metal/iron/chain" | "ae2:smelting/smooth_sky_stone_block" | "create:cut_scoria_slab" | "ad_astra:space_suit" | "molten_metals:splashing/gold_ingot_from_ceramic_mold" | "minecraft:birch_hanging_sign" | "create:splashing/red_sand" | "farmersdelight:cutting/jungle_log" | "railways:sequenced_assembly/track_crimson_wide" | "tconstruct:smeltery/casting/filling/scorched_fuel_tank" | "iceandfire:dragonarmor_netherite_neck" | "create:emptying/builders_tea" | "iceandfire:tide_deepblue_leggings" | "create:calcite_pillar_from_stone_types_calcite_stonecutting" | "railways:crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal_boiler" | "iceandfire:hydra_arrow" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_maple_log_to_maple_planks" | "create:crushing/deepslate_emerald_ore" | "powah:crafting/ender_cell_nitro" | "ae2:special/facade" | "minecraft:cooked_chicken" | "ad_astra:space_station/earth_orbit_space_station" | "ae2:decorative/sky_stone_brick" | "biomesoplenty:jacaranda_boat" | "minecraft:oak_door" | "biomesoplenty:redwood_fence" | "tconstruct:tools/modifiers/slotless/embellishment_netherite" | "tconstruct:tools/severing/snow_golem_head" | "biomesoplenty:jacaranda_stairs" | "create:cutting/runtime_generated/compat/minecraft/birch_planks_to_birch_fence_gate" | "tconstruct:tools/materials/wood/planks/acacia" | "railways:crafting/semaphore" | "tconstruct:armor/building/slime_skull/gold" | "tconstruct:smeltery/casts/red_sand_casts/nuggets" | "tconstruct:tools/modifiers/upgrade/lightspeed_armor_from_dust" | "ad_astra:coal_generator" | "railways:crafting/palettes/dyeing_1x/magenta_flat_slashed_locometal" | "minecraft:polished_diorite_stairs_from_diorite_stonecutting" | "create:cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "tconstruct:gadgets/frame/manyullyn" | "farmersdelight:beetroot_from_crate" | "powah:crafting/energy_discharger_niotic" | "tconstruct:tables/crafting_table_repair" | "molten_metals:mixing/molten_copper_from_nugget" | "minecraft:spruce_door" | "sophisticatedbackpacks:smelting_upgrade" | "powah:crafting/dielectric_rod" | "ae2:network/cables/dense_smart_white" | "create:crafting/kinetics/propeller" | "tconstruct:gadgets/shuriken/flint_shuriken" | "farmersdelight:cooked_salmon_slice_from_smoking" | "tconstruct:tools/materials/casting/amethyst_bronze" | "ae2:shaped/stairs/sky_stone_brick" | "molten_metals:mixing/molten_copper_from_ingot" | "create:cutting/runtime_generated/compat/minecraft/stripped_birch_wood_to_birch_planks" | "tconstruct:tools/materials/glass" | "railways:crafting/palettes/dyeing_8x/black_locometal_pillar" | "farmersdelight:straw" | "tconstruct:tools/modifiers/salvage/ability/luck" | "ad_astra:mars_stone_bricks" | "create:cut_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "minecraft:dark_prismarine" | "railways:stonecutting/palettes/cycling/yellow_flat_slashed_locometal" | "tconstruct:smeltery/melting/metal/copper/cut_block" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_planks_to_fir_sign" | "railways:crafting/palettes/dyeing_8x/green_copper_wrapped_locometal_boiler" | "minecraft:leather_horse_armor" | "tconstruct:world/wood/greenheart/log_to_wood" | "ae2:network/cables/glass_magenta" | "createaddition:mechanical_crafting/alternator" | "minecraft:candle" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "tconstruct:smeltery/melting/slime/ender/bud_small" | "ae2:smelting/silicon_from_certus_quartz_dust" | "railways:crafting/palettes/wrapping/brown_copper_wrapped_locometal" | "tconstruct:common/glass/gray_clear_stained_glass_pane_from_panes" | "tconstruct:gadgets/throwball/glow_ball" | "railways:crafting/palettes/dyeing_1x/light_gray_locometal_pillar" | "biomesoplenty:fir_chest_boat" | "ae2:network/blocks/spatial_io_port" | "tconstruct:world/wood/bloodshroom/trapdoor" | "minecraft:deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "create:cut_calcite_slab_recycling" | "farmersdelight:cutting/cornflower" | "tconstruct:smeltery/melting/metal/iron/small" | "railways:mechanical_crafting/light_gray_locometal_boiler" | "iceandfire:dragonsteel_lightning_shovel" | "create:cut_ochrum_slab_recycling" | "tconstruct:tables/dagger_recycling" | "iceandfire:sea_serpent_scale_block_blue_to_sea_serpent_scales_blue" | "farmersdelight:cutting/deepslate" | "create:tiled_glass_from_colorless_glass_stonecutting" | "iceandfire:tide_green_leggings" | "tconstruct:tools/materials/copper/block" | "molten_metals:splashing/bronze_ingot_from_metal_mold" | "biomesoplenty:umbran_fence_gate" | "railways:crafting/palettes/dyeing_1x/cyan_locometal_boiler" | "iceandfire:dragonscale_white_to_dragonscales_white" | "minecraft:jungle_slab" | "tconstruct:tools/materials/pig_iron/ingot" | "tconstruct:tools/materials/wood/logs/jungle" | "create:crushing/mars_diamond_ore" | "farmersdelight:cutting/birch_wood" | "tconstruct:common/glass/lime_clear_stained_glass_pane_from_panes" | "minecraft:skull_banner_pattern" | "tconstruct:tools/materials/composite/scorched_stone" | "biomesoplenty:hellbark_fence" | "railways:stonecutting/palettes/cycling/black_flat_slashed_locometal" | "molten_metals:emptying/molten_netherite_from_ceramic_mold" | "farmersdelight:shepherds_pie_block" | "farmersdelight:cutting/warped_sign" | "create:deploying/weathered_copper_tile_stairs_from_removing_wax" | "tconstruct:world/wood/skyroot/pressure_plate" | "createaddition:charging/weathered_copper" | "powah:energizing/blazing_crystal" | "minecraft:granite" | "minecraft:melon_seeds" | "railways:crafting/palettes/dyeing_1x/light_gray_riveted_locometal" | "railways:mechanical_crafting/cyan_iron_wrapped_locometal_boiler" | "tconstruct:smeltery/melting/metal/copper/smeltery_io" | "biomesoplenty:mahogany_hanging_sign" | "minecraft:black_dye_from_wither_rose" | "tconstruct:smeltery/scorched/polished_scorched_stone_crafting" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_log_to_stripped_empyreal_log" | "hexcasting:stonecutting/quenched_allay_bricks" | "ad_astra:steel_plating_stairs" | "tconstruct:tools/modifiers/ability/luck_crystal" | "railways:crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal_boiler" | "tconstruct:common/slime/earth/crystal_smelting" | "create:haunting/soul_campfire" | "hexical:animated_scroll_medium" | "farmersdelight:cutting/kelp_roll" | "ad_astra:polished_glacio_stone" | "tconstruct:tools/severing/magma_cream" | "railways:crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal" | "railways:crafting/palettes/dyeing_8x/white_locometal_boiler" | "minecraft:dye_yellow_carpet" | "iceandfire:silver_shovel" | "ae2:network/cables/glass_yellow" | "tconstruct:smeltery/casting/water/yellow_concrete" | "ae2:shaped/walls/quartz_bricks" | "create:cut_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "minecraft:dye_white_wool" | "iceandfire:dragonforge_lightning_core_disabled" | "tconstruct:tools/modifiers/slotless/embellishment_ender" | "create:crafting/kinetics/brown_seat_from_other_seat" | "railways:crafting/palettes/dyeing_1x/light_gray_locometal_smokebox" | "create:deploying/waxed_exposed_cut_copper_stairs_from_adding_wax" | "tconstruct:common/materials/slimesteel_ingot_from_block" | "create:crafting/logistics/stock_ticker_clear" | "tconstruct:common/glass/purple_clear_stained_glass_pane" | "minecraft:packed_ice" | "biomesoplenty:hellbark_hanging_sign" | "ad_astra:ostrum_ingot_from_ostrum_block" | "biomesoplenty:hellbark_fence_gate" | "ae2:matter_cannon/nuggets/zinc" | "resourcechickens:nest" | "railways:stonecutting/palettes/cycling/pink_locometal_pillar" | "tconstruct:tools/modifiers/ability/parrying" | "tconstruct:smeltery/casting/filling/seared_lantern_pixel" | "ad_astra:calorite_tank" | "iceandfire:dread_stone_slab" | "simplylight:illuminant_cyan_block_dyed" | "minecraft:deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "tconstruct:smeltery/melting/scorched/gauge" | "create:crafting/kinetics/copper_door" | "create:crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "create:andesite_bars_from_andesite_alloy_stonecutting" | "railways:crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal_boiler" | "biomesoplenty:dead_hanging_sign" | "extendedae:tape" | "ae2:tools/paintballs_brown" | "railways:sequenced_assembly/track_mangrove_wide" | "minecraft:cobbled_deepslate_wall" | "minecraft:purpur_slab_from_purpur_block_stonecutting" | "railways:sequenced_assembly/track_tieless_wide" | "ae2:tools/paintballs_lumen_magenta" | "create:polished_cut_limestone_slab_recycling" | "railways:crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal" | "tconstruct:smeltery/alloys/molten_rose_gold" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_log_to_stripped_willow_log" | "simplylight:illuminant_orange_block_on_dyed" | "ad_astra:oxygen_gear" | "create:polished_cut_crimsite_wall" | "minecraft:smooth_stone" | "tconstruct:tools/modifiers/upgrade/tank" | "ae2:decorative/chiseled_quartz_block_from_stonecutting" | "tconstruct:tools/materials/amethyst_bronze/ingot" | "create:milling/pink_petals" | "create:mangrove_window_pane" | "tconstruct:tools/materials/melting/iron" | "railways:crafting/palettes/dyeing_1x/cyan_locometal_pillar" | "minecraft:purple_carpet" | "tconstruct:tools/modifiers/salvage/upgrade/fiery" | "tconstruct:smeltery/melting/metal/cobalt/raw" | "tconstruct:smeltery/melting/metal/gold/platform" | "railways:sequenced_assembly/track_tieless" | "minecraft:polished_granite_slab_from_granite_stonecutting" | "createoreexcavation:crushing/redstone_crushing" | "create:ornate_iron_window" | "create:cutting/runtime_generated/compat/minecraft/spruce_planks_to_spruce_fence_gate" | "biomesoplenty:maple_hanging_sign" | "tconstruct:tools/materials/wood/planks/warped" | "minecraft:ender_eye" | "create:crushing/obsidian" | "farmersdelight:apple_pie_from_slices" | "create:cut_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "tconstruct:smeltery/casting/lavawood" | "minecraft:birch_slab" | "create:cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "railways:stonecutting/palettes/cycling/orange_riveted_locometal" | "iceandfire:furnace/frozen_dirt" | "railways:stonecutting/palettes/cycling/orange_flat_riveted_locometal" | "create:milling/gravel" | "railways:stonecutting/palettes/cycling/blue_locometal_pillar" | "sophisticatedbackpacks:battery_upgrade" | "tconstruct:smeltery/seared/channel" | "hextended:long/extended_edified" | "tconstruct:tools/modifiers/salvage/upgrade/punch" | "minecraft:waxed_cut_copper_stairs" | "minecraft:quartz_bricks_from_quartz_block_stonecutting" | "create:crafting/logistics/lime_postbox_from_other_postbox" | "railways:crafting/palettes/dyeing_1x/white_plated_locometal" | "minecraft:pink_stained_glass_pane_from_glass_pane" | "tconstruct:tools/modifiers/worktable/enchantment_converting/slotless_book" | "railways:stonecutting/palettes/cycling/light_gray_flat_riveted_locometal" | "hexical:hex_candle" | "minecraft:stone_hoe" | "create:cut_deepslate_brick_wall" | "tconstruct:smeltery/casts/gold_casts/nuggets" | "tconstruct:common/materials/hepatizon_block_from_ingots" | "iceandfire:delight/cooked_rice_with_fire_dragon_meat" | "ad_astra:polished_moon_stone" | "create:smelting/silver_ingot_compat_iceandfire" | "ae2:block_cutter/walls/quartz_wall" | "ae2:network/blocks/io_condenser" | "minecraft:exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "tconstruct:smeltery/melting/metal/slimesteel/block" | "tconstruct:smeltery/melting/metal/soulsteel/block" | "sophisticatedbackpacks:smoking_upgrade" | "minecraft:cooked_mutton_from_campfire_cooking" | "ad_astra:stonecutting/glacio_pillar_from_glacio_stone_bricks_stonecutting" | "minecraft:dye_black_wool" | "create:small_scoria_bricks_from_stone_types_scoria_stonecutting" | "tconstruct:smeltery/casting/metal/electrum/ingot_sand_cast" | "ad_astra:small_green_industrial_lamp" | "minecraft:cooked_beef" | "createaddition:charging/exposed_copper_shingle_stairs" | "biomesoplenty:dead_trapdoor" | "minecraft:oxidized_cut_copper" | "tconstruct:tables/part_builder" | "tconstruct:tools/modifiers/ability/crystalshot_amethyst" | "create:crushing/raw_gold" | "tconstruct:smeltery/casting/metal/knightslime/ingot_sand_cast" | "tconstruct:tools/materials/composite/copper_oxidized" | "minecraft:gold_nugget_from_smelting" | "tconstruct:tools/modifiers/salvage/ability/flamewake" | "minecraft:chiseled_quartz_block_from_quartz_block_stonecutting" | "create:filling/sweet_roll" | "ad_astra:stonecutting/venus_stone_stairs_from_venus_stone_stonecutting" | "resourcechickens:duck_egg_block" | "biomesoplenty:pine_button" | "tconstruct:smeltery/melting/metal/copper/cut_slab" | "railways:crafting/palettes/dyeing_8x/white_locometal_pillar" | "iceandfire:dragonsteel_ice_pickaxe" | "ad_astra:space_pants" | "ad_astra:stonecutting/polished_mars_stone_stairs_from_mars_stone_stonecutting" | "tconstruct:tools/materials/melting/chain" | "hextended:lesser_battery_staff" | "ae2:network/cables/dense_smart_black" | "ae2:materials/cardredstone" | "computercraft:turtle_advanced_overlays/turtle_trans_overlay" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_planks_to_mahogany_fence_gate" | "hexpigmentplus:magician_hat_round" | "molten_metals:slag_block" | "iceandfire:banners/banner_pattern_dread" | "minecraft:mangrove_pressure_plate" | "tconstruct:tools/modifiers/salvage/ability/autosmelt" | "tconstruct:tools/modifiers/salvage/ability/parrying" | "railways:crafting/palettes/wrapping/gray_iron_wrapped_locometal" | "create:crafting/kinetics/green_seat_from_other_seat" | "tconstruct:smeltery/casts/red_sand_casts/wires" | "create:framed_glass_pane_from_colorless_glass_panes_stonecutting" | "create:cut_veridium_from_stone_types_veridium_stonecutting" | "tconstruct:common/materials/rose_gold_block_from_ingots" | "ae2:decorative/cut_quartz_block_from_stonecutting" | "farmersdelight:pink_canvas_sign" | "minecraft:weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "create:small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/bamboo_planks_to_bamboo_trapdoor" | "create:deploying/waxed_weathered_copper_tiles_from_adding_wax" | "ae2:shaped/slabs/cut_quartz_block" | "hextended:obsidian_staff" | "tconstruct:smeltery/casting/seared/brick_composite" | "iceandfire:stonecutter/dread_stone_bricks" | "tconstruct:tools/modifiers/salvage/upgrade/sticky" | "iceandfire:sea_serpent_scales_blue_to_sea_serpent_scale_block_blue" | "create:small_scorchia_brick_slab" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_jacaranda_wood_to_jacaranda_planks" | "railways:sequenced_assembly/track_biomesoplenty_palm" | "create:crushing/emerald_ore" | "ae2:network/cells/item_storage_components_cell_1k_part" | "tconstruct:smeltery/casting/filling/seared_ingot_tank" | "ad_astra:glacio_stone_brick_wall" | "iceandfire:tide_bronze_chestplate" | "ad_astra:jet_suit_pants" | "farmersdelight:cooked_mutton_chops" | "tconstruct:tools/modifiers/slotless/embellishment_brass" | "ad_astra:iron_rod" | "tconstruct:tools/modifiers/seared_reinforcement" | "tconstruct:smeltery/melting/metal/iron/axes" | "ae2:shaped/walls/smooth_quartz_block" | "minecraft:shulker_box_coloring" | "railways:stonecutting/palettes/cycling/magenta_locometal_pillar" | "tconstruct:tools/materials/gold/ingot" | "ae2:block_cutter/slabs/smooth_sky_stone_slab" | "railways:crafting/palettes/dyeing_1x/magenta_locometal_smokebox" | "create:weathered_copper_shingle_stairs" | "create:crafting/logistics/redstone_link" | "minecraft:deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "railways:sequenced_assembly/track_spruce_wide" | "create:small_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "minecraft:enchanting_table" | "minecraft:white_glazed_terracotta" | "tconstruct:tools/modifiers/worktable/modifier_sorting" | "tconstruct:tools/parts/casting/broad_blade_gold_cast" | "tconstruct:smeltery/melting/metal/emerald/reinforcement" | "minecraft:lead" | "farmersdelight:roast_chicken_block" | "railways:crafting/palettes/dyeing_8x/white_flat_slashed_locometal" | "create:cut_asurine_from_stone_types_asurine_stonecutting" | "railways:sequenced_assembly/track_crimson" | "ad_astra:ostrum_plating_pressure_plate" | "ad_astra:small_blue_industrial_lamp" | "ae2:block_cutter/slabs/smooth_quartz_slab" | "railways:stonecutting/palettes/cycling/locometal_pillar" | "classicpipes:lapis_pipe" | "comforts:hammock_to_yellow" | "tconstruct:tools/modifiers/salvage/upgrade/haste" | "iceandfire:frost_troll_leather_leggings" | "railways:stonecutting/palettes/cycling/black_locometal_smokebox" | "classicpipes:jungle_fluid_pipe_b" | "tconstruct:smeltery/melting/metal/silver/ingot" | "farmersdelight:cooked_chicken_cuts" | "classicpipes:jungle_fluid_pipe_a" | "minecraft:stripped_spruce_wood" | "minecraft:acacia_wood" | "railways:crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal" | "create:dripstone_pillar_from_stone_types_dripstone_stonecutting" | "ad_astra:smelting/cracked_moon_stone_bricks_from_smelting_moon_stone_bricks" | "railways:crafting/palettes/dyeing_8x/purple_flat_slashed_locometal" | "powah:crafting/ender_cell_basic" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_fence_gate" | "create:acacia_window_pane" | "create:cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "railways:crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal_boiler" | "railways:sequenced_assembly/pink_conductor_cap" | "tconstruct:tools/modifiers/salvage/ability/gilded" | "create:cut_diorite_brick_wall" | "farmersdelight:cutting/beef" | "tconstruct:tools/materials/casting/glass" | "ad_astra:blasting/gold_ingot_from_blasting_venus_gold_ore" | "create:sequenced_assembly/precision_mechanism" | "iceandfire:deathworm_white_leggings" | "tconstruct:smeltery/casting/ender/pearl" | "railways:crafting/palettes/dyeing_1x/light_gray_flat_riveted_locometal" | "tconstruct:tools/materials/wood/planks/birch" | "comforts:sleeping_bag_to_lime" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_wood_to_stripped_magic_wood" | "tconstruct:tools/materials/casting/electrum" | "molten_metals:mixing/molten_copper_from_block_raw" | "biomesoplenty:magic_door" | "farmersdelight:bread_from_smoking" | "ad_astra:desh_plating_slab" | "create:cut_scorchia_wall" | "ae2:network/cables/dense_smart_green" | "biomesoplenty:maple_planks" | "extendedae:wireless_tool" | "tconstruct:tools/parts/casting/small_blade_composite" | "create:polished_cut_deepslate_wall" | "tconstruct:tools/repair/flint_and_brick_scorched_station" | "ad_astra:light_blue_flag" | "create:cut_crimsite_slab_recycling" | "create:milling/calcite" | "create:crafting/logistics/yellow_table_cloth_from_other_table_cloth" | "classicpipes:diamond_fluid_pipe_b" | "molten_metals:splashing/iron_ingot_from_metal_mold" | "classicpipes:diamond_fluid_pipe_a" | "tconstruct:tools/parts/casting/tough_handle_sand_cast" | "create:crafting/kinetics/light_gray_seat" | "powah:crafting/dielectric_paste" | "tconstruct:smeltery/melting/slime/ender/sling" | "tconstruct:tools/materials/slimesteel/block" | "ad_astra:lime_flag" | "create:cutting/runtime_generated/compat/minecraft/stripped_cherry_log_to_cherry_planks" | "minecraft:waxed_cut_copper_slab" | "create:haunting/lapis_recycling" | "tconstruct:smeltery/seared/duct_retextured" | "iceandfire:tide_deepblue_chestplate" | "tconstruct:tools/materials/casting/ender_pearl" | "resourcechickens:cooked_catcher_duck_smoking" | "create:cutting/runtime_generated/compat/biomesoplenty/magic_planks_to_magic_fence" | "simplylight:illuminant_light_blue_block_dyed" | "hexpigmentplus:magician_hat_hay" | "tconstruct:tools/materials/seared_stone/brick" | "ae2:inscriber/ender_dust" | "railways:stonecutting/palettes/cycling/cyan_riveted_locometal" | "hexcasting:compat/farmersdelight/cutting/akashic_wood" | "ad_astra:smelting/cracked_permafrost_bricks_from_smelting_permafrost_bricks" | "create:crushing/gravel" | "create:crafting/kinetics/gearbox" | "tconstruct:tools/modifiers/salvage/ability/ambidextrous" | "iceandfire:furnace/frozen_grass_path" | "create:deploying/exposed_copper_tile_stairs_from_deoxidising" | "create:crafting/logistics/andesite_table_cloth_clear" | "minecraft:cyan_dye_from_pitcher_plant" | "create:small_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "railways:stonecutting/palettes/cycling/magenta_riveted_locometal" | "minecraft:leather_helmet" | "minecraft:light_blue_bed" | "ae2:network/parts/panels_semi_dark_monitor_alt" | "ae2:block_cutter/slabs/sky_stone_brick_slab" | "comforts:sleeping_bag_to_blue" | "minecraft:nether_brick_stairs" | "railways:mechanical_crafting/lime_copper_wrapped_locometal_boiler" | "ad_astra:stonecutting/mars_stone_brick_wall_from_mars_stone_bricks_stonecutting" | "tconstruct:smeltery/melting/metal/steel/rod" | "create:deploying/waxed_oxidized_copper_tile_slab_from_adding_wax" | "ad_astra:polished_mercury_stone" | "minecraft:recovery_compass" | "biomesoplenty:palm_button" | "minecraft:magenta_bed" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "ad_astra:calorite_panel" | "minecraft:magenta_dye_from_blue_red_white_dye" | "create:deploying/large_cogwheel" | "minecraft:cherry_fence" | "resourcechickens:cooked_catcher_campfire" | "create:crafting/logistics/light_blue_postbox_from_other_postbox" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_planks_to_fir_button" | "tconstruct:smeltery/melting/quartz/daylight_detector" | "ae2:network/cables/covered_red" | "tconstruct:smeltery/casting/water/green_concrete" | "create:cut_granite_brick_slab_recycling" | "tconstruct:smeltery/melting/slime/mushroom_stew" | "create:cherry_window" | "ad_astra:stonecutting/chiseled_mercury_stone_slab_from_chiseled_mercury_stone_bricks_stonecutting" | "ae2:tools/paintballs_lumen_black" | "minecraft:pink_terracotta" | "create:crafting/kinetics/black_valve_handle_from_other_valve_handle" | "minecraft:spire_armor_trim_smithing_template_smithing_trim" | "railways:crafting/palettes/dyeing_8x/white_copper_wrapped_locometal" | "iceandfire:armor_silver_metal_boots" | "tconstruct:smeltery/casts/red_sand_casts/rods" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_pine_log_to_pine_planks" | "ae2:materials/cardfuzzy" | "powah:crafting/energy_discharger_hardened" | "tconstruct:common/materials/pig_iron_nugget_from_ingot" | "railways:crafting/palettes/dyeing_8x/brown_locometal_boiler" | "ad_astra:venus_stone_brick_stairs" | "ad_astra:permafrost_bricks" | "ae2:shaped/walls/chiseled_quartz_block" | "create:cutting/strophar_caps" | "create:filling/chocolate_glazed_berries" | "tconstruct:tools/materials/string" | "create:small_andesite_bricks_from_stone_types_andesite_stonecutting" | "ae2:network/cables/smart_fluix_clean" | "hexcasting:artifact" | "biomesoplenty:jacaranda_wood" | "ae2:network/parts/annihilation_plane_alt" | "ad_astra:iron_plating_slab" | "sophisticatedbackpacks:advanced_pump_upgrade" | "railways:stonecutting/palettes/cycling/black_locometal_pillar" | "ae2:network/blocks/energy_energy_cell" | "iceandfire:dragonarmor_dragon_steel_fire_neck" | "railways:crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal" | "tconstruct:common/slime/ender/slimeball_from_block" | "railways:crafting/small_buffer" | "create:crafting/logistics/package_frogport" | "computercraft:pocket_advanced/computercraft/wireless_modem_advanced" | "ad_astra:stonecutting/glacio_stone_brick_slab_from_glacio_stone_stonecutting" | "createaddition:charging/cut_copper_block" | "minecraft:prismarine_stairs" | "railways:sequenced_assembly/track_birch" | "tconstruct:smeltery/casting/obsidian/pane" | "hexcasting:focus" | "minecraft:white_dye" | "tconstruct:smeltery/melting/metal/iron/crossbow" | "createoreexcavation:ore_vein_type/emerald" | "ad_astra:stonecutting/moon_stone_brick_stairs_from_moon_stone_bricks_stonecutting" | "tconstruct:tools/modifiers/upgrade/sharpness_from_shard" | "railways:crafting/palettes/dyeing_1x/orange_plated_locometal" | "farmersdelight:organic_compost_from_tree_bark" | "biomesoplenty:red_maple_leaf_pile" | "ad_astra:magenta_industrial_lamp" | "biomesoplenty:mahogany_boat" | "minecraft:wild_armor_trim_smithing_template_smithing_trim" | "create:polished_cut_granite_slab" | "create:polished_cut_veridium_stairs" | "biomesoplenty:palm_chest_boat" | "simplylight:illuminant_cyan_block_on_dyed" | "minecraft:brown_stained_glass" | "tconstruct:tools/materials/wood/planks/crimson" | "minecraft:tinted_glass" | "ae2:tools/paintballs_lumen_light_blue" | "biomesoplenty:redwood_fence_gate" | "ae2:network/cells/spatial_storage_cell_2_cubed_storage" | "minecraft:lodestone" | "create:crafting/kinetics/yellow_seat_from_other_seat" | "ad_astra:stonecutting/venus_stone_brick_wall_from_venus_stone_stonecutting" | "railways:crafting/palettes/dyeing_1x/purple_locometal_pillar" | "create:cut_ochrum_from_stone_types_ochrum_stonecutting" | "minecraft:cut_copper_stairs_from_copper_block_stonecutting" | "hexcasting:stonecutting/quenched_allay_tiles" | "iceandfire:troll_tusk_bonemeal" | "create:crafting/kinetics/speedometer" | "farmersdelight:potato_from_crate" | "ad_astra:calorite_plating_stairs" | "create:granite_from_stone_types_granite_stonecutting" | "minecraft:stone_stairs" | "tconstruct:tools/materials/skyslime_vine" | "minecraft:dried_kelp_block" | "tconstruct:tools/materials/rock/andesite" | "biomesoplenty:magenta_dye_from_wildflower" | "biomesoplenty:pine_trapdoor" | "minecraft:quartz" | "minecraft:nether_brick_wall" | "hexcasting:compat/farmersdelight/cutting/edified_log" | "createaddition:crafting/redstone_relay" | "railways:stonecutting/palettes/cycling/red_plated_locometal" | "create:deploying/waxed_weathered_copper_shingle_slab_from_adding_wax" | "ad_astra:venus_sandstone_brick_slab" | "hexcasting:amethyst_bricks_from_amethyst_bricks_small" | "farmersdelight:beef_patty_from_campfire_cooking" | "railways:crafting/palettes/dyeing_1x/green_plated_locometal" | "railways:mechanical_crafting/iron_wrapped_locometal_boiler" | "tconstruct:tools/modifiers/upgrade/speedy_from_dust" | "iceandfire:dragonbone_pickaxe" | "biomesoplenty:empyreal_wood" | "tconstruct:gadgets/throwball/efln_ball" | "create:polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "tconstruct:tools/modifiers/worktable/enchantment_converting/unenchant_book" | "iceandfire:armor_copper_metal_chestplate" | "resourcechickens:catcher" | "powah:crafting/solar_panel_nitro" | "agricraft:obsidian_crop_sticks" | "powah:crafting/reactor_spirited" | "tconstruct:tools/modifiers/salvage/upgrade/trueshot" | "computercraft:turtle_advanced/minecraft/diamond_shovel" | "sophisticatedbackpacks:upgrade_base" | "ae2:network/cables/covered_cyan" | "comforts:rope_and_nail" | "ae2:block_cutter/slabs/sky_stone_slab" | "ad_astra:stonecutting/moon_stone_bricks_from_moon_stone_stonecutting" | "ae2:network/parts/terminals" | "hextended:long/extended_dark_oak" | "iceandfire:dragonsteel_ice_sword" | "ad_astra:glowing_desh_pillar" | "biomesoplenty:willow_hanging_sign" | "tconstruct:smeltery/melting/metal/gold/reinforcement" | "hexcasting:decompose_quenched_shard/charged" | "minecraft:orange_dye_from_orange_tulip" | "create:milling/peony" | "create:polished_cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "railways:crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal" | "ae2:network/blocks/energy_energy_acceptor" | "tconstruct:smeltery/melting/quartz/gem_1" | "factory_blocks:mason_table" | "tconstruct:smeltery/melting/metal/gold/powered_rail" | "minecraft:blue_carpet" | "hexcasting:dye_colorizer_purple" | "railways:sequenced_assembly/blue_conductor_cap" | "railways:mechanical_crafting/cyan_brass_wrapped_locometal_boiler" | "create:cut_dripstone_brick_slab" | "ad_astra:strophar_stairs" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_planks_to_dark_oak_fence_gate" | "classicpipes:diamond_pipe" | "comforts:sleeping_bag_cyan" | "tconstruct:tools/modifiers/upgrade/zoom" | "create:cut_diorite_wall_from_stone_types_diorite_stonecutting" | "tconstruct:tools/materials/blazing_bone" | "tconstruct:tools/modifiers/upgrade/experienced" | "railways:crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal" | "farmersdelight:barbecue_stick" | "iceandfire:legendary_dragon_seeker" | "ae2:network/blocks/spatial_anchor" | "ad_astra:permafrost_brick_stairs" | "biomesoplenty:redwood_planks" | "create:cutting/runtime_generated/compat/tconstruct/greenheart_wood_to_stripped_greenheart_wood" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_planks_to_fir_fence" | "create:small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "tconstruct:tools/modifiers/slotless/embellishment_steel" | "farmersdelight:stuffed_potato" | "ad_astra:calorite_nugget" | "tconstruct:smeltery/casting/water/black_concrete" | "hexcasting:pride_colorizer_bisexual" | "powah:crafting/ender_gate_niotic" | "create:small_diorite_bricks_from_stone_types_diorite_stonecutting" | "ae2:network/crafting/cpu_crafting_monitor" | "create:cut_granite_bricks_from_stone_types_granite_stonecutting" | "create:deploying/waxed_weathered_cut_copper_from_adding_wax" | "create:milling/andesite" | "hexpigmentplus:magician_hat_hay_bowl" | "iceandfire:armor_copper_boots" | "farmersdelight:cooking/rabbit_stew" | "minecraft:cooked_chicken_from_smoking" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_planks_to_hellbark_pressure_plate" | "create:splashing/runtime_generated/compat/minecraft/light_gray_concrete_powder_to_light_gray_concrete" | "create:cutting/runtime_generated/compat/tconstruct/bloodshroom_planks_to_bloodshroom_pressure_plate" | "minecraft:cut_red_sandstone_from_red_sandstone_stonecutting" | "iceandfire:dragonarmor_silver_tail" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "tconstruct:tools/parts/casting/small_blade_sand_cast" | "ad_astra:stonecutting/polished_mars_stone_slab_from_mars_stone_stonecutting" | "biomesoplenty:stripped_umbran_wood" | "ae2:network/blocks/storage_chest" | "iceandfire:banners/banner_pattern_eye" | "create:crafting/appliances/attribute_filter_clear" | "tconstruct:smeltery/casting/slime/earth/slimeball" | "minecraft:dripstone_block" | "minecraft:mangrove_chest_boat" | "minecraft:iron_hoe" | "minecraft:jungle_hanging_sign" | "ad_astra:nasa_workbench/tier_4_rocket_from_nasa_workbench" | "create:milling/compat/biomesoplenty/waterlily" | "railways:crafting/palettes/dyeing_1x/purple_locometal_smokebox" | "create:crushing/golden_horse_armor" | "tconstruct:smeltery/alloys/molten_slimesteel" | "ad_astra:glacian_fence" | "railways:crafting/palettes/dyeing_1x/light_gray_locometal_boiler" | "create:compacting/blaze_cake" | "create:brass_bars_from_brass_ingots_stonecutting" | "biomesoplenty:empyreal_pressure_plate" | "ad_astra:stonecutting/chiseled_mars_stone_slab_from_chiseled_mars_stone_bricks_stonecutting" | "tconstruct:tools/severing/mooshroom_shroom" | "create:deploying/copper_tile_slab_from_deoxidising" | "minecraft:jungle_trapdoor" | "tconstruct:smeltery/seared/seared_bricks_wall_stonecutter" | "ae2:tools/portable_fluid_cell_256k" | "tconstruct:tools/severing/zombie_head" | "molten_metals:mixing/molten_iron_from_ingot" | "ad_astra:stonecutting/permafrost_brick_stairs_from_permafrost_bricks_stonecutting" | "tconstruct:smeltery/seared/lantern" | "tconstruct:common/firewood/nahuatl_slab" | "createaddition:liquid_burning/biofuel" | "ad_astra:small_light_blue_industrial_lamp" | "railways:crafting/palettes/dyeing_8x/blue_locometal_pillar" | "ae2:tools/paintballs_orange" | "railways:crafting/palettes/dyeing_1x/brown_locometal_boiler" | "create:crushing/deepslate_ostrum_ore" | "biomesoplenty:hellbark_door" | "classicpipes:tag_label_a" | "classicpipes:tag_label_b" | "sophisticatedbackpacks:filter_upgrade" | "railways:crafting/palettes/dyeing_8x/green_copper_wrapped_locometal" | "iceandfire:deathworm_red_helmet" | "tconstruct:tables/part_chest" | "biomesoplenty:magic_planks" | "tconstruct:smeltery/casting/slime/blood/bone" | "ae2:network/cables/dense_covered_purple" | "create:deploying/waxed_exposed_copper_tile_slab_from_adding_wax" | "create:polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "ad_astra:smelting/cheese_from_smelting_moon_cheese_ore" | "ae2:network/cables/dense_smart_blue" | "tconstruct:tools/parts/casting/tough_handle_composite" | "create:tiled_glass_pane_from_colorless_glass_panes_stonecutting" | "minecraft:polished_blackstone_slab_from_polished_blackstone_stonecutting" | "railways:crafting/palettes/dyeing_1x/green_brass_wrapped_locometal" | "hexcasting:slate_amethyst_tiles" | "iceandfire:armor_bronze_leggings" | "create:deploying/waxed_weathered_cut_copper_slab_from_adding_wax" | "tconstruct:smeltery/melting/obsidian/chest" | "minecraft:target" | "hexcasting:patchi_book" | "ae2:decorative/quartz_fixture_from_anchors" | "minecraft:orange_carpet" | "create:crafting/logistics/white_table_cloth_from_other_table_cloth" | "tconstruct:smeltery/casting/filling/scorched_lantern_pixel" | "create:cutting/runtime_generated/compat/minecraft/crimson_planks_to_crimson_fence" | "create:campfire_cooking/bread" | "tconstruct:tools/modifiers/upgrade/step_up" | "tconstruct:smeltery/melting/slime/ender/crystal" | "create:weathered_iron_window_pane" | "create:small_limestone_brick_wall" | "create:crushing/tuff" | "create:cut_limestone_wall" | "minecraft:mangrove_slab" | "tconstruct:smeltery/melting/glass/bottle" | "railways:crafting/palettes/dyeing_1x/brown_flat_riveted_locometal" | "farmersdelight:cutting/leather_boots" | "tconstruct:tools/parts/casting/broad_axe_head_sand_cast" | "hexcasting:default_colorizer" | "hexcasting:stonecutting/slate_bricks" | "create:crafting/logistics/orange_postbox_from_other_postbox" | "biomesoplenty:palm_sign" | "create:cutting/runtime_generated/compat/minecraft/stripped_cherry_wood_to_cherry_planks" | "create:cut_diorite_slab_recycling" | "tconstruct:common/basalt_blast_furnace" | "biomesoplenty:light_blue_dye_from_blue_hydrangea" | "tconstruct:tools/severing/blaze_rod" | "tconstruct:smeltery/scorched/scorched_brick_kiln" | "tconstruct:tools/modifiers/upgrade/farsighted" | "iceandfire:banners/banner_pattern_fae" | "iceandfire:sea_serpent_scales_teal_to_sea_serpent_scale_block_teal" | "iceandfire:dragonarmor_netherite_body" | "minecraft:chiseled_stone_bricks_stone_from_stonecutting" | "create:deploying/exposed_cut_copper_stairs_from_deoxidising" | "tconstruct:tools/parts/casting/repair_kit_gold_cast" | "computercraft:turtle_normal/minecraft/diamond_hoe" | "create:milling/rose_bush" | "railways:crafting/palettes/dyeing_8x/purple_flat_riveted_locometal" | "create:deploying/exposed_cut_copper_from_removing_wax" | "minecraft:netherite_sword_smithing" | "ae2:network/cables/dense_smart_lime" | "tconstruct:common/gold_bars" | "railways:stonecutting/palettes/cycling/flat_riveted_locometal" | "create:crafting/kinetics/mechanical_crafter" | "create:blasting/iron_ingot_from_crushed" | "farmersdelight:rice_bale" | "create:diorite_from_stone_types_diorite_stonecutting" | "railways:crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal_boiler" | "tconstruct:smeltery/casting/filling/bottle" | "create:crafting/logistics/green_table_cloth" | "tconstruct:tools/materials/casting/copper" | "hexical:animated_scroll_large" | "railways:stonecutting/palettes/cycling/yellow_flat_riveted_locometal" | "tconstruct:tools/modifiers/ability/unbreakable" | "tconstruct:tools/modifiers/upgrade/soulbound" | "minecraft:magenta_concrete_powder" | "minecraft:red_dye_from_poppy" | "create:small_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "minecraft:light_blue_candle" | "railways:crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal_boiler" | "tconstruct:smeltery/melting/metal/steel/nugget" | "biomesoplenty:chiseled_brimstone_bricks" | "createaddition:crafting/large_connector_electrum" | "minecraft:iron_ingot_from_blasting_deepslate_iron_ore" | "tconstruct:smeltery/casting/metal/netherite/debris_nugget_sand_cast" | "hexcasting:staff/acacia" | "hexcasting:stonecutting/amethyst_bricks_small" | "minecraft:deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "ad_astra:glowing_ostrum_pillar" | "tconstruct:tools/modifiers/salvage/ability/stripping" | "ae2:inscriber/calculation_processor_press" | "iceandfire:armor_black_chestplate" | "minecraft:mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "create:polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "farmersdelight:light_blue_hanging_canvas_sign" | "tconstruct:world/wood/skyroot/log_to_wood" | "minecraft:stone_bricks_from_stone_stonecutting" | "powah:crafting/magmator_spirited" | "iceandfire:silver_ingot_to_silver_block" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_fence" | "create:milling/oxeye_daisy" | "sophisticatedbackpacks:magnet_upgrade" | "ad_astra:blue_industrial_lamp" | "biomesoplenty:mossy_cobblestone_from_willow_vine" | "railways:crafting/palettes/dyeing_1x/yellow_flat_riveted_locometal" | "tconstruct:tools/materials/wood/planks/spruce" | "tconstruct:smeltery/melting/metal/copper/smeltery_controller" | "ae2:tools/paintballs_lumen_green" | "hexcasting:ancient_colorizer" | "tconstruct:tools/modifiers/salvage/upgrade/freezing" | "tconstruct:tools/modifiers/defense/projectile_protection" | "minecraft:yellow_banner" | "railways:crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal_boiler" | "tconstruct:smeltery/casting/quartz/gem_sand_cast" | "iceandfire:dragonscale_sapphire_to_dragonscales_sapphire" | "agricraft:iron_rake" | "ae2:inscriber/fluix_dust" | "minecraft:purpur_stairs_from_purpur_block_stonecutting" | "minecraft:soul_lantern" | "biomesoplenty:willow_pressure_plate" | "create:crafting/logistics/cyan_table_cloth_from_other_table_cloth" | "railways:crafting/palettes/dyeing_8x/green_iron_wrapped_locometal_boiler" | "ad_astra:stonecutting/glacio_stone_bricks_from_glacio_stone_stonecutting" | "minecraft:crimson_trapdoor" | "create:crafting/kinetics/mysterious_cuckoo_clock" | "tconstruct:smeltery/melting/quartz/gem" | "minecraft:dye_gray_bed" | "minecraft:firework_star_fade" | "hextended:long/extended_acacia" | "tconstruct:smeltery/melting/amethyst/block" | "farmersdelight:cooked_salmon_slice_from_campfire_cooking" | "create:crafting/logistics/pulse_repeater" | "create:small_scoria_brick_slab_recycling" | "minecraft:dye_light_gray_bed" | "minecraft:bamboo_stairs" | "simplylight:illuminant_lime_block_dyed" | "tconstruct:smeltery/casting/emerald/gem_gold_cast" | "create:polished_cut_tuff_slab_recycling" | "minecraft:smooth_basalt" | "minecraft:blue_concrete_powder" | "minecraft:blue_stained_glass" | "railways:sequenced_assembly/white_conductor_cap" | "minecraft:iron_ingot_from_smelting_deepslate_iron_ore" | "create:small_granite_brick_wall_from_stone_types_granite_stonecutting" | "create:splashing/runtime_generated/compat/minecraft/orange_concrete_powder_to_orange_concrete" | "minecraft:chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "tconstruct:common/mud_bricks_slab" | "create:small_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "create:small_granite_brick_slab" | "create:copper_shingle_slab" | "ad_astra:engine_frame" | "ad_astra:iron_panel" | "create:crushing/netherrack" | "hexcasting:trinket" | "farmersdelight:packed_mud_from_straw" | "minecraft:blue_candle" | "create:cut_ochrum_wall" | "ae2:network/cables/dense_covered_pink" | "iceandfire:siren_flute" | "create:cutting/runtime_generated/compat/minecraft/mangrove_planks_to_mangrove_fence" | "ae2:network/cables/glass_brown" | "create:crafting/logistics/pink_postbox_from_other_postbox" | "create:cutting/runtime_generated/compat/biomesoplenty/maple_planks_to_maple_pressure_plate" | "ae2:tools/portable_item_cell_256k" | "iceandfire:earplugs" | "minecraft:flower_banner_pattern" | "tconstruct:tools/materials/composite/whitestone_from_zinc" | "biomesoplenty:dead_fence" | "ad_astra:stonecutting/chiseled_venus_stone_bricks_from_venus_stone_bricks_stonecutting" | "ae2:network/parts/cable_anchor" | "biomesoplenty:orange_dye_from_burning_blossom" | "tconstruct:smeltery/melting/metal/netherite/boots" | "railways:crafting/palettes/dyeing_8x/white_slashed_locometal" | "tconstruct:tools/building/cleaver" | "tconstruct:common/glass/lime_clear_stained_glass" | "tconstruct:smeltery/casting/seared/stone/slab" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "hexpigmentplus:magician_hat_falling" | "ae2:entropy/cool/flowing_water_snowball" | "minecraft:gold_ingot_from_blasting_raw_gold" | "tconstruct:smeltery/alloys/molten_brass" | "minecraft:cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:gold_ingot_from_blasting_gold_ore" | "create:small_diorite_brick_slab" | "ad_astra:ti_69" | "classicpipes:crimson_fluid_pipe_a" | "classicpipes:crimson_fluid_pipe_b" | "biomesoplenty:smooth_white_sandstone_stairs_from_smooth_white_sandstone_stonecutting" | "tconstruct:tables/tinker_station_part_swapping" | "powah:crafting/ender_gate_nitro_2" | "create:cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "tconstruct:smeltery/scorched/polished_scorched_stone_stonecutting" | "create:smelting/zinc_ingot_from_raw_ore" | "tconstruct:smeltery/entity_melting/slime" | "create:crafting/logistics/light_gray_table_cloth_from_other_table_cloth" | "railways:crafting/palettes/dyeing_1x/white_flat_slashed_locometal" | "ad_astra:venus_cobblestone_slab" | "minecraft:purple_banner" | "extendedae:water_cell" | "ae2:transform/damaged_budding_quartz" | "create:cutting/runtime_generated/compat/hexcasting/edified_log_to_stripped_edified_log" | "create:jungle_window_pane" | "farmersdelight:straw_bale" | "create:deepslate_from_stone_types_deepslate_stonecutting" | "railways:crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal" | "create:cut_dripstone_slab" | "tconstruct:tools/parts/builder/bow_grip" | "tconstruct:tools/modifiers/slimesteel_reinforcement" | "minecraft:wooden_hoe" | "tconstruct:common/glass/black_clear_stained_glass" | "createoreexcavation:diamond_drill" | "create:cutting/runtime_generated/compat/minecraft/stripped_jungle_wood_to_jungle_planks" | "ae2:entropy/cool/water_ice" | "farmersdelight:gray_hanging_canvas_sign" | "railways:crafting/palettes/dyeing_1x/red_riveted_locometal" | "ae2:network/cables/glass_gray" | "create:small_limestone_bricks_from_stone_types_limestone_stonecutting" | "tconstruct:smeltery/casting/metal/zinc/nugget_gold_cast" | "railways:mechanical_crafting/yellow_iron_wrapped_locometal_boiler" | "ae2:network/blocks/crystal_processing_charger" | "tconstruct:tools/materials/melting/rose_gold" | "biomesoplenty:pine_door" | "biomesoplenty:black_sandstone_slab_from_black_sandstone_stonecutting" | "powah:crafting/solar_panel_basic" | "minecraft:waxed_oxidized_cut_copper_stairs" | "tconstruct:smeltery/melting/seared/lantern" | "tconstruct:tools/modifiers/ability/crystalshot_random" | "farmersdelight:cutting/leather_horse_armor" | "biomesoplenty:brimstone_bud" | "tconstruct:smeltery/casting/metal/brass/nugget_sand_cast" | "railways:crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal" | "railways:crafting/palettes/wrapping/blue_brass_wrapped_locometal" | "molten_metals:emptying/molten_zinc_from_metal_mold" | "tconstruct:smeltery/casting/glass/pane" | "railways:crafting/palettes/dyeing_8x/red_flat_riveted_locometal" | "minecraft:blackstone_stairs_from_blackstone_stonecutting" | "create:crafting/copper/waxed_weathered_copper_shingle_slab_from_honeycomb" | "minecraft:piston" | "railways:sequenced_assembly/track_warped_wide" | "ad_astra:smelting/ice_shard_from_smelting_moon_ice_shard_ore" | "iceandfire:dread_stone_bricks" | "minecraft:white_banner" | "minecraft:smooth_quartz" | "ae2:network/cells/item_storage_components_cell_16k_part" | "simplylight:illuminant_yellow_block_on_dyed" | "tconstruct:smeltery/melting/diamond/boots" | "create:milling/cocoa_beans" | "minecraft:cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "create:crafting/kinetics/train_trapdoor" | "tconstruct:smeltery/melting/metal/steel/ingot" | "tconstruct:tools/modifiers/upgrade/soulspeed" | "tconstruct:smeltery/casting/metal/amethyst_bronze/block" | "biomesoplenty:smooth_white_sandstone_slab" | "iceandfire:armor_amythest_chestplate" | "create:sequenced_assembly/sturdy_sheet" | "farmersdelight:fried_egg_from_campfire_cooking" | "farmersdelight:cutting/oak_log" | "ad_astra:stonecutting/venus_stone_brick_slab_from_venus_stone_bricks_stonecutting" | "biomesoplenty:pine_sign" | "biomesoplenty:gray_dye_from_wilted_lily" | "minecraft:diorite_stairs_from_diorite_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/fir_wood_to_stripped_fir_wood" | "powah:crafting/energy_cell_hardened" | "resourcechickens:egg_block" | "biomesoplenty:null_end_stone" | "tconstruct:tools/parts/builder/round_plate" | "comforts:rope_and_nail_shapeless" | "railways:crafting/big_buffer" | "tconstruct:smeltery/casts/gold_casts/large_plate" | "biomesoplenty:cut_orange_sandstone_slab_from_cut_orange_sandstone_stonecutting" | "create:small_limestone_brick_stairs" | "railways:crafting/palettes/wrapping/orange_copper_wrapped_locometal" | "minecraft:green_glazed_terracotta" | "comforts:sleeping_bag_to_white" | "createaddition:charging/channeling" | "create:crafting/kinetics/copper_valve_handle" | "create:deploying/waxed_oxidized_cut_copper_stairs_from_adding_wax" | "tconstruct:tools/severing/piglin_brute_head" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_planks_to_redwood_slab" | "tconstruct:smeltery/melting/slime/earth/crystal_block" | "create:small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "powah:crafting/solar_panel_starter" | "ad_astra:desh_cable" | "ad_astra:calorite_block" | "tconstruct:tools/parts/casting/tool_handle_sand_cast" | "railways:stonecutting/palettes/cycling/white_slashed_locometal" | "create:crafting/logistics/purple_table_cloth_from_other_table_cloth" | "tconstruct:smeltery/melting/metal/electrum/wire" | "createaddition:crafting/capacitor_1" | "tconstruct:smeltery/melting/metal/electrum/plates" | "iceandfire:deathworm_white_chestplate" | "createaddition:crafting/capacitor_2" | "railways:crafting/palettes/dyeing_1x/yellow_slashed_locometal" | "ae2:matter_cannon/nuggets/copper" | "tconstruct:tools/parts/casting/broad_axe_head_composite" | "hexical:grimoire" | "create:deploying/copper_shingle_slab_from_removing_wax" | "tconstruct:smeltery/casting/seared/stone/block_from_clay" | "create:crafting/logistics/white_postbox" | "railways:sequenced_assembly/track_biomesoplenty_palm_wide" | "farmersdelight:stove" | "ad_astra:stonecutting/venus_stone_brick_stairs_from_venus_stone_stonecutting" | "tconstruct:tools/modifiers/ability/gilded" | "railways:crafting/palettes/dyeing_8x/green_plated_locometal" | "create:cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "tconstruct:smeltery/casts/gold_casts/hammer_head" | "farmersdelight:carrot_crate" | "create:cutting/runtime_generated/compat/minecraft/acacia_planks_to_acacia_stairs" | "minecraft:tipped_arrow" | "minecraft:rib_armor_trim_smithing_template_smithing_trim" | "minecraft:light_blue_carpet" | "tconstruct:tools/materials/melting/silver" | "railways:mechanical_crafting/lime_iron_wrapped_locometal_boiler" | "create:polished_cut_granite_wall_from_stone_types_granite_stonecutting" | "powah:crafting/reactor_blazing" | "biomesoplenty:empyreal_trapdoor" | "ae2:inscriber/engineering_processor" | "minecraft:gold_ingot_from_smelting_deepslate_gold_ore" | "ad_astra:netherite_space_suit" | "iceandfire:dragonsteel_lightning_sword" | "create:milling/cobblestone" | "tconstruct:smeltery/scorched/scorched_ladder" | "classicpipes:jungle_pipe" | "ad_astra:small_black_industrial_lamp" | "create:layered_andesite_from_stone_types_andesite_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_sign" | "tconstruct:tools/materials/casting/queens_slime" | "create:cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "create:polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "minecraft:deepslate_tile_slab" | "tconstruct:tools/modifiers/ability/tool_belt_2" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_fir_wood_to_fir_planks" | "tconstruct:tools/modifiers/ability/tool_belt_3" | "tconstruct:tools/materials/glass_pane" | "tconstruct:tools/modifiers/ability/tool_belt_1" | "create:polished_cut_calcite_from_stone_types_calcite_stonecutting" | "railways:stonecutting/palettes/cycling/red_slashed_locometal" | "tconstruct:tools/modifiers/ability/tool_belt_6" | "tconstruct:smeltery/casting/metal/brass/nugget_gold_cast" | "tconstruct:tools/modifiers/ability/tool_belt_4" | "tconstruct:tools/modifiers/ability/tool_belt_5" | "tconstruct:tools/materials/bloodbone" | "railways:crafting/palettes/dyeing_1x/gray_plated_locometal" | "railways:crafting/palettes/dyeing_8x/pink_plated_locometal" | "create:cutting/runtime_generated/compat/biomesoplenty/umbran_planks_to_umbran_stairs" | "create:cutting/runtime_generated/compat/minecraft/spruce_wood_to_stripped_spruce_wood" | "simplylight:illuminant_pink_block_toggle" | "railways:crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal" | "railways:crafting/palettes/dyeing_1x/pink_flat_slashed_locometal" | "create:cutting/runtime_generated/compat/minecraft/mangrove_planks_to_mangrove_stairs" | "create:crafting/logistics/yellow_table_cloth_clear" | "molten_metals:filling/zinc_filled_metal_mold" | "create:dark_oak_window" | "ad_astra:chiseled_mercury_stone_bricks" | "ad_astra:mars_stone_brick_slab" | "create:small_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "powah:energizing/spirited_crystal" | "minecraft:warped_button" | "computercraft:pocket_computer_advanced" | "comforts:sleeping_bag_to_magenta" | "ae2:tools/paintballs_blue" | "tconstruct:tools/building/broad_axe" | "create:cut_crimsite_stairs" | "railways:sequenced_assembly/green_conductor_cap" | "ae2:tools/paintballs_lime" | "create:small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "tconstruct:common/glass/orange_clear_stained_glass" | "tconstruct:tools/modifiers/tasty" | "create:crafting/kinetics/sequenced_gearshift" | "farmersdelight:cutting/dark_oak_door" | "tconstruct:smeltery/melting/obsidian/foundry_controller" | "create:cutting/runtime_generated/compat/biomesoplenty/umbran_log_to_stripped_umbran_log" | "create:cutting/runtime_generated/compat/minecraft/stripped_birch_log_to_birch_planks" | "tconstruct:tables/tinker_station_damaging/splash_one" | "minecraft:armor_dye" | "hexcasting:edified_pressure_plate" | "ad_astra:stonecutting/chiseled_permafrost_bricks_from_permafrost_bricks_stonecutting" | "tconstruct:tools/modifiers/salvage/upgrade/ricochet" | "ad_astra:chiseled_moon_stone_bricks" | "ad_astra:encased_ostrum_block" | "create:polished_cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "tconstruct:smeltery/melting/slime/sky/sling" | "tconstruct:tools/modifiers/cobalt_reinforcement" | "railways:sequenced_assembly/track_jungle_narrow" | "farmersdelight:cutting/mangrove_hanging_sign" | "ad_astra:mars_cobblestone_stairs" | "tconstruct:tools/modifiers/salvage/upgrade/power" | "minecraft:map" | "biomesoplenty:orange_maple_leaf_pile" | "biomesoplenty:unmapped_end_stone" | "create:cut_scorchia_stairs" | "minecraft:detector_rail" | "ae2:transform/flawed_budding_quartz" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_button" | "create:crafting/materials/small_rose_quartz_tiles_from_conversion" | "agricraft:emerald" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_planks_to_dark_oak_button" | "biomesoplenty:jacaranda_hanging_sign" | "create:blasting/silver_ingot_compat_iceandfire" | "ae2:block_cutter/slabs/cut_quartz_slab" | "railways:stonecutting/palettes/cycling/purple_locometal_pillar" | "tconstruct:smeltery/casting/filling/tipped_arrow" | "tconstruct:smeltery/casting/metal/steel/ingot_sand_cast" | "create:cutting/runtime_generated/compat/minecraft/bamboo_planks_to_bamboo_fence" | "minecraft:crafting_table" | "biomesoplenty:tnt_from_bop_sand" | "powah:crafting/battery_basic" | "minecraft:green_stained_glass_pane_from_glass_pane" | "tconstruct:common/tinkers_gadgetry" | "create:crafting/logistics/stockpile_switch" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_planks_to_hellbark_stairs" | "create:splashing/industrial_iron_window" | "biomesoplenty:umbran_sign" | "create:crafting/logistics/stock_link" | "tconstruct:tools/modifiers/upgrade/impaling" | "create:cutting/runtime_generated/compat/biomesoplenty/umbran_planks_to_umbran_fence" | "powah:crafting/player_tranmitter_basic" | "tconstruct:smeltery/casting/seared/bricks/block" | "tconstruct:common/slime/ender/slimeball_from_congealed" | "ad_astra:strophar_fence" | "tconstruct:smeltery/casting/metal/electrum/nugget_gold_cast" | "minecraft:anvil" | "iceandfire:armor_gray_leggings" | "ae2:network/cables/smart_gray" | "create:cut_scorchia_brick_stairs" | "ae2:network/cables/dense_covered_white" | "create:polished_cut_andesite_stairs" | "tconstruct:smeltery/seared/seared_bricks_slab" | "tconstruct:tools/modifiers/salvage/upgrade/item_frame" | "railways:stonecutting/palettes/cycling/lime_riveted_locometal" | "railways:crafting/palettes/dyeing_8x/orange_locometal_boiler" | "create:crafting/logistics/pulse_extender" | "tconstruct:tools/modifiers/ability/melting" | "tconstruct:smeltery/casting/slime/sky/block" | "create:cutting/runtime_generated/compat/biomesoplenty/dead_planks_to_dead_slab" | "iceandfire:dragonscale_red_to_dragonscales_red" | "tconstruct:tools/modifiers/ability/exchanging" | "create:cutting/runtime_generated/compat/minecraft/bamboo_planks_to_bamboo_sign" | "agricraft:iron_crop_sticks" | "ae2:shaped/slabs/quartz_pillar" | "railways:stonecutting/palettes/cycling/orange_slashed_locometal" | "railways:crafting/palettes/dyeing_8x/black_flat_riveted_locometal" | "farmersdelight:magenta_hanging_canvas_sign" | "tconstruct:tools/materials/queens_slime/ingot" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_fence" | "tconstruct:smeltery/casting/metal/steel/ingot_gold_cast" | "railways:stonecutting/palettes/cycling/pink_riveted_locometal" | "createaddition:crafting/electrum_ingot" | "create:crafting/logistics/factory_gauge_clear" | "biomesoplenty:dead_door" | "computercraft:redstone_relay" | "ae2:decorative/quartz_fixture" | "molten_metals:filling/zinc_filled_ceramic_mold" | "create:small_ochrum_brick_slab" | "create:copper_shingles_from_copper_ingots_stonecutting" | "create:crushing/moon_iron_ore" | "create:polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "minecraft:black_glazed_terracotta" | "tconstruct:world/wood/greenheart/stairs" | "minecraft:carrot_on_a_stick" | "tconstruct:tools/modifiers/salvage/upgrade/netherite" | "create:crafting/copper/waxed_copper_tile_stairs_from_honeycomb" | "iceandfire:dragonarmor_dragon_steel_fire_head" | "ae2:network/blocks/quantum_ring" | "create:exposed_copper_shingle_slab" | "railways:crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal_boiler" | "create:cutting/runtime_generated/compat/minecraft/jungle_wood_to_stripped_jungle_wood" | "minecraft:waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "create:cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "ae2:misc/deconstruction_cut_certus_quartz_block" | "create:haunting/soul_lantern" | "ad_astra:pink_flag" | "tconstruct:tools/modifiers/upgrade/antiaquatic" | "tconstruct:tools/modifiers/worktable/enchantment_converting/ability_tool" | "tconstruct:tools/materials/melting/amethyst_bronze" | "minecraft:raw_iron_block" | "tconstruct:tools/modifiers/salvage/ability/tool_belt" | "ae2:block_cutter/walls/chiseled_quartz_wall" | "minecraft:oak_button" | "powah:crafting/cable_niotic" | "railways:crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal_boiler" | "minecraft:dark_oak_hanging_sign" | "powah:crafting/dielectric_casing" | "tconstruct:smeltery/melting/clay/terracotta" | "tconstruct:tools/modifiers/ability/silky" | "minecraft:polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "railways:crafting/buffer" | "hexcasting:dye_colorizer_brown" | "biomesoplenty:smooth_black_sandstone_stairs_from_smooth_black_sandstone_stonecutting" | "simplylight:illuminant_yellow_block_on_toggle" | "agricraft:amethyst_shard" | "farmersdelight:milk_bucket_from_bottles" | "ad_astra:aeronos_slab" | "tconstruct:tools/materials/wood/logs/dark_oak" | "ae2:transform/certus_quartz_crystals" | "iceandfire:dragonscales_amythest_to_dragonscale_amythest" | "comforts:hammock_brown" | "tconstruct:tools/modifiers/defense/melee_protection" | "create:cutting/runtime_generated/compat/tconstruct/skyroot_planks_to_skyroot_trapdoor" | "railways:crafting/palettes/dyeing_8x/light_gray_locometal_smokebox" | "farmersdelight:cutting/jungle_wood" | "minecraft:waxed_exposed_cut_copper" | "tconstruct:smeltery/scorched/scorched_bricks_slab" | "create:crafting/copper/waxed_oxidized_copper_shingle_slab_from_honeycomb" | "farmersdelight:cutting/cooked_chicken" | "simplylight:illuminant_brown_block_dyed" | "create:crafting/logistics/cyan_postbox" | "tconstruct:tools/materials/slimewood/bloodshroom_planks" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_log_to_stripped_redwood_log" | "powah:crafting/player_tranmitter_nitro" | "hexcasting:decompose_quenched_shard/dust" | "railways:stonecutting/palettes/cycling/riveted_locometal" | "tconstruct:tools/modifiers/upgrade/depth_strider" | "tconstruct:smeltery/melting/scorched/ingot_tank" | "tconstruct:smeltery/melting/fuel/lava" | "minecraft:item_frame" | "minecraft:iron_ingot_from_smelting_iron_ore" | "tconstruct:smeltery/melting/quartz/block" | "tconstruct:world/wood/skyroot/fence" | "minecraft:polished_granite_stairs_from_polished_granite_stonecutting" | "railways:sequenced_assembly/track_warped_narrow" | "tconstruct:tools/materials/slimewood/bloodshroom_logs" | "farmersdelight:egg_sandwich" | "tconstruct:smeltery/melting/slime/ichor/block" | "tconstruct:smeltery/seared/table" | "create:small_diorite_brick_slab_recycling" | "minecraft:pink_dye_from_pink_tulip" | "tconstruct:tools/modifiers/salvage/ability/path_maker" | "minecraft:arrow" | "ae2:transform/fluix_crystals" | "hexcasting:dye_colorizer_light_blue" | "powah:crafting/player_tranmitter_niotic" | "tconstruct:common/glass/green_clear_stained_glass" | "create:crafting/logistics/light_gray_table_cloth_clear" | "ad_astra:iron_plating_button" | "ae2:shaped/stairs/quartz_pillar" | "tconstruct:tools/materials/rock/blackstone" | "farmersdelight:purple_canvas_sign" | "ad_astra:stonecutting/moon_cobblestone_slab_from_moon_cobblestone_stonecutting" | "railways:crafting/palettes/dyeing_8x/magenta_slashed_locometal" | "minecraft:red_sandstone_stairs" | "powah:crafting/capacitor_blazing" | "create:cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "biomesoplenty:magic_trapdoor" | "computercraft:turtle_normal/minecraft/crafting_table" | "tconstruct:tools/modifiers/ability/crystalshot_earthslime" | "farmersdelight:brown_hanging_canvas_sign" | "tconstruct:smeltery/melting/metal/hepatizon/ingot" | "tconstruct:tools/modifiers/ability/pockets" | "tconstruct:common/materials/rose_gold_ingot_from_nuggets" | "create:cut_tuff_slab" | "tconstruct:smeltery/melting/metal/brass/plates" | "tconstruct:tools/materials/composite/iron_oxidized" | "ad_astra:water_pump" | "tconstruct:smeltery/casting/seared/brick_sand_cast" | "create:crafting/logistics/black_table_cloth_clear" | "computercraft:computer_advanced" | "hexcasting:slate_pillar" | "create:crafting/kinetics/sail_frame_from_conversion" | "create:cut_tuff_brick_slab" | "create:crafting/copper/waxed_weathered_copper_tile_slab_from_honeycomb" | "create:crushing/coal_ore" | "biomesoplenty:red_dye_from_waterlily" | "tconstruct:tools/severing/enderman_head" | "create:cutting/runtime_generated/compat/biomesoplenty/maple_planks_to_maple_sign" | "railways:crafting/palettes/dyeing_1x/white_flat_riveted_locometal" | "ad_astra:polished_mars_stone_stairs" | "create:layered_veridium_from_stone_types_veridium_stonecutting" | "railways:crafting/smokestack_woodburner" | "minecraft:jungle_button" | "createoreexcavation:ore_vein_type/water" | "powah:crafting/energy_hopper_hardened" | "tconstruct:tools/modifiers/ability/strength" | "tconstruct:smeltery/melting/metal/gold/plates" | "create:cutting/runtime_generated/compat/minecraft/crimson_planks_to_crimson_pressure_plate" | "tconstruct:tools/modifiers/worktable/invisible_ink_adding" | "tconstruct:tools/modifiers/ability/tool_belt_crystal" | "railways:crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal" | "iceandfire:dragonforge_fire_input" | "ratatouille:folly_plush" | "iceandfire:deathworm_red_chestplate" | "create:polished_cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "minecraft:waxed_oxidized_copper_from_honeycomb" | "tconstruct:smeltery/melting/metal/iron/reinforcement" | "minecraft:spruce_trapdoor" | "iceandfire:dragonseeker" | "tconstruct:smeltery/casting/water/magenta_concrete" | "tconstruct:smeltery/casting/metal/netherite/scrap_sand_cast" | "create:cut_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "minecraft:respawn_anchor" | "computercraft:disk_drive" | "tconstruct:tools/modifiers/salvage/defense/blast_protection" | "tconstruct:tools/severing/enderslime_ball" | "tconstruct:smeltery/melting/seared/fuel_tank" | "tconstruct:tools/modifiers/salvage/upgrade/antiaquatic" | "createaddition:charging/cut_copper_slab" | "createaddition:crafting/electrum_amulet" | "minecraft:dark_prismarine_stairs" | "create:polished_cut_asurine_from_stone_types_asurine_stonecutting" | "create:copper_scaffolding_from_copper_ingots_stonecutting" | "tconstruct:common/glass/light_gray_clear_stained_glass" | "comforts:hammock_to_blue" | "create:deploying/copper_tiles_from_deoxidising" | "tconstruct:smeltery/casting/metal/amethyst_bronze/nugget_sand_cast" | "tconstruct:smeltery/casting/metal/electrum/plate_sand_cast" | "minecraft:polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:snow_block" | "tconstruct:smeltery/casting/metal/electrum/rod_sand_cast" | "ae2:network/cells/item_storage_cell_64k_storage" | "create:blasting/zinc_ingot_from_crushed" | "ae2:network/cables/covered_light_blue" | "tconstruct:tools/modifiers/slotless/travelers_dyeing" | "hexcasting:edified_door" | "create:crafting/kinetics/fluid_valve" | "create:polished_cut_veridium_wall" | "minecraft:composter" | "minecraft:sandstone_stairs" | "hexcasting:amethyst_bricks_small_from_amethyst_bricks" | "iceandfire:tide_purple_chestplate" | "railways:crafting/palettes/dyeing_1x/magenta_plated_locometal" | "railways:crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal_boiler" | "ae2:tools/paintballs_lumen_orange" | "agricraft:journal" | "create:haunting/infested_cracked_stone_bricks" | "create:copper_tile_stairs" | "tconstruct:tools/materials/wood/logs/crimson" | "molten_metals:mixing/molten_iron_from_nugget" | "tconstruct:tools/modifiers/worktable/attack_modifier_clearing" | "railways:crafting/palettes/dyeing_8x/magenta_flat_slashed_locometal" | "minecraft:coarse_dirt" | "create:crafting/kinetics/white_seat" | "biomesoplenty:hellbark_pressure_plate" | "railways:crafting/palettes/dyeing_8x/light_blue_slashed_locometal" | "create:crushing/deepslate_coal_ore" | "farmersdelight:cutting/dark_oak_trapdoor" | "molten_metals:mixing/molten_brass_from_nugget" | "tconstruct:tools/materials/melting/pig_iron" | "minecraft:prismarine_slab" | "tconstruct:common/glass/magenta_clear_stained_glass" | "minecraft:fermented_spider_eye" | "ae2:network/parts/panels_dark_monitor" | "railways:crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal" | "minecraft:light_gray_glazed_terracotta" | "tconstruct:tools/modifiers/salvage/upgrade/diamond" | "railways:crafting/palettes/dyeing_1x/blue_flat_riveted_locometal" | "tconstruct:tools/materials/composite/bloodbone" | "minecraft:gold_ingot_from_gold_block" | "biomesoplenty:stripped_mahogany_wood" | "tconstruct:smeltery/casting/metal/copper/ingot_sand_cast" | "minecraft:cobbled_deepslate_slab" | "create:crafting/appliances/dough" | "minecraft:iron_door" | "minecraft:purple_stained_glass_pane" | "molten_metals:splashing/bismuth_ingot_from_metal_mold" | "tconstruct:smeltery/melting/metal/iron/anvil" | "powah:crafting/dielectric_rod_h_2" | "railways:crafting/smokestack_diesel" | "tconstruct:smeltery/melting/glass/block" | "ae2:tools/paintballs_lumen_gray" | "railways:stonecutting/palettes/cycling/magenta_plated_locometal" | "farmersdelight:cooking/pasta_with_mutton_chop" | "tconstruct:smeltery/casts/red_sand_casts/hammer_head" | "minecraft:chiseled_quartz_block" | "tconstruct:smeltery/entity_melting/silverfish" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_planks_to_mahogany_sign" | "powah:crafting/ender_cell_starter" | "ad_astra:light_gray_industrial_lamp" | "hexpigmentplus:magician_hat_magic" | "railways:stonecutting/palettes/cycling/yellow_slashed_locometal" | "tconstruct:tools/severing/zombified_piglin_head" | "create:cut_scorchia_brick_slab" | "create:cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "ad_astra:airlock" | "ae2:network/cables/glass_white" | "railways:stonecutting/palettes/cycling/brown_locometal_smokebox" | "comforts:hammock_to_lime" | "railways:crafting/palettes/dyeing_8x/white_plated_locometal" | "tconstruct:smeltery/casts/sand_casts/rods" | "powah:crafting/binding_card" | "create:small_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "minecraft:smooth_quartz_stairs" | "tconstruct:tools/materials/casting/rose_gold" | "tconstruct:tools/modifiers/ability/expanded" | "railways:stonecutting/palettes/cycling/pink_plated_locometal" | "createaddition:mixing/biomass_from_honeycomb" | "simplylight:illuminant_gray_block_toggle" | "create:crafting/kinetics/mechanical_mixer" | "tconstruct:common/encyclopedia" | "iceandfire:armor_gray_boots" | "tconstruct:tools/materials/melting/nahuatl" | "minecraft:lime_dye" | "comforts:sleeping_bag_to_light_gray" | "farmersdelight:cabbage_from_leaves" | "railways:crafting/palettes/dyeing_1x/brown_locometal_smokebox" | "tconstruct:tools/modifiers/upgrade/leaping" | "minecraft:oak_planks" | "simplylight:illuminant_slab_from_panel" | "molten_metals:filling/iron_filled_ceramic_mold" | "minecraft:orange_candle" | "biomesoplenty:palm_door" | "tconstruct:tools/severing/skyslime_ball" | "biomesoplenty:brimstone_fumarole" | "iceandfire:skull_to_bone_meal" | "railways:stonecutting/palettes/cycling/light_gray_locometal_smokebox" | "tconstruct:tools/modifiers/defense/shulking" | "create:framed_glass_from_colorless_glass_stonecutting" | "minecraft:mangrove_door" | "tconstruct:smeltery/casting/metal/electrum/wire_gold_cast" | "create:polished_cut_diorite_wall" | "railways:crafting/palettes/dyeing_8x/red_riveted_locometal" | "railways:sequenced_assembly/track_ender_wide" | "hexcasting:brainsweep/directrix_boolean" | "minecraft:stone_brick_wall" | "ae2:decorative/smooth_quartz_block" | "create:milling/compat/biomesoplenty/blue_hydrangea" | "minecraft:repair_item" | "hexcasting:dye_colorizer_pink" | "biomesoplenty:pine_pressure_plate" | "minecraft:light_blue_dye_from_blue_white_dye" | "computercraft:pocket_normal/computercraft/wireless_modem_advanced" | "tconstruct:tools/modifiers/salvage/upgrade/lightspeed_armor" | "create:crafting/materials/cardboard_from_bound_block" | "tconstruct:tools/modifiers/slotless/embellishment_silver" | "minecraft:cyan_dye" | "create:oxidized_copper_shingle_slab_from_oxidized_copper_shingles_stonecutting" | "tconstruct:world/wood/greenheart/pressure_plate" | "farmersdelight:bamboo_cabinet" | "railways:crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal_boiler" | "ad_astra:calorite_plating" | "create:crafting/logistics/cyan_table_cloth" | "createaddition:charging/weathered_cut_copper_stairs" | "tconstruct:common/mud_bricks_stairs" | "create:crafting/kinetics/gray_seat_from_other_seat" | "minecraft:gold_block" | "tconstruct:smeltery/casting/metal/hepatizon/ingot_sand_cast" | "minecraft:spruce_boat" | "railways:stonecutting/palettes/cycling/plated_locometal" | "tconstruct:smeltery/melting/metal/gold/block" | "minecraft:cherry_wood" | "ad_astra:smelting/desh_ingot_from_smelting_moon_desh_ore" | "molten_metals:mixing/molten_zinc_from_nugget" | "createoreexcavation:ore_vein_type/iron" | "railways:crafting/palettes/dyeing_1x/black_riveted_locometal" | "tconstruct:smeltery/casting/metal/gold/nugget_gold_cast" | "powah:smelting/uraninite_from_raw_blasting" | "biomesoplenty:smooth_orange_sandstone_slab" | "iceandfire:tide_purple_boots" | "tconstruct:tools/modifiers/worktable/enchantment_converting/upgrade_tool" | "railways:crafting/palettes/dyeing_8x/light_gray_locometal_pillar" | "minecraft:copper_ingot_from_blasting_raw_copper" | "minecraft:cut_red_sandstone_slab" | "extendedae:threshold_level_emitter" | "tconstruct:smeltery/casting/metal/brass/plate_sand_cast" | "powah:crafting/battery_nitro" | "farmersdelight:salmon_roll" | "ad_astra:polished_venus_stone_slab" | "create:cutting/runtime_generated/compat/minecraft/crimson_stem_to_stripped_crimson_stem" | "minecraft:emerald_from_smelting_deepslate_emerald_ore" | "hexcasting:quenched_allay_bricks_from_quenched_allay_bricks_small" | "create:cut_tuff_brick_slab_recycling" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_trapdoor" | "tconstruct:world/wood/bloodshroom/stripped_log_to_wood" | "railways:crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal_boiler" | "powah:crafting/energy_discharger_spirited" | "ad_astra:stonecutting/mercury_stone_bricks_from_mercury_stone_stonecutting" | "tconstruct:common/slime/sky/slimeball_from_congealed" | "railways:crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal_boiler" | "create:ornate_iron_window_pane" | "tconstruct:tools/modifiers/iron_reinforcement" | "biomesoplenty:dead_slab" | "ad_astra:moon_pillar" | "tconstruct:tools/repair/flint_and_brick_seared_repair_kit" | "minecraft:raw_iron" | "minecraft:iron_nugget" | "create:deploying/cut_copper_from_deoxidising" | "tconstruct:common/slime/blood/slimeball_from_block" | "create:crafting/logistics/brown_table_cloth_from_other_table_cloth" | "farmersdelight:cutting/gravel" | "create:crushing/raw_copper_block" | "minecraft:waxed_oxidized_cut_copper_from_honeycomb" | "tconstruct:common/materials/amethyst_bronze_ingot_from_nuggets" | "railways:crafting/palettes/dyeing_1x/black_brass_wrapped_locometal" | "iceandfire:delight/cooked_rice_with_ice_dragon_meat" | "tconstruct:smeltery/casting/metal/electrum/wire_sand_cast" | "minecraft:nether_wart_block" | "minecraft:bamboo_fence_gate" | "farmersdelight:cooking/baked_cod_stew" | "tconstruct:smeltery/casting/blaze/cream" | "ae2:entropy/cool/stone_bricks_cracked_stone_bricks" | "railways:stonecutting/palettes/cycling/green_flat_riveted_locometal" | "iceandfire:dragonarmor_iron_head" | "hextended:long/extended_moss_staff" | "tconstruct:common/materials/copper_ingot_from_nuggets" | "sophisticatedbackpacks:advanced_magnet_upgrade_from_basic" | "farmersdelight:cherry_cabinet" | "tconstruct:smeltery/melting/metal/queens_slime/block" | "comforts:hammock_purple" | "create:crushing/diorite" | "create:cut_veridium_wall" | "create:crafting/kinetics/magenta_seat_from_other_seat" | "ad_astra:radio" | "powah:crafting/battery_blazing" | "powah:crafting/reactor_basic" | "tconstruct:smeltery/melting/metal/gold/raw" | "simplylight:illuminant_lime_block_toggle" | "farmersdelight:melon_popsicle" | "farmersdelight:spruce_cabinet" | "tconstruct:tools/modifiers/salvage/upgrade/zoom" | "ae2:network/cells/item_storage_components_cell_64k_part" | "create:cutting/runtime_generated/compat/tconstruct/skyroot_log_to_stripped_skyroot_log" | "minecraft:dye_light_gray_wool" | "minecraft:writable_book" | "create:cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "railways:stonecutting/palettes/cycling/flat_slashed_locometal" | "ad_astra:stonecutting/polished_conglomerate_from_conglomerate_stonecutting" | "tconstruct:smeltery/casting/metal/iron/plate_gold_cast" | "tconstruct:common/materials/queens_slime_block_from_ingots" | "minecraft:golden_apple" | "ad_astra:blasting/ostrum_ingot_from_blasting_deepslate_ostrum_ore" | "minecraft:diamond_pickaxe" | "minecraft:light_gray_dye_from_oxeye_daisy" | "railways:sequenced_assembly/track_create_andesite_wide" | "tconstruct:tools/modifiers/ability/snowdrift" | "tconstruct:tools/parts/casting/hammer_head_gold_cast" | "createaddition:compat/tconstruct/amethyst_bronze" | "create:crushing/deepslate_redstone_ore" | "ad_astra:encased_steel_block" | "ad_astra:compressing/iron_plate_from_compressing_iron_ingot" | "ad_astra:oxygen_sensor" | "create:small_deepslate_brick_slab_recycling" | "farmersdelight:steak_and_potatoes" | "tconstruct:smeltery/melting/quartz/ore_singular" | "create:crafting/logistics/lime_table_cloth_from_other_table_cloth" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_planks_to_mahogany_trapdoor" | "railways:crafting/palettes/dyeing_1x/pink_plated_locometal" | "ad_astra:stonecutting/mars_stone_stairs_from_mars_stone_stonecutting" | "create:tuff_from_stone_types_tuff_stonecutting" | "tconstruct:smeltery/casting/slime/earth/block" | "extendedae:pre_bus" | "tconstruct:tools/modifiers/salvage/ability/trick_quiver" | "iceandfire:dread_stone_face" | "create:crafting/logistics/blue_postbox_from_other_postbox" | "minecraft:polished_blackstone_wall" | "farmersdelight:cooking/squid_ink_pasta" | "molten_metals:mixing/molten_copper_from_ingot_raw" | "minecraft:redstone_from_smelting_redstone_ore" | "tconstruct:tools/modifiers/salvage/upgrade/experienced" | "iceandfire:deathworm_white_helmet" | "farmersdelight:cutting/warped_trapdoor" | "minecraft:suspicious_stew" | "railways:crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal_boiler" | "railways:crafting/palettes/wrapping/light_blue_iron_wrapped_locometal" | "farmersdelight:cutting/oak_wood" | "molten_metals:filling/netherite_filled_ceramic_mold" | "ae2:network/blocks/interfaces_interface" | "ae2:network/cables/smart_magenta" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_empyreal_log_to_empyreal_planks" | "railways:crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal_boiler" | "tconstruct:smeltery/casting/metal/hepatizon/ingot_gold_cast" | "tconstruct:smeltery/casting/soup/rabbit" | "iceandfire:dragonbone_sword_ice" | "create:crafting/kinetics/item_vault" | "create:crafting/logistics/white_table_cloth" | "create:warped_window_pane" | "create:crafting/schematics/schematic_table" | "create:crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "minecraft:dye_green_carpet" | "ad_astra:jet_suit_boots" | "tconstruct:smeltery/entity_melting/zombie" | "powah:crafting/energizing_rod_blazing" | "farmersdelight:cutting/spruce_log" | "ad_astra:raw_desh_block" | "iceandfire:dragonforge_ice_core_disabled" | "sophisticatedbackpacks:advanced_jukebox_upgrade" | "railways:stonecutting/palettes/cycling/yellow_plated_locometal" | "hexpigmentplus:magician_hat_lutin" | "ad_astra:ostrum_plating_stairs" | "tconstruct:smeltery/casts/sand_casts/tool_binding" | "create:cut_limestone_bricks_from_stone_types_limestone_stonecutting" | "tconstruct:tools/modifiers/upgrade/fireprimer" | "tconstruct:tools/modifiers/upgrade/hydraulic_from_bricks" | "tconstruct:tools/building/flint_and_brick" | "minecraft:wooden_pickaxe" | "create:deploying/exposed_copper_from_removing_wax" | "railways:mechanical_crafting/cyan_locometal_boiler" | "create:small_asurine_brick_slab" | "powah:crafting/spirited_crystal_block" | "tconstruct:smeltery/casting/metal/electrum/plate_gold_cast" | "tconstruct:common/slime/sky/congealed" | "ae2:network/blocks/pattern_providers_interface" | "tconstruct:smeltery/melting/metal/gold/apple" | "create:cut_granite_brick_stairs" | "create:crafting/logistics/green_table_cloth_clear" | "railways:mechanical_crafting/black_iron_wrapped_locometal_boiler" | "minecraft:stick_from_bamboo_item" | "tconstruct:tools/severing/ender_dragon_head" | "create:crafting/kinetics/depot" | "tconstruct:tools/modifiers/slotless/draconic_from_head" | "iceandfire:dragonforge_ice_input" | "minecraft:diamond_from_blasting_diamond_ore" | "tconstruct:tables/tinker_station_repair" | "tconstruct:common/slime/sky/crystal_block" | "ad_astra:mercury_stone_slab" | "tconstruct:tools/modifiers/ability/bucketing" | "create:andesite_table_cloth_from_andesite_alloy_stonecutting" | "railways:stonecutting/palettes/cycling/magenta_slashed_locometal" | "tconstruct:tools/modifiers/upgrade/fiery" | "tconstruct:tools/modifiers/worktable/attack_modifier_setting" | "tconstruct:armor/building/slime_skull/rotten_flesh" | "create:cutting/runtime_generated/compat/minecraft/stripped_spruce_wood_to_spruce_planks" | "tconstruct:tools/modifiers/ability/pathing" | "tconstruct:smeltery/melting/glass/pane" | "minecraft:end_stone_brick_stairs" | "tconstruct:smeltery/seared/fuel_gauge" | "create:small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "create:cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "minecraft:stripped_crimson_hyphae" | "hexcasting:scroll_paper_lantern" | "minecraft:cyan_carpet" | "extendedae:ex_charger" | "iceandfire:armor_copper_metal_boots" | "minecraft:polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "tconstruct:tools/building/scythe" | "ducky-periphs:keyboard_block" | "railways:crafting/palettes/dyeing_1x/orange_slashed_locometal" | "tconstruct:smeltery/casts/sand_casts/round_plate" | "create:weathered_iron_block_from_iron_ingots_stonecutting" | "create:polished_cut_crimsite_from_stone_types_crimsite_stonecutting" | "extendedae:ex_drive_upgrade" | "minecraft:smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "createoreexcavation:drill" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_maple_wood_to_maple_planks" | "iceandfire:dragonarmor_netherite_tail" | "ae2:network/cables/dense_covered_brown" | "biomesoplenty:brimstone_brick_slab" | "minecraft:cyan_terracotta" | "tconstruct:smeltery/casting/metal/slimesteel/ingot_sand_cast" | "railways:crafting/palettes/wrapping/light_blue_brass_wrapped_locometal" | "ad_astra:green_industrial_lamp" | "tconstruct:tools/modifiers/upgrade/piercing" | "minecraft:mangrove_fence" | "tconstruct:smeltery/melting/metal/rose_gold/nugget" | "minecraft:polished_deepslate_from_cobbled_deepslate_stonecutting" | "tconstruct:smeltery/melting/clay/brick" | "tconstruct:tools/severing/shulker_shell" | "powah:energizing/uraninite_from_ore_poor" | "tconstruct:smeltery/casting/scorched/glass" | "minecraft:light_gray_bed" | "hexcasting:dye_colorizer_white" | "tconstruct:smeltery/casting/metal/queens_slime/ingot_sand_cast" | "ad_astra:glacio_cobblestone_slab" | "tconstruct:tables/scorched_forge" | "create:small_veridium_brick_slab" | "tconstruct:smeltery/casts/sand_casts/broad_blade" | "tconstruct:smeltery/casting/slime/sky/dirt" | "minecraft:black_stained_glass_pane" | "railways:stonecutting/palettes/cycling/lime_slashed_locometal" | "iceandfire:dragon_horn" | "railways:crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal" | "ad_astra:blasting/iron_ingot_from_blasting_mars_iron_ore" | "tconstruct:smeltery/casting/slime/blood/block" | "hexpigmentplus:magician_hat_wide" | "iceandfire:banners/banner_pattern_fire_head" | "create:deploying/copper_shingle_stairs_from_removing_wax" | "create:deploying/exposed_copper_shingles_from_deoxidising" | "minecraft:spruce_chest_boat" | "iceandfire:armor_white_leggings" | "create:deploying/waxed_oxidized_cut_copper_slab_from_adding_wax" | "createoreexcavation:drilling/gold" | "biomesoplenty:orange_dye_from_orange_cosmos" | "powah:energizing/energized_steel" | "minecraft:golden_axe" | "ad_astra:stonecutting/moon_stone_stairs_from_moon_stone_stonecutting" | "tconstruct:smeltery/melting/metal/zinc/raw" | "farmersdelight:sweet_berry_cheesecake_from_slices" | "iceandfire:ash_to_charcoal" | "tconstruct:world/wood/bloodshroom/stairs" | "railways:crafting/palettes/wrapping/white_copper_wrapped_locometal" | "railways:crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal_boiler" | "create:small_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "ae2:shaped/slabs/quartz_block" | "classicpipes:oak_pipe" | "powah:crafting/reactor_hardened" | "create:small_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "tconstruct:tools/modifiers/slotless/embellishment_iron" | "create:vertical_framed_glass_from_colorless_glass_stonecutting" | "create:crafting/kinetics/magenta_seat" | "tconstruct:smeltery/casting/obsidian/block" | "minecraft:snow" | "create:crafting/kinetics/brown_seat" | "create:cut_crimsite_brick_slab_recycling" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_wood_to_stripped_willow_wood" | "railways:crafting/palettes/dyeing_8x/black_iron_wrapped_locometal" | "tconstruct:tools/modifiers/ability/long_fall" | "tconstruct:world/wood/greenheart/fence_gate" | "tconstruct:tools/materials/iron/nugget" | "create:small_asurine_brick_slab_recycling" | "minecraft:blackstone_wall_from_blackstone_stonecutting" | "railways:crafting/palettes/dyeing_8x/green_brass_wrapped_locometal_boiler" | "simplylight:illuminant_red_block_on_dyed" | "farmersdelight:cutting/azure_bluet" | "ad_astra:stonecutting/venus_stone_bricks_from_venus_stone_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_planks_to_redwood_pressure_plate" | "railways:stonecutting/palettes/cycling/gray_slashed_locometal" | "ae2:network/cables/glass_cyan" | "farmersdelight:integration/create/milling/wild_carrots" | "sophisticatedcore:upgrade_clear" | "create:splashing/crushed_raw_copper" | "minecraft:emerald_from_smelting_emerald_ore" | "create:cutting/runtime_generated/compat/minecraft/spruce_planks_to_spruce_fence" | "biomesoplenty:magic_sign" | "biomesoplenty:chiseled_orange_sandstone" | "create:crafting/appliances/copper_diving_boots" | "tconstruct:smeltery/casting/metal/netherite/scrap_gold_cast" | "ae2:network/cables/smart_yellow" | "tconstruct:tools/modifiers/ability/crystalshot_ichor" | "railways:crafting/palettes/dyeing_8x/green_flat_slashed_locometal" | "tconstruct:tools/modifiers/upgrade/sharpness_from_block" | "farmersdelight:mixed_salad" | "tconstruct:tools/modifiers/salvage/ability/crystalshot" | "railways:crafting/palettes/wrapping/magenta_iron_wrapped_locometal" | "create:crushing/wool" | "create:deploying/exposed_copper_tile_slab_from_removing_wax" | "biomesoplenty:black_sandstone_stairs_from_black_sandstone_stonecutting" | "create:crimson_window" | "farmersdelight:cutting/chicken" | "powah:crafting/ender_cell_hardened_2" | "farmersdelight:cutting/cooked_cod" | "railways:sequenced_assembly/track_stripped_bamboo" | "biomesoplenty:dead_chest_boat" | "tconstruct:tools/materials/iron/ingot" | "minecraft:white_concrete_powder" | "railways:crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal_boiler" | "minecraft:yellow_terracotta" | "tconstruct:tools/modifiers/slotless/embellishment_debris" | "tconstruct:smeltery/melting/metal/zinc/raw_block" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_planks_to_willow_fence" | "biomesoplenty:rabbit_stew_from_toadstool" | "powah:crafting/cable_blazing_2" | "sophisticatedbackpacks:blasting_upgrade" | "minecraft:cherry_boat" | "minecraft:chiseled_nether_bricks_from_nether_bricks_stonecutting" | "ad_astra:photovoltaic_etrium_cell" | "create:small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "ad_astra:stonecutting/glacio_stone_brick_slab_from_glacio_stone_bricks_stonecutting" | "create:deploying/waxed_weathered_copper_shingles_from_adding_wax" | "iceandfire:amphithere_macuahuitl" | "tconstruct:tools/modifiers/upgrade/haste_from_block" | "create:crafting/kinetics/schedule" | "ae2:entropy/heat/water_air" | "ae2:network/cables/glass_green" | "ad_astra:stonecutting/polished_venus_stone_slab_from_polished_venus_stone_stonecutting" | "iceandfire:dragonarmor_gold_neck" | "ae2:tools/fluix_hoe" | "create:cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "railways:crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal" | "ad_astra:blasting/cheese_from_blasting_moon_cheese_ore" | "railways:crafting/palettes/dyeing_8x/magenta_locometal_pillar" | "minecraft:barrel" | "create:cut_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "create:tuff_pillar_from_stone_types_tuff_stonecutting" | "ae2:materials/basiccard" | "tconstruct:tools/parts/casting/small_blade_gold_cast" | "farmersdelight:cutting/wild_onions" | "iceandfire:dragonforge/dragonsteel_lightning_ingot" | "tconstruct:common/firewood/nahuatl_stairs" | "create:cut_asurine_wall_from_stone_types_asurine_stonecutting" | "minecraft:deepslate_brick_slab_from_polished_deepslate_stonecutting" | "iceandfire:silver_axe" | "tconstruct:smeltery/scorched/chute" | "createaddition:compacting/seed_oil" | "ad_astra:stonecutting/moon_stone_brick_wall_from_moon_stone_stonecutting" | "ae2:network/cables/glass_fluix" | "railways:crafting/palettes/dyeing_1x/orange_locometal_smokebox" | "iceandfire:dragonsteel_fire_axe" | "minecraft:smithing_table" | "minecraft:dye_gray_carpet" | "minecraft:deepslate_tile_slab_from_polished_deepslate_stonecutting" | "minecraft:shaper_armor_trim_smithing_template" | "tconstruct:smeltery/melting/metal/iron/ingot_5" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_planks_to_mahogany_slab" | "tconstruct:smeltery/melting/metal/iron/ingot_4" | "createaddition:compat/ae2/charged_certus_quartz" | "tconstruct:smeltery/melting/metal/iron/ingot_1" | "tconstruct:smeltery/melting/metal/iron/ingot_2" | "minecraft:cauldron" | "tconstruct:tools/modifiers/upgrade/punch" | "create:cutting/runtime_generated/compat/hexcasting/edified_planks_to_edified_fence" | "railways:crafting/palettes/dyeing_1x/blue_slashed_locometal" | "create:polished_cut_calcite_slab" | "minecraft:waxed_weathered_cut_copper_slab_from_honeycomb" | "ae2:block_cutter/walls/smooth_sky_stone_wall" | "ae2:network/cables/dense_covered_magenta" | "biomesoplenty:mahogany_fence_gate" | "ad_astra:stonecutting/polished_glacio_stone_from_glacio_stone_bricks_stonecutting" | "tconstruct:smeltery/casting/water/lime_concrete" | "tconstruct:tools/materials/melting/ancient_hide" | "tconstruct:smeltery/melting/metal/manyullyn/nugget" | "minecraft:cobblestone_slab" | "create:oxidized_copper_shingle_stairs_from_oxidized_copper_shingles_stonecutting" | "railways:crafting/palettes/dyeing_8x/purple_locometal_pillar" | "sophisticatedbackpacks:refill_upgrade" | "create:cutting/runtime_generated/compat/minecraft/stripped_acacia_wood_to_acacia_planks" | "minecraft:gold_ingot_from_smelting_gold_ore" | "biomesoplenty:willow_trapdoor" | "tconstruct:smeltery/entity_melting/heads/ender_dragon" | "minecraft:popped_chorus_fruit" | "tconstruct:gadgets/shuriken/quartz_shuriken" | "minecraft:shaper_armor_trim_smithing_template_smithing_trim" | "iceandfire:armor_blue_chestplate" | "hexcasting:pride_colorizer_asexual" | "railways:stonecutting/palettes/cycling/yellow_riveted_locometal" | "ae2:matter_cannon/matter_ball" | "create:deploying/waxed_oxidized_copper_shingles_from_adding_wax" | "minecraft:chest" | "railways:crafting/palettes/dyeing_8x/red_iron_wrapped_locometal" | "minecraft:gray_stained_glass" | "ad_astra:blasting/diamond_from_blasting_mars_diamond_ore" | "biomesoplenty:cut_black_sandstone_slab" | "ad_astra:polished_venus_stone" | "createaddition:charging/exposed_cut_copper_stairs" | "railways:crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal_boiler" | "iceandfire:armor_sapphire_leggings" | "ad_astra:compressor" | "comforts:hammock_to_purple" | "iceandfire:dread_stone_tile" | "minecraft:creeper_banner_pattern" | "railways:stonecutting/palettes/cycling/cyan_slashed_locometal" | "ad_astra:calorite_plating_pressure_plate" | "minecraft:red_bed" | "railways:dying_existing_cap_orange" | "railways:crafting/palettes/dyeing_8x/light_blue_flat_riveted_locometal" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_planks_to_empyreal_sign" | "iceandfire:dragonscale_black_to_dragonscales_black" | "minecraft:dye_gray_wool" | "ae2:network/cells/item_storage_cell_4k" | "tconstruct:tools/building/crossbow" | "minecraft:deepslate_bricks_from_cobbled_deepslate_stonecutting" | "hexal:freeze/packed_ice" | "railways:crafting/palettes/dyeing_8x/light_blue_locometal_smokebox" | "railways:crafting/palettes/wrapping/light_gray_brass_wrapped_locometal" | "create:compacting/granite_from_flint" | "createaddition:mixing/biomass_from_saplings" | "iceandfire:dragonsteel_lightning_pickaxe" | "tconstruct:smeltery/melting/metal/copper/lightning_rod" | "ae2:network/wireless_part" | "ad_astra:stonecutting/mercury_pillar_from_mercury_stone_bricks_stonecutting" | "farmersdelight:cooked_cod_slice_from_campfire_cooking" | "railways:crafting/palettes/dyeing_1x/purple_flat_riveted_locometal" | "iceandfire:dragonsteel_lightning_hoe" | "minecraft:end_stone_brick_slab_from_end_stone_stonecutting" | "create:crafting/logistics/magenta_table_cloth" | "ad_astra:ostrum_plating_slab" | "createoreexcavation:vein_finder" | "tconstruct:smeltery/melting/water/snow_layer" | "minecraft:iron_boots" | "tconstruct:tools/modifiers/salvage/upgrade/sweeping_edge" | "iceandfire:dragonscale_copper_to_dragonscales_copper" | "minecraft:golden_chestplate" | "tconstruct:smeltery/scorched/ingot_gauge" | "tconstruct:smeltery/scorched/scorched_bricks_fence" | "tconstruct:tools/modifiers/ability/protection" | "create:crafting/logistics/brown_postbox" | "minecraft:copper_ingot_from_smelting_raw_copper" | "ae2:network/cells/spatial_storage_cell_16_cubed_storage" | "tconstruct:tools/modifiers/upgrade/killager_from_block" | "tconstruct:smeltery/melting/slime/sky/bud_large" | "create:cutting/runtime_generated/compat/minecraft/oak_planks_to_oak_fence_gate" | "farmersdelight:integration/create/filling/chocolate_pie" | "railways:crafting/palettes/wrapping/green_copper_wrapped_locometal" | "railways:dying_existing_cap_black" | "comforts:sleeping_bag_to_green" | "minecraft:netherite_ingot" | "farmersdelight:warped_cabinet" | "classicpipes:routing_pipe" | "tconstruct:smeltery/casting/metal/copper/ingot_gold_cast" | "tconstruct:smeltery/entity_melting/iron_golem" | "classicpipes:birch_fluid_pipe_b" | "tconstruct:tools/modifiers/salvage/ability/glowing" | "ae2:tools/paintballs_light_gray" | "ae2:network/cells/item_storage_cell_1k" | "classicpipes:birch_fluid_pipe_a" | "iceandfire:banners/banner_pattern_mermaid" | "ae2:tools/nether_quartz_hoe" | "railways:mechanical_crafting/cyan_copper_wrapped_locometal_boiler" | "tconstruct:common/glass/yellow_clear_stained_glass_pane_from_panes" | "ad_astra:compressing/ostrum_plate_from_compressing_ostrum_ingots" | "biomesoplenty:cut_white_sandstone" | "railways:crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal" | "minecraft:light_blue_terracotta" | "powah:crafting/energy_hopper_basic" | "tconstruct:smeltery/red_sand_cast" | "minecraft:spruce_stairs" | "sophisticatedbackpacks:auto_blasting_upgrade_from_auto_smelting_upgrade" | "ad_astra:aeronos_trapdoor" | "minecraft:jungle_sign" | "minecraft:cyan_candle" | "ae2:tools/portable_item_cell_16k" | "create:deploying/waxed_cut_copper_from_adding_wax" | "tconstruct:smeltery/melting/clay/ball" | "tconstruct:tools/materials/necrotic_bone" | "tconstruct:tools/modifiers/slotless/embellishment_sky" | "railways:dying_existing_cap_green" | "minecraft:light_gray_dye_from_white_tulip" | "ae2:network/parts/formation_plane" | "tconstruct:smeltery/casting/metal/manyullyn/nugget_sand_cast" | "tconstruct:tools/materials/casting/steel" | "biomesoplenty:willow_button" | "tconstruct:tools/modifiers/salvage/upgrade/bane_of_sssss" | "railways:crafting/palettes/dyeing_8x/yellow_plated_locometal" | "create:crafting/kinetics/whisk" | "hexcasting:brainsweep/impetus_rightclick" | "hexcasting:edified_slab" | "create:crafting/kinetics/mechanical_drill" | "create:polished_cut_scoria_wall" | "create:cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "create:mixing/cardboard_pulp" | "railways:stonecutting/palettes/cycling/light_gray_locometal_pillar" | "ad_astra:chiseled_glacio_stone_bricks" | "create:cutting/runtime_generated/compat/biomesoplenty/maple_log_to_stripped_maple_log" | "tconstruct:tools/modifiers/salvage/ability/reach" | "sophisticatedbackpacks:deposit_upgrade" | "ad_astra:blasting/coal_from_blasting_venus_coal_ore" | "minecraft:light_gray_dye_from_black_white_dye" | "create:polished_cut_ochrum_wall" | "sophisticatedbackpacks:blasting_upgrade_from_smelting_upgrade" | "tconstruct:common/slime/ender/crystal_growing" | "biomesoplenty:brimstone_brick_wall_from_brimstone_stonecutting" | "create:copper_bars_from_copper_ingots_stonecutting" | "minecraft:slime_block" | "tconstruct:tools/modifiers/wither_bone_conversion" | "railways:crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal" | "ducky-periphs:entity_detector_block" | "tconstruct:tools/modifiers/defense/knockback_resistance" | "create:horizontal_framed_glass_pane_from_colorless_glass_panes_stonecutting" | "agricraft:netherite_scrap" | "create:cut_calcite_from_stone_types_calcite_stonecutting" | "minecraft:cooked_rabbit_from_campfire_cooking" | "tconstruct:armor/building/slime_skull/rose_gold" | "create:cutting/runtime_generated/compat/hexcasting/edified_planks_to_edified_pressure_plate" | "ae2:transform/entangled_singularity_from_pearl" | "minecraft:mud_bricks" | "tconstruct:smeltery/melting/metal/zinc/plates" | "minecraft:netherite_upgrade_smithing_template" | "tconstruct:smeltery/casting/metal/queens_slime/nugget_sand_cast" | "railways:crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal_boiler" | "biomesoplenty:chiseled_brimstone_bricks_from_brimstone_stonecutting" | "tconstruct:smeltery/melting/metal/cobalt/nugget" | "comforts:sleeping_bag_to_black" | "tconstruct:tools/modifiers/slotless/embellishment_earth" | "computercraft:disk_7" | "computercraft:disk_8" | "computercraft:disk_9" | "minecraft:mud_brick_stairs_from_mud_bricks_stonecutting" | "computercraft:disk_3" | "computercraft:disk_4" | "computercraft:disk_5" | "tconstruct:smeltery/melting/slime/earth/bud_large" | "computercraft:disk_6" | "tconstruct:armor/repair/plate_repair_kit" | "tconstruct:armor/building/travelers_goggles" | "computercraft:disk_1" | "computercraft:disk_2" | "tconstruct:tools/materials/casting/seared_stone" | "iceandfire:ash" | "create:polished_cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "iceandfire:dragonscales_electric_to_dragonscale_electric" | "iceandfire:armor_silver_leggings" | "railways:crafting/palettes/dyeing_8x/blue_slashed_locometal" | "create:small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "powah:crafting/thermo_generator_basic" | "minecraft:light_gray_carpet" | "ad_astra:calorite_ingot_from_calorite_block" | "minecraft:magenta_stained_glass_pane_from_glass_pane" | "minecraft:smooth_sandstone" | "tconstruct:common/slime/ichor/crystal_smelting" | "ad_astra:raw_calorite" | "iceandfire:dragonarmor_copper_head" | "simplylight:illuminant_slab" | "hexcasting:amethyst_bricks" | "tconstruct:tools/modifiers/salvage/defense/turtle_shell" | "create:polished_cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "minecraft:diorite_wall" | "tconstruct:smeltery/casting/water/brown_concrete" | "railways:stonecutting/palettes/cycling/white_locometal_pillar" | "minecraft:spruce_planks" | "tconstruct:common/slime/sticky_piston" | "farmersdelight:cutting/dark_oak_hanging_sign" | "powah:crafting/energy_cell_spirited" | "railways:crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal_boiler" | "tconstruct:smeltery/melting/diamond/ore_singular" | "minecraft:polished_blackstone_bricks" | "minecraft:mossy_cobblestone_from_moss_block" | "biomesoplenty:stripped_empyreal_wood" | "tconstruct:smeltery/melting/metal/iron/bucket" | "iceandfire:tide_teal_helmet" | "iceandfire:tide_teal_boots" | "tconstruct:smeltery/casting/water/bottle" | "biomesoplenty:brimstone_brick_wall_from_brimstone_bricks_stonecutting" | "simplylight:illuminant_cyan_block_on_toggle" | "create:small_granite_brick_stairs" | "ae2:network/parts/tunnels_me" | "railways:crafting/palettes/wrapping/black_copper_wrapped_locometal" | "tconstruct:smeltery/melting/metal/copper/raw" | "create:cutting/runtime_generated/compat/minecraft/bamboo_planks_to_bamboo_fence_gate" | "railways:crafting/link_and_pin" | "molten_metals:mixing/molten_brass_from_block" | "minecraft:lantern" | "minecraft:waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "create:polished_cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "agricraft:diamond" | "iceandfire:silver_block_to_silver_ingot" | "create:cutting/runtime_generated/compat/biomesoplenty/umbran_planks_to_umbran_trapdoor" | "tconstruct:smeltery/melting/metal/gold/horse_armor" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_planks_to_willow_button" | "tconstruct:smeltery/seared/seared_stone_slab_stonecutter" | "ad_astra:stonecutting/moon_stone_brick_stairs_from_moon_stone_stonecutting" | "minecraft:deepslate_brick_wall" | "tconstruct:smeltery/casting/water/purple_concrete" | "tconstruct:tools/modifiers/salvage/defense/knockback_resistance" | "ae2:network/cables/dense_covered_yellow" | "create:crafting/kinetics/shaft" | "tconstruct:tools/modifiers/ability/bulk_quiver" | "molten_metals:splashing/gold_ingot_from_metal_mold" | "tconstruct:smeltery/casting/slime/sky/congealed" | "create:small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "iceandfire:armor_gray_chestplate" | "create:item_application/andesite_casing_from_log" | "create:cutting/runtime_generated/compat/biomesoplenty/maple_planks_to_maple_door" | "ae2:network/blocks/storage_drive" | "railways:stonecutting/palettes/cycling/locometal_smokebox" | "hexcasting:amethyst_sconce" | "minecraft:lime_bed" | "tconstruct:tools/materials/rock/deepslate" | "farmersdelight:rice_from_bag" | "hexpigmentplus:magician_hat_clown" | "ad_astra:nasa_workbench/tier_1_rocket_from_nasa_workbench" | "classicpipes:stocking_pipe_a" | "classicpipes:stocking_pipe_b" | "create:blasting/zinc_ingot_from_ore" | "create:haunting/soul_soil" | "farmersdelight:flint_knife" | "biomesoplenty:maple_boat" | "minecraft:cherry_chest_boat" | "railways:crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal" | "tconstruct:tools/modifiers/stringy_tinker_station" | "tconstruct:smeltery/melting/slime/sky/block" | "ad_astra:stonecutting/moon_pillar_from_moon_stone_stonecutting" | "ad_astra:desh_nugget" | "tconstruct:gadgets/cake/ender" | "create:polished_cut_tuff_slab_from_stone_types_tuff_stonecutting" | "createaddition:rolling/electrum_plate" | "iceandfire:armor_sapphire_boots" | "ae2:network/cables/glass_purple" | "comforts:sleeping_bag_orange" | "create:crafting/kinetics/steam_whistle" | "create:splashing/runtime_generated/compat/minecraft/light_blue_concrete_powder_to_light_blue_concrete" | "hexcasting:dye_colorizer_gray" | "create:milling/tall_grass" | "ae2:network/parts/toggle_bus_inverted_alt" | "simplylight:walllamp" | "railways:crafting/palettes/dyeing_1x/purple_riveted_locometal" | "create:cutting/runtime_generated/compat/minecraft/birch_wood_to_stripped_birch_wood" | "create:polished_cut_scorchia_slab_recycling" | "tconstruct:smeltery/melting/metal/cobalt/raw_block" | "ae2:network/cables/dense_covered_light_gray" | "ad_astra:raw_desh" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_stairs" | "minecraft:magenta_dye_from_purple_and_pink" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_wood_to_stripped_mahogany_wood" | "create:cutting/runtime_generated/compat/minecraft/cherry_log_to_stripped_cherry_log" | "extendedae:epp_part" | "minecraft:purpur_pillar" | "ad_astra:steel_nugget" | "ad_astra:smelting/iron_ingot_from_smelting_glacio_iron_ore" | "biomesoplenty:palm_trapdoor" | "ad_astra:ostrum_panel" | "ad_astra:small_yellow_industrial_lamp" | "create:deploying/waxed_oxidized_copper_from_adding_wax" | "simplylight:illuminant_red_block_dyed" | "biomesoplenty:cut_orange_sandstone_slab" | "simplylight:illuminant_gray_block_dyed" | "hexcasting:slate_bricks_small_from_slate_bricks" | "createaddition:charging/exposed_copper_shingles" | "minecraft:redstone_lamp" | "hexcasting:edified_fence_gate" | "minecraft:end_rod" | "hexcasting:dynamicseal_focus" | "minecraft:iron_ingot_from_blasting_iron_ore" | "tconstruct:tools/modifiers/salvage/ability/spilling" | "tconstruct:tables/crafting_station" | "farmersdelight:cutting/cod" | "ae2:tools/certus_quartz_axe" | "create:polished_cut_andesite_slab_from_stone_types_andesite_stonecutting" | "hexcasting:amethyst_dust_unpacking" | "hextended:long/extended_warped" | "iceandfire:dread_torch" | "biomesoplenty:orange_sandstone" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_planks_to_empyreal_door" | "create:cutting/runtime_generated/compat/hexcasting/edified_planks_to_edified_stairs" | "create:polished_cut_veridium_slab_recycling" | "ae2:inscriber/sky_stone_dust" | "tconstruct:smeltery/entity_melting/creeper" | "farmersdelight:cutting/dark_oak_log" | "railways:stonecutting/palettes/cycling/green_locometal_pillar" | "minecraft:acacia_boat" | "iceandfire:sapphire_block_to_sapphire_gem" | "tconstruct:smeltery/melting/metal/hepatizon/nugget" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_planks_to_palm_button" | "tconstruct:common/glass/light_blue_clear_stained_glass_pane" | "iceandfire:copper_pickaxe" | "railways:mechanical_crafting/pink_copper_wrapped_locometal_boiler" | "railways:crafting/palettes/dyeing_8x/brown_plated_locometal" | "farmersdelight:magenta_canvas_sign" | "railways:stonecutting/palettes/cycling/white_riveted_locometal" | "minecraft:dye_blue_bed" | "create:milling/bone" | "create:scoria_pillar_from_stone_types_scoria_stonecutting" | "ad_astra:chiseled_moon_stone_slab" | "tconstruct:tools/severing/stray_head" | "create:polished_cut_dripstone_stairs" | "tconstruct:smeltery/melting/slime/sky/crystal_block" | "railways:crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal_boiler" | "railways:crafting/palettes/dyeing_1x/green_riveted_locometal" | "tconstruct:tools/materials/composite/plated_slimewood" | "create:cutting/runtime_generated/compat/biomesoplenty/willow_planks_to_willow_sign" | "molten_metals:filling/gold_filled_metal_mold" | "minecraft:painting" | "iceandfire:banners/banner_pattern_gorgon" | "farmersdelight:cutting/wild_potatoes" | "ad_astra:smelting/coal_from_smelting_glacio_coal_ore" | "railways:crafting/palettes/dyeing_8x/cyan_locometal_pillar" | "create:cutting/runtime_generated/compat/biomesoplenty/umbran_planks_to_umbran_pressure_plate" | "minecraft:dark_oak_wood" | "createaddition:crafting/small_connector_copper" | "create:crafting/kinetics/blue_seat_from_other_seat" | "create:small_ochrum_brick_slab_recycling" | "tconstruct:tools/materials/wood/logs/warped" | "farmersdelight:cutting/birch_hanging_sign" | "ae2:network/blocks/crank" | "railways:crafting/palettes/dyeing_8x/black_copper_wrapped_locometal" | "biomesoplenty:fir_stairs" | "iceandfire:dragonsteel_ice_boots" | "tconstruct:tools/severing/husk_head" | "powah:crafting/energy_hopper_spirited" | "minecraft:stone_brick_slab_from_stone_stonecutting" | "ad_astra:stonecutting/mercury_stone_stairs_from_mercury_stone_stonecutting" | "farmersdelight:integration/create/milling/wild_potatoes" | "create:cutting/runtime_generated/compat/biomesoplenty/hellbark_log_to_stripped_hellbark_log" | "create:deploying/copper_shingle_stairs_from_deoxidising" | "railways:sequenced_assembly/track_biomesoplenty_dead_wide" | "create:crafting/appliances/item_frame" | "iceandfire:dragonsteel_fire_boots" | "ae2:network/crafting/64k_cpu_crafting_storage" | "biomesoplenty:orange_sandstone_wall_from_orange_sandstone_stonecutting" | "railways:sequenced_assembly/track_cherry_wide" | "tconstruct:smeltery/casting/quartz/gem_gold_cast" | "create:deploying/waxed_weathered_copper_shingle_stairs_from_adding_wax" | "tconstruct:smeltery/melting/seared/grout" | "create:crafting/materials/andesite_alloy_block" | "tconstruct:smeltery/casting/slime/sky/bottle" | "minecraft:oak_trapdoor" | "create:crafting/materials/cardboard_from_block" | "create:crafting/kinetics/pink_seat_from_other_seat" | "ad_astra:stonecutting/mars_pillar_from_mars_stone_bricks_stonecutting" | "railways:stonecutting/palettes/cycling/orange_plated_locometal" | "simplylight:illuminant_magenta_block_dyed" | "minecraft:waxed_cut_copper_slab_from_honeycomb" | "create:crafting/materials/cardboard_block" | "create:crafting/kinetics/placard" | "minecraft:birch_button" | "farmersdelight:grilled_salmon" | "ae2:network/cables/dense_smart_brown" | "create:crushing/diamond_horse_armor" | "ad_astra:desh_ingot_from_desh_block" | "powah:crafting/ender_cell_blazing_2" | "tconstruct:common/copper_platform_waxing_exposed" | "minecraft:weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "tconstruct:smeltery/casting/clay/brick_sand_cast" | "minecraft:cyan_bed" | "resourcechickens:duck_cooked" | "ad_astra:small_gray_industrial_lamp" | "ad_astra:stonecutting/venus_cobblestone_slab_from_venus_cobblestone_stonecutting" | "ad_astra:venus_pillar" | "create:cutting/runtime_generated/compat/hexcasting/edified_planks_to_edified_door" | "create:crafting/kinetics/white_valve_handle_from_other_valve_handle" | "iceandfire:dragon_stick" | "create:crafting/kinetics/crafter_slot_cover" | "hexcasting:staff/birch" | "create:crafting/materials/brass_ingot_from_decompacting" | "simplylight:illuminant_green_block_on_toggle" | "railways:stonecutting/palettes/cycling/green_locometal_smokebox" | "createoreexcavation:drilling/quartz" | "ae2:block_cutter/walls/cut_quartz_wall" | "ad_astra:smelting/iron_ingot_from_smelting_moon_iron_ore" | "railways:crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal" | "createaddition:charging/weathered_cut_copper" | "farmersdelight:chocolate_pie" | "create:crafting/appliances/cardboard_boots" | "create:cutting/runtime_generated/compat/biomesoplenty/mahogany_planks_to_mahogany_door" | "tconstruct:tools/modifiers/slotless/resurrected" | "tconstruct:tools/modifiers/salvage/ability/double_jump" | "create:small_limestone_brick_slab_recycling" | "railways:crafting/palettes/dyeing_1x/brown_slashed_locometal" | "railways:crafting/palettes/wrapping/cyan_copper_wrapped_locometal" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_planks_to_palm_sign" | "minecraft:orange_stained_glass_pane" | "railways:crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal" | "comforts:hammock_pink" | "minecraft:brick" | "create:deploying/weathered_copper_shingle_slab_from_deoxidising" | "railways:mechanical_crafting/light_blue_locometal_boiler" | "powah:crafting/ender_cell_starter_2" | "molten_metals:mixing/molten_gold_from_block" | "minecraft:music_disc_5" | "molten_metals:filling/iron_filled_metal_mold" | "railways:crafting/palettes/dyeing_8x/blue_riveted_locometal" | "minecraft:coal" | "railways:sequenced_assembly/track_biomesoplenty_redwood_wide" | "railways:crafting/palettes/dyeing_1x/green_slashed_locometal" | "minecraft:gold_ingot_from_blasting_deepslate_gold_ore" | "railways:crafting/palettes/dyeing_1x/blue_locometal_pillar" | "tconstruct:common/materials/cobalt_ingot_from_block" | "tconstruct:smeltery/melting/metal/cobalt/ore_singular" | "ad_astra:glacian_button" | "hextended:purpur_staff" | "ad_astra:stonecutting/mars_stone_brick_wall_from_mars_stone_stonecutting" | "railways:stonecutting/palettes/cycling/cyan_locometal_pillar" | "create:filling/blaze_cake" | "railways:crafting/palettes/dyeing_8x/white_riveted_locometal" | "minecraft:smoker" | "create:splashing/iceandfire/crushed_raw_silver" | "ae2:inscriber/silicon_print" | "ad_astra:smelting/venus_stone_from_smelting_venus_cobblestone" | "railways:crafting/palettes/wrapping/purple_brass_wrapped_locometal" | "tconstruct:tools/modifiers/salvage/upgrade/necrotic" | "create:polished_cut_scorchia_wall" | "tconstruct:armor/repair/slimeshell_repair_kit" | "create:deploying/waxed_weathered_copper_tile_slab_from_adding_wax" | "tconstruct:smeltery/casts/red_sand_casts/bow_limb" | "tconstruct:smeltery/casts/sand_casts/bow_grip" | "railways:stonecutting/palettes/cycling/light_blue_locometal_smokebox" | "sophisticatedbackpacks:iron_backpack" | "tconstruct:tools/modifiers/salvage/ability/tilling" | "create:andesite_ladder_from_andesite_alloy_stonecutting" | "tconstruct:tools/building/earth_staff" | "create:crafting/kinetics/smart_chute" | "ad_astra:moon_stone_brick_slab" | "minecraft:brown_dye" | "iceandfire:crackled_to_gravel" | "minecraft:waxed_exposed_cut_copper_stairs_from_honeycomb" | "minecraft:brick_slab" | "railways:crafting/palettes/dyeing_8x/orange_plated_locometal" | "railways:conductor_vent_from_industrial_iron_block_stonecutting" | "farmersdelight:cutting/clay" | "tconstruct:tools/modifiers/salvage/upgrade/piercing" | "tconstruct:common/slime/ender/crystal_smelting" | "tconstruct:common/glass/vanilla/end_crystal" | "create:deploying/waxed_exposed_copper_shingle_stairs_from_adding_wax" | "ad_astra:blasting/ice_shard_from_blasting_moon_ice_shard_ore" | "tconstruct:common/glass/orange_clear_stained_glass_pane" | "minecraft:bricks" | "minecraft:red_sandstone_slab" | "hexcasting:compat/farmersdelight/cutting/edified_log_citrine" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_dead_log_to_dead_planks" | "railways:crafting/palettes/dyeing_1x/orange_riveted_locometal" | "tconstruct:tools/modifiers/salvage/upgrade/padded" | "hexcasting:slate_bricks_from_slate_bricks_small" | "powah:crafting/energy_hopper_nitro" | "minecraft:yellow_glazed_terracotta" | "ae2:network/cells/fluid_storage_cell_64k_storage" | "create:polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "tconstruct:tools/building/ichor_staff" | "iceandfire:dragon_ice" | "sophisticatedbackpacks:auto_smoking_upgrade_from_auto_smelting_upgrade" | "simplylight:illuminant_black_block_toggle" | "minecraft:exposed_cut_copper" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_fence_gate" | "farmersdelight:cutting/cherry_wood" | "create:deploying/copper_block_from_deoxidising" | "minecraft:dark_oak_stairs" | "minecraft:jungle_pressure_plate" | "farmersdelight:honey_glazed_ham_block" | "minecraft:host_armor_trim_smithing_template" | "railways:crafting/palettes/wrapping/cyan_brass_wrapped_locometal" | "tconstruct:smeltery/melting/slime/sky/bud_small" | "create:cut_veridium_brick_slab_recycling" | "minecraft:smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "ae2:tools/paintballs_lumen_cyan" | "ae2:network/cables/smart_pink" | "farmersdelight:orange_hanging_canvas_sign" | "iceandfire:armor_red_chestplate" | "powah:crafting/magmator_starter" | "tconstruct:smeltery/melting/metal/netherite/lodestone" | "tconstruct:smeltery/casting/seared/cobble/slab" | "minecraft:blue_banner" | "ae2:network/cables/dense_smart_yellow" | "ae2:decorative/cut_quartz_block" | "tconstruct:tools/parts/builder/broad_blade" | "railways:crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal_boiler" | "iceandfire:forest_troll_leather_helmet" | "ad_astra:venus_stone_brick_wall" | "create:cutting/runtime_generated/compat/biomesoplenty/dead_planks_to_dead_door" | "biomesoplenty:hellbark_slab" | "create:crafting/logistics/redstone_requester_clear" | "biomesoplenty:white_sandstone_stairs" | "tconstruct:compat/create/andesite_alloy_iron" | "create:crushing/leather_horse_armor" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_door" | "minecraft:glowstone" | "create:copper_tile_slab" | "create:crushing/nether_quartz_ore" | "minecraft:vex_armor_trim_smithing_template_smithing_trim" | "create:cut_deepslate_brick_stairs" | "biomesoplenty:jacaranda_chest_boat" | "minecraft:red_nether_brick_wall" | "create:small_crimsite_brick_stairs" | "minecraft:chiseled_red_sandstone" | "biomesoplenty:magic_pressure_plate" | "create:cutting/runtime_generated/compat/ad_astra/glacian_planks_to_glacian_stairs" | "farmersdelight:fried_egg" | "molten_metals:emptying/molten_iron_from_metal_mold" | "biomesoplenty:pine_slab" | "tconstruct:smeltery/casts/sand_casts/small_blade" | "railways:sequenced_assembly/track_biomesoplenty_fir_wide" | "railways:crafting/palettes/dyeing_1x/black_locometal_smokebox" | "create:filling/gunpowder" | "ad_astra:stonecutting/mars_stone_bricks_from_mars_stone_stonecutting" | "create:polished_cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "tconstruct:smeltery/melting/metal/slimesteel/ingot" | "powah:crafting/thermo_generator_nitro" | "tconstruct:smeltery/melting/metal/gold/rod" | "ad_astra:stonecutting/moon_stone_brick_wall_from_moon_stone_bricks_stonecutting" | "minecraft:light_gray_candle" | "tconstruct:tools/materials/rose_gold/ingot" | "tconstruct:smeltery/casting/metal/manyullyn/nugget_gold_cast" | "minecraft:cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "create:crafting/kinetics/belt_connector" | "ae2:network/blocks/pattern_providers_interface_alt" | "tconstruct:tools/severing/wither_skeleton_bone" | "ad_astra:chiseled_glacio_stone_slab" | "simplylight:illuminant_lime_block_on_toggle" | "create_copper_and_zinc:mixing_asurine" | "ad_astra:aeronos_ladder" | "tconstruct:world/wood/greenheart/fence" | "minecraft:dye_lime_carpet" | "farmersdelight:cooking/tomato_sauce" | "tconstruct:smeltery/casting/metal/queens_slime/ingot_gold_cast" | "farmersdelight:fruit_salad" | "create:crafting/logistics/orange_postbox" | "railways:sequenced_assembly/black_conductor_cap" | "ae2:inscriber/logic_processor" | "ae2:decorative/certus_quartz_bricks_from_stonecutting" | "ae2:decorative/chiseled_quartz_block" | "iceandfire:dragonscales_gray_to_dragonscale_gray" | "minecraft:deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "tconstruct:smeltery/casting/water/light_gray_concrete" | "railways:crafting/palettes/dyeing_1x/pink_locometal_boiler" | "tconstruct:smeltery/melting/metal/cobalt/platform" | "tconstruct:tools/materials/hepatizon/ingot" | "powah:crafting/reactor_nitro" | "minecraft:sea_lantern" | "create:weathered_copper_tile_slab" | "tconstruct:smeltery/casting/water/pink_concrete" | "tconstruct:gadgets/frame/netherite" | "tconstruct:tools/materials/gold/block" | "farmersdelight:cutting/oak_hanging_sign" | "molten_metals:emptying/molten_brass_from_metal_mold" | "hexcasting:compat/farmersdelight/cutting/akashic_trapdoor" | "create:milling/sandstone" | "minecraft:diamond_hoe" | "farmersdelight:tomato_seeds" | "farmersdelight:cutting/dark_oak_sign" | "minecraft:dye_cyan_wool" | "railways:crafting/palettes/dyeing_1x/brown_flat_slashed_locometal" | "railways:crafting/palettes/dyeing_1x/magenta_locometal_boiler" | "farmersdelight:cutting/allium" | "ad_astra:stonecutting/mercury_cobblestone_slab_from_mercury_cobblestone_stonecutting" | "ae2:tools/paintballs_green" | "create:polished_cut_deepslate_from_stone_types_deepslate_stonecutting" | "railways:stonecutting/palettes/cycling/pink_slashed_locometal" | "minecraft:weathered_cut_copper" | "create:cutting/runtime_generated/compat/biomesoplenty/redwood_planks_to_redwood_door" | "tconstruct:tools/parts/builder/broad_axe_head" | "createoreexcavation:ore_vein_type/coal" | "railways:crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal" | "create:polished_cut_limestone_stairs" | "extendedae:wireless_connector" | "hexcasting:compat/farmersdelight/cutting/edified_log_purple" | "create:deploying/waxed_exposed_copper_shingles_from_adding_wax" | "biomesoplenty:brimstone_cluster_from_brimstone_stonecutting" | "minecraft:end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "hexpigmentplus:magician_hat" | "minecraft:dye_pink_carpet" | "extendedae:active_formation_plane" | "simplylight:edge_light" | "minecraft:leather" | "create:polished_cut_ochrum_stairs" | "tconstruct:tools/parts/casting/broad_axe_head_gold_cast" | "railways:crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal" | "hexcasting:pride_colorizer_genderfluid" | "minecraft:waxed_cut_copper_stairs_from_honeycomb" | "tconstruct:smeltery/melting/metal/iron/helmet" | "create:cut_diorite_slab" | "create:cut_diorite_brick_slab_recycling" | "minecraft:dye_brown_bed" | "sophisticatedbackpacks:gold_backpack" | "create:crafting/logistics/black_table_cloth" | "minecraft:stone_brick_wall_from_stone_bricks_stonecutting" | "ad_astra:encased_calorite_block" | "create:deploying/oxidized_cut_copper_stairs_from_removing_wax" | "tconstruct:smeltery/melting/glass/sand_cast" | "ae2:block_cutter/stairs/chiseled_quartz_stairs" | "minecraft:furnace" | "iceandfire:sea_serpent_scales_purple_to_sea_serpent_scale_block_purple" | "molten_metals:slag_from_block" | "hextended:long/extended_flowered_moss_staff" | "molten_metals:filling/gold_filled_ceramic_mold" | "minecraft:dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "tconstruct:armor/repair/wood_repair_kit" | "tconstruct:tools/modifiers/ability/reflecting" | "farmersdelight:cooking/fish_stew" | "tconstruct:smeltery/melting/metal/iron/horse_armor" | "ae2:network/blocks/quantum_link" | "tconstruct:smeltery/melting/clay/brick_slab" | "ae2:network/parts/level_emitter" | "create:cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "simplylight:illuminant_green_block_toggle" | "minecraft:activator_rail" | "create:crafting/kinetics/purple_valve_handle_from_other_valve_handle" | "ae2:network/cells/item_storage_components_cell_4k_part" | "minecraft:crimson_pressure_plate" | "railways:crafting/track_switch_brass" | "tconstruct:armor/building/slime_skull/bloodbone" | "tconstruct:tools/materials/casting/scorched_stone" | "classicpipes:obsidian_pipe" | "ad_astra:desh_sliding_door" | "create:veridium_pillar_from_stone_types_veridium_stonecutting" | "minecraft:cherry_stairs" | "createaddition:compat/tconstruct/slimesteel" | "create:crafting/logistics/gray_table_cloth" | "hexcasting:pride_colorizer_aromantic" | "minecraft:red_sandstone" | "create:crafting/appliances/slime_ball" | "ae2:shaped/slabs/chiseled_quartz_block" | "hexcasting:brainsweep/impetus_storedplayer" | "create:cutting/runtime_generated/compat/hexcasting/stripped_edified_log_to_edified_planks" | "farmersdelight:cutting/warped_hanging_sign" | "tconstruct:tools/materials/copper/ingot" | "tconstruct:tools/parts/builder/small_blade" | "tconstruct:tools/parts/casting/repair_kit_sand_cast" | "tconstruct:smeltery/casting/metal/gold/melon" | "iceandfire:dragonarmor_dragon_steel_ice_head" | "iceandfire:diamond_hippogryph_armor" | "create:crafting/kinetics/cart_assembler" | "create:deploying/weathered_copper_tile_slab_from_deoxidising" | "tconstruct:smeltery/casting/water/gray_concrete" | "biomesoplenty:willow_wood" | "agricraft:magnifying_helmet" | "biomesoplenty:empyreal_fence" | "classicpipes:warped_fluid_pipe_a" | "minecraft:waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "classicpipes:warped_fluid_pipe_b" | "minecraft:bamboo_fence" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_willow_wood_to_willow_planks" | "minecraft:red_glazed_terracotta" | "minecraft:birch_boat" | "railways:crafting/palettes/dyeing_1x/pink_flat_riveted_locometal" | "hexcasting:stonecutting/quenched_allay_bricks_small" | "iceandfire:summoning_crystal_ice_reset" | "tconstruct:smeltery/melting/metal/copper/rod" | "createaddition:filling/cake" | "railways:crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal_boiler" | "minecraft:packed_mud" | "railways:stonecutting/palettes/cycling/gray_riveted_locometal" | "ae2:tools/paintballs_black" | "minecraft:netherite_helmet_smithing" | "tconstruct:smeltery/casting/metal/netherite/debris_nugget_gold_cast" | "create:crushing/raw_gold_block" | "computercraft:monitor_advanced" | "tconstruct:smeltery/melting/obsidian/pane" | "create:layered_calcite_from_stone_types_calcite_stonecutting" | "tconstruct:smeltery/melting/emerald/gem" | "iceandfire:dragonarmor_gold_head" | "biomesoplenty:pine_chest_boat" | "powah:crafting/ender_cell_niotic" | "ad_astra:stonecutting/polished_venus_stone_stairs_from_venus_stone_stonecutting" | "createaddition:crafting/festive_spool" | "biomesoplenty:dead_button" | "iceandfire:furnace/frozen_grass" | "iceandfire:dragonscales_sapphire_to_dragonscale_sapphire" | "createaddition:compacting/cake_base" | "ae2:tools/nether_quartz_wrench" | "railways:sequenced_assembly/track_tieless_narrow" | "create:crafting/kinetics/filter" | "create:crafting/appliances/schedule_clear" | "tconstruct:armor/repair/slimelytra_station" | "tconstruct:smeltery/melting/metal/iron/raw_block" | "create:mixing/compat/ae2/fluix_crystal" | "ad_astra:space_station/moon_orbit_space_station" | "tconstruct:tools/materials/slimesteel/ingot" | "tconstruct:smeltery/seared/seared_cobble_slab" | "tconstruct:tools/modifiers/slotless/embellishment_slimesteel" | "minecraft:gray_candle" | "create:crafting/kinetics/speedometer_from_conversion" | "minecraft:stripped_dark_oak_wood" | "biomesoplenty:blackstone_spines" | "powah:crafting/furnator_blazing" | "ad_astra:smelting/ice_shard_from_smelting_mars_ice_shard_ore" | "create:milling/red_tulip" | "create:asurine_pillar_from_stone_types_asurine_stonecutting" | "biomesoplenty:smooth_black_sandstone_slab_from_smooth_black_sandstone_stonecutting" | "create:crafting/materials/brass_nugget_from_decompacting" | "ad_astra:cryo_freezer" | "create:deploying/cut_copper_slab_from_removing_wax" | "minecraft:birch_fence" | "create:crafting/kinetics/brass_door" | "create:milling/coal" | "create:milling/compat/biomesoplenty/glowflower" | "tconstruct:smeltery/melting/slime/ender/ball" | "farmersdelight:cooking_pot" | "hexcasting:pride_colorizer_demiboy" | "create:crafting/materials/zinc_ingot_from_compacting" | "minecraft:red_nether_brick_slab" | "create:cutting/runtime_generated/compat/tconstruct/greenheart_planks_to_greenheart_fence" | "createaddition:crafting/biomass_pellet_block" | "tconstruct:common/materials/manyullyn_ingot_from_nuggets" | "ad_astra:compressing/steel_plate_from_compressing_steel_ingots" | "minecraft:cooked_salmon_from_campfire_cooking" | "create:cut_crimsite_brick_slab" | "ae2:tools/paintballs_yellow" | "computercraft:pocket_advanced/computercraft/wireless_modem_normal" | "tconstruct:smeltery/casting/diamond/gem_sand_cast" | "create:crafting/kinetics/green_valve_handle_from_other_valve_handle" | "iceandfire:dragonarmor_dragon_steel_lightning_tail" | "railways:crafting/palettes/dyeing_8x/lime_flat_slashed_locometal" | "minecraft:cut_sandstone_slab_from_cut_sandstone_stonecutting" | "ad_astra:polished_glacio_stone_slab" | "tconstruct:smeltery/casting/slime/blood/bottle" | "railways:mechanical_crafting/gray_iron_wrapped_locometal_boiler" | "railways:mechanical_crafting/green_iron_wrapped_locometal_boiler" | "minecraft:sugar_from_honey_bottle" | "create:milling/compat/biomesoplenty/white_lavender" | "tconstruct:smeltery/casting/blazewood" | "minecraft:spruce_fence_gate" | "minecraft:leather_chestplate" | "create:milling/compat/ae2/certus_quartz" | "ad_astra:stonecutting/glacio_stone_brick_wall_from_glacio_stone_stonecutting" | "minecraft:beehive" | "railways:crafting/palettes/dyeing_8x/magenta_locometal_smokebox" | "minecraft:white_stained_glass_pane_from_glass_pane" | "biomesoplenty:mahogany_chest_boat" | "create:deploying/oxidized_cut_copper_from_removing_wax" | "railways:sequenced_assembly/track_birch_narrow" | "createaddition:crafting/diamond_grit_sandpaper" | "create:crafting/logistics/green_postbox_from_other_postbox" | "minecraft:birch_wood" | "iceandfire:sea_serpent_scales_green_to_sea_serpent_scale_block_green" | "railways:crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal" | "minecraft:scaffolding" | "ad_astra:compressing/calorite_plate_from_compressing_calorite_blocks" | "computercraft:turtle_advanced/computercraft/speaker" | "railways:crafting/palettes/dyeing_8x/brown_locometal_pillar" | "tconstruct:tools/modifiers/salvage/upgrade/hydraulic" | "minecraft:acacia_button" | "tconstruct:gadgets/fancy_frame/reversed_reversed_gold" | "minecraft:polished_granite_from_granite_stonecutting" | "create:crushing/glowstone" | "molten_metals:mixing/molten_zinc_from_ingot" | "create:small_asurine_brick_wall" | "minecraft:lapis_lazuli_from_smelting_deepslate_lapis_ore" | "create:splashing/runtime_generated/compat/minecraft/magenta_concrete_powder_to_magenta_concrete" | "railways:stonecutting/palettes/cycling/gray_locometal_pillar" | "tconstruct:smeltery/melting/metal/gold/gilded_blackstone" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_slab" | "createaddition:crafting/copper_spool" | "sophisticatedbackpacks:copper_backpack" | "create:mechanical_crafting/extendo_grip" | "biomesoplenty:magic_stairs" | "hextended:long/extended_crimson" | "tconstruct:tools/modifiers/defense/fire_protection" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_wood_to_stripped_palm_wood" | "create:cutting/runtime_generated/compat/minecraft/cherry_planks_to_cherry_fence" | "minecraft:andesite_slab" | "railways:mechanical_crafting/black_brass_wrapped_locometal_boiler" | "tconstruct:smeltery/casting/slime/blood/slimeball" | "minecraft:bamboo_chest_raft" | "iceandfire:dread_stone" | "ad_astra:stonecutting/moon_cobblestone_stairs_from_moon_cobblestone_stonecutting" | "minecraft:honey_block" | "railways:crafting/palettes/wrapping/orange_iron_wrapped_locometal" | "minecraft:bamboo_planks" | "powah:crafting/thermo_generator_starter" | "create:deploying/exposed_copper_shingle_slab_from_deoxidising" | "create:crafting/logistics/stock_ticker" | "farmersdelight:melon_juice" | "create:crafting/kinetics/large_cogwheel" | "ad_astra:glacian_slab" | "create:cutting/runtime_generated/compat/tconstruct/stripped_greenheart_log_to_greenheart_planks" | "ad_astra:mercury_cobblestone_slab" | "iceandfire:tide_blue_boots" | "create:crafting/kinetics/metal_bracket" | "minecraft:stone_brick_stairs_from_stone_bricks_stonecutting" | "hexical:lightning_rod_staff" | "createaddition:charging/cut_copper_stairs" | "create:cutting/runtime_generated/compat/tconstruct/stripped_bloodshroom_wood_to_bloodshroom_planks" | "railways:crafting/palettes/dyeing_1x/light_blue_flat_slashed_locometal" | "createaddition:compat/tconstruct/rose_gold" | "ad_astra:jet_suit_helmet" | "create:crafting/kinetics/framed_glass_door" | "create:crafting/logistics/orange_table_cloth_from_other_table_cloth" | "minecraft:coal_from_blasting_coal_ore" | "iceandfire:dragonsteel_lightning_helmet" | "molten_metals:mixing/molten_gold_from_block_raw" | "ad_astra:blasting/ostrum_ingot_from_blasting_mars_ostrum_ore" | "extendedae:precise_storage_bus" | "ad_astra:space_station/glacio_orbit_space_station" | "tconstruct:smeltery/casting/scorched/polished_from_magma" | "tconstruct:tools/severing/creeper_tnt" | "createoreexcavation:drilling/diamond" | "biomesoplenty:redwood_wood" | "create:crafting/kinetics/gantry_carriage" | "farmersdelight:cutting/red_tulip" | "railways:stonecutting/palettes/cycling/pink_flat_slashed_locometal" | "hexcasting:brainsweep/budding_amethyst" | "tconstruct:smeltery/seared/seared_paver_smelting" | "ad_astra:smelting/diamond_from_smelting_mars_diamond_ore" | "ae2:network/blocks/cell_workbench" | "farmersdelight:cutting/spruce_wood" | "create:crafting/logistics/powered_latch" | "tconstruct:smeltery/scorched/scorched_road_slab_stonecutter" | "railways:crafting/palettes/wrapping/red_copper_wrapped_locometal" | "hexcasting:edified_trapdoor" | "iceandfire:frost_troll_leather_chestplate" | "biomesoplenty:fir_slab" | "create:ochrum_pillar_from_stone_types_ochrum_stonecutting" | "farmersdelight:cutting/crimson_hyphae" | "minecraft:warped_hanging_sign" | "create:cutting/runtime_generated/compat/tconstruct/skyroot_planks_to_skyroot_fence_gate" | "railways:crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal" | "tconstruct:smeltery/scorched/fuel_gauge" | "minecraft:cracked_deepslate_bricks" | "hextended:long/extended_oak" | "minecraft:orange_dye_from_torchflower" | "createaddition:compacting/biomass_pellet" | "tconstruct:common/glass/light_gray_clear_stained_glass_pane" | "tconstruct:smeltery/casting/seared/glass_pane" | "railways:crafting/palettes/dyeing_1x/white_riveted_locometal" | "create:smelting/iron_ingot_from_crushed" | "ad_astra:desh_plateblock" | "hextended:dark_prismarine_staff" | "railways:crafting/palettes/dyeing_8x/red_locometal_smokebox" | "farmersdelight:cooking/pasta_with_meatballs" | "create:crafting/kinetics/track_signal" | "railways:mechanical_crafting/light_blue_brass_wrapped_locometal_boiler" | "tconstruct:tools/modifiers/salvage/ability/long_fall" | "create:crafting/materials/andesite_alloy_from_block" | "minecraft:jungle_fence_gate" | "tconstruct:armor/building/plate_helmet" | "create:cut_asurine_wall" | "iceandfire:dragonarmor_dragon_steel_ice_neck" | "create:crafting/kinetics/water_wheel" | "create:polished_cut_asurine_wall_from_stone_types_asurine_stonecutting" | "biomesoplenty:fir_fence_gate" | "tconstruct:tools/modifiers/silky_cloth" | "railways:crafting/palettes/wrapping/brown_iron_wrapped_locometal" | "simplylight:illuminant_orange_block_on_toggle" | "create:mixing/chocolate_melting" | "create:cutting/runtime_generated/compat/minecraft/stripped_dark_oak_wood_to_dark_oak_planks" | "iceandfire:armor_black_helmet" | "railways:crafting/palettes/dyeing_8x/red_brass_wrapped_locometal" | "ae2:network/cables/dense_covered_fluix" | "create:crafting/materials/raw_zinc_block" | "create:cutting/runtime_generated/compat/minecraft/jungle_planks_to_jungle_fence" | "molten_metals:slag_from_nugget" | "create:cutting/andesite_alloy" | "create:pressing/copper_ingot" | "hexcasting:dye_colorizer_lime" | "farmersdelight:light_blue_canvas_sign" | "create:cut_diorite_slab_from_stone_types_diorite_stonecutting" | "create:cutting/runtime_generated/compat/tconstruct/stripped_skyroot_log_to_skyroot_planks" | "minecraft:polished_basalt_from_basalt_stonecutting" | "tconstruct:gadgets/punji" | "hexcasting:ageing_scroll_paper_lantern" | "railways:crafting/palettes/dyeing_8x/white_copper_wrapped_locometal_boiler" | "createoreexcavation:netherite_drill_smithing" | "tconstruct:smeltery/seared/drain_retextured" | "create:milling/compat/biomesoplenty/tall_lavender" | "tconstruct:smeltery/casting/metal/cobalt/ingot_sand_cast" | "ad_astra:blasting/iron_ingot_from_blasting_glacio_iron_ore" | "ad_astra:iron_sliding_door" | "iceandfire:silver_ingot_from_smelting_raw_silver" | "minecraft:polished_granite_slab_from_polished_granite_stonecutting" | "extendedae:caner" | "minecraft:warped_planks" | "minecraft:red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "create:cutting/runtime_generated/compat/minecraft/dark_oak_wood_to_stripped_dark_oak_wood" | "hexcasting:lens" | "create:crafting/kinetics/sticker" | "tconstruct:tools/modifiers/worktable/enchantment_converting/defense_tool" | "ae2:decorative/fluix_block" | "minecraft:red_candle" | "create:polished_cut_scoria_stairs" | "ad_astra:smelting/cracked_mercury_stone_bricks_from_smelting_mercury_stone_bricks" | "ducky-periphs:ducky_banner_pattern" | "create:cutting/runtime_generated/compat/biomesoplenty/jacaranda_planks_to_jacaranda_button" | "minecraft:brown_carpet" | "create:cut_granite_brick_slab" | "railways:crafting/palettes/dyeing_8x/pink_flat_riveted_locometal" | "create:oxidized_copper_tile_slab" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_planks_to_empyreal_slab" | "minecraft:crimson_fence" | "tconstruct:tools/modifiers/upgrade/lightspeed_from_dust" | "minecraft:oxidized_cut_copper_slab" | "tconstruct:tools/modifiers/golden_tinker_station" | "create:deploying/cut_copper_stairs_from_removing_wax" | "createaddition:mixing/biomass_from_leaves" | "tconstruct:smeltery/melting/metal/zinc/ingot" | "iceandfire:armor_blue_boots" | "railways:crafting/palettes/dyeing_8x/red_copper_wrapped_locometal" | "minecraft:light_gray_stained_glass" | "biomesoplenty:white_sandstone_slab" | "sophisticatedbackpacks:backpack_dye" | "biomesoplenty:rose_quartz_block" | "tconstruct:tools/severing/cave_spider_head" | "minecraft:decorated_pot_simple" | "ae2:shaped/walls/fluix_block" | "biomesoplenty:cyan_dye_from_glowflower" | "biomesoplenty:mahogany_stairs" | "minecraft:oak_pressure_plate" | "minecraft:diorite" | "ad_astra:cable_duct" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_palm_log_to_palm_planks" | "ae2:shaped/stairs/quartz_bricks" | "tconstruct:tools/modifiers/salvage/ability/plowing" | "ad_astra:blasting/desh_ingot_from_blasting_deepslate_desh_ore" | "hextended:long/extended_purpur_staff" | "tconstruct:tools/modifiers/bronze_reinforcement" | "create:milling/poppy" | "minecraft:snout_armor_trim_smithing_template_smithing_trim" | "farmersdelight:cutting/bricks" | "iceandfire:dragonarmor_dragon_steel_fire_body" | "createoreexcavation:ore_vein_type/quartz" | "tconstruct:smeltery/melting/metal/cobalt/scorched_duct" | "hexpigmentplus:magician_cloak_scarf" | "tconstruct:smeltery/melting/soul/sand" | "powah:crafting/aerial_pearl" | "minecraft:crimson_button" | "minecraft:jungle_planks" | "minecraft:netherite_axe_smithing" | "ad_astra:compressing/ostrum_plate_from_compressing_ostrum_blocks" | "ae2:block_cutter/walls/sky_stone_small_brick_wall" | "tconstruct:tools/modifiers/salvage/upgrade/smite" | "ae2:decorative/sky_stone_small_brick" | "biomesoplenty:empyreal_boat" | "simplylight:illuminant_blue_block_dyed" | "tconstruct:tables/tool_recycling" | "iceandfire:gold_pile" | "biomesoplenty:smooth_orange_sandstone" | "tconstruct:smeltery/melting/diamond/helmet" | "agricraft:clipper" | "minecraft:polished_deepslate_slab_from_polished_deepslate_stonecutting" | "minecraft:red_nether_bricks" | "create:crushing/blaze_rod" | "createaddition:charging/copper_shingle_slab" | "tconstruct:world/wood/greenheart/planks" | "railways:crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal" | "tconstruct:tools/materials/scorched_stone/brick" | "minecraft:warped_slab" | "minecraft:mangrove_stairs" | "ad_astra:stonecutting/mars_stone_brick_stairs_from_mars_stone_stonecutting" | "minecraft:prismarine" | "createoreexcavation:ore_vein_type/redstone" | "create:crafting/logistics/packager_from_conversion" | "minecraft:chiseled_sandstone" | "railways:crafting/palettes/wrapping/copper_wrapped_locometal" | "minecraft:bamboo_raft" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_willow_log_to_willow_planks" | "ad_astra:stonecutting/chiseled_permafrost_brick_slab_from_chiseled_permafrost_bricks_stonecutting" | "tconstruct:tools/modifiers/upgrade/overforced" | "iceandfire:armor_copper_leggings" | "powah:crafting/ender_gate_blazing_2" | "tconstruct:smeltery/casting/soul/pane" | "iceandfire:banners/banner_pattern_lightning" | "railways:sequenced_assembly/track_ender_narrow" | "railways:sequenced_assembly/track_acacia" | "minecraft:moss_carpet" | "minecraft:mossy_cobblestone_slab" | "create:crafting/kinetics/nozzle" | "simplylight:illuminant_gray_block_on_dyed" | "molten_metals:mixing/molten_iron_from_block" | "minecraft:polished_diorite_slab_from_diorite_stonecutting" | "powah:crafting/ender_gate_starter" | "railways:stonecutting/palettes/cycling/yellow_locometal_smokebox" | "createaddition:compat/tconstruct/pig_iron" | "tconstruct:smeltery/casting/seared/bricks/wall" | "comforts:hammock_to_pink" | "minecraft:cake" | "create:crafting/kinetics/linear_chassis" | "create:polished_cut_asurine_slab" | "tconstruct:tools/modifiers/salvage/ability/reflecting" | "tconstruct:smeltery/melting/metal/copper/ore_dense" | "minecraft:granite_slab" | "create:cutting/runtime_generated/compat/tconstruct/greenheart_planks_to_greenheart_door" | "minecraft:mud_brick_stairs" | "create:pressing/sugar_cane" | "tconstruct:smeltery/seared/grout_multiple" | "tconstruct:tools/modifiers/slotless/embellishment_gold" | "minecraft:lime_concrete_powder" | "ae2:network/blocks/energy_dense_energy_cell" | "minecraft:leather_leggings" | "minecraft:sandstone_wall_from_sandstone_stonecutting" | "ad_astra:smelting/ostrum_ingot_from_smelting_deepslate_ostrum_ore" | "ad_astra:purple_industrial_lamp" | "create:crushing/raw_iron_block" | "hextended:long/extended_dark_prismarine_staff" | "minecraft:polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "ae2:block_cutter/slabs/chiseled_quartz_slab" | "railways:sequenced_assembly/track_acacia_wide" | "railways:mechanical_crafting/light_gray_iron_wrapped_locometal_boiler" | "tconstruct:smeltery/casting/filling/splash_bottle" | "minecraft:cherry_pressure_plate" | "railways:crafting/palettes/dyeing_1x/green_locometal_smokebox" | "minecraft:redstone_from_blasting_deepslate_redstone_ore" | "minecraft:netherite_scrap_from_blasting" | "create:cut_scoria_slab_recycling" | "tconstruct:common/glass/brown_clear_stained_glass" | "farmersdelight:cutting/crimson_trapdoor" | "create_copper_and_zinc:mixing_veridium" | "minecraft:book" | "hexcasting:decompose_quenched_shard/shard" | "create:crafting/kinetics/flywheel" | "classicpipes:acacia_pipe" | "farmersdelight:cutting/cooked_salmon" | "biomesoplenty:smooth_black_sandstone_slab" | "tconstruct:smeltery/melting/slime/earth/congealed" | "create:cutting/runtime_generated/compat/minecraft/birch_planks_to_birch_trapdoor" | "tconstruct:smeltery/sand_cast" | "create:cut_scoria_brick_stairs" | "iceandfire:raw_silver_block_to_raw_silver" | "sophisticatedbackpacks:advanced_deposit_upgrade" | "classicpipes:cherry_pipe" | "minecraft:polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "tconstruct:tools/materials/wood/planks/dark_oak" | "railways:crafting/palettes/dyeing_1x/black_slashed_locometal" | "minecraft:red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "hexcasting:slate_bricks" | "create:small_granite_brick_slab_from_stone_types_granite_stonecutting" | "ad_astra:wheel" | "tconstruct:common/copper_platform" | "createaddition:charging/weathered_cut_copper_slab" | "create:cut_limestone_stairs" | "create:crafting/logistics/red_table_cloth_from_other_table_cloth" | "minecraft:redstone_from_smelting_deepslate_redstone_ore" | "create:polished_cut_scoria_from_stone_types_scoria_stonecutting" | "create:splashing/crushed_raw_zinc" | "minecraft:sandstone_slab" | "hexcasting:stonecutting/amethyst_pillar" | "molten_metals:emptying/molten_copper_from_metal_mold" | "ae2:network/cables/dense_covered_cyan" | "railways:crafting/palettes/dyeing_1x/magenta_riveted_locometal" | "minecraft:wild_armor_trim_smithing_template" | "iceandfire:ambrosia" | "ad_astra:stonecutting/chiseled_permafrost_brick_stairs_from_chiseled_permafrost_bricks_stonecutting" | "minecraft:cracked_polished_blackstone_bricks" | "minecraft:deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "farmersdelight:cutting/jungle_sign" | "create:deploying/waxed_oxidized_copper_shingle_slab_from_adding_wax" | "tconstruct:smeltery/casting/scorched/stone_from_scorched" | "railways:crafting/palettes/dyeing_8x/lime_plated_locometal" | "iceandfire:armor_green_helmet" | "minecraft:snout_armor_trim_smithing_template" | "create:cutting/runtime_generated/compat/minecraft/crimson_planks_to_crimson_slab" | "tconstruct:smeltery/entity_melting/sky_slime" | "comforts:hammock_gray" | "computercraft:pocket_computer_upgrade" | "ae2:misc/tiny_tnt" | "extendedae:pattern_modifier" | "railways:crafting/palettes/dyeing_8x/lime_locometal_pillar" | "railways:crafting/palettes/dyeing_8x/purple_slashed_locometal" | "comforts:hammock_to_light_blue" | "computercraft:wired_modem_full_from" | "create:cutting/runtime_generated/compat/minecraft/mangrove_planks_to_mangrove_sign" | "railways:crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal" | "ae2:decorative/quartz_glass" | "minecraft:pink_candle" | "minecraft:red_terracotta" | "agricraft:seed_analyzer" | "createaddition:rolling/copper_plate" | "minecraft:ward_armor_trim_smithing_template_smithing_trim" | "powah:crafting/solar_panel_niotic" | "minecraft:deepslate_tile_stairs" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_planks_to_palm_fence_gate" | "tconstruct:smeltery/casting/metal/copper/block" | "create:crafting/kinetics/encased_chain_drive" | "farmersdelight:mangrove_cabinet" | "tconstruct:tools/materials/casting/iron" | "minecraft:oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "tconstruct:smeltery/casting/quartz/block" | "tconstruct:common/cobalt_platform" | "minecraft:eye_armor_trim_smithing_template_smithing_trim" | "minecraft:polished_diorite_slab" | "railways:stonecutting/palettes/cycling/magenta_locometal_smokebox" | "tconstruct:world/wood/greenheart/trapdoor" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "molten_metals:splashing/tin_ingot_from_ceramic_mold" | "tconstruct:tools/severing/blaze_head" | "tconstruct:smeltery/casting/metal/electrum/ingot_gold_cast" | "create:crafting/copper/waxed_copper_tiles_from_honeycomb" | "tconstruct:smeltery/casting/metal/cobalt/nugget_sand_cast" | "hexcasting:compat/farmersdelight/cutting/edified_log_amethyst" | "hextended:dynamicseal_drawing_orb" | "tconstruct:smeltery/melting/diamond/shovel" | "create:cutting/runtime_generated/compat/minecraft/cherry_planks_to_cherry_door" | "minecraft:netherite_hoe_smithing" | "create:cutting/runtime_generated/compat/minecraft/warped_planks_to_warped_sign" | "railways:crafting/palettes/wrapping/pink_iron_wrapped_locometal" | "create:milling/white_tulip" | "railways:mechanical_crafting/white_brass_wrapped_locometal_boiler" | "tconstruct:smeltery/melting/slime/blood/flesh" | "railways:stonecutting/palettes/cycling/green_flat_slashed_locometal" | "farmersdelight:diamond_knife" | "minecraft:prismarine_stairs_from_prismarine_stonecutting" | "create:cutting/runtime_generated/compat/biomesoplenty/maple_wood_to_stripped_maple_wood" | "minecraft:quartz_stairs_from_quartz_block_stonecutting" | "railways:crafting/palettes/wrapping/red_brass_wrapped_locometal" | "tconstruct:tools/modifiers/slotless/embellishment_manyullyn" | "computercraft:turtle_advanced_upgrade" | "tconstruct:tools/materials/casting/pig_iron" | "minecraft:wayfinder_armor_trim_smithing_template_smithing_trim" | "minecraft:diamond_from_smelting_deepslate_diamond_ore" | "farmersdelight:yellow_hanging_canvas_sign" | "minecraft:birch_pressure_plate" | "create:cutting/runtime_generated/compat/biomesoplenty/stripped_empyreal_wood_to_empyreal_planks" | "tconstruct:smeltery/casting/blaze/rod_gold_cast" | "ad_astra:mars_stone_brick_wall" | "tconstruct:smeltery/melting/metal/iron/block" | "hexal:relay" | "ae2:entropy/cool/stone_cobblestone" | "create:cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "create:crafting/materials/zinc_nugget_from_decompacting" | "tconstruct:tools/modifiers/upgrade/shield_strap" | "tconstruct:smeltery/melting/slime/sky/congealed" | "create:cut_scorchia_from_stone_types_scorchia_stonecutting" | "create:spruce_window" | "create:crafting/copper/waxed_weathered_copper_shingle_stairs_from_honeycomb" | "minecraft:emerald_from_blasting_deepslate_emerald_ore" | "ae2:inscriber/engineering_processor_press" | "minecraft:black_bed" | "tconstruct:smeltery/casting/filling/bucket" | "create:crafting/kinetics/hose_pulley" | "farmersdelight:cooked_bacon" | "railways:crafting/palettes/dyeing_8x/green_locometal_smokebox" | "railways:crafting/palettes/wrapping/lime_copper_wrapped_locometal" | "railways:crafting/palettes/dyeing_1x/blue_flat_slashed_locometal" | "create:cut_ochrum_brick_wall" | "biomesoplenty:mahogany_wood" | "create:crafting/copper/waxed_oxidized_copper_shingle_stairs_from_honeycomb" | "create:cut_andesite_slab_from_stone_types_andesite_stonecutting" | "tconstruct:tools/parts/builder/large_plate" | "minecraft:bowl" | "createaddition:compat/tconstruct/manyullyn" | "tconstruct:smeltery/seared/seared_brick" | "ad_astra:lime_industrial_lamp" | "ad_astra:ostrum_engine" | "minecraft:purple_concrete_powder" | "tconstruct:smeltery/casting/clay/block" | "railways:mechanical_crafting/white_copper_wrapped_locometal_boiler" | "create:cutting/runtime_generated/compat/biomesoplenty/empyreal_planks_to_empyreal_fence" | "ad_astra:light_gray_flag" | "minecraft:spectral_arrow" | "minecraft:red_carpet" | "railways:sequenced_assembly/track_biomesoplenty_willow" | "tconstruct:world/wood/skyroot/sign" | "ad_astra:steel_panel" | "create:cutting/runtime_generated/compat/biomesoplenty/palm_planks_to_palm_pressure_plate" | "hexcasting:pride_colorizer_aroace" | "createaddition:crafting/electrum" | "create:crafting/materials/red_sand_paper" | "create:polished_cut_diorite_from_stone_types_diorite_stonecutting" | "tconstruct:smeltery/seared/seared_bricks_wall" | "railways:stonecutting/palettes/cycling/red_riveted_locometal" | "minecraft:dye_magenta_bed" | "tconstruct:tools/modifiers/slotless/harmonious" | "tconstruct:armor/building/plate_chestplate" | "create:cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "create:crafting/kinetics/light_blue_valve_handle_from_other_valve_handle" | "tcons